%import macros.inc

##############################################################
# Defaults (rawhide)... 

%global enable_profiling 0
%global enable_testsuite 1
%global enable_python 1
# Off by default - <= does not work well with or:
%global enable_python3 0
%global enable_dbusd 0
%global enable_udev 1
%global enable_systemd 1
%global enable_cmirror 1
%global enable_lvmlockd 1
%global enable_lvmetad 1
%global enable_lvmpolld 1
%global enable_dmfilemapd 0
#%global enable_lvmlockd_dlm 0
#%global enable_lvmlockd_sanlock 0

%if %{enable_udev}
%service lvmetad 1
%service lvmpolld 1
%endif

########################################################
# Normally clustering is maintained via resource agents
#
# enable service only if you know what you are doing
#
%if %{enable_cmirror}
#service clvmd 1
#service cmirrord 1
%endif

%global buildreq_cluster corosync-devel >= 1.99.9-1, dlm-devel >= 3.99.1-1
%global req_cluster corosync >= 1.99.9-1, dlm >= 3.99.2-1
%with clvmd corosync

# TODO %global req_dm_persistent device-mapper-persistent-data >= 0.1.4
%with cache internal
%with thin internal
%with thin_check %{_sbindir}/thin_check
%with thin_repair %{_sbindir}/thin_repair
%with thin_dump %{_sbindir}/thin_dump

%global buildreq_udev systemd-devel
%global req_udev udev >= 181-1


%if %{fedora} >= 24 || %{rhel} >= 7
 %service lvmlockd 1
 %global sanlock_version 3.3.0-1
 %global enable_lvmlockd_dlm 1
 %global enable_lvmlockd_sanlock 1
 %if %{rhel}
  %ifarch i686 x86_64 s390x
   %global buildreq_lvmlockd_dlm dlm-devel >= %{dlm_version}
  %else
   %global enable_lvmlockd_dlm 0
  %endif
  %ifarch x86_64 ppc64le ppc64 aarch64
   %global buildreq_lvmlockd_sanlock sanlock-devel >= %{sanlock_version}
  %else
   %global enable_lvmlockd_sanlock 0
  %endif
 %endif
%else
 %if %{fedora} >= 22
  %service lvmlockd 1
  %global enable_lvmlockd_dlm 1
 %endif
%endif

##############################################################

%if %{rhel} == 5
%global enable_python 0
%endif

%if %{rhel} >= 8 || %{fedora} >= 20
%global enable_python3 1
%endif

%if %{enable_python}
  %global buildreq_python2_devel python2-devel
  %global buildreq_python_setuptools python-setuptools
%endif
%if %{enable_python3}
  %global buildreq_python3_devel python3-devel
  %global buildreq_python_setuptools python-setuptools
%endif

##############################################################

%if %{rhel} >= 7 || %{fedora} >= 25
  %global enable_dmfilemapd 1
%endif

##############################################################

%if %{rhel} >= 8 || %{fedora} >= 23
  %if %{enable_python3}
    %global enable_dbusd 1
  %else
    # dbusd requires python3
    false
  %endif
%endif

%if %{enable_dbusd}
  %global buildreq_python3_dbus python3-dbus
  %global buildreq_python3_pyudev python3-pyudev
%endif

##############################################################

%if %{fedora} == 16 || %{rhel} == 6
%global enable_systemd 0

%global buildreq_udev libudev-devel
%global buildreq_cluster openaislib-devel >= 1.1.1-1, clusterlib-devel >= 3.0.6-1, corosynclib-devel >= 1.2.0-1

%global req_udev udev >= 158-1
%global req_cluster openais >= 1.1.1-1, cman >= 3.0.6-1, corosync >= 1.2.0-1

%global _udevbasedir /lib/udev
%global _udevdir %{_udevbasedir}/rules.d
%endif

%if %{fedora} == 16
%with cache none
%with thin none
%with thin_check
%with thin_repair
%with thin_dump
%endif

##############################################################

%if %{fedora} == 17
%global buildreq_udev systemd-devel
%global buildreq_cluster corosync-devel >= 1.99.9-1, dlm-devel >= 3.99.1-1

%global req_udev udev >= 181-1
%global req_dm_persistent device-mapper-persistent-data >= 0.1.4
%global req_cluster corosync >= 1.99.9-1, dlm >= 3.99.2-1
%endif

##############################################################
# same as FC 16 above, only with older udev

%if %{rhel} == 6
%global req_udev udev >= 147-2
%global req_dm_persistent device-mapper-persistent-data >= 0.1.4
%endif

##############################################################

# Do not reset Release to 1 unless both lvm2 and device-mapper
# versions are increased together.

%global device_mapper_version 1.02.97

Summary: Userland logical volume management tools
Name: lvm2
Version: 2.02.120
Release: 1%{?dist}
License: GPLv2
Group: System Environment/Base
URL: http://sources.redhat.com/lvm2
Source0: ftp://sources.redhat.com/pub/lvm2/LVM2.%{version}.tgz
Source91: source.inc
Source92: build.inc
Source93: packages.inc
Source94: macros.inc

BuildRequires: libselinux-devel >= 1.30.19-4, libsepol-devel
BuildRequires: ncurses-devel
BuildRequires: readline-devel
BuildRequires: module-init-tools
BuildRequires: pkgconfig

# Expands to nothing unless at least 2 arguments are given
%define maybe() \
%if %(test -n "%{?2}" && echo 1 || echo 0) \
%* \
%endif
%define ifwith() \
%if %(if echo %{with_flags} | grep -q %1; then echo 1; else echo 0; fi)

%maybe BuildRequires: %{?buildreq_udev}
%maybe BuildRequires: %{?buildreq_cluster}
%maybe BuildRequires: %{?buildreq_lvmlockd_dlm}
%maybe BuildRequires: %{?buildreq_lvmlockd_sanlock}
%maybe BuildRequires: %{?buildreq_python2_devel}
%maybe BuildRequires: %{?buildreq_python3_devel}
%maybe BuildRequires: %{?buildreq_python_setuptools}

%description
LVM2 includes all of the support for handling read/write operations on
physical volumes (hard disks, RAID-Systems, magneto optical, etc.,
multiple devices (MD), see mdadd(8) or even loop devices, see
losetup(8)), creating volume groups (kind of virtual disks) from one
or more physical volumes and creating one or more logical volumes
(kind of logical partitions) in volume groups.
