/*
** ###################################################################
**
**     Copyright (c) 2016 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
** ###################################################################
*/

#ifndef __DDR_PHY_MEM_MAP_H__
#define __DDR_PHY_MEM_MAP_H__

//JDG change base addr for DDR_PHY
//#define DDR_PHY_BASE_ADDR(X) 0x5c000000 + ((X & 1) * 0x20000) + ((X & 2) * 0x30000) + 0x10000
#define DDR_PHY_BASE_ADDR(X) 0x5c000000 + ((X * 0x100000) + 0x10000)

// Following defines registers offset of the Synopsys DesignWare Cores LPDDR4 multiPHY Utility Block (PUB)
#define DDR_PHY_RIDR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x000)
#define DDR_PHY_RIDR_0          0x5c010000
#define DDR_PHY_RIDR_1          0x5c110000
#define DDR_PHY_PIR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x001)
#define DDR_PHY_PIR_0           0x5c010004
#define DDR_PHY_PIR_1           0x5c110004
#define DDR_PHY_PGCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x004)
#define DDR_PHY_PGCR0_0         0x5c010010
#define DDR_PHY_PGCR0_1         0x5c110010
#define DDR_PHY_PGCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x005)
#define DDR_PHY_PGCR1_0         0x5c010014
#define DDR_PHY_PGCR1_1         0x5c110014
#define DDR_PHY_PGCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x006)
#define DDR_PHY_PGCR2_0         0x5c010018
#define DDR_PHY_PGCR2_1         0x5c110018
#define DDR_PHY_PGCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x007)
#define DDR_PHY_PGCR3_0         0x5c01001c
#define DDR_PHY_PGCR3_1         0x5c11001c
#define DDR_PHY_PGCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x008)
#define DDR_PHY_PGCR4_0         0x5c010020
#define DDR_PHY_PGCR4_1         0x5c110020
#define DDR_PHY_PGCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x009)
#define DDR_PHY_PGCR5_0         0x5c010024
#define DDR_PHY_PGCR5_1         0x5c110024
#define DDR_PHY_PGCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x00A)
#define DDR_PHY_PGCR6_0         0x5c010028
#define DDR_PHY_PGCR6_1         0x5c110028
#define DDR_PHY_PGCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x00B)
#define DDR_PHY_PGCR7_0         0x5c01002c
#define DDR_PHY_PGCR7_1         0x5c11002c
#define DDR_PHY_PGSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x00C)
#define DDR_PHY_PGSR0_0         0x5c010030
#define DDR_PHY_PGSR0_1         0x5c110030
#define DDR_PHY_PGSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x00D)
#define DDR_PHY_PGSR1_0         0x5c010034
#define DDR_PHY_PGSR1_1         0x5c110034
#define DDR_PHY_PGSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x00E)
#define DDR_PHY_PGSR2_0         0x5c010038
#define DDR_PHY_PGSR2_1         0x5c110038
#define DDR_PHY_PTR0(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x010)
#define DDR_PHY_PTR0_0          0x5c010040
#define DDR_PHY_PTR0_1          0x5c110040
#define DDR_PHY_PTR1(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x011)
#define DDR_PHY_PTR1_0          0x5c010044
#define DDR_PHY_PTR1_1          0x5c110044
#define DDR_PHY_PTR2(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x012)
#define DDR_PHY_PTR2_0          0x5c010048
#define DDR_PHY_PTR2_1          0x5c110048
#define DDR_PHY_PTR3(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x013)
#define DDR_PHY_PTR3_0          0x5c01004c
#define DDR_PHY_PTR3_1          0x5c11004c
#define DDR_PHY_PTR4(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x014)
#define DDR_PHY_PTR4_0          0x5c010050
#define DDR_PHY_PTR4_1          0x5c110050
#define DDR_PHY_PTR5(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x015)
#define DDR_PHY_PTR5_0          0x5c010054
#define DDR_PHY_PTR5_1          0x5c110054
#define DDR_PHY_PTR6(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x016)
#define DDR_PHY_PTR6_0          0x5c010058
#define DDR_PHY_PTR6_1          0x5c110058
#define DDR_PHY_PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01A)
#define DDR_PHY_PLLCR0_0        0x5c010068
#define DDR_PHY_PLLCR0_1        0x5c110068
#define DDR_PHY_PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01B)
#define DDR_PHY_PLLCR1_0        0x5c01006c
#define DDR_PHY_PLLCR1_1        0x5c11006c
#define DDR_PHY_PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01C)
#define DDR_PHY_PLLCR2_0        0x5c010070
#define DDR_PHY_PLLCR2_1        0x5c110070
#define DDR_PHY_PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01D)
#define DDR_PHY_PLLCR3_0        0x5c010074
#define DDR_PHY_PLLCR3_1        0x5c110074
#define DDR_PHY_PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01E)
#define DDR_PHY_PLLCR4_0        0x5c010078
#define DDR_PHY_PLLCR4_1        0x5c110078
#define DDR_PHY_PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x01F)
#define DDR_PHY_PLLCR5_0        0x5c01007c
#define DDR_PHY_PLLCR5_1        0x5c11007c
#define DDR_PHY_DXCCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x022)
#define DDR_PHY_DXCCR_0         0x5c010088
#define DDR_PHY_DXCCR_1         0x5c110088
#define DDR_PHY_DSGCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x024)
#define DDR_PHY_DSGCR_0         0x5c010090
#define DDR_PHY_DSGCR_1         0x5c110090
#define DDR_PHY_ODTCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x026)
#define DDR_PHY_ODTCR_0         0x5c010098
#define DDR_PHY_ODTCR_1         0x5c110098
#define DDR_PHY_AACR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x028)
#define DDR_PHY_AACR_0          0x5c0100a0
#define DDR_PHY_AACR_1          0x5c1100a0
#define DDR_PHY_GPR0(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x030)
#define DDR_PHY_GPR0_0          0x5c0100c0
#define DDR_PHY_GPR0_1          0x5c1100c0
#define DDR_PHY_GPR1(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x031)
#define DDR_PHY_GPR1_0          0x5c0100c4
#define DDR_PHY_GPR1_1          0x5c1100c4
#define DDR_PHY_DCR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x040)
#define DDR_PHY_DCR_0           0x5c010100
#define DDR_PHY_DCR_1           0x5c110100
#define DDR_PHY_DTPR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x044)
#define DDR_PHY_DTPR0_0         0x5c010110
#define DDR_PHY_DTPR0_1         0x5c110110
#define DDR_PHY_DTPR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x045)
#define DDR_PHY_DTPR1_0         0x5c010114
#define DDR_PHY_DTPR1_1         0x5c110114
#define DDR_PHY_DTPR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x046)
#define DDR_PHY_DTPR2_0         0x5c010118
#define DDR_PHY_DTPR2_1         0x5c110118
#define DDR_PHY_DTPR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x047)
#define DDR_PHY_DTPR3_0         0x5c01011c
#define DDR_PHY_DTPR3_1         0x5c11011c
#define DDR_PHY_DTPR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x048)
#define DDR_PHY_DTPR4_0         0x5c010120
#define DDR_PHY_DTPR4_1         0x5c110120
#define DDR_PHY_DTPR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x049)
#define DDR_PHY_DTPR5_0         0x5c010124
#define DDR_PHY_DTPR5_1         0x5c110124
#define DDR_PHY_RDIMMGCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x050)
#define DDR_PHY_RDIMMGCR0_0     0x5c010140
#define DDR_PHY_RDIMMGCR0_1     0x5c110140
#define DDR_PHY_RDIMMGCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x051)
#define DDR_PHY_RDIMMGCR1_0     0x5c010144
#define DDR_PHY_RDIMMGCR1_1     0x5c110144
#define DDR_PHY_RDIMMGCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x052)
#define DDR_PHY_RDIMMGCR2_0     0x5c010148
#define DDR_PHY_RDIMMGCR2_1     0x5c110148
#define DDR_PHY_RDIMMCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x054)
#define DDR_PHY_RDIMMCR0_0      0x5c010150
#define DDR_PHY_RDIMMCR0_1      0x5c110150
#define DDR_PHY_RDIMMCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x055)
#define DDR_PHY_RDIMMCR1_0      0x5c010154
#define DDR_PHY_RDIMMCR1_1      0x5c110154
#define DDR_PHY_RDIMMCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x056)
#define DDR_PHY_RDIMMCR2_0      0x5c010158
#define DDR_PHY_RDIMMCR2_1      0x5c110158
#define DDR_PHY_RDIMMCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x057)
#define DDR_PHY_RDIMMCR3_0      0x5c01015c
#define DDR_PHY_RDIMMCR3_1      0x5c11015c
#define DDR_PHY_RDIMMCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x058)
#define DDR_PHY_RDIMMCR4_0      0x5c010160
#define DDR_PHY_RDIMMCR4_1      0x5c110160
#define DDR_PHY_SCHCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x05A)
#define DDR_PHY_SCHCR0_0        0x5c010168
#define DDR_PHY_SCHCR0_1        0x5c110168
#define DDR_PHY_SCHCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x05B)
#define DDR_PHY_SCHCR1_0        0x5c01016c
#define DDR_PHY_SCHCR1_1        0x5c11016c
#define DDR_PHY_MR0(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x060)
#define DDR_PHY_MR0_0           0x5c010180
#define DDR_PHY_MR0_1           0x5c110180
#define DDR_PHY_MR1(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x061)
#define DDR_PHY_MR1_0           0x5c010184
#define DDR_PHY_MR1_1           0x5c110184
#define DDR_PHY_MR2(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x062)
#define DDR_PHY_MR2_0           0x5c010188
#define DDR_PHY_MR2_1           0x5c110188
#define DDR_PHY_MR3(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x063)
#define DDR_PHY_MR3_0           0x5c01018c
#define DDR_PHY_MR3_1           0x5c11018c
#define DDR_PHY_MR4(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x064)
#define DDR_PHY_MR4_0           0x5c010190
#define DDR_PHY_MR4_1           0x5c110190
#define DDR_PHY_MR5(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x065)
#define DDR_PHY_MR5_0           0x5c010194
#define DDR_PHY_MR5_1           0x5c110194
#define DDR_PHY_MR6(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x066)
#define DDR_PHY_MR6_0           0x5c010198
#define DDR_PHY_MR6_1           0x5c110198
#define DDR_PHY_MR7(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x067)
#define DDR_PHY_MR7_0           0x5c01019c
#define DDR_PHY_MR7_1           0x5c11019c
#define DDR_PHY_MR11(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x06B)
#define DDR_PHY_MR11_0          0x5c0101ac
#define DDR_PHY_MR11_1          0x5c1101ac
#define DDR_PHY_MR12(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x06C)
#define DDR_PHY_MR12_0          0x5c0101b0
#define DDR_PHY_MR12_1          0x5c1101b0
#define DDR_PHY_MR13(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x06D)
#define DDR_PHY_MR13_0          0x5c0101b4
#define DDR_PHY_MR13_1          0x5c1101b4
#define DDR_PHY_MR14(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x06E)
#define DDR_PHY_MR14_0          0x5c0101b8
#define DDR_PHY_MR14_1          0x5c1101b8
#define DDR_PHY_MR22(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x076)
#define DDR_PHY_MR22_0          0x5c0101d8
#define DDR_PHY_MR22_1          0x5c1101d8
#define DDR_PHY_DTCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x080)
#define DDR_PHY_DTCR0_0         0x5c010200
#define DDR_PHY_DTCR0_1         0x5c110200
#define DDR_PHY_DTCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x081)
#define DDR_PHY_DTCR1_0         0x5c010204
#define DDR_PHY_DTCR1_1         0x5c110204
#define DDR_PHY_DTAR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x082)
#define DDR_PHY_DTAR0_0         0x5c010208
#define DDR_PHY_DTAR0_1         0x5c110208
#define DDR_PHY_DTAR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x083)
#define DDR_PHY_DTAR1_0         0x5c01020c
#define DDR_PHY_DTAR1_1         0x5c11020c
#define DDR_PHY_DTAR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x084)
#define DDR_PHY_DTAR2_0         0x5c010210
#define DDR_PHY_DTAR2_1         0x5c110210
#define DDR_PHY_DTDR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x086)
#define DDR_PHY_DTDR0_0         0x5c010218
#define DDR_PHY_DTDR0_1         0x5c110218
#define DDR_PHY_DTDR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x087)
#define DDR_PHY_DTDR1_0         0x5c01021c
#define DDR_PHY_DTDR1_1         0x5c11021c
#define DDR_PHY_DTEDR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x08C)
#define DDR_PHY_DTEDR0_0        0x5c010230
#define DDR_PHY_DTEDR0_1        0x5c110230
#define DDR_PHY_DTEDR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x08C)
#define DDR_PHY_DTEDR1_0        0x5c010230
#define DDR_PHY_DTEDR1_1        0x5c110230
#define DDR_PHY_DTEDR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x08C)
#define DDR_PHY_DTEDR2_0        0x5c010230
#define DDR_PHY_DTEDR2_1        0x5c110230
#define DDR_PHY_VTDR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x08F)
#define DDR_PHY_VTDR_0          0x5c01023c
#define DDR_PHY_VTDR_1          0x5c11023c
#define DDR_PHY_CATR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x090)
#define DDR_PHY_CATR0_0         0x5c010240
#define DDR_PHY_CATR0_1         0x5c110240
#define DDR_PHY_CATR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x091)
#define DDR_PHY_CATR1_0         0x5c010244
#define DDR_PHY_CATR1_1         0x5c110244
#define DDR_PHY_PGCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x092)
#define DDR_PHY_PGCR8_0			0x5c010248
#define DDR_PHY_PGCR8_1			0x5c110248
#define DDR_PHY_DQSDR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x094)
#define DDR_PHY_DQSDR0_0        0x5c010250
#define DDR_PHY_DQSDR0_1        0x5c110250
#define DDR_PHY_DQSDR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x095)
#define DDR_PHY_DQSDR1_0        0x5c010254
#define DDR_PHY_DQSDR1_1        0x5c110254
#define DDR_PHY_DQSDR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x096)
#define DDR_PHY_DQSDR2_0        0x5c010258
#define DDR_PHY_DQSDR2_1        0x5c110258
#define DDR_PHY_DCUAR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C0)
#define DDR_PHY_DCUAR_0         0x5c010300
#define DDR_PHY_DCUAR_1         0x5c110300
#define DDR_PHY_DCUDR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C1)
#define DDR_PHY_DCUDR_0         0x5c010304
#define DDR_PHY_DCUDR_1         0x5c110304
#define DDR_PHY_DCURR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C2)
#define DDR_PHY_DCURR_0         0x5c010308
#define DDR_PHY_DCURR_1         0x5c110308
#define DDR_PHY_DCULR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C3)
#define DDR_PHY_DCULR_0         0x5c01030c
#define DDR_PHY_DCULR_1         0x5c11030c
#define DDR_PHY_DCUGCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C4)
#define DDR_PHY_DCUGCR_0        0x5c010310
#define DDR_PHY_DCUGCR_1        0x5c110310
#define DDR_PHY_DCUTPR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C5)
#define DDR_PHY_DCUTPR_0        0x5c010314
#define DDR_PHY_DCUTPR_1        0x5c110314
#define DDR_PHY_DCUSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C6)
#define DDR_PHY_DCUSR0_0        0x5c010318
#define DDR_PHY_DCUSR0_1        0x5c110318
#define DDR_PHY_DCUSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x0C7)
#define DDR_PHY_DCUSR1_0        0x5c01031c
#define DDR_PHY_DCUSR1_1        0x5c11031c
#define DDR_PHY_BISTRR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x100)
#define DDR_PHY_BISTRR_0        0x5c010400
#define DDR_PHY_BISTRR_1        0x5c110400
#define DDR_PHY_BISTWCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x101)
#define DDR_PHY_BISTWCR_0       0x5c010404
#define DDR_PHY_BISTWCR_1       0x5c110404
#define DDR_PHY_BISTMSKR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x102)
#define DDR_PHY_BISTMSKR0_0     0x5c010408
#define DDR_PHY_BISTMSKR0_1     0x5c110408
#define DDR_PHY_BISTMSKR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x103)
#define DDR_PHY_BISTMSKR1_0     0x5c01040c
#define DDR_PHY_BISTMSKR1_1     0x5c11040c
#define DDR_PHY_BISTMSKR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x104)
#define DDR_PHY_BISTMSKR2_0     0x5c010410
#define DDR_PHY_BISTMSKR2_1     0x5c110410
#define DDR_PHY_BISTLSR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x105)
#define DDR_PHY_BISTLSR_0       0x5c010414
#define DDR_PHY_BISTLSR_1       0x5c110414
#define DDR_PHY_BISTAR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x106)
#define DDR_PHY_BISTAR0_0       0x5c010418
#define DDR_PHY_BISTAR0_1       0x5c110418
#define DDR_PHY_BISTAR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x107)
#define DDR_PHY_BISTAR1_0       0x5c01041c
#define DDR_PHY_BISTAR1_1       0x5c11041c
#define DDR_PHY_BISTAR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x108)
#define DDR_PHY_BISTAR2_0       0x5c010420
#define DDR_PHY_BISTAR2_1       0x5c110420
#define DDR_PHY_BISTAR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x109)
#define DDR_PHY_BISTAR3_0       0x5c010424
#define DDR_PHY_BISTAR3_1       0x5c110424
#define DDR_PHY_BISTAR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10A)
#define DDR_PHY_BISTAR4_0       0x5c010428
#define DDR_PHY_BISTAR4_1       0x5c110428
#define DDR_PHY_BISTUDPR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10B)
#define DDR_PHY_BISTUDPR_0      0x5c01042c
#define DDR_PHY_BISTUDPR_1      0x5c11042c
#define DDR_PHY_BISTGSR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10C)
#define DDR_PHY_BISTGSR_0       0x5c010430
#define DDR_PHY_BISTGSR_1       0x5c110430
#define DDR_PHY_BISTWER0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10D)
#define DDR_PHY_BISTWER0_0      0x5c010434
#define DDR_PHY_BISTWER0_1      0x5c110434
#define DDR_PHY_BISTWER1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10E)
#define DDR_PHY_BISTWER1_0      0x5c010438
#define DDR_PHY_BISTWER1_1      0x5c110438
#define DDR_PHY_BISTBER0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x10F)
#define DDR_PHY_BISTBER0_0      0x5c01043c
#define DDR_PHY_BISTBER0_1      0x5c11043c
#define DDR_PHY_BISTBER1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x110)
#define DDR_PHY_BISTBER1_0      0x5c010440
#define DDR_PHY_BISTBER1_1      0x5c110440
#define DDR_PHY_BISTBER2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x111)
#define DDR_PHY_BISTBER2_0      0x5c010444
#define DDR_PHY_BISTBER2_1      0x5c110444
#define DDR_PHY_BISTBER3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x112)
#define DDR_PHY_BISTBER3_0      0x5c010448
#define DDR_PHY_BISTBER3_1      0x5c110448
#define DDR_PHY_BISTBER4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x113)
#define DDR_PHY_BISTBER4_0      0x5c01044c
#define DDR_PHY_BISTBER4_1      0x5c11044c
#define DDR_PHY_BISTWCSR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x114)
#define DDR_PHY_BISTWCSR_0      0x5c010450
#define DDR_PHY_BISTWCSR_1      0x5c110450
#define DDR_PHY_BISTFWR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x115)
#define DDR_PHY_BISTFWR0_0      0x5c010454
#define DDR_PHY_BISTFWR0_1      0x5c110454
#define DDR_PHY_BISTFWR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x116)
#define DDR_PHY_BISTFWR1_0      0x5c010458
#define DDR_PHY_BISTFWR1_1      0x5c110458
#define DDR_PHY_BISTFWR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x117)
#define DDR_PHY_BISTFWR2_0      0x5c01045c
#define DDR_PHY_BISTFWR2_1      0x5c11045c
#define DDR_PHY_BISTBER5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x118)
#define DDR_PHY_BISTBER5_0      0x5c010460
#define DDR_PHY_BISTBER5_1      0x5c110460
#define DDR_PHY_RANKIDR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x137)
#define DDR_PHY_RANKIDR_0       0x5c0104dc
#define DDR_PHY_RANKIDR_1       0x5c1104dc
#define DDR_PHY_RIOCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x138)
#define DDR_PHY_RIOCR0_0        0x5c0104e0
#define DDR_PHY_RIOCR0_1        0x5c1104e0
#define DDR_PHY_RIOCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x139)
#define DDR_PHY_RIOCR1_0        0x5c0104e4
#define DDR_PHY_RIOCR1_1        0x5c1104e4
#define DDR_PHY_RIOCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x13A)
#define DDR_PHY_RIOCR2_0        0x5c0104e8
#define DDR_PHY_RIOCR2_1        0x5c1104e8
#define DDR_PHY_RIOCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x13B)
#define DDR_PHY_RIOCR3_0        0x5c0104ec
#define DDR_PHY_RIOCR3_1        0x5c1104ec
#define DDR_PHY_RIOCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x13C)
#define DDR_PHY_RIOCR4_0        0x5c0104f0
#define DDR_PHY_RIOCR4_1        0x5c1104f0
#define DDR_PHY_RIOCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x13D)
#define DDR_PHY_RIOCR5_0        0x5c0104f4
#define DDR_PHY_RIOCR5_1        0x5c1104f4
#define DDR_PHY_ACIOCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x140)
#define DDR_PHY_ACIOCR0_0       0x5c010500
#define DDR_PHY_ACIOCR0_1       0x5c110500
#define DDR_PHY_ACIOCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x141)
#define DDR_PHY_ACIOCR1_0       0x5c010504
#define DDR_PHY_ACIOCR1_1       0x5c110504
#define DDR_PHY_ACIOCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x142)
#define DDR_PHY_ACIOCR2_0       0x5c010508
#define DDR_PHY_ACIOCR2_1       0x5c110508
#define DDR_PHY_ACIOCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x143)
#define DDR_PHY_ACIOCR3_0       0x5c01050c
#define DDR_PHY_ACIOCR3_1       0x5c11050c
#define DDR_PHY_ACIOCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x144)
#define DDR_PHY_ACIOCR4_0       0x5c010510
#define DDR_PHY_ACIOCR4_1       0x5c110510
#define DDR_PHY_ACIOCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x145)
#define DDR_PHY_ACIOCR5_0       0x5c010514
#define DDR_PHY_ACIOCR5_1       0x5c110514
#define DDR_PHY_IOVCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x148)
#define DDR_PHY_IOVCR0_0        0x5c010520
#define DDR_PHY_IOVCR0_1        0x5c110520
#define DDR_PHY_IOVCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x149)
#define DDR_PHY_IOVCR1_0        0x5c010524
#define DDR_PHY_IOVCR1_1        0x5c110524
#define DDR_PHY_VTCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x14A)
#define DDR_PHY_VTCR0_0         0x5c010528
#define DDR_PHY_VTCR0_1         0x5c110528
#define DDR_PHY_VTCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x14B)
#define DDR_PHY_VTCR1_0         0x5c01052c
#define DDR_PHY_VTCR1_1         0x5c11052c
#define DDR_PHY_ACBDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x150)
#define DDR_PHY_ACBDLR0_0       0x5c010540
#define DDR_PHY_ACBDLR0_1       0x5c110540
#define DDR_PHY_ACBDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x151)
#define DDR_PHY_ACBDLR1_0       0x5c010544
#define DDR_PHY_ACBDLR1_1       0x5c110544
#define DDR_PHY_ACBDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x152)
#define DDR_PHY_ACBDLR2_0       0x5c010548
#define DDR_PHY_ACBDLR2_1       0x5c110548
#define DDR_PHY_ACBDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x153)
#define DDR_PHY_ACBDLR3_0       0x5c01054c
#define DDR_PHY_ACBDLR3_1       0x5c11054c
#define DDR_PHY_ACBDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x154)
#define DDR_PHY_ACBDLR4_0       0x5c010550
#define DDR_PHY_ACBDLR4_1       0x5c110550
#define DDR_PHY_ACBDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x155)
#define DDR_PHY_ACBDLR5_0       0x5c010554
#define DDR_PHY_ACBDLR5_1       0x5c110554
#define DDR_PHY_ACBDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x156)
#define DDR_PHY_ACBDLR6_0       0x5c010558
#define DDR_PHY_ACBDLR6_1       0x5c110558
#define DDR_PHY_ACBDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x157)
#define DDR_PHY_ACBDLR7_0       0x5c01055c
#define DDR_PHY_ACBDLR7_1       0x5c11055c
#define DDR_PHY_ACBDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x158)
#define DDR_PHY_ACBDLR8_0       0x5c010560
#define DDR_PHY_ACBDLR8_1       0x5c110560
#define DDR_PHY_ACBDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x159)
#define DDR_PHY_ACBDLR9_0       0x5c010564
#define DDR_PHY_ACBDLR9_1       0x5c110564
#define DDR_PHY_ACBDLR10(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15A)
#define DDR_PHY_ACBDLR10_0      0x5c010568
#define DDR_PHY_ACBDLR10_1      0x5c110568
#define DDR_PHY_ACBDLR11(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15B)
#define DDR_PHY_ACBDLR11_0      0x5c01056c
#define DDR_PHY_ACBDLR11_1      0x5c11056c
#define DDR_PHY_ACBDLR12(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15C)
#define DDR_PHY_ACBDLR12_0      0x5c010570
#define DDR_PHY_ACBDLR12_1      0x5c110570
#define DDR_PHY_ACBDLR13(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15D)
#define DDR_PHY_ACBDLR13_0      0x5c010574
#define DDR_PHY_ACBDLR13_1      0x5c110574
#define DDR_PHY_ACBDLR14(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15E)
#define DDR_PHY_ACBDLR14_0      0x5c010578
#define DDR_PHY_ACBDLR14_1      0x5c110578
#define DDR_PHY_ACBDLR15(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x15F)
#define DDR_PHY_ACBDLR15_0      0x5c01057c
#define DDR_PHY_ACBDLR15_1      0x5c11057c
#define DDR_PHY_ACBDLR16(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x160)
#define DDR_PHY_ACBDLR16_0      0x5c010580
#define DDR_PHY_ACBDLR16_1      0x5c110580
#define DDR_PHY_ACLCDLR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x161)
#define DDR_PHY_ACLCDLR_0       0x5c010584
#define DDR_PHY_ACLCDLR_1       0x5c110584
#define DDR_PHY_ACMDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x168)
#define DDR_PHY_ACMDLR0_0       0x5c0105a0
#define DDR_PHY_ACMDLR0_1       0x5c1105a0
#define DDR_PHY_ACMDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x169)
#define DDR_PHY_ACMDLR1_0       0x5c0105a4
#define DDR_PHY_ACMDLR1_1       0x5c1105a4
#define DDR_PHY_ZQCR(X)			REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A0)
#define DDR_PHY_ZQCR_0          0x5c010680
#define DDR_PHY_ZQCR_1          0x5c110680
#define DDR_PHY_ZQ0PR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A1)
#define DDR_PHY_ZQ0PR0_0        0x5c010684
#define DDR_PHY_ZQ0PR0_1        0x5c110684
#define DDR_PHY_ZQ0PR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A2)
#define DDR_PHY_ZQ0PR1_0        0x5c010688
#define DDR_PHY_ZQ0PR1_1        0x5c110688
#define DDR_PHY_ZQ0DR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A3)
#define DDR_PHY_ZQ0DR0_0        0x5c01068c
#define DDR_PHY_ZQ0DR0_1        0x5c11068c
#define DDR_PHY_ZQ0DR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A4)
#define DDR_PHY_ZQ0DR1_0        0x5c010690
#define DDR_PHY_ZQ0DR1_1        0x5c110690
#define DDR_PHY_ZQ0OR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A5)
#define DDR_PHY_ZQ0OR0_0        0x5c010694
#define DDR_PHY_ZQ0OR0_1        0x5c110694
#define DDR_PHY_ZQ0OR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A6)
#define DDR_PHY_ZQ0OR1_0        0x5c010698
#define DDR_PHY_ZQ0OR1_1        0x5c110698
#define DDR_PHY_ZQ0SR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A7)
#define DDR_PHY_ZQ0SR_0         0x5c01069c
#define DDR_PHY_ZQ0SR_1         0x5c11069c
#define DDR_PHY_ZQ1PR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1A9)
#define DDR_PHY_ZQ1PR0_0        0x5c0106a4
#define DDR_PHY_ZQ1PR0_1        0x5c1106a4
#define DDR_PHY_ZQ1PR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AA)
#define DDR_PHY_ZQ1PR1_0        0x5c0106a8
#define DDR_PHY_ZQ1PR1_1        0x5c1106a8
#define DDR_PHY_ZQ1DR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AB)
#define DDR_PHY_ZQ1DR0_0        0x5c0106ac
#define DDR_PHY_ZQ1DR0_1        0x5c1106ac
#define DDR_PHY_ZQ1DR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AC)
#define DDR_PHY_ZQ1DR1_0        0x5c0106b0
#define DDR_PHY_ZQ1DR1_1        0x5c1106b0
#define DDR_PHY_ZQ1OR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AD)
#define DDR_PHY_ZQ1OR0_0        0x5c0106b4
#define DDR_PHY_ZQ1OR0_1        0x5c1106b4
#define DDR_PHY_ZQ1OR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AE)
#define DDR_PHY_ZQ1OR1_0        0x5c0106b8
#define DDR_PHY_ZQ1OR1_1        0x5c1106b8
#define DDR_PHY_ZQ1SR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1AF)
#define DDR_PHY_ZQ1SR_0         0x5c0106bc
#define DDR_PHY_ZQ1SR_1         0x5c1106bc
#define DDR_PHY_ZQ2PR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B1)
#define DDR_PHY_ZQ2PR0_0        0x5c0106c4
#define DDR_PHY_ZQ2PR0_1        0x5c1106c4
#define DDR_PHY_ZQ2PR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B2)
#define DDR_PHY_ZQ2PR1_0        0x5c0106c8
#define DDR_PHY_ZQ2PR1_1        0x5c1106c8
#define DDR_PHY_ZQ2DR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B3)
#define DDR_PHY_ZQ2DR0_0        0x5c0106cc
#define DDR_PHY_ZQ2DR0_1        0x5c1106cc
#define DDR_PHY_ZQ2DR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B4)
#define DDR_PHY_ZQ2DR1_0        0x5c0106d0
#define DDR_PHY_ZQ2DR1_1        0x5c1106d0
#define DDR_PHY_ZQ2OR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B5)
#define DDR_PHY_ZQ2OR0_0        0x5c0106d4
#define DDR_PHY_ZQ2OR0_1        0x5c1106d4
#define DDR_PHY_ZQ2OR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B6)
#define DDR_PHY_ZQ2OR1_0        0x5c0106d8
#define DDR_PHY_ZQ2OR1_1        0x5c1106d8
#define DDR_PHY_ZQ2SR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B7)
#define DDR_PHY_ZQ2SR_0         0x5c0106dc
#define DDR_PHY_ZQ2SR_1         0x5c1106dc
#define DDR_PHY_ZQ3PR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1B9)
#define DDR_PHY_ZQ3PR0_0        0x5c0106e4
#define DDR_PHY_ZQ3PR0_1        0x5c1106e4
#define DDR_PHY_ZQ3PR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BA)
#define DDR_PHY_ZQ3PR1_0        0x5c0106e8
#define DDR_PHY_ZQ3PR1_1        0x5c1106e8
#define DDR_PHY_ZQ3DR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BB)
#define DDR_PHY_ZQ3DR0_0        0x5c0106ec
#define DDR_PHY_ZQ3DR0_1        0x5c1106ec
#define DDR_PHY_ZQ3DR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BC)
#define DDR_PHY_ZQ3DR1_0        0x5c0106f0
#define DDR_PHY_ZQ3DR1_1        0x5c1106f0
#define DDR_PHY_ZQ3OR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BD)
#define DDR_PHY_ZQ3OR0_0        0x5c0106f4
#define DDR_PHY_ZQ3OR0_1        0x5c1106f4
#define DDR_PHY_ZQ3OR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BE)
#define DDR_PHY_ZQ3OR1_0        0x5c0106f8
#define DDR_PHY_ZQ3OR1_1        0x5c1106f8
#define DDR_PHY_ZQ3SR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1BF)
#define DDR_PHY_ZQ3SR_0         0x5c0106fc
#define DDR_PHY_ZQ3SR_1         0x5c1106fc
#define DDR_PHY_DX0GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C0)
#define DDR_PHY_DX0GCR0_0       0x5c010700
#define DDR_PHY_DX0GCR0_1       0x5c110700
#define DDR_PHY_DX0GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C1)
#define DDR_PHY_DX0GCR1_0       0x5c010704
#define DDR_PHY_DX0GCR1_1       0x5c110704
#define DDR_PHY_DX0GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C2)
#define DDR_PHY_DX0GCR2_0       0x5c010708
#define DDR_PHY_DX0GCR2_1       0x5c110708
#define DDR_PHY_DX0GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C3)
#define DDR_PHY_DX0GCR3_0       0x5c01070c
#define DDR_PHY_DX0GCR3_1       0x5c11070c
#define DDR_PHY_DX0GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C4)
#define DDR_PHY_DX0GCR4_0       0x5c010710
#define DDR_PHY_DX0GCR4_1       0x5c110710
#define DDR_PHY_DX0GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C5)
#define DDR_PHY_DX0GCR5_0       0x5c010714
#define DDR_PHY_DX0GCR5_1       0x5c110714
#define DDR_PHY_DX0GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C6)
#define DDR_PHY_DX0GCR6_0       0x5c010718
#define DDR_PHY_DX0GCR6_1       0x5c110718
#define DDR_PHY_DX0GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C7)
#define DDR_PHY_DX0GCR7_0       0x5c01071c
#define DDR_PHY_DX0GCR7_1       0x5c11071c
#define DDR_PHY_DX0GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C8)
#define DDR_PHY_DX0GCR8_0       0x5c010720
#define DDR_PHY_DX0GCR8_1       0x5c110720
#define DDR_PHY_DX0GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1C9)
#define DDR_PHY_DX0GCR9_0       0x5c010724
#define DDR_PHY_DX0GCR9_1       0x5c110724
#define DDR_PHY_DX0DQMAP0(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1CA)
#define DDR_PHY_DX0DQMAP0_0		0x5c010728
#define DDR_PHY_DX0DQMAP0_1		0x5c110728
#define DDR_PHY_DX0DQMAP1(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1CB)
#define DDR_PHY_DX0DQMAP1_0		0x5c01072c
#define DDR_PHY_DX0DQMAP1_1		0x5c11072c
#define DDR_PHY_DX0BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D0)
#define DDR_PHY_DX0BDLR0_0      0x5c010740
#define DDR_PHY_DX0BDLR0_1      0x5c110740
#define DDR_PHY_DX0BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D1)
#define DDR_PHY_DX0BDLR1_0      0x5c010744
#define DDR_PHY_DX0BDLR1_1      0x5c110744
#define DDR_PHY_DX0BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D2)
#define DDR_PHY_DX0BDLR2_0      0x5c010748
#define DDR_PHY_DX0BDLR2_1      0x5c110748
#define DDR_PHY_DX0BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D4)
#define DDR_PHY_DX0BDLR3_0      0x5c010750
#define DDR_PHY_DX0BDLR3_1      0x5c110750
#define DDR_PHY_DX0BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D5)
#define DDR_PHY_DX0BDLR4_0      0x5c010754
#define DDR_PHY_DX0BDLR4_1      0x5c110754
#define DDR_PHY_DX0BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D6)
#define DDR_PHY_DX0BDLR5_0      0x5c010758
#define DDR_PHY_DX0BDLR5_1      0x5c110758
#define DDR_PHY_DX0BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D8)
#define DDR_PHY_DX0BDLR6_0      0x5c010760
#define DDR_PHY_DX0BDLR6_1      0x5c110760
#define DDR_PHY_DX0BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1D9)
#define DDR_PHY_DX0BDLR7_0      0x5c010764
#define DDR_PHY_DX0BDLR7_1      0x5c110764
#define DDR_PHY_DX0BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1DA)
#define DDR_PHY_DX0BDLR8_0      0x5c010768
#define DDR_PHY_DX0BDLR8_1      0x5c110768
#define DDR_PHY_DX0BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1DB)
#define DDR_PHY_DX0BDLR9_0      0x5c01076c
#define DDR_PHY_DX0BDLR9_1      0x5c11076c
#define DDR_PHY_DX0LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E0)
#define DDR_PHY_DX0LCDLR0_0     0x5c010780
#define DDR_PHY_DX0LCDLR0_1     0x5c110780
#define DDR_PHY_DX0LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E1)
#define DDR_PHY_DX0LCDLR1_0     0x5c010784
#define DDR_PHY_DX0LCDLR1_1     0x5c110784
#define DDR_PHY_DX0LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E2)
#define DDR_PHY_DX0LCDLR2_0     0x5c010788
#define DDR_PHY_DX0LCDLR2_1     0x5c110788
#define DDR_PHY_DX0LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E3)
#define DDR_PHY_DX0LCDLR3_0     0x5c01078c
#define DDR_PHY_DX0LCDLR3_1     0x5c11078c
#define DDR_PHY_DX0LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E4)
#define DDR_PHY_DX0LCDLR4_0     0x5c010790
#define DDR_PHY_DX0LCDLR4_1     0x5c110790
#define DDR_PHY_DX0LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E5)
#define DDR_PHY_DX0LCDLR5_0     0x5c010794
#define DDR_PHY_DX0LCDLR5_1     0x5c110794
#define DDR_PHY_DX0MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E8)
#define DDR_PHY_DX0MDLR0_0      0x5c0107a0
#define DDR_PHY_DX0MDLR0_1      0x5c1107a0
#define DDR_PHY_DX0MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1E9)
#define DDR_PHY_DX0MDLR1_0      0x5c0107a4
#define DDR_PHY_DX0MDLR1_1      0x5c1107a4
#define DDR_PHY_DX0GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F0)
#define DDR_PHY_DX0GTR0_0       0x5c0107c0
#define DDR_PHY_DX0GTR0_1       0x5c1107c0
#define DDR_PHY_DX0RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F4)
#define DDR_PHY_DX0RSR0_0       0x5c0107d0
#define DDR_PHY_DX0RSR0_1       0x5c1107d0
#define DDR_PHY_DX0RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F5)
#define DDR_PHY_DX0RSR1_0       0x5c0107d4
#define DDR_PHY_DX0RSR1_1       0x5c1107d4
#define DDR_PHY_DX0RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F6)
#define DDR_PHY_DX0RSR2_0       0x5c0107d8
#define DDR_PHY_DX0RSR2_1       0x5c1107d8
#define DDR_PHY_DX0RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F7)
#define DDR_PHY_DX0RSR3_0       0x5c0107dc
#define DDR_PHY_DX0RSR3_1       0x5c1107dc
#define DDR_PHY_DX0GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F8)
#define DDR_PHY_DX0GSR0_0       0x5c0107e0
#define DDR_PHY_DX0GSR0_1       0x5c1107e0
#define DDR_PHY_DX0GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1F9)
#define DDR_PHY_DX0GSR1_0       0x5c0107e4
#define DDR_PHY_DX0GSR1_1       0x5c1107e4
#define DDR_PHY_DX0GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1FA)
#define DDR_PHY_DX0GSR2_0       0x5c0107e8
#define DDR_PHY_DX0GSR2_1       0x5c1107e8
#define DDR_PHY_DX0GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1FB)
#define DDR_PHY_DX0GSR3_0       0x5c0107ec
#define DDR_PHY_DX0GSR3_1       0x5c1107ec
#define DDR_PHY_DX0GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1FC)
#define DDR_PHY_DX0GSR4_0       0x5c0107f0
#define DDR_PHY_DX0GSR4_1       0x5c1107f0
#define DDR_PHY_DX0GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1FD)
#define DDR_PHY_DX0GSR5_0       0x5c0107f4
#define DDR_PHY_DX0GSR5_1       0x5c1107f4
#define DDR_PHY_DX0GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x1FE)
#define DDR_PHY_DX0GSR6_0       0x5c0107f8
#define DDR_PHY_DX0GSR6_1       0x5c1107f8
#define DDR_PHY_DX1GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x200)
#define DDR_PHY_DX1GCR0_0       0x5c010800
#define DDR_PHY_DX1GCR0_1       0x5c110800
#define DDR_PHY_DX1GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x201)
#define DDR_PHY_DX1GCR1_0       0x5c010804
#define DDR_PHY_DX1GCR1_1       0x5c110804
#define DDR_PHY_DX1GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x202)
#define DDR_PHY_DX1GCR2_0       0x5c010808
#define DDR_PHY_DX1GCR2_1       0x5c110808
#define DDR_PHY_DX1GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x203)
#define DDR_PHY_DX1GCR3_0       0x5c01080c
#define DDR_PHY_DX1GCR3_1       0x5c11080c
#define DDR_PHY_DX1GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x204)
#define DDR_PHY_DX1GCR4_0       0x5c010810
#define DDR_PHY_DX1GCR4_1       0x5c110810
#define DDR_PHY_DX1GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x205)
#define DDR_PHY_DX1GCR5_0       0x5c010814
#define DDR_PHY_DX1GCR5_1       0x5c110814
#define DDR_PHY_DX1GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x206)
#define DDR_PHY_DX1GCR6_0       0x5c010818
#define DDR_PHY_DX1GCR6_1       0x5c110818
#define DDR_PHY_DX1GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x207)
#define DDR_PHY_DX1GCR7_0       0x5c01081c
#define DDR_PHY_DX1GCR7_1       0x5c11081c
#define DDR_PHY_DX1GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x208)
#define DDR_PHY_DX1GCR8_0       0x5c010820
#define DDR_PHY_DX1GCR8_1       0x5c110820
#define DDR_PHY_DX1GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x209)
#define DDR_PHY_DX1GCR9_0       0x5c010824
#define DDR_PHY_DX1GCR9_1       0x5c110824
#define DDR_PHY_DX1DQMAP0(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x20A)
#define DDR_PHY_DX1DQMAP0_0		0x5c010828	
#define DDR_PHY_DX1DQMAP0_1		0x5c110828
#define DDR_PHY_DX1DQMAP1(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x20B)
#define DDR_PHY_DX1DQMAP1_0		0x5c01082c	
#define DDR_PHY_DX1DQMAP1_1		0x5c11082c
#define DDR_PHY_DX1BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x210)
#define DDR_PHY_DX1BDLR0_0      0x5c010840
#define DDR_PHY_DX1BDLR0_1      0x5c110840
#define DDR_PHY_DX1BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x211)
#define DDR_PHY_DX1BDLR1_0      0x5c010844
#define DDR_PHY_DX1BDLR1_1      0x5c110844
#define DDR_PHY_DX1BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x212)
#define DDR_PHY_DX1BDLR2_0      0x5c010848
#define DDR_PHY_DX1BDLR2_1      0x5c110848
#define DDR_PHY_DX1BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x214)
#define DDR_PHY_DX1BDLR3_0      0x5c010850
#define DDR_PHY_DX1BDLR3_1      0x5c110850
#define DDR_PHY_DX1BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x215)
#define DDR_PHY_DX1BDLR4_0      0x5c010854
#define DDR_PHY_DX1BDLR4_1      0x5c110854
#define DDR_PHY_DX1BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x216)
#define DDR_PHY_DX1BDLR5_0      0x5c010858
#define DDR_PHY_DX1BDLR5_1      0x5c110858
#define DDR_PHY_DX1BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x218)
#define DDR_PHY_DX1BDLR6_0      0x5c010860
#define DDR_PHY_DX1BDLR6_1      0x5c110860
#define DDR_PHY_DX1BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x219)
#define DDR_PHY_DX1BDLR7_0      0x5c010864
#define DDR_PHY_DX1BDLR7_1      0x5c110864
#define DDR_PHY_DX1BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x21A)
#define DDR_PHY_DX1BDLR8_0      0x5c010868
#define DDR_PHY_DX1BDLR8_1      0x5c110868
#define DDR_PHY_DX1BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x21B)
#define DDR_PHY_DX1BDLR9_0      0x5c01086c
#define DDR_PHY_DX1BDLR9_1      0x5c11086c
#define DDR_PHY_DX1LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x220)
#define DDR_PHY_DX1LCDLR0_0     0x5c010880
#define DDR_PHY_DX1LCDLR0_1     0x5c110880
#define DDR_PHY_DX1LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x221)
#define DDR_PHY_DX1LCDLR1_0     0x5c010884
#define DDR_PHY_DX1LCDLR1_1     0x5c110884
#define DDR_PHY_DX1LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x222)
#define DDR_PHY_DX1LCDLR2_0     0x5c010888
#define DDR_PHY_DX1LCDLR2_1     0x5c110888
#define DDR_PHY_DX1LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x223)
#define DDR_PHY_DX1LCDLR3_0     0x5c01088c
#define DDR_PHY_DX1LCDLR3_1     0x5c11088c
#define DDR_PHY_DX1LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x224)
#define DDR_PHY_DX1LCDLR4_0     0x5c010890
#define DDR_PHY_DX1LCDLR4_1     0x5c110890
#define DDR_PHY_DX1LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x225)
#define DDR_PHY_DX1LCDLR5_0     0x5c010894
#define DDR_PHY_DX1LCDLR5_1     0x5c110894
#define DDR_PHY_DX1MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x228)
#define DDR_PHY_DX1MDLR0_0      0x5c0108a0
#define DDR_PHY_DX1MDLR0_1      0x5c1108a0
#define DDR_PHY_DX1MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x229)
#define DDR_PHY_DX1MDLR1_0      0x5c0108a4
#define DDR_PHY_DX1MDLR1_1      0x5c1108a4
#define DDR_PHY_DX1GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x230)
#define DDR_PHY_DX1GTR0_0       0x5c0108c0
#define DDR_PHY_DX1GTR0_1       0x5c1108c0
#define DDR_PHY_DX1RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x234)
#define DDR_PHY_DX1RSR0_0       0x5c0108d0
#define DDR_PHY_DX1RSR0_1       0x5c1108d0
#define DDR_PHY_DX1RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x235)
#define DDR_PHY_DX1RSR1_0       0x5c0108d4
#define DDR_PHY_DX1RSR1_1       0x5c1108d4
#define DDR_PHY_DX1RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x236)
#define DDR_PHY_DX1RSR2_0       0x5c0108d8
#define DDR_PHY_DX1RSR2_1       0x5c1108d8
#define DDR_PHY_DX1RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x237)
#define DDR_PHY_DX1RSR3_0       0x5c0108dc
#define DDR_PHY_DX1RSR3_1       0x5c1108dc
#define DDR_PHY_DX1GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x238)
#define DDR_PHY_DX1GSR0_0       0x5c0108e0
#define DDR_PHY_DX1GSR0_1       0x5c1108e0
#define DDR_PHY_DX1GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x239)
#define DDR_PHY_DX1GSR1_0       0x5c0108e4
#define DDR_PHY_DX1GSR1_1       0x5c1108e4
#define DDR_PHY_DX1GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x23A)
#define DDR_PHY_DX1GSR2_0       0x5c0108e8
#define DDR_PHY_DX1GSR2_1       0x5c1108e8
#define DDR_PHY_DX1GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x23B)
#define DDR_PHY_DX1GSR3_0       0x5c0108ec
#define DDR_PHY_DX1GSR3_1       0x5c1108ec
#define DDR_PHY_DX1GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x23C)
#define DDR_PHY_DX1GSR4_0       0x5c0108f0
#define DDR_PHY_DX1GSR4_1       0x5c1108f0
#define DDR_PHY_DX1GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x23D)
#define DDR_PHY_DX1GSR5_0       0x5c0108f4
#define DDR_PHY_DX1GSR5_1       0x5c1108f4
#define DDR_PHY_DX1GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x23E)
#define DDR_PHY_DX1GSR6_0       0x5c0108f8
#define DDR_PHY_DX1GSR6_1       0x5c1108f8
#define DDR_PHY_DX2GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x240)
#define DDR_PHY_DX2GCR0_0       0x5c010900
#define DDR_PHY_DX2GCR0_1       0x5c110900
#define DDR_PHY_DX2GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x241)
#define DDR_PHY_DX2GCR1_0       0x5c010904
#define DDR_PHY_DX2GCR1_1       0x5c110904
#define DDR_PHY_DX2GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x242)
#define DDR_PHY_DX2GCR2_0       0x5c010908
#define DDR_PHY_DX2GCR2_1       0x5c110908
#define DDR_PHY_DX2GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x243)
#define DDR_PHY_DX2GCR3_0       0x5c01090c
#define DDR_PHY_DX2GCR3_1       0x5c11090c
#define DDR_PHY_DX2GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x244)
#define DDR_PHY_DX2GCR4_0       0x5c010910
#define DDR_PHY_DX2GCR4_1       0x5c110910
#define DDR_PHY_DX2GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x245)
#define DDR_PHY_DX2GCR5_0       0x5c010914
#define DDR_PHY_DX2GCR5_1       0x5c110914
#define DDR_PHY_DX2GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x246)
#define DDR_PHY_DX2GCR6_0       0x5c010918
#define DDR_PHY_DX2GCR6_1       0x5c110918
#define DDR_PHY_DX2GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x247)
#define DDR_PHY_DX2GCR7_0       0x5c01091c
#define DDR_PHY_DX2GCR7_1       0x5c11091c
#define DDR_PHY_DX2GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x248)
#define DDR_PHY_DX2GCR8_0       0x5c010920
#define DDR_PHY_DX2GCR8_1       0x5c110920
#define DDR_PHY_DX2GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x249)
#define DDR_PHY_DX2GCR9_0       0x5c010924
#define DDR_PHY_DX2GCR9_1       0x5c110924
#define DDR_PHY_DX2DQMAP0(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x24A)
#define DDR_PHY_DX2DQMAP0_0		0x5c010928
#define DDR_PHY_DX2DQMAP0_1		0x5c110928
#define DDR_PHY_DX2DQMAP1(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x24B)
#define DDR_PHY_DX2DQMAP1_0		0x5c01092c
#define DDR_PHY_DX2DQMAP1_1		0x5c11092c
#define DDR_PHY_DX2BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x250)
#define DDR_PHY_DX2BDLR0_0      0x5c010940
#define DDR_PHY_DX2BDLR0_1      0x5c110940
#define DDR_PHY_DX2BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x251)
#define DDR_PHY_DX2BDLR1_0      0x5c010944
#define DDR_PHY_DX2BDLR1_1      0x5c110944
#define DDR_PHY_DX2BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x252)
#define DDR_PHY_DX2BDLR2_0      0x5c010948
#define DDR_PHY_DX2BDLR2_1      0x5c110948
#define DDR_PHY_DX2BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x254)
#define DDR_PHY_DX2BDLR3_0      0x5c010950
#define DDR_PHY_DX2BDLR3_1      0x5c110950
#define DDR_PHY_DX2BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x255)
#define DDR_PHY_DX2BDLR4_0      0x5c010954
#define DDR_PHY_DX2BDLR4_1      0x5c110954
#define DDR_PHY_DX2BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x256)
#define DDR_PHY_DX2BDLR5_0      0x5c010958
#define DDR_PHY_DX2BDLR5_1      0x5c110958
#define DDR_PHY_DX2BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x258)
#define DDR_PHY_DX2BDLR6_0      0x5c010960
#define DDR_PHY_DX2BDLR6_1      0x5c110960
#define DDR_PHY_DX2BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x259)
#define DDR_PHY_DX2BDLR7_0      0x5c010964
#define DDR_PHY_DX2BDLR7_1      0x5c110964
#define DDR_PHY_DX2BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x25A)
#define DDR_PHY_DX2BDLR8_0      0x5c010968
#define DDR_PHY_DX2BDLR8_1      0x5c110968
#define DDR_PHY_DX2BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x25B)
#define DDR_PHY_DX2BDLR9_0      0x5c01096c
#define DDR_PHY_DX2BDLR9_1      0x5c11096c
#define DDR_PHY_DX2LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x260)
#define DDR_PHY_DX2LCDLR0_0     0x5c010980
#define DDR_PHY_DX2LCDLR0_1     0x5c110980
#define DDR_PHY_DX2LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x261)
#define DDR_PHY_DX2LCDLR1_0     0x5c010984
#define DDR_PHY_DX2LCDLR1_1     0x5c110984
#define DDR_PHY_DX2LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x262)
#define DDR_PHY_DX2LCDLR2_0     0x5c010988
#define DDR_PHY_DX2LCDLR2_1     0x5c110988
#define DDR_PHY_DX2LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x263)
#define DDR_PHY_DX2LCDLR3_0     0x5c01098c
#define DDR_PHY_DX2LCDLR3_1     0x5c11098c
#define DDR_PHY_DX2LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x264)
#define DDR_PHY_DX2LCDLR4_0     0x5c010990
#define DDR_PHY_DX2LCDLR4_1     0x5c110990
#define DDR_PHY_DX2LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x265)
#define DDR_PHY_DX2LCDLR5_0     0x5c010994
#define DDR_PHY_DX2LCDLR5_1     0x5c110994
#define DDR_PHY_DX2MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x268)
#define DDR_PHY_DX2MDLR0_0      0x5c0109a0
#define DDR_PHY_DX2MDLR0_1      0x5c1109a0
#define DDR_PHY_DX2MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x269)
#define DDR_PHY_DX2MDLR1_0      0x5c0109a4
#define DDR_PHY_DX2MDLR1_1      0x5c1109a4
#define DDR_PHY_DX2GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x270)
#define DDR_PHY_DX2GTR0_0       0x5c0109c0
#define DDR_PHY_DX2GTR0_1       0x5c1109c0
#define DDR_PHY_DX2RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x274)
#define DDR_PHY_DX2RSR0_0       0x5c0109d0
#define DDR_PHY_DX2RSR0_1       0x5c1109d0
#define DDR_PHY_DX2RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x275)
#define DDR_PHY_DX2RSR1_0       0x5c0109d4
#define DDR_PHY_DX2RSR1_1       0x5c1109d4
#define DDR_PHY_DX2RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x276)
#define DDR_PHY_DX2RSR2_0       0x5c0109d8
#define DDR_PHY_DX2RSR2_1       0x5c1109d8
#define DDR_PHY_DX2RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x277)
#define DDR_PHY_DX2RSR3_0       0x5c0109dc
#define DDR_PHY_DX2RSR3_1       0x5c1109dc
#define DDR_PHY_DX2GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x278)
#define DDR_PHY_DX2GSR0_0       0x5c0109e0
#define DDR_PHY_DX2GSR0_1       0x5c1109e0
#define DDR_PHY_DX2GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x279)
#define DDR_PHY_DX2GSR1_0       0x5c0109e4
#define DDR_PHY_DX2GSR1_1       0x5c1109e4
#define DDR_PHY_DX2GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x27A)
#define DDR_PHY_DX2GSR2_0       0x5c0109e8
#define DDR_PHY_DX2GSR2_1       0x5c1109e8
#define DDR_PHY_DX2GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x27B)
#define DDR_PHY_DX2GSR3_0       0x5c0109ec
#define DDR_PHY_DX2GSR3_1       0x5c1109ec
#define DDR_PHY_DX2GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x27C)
#define DDR_PHY_DX2GSR4_0       0x5c0109f0
#define DDR_PHY_DX2GSR4_1       0x5c1109f0
#define DDR_PHY_DX2GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x27D)
#define DDR_PHY_DX2GSR5_0       0x5c0109f4
#define DDR_PHY_DX2GSR5_1       0x5c1109f4
#define DDR_PHY_DX2GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x27E)
#define DDR_PHY_DX2GSR6_0       0x5c0109f8
#define DDR_PHY_DX2GSR6_1       0x5c1109f8
#define DDR_PHY_DX3GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x280)
#define DDR_PHY_DX3GCR0_0       0x5c010a00
#define DDR_PHY_DX3GCR0_1       0x5c110a00
#define DDR_PHY_DX3GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x281)
#define DDR_PHY_DX3GCR1_0       0x5c010a04
#define DDR_PHY_DX3GCR1_1       0x5c110a04
#define DDR_PHY_DX3GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x282)
#define DDR_PHY_DX3GCR2_0       0x5c010a08
#define DDR_PHY_DX3GCR2_1       0x5c110a08
#define DDR_PHY_DX3GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x283)
#define DDR_PHY_DX3GCR3_0       0x5c010a0c
#define DDR_PHY_DX3GCR3_1       0x5c110a0c
#define DDR_PHY_DX3GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x284)
#define DDR_PHY_DX3GCR4_0       0x5c010a10
#define DDR_PHY_DX3GCR4_1       0x5c110a10
#define DDR_PHY_DX3GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x285)
#define DDR_PHY_DX3GCR5_0       0x5c010a14
#define DDR_PHY_DX3GCR5_1       0x5c110a14
#define DDR_PHY_DX3GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x286)
#define DDR_PHY_DX3GCR6_0       0x5c010a18
#define DDR_PHY_DX3GCR6_1       0x5c110a18
#define DDR_PHY_DX3GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x287)
#define DDR_PHY_DX3GCR7_0       0x5c010a1c
#define DDR_PHY_DX3GCR7_1       0x5c110a1c
#define DDR_PHY_DX3GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x288)
#define DDR_PHY_DX3GCR8_0       0x5c010a20
#define DDR_PHY_DX3GCR8_1       0x5c110a20
#define DDR_PHY_DX3GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x289)
#define DDR_PHY_DX3GCR9_0       0x5c010a24
#define DDR_PHY_DX3GCR9_1       0x5c110a24
#define DDR_PHY_DX3DQMAP0(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x28A)
#define DDR_PHY_DX3DQMAP0_0		0x5c010a28
#define DDR_PHY_DX3DQMAP0_1		0x5c110a28
#define DDR_PHY_DX3DQMAP1(X)	REG32(DDR_PHY_BASE_ADDR(X) + 4*0x28B)
#define DDR_PHY_DX3DQMAP1_0		0x5c010a2c
#define DDR_PHY_DX3DQMAP1_1		0x5c110a2c
#define DDR_PHY_DX3BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x290)
#define DDR_PHY_DX3BDLR0_0      0x5c010a40
#define DDR_PHY_DX3BDLR0_1      0x5c110a40
#define DDR_PHY_DX3BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x291)
#define DDR_PHY_DX3BDLR1_0      0x5c010a44
#define DDR_PHY_DX3BDLR1_1      0x5c110a44
#define DDR_PHY_DX3BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x292)
#define DDR_PHY_DX3BDLR2_0      0x5c010a48
#define DDR_PHY_DX3BDLR2_1      0x5c110a48
#define DDR_PHY_DX3BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x294)
#define DDR_PHY_DX3BDLR3_0      0x5c010a50
#define DDR_PHY_DX3BDLR3_1      0x5c110a50
#define DDR_PHY_DX3BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x295)
#define DDR_PHY_DX3BDLR4_0      0x5c010a54
#define DDR_PHY_DX3BDLR4_1      0x5c110a54
#define DDR_PHY_DX3BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x296)
#define DDR_PHY_DX3BDLR5_0      0x5c010a58
#define DDR_PHY_DX3BDLR5_1      0x5c110a58
#define DDR_PHY_DX3BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x298)
#define DDR_PHY_DX3BDLR6_0      0x5c010a60
#define DDR_PHY_DX3BDLR6_1      0x5c110a60
#define DDR_PHY_DX3BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x299)
#define DDR_PHY_DX3BDLR7_0      0x5c010a64
#define DDR_PHY_DX3BDLR7_1      0x5c110a64
#define DDR_PHY_DX3BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x29A)
#define DDR_PHY_DX3BDLR8_0      0x5c010a68
#define DDR_PHY_DX3BDLR8_1      0x5c110a68
#define DDR_PHY_DX3BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x29B)
#define DDR_PHY_DX3BDLR9_0      0x5c010a6c
#define DDR_PHY_DX3BDLR9_1      0x5c110a6c
#define DDR_PHY_DX3LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A0)
#define DDR_PHY_DX3LCDLR0_0     0x5c010a80
#define DDR_PHY_DX3LCDLR0_1     0x5c110a80
#define DDR_PHY_DX3LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A1)
#define DDR_PHY_DX3LCDLR1_0     0x5c010a84
#define DDR_PHY_DX3LCDLR1_1     0x5c110a84
#define DDR_PHY_DX3LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A2)
#define DDR_PHY_DX3LCDLR2_0     0x5c010a88
#define DDR_PHY_DX3LCDLR2_1     0x5c110a88
#define DDR_PHY_DX3LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A3)
#define DDR_PHY_DX3LCDLR3_0     0x5c010a8c
#define DDR_PHY_DX3LCDLR3_1     0x5c110a8c
#define DDR_PHY_DX3LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A4)
#define DDR_PHY_DX3LCDLR4_0     0x5c010a90
#define DDR_PHY_DX3LCDLR4_1     0x5c110a90
#define DDR_PHY_DX3LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A5)
#define DDR_PHY_DX3LCDLR5_0     0x5c010a94
#define DDR_PHY_DX3LCDLR5_1     0x5c110a94
#define DDR_PHY_DX3MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A8)
#define DDR_PHY_DX3MDLR0_0      0x5c010aa0
#define DDR_PHY_DX3MDLR0_1      0x5c110aa0
#define DDR_PHY_DX3MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2A9)
#define DDR_PHY_DX3MDLR1_0      0x5c010aa4
#define DDR_PHY_DX3MDLR1_1      0x5c110aa4
#define DDR_PHY_DX3GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B0)
#define DDR_PHY_DX3GTR0_0       0x5c010ac0
#define DDR_PHY_DX3GTR0_1       0x5c110ac0
#define DDR_PHY_DX3RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B4)
#define DDR_PHY_DX3RSR0_0       0x5c010ad0
#define DDR_PHY_DX3RSR0_1       0x5c110ad0
#define DDR_PHY_DX3RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B5)
#define DDR_PHY_DX3RSR1_0       0x5c010ad4
#define DDR_PHY_DX3RSR1_1       0x5c110ad4
#define DDR_PHY_DX3RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B6)
#define DDR_PHY_DX3RSR2_0       0x5c010ad8
#define DDR_PHY_DX3RSR2_1       0x5c110ad8
#define DDR_PHY_DX3RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B7)
#define DDR_PHY_DX3RSR3_0       0x5c010adc
#define DDR_PHY_DX3RSR3_1       0x5c110adc
#define DDR_PHY_DX3GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B8)
#define DDR_PHY_DX3GSR0_0       0x5c010ae0
#define DDR_PHY_DX3GSR0_1       0x5c110ae0
#define DDR_PHY_DX3GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2B9)
#define DDR_PHY_DX3GSR1_0       0x5c010ae4
#define DDR_PHY_DX3GSR1_1       0x5c110ae4
#define DDR_PHY_DX3GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2BA)
#define DDR_PHY_DX3GSR2_0       0x5c010ae8
#define DDR_PHY_DX3GSR2_1       0x5c110ae8
#define DDR_PHY_DX3GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2BB)
#define DDR_PHY_DX3GSR3_0       0x5c010aec
#define DDR_PHY_DX3GSR3_1       0x5c110aec
#define DDR_PHY_DX3GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2BC)
#define DDR_PHY_DX3GSR4_0       0x5c010af0
#define DDR_PHY_DX3GSR4_1       0x5c110af0
#define DDR_PHY_DX3GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2BD)
#define DDR_PHY_DX3GSR5_0       0x5c010af4
#define DDR_PHY_DX3GSR5_1       0x5c110af4
#define DDR_PHY_DX3GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2BE)
#define DDR_PHY_DX3GSR6_0       0x5c010af8
#define DDR_PHY_DX3GSR6_1       0x5c110af8
#define DDR_PHY_DX4GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C0)
#define DDR_PHY_DX4GCR0_0       0x5c010b00
#define DDR_PHY_DX4GCR0_1       0x5c110b00
#define DDR_PHY_DX4GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C1)
#define DDR_PHY_DX4GCR1_0       0x5c010b04
#define DDR_PHY_DX4GCR1_1       0x5c110b04
#define DDR_PHY_DX4GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C2)
#define DDR_PHY_DX4GCR2_0       0x5c010b08
#define DDR_PHY_DX4GCR2_1       0x5c110b08
#define DDR_PHY_DX4GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C3)
#define DDR_PHY_DX4GCR3_0       0x5c010b0c
#define DDR_PHY_DX4GCR3_1       0x5c110b0c
#define DDR_PHY_DX4GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C4)
#define DDR_PHY_DX4GCR4_0       0x5c010b10
#define DDR_PHY_DX4GCR4_1       0x5c110b10
#define DDR_PHY_DX4GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C5)
#define DDR_PHY_DX4GCR5_0       0x5c010b14
#define DDR_PHY_DX4GCR5_1       0x5c110b14
#define DDR_PHY_DX4GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C6)
#define DDR_PHY_DX4GCR6_0       0x5c010b18
#define DDR_PHY_DX4GCR6_1       0x5c110b18
#define DDR_PHY_DX4GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C7)
#define DDR_PHY_DX4GCR7_0       0x5c010b1c
#define DDR_PHY_DX4GCR7_1       0x5c110b1c
#define DDR_PHY_DX4GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C8)
#define DDR_PHY_DX4GCR8_0       0x5c010b20
#define DDR_PHY_DX4GCR8_1       0x5c110b20
#define DDR_PHY_DX4GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2C9)
#define DDR_PHY_DX4GCR9_0       0x5c010b24
#define DDR_PHY_DX4GCR9_1       0x5c110b24
#define DDR_PHY_DX4BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D0)
#define DDR_PHY_DX4BDLR0_0      0x5c010b40
#define DDR_PHY_DX4BDLR0_1      0x5c110b40
#define DDR_PHY_DX4BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D1)
#define DDR_PHY_DX4BDLR1_0      0x5c010b44
#define DDR_PHY_DX4BDLR1_1      0x5c110b44
#define DDR_PHY_DX4BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D2)
#define DDR_PHY_DX4BDLR2_0      0x5c010b48
#define DDR_PHY_DX4BDLR2_1      0x5c110b48
#define DDR_PHY_DX4BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D4)
#define DDR_PHY_DX4BDLR3_0      0x5c010b50
#define DDR_PHY_DX4BDLR3_1      0x5c110b50
#define DDR_PHY_DX4BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D5)
#define DDR_PHY_DX4BDLR4_0      0x5c010b54
#define DDR_PHY_DX4BDLR4_1      0x5c110b54
#define DDR_PHY_DX4BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D6)
#define DDR_PHY_DX4BDLR5_0      0x5c010b58
#define DDR_PHY_DX4BDLR5_1      0x5c110b58
#define DDR_PHY_DX4BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D8)
#define DDR_PHY_DX4BDLR6_0      0x5c010b60
#define DDR_PHY_DX4BDLR6_1      0x5c110b60
#define DDR_PHY_DX4BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2D9)
#define DDR_PHY_DX4BDLR7_0      0x5c010b64
#define DDR_PHY_DX4BDLR7_1      0x5c110b64
#define DDR_PHY_DX4BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2DA)
#define DDR_PHY_DX4BDLR8_0      0x5c010b68
#define DDR_PHY_DX4BDLR8_1      0x5c110b68
#define DDR_PHY_DX4BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2DB)
#define DDR_PHY_DX4BDLR9_0      0x5c010b6c
#define DDR_PHY_DX4BDLR9_1      0x5c110b6c
#define DDR_PHY_DX4LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E0)
#define DDR_PHY_DX4LCDLR0_0     0x5c010b80
#define DDR_PHY_DX4LCDLR0_1     0x5c110b80
#define DDR_PHY_DX4LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E1)
#define DDR_PHY_DX4LCDLR1_0     0x5c010b84
#define DDR_PHY_DX4LCDLR1_1     0x5c110b84
#define DDR_PHY_DX4LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E2)
#define DDR_PHY_DX4LCDLR2_0     0x5c010b88
#define DDR_PHY_DX4LCDLR2_1     0x5c110b88
#define DDR_PHY_DX4LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E3)
#define DDR_PHY_DX4LCDLR3_0     0x5c010b8c
#define DDR_PHY_DX4LCDLR3_1     0x5c110b8c
#define DDR_PHY_DX4LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E4)
#define DDR_PHY_DX4LCDLR4_0     0x5c010b90
#define DDR_PHY_DX4LCDLR4_1     0x5c110b90
#define DDR_PHY_DX4LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E5)
#define DDR_PHY_DX4LCDLR5_0     0x5c010b94
#define DDR_PHY_DX4LCDLR5_1     0x5c110b94
#define DDR_PHY_DX4MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E8)
#define DDR_PHY_DX4MDLR0_0      0x5c010ba0
#define DDR_PHY_DX4MDLR0_1      0x5c110ba0
#define DDR_PHY_DX4MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2E9)
#define DDR_PHY_DX4MDLR1_0      0x5c010ba4
#define DDR_PHY_DX4MDLR1_1      0x5c110ba4
#define DDR_PHY_DX4GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F0)
#define DDR_PHY_DX4GTR0_0       0x5c010bc0
#define DDR_PHY_DX4GTR0_1       0x5c110bc0
#define DDR_PHY_DX4RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F4)
#define DDR_PHY_DX4RSR0_0       0x5c010bd0
#define DDR_PHY_DX4RSR0_1       0x5c110bd0
#define DDR_PHY_DX4RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F5)
#define DDR_PHY_DX4RSR1_0       0x5c010bd4
#define DDR_PHY_DX4RSR1_1       0x5c110bd4
#define DDR_PHY_DX4RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F6)
#define DDR_PHY_DX4RSR2_0       0x5c010bd8
#define DDR_PHY_DX4RSR2_1       0x5c110bd8
#define DDR_PHY_DX4RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F7)
#define DDR_PHY_DX4RSR3_0       0x5c010bdc
#define DDR_PHY_DX4RSR3_1       0x5c110bdc
#define DDR_PHY_DX4GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F8)
#define DDR_PHY_DX4GSR0_0       0x5c010be0
#define DDR_PHY_DX4GSR0_1       0x5c110be0
#define DDR_PHY_DX4GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2F9)
#define DDR_PHY_DX4GSR1_0       0x5c010be4
#define DDR_PHY_DX4GSR1_1       0x5c110be4
#define DDR_PHY_DX4GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2FA)
#define DDR_PHY_DX4GSR2_0       0x5c010be8
#define DDR_PHY_DX4GSR2_1       0x5c110be8
#define DDR_PHY_DX4GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2FB)
#define DDR_PHY_DX4GSR3_0       0x5c010bec
#define DDR_PHY_DX4GSR3_1       0x5c110bec
#define DDR_PHY_DX4GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2FC)
#define DDR_PHY_DX4GSR4_0       0x5c010bf0
#define DDR_PHY_DX4GSR4_1       0x5c110bf0
#define DDR_PHY_DX4GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2FD)
#define DDR_PHY_DX4GSR5_0       0x5c010bf4
#define DDR_PHY_DX4GSR5_1       0x5c110bf4
#define DDR_PHY_DX4GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x2FE)
#define DDR_PHY_DX4GSR6_0       0x5c010bf8
#define DDR_PHY_DX4GSR6_1       0x5c110bf8
#define DDR_PHY_DX5GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x300)
#define DDR_PHY_DX5GCR0_0       0x5c010c00
#define DDR_PHY_DX5GCR0_1       0x5c110c00
#define DDR_PHY_DX5GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x301)
#define DDR_PHY_DX5GCR1_0       0x5c010c04
#define DDR_PHY_DX5GCR1_1       0x5c110c04
#define DDR_PHY_DX5GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x302)
#define DDR_PHY_DX5GCR2_0       0x5c010c08
#define DDR_PHY_DX5GCR2_1       0x5c110c08
#define DDR_PHY_DX5GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x303)
#define DDR_PHY_DX5GCR3_0       0x5c010c0c
#define DDR_PHY_DX5GCR3_1       0x5c110c0c
#define DDR_PHY_DX5GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x304)
#define DDR_PHY_DX5GCR4_0       0x5c010c10
#define DDR_PHY_DX5GCR4_1       0x5c110c10
#define DDR_PHY_DX5GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x305)
#define DDR_PHY_DX5GCR5_0       0x5c010c14
#define DDR_PHY_DX5GCR5_1       0x5c110c14
#define DDR_PHY_DX5GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x306)
#define DDR_PHY_DX5GCR6_0       0x5c010c18
#define DDR_PHY_DX5GCR6_1       0x5c110c18
#define DDR_PHY_DX5GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x307)
#define DDR_PHY_DX5GCR7_0       0x5c010c1c
#define DDR_PHY_DX5GCR7_1       0x5c110c1c
#define DDR_PHY_DX5GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x308)
#define DDR_PHY_DX5GCR8_0       0x5c010c20
#define DDR_PHY_DX5GCR8_1       0x5c110c20
#define DDR_PHY_DX5GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x309)
#define DDR_PHY_DX5GCR9_0       0x5c010c24
#define DDR_PHY_DX5GCR9_1       0x5c110c24
#define DDR_PHY_DX5BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x310)
#define DDR_PHY_DX5BDLR0_0      0x5c010c40
#define DDR_PHY_DX5BDLR0_1      0x5c110c40
#define DDR_PHY_DX5BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x311)
#define DDR_PHY_DX5BDLR1_0      0x5c010c44
#define DDR_PHY_DX5BDLR1_1      0x5c110c44
#define DDR_PHY_DX5BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x312)
#define DDR_PHY_DX5BDLR2_0      0x5c010c48
#define DDR_PHY_DX5BDLR2_1      0x5c110c48
#define DDR_PHY_DX5BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x314)
#define DDR_PHY_DX5BDLR3_0      0x5c010c50
#define DDR_PHY_DX5BDLR3_1      0x5c110c50
#define DDR_PHY_DX5BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x315)
#define DDR_PHY_DX5BDLR4_0      0x5c010c54
#define DDR_PHY_DX5BDLR4_1      0x5c110c54
#define DDR_PHY_DX5BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x316)
#define DDR_PHY_DX5BDLR5_0      0x5c010c58
#define DDR_PHY_DX5BDLR5_1      0x5c110c58
#define DDR_PHY_DX5BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x318)
#define DDR_PHY_DX5BDLR6_0      0x5c010c60
#define DDR_PHY_DX5BDLR6_1      0x5c110c60
#define DDR_PHY_DX5BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x319)
#define DDR_PHY_DX5BDLR7_0      0x5c010c64
#define DDR_PHY_DX5BDLR7_1      0x5c110c64
#define DDR_PHY_DX5BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x31A)
#define DDR_PHY_DX5BDLR8_0      0x5c010c68
#define DDR_PHY_DX5BDLR8_1      0x5c110c68
#define DDR_PHY_DX5BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x31B)
#define DDR_PHY_DX5BDLR9_0      0x5c010c6c
#define DDR_PHY_DX5BDLR9_1      0x5c110c6c
#define DDR_PHY_DX5LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x320)
#define DDR_PHY_DX5LCDLR0_0     0x5c010c80
#define DDR_PHY_DX5LCDLR0_1     0x5c110c80
#define DDR_PHY_DX5LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x321)
#define DDR_PHY_DX5LCDLR1_0     0x5c010c84
#define DDR_PHY_DX5LCDLR1_1     0x5c110c84
#define DDR_PHY_DX5LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x322)
#define DDR_PHY_DX5LCDLR2_0     0x5c010c88
#define DDR_PHY_DX5LCDLR2_1     0x5c110c88
#define DDR_PHY_DX5LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x323)
#define DDR_PHY_DX5LCDLR3_0     0x5c010c8c
#define DDR_PHY_DX5LCDLR3_1     0x5c110c8c
#define DDR_PHY_DX5LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x324)
#define DDR_PHY_DX5LCDLR4_0     0x5c010c90
#define DDR_PHY_DX5LCDLR4_1     0x5c110c90
#define DDR_PHY_DX5LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x325)
#define DDR_PHY_DX5LCDLR5_0     0x5c010c94
#define DDR_PHY_DX5LCDLR5_1     0x5c110c94
#define DDR_PHY_DX5MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x328)
#define DDR_PHY_DX5MDLR0_0      0x5c010ca0
#define DDR_PHY_DX5MDLR0_1      0x5c110ca0
#define DDR_PHY_DX5MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x329)
#define DDR_PHY_DX5MDLR1_0      0x5c010ca4
#define DDR_PHY_DX5MDLR1_1      0x5c110ca4
#define DDR_PHY_DX5GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x330)
#define DDR_PHY_DX5GTR0_0       0x5c010cc0
#define DDR_PHY_DX5GTR0_1       0x5c110cc0
#define DDR_PHY_DX5RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x334)
#define DDR_PHY_DX5RSR0_0       0x5c010cd0
#define DDR_PHY_DX5RSR0_1       0x5c110cd0
#define DDR_PHY_DX5RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x335)
#define DDR_PHY_DX5RSR1_0       0x5c010cd4
#define DDR_PHY_DX5RSR1_1       0x5c110cd4
#define DDR_PHY_DX5RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x336)
#define DDR_PHY_DX5RSR2_0       0x5c010cd8
#define DDR_PHY_DX5RSR2_1       0x5c110cd8
#define DDR_PHY_DX5RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x337)
#define DDR_PHY_DX5RSR3_0       0x5c010cdc
#define DDR_PHY_DX5RSR3_1       0x5c110cdc
#define DDR_PHY_DX5GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x338)
#define DDR_PHY_DX5GSR0_0       0x5c010ce0
#define DDR_PHY_DX5GSR0_1       0x5c110ce0
#define DDR_PHY_DX5GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x339)
#define DDR_PHY_DX5GSR1_0       0x5c010ce4
#define DDR_PHY_DX5GSR1_1       0x5c110ce4
#define DDR_PHY_DX5GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x33A)
#define DDR_PHY_DX5GSR2_0       0x5c010ce8
#define DDR_PHY_DX5GSR2_1       0x5c110ce8
#define DDR_PHY_DX5GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x33B)
#define DDR_PHY_DX5GSR3_0       0x5c010cec
#define DDR_PHY_DX5GSR3_1       0x5c110cec
#define DDR_PHY_DX5GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x33C)
#define DDR_PHY_DX5GSR4_0       0x5c010cf0
#define DDR_PHY_DX5GSR4_1       0x5c110cf0
#define DDR_PHY_DX5GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x33D)
#define DDR_PHY_DX5GSR5_0       0x5c010cf4
#define DDR_PHY_DX5GSR5_1       0x5c110cf4
#define DDR_PHY_DX5GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x33E)
#define DDR_PHY_DX5GSR6_0       0x5c010cf8
#define DDR_PHY_DX5GSR6_1       0x5c110cf8
#define DDR_PHY_DX6GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x340)
#define DDR_PHY_DX6GCR0_0       0x5c010d00
#define DDR_PHY_DX6GCR0_1       0x5c110d00
#define DDR_PHY_DX6GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x341)
#define DDR_PHY_DX6GCR1_0       0x5c010d04
#define DDR_PHY_DX6GCR1_1       0x5c110d04
#define DDR_PHY_DX6GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x342)
#define DDR_PHY_DX6GCR2_0       0x5c010d08
#define DDR_PHY_DX6GCR2_1       0x5c110d08
#define DDR_PHY_DX6GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x343)
#define DDR_PHY_DX6GCR3_0       0x5c010d0c
#define DDR_PHY_DX6GCR3_1       0x5c110d0c
#define DDR_PHY_DX6GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x344)
#define DDR_PHY_DX6GCR4_0       0x5c010d10
#define DDR_PHY_DX6GCR4_1       0x5c110d10
#define DDR_PHY_DX6GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x345)
#define DDR_PHY_DX6GCR5_0       0x5c010d14
#define DDR_PHY_DX6GCR5_1       0x5c110d14
#define DDR_PHY_DX6GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x346)
#define DDR_PHY_DX6GCR6_0       0x5c010d18
#define DDR_PHY_DX6GCR6_1       0x5c110d18
#define DDR_PHY_DX6GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x347)
#define DDR_PHY_DX6GCR7_0       0x5c010d1c
#define DDR_PHY_DX6GCR7_1       0x5c110d1c
#define DDR_PHY_DX6GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x348)
#define DDR_PHY_DX6GCR8_0       0x5c010d20
#define DDR_PHY_DX6GCR8_1       0x5c110d20
#define DDR_PHY_DX6GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x349)
#define DDR_PHY_DX6GCR9_0       0x5c010d24
#define DDR_PHY_DX6GCR9_1       0x5c110d24
#define DDR_PHY_DX6BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x350)
#define DDR_PHY_DX6BDLR0_0      0x5c010d40
#define DDR_PHY_DX6BDLR0_1      0x5c110d40
#define DDR_PHY_DX6BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x351)
#define DDR_PHY_DX6BDLR1_0      0x5c010d44
#define DDR_PHY_DX6BDLR1_1      0x5c110d44
#define DDR_PHY_DX6BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x352)
#define DDR_PHY_DX6BDLR2_0      0x5c010d48
#define DDR_PHY_DX6BDLR2_1      0x5c110d48
#define DDR_PHY_DX6BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x354)
#define DDR_PHY_DX6BDLR3_0      0x5c010d50
#define DDR_PHY_DX6BDLR3_1      0x5c110d50
#define DDR_PHY_DX6BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x355)
#define DDR_PHY_DX6BDLR4_0      0x5c010d54
#define DDR_PHY_DX6BDLR4_1      0x5c110d54
#define DDR_PHY_DX6BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x356)
#define DDR_PHY_DX6BDLR5_0      0x5c010d58
#define DDR_PHY_DX6BDLR5_1      0x5c110d58
#define DDR_PHY_DX6BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x358)
#define DDR_PHY_DX6BDLR6_0      0x5c010d60
#define DDR_PHY_DX6BDLR6_1      0x5c110d60
#define DDR_PHY_DX6BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x359)
#define DDR_PHY_DX6BDLR7_0      0x5c010d64
#define DDR_PHY_DX6BDLR7_1      0x5c110d64
#define DDR_PHY_DX6BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x35A)
#define DDR_PHY_DX6BDLR8_0      0x5c010d68
#define DDR_PHY_DX6BDLR8_1      0x5c110d68
#define DDR_PHY_DX6BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x35B)
#define DDR_PHY_DX6BDLR9_0      0x5c010d6c
#define DDR_PHY_DX6BDLR9_1      0x5c110d6c
#define DDR_PHY_DX6LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x360)
#define DDR_PHY_DX6LCDLR0_0     0x5c010d80
#define DDR_PHY_DX6LCDLR0_1     0x5c110d80
#define DDR_PHY_DX6LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x361)
#define DDR_PHY_DX6LCDLR1_0     0x5c010d84
#define DDR_PHY_DX6LCDLR1_1     0x5c110d84
#define DDR_PHY_DX6LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x362)
#define DDR_PHY_DX6LCDLR2_0     0x5c010d88
#define DDR_PHY_DX6LCDLR2_1     0x5c110d88
#define DDR_PHY_DX6LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x363)
#define DDR_PHY_DX6LCDLR3_0     0x5c010d8c
#define DDR_PHY_DX6LCDLR3_1     0x5c110d8c
#define DDR_PHY_DX6LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x364)
#define DDR_PHY_DX6LCDLR4_0     0x5c010d90
#define DDR_PHY_DX6LCDLR4_1     0x5c110d90
#define DDR_PHY_DX6LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x365)
#define DDR_PHY_DX6LCDLR5_0     0x5c010d94
#define DDR_PHY_DX6LCDLR5_1     0x5c110d94
#define DDR_PHY_DX6MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x368)
#define DDR_PHY_DX6MDLR0_0      0x5c010da0
#define DDR_PHY_DX6MDLR0_1      0x5c110da0
#define DDR_PHY_DX6MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x369)
#define DDR_PHY_DX6MDLR1_0      0x5c010da4
#define DDR_PHY_DX6MDLR1_1      0x5c110da4
#define DDR_PHY_DX6GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x370)
#define DDR_PHY_DX6GTR0_0       0x5c010dc0
#define DDR_PHY_DX6GTR0_1       0x5c110dc0
#define DDR_PHY_DX6RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x374)
#define DDR_PHY_DX6RSR0_0       0x5c010dd0
#define DDR_PHY_DX6RSR0_1       0x5c110dd0
#define DDR_PHY_DX6RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x375)
#define DDR_PHY_DX6RSR1_0       0x5c010dd4
#define DDR_PHY_DX6RSR1_1       0x5c110dd4
#define DDR_PHY_DX6RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x376)
#define DDR_PHY_DX6RSR2_0       0x5c010dd8
#define DDR_PHY_DX6RSR2_1       0x5c110dd8
#define DDR_PHY_DX6RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x377)
#define DDR_PHY_DX6RSR3_0       0x5c010ddc
#define DDR_PHY_DX6RSR3_1       0x5c110ddc
#define DDR_PHY_DX6GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x378)
#define DDR_PHY_DX6GSR0_0       0x5c010de0
#define DDR_PHY_DX6GSR0_1       0x5c110de0
#define DDR_PHY_DX6GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x379)
#define DDR_PHY_DX6GSR1_0       0x5c010de4
#define DDR_PHY_DX6GSR1_1       0x5c110de4
#define DDR_PHY_DX6GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x37A)
#define DDR_PHY_DX6GSR2_0       0x5c010de8
#define DDR_PHY_DX6GSR2_1       0x5c110de8
#define DDR_PHY_DX6GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x37B)
#define DDR_PHY_DX6GSR3_0       0x5c010dec
#define DDR_PHY_DX6GSR3_1       0x5c110dec
#define DDR_PHY_DX6GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x37C)
#define DDR_PHY_DX6GSR4_0       0x5c010df0
#define DDR_PHY_DX6GSR4_1       0x5c110df0
#define DDR_PHY_DX6GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x37D)
#define DDR_PHY_DX6GSR5_0       0x5c010df4
#define DDR_PHY_DX6GSR5_1       0x5c110df4
#define DDR_PHY_DX6GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x37E)
#define DDR_PHY_DX6GSR6_0       0x5c010df8
#define DDR_PHY_DX6GSR6_1       0x5c110df8
#define DDR_PHY_DX7GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x380)
#define DDR_PHY_DX7GCR0_0       0x5c010e00
#define DDR_PHY_DX7GCR0_1       0x5c110e00
#define DDR_PHY_DX7GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x381)
#define DDR_PHY_DX7GCR1_0       0x5c010e04
#define DDR_PHY_DX7GCR1_1       0x5c110e04
#define DDR_PHY_DX7GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x382)
#define DDR_PHY_DX7GCR2_0       0x5c010e08
#define DDR_PHY_DX7GCR2_1       0x5c110e08
#define DDR_PHY_DX7GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x383)
#define DDR_PHY_DX7GCR3_0       0x5c010e0c
#define DDR_PHY_DX7GCR3_1       0x5c110e0c
#define DDR_PHY_DX7GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x384)
#define DDR_PHY_DX7GCR4_0       0x5c010e10
#define DDR_PHY_DX7GCR4_1       0x5c110e10
#define DDR_PHY_DX7GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x385)
#define DDR_PHY_DX7GCR5_0       0x5c010e14
#define DDR_PHY_DX7GCR5_1       0x5c110e14
#define DDR_PHY_DX7GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x386)
#define DDR_PHY_DX7GCR6_0       0x5c010e18
#define DDR_PHY_DX7GCR6_1       0x5c110e18
#define DDR_PHY_DX7GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x387)
#define DDR_PHY_DX7GCR7_0       0x5c010e1c
#define DDR_PHY_DX7GCR7_1       0x5c110e1c
#define DDR_PHY_DX7GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x388)
#define DDR_PHY_DX7GCR8_0       0x5c010e20
#define DDR_PHY_DX7GCR8_1       0x5c110e20
#define DDR_PHY_DX7GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x389)
#define DDR_PHY_DX7GCR9_0       0x5c010e24
#define DDR_PHY_DX7GCR9_1       0x5c110e24
#define DDR_PHY_DX7BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x390)
#define DDR_PHY_DX7BDLR0_0      0x5c010e40
#define DDR_PHY_DX7BDLR0_1      0x5c110e40
#define DDR_PHY_DX7BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x391)
#define DDR_PHY_DX7BDLR1_0      0x5c010e44
#define DDR_PHY_DX7BDLR1_1      0x5c110e44
#define DDR_PHY_DX7BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x392)
#define DDR_PHY_DX7BDLR2_0      0x5c010e48
#define DDR_PHY_DX7BDLR2_1      0x5c110e48
#define DDR_PHY_DX7BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x394)
#define DDR_PHY_DX7BDLR3_0      0x5c010e50
#define DDR_PHY_DX7BDLR3_1      0x5c110e50
#define DDR_PHY_DX7BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x395)
#define DDR_PHY_DX7BDLR4_0      0x5c010e54
#define DDR_PHY_DX7BDLR4_1      0x5c110e54
#define DDR_PHY_DX7BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x396)
#define DDR_PHY_DX7BDLR5_0      0x5c010e58
#define DDR_PHY_DX7BDLR5_1      0x5c110e58
#define DDR_PHY_DX7BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x398)
#define DDR_PHY_DX7BDLR6_0      0x5c010e60
#define DDR_PHY_DX7BDLR6_1      0x5c110e60
#define DDR_PHY_DX7BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x399)
#define DDR_PHY_DX7BDLR7_0      0x5c010e64
#define DDR_PHY_DX7BDLR7_1      0x5c110e64
#define DDR_PHY_DX7BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x39A)
#define DDR_PHY_DX7BDLR8_0      0x5c010e68
#define DDR_PHY_DX7BDLR8_1      0x5c110e68
#define DDR_PHY_DX7BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x39B)
#define DDR_PHY_DX7BDLR9_0      0x5c010e6c
#define DDR_PHY_DX7BDLR9_1      0x5c110e6c
#define DDR_PHY_DX7LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A0)
#define DDR_PHY_DX7LCDLR0_0     0x5c010e80
#define DDR_PHY_DX7LCDLR0_1     0x5c110e80
#define DDR_PHY_DX7LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A1)
#define DDR_PHY_DX7LCDLR1_0     0x5c010e84
#define DDR_PHY_DX7LCDLR1_1     0x5c110e84
#define DDR_PHY_DX7LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A2)
#define DDR_PHY_DX7LCDLR2_0     0x5c010e88
#define DDR_PHY_DX7LCDLR2_1     0x5c110e88
#define DDR_PHY_DX7LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A3)
#define DDR_PHY_DX7LCDLR3_0     0x5c010e8c
#define DDR_PHY_DX7LCDLR3_1     0x5c110e8c
#define DDR_PHY_DX7LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A4)
#define DDR_PHY_DX7LCDLR4_0     0x5c010e90
#define DDR_PHY_DX7LCDLR4_1     0x5c110e90
#define DDR_PHY_DX7LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A5)
#define DDR_PHY_DX7LCDLR5_0     0x5c010e94
#define DDR_PHY_DX7LCDLR5_1     0x5c110e94
#define DDR_PHY_DX7MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A8)
#define DDR_PHY_DX7MDLR0_0      0x5c010ea0
#define DDR_PHY_DX7MDLR0_1      0x5c110ea0
#define DDR_PHY_DX7MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3A9)
#define DDR_PHY_DX7MDLR1_0      0x5c010ea4
#define DDR_PHY_DX7MDLR1_1      0x5c110ea4
#define DDR_PHY_DX7GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B0)
#define DDR_PHY_DX7GTR0_0       0x5c010ec0
#define DDR_PHY_DX7GTR0_1       0x5c110ec0
#define DDR_PHY_DX7RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B4)
#define DDR_PHY_DX7RSR0_0       0x5c010ed0
#define DDR_PHY_DX7RSR0_1       0x5c110ed0
#define DDR_PHY_DX7RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B5)
#define DDR_PHY_DX7RSR1_0       0x5c010ed4
#define DDR_PHY_DX7RSR1_1       0x5c110ed4
#define DDR_PHY_DX7RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B6)
#define DDR_PHY_DX7RSR2_0       0x5c010ed8
#define DDR_PHY_DX7RSR2_1       0x5c110ed8
#define DDR_PHY_DX7RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B7)
#define DDR_PHY_DX7RSR3_0       0x5c010edc
#define DDR_PHY_DX7RSR3_1       0x5c110edc
#define DDR_PHY_DX7GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B8)
#define DDR_PHY_DX7GSR0_0       0x5c010ee0
#define DDR_PHY_DX7GSR0_1       0x5c110ee0
#define DDR_PHY_DX7GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3B9)
#define DDR_PHY_DX7GSR1_0       0x5c010ee4
#define DDR_PHY_DX7GSR1_1       0x5c110ee4
#define DDR_PHY_DX7GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3BA)
#define DDR_PHY_DX7GSR2_0       0x5c010ee8
#define DDR_PHY_DX7GSR2_1       0x5c110ee8
#define DDR_PHY_DX7GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3BB)
#define DDR_PHY_DX7GSR3_0       0x5c010eec
#define DDR_PHY_DX7GSR3_1       0x5c110eec
#define DDR_PHY_DX7GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3BC)
#define DDR_PHY_DX7GSR4_0       0x5c010ef0
#define DDR_PHY_DX7GSR4_1       0x5c110ef0
#define DDR_PHY_DX7GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3BD)
#define DDR_PHY_DX7GSR5_0       0x5c010ef4
#define DDR_PHY_DX7GSR5_1       0x5c110ef4
#define DDR_PHY_DX7GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3BE)
#define DDR_PHY_DX7GSR6_0       0x5c010ef8
#define DDR_PHY_DX7GSR6_1       0x5c110ef8
#define DDR_PHY_DX8GCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C0)
#define DDR_PHY_DX8GCR0_0       0x5c010f00
#define DDR_PHY_DX8GCR0_1       0x5c110f00
#define DDR_PHY_DX8GCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C1)
#define DDR_PHY_DX8GCR1_0       0x5c010f04
#define DDR_PHY_DX8GCR1_1       0x5c110f04
#define DDR_PHY_DX8GCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C2)
#define DDR_PHY_DX8GCR2_0       0x5c010f08
#define DDR_PHY_DX8GCR2_1       0x5c110f08
#define DDR_PHY_DX8GCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C3)
#define DDR_PHY_DX8GCR3_0       0x5c010f0c
#define DDR_PHY_DX8GCR3_1       0x5c110f0c
#define DDR_PHY_DX8GCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C4)
#define DDR_PHY_DX8GCR4_0       0x5c010f10
#define DDR_PHY_DX8GCR4_1       0x5c110f10
#define DDR_PHY_DX8GCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C5)
#define DDR_PHY_DX8GCR5_0       0x5c010f14
#define DDR_PHY_DX8GCR5_1       0x5c110f14
#define DDR_PHY_DX8GCR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C6)
#define DDR_PHY_DX8GCR6_0       0x5c010f18
#define DDR_PHY_DX8GCR6_1       0x5c110f18
#define DDR_PHY_DX8GCR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C7)
#define DDR_PHY_DX8GCR7_0       0x5c010f1c
#define DDR_PHY_DX8GCR7_1       0x5c110f1c
#define DDR_PHY_DX8GCR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C8)
#define DDR_PHY_DX8GCR8_0       0x5c010f20
#define DDR_PHY_DX8GCR8_1       0x5c110f20
#define DDR_PHY_DX8GCR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3C9)
#define DDR_PHY_DX8GCR9_0       0x5c010f24
#define DDR_PHY_DX8GCR9_1       0x5c110f24
#define DDR_PHY_DX8BDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D0)
#define DDR_PHY_DX8BDLR0_0      0x5c010f40
#define DDR_PHY_DX8BDLR0_1      0x5c110f40
#define DDR_PHY_DX8BDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D1)
#define DDR_PHY_DX8BDLR1_0      0x5c010f44
#define DDR_PHY_DX8BDLR1_1      0x5c110f44
#define DDR_PHY_DX8BDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D2)
#define DDR_PHY_DX8BDLR2_0      0x5c010f48
#define DDR_PHY_DX8BDLR2_1      0x5c110f48
#define DDR_PHY_DX8BDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D4)
#define DDR_PHY_DX8BDLR3_0      0x5c010f50
#define DDR_PHY_DX8BDLR3_1      0x5c110f50
#define DDR_PHY_DX8BDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D5)
#define DDR_PHY_DX8BDLR4_0      0x5c010f54
#define DDR_PHY_DX8BDLR4_1      0x5c110f54
#define DDR_PHY_DX8BDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D6)
#define DDR_PHY_DX8BDLR5_0      0x5c010f58
#define DDR_PHY_DX8BDLR5_1      0x5c110f58
#define DDR_PHY_DX8BDLR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D8)
#define DDR_PHY_DX8BDLR6_0      0x5c010f60
#define DDR_PHY_DX8BDLR6_1      0x5c110f60
#define DDR_PHY_DX8BDLR7(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3D9)
#define DDR_PHY_DX8BDLR7_0      0x5c010f64
#define DDR_PHY_DX8BDLR7_1      0x5c110f64
#define DDR_PHY_DX8BDLR8(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3DA)
#define DDR_PHY_DX8BDLR8_0      0x5c010f68
#define DDR_PHY_DX8BDLR8_1      0x5c110f68
#define DDR_PHY_DX8BDLR9(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3DB)
#define DDR_PHY_DX8BDLR9_0      0x5c010f6c
#define DDR_PHY_DX8BDLR9_1      0x5c110f6c
#define DDR_PHY_DX8LCDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E0)
#define DDR_PHY_DX8LCDLR0_0     0x5c010f80
#define DDR_PHY_DX8LCDLR0_1     0x5c110f80
#define DDR_PHY_DX8LCDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E1)
#define DDR_PHY_DX8LCDLR1_0     0x5c010f84
#define DDR_PHY_DX8LCDLR1_1     0x5c110f84
#define DDR_PHY_DX8LCDLR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E2)
#define DDR_PHY_DX8LCDLR2_0     0x5c010f88
#define DDR_PHY_DX8LCDLR2_1     0x5c110f88
#define DDR_PHY_DX8LCDLR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E3)
#define DDR_PHY_DX8LCDLR3_0     0x5c010f8c
#define DDR_PHY_DX8LCDLR3_1     0x5c110f8c
#define DDR_PHY_DX8LCDLR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E4)
#define DDR_PHY_DX8LCDLR4_0     0x5c010f90
#define DDR_PHY_DX8LCDLR4_1     0x5c110f90
#define DDR_PHY_DX8LCDLR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E5)
#define DDR_PHY_DX8LCDLR5_0     0x5c010f94
#define DDR_PHY_DX8LCDLR5_1     0x5c110f94
#define DDR_PHY_DX8MDLR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E8)
#define DDR_PHY_DX8MDLR0_0      0x5c010fa0
#define DDR_PHY_DX8MDLR0_1      0x5c110fa0
#define DDR_PHY_DX8MDLR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3E9)
#define DDR_PHY_DX8MDLR1_0      0x5c010fa4
#define DDR_PHY_DX8MDLR1_1      0x5c110fa4
#define DDR_PHY_DX8GTR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F0)
#define DDR_PHY_DX8GTR0_0       0x5c010fc0
#define DDR_PHY_DX8GTR0_1       0x5c110fc0
#define DDR_PHY_DX8RSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F4)
#define DDR_PHY_DX8RSR0_0       0x5c010fd0
#define DDR_PHY_DX8RSR0_1       0x5c110fd0
#define DDR_PHY_DX8RSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F5)
#define DDR_PHY_DX8RSR1_0       0x5c010fd4
#define DDR_PHY_DX8RSR1_1       0x5c110fd4
#define DDR_PHY_DX8RSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F6)
#define DDR_PHY_DX8RSR2_0       0x5c010fd8
#define DDR_PHY_DX8RSR2_1       0x5c110fd8
#define DDR_PHY_DX8RSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F7)
#define DDR_PHY_DX8RSR3_0       0x5c010fdc
#define DDR_PHY_DX8RSR3_1       0x5c110fdc
#define DDR_PHY_DX8GSR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F8)
#define DDR_PHY_DX8GSR0_0       0x5c010fe0
#define DDR_PHY_DX8GSR0_1       0x5c110fe0
#define DDR_PHY_DX8GSR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3F9)
#define DDR_PHY_DX8GSR1_0       0x5c010fe4
#define DDR_PHY_DX8GSR1_1       0x5c110fe4
#define DDR_PHY_DX8GSR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3FA)
#define DDR_PHY_DX8GSR2_0       0x5c010fe8
#define DDR_PHY_DX8GSR2_1       0x5c110fe8
#define DDR_PHY_DX8GSR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3FB)
#define DDR_PHY_DX8GSR3_0       0x5c010fec
#define DDR_PHY_DX8GSR3_1       0x5c110fec
#define DDR_PHY_DX8GSR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3FC)
#define DDR_PHY_DX8GSR4_0       0x5c010ff0
#define DDR_PHY_DX8GSR4_1       0x5c110ff0
#define DDR_PHY_DX8GSR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3FD)
#define DDR_PHY_DX8GSR5_0       0x5c010ff4
#define DDR_PHY_DX8GSR5_1       0x5c110ff4
#define DDR_PHY_DX8GSR6(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x3FE)
#define DDR_PHY_DX8GSR6_0       0x5c010ff8
#define DDR_PHY_DX8GSR6_1       0x5c110ff8
#define DDR_PHY_DX8SL0OSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x500)
#define DDR_PHY_DX8SL0OSC_0     0x5c011400
#define DDR_PHY_DX8SL0OSC_1     0x5c111400
#define DDR_PHY_DX8SL0PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x501)
#define DDR_PHY_DX8SL0PLLCR0_0  0x5c011404
#define DDR_PHY_DX8SL0PLLCR0_1  0x5c111404
#define DDR_PHY_DX8SL0PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x502)
#define DDR_PHY_DX8SL0PLLCR1_0  0x5c011408
#define DDR_PHY_DX8SL0PLLCR1_1  0x5c111408
#define DDR_PHY_DX8SL0PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x503)
#define DDR_PHY_DX8SL0PLLCR2_0  0x5c01140c
#define DDR_PHY_DX8SL0PLLCR2_1  0x5c11140c
#define DDR_PHY_DX8SL0PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x504)
#define DDR_PHY_DX8SL0PLLCR3_0  0x5c011410
#define DDR_PHY_DX8SL0PLLCR3_1  0x5c111410
#define DDR_PHY_DX8SL0PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x505)
#define DDR_PHY_DX8SL0PLLCR4_0  0x5c011414
#define DDR_PHY_DX8SL0PLLCR4_1  0x5c111414
#define DDR_PHY_DX8SL0PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x506)
#define DDR_PHY_DX8SL0PLLCR5_0  0x5c011418
#define DDR_PHY_DX8SL0PLLCR5_1  0x5c111418
#define DDR_PHY_DX8SL0DQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x507)
#define DDR_PHY_DX8SL0DQSCTL_0  0x5c01141c
#define DDR_PHY_DX8SL0DQSCTL_1  0x5c11141c
#define DDR_PHY_DX8SL0TRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x508)
#define DDR_PHY_DX8SL0TRNCTL_0  0x5c011420
#define DDR_PHY_DX8SL0TRNCTL_1  0x5c111420
#define DDR_PHY_DX8SL0DDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x509)
#define DDR_PHY_DX8SL0DDLCTL_0  0x5c011424
#define DDR_PHY_DX8SL0DDLCTL_1  0x5c111424
#define DDR_PHY_DX8SL0DXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x50A)
#define DDR_PHY_DX8SL0DXCTL1_0  0x5c011428
#define DDR_PHY_DX8SL0DXCTL1_1  0x5c111428
#define DDR_PHY_DX8SL0DXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x50B)
#define DDR_PHY_DX8SL0DXCTL2_0  0x5c01142c
#define DDR_PHY_DX8SL0DXCTL2_1  0x5c11142c
#define DDR_PHY_DX8SL0IOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x50C)
#define DDR_PHY_DX8SL0IOCR_0    0x5c011430
#define DDR_PHY_DX8SL0IOCR_1    0x5c111430
#define DDR_PHY_DX8SL1OSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x510)
#define DDR_PHY_DX8SL1OSC_0     0x5c011440
#define DDR_PHY_DX8SL1OSC_1     0x5c111440
#define DDR_PHY_DX8SL1PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x511)
#define DDR_PHY_DX8SL1PLLCR0_0  0x5c011444
#define DDR_PHY_DX8SL1PLLCR0_1  0x5c111444
#define DDR_PHY_DX8SL1PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x512)
#define DDR_PHY_DX8SL1PLLCR1_0  0x5c011448
#define DDR_PHY_DX8SL1PLLCR1_1  0x5c111448
#define DDR_PHY_DX8SL1PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x513)
#define DDR_PHY_DX8SL1PLLCR2_0  0x5c01144c
#define DDR_PHY_DX8SL1PLLCR2_1  0x5c11144c
#define DDR_PHY_DX8SL1PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x514)
#define DDR_PHY_DX8SL1PLLCR3_0  0x5c011450
#define DDR_PHY_DX8SL1PLLCR3_1  0x5c111450
#define DDR_PHY_DX8SL1PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x515)
#define DDR_PHY_DX8SL1PLLCR4_0  0x5c011454
#define DDR_PHY_DX8SL1PLLCR4_1  0x5c111454
#define DDR_PHY_DX8SL1PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x516)
#define DDR_PHY_DX8SL1PLLCR5_0  0x5c011458
#define DDR_PHY_DX8SL1PLLCR5_1  0x5c111458
#define DDR_PHY_DX8SL1DQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x517)
#define DDR_PHY_DX8SL1DQSCTL_0  0x5c01145c
#define DDR_PHY_DX8SL1DQSCTL_1  0x5c11145c
#define DDR_PHY_DX8SL1TRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x518)
#define DDR_PHY_DX8SL1TRNCTL_0  0x5c011460
#define DDR_PHY_DX8SL1TRNCTL_1  0x5c111460
#define DDR_PHY_DX8SL1DDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x519)
#define DDR_PHY_DX8SL1DDLCTL_0  0x5c011464
#define DDR_PHY_DX8SL1DDLCTL_1  0x5c111464
#define DDR_PHY_DX8SL1DXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x51A)
#define DDR_PHY_DX8SL1DXCTL1_0  0x5c011468
#define DDR_PHY_DX8SL1DXCTL1_1  0x5c111468
#define DDR_PHY_DX8SL1DXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x51B)
#define DDR_PHY_DX8SL1DXCTL2_0  0x5c01146c
#define DDR_PHY_DX8SL1DXCTL2_1  0x5c11146c
#define DDR_PHY_DX8SL1IOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x51C)
#define DDR_PHY_DX8SL1IOCR_0    0x5c011470
#define DDR_PHY_DX8SL1IOCR_1    0x5c111470
#define DDR_PHY_DX8SL2OSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x520)
#define DDR_PHY_DX8SL2OSC_0     0x5c011480
#define DDR_PHY_DX8SL2OSC_1     0x5c111480
#define DDR_PHY_DX8SL2PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x521)
#define DDR_PHY_DX8SL2PLLCR0_0  0x5c011484
#define DDR_PHY_DX8SL2PLLCR0_1  0x5c111484
#define DDR_PHY_DX8SL2PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x522)
#define DDR_PHY_DX8SL2PLLCR1_0  0x5c011488
#define DDR_PHY_DX8SL2PLLCR1_1  0x5c111488
#define DDR_PHY_DX8SL2PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x523)
#define DDR_PHY_DX8SL2PLLCR2_0  0x5c01148c
#define DDR_PHY_DX8SL2PLLCR2_1  0x5c11148c
#define DDR_PHY_DX8SL2PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x524)
#define DDR_PHY_DX8SL2PLLCR3_0  0x5c011490
#define DDR_PHY_DX8SL2PLLCR3_1  0x5c111490
#define DDR_PHY_DX8SL2PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x525)
#define DDR_PHY_DX8SL2PLLCR4_0  0x5c011494
#define DDR_PHY_DX8SL2PLLCR4_1  0x5c111494
#define DDR_PHY_DX8SL2PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x526)
#define DDR_PHY_DX8SL2PLLCR5_0  0x5c011498
#define DDR_PHY_DX8SL2PLLCR5_1  0x5c111498
#define DDR_PHY_DX8SL2DQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x527)
#define DDR_PHY_DX8SL2DQSCTL_0  0x5c01149c
#define DDR_PHY_DX8SL2DQSCTL_1  0x5c11149c
#define DDR_PHY_DX8SL2TRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x528)
#define DDR_PHY_DX8SL2TRNCTL_0  0x5c0114a0
#define DDR_PHY_DX8SL2TRNCTL_1  0x5c1114a0
#define DDR_PHY_DX8SL2DDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x529)
#define DDR_PHY_DX8SL2DDLCTL_0  0x5c0114a4
#define DDR_PHY_DX8SL2DDLCTL_1  0x5c1114a4
#define DDR_PHY_DX8SL2DXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x52A)
#define DDR_PHY_DX8SL2DXCTL1_0  0x5c0114a8
#define DDR_PHY_DX8SL2DXCTL1_1  0x5c1114a8
#define DDR_PHY_DX8SL2DXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x52B)
#define DDR_PHY_DX8SL2DXCTL2_0  0x5c0114ac
#define DDR_PHY_DX8SL2DXCTL2_1  0x5c1114ac
#define DDR_PHY_DX8SL2IOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x52C)
#define DDR_PHY_DX8SL2IOCR_0    0x5c0114b0
#define DDR_PHY_DX8SL2IOCR_1    0x5c1114b0
#define DDR_PHY_DX8SL3OSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x530)
#define DDR_PHY_DX8SL3OSC_0     0x5c0114c0
#define DDR_PHY_DX8SL3OSC_1     0x5c1114c0
#define DDR_PHY_DX8SL3PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x531)
#define DDR_PHY_DX8SL3PLLCR0_0  0x5c0114c4
#define DDR_PHY_DX8SL3PLLCR0_1  0x5c1114c4
#define DDR_PHY_DX8SL3PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x532)
#define DDR_PHY_DX8SL3PLLCR1_0  0x5c0114c8
#define DDR_PHY_DX8SL3PLLCR1_1  0x5c1114c8
#define DDR_PHY_DX8SL3PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x533)
#define DDR_PHY_DX8SL3PLLCR2_0  0x5c0114cc
#define DDR_PHY_DX8SL3PLLCR2_1  0x5c1114cc
#define DDR_PHY_DX8SL3PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x534)
#define DDR_PHY_DX8SL3PLLCR3_0  0x5c0114d0
#define DDR_PHY_DX8SL3PLLCR3_1  0x5c1114d0
#define DDR_PHY_DX8SL3PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x535)
#define DDR_PHY_DX8SL3PLLCR4_0  0x5c0114d4
#define DDR_PHY_DX8SL3PLLCR4_1  0x5c1114d4
#define DDR_PHY_DX8SL3PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x536)
#define DDR_PHY_DX8SL3PLLCR5_0  0x5c0114d8
#define DDR_PHY_DX8SL3PLLCR5_1  0x5c1114d8
#define DDR_PHY_DX8SL3DQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x537)
#define DDR_PHY_DX8SL3DQSCTL_0  0x5c0114dc
#define DDR_PHY_DX8SL3DQSCTL_1  0x5c1114dc
#define DDR_PHY_DX8SL3TRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x538)
#define DDR_PHY_DX8SL3TRNCTL_0  0x5c0114e0
#define DDR_PHY_DX8SL3TRNCTL_1  0x5c1114e0
#define DDR_PHY_DX8SL3DDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x539)
#define DDR_PHY_DX8SL3DDLCTL_0  0x5c0114e4
#define DDR_PHY_DX8SL3DDLCTL_1  0x5c1114e4
#define DDR_PHY_DX8SL3DXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x53A)
#define DDR_PHY_DX8SL3DXCTL1_0  0x5c0114e8
#define DDR_PHY_DX8SL3DXCTL1_1  0x5c1114e8
#define DDR_PHY_DX8SL3DXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x53B)
#define DDR_PHY_DX8SL3DXCTL2_0  0x5c0114ec
#define DDR_PHY_DX8SL3DXCTL2_1  0x5c1114ec
#define DDR_PHY_DX8SL3IOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x53C)
#define DDR_PHY_DX8SL3IOCR_0    0x5c0114f0
#define DDR_PHY_DX8SL3IOCR_1    0x5c1114f0
#define DDR_PHY_DX8SL4OSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x540)
#define DDR_PHY_DX8SL4OSC_0     0x5c011500
#define DDR_PHY_DX8SL4OSC_1     0x5c111500
#define DDR_PHY_DX8SL4PLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x541)
#define DDR_PHY_DX8SL4PLLCR0_0  0x5c011504
#define DDR_PHY_DX8SL4PLLCR0_1  0x5c111504
#define DDR_PHY_DX8SL4PLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x542)
#define DDR_PHY_DX8SL4PLLCR1_0  0x5c011508
#define DDR_PHY_DX8SL4PLLCR1_1  0x5c111508
#define DDR_PHY_DX8SL4PLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x543)
#define DDR_PHY_DX8SL4PLLCR2_0  0x5c01150c
#define DDR_PHY_DX8SL4PLLCR2_1  0x5c11150c
#define DDR_PHY_DX8SL4PLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x544)
#define DDR_PHY_DX8SL4PLLCR3_0  0x5c011510
#define DDR_PHY_DX8SL4PLLCR3_1  0x5c111510
#define DDR_PHY_DX8SL4PLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x545)
#define DDR_PHY_DX8SL4PLLCR4_0  0x5c011514
#define DDR_PHY_DX8SL4PLLCR4_1  0x5c111514
#define DDR_PHY_DX8SL4PLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x546)
#define DDR_PHY_DX8SL4PLLCR5_0  0x5c011518
#define DDR_PHY_DX8SL4PLLCR5_1  0x5c111518
#define DDR_PHY_DX8SL4DQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x547)
#define DDR_PHY_DX8SL4DQSCTL_0  0x5c01151c
#define DDR_PHY_DX8SL4DQSCTL_1  0x5c11151c
#define DDR_PHY_DX8SL4TRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x548)
#define DDR_PHY_DX8SL4TRNCTL_0  0x5c011520
#define DDR_PHY_DX8SL4TRNCTL_1  0x5c111520
#define DDR_PHY_DX8SL4DDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x549)
#define DDR_PHY_DX8SL4DDLCTL_0  0x5c011524
#define DDR_PHY_DX8SL4DDLCTL_1  0x5c111524
#define DDR_PHY_DX8SL4DXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x54A)
#define DDR_PHY_DX8SL4DXCTL1_0  0x5c011528
#define DDR_PHY_DX8SL4DXCTL1_1  0x5c111528
#define DDR_PHY_DX8SL4DXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x54B)
#define DDR_PHY_DX8SL4DXCTL2_0  0x5c01152c
#define DDR_PHY_DX8SL4DXCTL2_1  0x5c11152c
#define DDR_PHY_DX8SL4IOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x54C)
#define DDR_PHY_DX8SL4IOCR_0    0x5c011530
#define DDR_PHY_DX8SL4IOCR_1    0x5c111530
#define DDR_PHY_DX8SLbOSC(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F0)
#define DDR_PHY_DX8SLbOSC_0     0x5c0117c0
#define DDR_PHY_DX8SLbOSC_1     0x5c1117c0
#define DDR_PHY_DX8SLbPLLCR0(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F1)
#define DDR_PHY_DX8SLbPLLCR0_0  0x5c0117c4
#define DDR_PHY_DX8SLbPLLCR0_1  0x5c1117c4
#define DDR_PHY_DX8SLbPLLCR1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F2)
#define DDR_PHY_DX8SLbPLLCR1_0  0x5c0117c8
#define DDR_PHY_DX8SLbPLLCR1_1  0x5c1117c8
#define DDR_PHY_DX8SLbPLLCR2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F3)
#define DDR_PHY_DX8SLbPLLCR2_0  0x5c0117cc
#define DDR_PHY_DX8SLbPLLCR2_1  0x5c1117cc
#define DDR_PHY_DX8SLbPLLCR3(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F4)
#define DDR_PHY_DX8SLbPLLCR3_0  0x5c0117d0
#define DDR_PHY_DX8SLbPLLCR3_1  0x5c1117d0
#define DDR_PHY_DX8SLbPLLCR4(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F5)
#define DDR_PHY_DX8SLbPLLCR4_0  0x5c0117d4
#define DDR_PHY_DX8SLbPLLCR4_1  0x5c1117d4
#define DDR_PHY_DX8SLbPLLCR5(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F6)
#define DDR_PHY_DX8SLbPLLCR5_0  0x5c0117d8
#define DDR_PHY_DX8SLbPLLCR5_1  0x5c1117d8
#define DDR_PHY_DX8SLbDQSCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F7)
#define DDR_PHY_DX8SLbDQSCTL_0  0x5c0117dc
#define DDR_PHY_DX8SLbDQSCTL_1  0x5c1117dc
#define DDR_PHY_DX8SLbTRNCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F8)
#define DDR_PHY_DX8SLbTRNCTL_0  0x5c0117e0
#define DDR_PHY_DX8SLbTRNCTL_1  0x5c1117e0
#define DDR_PHY_DX8SLbDDLCTL(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5F9)
#define DDR_PHY_DX8SLbDDLCTL_0  0x5c0117e4
#define DDR_PHY_DX8SLbDDLCTL_1  0x5c1117e4
#define DDR_PHY_DX8SLbDXCTL1(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5FA)
#define DDR_PHY_DX8SLbDXCTL1_0  0x5c0117e8
#define DDR_PHY_DX8SLbDXCTL1_1  0x5c1117e8
#define DDR_PHY_DX8SLbDXCTL2(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5FB)
#define DDR_PHY_DX8SLbDXCTL2_0  0x5c0117ec
#define DDR_PHY_DX8SLbDXCTL2_1  0x5c1117ec
#define DDR_PHY_DX8SLbIOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5FC)
#define DDR_PHY_DX8SLbIOCR_0    0x5c0117f0
#define DDR_PHY_DX8SLbIOCR_1    0x5c1117f0
#define DDR_PHY_DX4SLbIOCR(X)		REG32(DDR_PHY_BASE_ADDR(X) + 4*0x5FD)
#define DDR_PHY_DX4SLbIOCR_0    0x5c0117f4
#define DDR_PHY_DX4SLbIOCR_1    0x5c1117f4

#endif
