#define DDRC_DDR_SS_GPR0         0x3d000000

#define DDRC_IPS_BASE_ADDR(X) (0x3d400000 + (X * 0x2000000))
#define DDRC_IPS_BASE_ADDR_0	0x3f400000

#define DDRC_MSTR_0             0x3d400000
#define DDRC_STAT_0             0x3d400004
#define DDRC_MSTR1_0            0x3d400008
#define DDRC_MRCTRL0_0          0x3d400010
#define DDRC_MRCTRL1_0          0x3d400014
#define DDRC_MRSTAT_0           0x3d400018
#define DDRC_MRCTRL2_0          0x3d40001c
#define DDRC_DERATEEN_0         0x3d400020
#define DDRC_DERATEINT_0        0x3d400024
#define DDRC_MSTR2_0            0x3d400028
#define DDRC_PWRCTL_0           0x3d400030
#define DDRC_PWRTMG_0           0x3d400034
#define DDRC_HWLPCTL_0          0x3d400038
#define DDRC_HWFFCCTL_0         0x3d40003c
#define DDRC_HWFFCSTAT_0        0x3d400040
#define DDRC_RFSHCTL0_0         0x3d400050
#define DDRC_RFSHCTL1_0         0x3d400054
#define DDRC_RFSHCTL2_0         0x3d400058
#define DDRC_RFSHCTL3_0         0x3d400060
#define DDRC_RFSHTMG_0          0x3d400064
#define DDRC_ECCCFG0_0          0x3d400070
#define DDRC_ECCCFG1_0          0x3d400074
#define DDRC_ECCSTAT_0          0x3d400078
#define DDRC_ECCCLR_0           0x3d40007c
#define DDRC_ECCERRCNT_0        0x3d400080
#define DDRC_ECCCADDR0_0        0x3d400084
#define DDRC_ECCCADDR1_0        0x3d400088
#define DDRC_ECCCSYN0_0         0x3d40008c
#define DDRC_ECCCSYN1_0         0x3d400090
#define DDRC_ECCCSYN2_0         0x3d400094
#define DDRC_ECCBITMASK0_0      0x3d400098
#define DDRC_ECCBITMASK1_0      0x3d40009c
#define DDRC_ECCBITMASK2_0      0x3d4000a0
#define DDRC_ECCUADDR0_0        0x3d4000a4
#define DDRC_ECCUADDR1_0        0x3d4000a8
#define DDRC_ECCUSYN0_0         0x3d4000ac
#define DDRC_ECCUSYN1_0         0x3d4000b0
#define DDRC_ECCUSYN2_0         0x3d4000b4
#define DDRC_ECCPOISONADDR0_0   0x3d4000b8
#define DDRC_ECCPOISONADDR1_0   0x3d4000bc
#define DDRC_CRCPARCTL0_0       0x3d4000c0
#define DDRC_CRCPARCTL1_0       0x3d4000c4
#define DDRC_CRCPARCTL2_0       0x3d4000c8
#define DDRC_CRCPARSTAT_0       0x3d4000cc
#define DDRC_INIT0_0            0x3d4000d0
#define DDRC_INIT1_0            0x3d4000d4
#define DDRC_INIT2_0            0x3d4000d8
#define DDRC_INIT3_0            0x3d4000dc
#define DDRC_INIT4_0            0x3d4000e0
#define DDRC_INIT5_0            0x3d4000e4
#define DDRC_INIT6_0            0x3d4000e8
#define DDRC_INIT7_0            0x3d4000ec
#define DDRC_DIMMCTL_0          0x3d4000f0
#define DDRC_RANKCTL_0          0x3d4000f4
#define DDRC_DRAMTMG0_0         0x3d400100
#define DDRC_DRAMTMG1_0         0x3d400104
#define DDRC_DRAMTMG2_0         0x3d400108
#define DDRC_DRAMTMG3_0         0x3d40010c
#define DDRC_DRAMTMG4_0         0x3d400110
#define DDRC_DRAMTMG5_0         0x3d400114
#define DDRC_DRAMTMG6_0         0x3d400118
#define DDRC_DRAMTMG7_0         0x3d40011c
#define DDRC_DRAMTMG8_0         0x3d400120
#define DDRC_DRAMTMG9_0         0x3d400124
#define DDRC_DRAMTMG10_0        0x3d400128
#define DDRC_DRAMTMG11_0        0x3d40012c
#define DDRC_DRAMTMG12_0        0x3d400130
#define DDRC_DRAMTMG13_0        0x3d400134
#define DDRC_DRAMTMG14_0        0x3d400138
#define DDRC_DRAMTMG15_0        0x3d40013C
#define DDRC_DRAMTMG16_0        0x3d400140
#define DDRC_DRAMTMG17_0        0x3d400144
//
#define DDRC_ZQCTL0_0           0x3d400180
#define DDRC_ZQCTL1_0           0x3d400184
#define DDRC_ZQCTL2_0           0x3d400188
#define DDRC_ZQSTAT_0           0x3d40018c
#define DDRC_DFITMG0_0          0x3d400190
#define DDRC_DFITMG1_0          0x3d400194
#define DDRC_DFILPCFG0_0        0x3d400198
#define DDRC_DFILPCFG1_0        0x3d40019c
#define DDRC_DFIUPD0_0          0x3d4001a0
#define DDRC_DFIUPD1_0          0x3d4001a4
#define DDRC_DFIUPD2_0          0x3d4001a8
//#define DDRC_DFIUPD3(X)       (  DDRC_IPS_BASE_ADDR(X) + 0x1ac)     // iMX8 hasn't it
#define DDRC_DFIMISC_0          0x3d4001b0
#define DDRC_DFITMG2_0          0x3d4001b4
#define DDRC_DFITMG3_0          0x3d4001b8
#define DDRC_DFISTAT_0          0x3d4001bc
//
#define DDRC_DBICTL_0           0x3d4001c0
#define DDRC_DFIPHYMSTR_0       0x3d4001c4
#define DDRC_TRAINCTL0_0        0x3d4001d0
#define DDRC_TRAINCTL1_0        0x3d4001d4
#define DDRC_TRAINCTL2_0        0x3d4001d8
#define DDRC_TRAINSTAT_0        0x3d4001dc
#define DDRC_ADDRMAP0_0         0x3d400200
#define DDRC_ADDRMAP1_0         0x3d400204
#define DDRC_ADDRMAP2_0         0x3d400208
#define DDRC_ADDRMAP3_0         0x3d40020c
#define DDRC_ADDRMAP4_0         0x3d400210
#define DDRC_ADDRMAP5_0         0x3d400214
#define DDRC_ADDRMAP6_0         0x3d400218
#define DDRC_ADDRMAP7_0         0x3d40021c
#define DDRC_ADDRMAP8_0         0x3d400220
#define DDRC_ADDRMAP9_0         0x3d400224
#define DDRC_ADDRMAP10_0        0x3d400228
#define DDRC_ADDRMAP11_0        0x3d40022c
//
#define DDRC_ODTCFG_0           0x3d400240
#define DDRC_ODTMAP_0           0x3d400244
#define DDRC_SCHED_0            0x3d400250
#define DDRC_SCHED1_0           0x3d400254
#define DDRC_PERFHPR1_0         0x3d40025c
#define DDRC_PERFLPR1_0         0x3d400264
#define DDRC_PERFWR1_0          0x3d40026c
#define DDRC_PERFVPR1_0         0x3d400274
//
#define DDRC_PERFVPW1_0         0x3d400278
//
#define DDRC_DQMAP0_0           0x3d400280
#define DDRC_DQMAP1_0           0x3d400284
#define DDRC_DQMAP2_0           0x3d400288
#define DDRC_DQMAP3_0           0x3d40028c
#define DDRC_DQMAP4_0           0x3d400290
#define DDRC_DQMAP5_0           0x3d400294
#define DDRC_DBG0_0             0x3d400300
#define DDRC_DBG1_0             0x3d400304
#define DDRC_DBGCAM_0           0x3d400308
#define DDRC_DBGCMD_0           0x3d40030c
#define DDRC_DBGSTAT_0          0x3d400310
//
#define DDRC_SWCTL_0            0x3d400320
#define DDRC_SWSTAT_0           0x3d400324
#define DDRC_OCPARCFG0_0        0x3d400330
#define DDRC_OCPARCFG1_0        0x3d400334
#define DDRC_OCPARCFG2_0        0x3d400338
#define DDRC_OCPARCFG3_0        0x3d40033c
#define DDRC_OCPARSTAT0_0       0x3d400340
#define DDRC_OCPARSTAT1_0       0x3d400344
#define DDRC_OCPARWLOG0_0       0x3d400348
#define DDRC_OCPARWLOG1_0       0x3d40034c
#define DDRC_OCPARWLOG2_0       0x3d400350
#define DDRC_OCPARAWLOG0_0      0x3d400354
#define DDRC_OCPARAWLOG1_0      0x3d400358
#define DDRC_OCPARRLOG0_0       0x3d40035c
#define DDRC_OCPARRLOG1_0       0x3d400360
#define DDRC_OCPARARLOG0_0      0x3d400364
#define DDRC_OCPARARLOG1_0      0x3d400368
#define DDRC_POISONCFG_0        0x3d40036C
#define DDRC_POISONSTAT_0       0x3d400370
#define DDRC_ADVECCINDEX_0      0x3d400003
#define DDRC_ADVECCSTAT_0       0x3d400003
#define DDRC_ECCPOISONPAT0_0    0x3d400003
#define DDRC_ECCPOISONPAT1_0    0x3d400003
#define DDRC_ECCPOISONPAT2_0    0x3d400003
#define DDRC_HIFCTL_0           0x3d400003

#define DDRC_PSTAT_0            0x3d4003fc
#define DDRC_PCCFG_0            0x3d400400
#define DDRC_PCFGR_0_0          0x3d400404
#define DDRC_PCFGR_1_0          0x3d4004b4
#define DDRC_PCFGR_2_0          0x3d400564
#define DDRC_PCFGR_3_0          0x3d400614
#define DDRC_PCFGW_0_0          0x3d400408
#define DDRC_PCFGW_1_0          0x3d400408
#define DDRC_PCFGW_2_0          0x3d400568
#define DDRC_PCFGW_3_0          0x3d400618
#define DDRC_PCFGC_0_0          0x3d40040c
#define DDRC_PCFGIDMASKCH_0     0x3d400410
#define DDRC_PCFGIDVALUECH_0    0x3d400414
#define DDRC_PCTRL_0_0          0x3d400490
#define DDRC_PCTRL_1_0          0x3d400540
#define DDRC_PCTRL_2_0          0x3d4005f0
#define DDRC_PCTRL_3_0          0x3d4006a0
#define DDRC_PCFGQOS0_0_0       0x3d400494
#define DDRC_PCFGQOS1_0_0       0x3d400498
#define DDRC_PCFGWQOS0_0_0      0x3d40049c
#define DDRC_PCFGWQOS1_0_0      0x3d4004a0
#define DDRC_SARBASE0_0         0x3d400f04
#define DDRC_SARSIZE0_0         0x3d400f08
#define DDRC_SBRCTL_0           0x3d400f24
#define DDRC_SBRSTAT_0          0x3d400f28
#define DDRC_SBRWDATA0_0        0x3d400f2c
#define DDRC_SBRWDATA1_0        0x3d400f30
#define DDRC_PDCH_0             0x3d400f34

/**********************/
#define DDRC_MSTR(X)             (DDRC_IPS_BASE_ADDR(X) + 0x00)
#define DDRC_STAT(X)             (DDRC_IPS_BASE_ADDR(X) + 0x04)
#define DDRC_MSTR1(X)            (DDRC_IPS_BASE_ADDR(X) + 0x08)
#define DDRC_MRCTRL0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x10)
#define DDRC_MRCTRL1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x14)
#define DDRC_MRSTAT(X)           (DDRC_IPS_BASE_ADDR(X) + 0x18)
#define DDRC_MRCTRL2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1c)
#define DDRC_DERATEEN(X)         (DDRC_IPS_BASE_ADDR(X) + 0x20)
#define DDRC_DERATEINT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x24)
#define DDRC_MSTR2(X)            (DDRC_IPS_BASE_ADDR(X) + 0x28)
#define DDRC_PWRCTL(X)           (DDRC_IPS_BASE_ADDR(X) + 0x30)
#define DDRC_PWRTMG(X)           (DDRC_IPS_BASE_ADDR(X) + 0x34)
#define DDRC_HWLPCTL(X)          (DDRC_IPS_BASE_ADDR(X) + 0x38)
#define DDRC_HWFFCCTL(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3c)
#define DDRC_HWFFCSTAT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x40)
#define DDRC_RFSHCTL0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x50)
#define DDRC_RFSHCTL1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x54)
#define DDRC_RFSHCTL2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x58)
#define DDRC_RFSHCTL3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x60)
#define DDRC_RFSHTMG(X)          (DDRC_IPS_BASE_ADDR(X) + 0x64)
#define DDRC_ECCCFG0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x70)
#define DDRC_ECCCFG1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x74)
#define DDRC_ECCSTAT(X)          (DDRC_IPS_BASE_ADDR(X) + 0x78)
#define DDRC_ECCCLR(X)           (DDRC_IPS_BASE_ADDR(X) + 0x7c)
#define DDRC_ECCERRCNT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x80)
#define DDRC_ECCCADDR0(X)        (DDRC_IPS_BASE_ADDR(X) + 0x84)
#define DDRC_ECCCADDR1(X)        (DDRC_IPS_BASE_ADDR(X) + 0x88)
#define DDRC_ECCCSYN0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x8c)
#define DDRC_ECCCSYN1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x90)
#define DDRC_ECCCSYN2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x94)
#define DDRC_ECCBITMASK0(X)      (DDRC_IPS_BASE_ADDR(X) + 0x98)
#define DDRC_ECCBITMASK1(X)      (DDRC_IPS_BASE_ADDR(X) + 0x9c)
#define DDRC_ECCBITMASK2(X)      (DDRC_IPS_BASE_ADDR(X) + 0xa0)
#define DDRC_ECCUADDR0(X)        (DDRC_IPS_BASE_ADDR(X) + 0xa4)
#define DDRC_ECCUADDR1(X)        (DDRC_IPS_BASE_ADDR(X) + 0xa8)
#define DDRC_ECCUSYN0(X)         (DDRC_IPS_BASE_ADDR(X) + 0xac)
#define DDRC_ECCUSYN1(X)         (DDRC_IPS_BASE_ADDR(X) + 0xb0)
#define DDRC_ECCUSYN2(X)         (DDRC_IPS_BASE_ADDR(X) + 0xb4)
#define DDRC_ECCPOISONADDR0(X)   (DDRC_IPS_BASE_ADDR(X) + 0xb8)
#define DDRC_ECCPOISONADDR1(X)   (DDRC_IPS_BASE_ADDR(X) + 0xbc)
#define DDRC_CRCPARCTL0(X)       (DDRC_IPS_BASE_ADDR(X) + 0xc0)
#define DDRC_CRCPARCTL1(X)       (DDRC_IPS_BASE_ADDR(X) + 0xc4)
#define DDRC_CRCPARCTL2(X)       (DDRC_IPS_BASE_ADDR(X) + 0xc8)
#define DDRC_CRCPARSTAT(X)       (DDRC_IPS_BASE_ADDR(X) + 0xcc)
#define DDRC_INIT0(X)            (DDRC_IPS_BASE_ADDR(X) + 0xd0)
#define DDRC_INIT1(X)            (DDRC_IPS_BASE_ADDR(X) + 0xd4)
#define DDRC_INIT2(X)            (DDRC_IPS_BASE_ADDR(X) + 0xd8)
#define DDRC_INIT3(X)            (DDRC_IPS_BASE_ADDR(X) + 0xdc)
#define DDRC_INIT4(X)            (DDRC_IPS_BASE_ADDR(X) + 0xe0)
#define DDRC_INIT5(X)            (DDRC_IPS_BASE_ADDR(X) + 0xe4)
#define DDRC_INIT6(X)            (DDRC_IPS_BASE_ADDR(X) + 0xe8)
#define DDRC_INIT7(X)            (DDRC_IPS_BASE_ADDR(X) + 0xec)
#define DDRC_DIMMCTL(X)          (DDRC_IPS_BASE_ADDR(X) + 0xf0)
#define DDRC_RANKCTL(X)          (DDRC_IPS_BASE_ADDR(X) + 0xf4)
#define DDRC_DRAMTMG0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x100)
#define DDRC_DRAMTMG1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x104)
#define DDRC_DRAMTMG2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x108)
#define DDRC_DRAMTMG3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x10c)
#define DDRC_DRAMTMG4(X)         (DDRC_IPS_BASE_ADDR(X) + 0x110)
#define DDRC_DRAMTMG5(X)         (DDRC_IPS_BASE_ADDR(X) + 0x114)
#define DDRC_DRAMTMG6(X)         (DDRC_IPS_BASE_ADDR(X) + 0x118)
#define DDRC_DRAMTMG7(X)         (DDRC_IPS_BASE_ADDR(X) + 0x11c)
#define DDRC_DRAMTMG8(X)         (DDRC_IPS_BASE_ADDR(X) + 0x120)
#define DDRC_DRAMTMG9(X)         (DDRC_IPS_BASE_ADDR(X) + 0x124)
#define DDRC_DRAMTMG10(X)        (DDRC_IPS_BASE_ADDR(X) + 0x128)
#define DDRC_DRAMTMG11(X)        (DDRC_IPS_BASE_ADDR(X) + 0x12c)
#define DDRC_DRAMTMG12(X)        (DDRC_IPS_BASE_ADDR(X) + 0x130)
#define DDRC_DRAMTMG13(X)        (DDRC_IPS_BASE_ADDR(X) + 0x134)
#define DDRC_DRAMTMG14(X)        (DDRC_IPS_BASE_ADDR(X) + 0x138)
#define DDRC_DRAMTMG15(X)        (DDRC_IPS_BASE_ADDR(X) + 0x13C)
#define DDRC_DRAMTMG16(X)        (DDRC_IPS_BASE_ADDR(X) + 0x140)
#define DDRC_DRAMTMG17(X)        (DDRC_IPS_BASE_ADDR(X) + 0x144)
//
#define DDRC_ZQCTL0(X)           (DDRC_IPS_BASE_ADDR(X) + 0x180)
#define DDRC_ZQCTL1(X)           (DDRC_IPS_BASE_ADDR(X) + 0x184)
#define DDRC_ZQCTL2(X)           (DDRC_IPS_BASE_ADDR(X) + 0x188)
#define DDRC_ZQSTAT(X)           (DDRC_IPS_BASE_ADDR(X) + 0x18c)
#define DDRC_DFITMG0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x190)
#define DDRC_DFITMG1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x194)
#define DDRC_DFILPCFG0(X)        (DDRC_IPS_BASE_ADDR(X) + 0x198)
#define DDRC_DFILPCFG1(X)        (DDRC_IPS_BASE_ADDR(X) + 0x19c)
#define DDRC_DFIUPD0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1a0)
#define DDRC_DFIUPD1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1a4)
#define DDRC_DFIUPD2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1a8)
//#define DDRC_DFIUPD3(X)        (  DDRC_IPS_BASE_ADDR(X) + 0x1ac)     // iMX8 hasn't it
#define DDRC_DFIMISC(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1b0)
#define DDRC_DFITMG2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1b4)
#define DDRC_DFITMG3(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1b8)
#define DDRC_DFISTAT(X)          (DDRC_IPS_BASE_ADDR(X) + 0x1bc)
//
#define DDRC_DBICTL(X)           (DDRC_IPS_BASE_ADDR(X) + 0x1c0)
#define DDRC_DFIPHYMSTR(X)       (DDRC_IPS_BASE_ADDR(X) + 0x1c4)
#define DDRC_TRAINCTL0(X)        (DDRC_IPS_BASE_ADDR(X) + 0x1d0)
#define DDRC_TRAINCTL1(X)        (DDRC_IPS_BASE_ADDR(X) + 0x1d4)
#define DDRC_TRAINCTL2(X)        (DDRC_IPS_BASE_ADDR(X) + 0x1d8)
#define DDRC_TRAINSTAT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x1dc)
#define DDRC_ADDRMAP0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x200)
#define DDRC_ADDRMAP1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x204)
#define DDRC_ADDRMAP2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x208)
#define DDRC_ADDRMAP3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x20c)
#define DDRC_ADDRMAP4(X)         (DDRC_IPS_BASE_ADDR(X) + 0x210)
#define DDRC_ADDRMAP5(X)         (DDRC_IPS_BASE_ADDR(X) + 0x214)
#define DDRC_ADDRMAP6(X)         (DDRC_IPS_BASE_ADDR(X) + 0x218)
#define DDRC_ADDRMAP7(X)         (DDRC_IPS_BASE_ADDR(X) + 0x21c)
#define DDRC_ADDRMAP8(X)         (DDRC_IPS_BASE_ADDR(X) + 0x220)
#define DDRC_ADDRMAP9(X)         (DDRC_IPS_BASE_ADDR(X) + 0x224)
#define DDRC_ADDRMAP10(X)        (DDRC_IPS_BASE_ADDR(X) + 0x228)
#define DDRC_ADDRMAP11(X)        (DDRC_IPS_BASE_ADDR(X) + 0x22c)
//
#define DDRC_ODTCFG(X)           (DDRC_IPS_BASE_ADDR(X) + 0x240)
#define DDRC_ODTMAP(X)           (DDRC_IPS_BASE_ADDR(X) + 0x244)
#define DDRC_SCHED(X)            (DDRC_IPS_BASE_ADDR(X) + 0x250)
#define DDRC_SCHED1(X)           (DDRC_IPS_BASE_ADDR(X) + 0x254)
#define DDRC_PERFHPR1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x25c)
#define DDRC_PERFLPR1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x264)
#define DDRC_PERFWR1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x26c)
#define DDRC_PERFVPR1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x274)
//
#define DDRC_PERFVPW1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x278)
//
#define DDRC_DQMAP0(X)           (DDRC_IPS_BASE_ADDR(X) + 0x280)
#define DDRC_DQMAP1(X)           (DDRC_IPS_BASE_ADDR(X) + 0x284)
#define DDRC_DQMAP2(X)           (DDRC_IPS_BASE_ADDR(X) + 0x288)
#define DDRC_DQMAP3(X)           (DDRC_IPS_BASE_ADDR(X) + 0x28c)
#define DDRC_DQMAP4(X)           (DDRC_IPS_BASE_ADDR(X) + 0x290)
#define DDRC_DQMAP5(X)           (DDRC_IPS_BASE_ADDR(X) + 0x294)
#define DDRC_DBG0(X)             (DDRC_IPS_BASE_ADDR(X) + 0x300)
#define DDRC_DBG1(X)             (DDRC_IPS_BASE_ADDR(X) + 0x304)
#define DDRC_DBGCAM(X)           (DDRC_IPS_BASE_ADDR(X) + 0x308)
#define DDRC_DBGCMD(X)           (DDRC_IPS_BASE_ADDR(X) + 0x30c)
#define DDRC_DBGSTAT(X)          (DDRC_IPS_BASE_ADDR(X) + 0x310)
//
#define DDRC_SWCTL(X)            (DDRC_IPS_BASE_ADDR(X) + 0x320)
#define DDRC_SWSTAT(X)           (DDRC_IPS_BASE_ADDR(X) + 0x324)
#define DDRC_OCPARCFG0(X)        (DDRC_IPS_BASE_ADDR(X) + 0x330)
#define DDRC_OCPARCFG1(X)        (DDRC_IPS_BASE_ADDR(X) + 0x334)
#define DDRC_OCPARCFG2(X)        (DDRC_IPS_BASE_ADDR(X) + 0x338)
#define DDRC_OCPARCFG3(X)        (DDRC_IPS_BASE_ADDR(X) + 0x33c)
#define DDRC_OCPARSTAT0(X)       (DDRC_IPS_BASE_ADDR(X) + 0x340)
#define DDRC_OCPARSTAT1(X)       (DDRC_IPS_BASE_ADDR(X) + 0x344)
#define DDRC_OCPARWLOG0(X)       (DDRC_IPS_BASE_ADDR(X) + 0x348)
#define DDRC_OCPARWLOG1(X)       (DDRC_IPS_BASE_ADDR(X) + 0x34c)
#define DDRC_OCPARWLOG2(X)       (DDRC_IPS_BASE_ADDR(X) + 0x350)
#define DDRC_OCPARAWLOG0(X)      (DDRC_IPS_BASE_ADDR(X) + 0x354)
#define DDRC_OCPARAWLOG1(X)      (DDRC_IPS_BASE_ADDR(X) + 0x358)
#define DDRC_OCPARRLOG0(X)       (DDRC_IPS_BASE_ADDR(X) + 0x35c)
#define DDRC_OCPARRLOG1(X)       (DDRC_IPS_BASE_ADDR(X) + 0x360)
#define DDRC_OCPARARLOG0(X)      (DDRC_IPS_BASE_ADDR(X) + 0x364)
#define DDRC_OCPARARLOG1(X)      (DDRC_IPS_BASE_ADDR(X) + 0x368)
#define DDRC_POISONCFG(X)        (DDRC_IPS_BASE_ADDR(X) + 0x36C)
#define DDRC_POISONSTAT(X)       (DDRC_IPS_BASE_ADDR(X) + 0x370)
#define DDRC_ADVECCINDEX(X)      (DDRC_IPS_BASE_ADDR(X) + 0x3)
#define DDRC_ADVECCSTAT(X)       (DDRC_IPS_BASE_ADDR(X) + 0x3)
#define DDRC_ECCPOISONPAT0(X)    (DDRC_IPS_BASE_ADDR(X) + 0x3)
#define DDRC_ECCPOISONPAT1(X)    (DDRC_IPS_BASE_ADDR(X) + 0x3)
#define DDRC_ECCPOISONPAT2(X)    (DDRC_IPS_BASE_ADDR(X) + 0x3)
#define DDRC_HIFCTL(X)           (DDRC_IPS_BASE_ADDR(X) + 0x3)

#define DDRC_PSTAT(X)            (DDRC_IPS_BASE_ADDR(X) + 0x3fc)
#define DDRC_PCCFG(X)            (DDRC_IPS_BASE_ADDR(X) + 0x400)
#define DDRC_PCFGR_0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x404)
#define DDRC_PCFGR_1(X)          (DDRC_IPS_BASE_ADDR(X) + 1*0xb0+0x404)
#define DDRC_PCFGR_2(X)          (DDRC_IPS_BASE_ADDR(X) + 2*0xb0+0x404)
#define DDRC_PCFGR_3(X)          (DDRC_IPS_BASE_ADDR(X) + 3*0xb0+0x404)
#define DDRC_PCFGW_0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x408)
#define DDRC_PCFGW_1(X)          (DDRC_IPS_BASE_ADDR(X) + 1*0xb0+0x408)
#define DDRC_PCFGW_2(X)          (DDRC_IPS_BASE_ADDR(X) + 2*0xb0+0x408)
#define DDRC_PCFGW_3(X)          (DDRC_IPS_BASE_ADDR(X) + 3*0xb0+0x408)
#define DDRC_PCFGC_0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x40c)
#define DDRC_PCFGIDMASKCH(X)     (DDRC_IPS_BASE_ADDR(X) + 0x410)
#define DDRC_PCFGIDVALUECH(X)    (DDRC_IPS_BASE_ADDR(X) + 0x414)
#define DDRC_PCTRL_0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x490)
#define DDRC_PCTRL_1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x490 + 1*0xb0)
#define DDRC_PCTRL_2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x490 + 2*0xb0)
#define DDRC_PCTRL_3(X)          (DDRC_IPS_BASE_ADDR(X) + 0x490 + 3*0xb0)
#define DDRC_PCFGQOS0_0(X)       (DDRC_IPS_BASE_ADDR(X) + 0x494)
#define DDRC_PCFGQOS1_0(X)       (DDRC_IPS_BASE_ADDR(X) + 0x498)
#define DDRC_PCFGWQOS0_0(X)      (DDRC_IPS_BASE_ADDR(X) + 0x49c)
#define DDRC_PCFGWQOS1_0(X)      (DDRC_IPS_BASE_ADDR(X) + 0x4a0)
#define DDRC_SARBASE0(X)         (DDRC_IPS_BASE_ADDR(X) + 0xf04)
#define DDRC_SARSIZE0(X)         (DDRC_IPS_BASE_ADDR(X) + 0xf08)
#define DDRC_SBRCTL(X)           (DDRC_IPS_BASE_ADDR(X) + 0xf24)
#define DDRC_SBRSTAT(X)          (DDRC_IPS_BASE_ADDR(X) + 0xf28)
#define DDRC_SBRWDATA0(X)        (DDRC_IPS_BASE_ADDR(X) + 0xf2c)
#define DDRC_SBRWDATA1(X)        (DDRC_IPS_BASE_ADDR(X) + 0xf30)
#define DDRC_PDCH(X)             (DDRC_IPS_BASE_ADDR(X) + 0xf34)
/*
#define DDRC_PCFGW_0_0_ADDR     ((vuint8_t*)&(DDRC_PCFGW_0(0)))
#define DDRC_PCFGW_0_1_ADDR     ((vuint8_t*)&(DDRC_PCFGW_0(1)))
#define DDRC_PCFGW_0_2_ADDR     ((vuint8_t*)&(DDRC_PCFGW_0(2)))
#define DDRC_PCFGW_0_3_ADDR     ((vuint8_t*)&(DDRC_PCFGW_0(3)))

#define DDRC_MRCTRL1_0_ADDR     ((vuint8_t*)&(DDRC_MRCTRL1(0)))
#define DDRC_MRCTRL1_1_ADDR     ((vuint8_t*)&(DDRC_MRCTRL1(1)))
#define DDRC_MRCTRL1_2_ADDR     ((vuint8_t*)&(DDRC_MRCTRL1(2)))
#define DDRC_FREQ1_MRCTRL1_3_ADDR     ((vuint8_t*)&(DDRC_MRCTRL1(3)))
*/

// SHADOW registers

#define DDRC_FREQ1_DERATEEN(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2020)
#define DDRC_FREQ1_DERATEINT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2024)
#define DDRC_FREQ1_RFSHCTL0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2050)
#define DDRC_FREQ1_RFSHTMG(X)          (DDRC_IPS_BASE_ADDR(X) + 0x2064)
#define DDRC_FREQ1_INIT3(X)            (DDRC_IPS_BASE_ADDR(X) + 0x20dc)
#define DDRC_FREQ1_INIT4(X)            (DDRC_IPS_BASE_ADDR(X) + 0x20e0)
#define DDRC_FREQ1_INIT6(X)            (DDRC_IPS_BASE_ADDR(X) + 0x20e8)
#define DDRC_FREQ1_INIT7(X)            (DDRC_IPS_BASE_ADDR(X) + 0x20ec)
#define DDRC_FREQ1_DRAMTMG0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2100)
#define DDRC_FREQ1_DRAMTMG1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2104)
#define DDRC_FREQ1_DRAMTMG2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2108)
#define DDRC_FREQ1_DRAMTMG3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x210c)
#define DDRC_FREQ1_DRAMTMG4(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2110)
#define DDRC_FREQ1_DRAMTMG5(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2114)
#define DDRC_FREQ1_DRAMTMG6(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2118)
#define DDRC_FREQ1_DRAMTMG7(X)         (DDRC_IPS_BASE_ADDR(X) + 0x211c)
#define DDRC_FREQ1_DRAMTMG8(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2120)
#define DDRC_FREQ1_DRAMTMG9(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2124)
#define DDRC_FREQ1_DRAMTMG10(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2128)
#define DDRC_FREQ1_DRAMTMG11(X)        (DDRC_IPS_BASE_ADDR(X) + 0x212c)
#define DDRC_FREQ1_DRAMTMG12(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2130)
#define DDRC_FREQ1_DRAMTMG13(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2134)
#define DDRC_FREQ1_DRAMTMG14(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2138)
#define DDRC_FREQ1_DRAMTMG15(X)        (DDRC_IPS_BASE_ADDR(X) + 0x213C)
#define DDRC_FREQ1_DRAMTMG16(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2140)
#define DDRC_FREQ1_DRAMTMG17(X)        (DDRC_IPS_BASE_ADDR(X) + 0x2144)
#define DDRC_FREQ1_ZQCTL0(X)           (DDRC_IPS_BASE_ADDR(X) + 0x2180)
#define DDRC_FREQ1_DFITMG0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x2190)
#define DDRC_FREQ1_DFITMG1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x2194)
#define DDRC_FREQ1_DFITMG2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x21b4)
#define DDRC_FREQ1_DFITMG3(X)          (DDRC_IPS_BASE_ADDR(X) + 0x21b8)
#define DDRC_FREQ1_ODTCFG(X)           (DDRC_IPS_BASE_ADDR(X) + 0x2240)

#define DDRC_FREQ2_DERATEEN(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3020)
#define DDRC_FREQ2_DERATEINT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3024)
#define DDRC_FREQ2_RFSHCTL0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3050)
#define DDRC_FREQ2_RFSHTMG(X)          (DDRC_IPS_BASE_ADDR(X) + 0x3064)
#define DDRC_FREQ2_INIT3(X)            (DDRC_IPS_BASE_ADDR(X) + 0x30dc)
#define DDRC_FREQ2_INIT4(X)            (DDRC_IPS_BASE_ADDR(X) + 0x30e0)
#define DDRC_FREQ2_INIT6(X)            (DDRC_IPS_BASE_ADDR(X) + 0x30e8)
#define DDRC_FREQ2_INIT7(X)            (DDRC_IPS_BASE_ADDR(X) + 0x30ec)
#define DDRC_FREQ2_DRAMTMG0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3100)
#define DDRC_FREQ2_DRAMTMG1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3104)
#define DDRC_FREQ2_DRAMTMG2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3108)
#define DDRC_FREQ2_DRAMTMG3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x310c)
#define DDRC_FREQ2_DRAMTMG4(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3110)
#define DDRC_FREQ2_DRAMTMG5(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3114)
#define DDRC_FREQ2_DRAMTMG6(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3118)
#define DDRC_FREQ2_DRAMTMG7(X)         (DDRC_IPS_BASE_ADDR(X) + 0x311c)
#define DDRC_FREQ2_DRAMTMG8(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3120)
#define DDRC_FREQ2_DRAMTMG9(X)         (DDRC_IPS_BASE_ADDR(X) + 0x3124)
#define DDRC_FREQ2_DRAMTMG10(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3128)
#define DDRC_FREQ2_DRAMTMG11(X)        (DDRC_IPS_BASE_ADDR(X) + 0x312c)
#define DDRC_FREQ2_DRAMTMG12(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3130)
#define DDRC_FREQ2_DRAMTMG13(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3134)
#define DDRC_FREQ2_DRAMTMG14(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3138)
#define DDRC_FREQ2_DRAMTMG15(X)        (DDRC_IPS_BASE_ADDR(X) + 0x313C)
#define DDRC_FREQ2_DRAMTMG16(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3140)
#define DDRC_FREQ2_DRAMTMG17(X)        (DDRC_IPS_BASE_ADDR(X) + 0x3144)
#define DDRC_FREQ2_ZQCTL0(X)           (DDRC_IPS_BASE_ADDR(X) + 0x3180)
#define DDRC_FREQ2_DFITMG0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x3190)
#define DDRC_FREQ2_DFITMG1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x3194)
#define DDRC_FREQ2_DFITMG2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x31b4)
#define DDRC_FREQ2_DFITMG3(X)          (DDRC_IPS_BASE_ADDR(X) + 0x31b8)
#define DDRC_FREQ2_ODTCFG(X)           (DDRC_IPS_BASE_ADDR(X) + 0x3240)

#define DDRC_FREQ3_DERATEEN(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4020)
#define DDRC_FREQ3_DERATEINT(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4024)
#define DDRC_FREQ3_RFSHCTL0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4050)
#define DDRC_FREQ3_RFSHTMG(X)          (DDRC_IPS_BASE_ADDR(X) + 0x4064)
#define DDRC_FREQ3_INIT3(X)            (DDRC_IPS_BASE_ADDR(X) + 0x40dc)
#define DDRC_FREQ3_INIT4(X)            (DDRC_IPS_BASE_ADDR(X) + 0x40e0)
#define DDRC_FREQ3_INIT6(X)            (DDRC_IPS_BASE_ADDR(X) + 0x40e8)
#define DDRC_FREQ3_INIT7(X)            (DDRC_IPS_BASE_ADDR(X) + 0x40ec)
#define DDRC_FREQ3_DRAMTMG0(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4100)
#define DDRC_FREQ3_DRAMTMG1(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4104)
#define DDRC_FREQ3_DRAMTMG2(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4108)
#define DDRC_FREQ3_DRAMTMG3(X)         (DDRC_IPS_BASE_ADDR(X) + 0x410c)
#define DDRC_FREQ3_DRAMTMG4(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4110)
#define DDRC_FREQ3_DRAMTMG5(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4114)
#define DDRC_FREQ3_DRAMTMG6(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4118)
#define DDRC_FREQ3_DRAMTMG7(X)         (DDRC_IPS_BASE_ADDR(X) + 0x411c)
#define DDRC_FREQ3_DRAMTMG8(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4120)
#define DDRC_FREQ3_DRAMTMG9(X)         (DDRC_IPS_BASE_ADDR(X) + 0x4124)
#define DDRC_FREQ3_DRAMTMG10(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4128)
#define DDRC_FREQ3_DRAMTMG11(X)        (DDRC_IPS_BASE_ADDR(X) + 0x412c)
#define DDRC_FREQ3_DRAMTMG12(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4130)
#define DDRC_FREQ3_DRAMTMG13(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4134)
#define DDRC_FREQ3_DRAMTMG14(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4138)
#define DDRC_FREQ3_DRAMTMG15(X)        (DDRC_IPS_BASE_ADDR(X) + 0x413C)
#define DDRC_FREQ3_DRAMTMG16(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4140)
#if 0
/*todo fix*/
#define DDRC_FREQ3_DRAMTMG16(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4144)
#define DDRC_FREQ3_DRAMTMG17(X)        (DDRC_IPS_BASE_ADDR(X) + 0x4140)
#endif
#define DDRC_FREQ3_ZQCTL0(X)           (DDRC_IPS_BASE_ADDR(X) + 0x4180)
#define DDRC_FREQ3_DFITMG0(X)          (DDRC_IPS_BASE_ADDR(X) + 0x4190)
#define DDRC_FREQ3_DFITMG1(X)          (DDRC_IPS_BASE_ADDR(X) + 0x4194)
#define DDRC_FREQ3_DFITMG2(X)          (DDRC_IPS_BASE_ADDR(X) + 0x41b4)
#define DDRC_FREQ3_DFITMG3(X)          (DDRC_IPS_BASE_ADDR(X) + 0x41b8)
#define DDRC_FREQ3_ODTCFG(X)           (DDRC_IPS_BASE_ADDR(X) + 0x4240)
#define DDRC_DFITMG0_SHADOW(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2190)
#define DDRC_DFITMG1_SHADOW(X)         (DDRC_IPS_BASE_ADDR(X) + 0x2194)
#define DDRC_DFITMG2_SHADOW(X)         (DDRC_IPS_BASE_ADDR(X) + 0x21b4)
#define DDRC_DFITMG3_SHADOW(X)         (DDRC_IPS_BASE_ADDR(X) + 0x21b8)
#define DDRC_ODTCFG_SHADOW(X)          (DDRC_IPS_BASE_ADDR(X) + 0x2240)

//#define IP2APB_DDRPHY_IPS_BASE_ADDR(X)     DDRPHY1_IPS_BASE_ADDR - X*0x00030000
//#define IP2APB_DDRPHY_IPS_BASE_ADDR(X) 0xbc000000 + (X * 0x2000000)
//#define DDRPHY_MEM(X) 0xbc000000 + (X * 0x2000000) + 0x50000
#define IP2APB_DDRPHY_IPS_BASE_ADDR(X) (0x3c000000 + (X * 0x2000000))
#define DDRPHY_MEM(X) (0x3c000000 + (X * 0x2000000) + 0x50000)
//#define IP2APB_DDRPHY_IPS_BASE_ADDR(X) 0x3c000000 + (X * 0x2000000)

#if 0
/* todo: fix*/
#define DDRPHY_AcsmSeq0x0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040000)
#define DDRPHY_AcsmSeq0x1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040001)
#define DDRPHY_AcsmSeq0x2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040002)
#define DDRPHY_AcsmSeq0x3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040003)
#define DDRPHY_AcsmSeq0x4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040004)
#define DDRPHY_AcsmSeq0x5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040005)
#define DDRPHY_AcsmSeq0x6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040006)
#define DDRPHY_AcsmSeq0x7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040007)
#define DDRPHY_AcsmSeq0x8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040008)
#define DDRPHY_AcsmSeq0x9(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040009)
#define DDRPHY_AcsmSeq0x10(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000A)
#define DDRPHY_AcsmSeq0x11(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000B)
#define DDRPHY_AcsmSeq0x12(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000C)
#define DDRPHY_AcsmSeq0x13(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000D)
#define DDRPHY_AcsmSeq0x14(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000E)
#define DDRPHY_AcsmSeq0x15(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04000F)
#define DDRPHY_AcsmSeq0x16(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040010)
#define DDRPHY_AcsmSeq0x17(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040011)
#define DDRPHY_AcsmSeq0x18(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040012)
#define DDRPHY_AcsmSeq0x19(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040013)
#define DDRPHY_AcsmSeq0x20(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040014)
#define DDRPHY_AcsmSeq0x21(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040015)
#define DDRPHY_AcsmSeq0x22(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040016)
#define DDRPHY_AcsmSeq0x23(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040017)
#define DDRPHY_AcsmSeq0x24(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040018)
#define DDRPHY_AcsmSeq0x25(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040019)
#define DDRPHY_AcsmSeq0x26(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001A)
#define DDRPHY_AcsmSeq0x27(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001B)
#define DDRPHY_AcsmSeq0x28(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001C)
#define DDRPHY_AcsmSeq0x29(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001D)
#define DDRPHY_AcsmSeq0x30(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001E)
#define DDRPHY_AcsmSeq0x31(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04001F)

#define DDRPHY_AcsmSeq1x0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040020)
#define DDRPHY_AcsmSeq1x1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040021)
#define DDRPHY_AcsmSeq1x2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040022)
#define DDRPHY_AcsmSeq1x3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040023)
#define DDRPHY_AcsmSeq1x4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040024)
#define DDRPHY_AcsmSeq1x5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040025)
#define DDRPHY_AcsmSeq1x6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040026)
#define DDRPHY_AcsmSeq1x7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040027)
#define DDRPHY_AcsmSeq1x8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040028)
#define DDRPHY_AcsmSeq1x9(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040029)
#define DDRPHY_AcsmSeq1x10(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002A)
#define DDRPHY_AcsmSeq1x11(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002B)
#define DDRPHY_AcsmSeq1x12(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002C)
#define DDRPHY_AcsmSeq1x13(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002D)
#define DDRPHY_AcsmSeq1x14(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002E)
#define DDRPHY_AcsmSeq1x15(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04002F)
#define DDRPHY_AcsmSeq1x16(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040030)
#define DDRPHY_AcsmSeq1x17(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040031)
#define DDRPHY_AcsmSeq1x18(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040032)
#define DDRPHY_AcsmSeq1x19(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040033)
#define DDRPHY_AcsmSeq1x20(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040034)
#define DDRPHY_AcsmSeq1x21(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040035)
#define DDRPHY_AcsmSeq1x22(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040036)
#define DDRPHY_AcsmSeq1x23(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040037)
#define DDRPHY_AcsmSeq1x24(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040038)
#define DDRPHY_AcsmSeq1x25(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040039)
#define DDRPHY_AcsmSeq1x26(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003A)
#define DDRPHY_AcsmSeq1x27(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003B)
#define DDRPHY_AcsmSeq1x28(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003C)
#define DDRPHY_AcsmSeq1x29(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003D)
#define DDRPHY_AcsmSeq1x30(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003E)
#define DDRPHY_AcsmSeq1x31(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04003F)

#define DDRPHY_AcsmSeq2x0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040040)
#define DDRPHY_AcsmSeq2x1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040041)
#define DDRPHY_AcsmSeq2x2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040042)
#define DDRPHY_AcsmSeq2x3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040043)
#define DDRPHY_AcsmSeq2x4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040044)
#define DDRPHY_AcsmSeq2x5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040045)
#define DDRPHY_AcsmSeq2x6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040046)
#define DDRPHY_AcsmSeq2x7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040047)
#define DDRPHY_AcsmSeq2x8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040048)
#define DDRPHY_AcsmSeq2x9(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040049)
#define DDRPHY_AcsmSeq2x10(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004A)
#define DDRPHY_AcsmSeq2x11(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004B)
#define DDRPHY_AcsmSeq2x12(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004C)
#define DDRPHY_AcsmSeq2x13(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004D)
#define DDRPHY_AcsmSeq2x14(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004E)
#define DDRPHY_AcsmSeq2x15(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04004F)
#define DDRPHY_AcsmSeq2x16(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040050)
#define DDRPHY_AcsmSeq2x17(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040051)
#define DDRPHY_AcsmSeq2x18(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040052)
#define DDRPHY_AcsmSeq2x19(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040053)
#define DDRPHY_AcsmSeq2x20(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040054)
#define DDRPHY_AcsmSeq2x21(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040055)
#define DDRPHY_AcsmSeq2x22(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040056)
#define DDRPHY_AcsmSeq2x23(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040057)
#define DDRPHY_AcsmSeq2x24(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040058)
#define DDRPHY_AcsmSeq2x25(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040059)
#define DDRPHY_AcsmSeq2x26(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005A)
#define DDRPHY_AcsmSeq2x27(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005B)
#define DDRPHY_AcsmSeq2x28(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005C)
#define DDRPHY_AcsmSeq2x29(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005D)
#define DDRPHY_AcsmSeq2x30(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005E)
#define DDRPHY_AcsmSeq2x31(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04005F)

#define DDRPHY_AcsmSeq3x0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040060)
#define DDRPHY_AcsmSeq3x1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040061)
#define DDRPHY_AcsmSeq3x2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040062)
#define DDRPHY_AcsmSeq3x3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040063)
#define DDRPHY_AcsmSeq3x4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040064)
#define DDRPHY_AcsmSeq3x5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040065)
#define DDRPHY_AcsmSeq3x6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040066)
#define DDRPHY_AcsmSeq3x7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040067)
#define DDRPHY_AcsmSeq3x8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040068)
#define DDRPHY_AcsmSeq3x9(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040069)
#define DDRPHY_AcsmSeq3x10(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006A)
#define DDRPHY_AcsmSeq3x11(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006B)
#define DDRPHY_AcsmSeq3x12(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006C)
#define DDRPHY_AcsmSeq3x13(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006D)
#define DDRPHY_AcsmSeq3x14(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006E)
#define DDRPHY_AcsmSeq3x15(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04006F)
#define DDRPHY_AcsmSeq3x16(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040070)
#define DDRPHY_AcsmSeq3x17(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040071)
#define DDRPHY_AcsmSeq3x18(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040072)
#define DDRPHY_AcsmSeq3x19(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040073)
#define DDRPHY_AcsmSeq3x20(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040074)
#define DDRPHY_AcsmSeq3x21(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040075)
#define DDRPHY_AcsmSeq3x22(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040076)
#define DDRPHY_AcsmSeq3x23(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040077)
#define DDRPHY_AcsmSeq3x24(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040078)
#define DDRPHY_AcsmSeq3x25(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040079)
#define DDRPHY_AcsmSeq3x26(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007A)
#define DDRPHY_AcsmSeq3x27(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007B)
#define DDRPHY_AcsmSeq3x28(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007C)
#define DDRPHY_AcsmSeq3x29(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007D)
#define DDRPHY_AcsmSeq3x30(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007E)
#define DDRPHY_AcsmSeq3x31(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04007F)

#define DDRPHY_AcsmPlayback0x0_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040080)
#define DDRPHY_AcsmPlayback0x0_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140080)
#define DDRPHY_AcsmPlayback0x0_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240080)
#define DDRPHY_AcsmPlayback0x0_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340080)

#define DDRPHY_AcsmPlayback1x0_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040081)
#define DDRPHY_AcsmPlayback1x0_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140081)
#define DDRPHY_AcsmPlayback1x0_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240081)
#define DDRPHY_AcsmPlayback1x0_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340081)

#define DDRPHY_AcsmPlayback0x1_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040082)
#define DDRPHY_AcsmPlayback0x1_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140082)
#define DDRPHY_AcsmPlayback0x1_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240082)
#define DDRPHY_AcsmPlayback0x1_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340082)

#define DDRPHY_AcsmPlayback1x1_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040083)
#define DDRPHY_AcsmPlayback1x1_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140083)
#define DDRPHY_AcsmPlayback1x1_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240083)
#define DDRPHY_AcsmPlayback1x1_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340083)

#define DDRPHY_AcsmPlayback0x2_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040084)
#define DDRPHY_AcsmPlayback0x2_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140084)
#define DDRPHY_AcsmPlayback0x2_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240084)
#define DDRPHY_AcsmPlayback0x2_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340084)

#define DDRPHY_AcsmPlayback1x2_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040085)
#define DDRPHY_AcsmPlayback1x2_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140085)
#define DDRPHY_AcsmPlayback1x2_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240085)
#define DDRPHY_AcsmPlayback1x2_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340085)

#define DDRPHY_AcsmPlayback0x3_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040086)
#define DDRPHY_AcsmPlayback0x3_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140086)
#define DDRPHY_AcsmPlayback0x3_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240086)
#define DDRPHY_AcsmPlayback0x3_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340086)

#define DDRPHY_AcsmPlayback1x3_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040087)
#define DDRPHY_AcsmPlayback1x3_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140087)
#define DDRPHY_AcsmPlayback1x3_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240087)
#define DDRPHY_AcsmPlayback1x3_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340087)

#define DDRPHY_AcsmPlayback0x4_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040088)
#define DDRPHY_AcsmPlayback0x4_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140088)
#define DDRPHY_AcsmPlayback0x4_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240088)
#define DDRPHY_AcsmPlayback0x4_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340088)

#define DDRPHY_AcsmPlayback1x4_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x040089)
#define DDRPHY_AcsmPlayback1x4_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x140089)
#define DDRPHY_AcsmPlayback1x4_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x240089)
#define DDRPHY_AcsmPlayback1x4_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x340089)

#define DDRPHY_AcsmPlayback0x5_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008A)
#define DDRPHY_AcsmPlayback0x5_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008A)
#define DDRPHY_AcsmPlayback0x5_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008A)
#define DDRPHY_AcsmPlayback0x5_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008A)

#define DDRPHY_AcsmPlayback1x5_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008B)
#define DDRPHY_AcsmPlayback1x5_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008B)
#define DDRPHY_AcsmPlayback1x5_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008B)
#define DDRPHY_AcsmPlayback1x5_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008B)

#define DDRPHY_AcsmPlayback0x6_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008C)
#define DDRPHY_AcsmPlayback0x6_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008C)
#define DDRPHY_AcsmPlayback0x6_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008C)
#define DDRPHY_AcsmPlayback0x6_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008C)

#define DDRPHY_AcsmPlayback1x6_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008D)
#define DDRPHY_AcsmPlayback1x6_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008D)
#define DDRPHY_AcsmPlayback1x6_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008D)
#define DDRPHY_AcsmPlayback1x6_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008D)

#define DDRPHY_AcsmPlayback0x7_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008E)
#define DDRPHY_AcsmPlayback0x7_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008E)
#define DDRPHY_AcsmPlayback0x7_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008E)
#define DDRPHY_AcsmPlayback0x7_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008E)

#define DDRPHY_AcsmPlayback1x7_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x04008F)
#define DDRPHY_AcsmPlayback1x7_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x14008F)
#define DDRPHY_AcsmPlayback1x7_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x24008F)
#define DDRPHY_AcsmPlayback1x7_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x34008F)

#define DDRPHY_AcsmCtrl23(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400C0)
#define DDRPHY_AcsmCkeVal(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400C2)
#define DDRPHY_LowSpeedClockDivider(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400C8)
#define DDRPHY_AcsmCsMapCtrl0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D0)
#define DDRPHY_AcsmCsMapCtrl1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D1)
#define DDRPHY_AcsmCsMapCtrl2(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D2)
#define DDRPHY_AcsmCsMapCtrl3(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D3)
#define DDRPHY_AcsmCsMapCtrl4(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D4)
#define DDRPHY_AcsmCsMapCtrl5(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D5)
#define DDRPHY_AcsmCsMapCtrl6(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D6)
#define DDRPHY_AcsmCsMapCtrl7(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D7)
#define DDRPHY_AcsmCsMapCtrl8(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D8)
#define DDRPHY_AcsmCsMapCtrl9(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400D9)
#define DDRPHY_AcsmCsMapCtrl10(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DA)
#define DDRPHY_AcsmCsMapCtrl11(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DB)
#define DDRPHY_AcsmCsMapCtrl12(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DC)
#define DDRPHY_AcsmCsMapCtrl13(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DD)
#define DDRPHY_AcsmCsMapCtrl14(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DE)
#define DDRPHY_AcsmCsMapCtrl15(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400DF)

#define DDRPHY_AcsmOdtCtrl0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E0)
#define DDRPHY_AcsmOdtCtrl1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E1)
#define DDRPHY_AcsmOdtCtrl2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E2)
#define DDRPHY_AcsmOdtCtrl3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E3)
#define DDRPHY_AcsmOdtCtrl4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E4)
#define DDRPHY_AcsmOdtCtrl5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E5)
#define DDRPHY_AcsmOdtCtrl6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E6)
#define DDRPHY_AcsmOdtCtrl7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E7)
#define DDRPHY_AcsmOdtCtrl8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E8)
#define DDRPHY_AcsmCtrl16(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400E9)
#define DDRPHY_AcsmCtrl18(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400EB)
#define DDRPHY_AcsmCtrl19(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400EC)
#define DDRPHY_AcsmCtrl20(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400ED)
#define DDRPHY_AcsmCtrl21(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400EE)
#define DDRPHY_AcsmCtrl22(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400EF)
#define DDRPHY_AcsmCtrl0(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F0)
#define DDRPHY_AcsmCtrl1(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F1)
#define DDRPHY_AcsmCtrl2(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F2)
#define DDRPHY_AcsmCtrl3(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F3)
#define DDRPHY_AcsmCtrl4(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F4)
#define DDRPHY_AcsmCtrl5(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F5)
#define DDRPHY_AcsmCtrl6(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F6)
#define DDRPHY_AcsmCtrl7(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F7)
#define DDRPHY_AcsmCtrl8(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F8)
#define DDRPHY_AcsmCtrl9(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400F9)
#define DDRPHY_AcsmCtrl10(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FA)
#define DDRPHY_AcsmCtrl11(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FB)
#define DDRPHY_AcsmCtrl12(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FC)
#define DDRPHY_AcsmCtrl13(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FD)
#define DDRPHY_AcsmCtrl14(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FE)
#define DDRPHY_AcsmCtrl15(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0400FF)

#define DDRPHY_MtestMuxSel(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x00001A)
#define DDRPHY_AForceTriCont(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000028)
#define DDRPHY_ATxImpedance(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000043)
#define DDRPHY_ATestPrbsErr(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000053)
#define DDRPHY_ATxSlewRate(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000055)
#define DDRPHY_ATestPrbsErrCnt(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000056)
#define DDRPHY_ATxDly_0(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x000080)
#define DDRPHY_ATxDly_1(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x100080)
#define DDRPHY_ATxDly_2(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x200080)
#define DDRPHY_ATxDly_3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x300080)

#define DDRPHY_MicroContMuxSel(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0000)
#define DDRPHY_UctShadowRegs(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0004)
#define DDRPHY_DctWriteOnly(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0030)
#define DDRPHY_DctWriteProt(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0031)
#define DDRPHY_UctWriteOnlyShadow(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0032)
#define DDRPHY_UctDatWriteOnlyShadow(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0034)
#define DDRPHY_NeverGateCsrClock(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0035)
#define DDRPHY_DfiCfgRdDataValidTicks(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0037)
#define DDRPHY_MicroReset(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D0099)
#define DDRPHY_SequencerOverride(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D00E7)
#define DDRPHY_DfiInitCompleteShadow(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0D00FA)

#define DDRPHY_DbyteMiscMode(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010000)
#define DDRPHY_TsmByte0(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010001)
#define DDRPHY_TrainingParam(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010002)
#define DDRPHY_RxTrainPatternEnable(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010010)
#define DDRPHY_TsmByte1(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010011)
#define DDRPHY_TsmByte2(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010012)
#define DDRPHY_TsmByte3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010013)
#define DDRPHY_TsmByte4(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010014)
#define DDRPHY_TestModeConfig(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010017)
#define DDRPHY_TsmByte5(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010018)
#define DDRPHY_MtestMuxSel(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01001A)
#define DDRPHY_DtsmTrainModeCtrl(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01001F)
#define DDRPHY_DFIMRL_0(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010020)
#define DDRPHY_DFIMRL_1(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110020)
#define DDRPHY_DFIMRL_2(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210020)
#define DDRPHY_DFIMRL_3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310020)
#define DDRPHY_TrainingCntrFineMax_0(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010022)
#define DDRPHY_TrainingCntrFineMax_1(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010122)
#define DDRPHY_TrainingCntrFineMax_2(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010222)
#define DDRPHY_TrainingCntrFineMax_3(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010322)
#define DDRPHY_TrainingCntrFineMax_4(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010422)
#define DDRPHY_TrainingCntrFineMax_5(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010522)
#define DDRPHY_TrainingCntrFineMax_6(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010622)
#define DDRPHY_TrainingCntrFineMax_7(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010722)
#define DDRPHY_TrainingCntrFineMax_8(X)      (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010822)
#define DDRPHY_TrainingCntrFineMaxRxEn_0(X)  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010023)
#define DDRPHY_TrainingCntrFineMaxRxEn_1(X)  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010123)

#define DDRPHY_AsyncDbyteMode(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010024)
#define DDRPHY_AsyncDbyteTxEn(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010026)
#define DDRPHY_AsyncDbyteTxData(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010028)
#define DDRPHY_AsyncDbyteRxData(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01002A)
#define DDRPHY_VrefDAC1_0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010030)
#define DDRPHY_VrefDAC1_1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010130)
#define DDRPHY_VrefDAC1_2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010230)
#define DDRPHY_VrefDAC1_3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010330)
#define DDRPHY_VrefDAC1_4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010430)
#define DDRPHY_VrefDAC1_5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010530)
#define DDRPHY_VrefDAC1_6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010630)
#define DDRPHY_VrefDAC1_7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010730)
#define DDRPHY_VrefDAC1_8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010830)

#define DDRPHY_TrainingCntr_0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010032)
#define DDRPHY_TrainingCntr_1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010132)
#define DDRPHY_TrainingCntr_2(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010232)
#define DDRPHY_TrainingCntr_3(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010332)
#define DDRPHY_TrainingCntr_4(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010432)
#define DDRPHY_TrainingCntr_5(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010532)
#define DDRPHY_TrainingCntr_6(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010632)
#define DDRPHY_TrainingCntr_7(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010732)
#define DDRPHY_TrainingCntr_8(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010832)

#define DDRPHY_VrefDAC0_0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010040)
#define DDRPHY_VrefDAC0_1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010140)
#define DDRPHY_VrefDAC0_2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010240)
#define DDRPHY_VrefDAC0_3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010340)
#define DDRPHY_VrefDAC0_4(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010440)
#define DDRPHY_VrefDAC0_5(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010540)
#define DDRPHY_VrefDAC0_6(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010640)
#define DDRPHY_VrefDAC0_7(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010740)
#define DDRPHY_VrefDAC0_8(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010840)

#define DDRPHY_TxImpedanceDq_0(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010041)
#define DDRPHY_TxImpedanceDq_1(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010141)
#define DDRPHY_TxImpedanceDq_2(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110041)
#define DDRPHY_TxImpedanceDq_3(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110141)
#define DDRPHY_TxImpedanceDq_4(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210041)
#define DDRPHY_TxImpedanceDq_5(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210141)
#define DDRPHY_TxImpedanceDq_6(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310041)
#define DDRPHY_TxImpedanceDq_7(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310141)

#define DDRPHY_DqDqsRcvCntrl_0(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010043)
#define DDRPHY_DqDqsRcvCntrl_1(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010143)
#define DDRPHY_DqDqsRcvCntrl_2(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110043)
#define DDRPHY_DqDqsRcvCntrl_3(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110143)
#define DDRPHY_DqDqsRcvCntrl_4(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210043)
#define DDRPHY_DqDqsRcvCntrl_5(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210143)
#define DDRPHY_DqDqsRcvCntrl_6(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310043)
#define DDRPHY_DqDqsRcvCntrl_7(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310143)

#define DDRPHY_TxEqualizationMode_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010048)
#define DDRPHY_TxEqualizationMode_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110048)
#define DDRPHY_TxEqualizationMode_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210048)
#define DDRPHY_TxEqualizationMode_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310048)

#define DDRPHY_TxEqImpedanceDq_0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010049)
#define DDRPHY_TxEqImpedanceDq_1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010149)
#define DDRPHY_TxEqImpedanceDq_2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110049)
#define DDRPHY_TxEqImpedanceDq_3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110149)
#define DDRPHY_TxEqImpedanceDq_4(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210049)
#define DDRPHY_TxEqImpedanceDq_5(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210149)
#define DDRPHY_TxEqImpedanceDq_6(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310049)
#define DDRPHY_TxEqImpedanceDq_7(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310149)

#define DDRPHY_DqDqsRcvCntrl1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01004A)

#define DDRPHY_TxEqHiImpedanceDq_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01004B)
#define DDRPHY_TxEqHiImpedanceDq_1(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01014B)
#define DDRPHY_TxEqHiImpedanceDq_2(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11004B)
#define DDRPHY_TxEqHiImpedanceDq_3(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11014B)
#define DDRPHY_TxEqHiImpedanceDq_4(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21004B)
#define DDRPHY_TxEqHiImpedanceDq_5(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21014B)
#define DDRPHY_TxEqHiImpedanceDq_6(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31004B)
#define DDRPHY_TxEqHiImpedanceDq_7(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31014B)

#define DDRPHY_DqDqsRcvCntrl2_0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01004C)
#define DDRPHY_DqDqsRcvCntrl2_1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11004C)
#define DDRPHY_DqDqsRcvCntrl2_2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21004C)
#define DDRPHY_DqDqsRcvCntrl2_3(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31004C)

#define DDRPHY_TxOdtDrvStren_0(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01004D)
#define DDRPHY_TxOdtDrvStren_1(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01014D)
#define DDRPHY_TxOdtDrvStren_2(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11004D)
#define DDRPHY_TxOdtDrvStren_3(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11014D)
#define DDRPHY_TxOdtDrvStren_4(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21004D)
#define DDRPHY_TxOdtDrvStren_5(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21014D)
#define DDRPHY_TxOdtDrvStren_6(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31004D)
#define DDRPHY_TxOdtDrvStren_7(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31014D)

#define DDRPHY_RxFifoInfo(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010058)
#define DDRPHY_RxFifoVisibility(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010059)
#define DDRPHY_RxFifoContentsDQ3210(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01005A)
#define DDRPHY_RxFifoContentsDQ7654(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01005B)
#define DDRPHY_RxFifoContentsDBI(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01005C)

#define DDRPHY_TxSlewRate_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01005F)
#define DDRPHY_TxSlewRate_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01015F)
#define DDRPHY_TxSlewRate_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11005F)
#define DDRPHY_TxSlewRate_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11015F)
#define DDRPHY_TxSlewRate_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21005F)
#define DDRPHY_TxSlewRate_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21015F)
#define DDRPHY_TxSlewRate_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31005F)
#define DDRPHY_TxSlewRate_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31015F)

#define DDRPHY_TrainingIncDecDtsmEn_0(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010062)
#define DDRPHY_TrainingIncDecDtsmEn_1(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010162)
#define DDRPHY_TrainingIncDecDtsmEn_2(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010262)
#define DDRPHY_TrainingIncDecDtsmEn_3(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010362)
#define DDRPHY_TrainingIncDecDtsmEn_4(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010462)
#define DDRPHY_TrainingIncDecDtsmEn_5(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010562)
#define DDRPHY_TrainingIncDecDtsmEn_6(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010662)
#define DDRPHY_TrainingIncDecDtsmEn_7(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010762)
#define DDRPHY_TrainingIncDecDtsmEn_8(X)     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010862)

#define DDRPHY_RxPBDlyTg0_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010068)
#define DDRPHY_RxPBDlyTg0_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010168)
#define DDRPHY_RxPBDlyTg0_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010268)
#define DDRPHY_RxPBDlyTg0_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010368)
#define DDRPHY_RxPBDlyTg0_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010468)
#define DDRPHY_RxPBDlyTg0_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010568)
#define DDRPHY_RxPBDlyTg0_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010668)
#define DDRPHY_RxPBDlyTg0_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010768)
#define DDRPHY_RxPBDlyTg0_8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010868)

#define DDRPHY_RxPBDlyTg1_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010069)
#define DDRPHY_RxPBDlyTg1_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010169)
#define DDRPHY_RxPBDlyTg1_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010269)
#define DDRPHY_RxPBDlyTg1_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010369)
#define DDRPHY_RxPBDlyTg1_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010469)
#define DDRPHY_RxPBDlyTg1_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010569)
#define DDRPHY_RxPBDlyTg1_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010669)
#define DDRPHY_RxPBDlyTg1_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010769)
#define DDRPHY_RxPBDlyTg1_8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010869)

#define DDRPHY_RxPBDlyTg2_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01006A)
#define DDRPHY_RxPBDlyTg2_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01016A)
#define DDRPHY_RxPBDlyTg2_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01026A)
#define DDRPHY_RxPBDlyTg2_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01036A)
#define DDRPHY_RxPBDlyTg2_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01046A)
#define DDRPHY_RxPBDlyTg2_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01056A)
#define DDRPHY_RxPBDlyTg2_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01066A)
#define DDRPHY_RxPBDlyTg2_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01076A)
#define DDRPHY_RxPBDlyTg2_8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01086A)

#define DDRPHY_RxPBDlyTg3_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01006B)
#define DDRPHY_RxPBDlyTg3_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01016B)
#define DDRPHY_RxPBDlyTg3_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01026B)
#define DDRPHY_RxPBDlyTg3_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01036B)
#define DDRPHY_RxPBDlyTg3_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01046B)
#define DDRPHY_RxPBDlyTg3_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01056B)
#define DDRPHY_RxPBDlyTg3_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01066B)
#define DDRPHY_RxPBDlyTg3_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01076B)
#define DDRPHY_RxPBDlyTg3_8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01086B)

#define DDRPHY_RxEnDlyTg0_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010080)
#define DDRPHY_RxEnDlyTg0_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010180)
#define DDRPHY_RxEnDlyTg0_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110080)
#define DDRPHY_RxEnDlyTg0_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110180)
#define DDRPHY_RxEnDlyTg0_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210080)
#define DDRPHY_RxEnDlyTg0_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210180)
#define DDRPHY_RxEnDlyTg0_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310080)
#define DDRPHY_RxEnDlyTg0_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310180)

#define DDRPHY_RxEnDlyTg1_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010081)
#define DDRPHY_RxEnDlyTg1_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010181)
#define DDRPHY_RxEnDlyTg1_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110081)
#define DDRPHY_RxEnDlyTg1_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110181)
#define DDRPHY_RxEnDlyTg1_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210081)
#define DDRPHY_RxEnDlyTg1_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210181)
#define DDRPHY_RxEnDlyTg1_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310081)
#define DDRPHY_RxEnDlyTg1_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310181)

#define DDRPHY_RxEnDlyTg2_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010082)
#define DDRPHY_RxEnDlyTg2_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010182)
#define DDRPHY_RxEnDlyTg2_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110082)
#define DDRPHY_RxEnDlyTg2_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110182)
#define DDRPHY_RxEnDlyTg2_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210082)
#define DDRPHY_RxEnDlyTg2_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210182)
#define DDRPHY_RxEnDlyTg2_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310082)
#define DDRPHY_RxEnDlyTg2_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310182)

#define DDRPHY_RxEnDlyTg3_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010083)
#define DDRPHY_RxEnDlyTg3_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x010183)
#define DDRPHY_RxEnDlyTg3_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110083)
#define DDRPHY_RxEnDlyTg3_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x110183)
#define DDRPHY_RxEnDlyTg3_4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210083)
#define DDRPHY_RxEnDlyTg3_5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x210183)
#define DDRPHY_RxEnDlyTg3_6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310083)
#define DDRPHY_RxEnDlyTg3_7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x310183)

#define DDRPHY_RxClkDlyTg0_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01008C)
#define DDRPHY_RxClkDlyTg0_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01018C)
#define DDRPHY_RxClkDlyTg0_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11008C)
#define DDRPHY_RxClkDlyTg0_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11018C)
#define DDRPHY_RxClkDlyTg0_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21008C)
#define DDRPHY_RxClkDlyTg0_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21018C)
#define DDRPHY_RxClkDlyTg0_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31008C)
#define DDRPHY_RxClkDlyTg0_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31018C)

#define DDRPHY_RxClkDlyTg1_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01008D)
#define DDRPHY_RxClkDlyTg1_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01018D)
#define DDRPHY_RxClkDlyTg1_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11008D)
#define DDRPHY_RxClkDlyTg1_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11018D)
#define DDRPHY_RxClkDlyTg1_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21008D)
#define DDRPHY_RxClkDlyTg1_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21018D)
#define DDRPHY_RxClkDlyTg1_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31008D)
#define DDRPHY_RxClkDlyTg1_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31018D)

#define DDRPHY_RxClkDlyTg2_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01008E)
#define DDRPHY_RxClkDlyTg2_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01018E)
#define DDRPHY_RxClkDlyTg2_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11008E)
#define DDRPHY_RxClkDlyTg2_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11018E)
#define DDRPHY_RxClkDlyTg2_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21008E)
#define DDRPHY_RxClkDlyTg2_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21018E)
#define DDRPHY_RxClkDlyTg2_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31008E)
#define DDRPHY_RxClkDlyTg2_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31018E)

#define DDRPHY_RxClkDlyTg3_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01008F)
#define DDRPHY_RxClkDlyTg3_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x01018F)
#define DDRPHY_RxClkDlyTg3_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11008F)
#define DDRPHY_RxClkDlyTg3_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x11018F)
#define DDRPHY_RxClkDlyTg3_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21008F)
#define DDRPHY_RxClkDlyTg3_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x21018F)
#define DDRPHY_RxClkDlyTg3_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31008F)
#define DDRPHY_RxClkDlyTg3_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x31018F)

#define DDRPHY_Dq0LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A0)
#define DDRPHY_Dq1LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A1)
#define DDRPHY_Dq2LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A2)
#define DDRPHY_Dq3LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A3)
#define DDRPHY_Dq4LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A4)
#define DDRPHY_Dq5LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A5)
#define DDRPHY_Dq6LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A6)
#define DDRPHY_Dq7LnSel(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100A7)
#define DDRPHY_PptCtlStatic(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AA)
#define DDRPHY_PptCtlDyn(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AB)
#define DDRPHY_PptInfo(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AC)
#define DDRPHY_PptRxEnEvnt(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AD)
#define DDRPHY_PptDqsCntInvTrnTg0_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AE)
#define DDRPHY_PptDqsCntInvTrnTg0_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100AE)
#define DDRPHY_PptDqsCntInvTrnTg0_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100AE)
#define DDRPHY_PptDqsCntInvTrnTg0_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100AE)

#define DDRPHY_PptDqsCntInvTrnTg1_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100AF)
#define DDRPHY_PptDqsCntInvTrnTg1_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100AF)
#define DDRPHY_PptDqsCntInvTrnTg1_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100AF)
#define DDRPHY_PptDqsCntInvTrnTg1_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100AF)

#define DDRPHY_DtsmBlankingCtrl_0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B1)

#define DDRPHY_Tsm0_0(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B2)
#define DDRPHY_Tsm0_1(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101B2)
#define DDRPHY_Tsm0_2(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102B2)
#define DDRPHY_Tsm0_3(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103B2)
#define DDRPHY_Tsm0_4(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104B2)
#define DDRPHY_Tsm0_5(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105B2)
#define DDRPHY_Tsm0_6(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106B2)
#define DDRPHY_Tsm0_7(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107B2)
#define DDRPHY_Tsm0_8(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108B2)

#define DDRPHY_Tsm1_0(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B3)
#define DDRPHY_Tsm1_1(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101B3)
#define DDRPHY_Tsm1_2(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102B3)
#define DDRPHY_Tsm1_3(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103B3)
#define DDRPHY_Tsm1_4(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104B3)
#define DDRPHY_Tsm1_5(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105B3)
#define DDRPHY_Tsm1_6(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106B3)
#define DDRPHY_Tsm1_7(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107B3)
#define DDRPHY_Tsm1_8(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108B3)

#define DDRPHY_Tsm2_0(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B4)
#define DDRPHY_Tsm2_1(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101B4)
#define DDRPHY_Tsm2_2(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102B4)
#define DDRPHY_Tsm2_3(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103B4)
#define DDRPHY_Tsm2_4(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104B4)
#define DDRPHY_Tsm2_5(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105B4)
#define DDRPHY_Tsm2_6(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106B4)
#define DDRPHY_Tsm2_7(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107B4)
#define DDRPHY_Tsm2_8(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108B4)

#define DDRPHY_Tsm3_0(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B5)
#define DDRPHY_TxChkDataSelects_0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B6)
#define DDRPHY_DtsmUpThldXingInd_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B7)
#define DDRPHY_DtsmLoThldXingInd_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B8)
#define DDRPHY_DbyteAllDtsmCtrl0_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100B9)
#define DDRPHY_DbyteAllDtsmCtrl1_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100BA)
#define DDRPHY_DbyteAllDtsmCtrl2_0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100BB)

#define DDRPHY_TxDqDlyTg0_00(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100C0)
#define DDRPHY_TxDqDlyTg0_01(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101C0)
#define DDRPHY_TxDqDlyTg0_02(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102C0)
#define DDRPHY_TxDqDlyTg0_03(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103C0)
#define DDRPHY_TxDqDlyTg0_04(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104C0)
#define DDRPHY_TxDqDlyTg0_05(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105C0)
#define DDRPHY_TxDqDlyTg0_06(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106C0)
#define DDRPHY_TxDqDlyTg0_07(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107C0)
#define DDRPHY_TxDqDlyTg0_08(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108C0)
#define DDRPHY_TxDqDlyTg0_10(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100C0)
#define DDRPHY_TxDqDlyTg0_11(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101C0)
#define DDRPHY_TxDqDlyTg0_12(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1102C0)
#define DDRPHY_TxDqDlyTg0_13(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1103C0)
#define DDRPHY_TxDqDlyTg0_14(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1104C0)
#define DDRPHY_TxDqDlyTg0_15(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1105C0)
#define DDRPHY_TxDqDlyTg0_16(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1106C0)
#define DDRPHY_TxDqDlyTg0_17(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1107C0)
#define DDRPHY_TxDqDlyTg0_18(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1108C0)
#define DDRPHY_TxDqDlyTg0_20(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100C0)
#define DDRPHY_TxDqDlyTg0_21(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101C0)
#define DDRPHY_TxDqDlyTg0_22(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2102C0)
#define DDRPHY_TxDqDlyTg0_23(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2103C0)
#define DDRPHY_TxDqDlyTg0_24(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2104C0)
#define DDRPHY_TxDqDlyTg0_25(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2105C0)
#define DDRPHY_TxDqDlyTg0_26(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2106C0)
#define DDRPHY_TxDqDlyTg0_27(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2107C0)
#define DDRPHY_TxDqDlyTg0_28(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2108C0)
#define DDRPHY_TxDqDlyTg0_30(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100C0)
#define DDRPHY_TxDqDlyTg0_31(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101C0)
#define DDRPHY_TxDqDlyTg0_32(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3102C0)
#define DDRPHY_TxDqDlyTg0_33(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3103C0)
#define DDRPHY_TxDqDlyTg0_34(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3104C0)
#define DDRPHY_TxDqDlyTg0_35(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3105C0)
#define DDRPHY_TxDqDlyTg0_36(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3106C0)
#define DDRPHY_TxDqDlyTg0_37(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3107C0)
#define DDRPHY_TxDqDlyTg0_38(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3108C0)

#define DDRPHY_TxDqDlyTg1_00(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100C1)
#define DDRPHY_TxDqDlyTg1_01(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101C1)
#define DDRPHY_TxDqDlyTg1_02(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102C1)
#define DDRPHY_TxDqDlyTg1_03(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103C1)
#define DDRPHY_TxDqDlyTg1_04(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104C1)
#define DDRPHY_TxDqDlyTg1_05(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105C1)
#define DDRPHY_TxDqDlyTg1_06(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106C1)
#define DDRPHY_TxDqDlyTg1_07(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107C1)
#define DDRPHY_TxDqDlyTg1_08(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108C1)
#define DDRPHY_TxDqDlyTg1_10(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100C1)
#define DDRPHY_TxDqDlyTg1_11(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101C1)
#define DDRPHY_TxDqDlyTg1_12(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1102C1)
#define DDRPHY_TxDqDlyTg1_13(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1103C1)
#define DDRPHY_TxDqDlyTg1_14(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1104C1)
#define DDRPHY_TxDqDlyTg1_15(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1105C1)
#define DDRPHY_TxDqDlyTg1_16(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1106C1)
#define DDRPHY_TxDqDlyTg1_17(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1107C1)
#define DDRPHY_TxDqDlyTg1_18(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1108C1)
#define DDRPHY_TxDqDlyTg1_20(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100C1)
#define DDRPHY_TxDqDlyTg1_21(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101C1)
#define DDRPHY_TxDqDlyTg1_22(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2102C1)
#define DDRPHY_TxDqDlyTg1_23(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2103C1)
#define DDRPHY_TxDqDlyTg1_24(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2104C1)
#define DDRPHY_TxDqDlyTg1_25(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2105C1)
#define DDRPHY_TxDqDlyTg1_26(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2106C1)
#define DDRPHY_TxDqDlyTg1_27(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2107C1)
#define DDRPHY_TxDqDlyTg1_28(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2108C1)
#define DDRPHY_TxDqDlyTg1_30(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100C1)
#define DDRPHY_TxDqDlyTg1_31(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101C1)
#define DDRPHY_TxDqDlyTg1_32(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3102C1)
#define DDRPHY_TxDqDlyTg1_33(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3103C1)
#define DDRPHY_TxDqDlyTg1_34(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3104C1)
#define DDRPHY_TxDqDlyTg1_35(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3105C1)
#define DDRPHY_TxDqDlyTg1_36(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3106C1)
#define DDRPHY_TxDqDlyTg1_37(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3107C1)
#define DDRPHY_TxDqDlyTg1_38(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3108C1)

#define DDRPHY_TxDqDlyTg2_00(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100C2)
#define DDRPHY_TxDqDlyTg2_01(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101C2)
#define DDRPHY_TxDqDlyTg2_02(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102C2)
#define DDRPHY_TxDqDlyTg2_03(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103C2)
#define DDRPHY_TxDqDlyTg2_04(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104C2)
#define DDRPHY_TxDqDlyTg2_05(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105C2)
#define DDRPHY_TxDqDlyTg2_06(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106C2)
#define DDRPHY_TxDqDlyTg2_07(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107C2)
#define DDRPHY_TxDqDlyTg2_08(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108C2)
#define DDRPHY_TxDqDlyTg2_10(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100C2)
#define DDRPHY_TxDqDlyTg2_11(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101C2)
#define DDRPHY_TxDqDlyTg2_12(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1102C2)
#define DDRPHY_TxDqDlyTg2_13(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1103C2)
#define DDRPHY_TxDqDlyTg2_14(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1104C2)
#define DDRPHY_TxDqDlyTg2_15(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1105C2)
#define DDRPHY_TxDqDlyTg2_16(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1106C2)
#define DDRPHY_TxDqDlyTg2_17(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1107C2)
#define DDRPHY_TxDqDlyTg2_18(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1108C2)
#define DDRPHY_TxDqDlyTg2_20(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100C2)
#define DDRPHY_TxDqDlyTg2_21(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101C2)
#define DDRPHY_TxDqDlyTg2_22(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2102C2)
#define DDRPHY_TxDqDlyTg2_23(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2103C2)
#define DDRPHY_TxDqDlyTg2_24(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2104C2)
#define DDRPHY_TxDqDlyTg2_25(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2105C2)
#define DDRPHY_TxDqDlyTg2_26(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2106C2)
#define DDRPHY_TxDqDlyTg2_27(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2107C2)
#define DDRPHY_TxDqDlyTg2_28(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2108C2)
#define DDRPHY_TxDqDlyTg2_30(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100C2)
#define DDRPHY_TxDqDlyTg2_31(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101C2)
#define DDRPHY_TxDqDlyTg2_32(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3102C2)
#define DDRPHY_TxDqDlyTg2_33(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3103C2)
#define DDRPHY_TxDqDlyTg2_34(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3104C2)
#define DDRPHY_TxDqDlyTg2_35(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3105C2)
#define DDRPHY_TxDqDlyTg2_36(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3106C2)
#define DDRPHY_TxDqDlyTg2_37(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3107C2)
#define DDRPHY_TxDqDlyTg2_38(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3108C2)

#define DDRPHY_TxDqDlyTg3_00(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100C3)
#define DDRPHY_TxDqDlyTg3_01(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101C3)
#define DDRPHY_TxDqDlyTg3_02(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0102C3)
#define DDRPHY_TxDqDlyTg3_03(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0103C3)
#define DDRPHY_TxDqDlyTg3_04(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0104C3)
#define DDRPHY_TxDqDlyTg3_05(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0105C3)
#define DDRPHY_TxDqDlyTg3_06(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0106C3)
#define DDRPHY_TxDqDlyTg3_07(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0107C3)
#define DDRPHY_TxDqDlyTg3_08(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0108C3)
#define DDRPHY_TxDqDlyTg3_10(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100C3)
#define DDRPHY_TxDqDlyTg3_11(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101C3)
#define DDRPHY_TxDqDlyTg3_12(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1102C3)
#define DDRPHY_TxDqDlyTg3_13(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1103C3)
#define DDRPHY_TxDqDlyTg3_14(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1104C3)
#define DDRPHY_TxDqDlyTg3_15(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1105C3)
#define DDRPHY_TxDqDlyTg3_16(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1106C3)
#define DDRPHY_TxDqDlyTg3_17(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1107C3)
#define DDRPHY_TxDqDlyTg3_18(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1108C3)
#define DDRPHY_TxDqDlyTg3_20(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100C3)
#define DDRPHY_TxDqDlyTg3_21(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101C3)
#define DDRPHY_TxDqDlyTg3_22(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2102C3)
#define DDRPHY_TxDqDlyTg3_23(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2103C3)
#define DDRPHY_TxDqDlyTg3_24(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2104C3)
#define DDRPHY_TxDqDlyTg3_25(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2105C3)
#define DDRPHY_TxDqDlyTg3_26(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2106C3)
#define DDRPHY_TxDqDlyTg3_27(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2107C3)
#define DDRPHY_TxDqDlyTg3_28(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2108C3)
#define DDRPHY_TxDqDlyTg3_30(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100C3)
#define DDRPHY_TxDqDlyTg3_31(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101C3)
#define DDRPHY_TxDqDlyTg3_32(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3102C3)
#define DDRPHY_TxDqDlyTg3_33(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3103C3)
#define DDRPHY_TxDqDlyTg3_34(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3104C3)
#define DDRPHY_TxDqDlyTg3_35(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3105C3)
#define DDRPHY_TxDqDlyTg3_36(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3106C3)
#define DDRPHY_TxDqDlyTg3_37(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3107C3)
#define DDRPHY_TxDqDlyTg3_38(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3108C3)

#define DDRPHY_TxDqsDlyTg0_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100D0)
#define DDRPHY_TxDqsDlyTg0_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101D0)
#define DDRPHY_TxDqsDlyTg0_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100D0)
#define DDRPHY_TxDqsDlyTg0_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101D0)
#define DDRPHY_TxDqsDlyTg0_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100D0)
#define DDRPHY_TxDqsDlyTg0_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101D0)
#define DDRPHY_TxDqsDlyTg0_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100D0)
#define DDRPHY_TxDqsDlyTg0_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101D0)

#define DDRPHY_TxDqsDlyTg1_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100D1)
#define DDRPHY_TxDqsDlyTg1_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101D1)
#define DDRPHY_TxDqsDlyTg1_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100D1)
#define DDRPHY_TxDqsDlyTg1_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101D1)
#define DDRPHY_TxDqsDlyTg1_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100D1)
#define DDRPHY_TxDqsDlyTg1_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101D1)
#define DDRPHY_TxDqsDlyTg1_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100D1)
#define DDRPHY_TxDqsDlyTg1_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101D1)

#define DDRPHY_TxDqsDlyTg2_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100D2)
#define DDRPHY_TxDqsDlyTg2_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101D2)
#define DDRPHY_TxDqsDlyTg2_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100D2)
#define DDRPHY_TxDqsDlyTg2_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101D2)
#define DDRPHY_TxDqsDlyTg2_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100D2)
#define DDRPHY_TxDqsDlyTg2_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101D2)
#define DDRPHY_TxDqsDlyTg2_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100D2)
#define DDRPHY_TxDqsDlyTg2_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101D2)

#define DDRPHY_TxDqsDlyTg3_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0100D3)
#define DDRPHY_TxDqsDlyTg3_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0101D3)
#define DDRPHY_TxDqsDlyTg3_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1100D3)
#define DDRPHY_TxDqsDlyTg3_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1101D3)
#define DDRPHY_TxDqsDlyTg3_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2100D3)
#define DDRPHY_TxDqsDlyTg3_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2101D3)
#define DDRPHY_TxDqsDlyTg3_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3100D3)
#define DDRPHY_TxDqsDlyTg3_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3101D3)

#define DDRPHY_DctShadowRegs(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0004)
#define DDRPHY_DctWriteOnlyShadow(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0030)
#define DDRPHY_UctWriteOnly(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0032)
#define DDRPHY_UctWriteProt(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0033)
#define DDRPHY_UctDatWriteOnly(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0034)
#define DDRPHY_UctDatWriteProt(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0035)
#define DDRPHY_UctlErr(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0036)
#define DDRPHY_UcclkHclkEnables(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0080)
#define DDRPHY_CurPstate0b(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0081)
#define DDRPHY_ClrWakeupSticky(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0095)
#define DDRPHY_WakeupMask(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C0096)
#define DDRPHY_CUSTPUBREV(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C00ED)
#define DDRPHY_PUBREV(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0C00EE)

#define DDRPHY_PreSequenceReg0b0s0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090000)
#define DDRPHY_SequenceReg0b71s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090100)
#define DDRPHY_PreSequenceReg0b0s1(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090001)

#define DDRPHY_Seq0BGPR1_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090201)
#define DDRPHY_Seq0BGPR1_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190201)
#define DDRPHY_Seq0BGPR1_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290201)
#define DDRPHY_Seq0BGPR1_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390201)

#define DDRPHY_SequenceReg0b72s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090101)
#define DDRPHY_PreSequenceReg0b0s2(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090002)

#define DDRPHY_Seq0BGPR2_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090202)
#define DDRPHY_Seq0BGPR2_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190202)
#define DDRPHY_Seq0BGPR2_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290202)
#define DDRPHY_Seq0BGPR2_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390202)

#define DDRPHY_SequenceReg0b72s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090102)
#define DDRPHY_PreSequenceReg0b1s0(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090003)

#define DDRPHY_Seq0BGPR3_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090203)
#define DDRPHY_Seq0BGPR3_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190203)
#define DDRPHY_Seq0BGPR3_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290203)
#define DDRPHY_Seq0BGPR3_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390203)

#define DDRPHY_SequenceReg0b72s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090103)
#define DDRPHY_PreSequenceReg0b1s1(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090004)

#define DDRPHY_Seq0BGPR4_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090204)
#define DDRPHY_Seq0BGPR4_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190204)
#define DDRPHY_Seq0BGPR4_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290204)
#define DDRPHY_Seq0BGPR4_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390204)

#define DDRPHY_SequenceReg0b73s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090104)
#define DDRPHY_PreSequenceReg0b1s2(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090005)

#define DDRPHY_Seq0BGPR5_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090205)
#define DDRPHY_Seq0BGPR5_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190205)
#define DDRPHY_Seq0BGPR5_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290205)
#define DDRPHY_Seq0BGPR5_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390205)

#define DDRPHY_SequenceReg0b73s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090105)
#define DDRPHY_PostSequenceReg0b0s0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090006)

#define DDRPHY_Seq0BGPR6_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090206)
#define DDRPHY_Seq0BGPR6_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190206)
#define DDRPHY_Seq0BGPR6_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290206)
#define DDRPHY_Seq0BGPR6_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390206)

#define DDRPHY_SequenceReg0b73s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090106)
#define DDRPHY_PostSequenceReg0b0s1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090007)

#define DDRPHY_Seq0BGPR7_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090207)
#define DDRPHY_Seq0BGPR7_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190207)
#define DDRPHY_Seq0BGPR7_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290207)
#define DDRPHY_Seq0BGPR7_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390207)

#define DDRPHY_SequenceReg0b74s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090107)
#define DDRPHY_PostSequenceReg0b0s2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090008)

#define DDRPHY_Seq0BGPR8_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090208)
#define DDRPHY_Seq0BGPR8_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x190208)
#define DDRPHY_Seq0BGPR8_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x290208)
#define DDRPHY_Seq0BGPR8_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x390208)

#define DDRPHY_SequenceReg0b74s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090108)
#define DDRPHY_PostSequenceReg0b1s0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090009)
#define DDRPHY_SequenceReg0b74s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090109)
#define DDRPHY_PostSequenceReg0b1s1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000A)
#define DDRPHY_SequenceReg0b75s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010A)
#define DDRPHY_PostSequenceReg0b1s2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000B)
#define DDRPHY_SequenceReg0b75s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010B)

#define DDRPHY_Seq0BDisableFlag0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000C)
#define DDRPHY_SequenceReg0b75s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010C)
#define DDRPHY_Seq0BDisableFlag1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000D)
#define DDRPHY_SequenceReg0b76s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010D)
#define DDRPHY_Seq0BDisableFlag2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000E)
#define DDRPHY_SequenceReg0b76s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010E)
#define DDRPHY_Seq0BDisableFlag3(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09000F)
#define DDRPHY_SequenceReg0b76s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09010F)
#define DDRPHY_Seq0BDisableFlag4(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090010)
#define DDRPHY_SequenceReg0b77s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090110)
#define DDRPHY_Seq0BDisableFlag5(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090011)
#define DDRPHY_SequenceReg0b77s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090111)
#define DDRPHY_Seq0BDisableFlag6(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090012)
#define DDRPHY_SequenceReg0b77s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090112)
#define DDRPHY_Seq0BDisableFlag7(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090013)
#define DDRPHY_SequenceReg0b78s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090113)
#define DDRPHY_SequenceReg0b78s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090114)
#define DDRPHY_SequenceReg0b78s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090115)
#define DDRPHY_SequenceReg0b79s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090116)
#define DDRPHY_StartVector0b0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090017)
#define DDRPHY_SequenceReg0b79s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090117)
#define DDRPHY_StartVector0b1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090018)
#define DDRPHY_SequenceReg0b79s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090118)

#define DDRPHY_StartVector0b2(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090019)
#define DDRPHY_SequenceReg0b80s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090119)
#define DDRPHY_StartVector0b3(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001A)
#define DDRPHY_SequenceReg0b80s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011A)
#define DDRPHY_StartVector0b4(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001B)
#define DDRPHY_SequenceReg0b80s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011B)
#define DDRPHY_StartVector0b5(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001C)
#define DDRPHY_SequenceReg0b81s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011C)
#define DDRPHY_StartVector0b6(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001D)
#define DDRPHY_SequenceReg0b81s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011D)
#define DDRPHY_StartVector0b7(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001E)
#define DDRPHY_SequenceReg0b81s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011E)
#define DDRPHY_StartVector0b8(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09001F)
#define DDRPHY_SequenceReg0b82s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09011F)
#define DDRPHY_StartVector0b9(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090020)
#define DDRPHY_SequenceReg0b82s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090120)
#define DDRPHY_StartVector0b10(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090021)
#define DDRPHY_SequenceReg0b82s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090121)
#define DDRPHY_StartVector0b11(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090022)
#define DDRPHY_SequenceReg0b83s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090122)
#define DDRPHY_StartVector0b12(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090023)
#define DDRPHY_SequenceReg0b83s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090123)
#define DDRPHY_StartVector0b13(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090024)
#define DDRPHY_SequenceReg0b83s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090124)
#define DDRPHY_StartVector0b14(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090025)
#define DDRPHY_SequenceReg0b84s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090125)
#define DDRPHY_StartVector0b15(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090026)
#define DDRPHY_SequenceReg0b84s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090126)

#define DDRPHY_Seq0bWaitCondSel(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090027)
#define DDRPHY_SequenceReg0b84s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090127)
#define DDRPHY_PhyInLP3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090028)

#define DDRPHY_SequenceReg0b85s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090128)
#define DDRPHY_SequenceReg0b0s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090029)
#define DDRPHY_SequenceReg0b85s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090129)
#define DDRPHY_SequenceReg0b0s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002a)
#define DDRPHY_SequenceReg0b85s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012a)
#define DDRPHY_SequenceReg0b0s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002b)
#define DDRPHY_SequenceReg0b86s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012b)
#define DDRPHY_SequenceReg0b1s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002c)
#define DDRPHY_SequenceReg0b86s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012c)
#define DDRPHY_SequenceReg0b1s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002d)
#define DDRPHY_SequenceReg0b86s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012d)
#define DDRPHY_SequenceReg0b1s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002e)
#define DDRPHY_SequenceReg0b87s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012e)
#define DDRPHY_SequenceReg0b2s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09002f)
#define DDRPHY_SequenceReg0b87s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09012f)
#define DDRPHY_SequenceReg0b2s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090030)
#define DDRPHY_SequenceReg0b87s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090130)
#define DDRPHY_SequenceReg0b2s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090031)
#define DDRPHY_SequenceReg0b88s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090131)
#define DDRPHY_SequenceReg0b3s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090032)
#define DDRPHY_SequenceReg0b88s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090132)
#define DDRPHY_SequenceReg0b3s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090033)
#define DDRPHY_SequenceReg0b88s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090133)
#define DDRPHY_SequenceReg0b3s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090034)
#define DDRPHY_SequenceReg0b89s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090134)
#define DDRPHY_SequenceReg0b4s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090035)
#define DDRPHY_SequenceReg0b89s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090135)
#define DDRPHY_SequenceReg0b4s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090036)
#define DDRPHY_SequenceReg0b89s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090136)
#define DDRPHY_SequenceReg0b4s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090037)
#define DDRPHY_SequenceReg0b90s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090137)
#define DDRPHY_SequenceReg0b5s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090038)
#define DDRPHY_SequenceReg0b90s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090138)
#define DDRPHY_SequenceReg0b5s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090039)
#define DDRPHY_SequenceReg0b90s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090139)
#define DDRPHY_SequenceReg0b5s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003a)
#define DDRPHY_SequenceReg0b91s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013a)
#define DDRPHY_SequenceReg0b6s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003b)
#define DDRPHY_SequenceReg0b91s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013b)
#define DDRPHY_SequenceReg0b6s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003c)
#define DDRPHY_SequenceReg0b91s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013c)
#define DDRPHY_SequenceReg0b6s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003d)
#define DDRPHY_SequenceReg0b92s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013d)
#define DDRPHY_SequenceReg0b7s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003e)
#define DDRPHY_SequenceReg0b92s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013e)
#define DDRPHY_SequenceReg0b7s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09003f)
#define DDRPHY_SequenceReg0b92s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09013f)
#define DDRPHY_SequenceReg0b7s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090040)
#define DDRPHY_SequenceReg0b93s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090140)
#define DDRPHY_SequenceReg0b8s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090041)
#define DDRPHY_SequenceReg0b93s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090141)
#define DDRPHY_SequenceReg0b8s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090042)
#define DDRPHY_SequenceReg0b93s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090142)
#define DDRPHY_SequenceReg0b8s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090043)
#define DDRPHY_SequenceReg0b94s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090143)
#define DDRPHY_SequenceReg0b9s0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090044)
#define DDRPHY_SequenceReg0b94s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090144)
#define DDRPHY_SequenceReg0b9s1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090045)
#define DDRPHY_SequenceReg0b94s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090145)
#define DDRPHY_SequenceReg0b9s2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090046)
#define DDRPHY_SequenceReg0b95s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090146)
#define DDRPHY_SequenceReg0b10s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090047)
#define DDRPHY_SequenceReg0b95s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090147)
#define DDRPHY_SequenceReg0b10s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090048)
#define DDRPHY_SequenceReg0b95s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090148)
#define DDRPHY_SequenceReg0b10s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090049)
#define DDRPHY_SequenceReg0b96s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090149)
#define DDRPHY_SequenceReg0b11s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004a)
#define DDRPHY_SequenceReg0b96s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014a)
#define DDRPHY_SequenceReg0b11s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004b)
#define DDRPHY_SequenceReg0b96s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014b)
#define DDRPHY_SequenceReg0b11s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004c)
#define DDRPHY_SequenceReg0b97s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014c)
#define DDRPHY_SequenceReg0b12s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004d)
#define DDRPHY_SequenceReg0b97s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014d)
#define DDRPHY_SequenceReg0b12s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004e)
#define DDRPHY_SequenceReg0b97s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014e)
#define DDRPHY_SequenceReg0b12s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09004f)
#define DDRPHY_SequenceReg0b98s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09014f)
#define DDRPHY_SequenceReg0b13s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090050)
#define DDRPHY_SequenceReg0b98s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090150)
#define DDRPHY_SequenceReg0b13s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090051)
#define DDRPHY_SequenceReg0b98s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090151)
#define DDRPHY_SequenceReg0b13s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090052)
#define DDRPHY_SequenceReg0b99s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090152)
#define DDRPHY_SequenceReg0b14s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090053)
#define DDRPHY_SequenceReg0b99s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090153)
#define DDRPHY_SequenceReg0b14s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090054)
#define DDRPHY_SequenceReg0b99s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090154)
#define DDRPHY_SequenceReg0b14s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090055)
#define DDRPHY_SequenceReg0b100s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090155)
#define DDRPHY_SequenceReg0b15s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090056)
#define DDRPHY_SequenceReg0b100s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090156)
#define DDRPHY_SequenceReg0b15s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090057)
#define DDRPHY_SequenceReg0b100s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090157)
#define DDRPHY_SequenceReg0b15s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090058)
#define DDRPHY_SequenceReg0b101s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090158)
#define DDRPHY_SequenceReg0b16s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090059)
#define DDRPHY_SequenceReg0b101s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090159)
#define DDRPHY_SequenceReg0b16s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005a)
#define DDRPHY_SequenceReg0b101s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015a)
#define DDRPHY_SequenceReg0b16s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005b)
#define DDRPHY_SequenceReg0b102s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015b)
#define DDRPHY_SequenceReg0b17s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005c)
#define DDRPHY_SequenceReg0b102s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015c)
#define DDRPHY_SequenceReg0b17s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005d)
#define DDRPHY_SequenceReg0b102s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015d)
#define DDRPHY_SequenceReg0b17s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005e)
#define DDRPHY_SequenceReg0b103s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015e)
#define DDRPHY_SequenceReg0b18s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09005f)
#define DDRPHY_SequenceReg0b103s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09015f)
#define DDRPHY_SequenceReg0b18s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090060)
#define DDRPHY_SequenceReg0b103s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090160)
#define DDRPHY_SequenceReg0b18s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090061)
#define DDRPHY_SequenceReg0b104s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090161)
#define DDRPHY_SequenceReg0b19s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090062)
#define DDRPHY_SequenceReg0b104s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090162)
#define DDRPHY_SequenceReg0b19s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090063)
#define DDRPHY_SequenceReg0b104s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090163)
#define DDRPHY_SequenceReg0b19s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090064)
#define DDRPHY_SequenceReg0b105s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090164)
#define DDRPHY_SequenceReg0b20s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090065)
#define DDRPHY_SequenceReg0b105s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090165)
#define DDRPHY_SequenceReg0b20s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090066)
#define DDRPHY_SequenceReg0b105s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090166)
#define DDRPHY_SequenceReg0b20s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090067)
#define DDRPHY_SequenceReg0b106s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090167)
#define DDRPHY_SequenceReg0b21s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090068)
#define DDRPHY_SequenceReg0b106s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090168)
#define DDRPHY_SequenceReg0b21s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090069)
#define DDRPHY_SequenceReg0b106s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090169)
#define DDRPHY_SequenceReg0b21s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006a)
#define DDRPHY_SequenceReg0b107s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016a)
#define DDRPHY_SequenceReg0b22s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006b)
#define DDRPHY_SequenceReg0b107s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016b)
#define DDRPHY_SequenceReg0b22s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006c)
#define DDRPHY_SequenceReg0b107s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016c)
#define DDRPHY_SequenceReg0b22s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006d)
#define DDRPHY_SequenceReg0b108s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016d)
#define DDRPHY_SequenceReg0b23s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006e)
#define DDRPHY_SequenceReg0b108s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016e)
#define DDRPHY_SequenceReg0b23s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09006f)
#define DDRPHY_SequenceReg0b108s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09016f)
#define DDRPHY_SequenceReg0b23s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090070)
#define DDRPHY_SequenceReg0b109s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090170)
#define DDRPHY_SequenceReg0b24s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090071)
#define DDRPHY_SequenceReg0b109s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090171)
#define DDRPHY_SequenceReg0b24s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090072)
#define DDRPHY_SequenceReg0b109s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090172)
#define DDRPHY_SequenceReg0b24s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090073)
#define DDRPHY_SequenceReg0b110s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090173)
#define DDRPHY_SequenceReg0b25s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090074)
#define DDRPHY_SequenceReg0b110s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090174)
#define DDRPHY_SequenceReg0b25s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090075)
#define DDRPHY_SequenceReg0b110s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090175)
#define DDRPHY_SequenceReg0b25s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090076)
#define DDRPHY_SequenceReg0b111s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090176)
#define DDRPHY_SequenceReg0b26s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090077)
#define DDRPHY_SequenceReg0b111s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090177)
#define DDRPHY_SequenceReg0b26s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090078)
#define DDRPHY_SequenceReg0b111s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090178)
#define DDRPHY_SequenceReg0b26s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090079)
#define DDRPHY_SequenceReg0b112s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090179)
#define DDRPHY_SequenceReg0b27s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007a)
#define DDRPHY_SequenceReg0b112s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017a)
#define DDRPHY_SequenceReg0b27s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007b)
#define DDRPHY_SequenceReg0b112s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017b)
#define DDRPHY_SequenceReg0b27s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007c)
#define DDRPHY_SequenceReg0b113s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017c)
#define DDRPHY_SequenceReg0b28s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007d)
#define DDRPHY_SequenceReg0b113s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017d)
#define DDRPHY_SequenceReg0b28s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007e)
#define DDRPHY_SequenceReg0b113s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017e)
#define DDRPHY_SequenceReg0b28s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09007f)
#define DDRPHY_SequenceReg0b114s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09017f)
#define DDRPHY_SequenceReg0b29s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090080)
#define DDRPHY_SequenceReg0b114s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090180)
#define DDRPHY_SequenceReg0b29s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090081)
#define DDRPHY_SequenceReg0b114s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090181)
#define DDRPHY_SequenceReg0b29s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090082)
#define DDRPHY_SequenceReg0b115s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090182)
#define DDRPHY_SequenceReg0b30s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090083)
#define DDRPHY_SequenceReg0b115s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090183)
#define DDRPHY_SequenceReg0b30s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090084)
#define DDRPHY_SequenceReg0b115s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090184)
#define DDRPHY_SequenceReg0b30s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090085)
#define DDRPHY_SequenceReg0b116s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090185)
#define DDRPHY_SequenceReg0b31s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090086)
#define DDRPHY_SequenceReg0b116s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090186)
#define DDRPHY_SequenceReg0b31s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090087)
#define DDRPHY_SequenceReg0b116s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090187)
#define DDRPHY_SequenceReg0b31s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090088)
#define DDRPHY_SequenceReg0b117s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090188)
#define DDRPHY_SequenceReg0b32s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090089)
#define DDRPHY_SequenceReg0b117s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090189)
#define DDRPHY_SequenceReg0b32s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008a)
#define DDRPHY_SequenceReg0b117s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018a)
#define DDRPHY_SequenceReg0b32s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008b)
#define DDRPHY_SequenceReg0b118s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018b)
#define DDRPHY_SequenceReg0b33s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008c)
#define DDRPHY_SequenceReg0b118s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018c)
#define DDRPHY_SequenceReg0b33s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008d)
#define DDRPHY_SequenceReg0b118s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018d)
#define DDRPHY_SequenceReg0b33s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008e)
#define DDRPHY_SequenceReg0b119s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018e)
#define DDRPHY_SequenceReg0b34s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09008f)
#define DDRPHY_SequenceReg0b119s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09018f)
#define DDRPHY_SequenceReg0b34s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090090)
#define DDRPHY_SequenceReg0b119s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090190)
#define DDRPHY_SequenceReg0b34s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090091)
#define DDRPHY_SequenceReg0b120s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090191)
#define DDRPHY_SequenceReg0b35s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090092)
#define DDRPHY_SequenceReg0b120s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090192)
#define DDRPHY_SequenceReg0b35s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090093)
#define DDRPHY_SequenceReg0b120s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090193)
#define DDRPHY_SequenceReg0b35s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090094)
#define DDRPHY_SequenceReg0b121s0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090194)
#define DDRPHY_SequenceReg0b36s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090095)
#define DDRPHY_SequenceReg0b121s1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090195)
#define DDRPHY_SequenceReg0b36s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090096)
#define DDRPHY_SequenceReg0b121s2(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090196)
#define DDRPHY_SequenceReg0b36s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090097)
#define DDRPHY_SequenceReg0b37s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090098)
#define DDRPHY_SequenceReg0b37s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x090099)
#define DDRPHY_SequenceReg0b37s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009a)
#define DDRPHY_SequenceReg0b38s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009b)
#define DDRPHY_SequenceReg0b38s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009c)
#define DDRPHY_SequenceReg0b38s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009d)
#define DDRPHY_SequenceReg0b39s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009e)
#define DDRPHY_SequenceReg0b39s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x09009f)
#define DDRPHY_SequenceReg0b39s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a0)
#define DDRPHY_SequenceReg0b40s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a1)
#define DDRPHY_SequenceReg0b40s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a2)
#define DDRPHY_SequenceReg0b40s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a3)
#define DDRPHY_SequenceReg0b41s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a4)
#define DDRPHY_SequenceReg0b41s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a5)
#define DDRPHY_SequenceReg0b41s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a6)
#define DDRPHY_SequenceReg0b42s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a7)
#define DDRPHY_SequenceReg0b42s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a8)
#define DDRPHY_SequenceReg0b42s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900a9)
#define DDRPHY_SequenceReg0b43s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900aa)
#define DDRPHY_SequenceReg0b43s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ab)
#define DDRPHY_SequenceReg0b43s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ac)
#define DDRPHY_SequenceReg0b44s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ad)
#define DDRPHY_SequenceReg0b44s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ae)
#define DDRPHY_SequenceReg0b44s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900af)
#define DDRPHY_SequenceReg0b45s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b0)
#define DDRPHY_SequenceReg0b45s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b1)
#define DDRPHY_SequenceReg0b45s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b2)
#define DDRPHY_SequenceReg0b46s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b3)
#define DDRPHY_SequenceReg0b46s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b4)
#define DDRPHY_SequenceReg0b46s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b5)
#define DDRPHY_SequenceReg0b47s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b6)
#define DDRPHY_SequenceReg0b47s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b7)
#define DDRPHY_SequenceReg0b47s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b8)
#define DDRPHY_SequenceReg0b48s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900b9)
#define DDRPHY_SequenceReg0b48s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ba)
#define DDRPHY_SequenceReg0b48s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900bb)
#define DDRPHY_SequenceReg0b49s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900bc)
#define DDRPHY_SequenceReg0b49s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900bd)
#define DDRPHY_SequenceReg0b49s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900be)
#define DDRPHY_SequenceReg0b50s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900bf)
#define DDRPHY_SequenceReg0b50s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c0)
#define DDRPHY_SequenceReg0b50s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c1)
#define DDRPHY_SequenceReg0b51s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c2)
#define DDRPHY_SequenceReg0b51s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c3)
#define DDRPHY_SequenceReg0b51s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c4)
#define DDRPHY_SequenceReg0b52s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c5)
#define DDRPHY_SequenceReg0b52s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c6)
#define DDRPHY_SequenceReg0b52s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c7)
#define DDRPHY_SequenceReg0b53s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c8)
#define DDRPHY_SequenceReg0b53s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900c9)
#define DDRPHY_SequenceReg0b53s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ca)
#define DDRPHY_SequenceReg0b54s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900cb)
#define DDRPHY_SequenceReg0b54s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900cc)
#define DDRPHY_SequenceReg0b54s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900cd)
#define DDRPHY_SequenceReg0b55s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ce)
#define DDRPHY_SequenceReg0b55s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900cf)
#define DDRPHY_SequenceReg0b55s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d0)
#define DDRPHY_SequenceReg0b56s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d1)
#define DDRPHY_SequenceReg0b56s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d2)
#define DDRPHY_SequenceReg0b56s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d3)
#define DDRPHY_SequenceReg0b57s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d4)
#define DDRPHY_SequenceReg0b57s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d5)
#define DDRPHY_SequenceReg0b57s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d6)
#define DDRPHY_SequenceReg0b58s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d7)
#define DDRPHY_SequenceReg0b58s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d8)
#define DDRPHY_SequenceReg0b58s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900d9)
#define DDRPHY_SequenceReg0b59s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900da)
#define DDRPHY_SequenceReg0b59s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900db)
#define DDRPHY_SequenceReg0b59s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900dc)
#define DDRPHY_SequenceReg0b60s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900dd)
#define DDRPHY_SequenceReg0b60s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900de)
#define DDRPHY_SequenceReg0b60s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900df)
#define DDRPHY_SequenceReg0b61s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e0)
#define DDRPHY_SequenceReg0b61s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e1)
#define DDRPHY_SequenceReg0b61s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e2)
#define DDRPHY_SequenceReg0b62s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e3)
#define DDRPHY_SequenceReg0b62s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e4)
#define DDRPHY_SequenceReg0b62s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e5)
#define DDRPHY_SequenceReg0b63s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e6)
#define DDRPHY_SequenceReg0b63s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e7)
#define DDRPHY_SequenceReg0b63s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e8)
#define DDRPHY_SequenceReg0b64s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900e9)
#define DDRPHY_SequenceReg0b64s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ea)
#define DDRPHY_SequenceReg0b64s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900eb)
#define DDRPHY_SequenceReg0b65s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ec)
#define DDRPHY_SequenceReg0b65s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ed)
#define DDRPHY_SequenceReg0b65s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ee)
#define DDRPHY_SequenceReg0b66s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ef)
#define DDRPHY_SequenceReg0b66s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f0)
#define DDRPHY_SequenceReg0b66s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f1)
#define DDRPHY_SequenceReg0b67s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f2)
#define DDRPHY_SequenceReg0b67s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f3)
#define DDRPHY_SequenceReg0b67s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f4)
#define DDRPHY_SequenceReg0b68s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f5)
#define DDRPHY_SequenceReg0b68s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f6)
#define DDRPHY_SequenceReg0b68s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f7)
#define DDRPHY_SequenceReg0b69s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f8)
#define DDRPHY_SequenceReg0b69s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900f9)
#define DDRPHY_SequenceReg0b69s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900fa)
#define DDRPHY_SequenceReg0b70s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900fb)
#define DDRPHY_SequenceReg0b70s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900fc)
#define DDRPHY_SequenceReg0b70s2(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900fd)
#define DDRPHY_SequenceReg0b71s0(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900fe)
#define DDRPHY_SequenceReg0b71s1(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0900ff)

#define DDRPHY_RxFifoInit(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020000)
#define DDRPHY_MapCAA0toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020100)
#define DDRPHY_ForceClkDisable(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020001)
#define DDRPHY_MapCAA1toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020101)
#define DDRPHY_ClockingCtrl(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020002)
#define DDRPHY_MapCAA2toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020102)
#define DDRPHY_MapCAA3toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020103)
#define DDRPHY_MapCAA4toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020104)
#define DDRPHY_MapCAA5toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020105)
#define DDRPHY_MapCAA6toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020106)
#define DDRPHY_TestBumpCntrl1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020007)
#define DDRPHY_MapCAA7toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020107)

#define DDRPHY_CalUclkInfo_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020008)
#define DDRPHY_CalUclkInfo_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120008)
#define DDRPHY_CalUclkInfo_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220008)
#define DDRPHY_CalUclkInfo_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320008)

#define DDRPHY_MapCAA8toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020108)
#define DDRPHY_MapCAA9toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020109)
#define DDRPHY_TestBumpCntrl(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000A)

#define DDRPHY_Seq0BDLY0_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000B)
#define DDRPHY_Seq0BDLY0_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12000B)
#define DDRPHY_Seq0BDLY0_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22000B)
#define DDRPHY_Seq0BDLY0_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32000B)

#define DDRPHY_Seq0BDLY1_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000C)
#define DDRPHY_Seq0BDLY1_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12000C)
#define DDRPHY_Seq0BDLY1_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22000C)
#define DDRPHY_Seq0BDLY1_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32000C)

#define DDRPHY_Seq0BDLY2_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000D)
#define DDRPHY_Seq0BDLY2_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12000D)
#define DDRPHY_Seq0BDLY2_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22000D)
#define DDRPHY_Seq0BDLY2_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32000D)

#define DDRPHY_Seq0BDLY3_0(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000E)
#define DDRPHY_Seq0BDLY3_1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12000E)
#define DDRPHY_Seq0BDLY3_2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22000E)
#define DDRPHY_Seq0BDLY3_3(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32000E)

#define DDRPHY_PhyAlertStatus(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02000F)

#define DDRPHY_PPTTrainSetup_0(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020010)
#define DDRPHY_PPTTrainSetup_1(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120010)
#define DDRPHY_PPTTrainSetup_2(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220010)
#define DDRPHY_PPTTrainSetup_3(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320010)

#define DDRPHY_MapCAB0toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020110)

#define DDRPHY_PPTTrainSetup2_0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020011)
#define DDRPHY_PPTTrainSetup2_1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120011)
#define DDRPHY_PPTTrainSetup2_2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220011)
#define DDRPHY_PPTTrainSetup2_3(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320011)

#define DDRPHY_MapCAB1toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020111)
#define DDRPHY_ATestMode(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020012)
#define DDRPHY_MapCAB2toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020112)

#define DDRPHY_MapCAB3toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020113)
#define DDRPHY_TxCalBinP(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020014)
#define DDRPHY_MapCAB4toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020114)
#define DDRPHY_TxCalBinN(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020015)
#define DDRPHY_MapCAB5toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020115)
#define DDRPHY_TxCalPOvr(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020016)
#define DDRPHY_MapCAB6toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020116)
#define DDRPHY_TxCalNOvr(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020017)
#define DDRPHY_MapCAB7toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020117)
#define DDRPHY_DfiMode(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020018)
#define DDRPHY_MapCAB8toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020118)

#define DDRPHY_TristateModeCA_0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020019)
#define DDRPHY_TristateModeCA_1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120019)
#define DDRPHY_TristateModeCA_2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220019)
#define DDRPHY_TristateModeCA_3(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320019)

#define DDRPHY_MapCAB9toDfi(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020119)

#define DDRPHY_MtestMuxSel(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02001A)
#define DDRPHY_MtestPgmInfo(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02001B)
#define DDRPHY_DynPwrDnUp(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02001C)
#define DDRPHY_PMIEnable(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02001D)
#define DDRPHY_PhyTID(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02001E)

#define DDRPHY_HwtMRL_0(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020020)
#define DDRPHY_HwtMRL_1(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120020)
#define DDRPHY_HwtMRL_2(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220020)
#define DDRPHY_HwtMRL_3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320020)

#define DDRPHY_DFIPHYUPD(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020021)
#define DDRPHY_PdaMrsWriteMode(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020022)
#define DDRPHY_DFIGEARDOWNCTL(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020023)

#define DDRPHY_DqsPreambleControl_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020024)
#define DDRPHY_DqsPreambleControl_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120024)
#define DDRPHY_DqsPreambleControl_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220024)
#define DDRPHY_DqsPreambleControl_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320024)

#define DDRPHY_MasterX4Config(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020025)
#define DDRPHY_WrLevBits(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020026)
#define DDRPHY_EnableCsMulticast(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020027)
#define DDRPHY_Acx4AnibDis(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02002c)

#define DDRPHY_ImgDramMR3_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02002D)
#define DDRPHY_ImgDramMR3_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12002D)
#define DDRPHY_ImgDramMR3_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22002D)
#define DDRPHY_ImgDramMR3_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32002D)

#define DDRPHY_ARdPtrInitVal_0(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02002E)
#define DDRPHY_ARdPtrInitVal_1(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12002E)
#define DDRPHY_ARdPtrInitVal_2(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22002E)
#define DDRPHY_ARdPtrInitVal_3(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32002E)

#define DDRPHY_Db0LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020030)

#define DDRPHY_Db1LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020031)
#define DDRPHY_Db2LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020032)
#define DDRPHY_Db3LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020033)
#define DDRPHY_Db4LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020034)
#define DDRPHY_Db5LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020035)
#define DDRPHY_Db6LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020036)
#define DDRPHY_Db7LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020037)
#define DDRPHY_Db8LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020038)
#define DDRPHY_Db9LcdlCalPhDetOut(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020039)
#define DDRPHY_DbyteDllModeCntrl(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02003A)
#define DDRPHY_DbyteRxEnTrain(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02003B)
#define DDRPHY_AnLcdlCalPhDetOut(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02003F)
#define DDRPHY_CalOffsets(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020045)
#define DDRPHY_SarInitVals(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020047)
#define DDRPHY_CalPExtOvr(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020049)
#define DDRPHY_CalCmpr5Ovr(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02004A)
#define DDRPHY_CalNIntOvr(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02004B)
#define DDRPHY_CalDrvStr0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020050)

#define DDRPHY_ProcOdtCtl_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020055)
#define DDRPHY_ProcOdtCtl_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120055)
#define DDRPHY_ProcOdtCtl_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220055)
#define DDRPHY_ProcOdtCtl_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320055)

#define DDRPHY_ProcOdtTimeCtl_0(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020056)
#define DDRPHY_ProcOdtTimeCtl_1(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x120056)
#define DDRPHY_ProcOdtTimeCtl_2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x220056)
#define DDRPHY_ProcOdtTimeCtl_3(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x320056)

#define DDRPHY_MemAlertControl(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02005B)
#define DDRPHY_MemAlertControl2(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02005C)
#define DDRPHY_MemResetL(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020060)
#define DDRPHY_PUBMODE(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02006E)
#define DDRPHY_MiscPhyStatus(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02006F)
#define DDRPHY_CoreLoopbackSel(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020070)
#define DDRPHY_DllTrainParam(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020071)
#define DDRPHY_LpCsEnA(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020072)
#define DDRPHY_LpCsEnB(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020073)
#define DDRPHY_LpCsEnBypass(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020074)
#define DDRPHY_DfiCAMode(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020075)
#define DDRPHY_HwtCACtl(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020076)
#define DDRPHY_HwtCAMode(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020077)
#define DDRPHY_DllControl(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020078)
#define DDRPHY_PulseDllUpdatePhase(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020079)
#define DDRPHY_HwtControlOvr0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007A)
#define DDRPHY_HwtControlOvr1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007B)

#define DDRPHY_DllGainCtl_0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007C)
#define DDRPHY_DllGainCtl_1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x12007C)
#define DDRPHY_DllGainCtl_2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x22007C)
#define DDRPHY_DllGainCtl_3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x32007C)

#define DDRPHY_DllLockParam(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007D)
#define DDRPHY_HwtControlVal0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007E)
#define DDRPHY_HwtControlVal1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02007F)
#define DDRPHY_AcsmGlblStart(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020081)
#define DDRPHY_AcsmGlblSglStpCtrl(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020082)
#define DDRPHY_LcdlCalPhase(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020084)
#define DDRPHY_LcdlCalCtrl(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020085)
#define DDRPHY_CalRate(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020088)
#define DDRPHY_CalZap(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020089)
#define DDRPHY_PState(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02008B)
#define DDRPHY_CalPreDriverOverride(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02008C)
#define DDRPHY_PllOutGateControl(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02008D)
#define DDRPHY_UcMemResetControl(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02008F)

#define DDRPHY_PorControl(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020090)
#define DDRPHY_CalBusy(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020097)
#define DDRPHY_CalMisc2(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x020098)
#define DDRPHY_CalMisc(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02009A)
#define DDRPHY_CalCmpr5(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02009C)
#define DDRPHY_CalNInt(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02009D)
#define DDRPHY_CalPExt(X)                    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x02009E)
#define DDRPHY_CalCmpInvert(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200A8)
#define DDRPHY_CalCmpanaCntrl(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200AE)

#define DDRPHY_DfiRdDataCsDestMap_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B0)
#define DDRPHY_DfiRdDataCsDestMap_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200B0)
#define DDRPHY_DfiRdDataCsDestMap_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200B0)
#define DDRPHY_DfiRdDataCsDestMap_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200B0)

#define DDRPHY_VrefInGlobal_0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B2)
#define DDRPHY_VrefInGlobal_1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200B2)
#define DDRPHY_VrefInGlobal_2(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200B2)
#define DDRPHY_VrefInGlobal_3(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200B2)

#define DDRPHY_DfiWrDataCsDestMap_0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B4)
#define DDRPHY_DfiWrDataCsDestMap_1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200B4)
#define DDRPHY_DfiWrDataCsDestMap_2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200B4)
#define DDRPHY_DfiWrDataCsDestMap_3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200B4)

#define DDRPHY_PhyMasUpdGoodCtr(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B5)
#define DDRPHY_PhyCtlUpdGoodCtr(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B6)
#define DDRPHY_DctPhyUpdGoodCtr(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B7)
#define DDRPHY_PhyMasUpdFailCtr(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B8)
#define DDRPHY_PhyCtlUpdFailCtr(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200B9)
#define DDRPHY_PhyCtlUpd1FailCtr(X)          (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200BA)
#define DDRPHY_PhyPerfCtrEnable(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200BB)
#define DDRPHY_PllPwrDn(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C3)
#define DDRPHY_PllReset(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C4)
#define DDRPHY_PllCtrl2_0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C5)
#define DDRPHY_PllCtrl2_1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200C5)
#define DDRPHY_PllCtrl2_2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200C5)
#define DDRPHY_PllCtrl2_3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200C5)
#define DDRPHY_PllCtrl0(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C6)
#define DDRPHY_PllCtrl1_0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C7)
#define DDRPHY_PllCtrl1_1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200C7)
#define DDRPHY_PllCtrl1_2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200C7)
#define DDRPHY_PllCtrl1_3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200C7)
#define DDRPHY_PllTst(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C8)
#define DDRPHY_PllLockStatus(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200C9)
#define DDRPHY_PllTestMode_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CA)
#define DDRPHY_PllTestMode_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200CA)
#define DDRPHY_PllTestMode_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200CA)
#define DDRPHY_PllTestMode_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200CA)
#define DDRPHY_PllCtrl3(X)                   (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CB)
#define DDRPHY_PllCtrl4_0(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CC)
#define DDRPHY_PllCtrl4_1(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200CC)
#define DDRPHY_PllCtrl4_2(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200CC)
#define DDRPHY_PllCtrl4_3(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200CC)
#define DDRPHY_PllEndofCal(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CD)
#define DDRPHY_PllStandbyEff(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CE)
#define DDRPHY_PllDacValOut(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200CF)
#define DDRPHY_DlyTestSeq(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D0)
#define DDRPHY_DlyTestRingSelDb(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D1)
#define DDRPHY_DlyTestRingSelAc(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D2)
#define DDRPHY_DlyTestCntDfiClkIV(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D3)
#define DDRPHY_DlyTestCntDfiClk(X)           (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D4)
#define DDRPHY_DlyTestCntRingOscDb0(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D5)
#define DDRPHY_DlyTestCntRingOscDb1(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D6)
#define DDRPHY_DlyTestCntRingOscDb2(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D7)
#define DDRPHY_DlyTestCntRingOscDb3(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D8)
#define DDRPHY_DlyTestCntRingOscDb4(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200D9)
#define DDRPHY_DlyTestCntRingOscDb5(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DA)
#define DDRPHY_DlyTestCntRingOscDb6(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DB)
#define DDRPHY_DlyTestCntRingOscDb7(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DC)
#define DDRPHY_DlyTestCntRingOscDb8(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DD)
#define DDRPHY_DlyTestCntRingOscDb9(X)       (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DE)
#define DDRPHY_DlyTestCntRingOscAc(X)        (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200DF)
#define DDRPHY_MstLcdlDbgCntl(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200E0)
#define DDRPHY_MstLcdl0DbgRes(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200E1)
#define DDRPHY_MstLcdl1DbgRes(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200E2)
#define DDRPHY_CUSTPHYREV(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200ED)
#define DDRPHY_PHYREV(X)                     (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200EE)
#define DDRPHY_LP3ExitSeq0BStartVector(X)    (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200EF)
#define DDRPHY_DfiFreqXlat0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F0)
#define DDRPHY_DfiFreqXlat1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F1)
#define DDRPHY_DfiFreqXlat2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F2)
#define DDRPHY_DfiFreqXlat3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F3)
#define DDRPHY_DfiFreqXlat4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F4)
#define DDRPHY_DfiFreqXlat5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F5)
#define DDRPHY_DfiFreqXlat6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F6)
#define DDRPHY_DfiFreqXlat7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F7)
#define DDRPHY_TxRdPtrInit(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F8)
#define DDRPHY_DfiInitComplete(X)            (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200F9)

#define DDRPHY_DfiFreqRatio_0(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x0200FA)
#define DDRPHY_DfiFreqRatio_1(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x1200FA)
#define DDRPHY_DfiFreqRatio_2(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x2200FA)
#define DDRPHY_DfiFreqRatio_3(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x3200FA)

#define DDRPHY_PPGCCtrl1(X)                  (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070011)
#define DDRPHY_PpgcLane2CrcInMap0(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070015)
#define DDRPHY_PpgcLane2CrcInMap1(X)         (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070016)

#define DDRPHY_PrbsTapDly0_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070024)
#define DDRPHY_PrbsTapDly0_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070124)
#define DDRPHY_PrbsTapDly0_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070224)
#define DDRPHY_PrbsTapDly0_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070324)
#define DDRPHY_PrbsTapDly0_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070424)
#define DDRPHY_PrbsTapDly0_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070524)
#define DDRPHY_PrbsTapDly0_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070624)
#define DDRPHY_PrbsTapDly0_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070724)
#define DDRPHY_PrbsTapDly0_8(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070824)

#define DDRPHY_PrbsTapDly1_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070025)
#define DDRPHY_PrbsTapDly1_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070125)
#define DDRPHY_PrbsTapDly1_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070225)
#define DDRPHY_PrbsTapDly1_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070325)
#define DDRPHY_PrbsTapDly1_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070425)
#define DDRPHY_PrbsTapDly1_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070525)
#define DDRPHY_PrbsTapDly1_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070625)
#define DDRPHY_PrbsTapDly1_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070725)
#define DDRPHY_PrbsTapDly1_8(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070825)

#define DDRPHY_PrbsTapDly2_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070026)
#define DDRPHY_PrbsTapDly2_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070126)
#define DDRPHY_PrbsTapDly2_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070226)
#define DDRPHY_PrbsTapDly2_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070326)
#define DDRPHY_PrbsTapDly2_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070426)
#define DDRPHY_PrbsTapDly2_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070526)
#define DDRPHY_PrbsTapDly2_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070626)
#define DDRPHY_PrbsTapDly2_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070726)
#define DDRPHY_PrbsTapDly2_8(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070826)

#define DDRPHY_PrbsTapDly3_0(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070027)
#define DDRPHY_PrbsTapDly3_1(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070127)
#define DDRPHY_PrbsTapDly3_2(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070227)
#define DDRPHY_PrbsTapDly3_3(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070327)
#define DDRPHY_PrbsTapDly3_4(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070427)
#define DDRPHY_PrbsTapDly3_5(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070527)
#define DDRPHY_PrbsTapDly3_6(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070627)
#define DDRPHY_PrbsTapDly3_7(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070727)
#define DDRPHY_PrbsTapDly3_8(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070827)

#define DDRPHY_GenPrbsByte0(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070030)
#define DDRPHY_GenPrbsByte1(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070031)
#define DDRPHY_GenPrbsByte2(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070032)
#define DDRPHY_GenPrbsByte3(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070033)
#define DDRPHY_GenPrbsByte4(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070034)
#define DDRPHY_GenPrbsByte5(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070035)
#define DDRPHY_GenPrbsByte6(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070036)
#define DDRPHY_GenPrbsByte7(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070037)
#define DDRPHY_GenPrbsByte8(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070038)
#define DDRPHY_GenPrbsByte9(X)               (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070039)
#define DDRPHY_GenPrbsByte10(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003A)
#define DDRPHY_GenPrbsByte11(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003B)
#define DDRPHY_GenPrbsByte12(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003C)
#define DDRPHY_GenPrbsByte13(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003D)
#define DDRPHY_GenPrbsByte14(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003E)
#define DDRPHY_GenPrbsByte15(X)              (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x07003F)
#define DDRPHY_PrbsGenCtl(X)                 (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070060)
#define DDRPHY_PrbsGenStateLo(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070061)
#define DDRPHY_PrbsGenStateHi(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070062)
#define DDRPHY_PrbsChkStateLo(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070063)
#define DDRPHY_PrbsChkStateHi(X)             (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070064)
#define DDRPHY_PrbsGenCtl1(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070065)
#define DDRPHY_PrbsGenCtl2(X)                (IP2APB_DDRPHY_IPS_BASE_ADDR(X) + 4*0x070066)


#define DRC_PERF_MON_BASE_ADDR(X)            (0x3d800000 + (X * 0x2000000))
#define DRC_PERF_MON_CNT0_CTL(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x0)
#define DRC_PERF_MON_CNT1_CTL(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x4)
#define DRC_PERF_MON_CNT2_CTL(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x8)
#define DRC_PERF_MON_CNT3_CTL(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0xC)
#define DRC_PERF_MON_CNT0_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x20)
#define DRC_PERF_MON_CNT1_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x24)
#define DRC_PERF_MON_CNT2_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x28)
#define DRC_PERF_MON_CNT3_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x2C)
#define DRC_PERF_MON_MRR0_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x40)
#define DRC_PERF_MON_MRR1_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x44)
#define DRC_PERF_MON_MRR2_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x48)
#define DRC_PERF_MON_MRR3_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x4C)
#define DRC_PERF_MON_MRR4_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x50)
#define DRC_PERF_MON_MRR5_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x54)
#define DRC_PERF_MON_MRR6_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x58)
#define DRC_PERF_MON_MRR7_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x5C)
#define DRC_PERF_MON_MRR8_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x60)
#define DRC_PERF_MON_MRR9_DAT(X)             (DRC_PERF_MON_BASE_ADDR(X) + 0x64)
#define DRC_PERF_MON_MRR10_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x68)
#define DRC_PERF_MON_MRR11_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x6C)
#define DRC_PERF_MON_MRR12_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x70)
#define DRC_PERF_MON_MRR13_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x74)
#define DRC_PERF_MON_MRR14_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x78)
#define DRC_PERF_MON_MRR15_DAT(X)            (DRC_PERF_MON_BASE_ADDR(X) + 0x7C)
#endif
