/*
 * Copyright (c) 2005-2016 Freescale Semiconductor, Inc.
 * Copyright 2017 NXP
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
/* Instance: IMXDPU */

#ifndef IMXDPUV1_REGISTERS_H
#define IMXDPUV1_REGISTERS_H
/* Register: IMXDPUV1_comctrl_IPIdentifier */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER                        ((uint32_t)(0))
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_OFFSET                 ((uint32_t)(0))
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_RESET_VALUE            0x21340400U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNDELIVERYID_MASK  0xF0U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNDELIVERYID_SHIFT 4U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL_MASK 0xF00U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL_SHIFT 8U
/* Field Value: DESIGNMATURITYLEVEL__PREFS, Pre feasibility study.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL__PREFS 0x1U
/* Field Value: DESIGNMATURITYLEVEL__FS, Feasibility study.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL__FS 0x2U
/* Field Value: DESIGNMATURITYLEVEL__R0, Functionality complete.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL__R0 0x3U
/* Field Value: DESIGNMATURITYLEVEL__R1, Verification complete.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_DESIGNMATURITYLEVEL__R1 0x4U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPEVOLUTION_MASK       0xF000U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPEVOLUTION_SHIFT      12U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET_MASK      0xF0000U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET_SHIFT     16U
/* Field Value: IPFEATURESET__E, Minimal functionality (Eco).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET__E        0x1U
/* Field Value: IPFEATURESET__L, Reduced functionality (Light).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET__L        0x2U
/* Field Value: IPFEATURESET__P, Advanced functionality (Plus).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET__P        0x4U
/* Field Value: IPFEATURESET__X, Extensive functionality (eXtensive).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFEATURESET__X        0x5U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION_MASK     0xF00000U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION_SHIFT    20U
/* Field Value: IPAPPLICATION__B, Blit Engine only.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION__B       0x1U
/* Field Value: IPAPPLICATION__D, Blit Engine and Display Controller.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION__D       0x2U
/* Field Value: IPAPPLICATION__V, Display Controller only (with direct capture).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION__V       0x3U
/* Field Value: IPAPPLICATION__G, Blit Engine, Display Controller (with direct
 * capture), Capture Controller (buffered capture) and Drawing Engine.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION__G       0x4U
/* Field Value: IPAPPLICATION__C, Display Controller only.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPAPPLICATION__C       0x5U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPCONFIGURATION_MASK   0xF000000U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPCONFIGURATION_SHIFT  24U
/* Field Value: IPCONFIGURATION__M, Graphics core only (Module).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPCONFIGURATION__M     0x1U
/* Field Value: IPCONFIGURATION__S, Subsystem including a graphics core (System).  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPCONFIGURATION__S     0x2U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFAMILY_MASK          0xF0000000U
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFAMILY_SHIFT         28U
/* Field Value: IPFAMILY__IMXDPU2010, IMXDPU building block generation 2010.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFAMILY__IMXDPU2010   0U
/* Field Value: IPFAMILY__IMXDPU2012, IMXDPU building block generation 2012.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFAMILY__IMXDPU2012   0x1U
/* Field Value: IPFAMILY__IMXDPU2013, IMXDPU building block generation 2013.  */
#define IMXDPUV1_COMCTRL_IPIDENTIFIER_IPFAMILY__IMXDPU2013   0x2U

/* Register: IMXDPUV1_comctrl_LockUnlock */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK                          ((uint32_t)(0x40))
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_OFFSET                   ((uint32_t)(0x40))
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_COMCTRL_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_comctrl_LockStatus */
#define IMXDPUV1_COMCTRL_LOCKSTATUS                          ((uint32_t)(0x44))
#define IMXDPUV1_COMCTRL_LOCKSTATUS_OFFSET                   ((uint32_t)(0x44))
#define IMXDPUV1_COMCTRL_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_COMCTRL_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_comctrl_UserInterruptMask0 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0                  ((uint32_t)(0x48))
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0_OFFSET           ((uint32_t)(0x48))
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0_RESET_VALUE      0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0_USERINTERRUPTMASK0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK0_USERINTERRUPTMASK0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptMask1 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1                  ((uint32_t)(0x4C))
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1_OFFSET           ((uint32_t)(0x4C))
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1_RESET_VALUE      0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1_USERINTERRUPTMASK1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTMASK1_USERINTERRUPTMASK1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptEnable0 */
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0                    ((uint32_t)(0x50))
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0_OFFSET             ((uint32_t)(0x50))
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0_INTERRUPTENABLE0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE0_INTERRUPTENABLE0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptEnable1 */
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1                    ((uint32_t)(0x54))
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1_OFFSET             ((uint32_t)(0x54))
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1_INTERRUPTENABLE1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTENABLE1_INTERRUPTENABLE1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptPreset0 */
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0                    ((uint32_t)(0x58))
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0_OFFSET             ((uint32_t)(0x58))
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0_RESET_MASK         0U
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0_INTERRUPTPRESET0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET0_INTERRUPTPRESET0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptPreset1 */
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1                    ((uint32_t)(0x5C))
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1_OFFSET             ((uint32_t)(0x5C))
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1_RESET_MASK         0U
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1_INTERRUPTPRESET1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTPRESET1_INTERRUPTPRESET1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptClear0 */
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0                     ((uint32_t)(0x60))
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0_OFFSET              ((uint32_t)(0x60))
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0_RESET_VALUE         0U
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0_RESET_MASK          0U
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0_INTERRUPTCLEAR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR0_INTERRUPTCLEAR0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptClear1 */
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1                     ((uint32_t)(0x64))
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1_OFFSET              ((uint32_t)(0x64))
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1_RESET_VALUE         0U
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1_RESET_MASK          0U
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1_INTERRUPTCLEAR1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTCLEAR1_INTERRUPTCLEAR1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptStatus0 */
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0                    ((uint32_t)(0x68))
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0_OFFSET             ((uint32_t)(0x68))
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0_RESET_MASK         0U
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0_INTERRUPTSTATUS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS0_INTERRUPTSTATUS0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_InterruptStatus1 */
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1                    ((uint32_t)(0x6C))
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1_OFFSET             ((uint32_t)(0x6C))
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1_RESET_VALUE        0U
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1_RESET_MASK         0U
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1_INTERRUPTSTATUS1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_INTERRUPTSTATUS1_INTERRUPTSTATUS1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptEnable0 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0                ((uint32_t)(0x80))
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0_OFFSET         ((uint32_t)(0x80))
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0_USERINTERRUPTENABLE0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE0_USERINTERRUPTENABLE0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptEnable1 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1                ((uint32_t)(0x84))
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1_OFFSET         ((uint32_t)(0x84))
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1_USERINTERRUPTENABLE1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTENABLE1_USERINTERRUPTENABLE1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptPreset0 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0                ((uint32_t)(0x88))
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0_OFFSET         ((uint32_t)(0x88))
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0_RESET_MASK     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0_USERINTERRUPTPRESET0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET0_USERINTERRUPTPRESET0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptPreset1 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1                ((uint32_t)(0x8C))
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1_OFFSET         ((uint32_t)(0x8C))
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1_RESET_MASK     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1_USERINTERRUPTPRESET1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTPRESET1_USERINTERRUPTPRESET1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptClear0 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0                 ((uint32_t)(0x90))
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0_OFFSET          ((uint32_t)(0x90))
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0_RESET_VALUE     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0_RESET_MASK      0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0_USERINTERRUPTCLEAR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR0_USERINTERRUPTCLEAR0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptClear1 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1                 ((uint32_t)(0x94))
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1_OFFSET          ((uint32_t)(0x94))
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1_RESET_VALUE     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1_RESET_MASK      0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1_USERINTERRUPTCLEAR1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTCLEAR1_USERINTERRUPTCLEAR1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptStatus0 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0                ((uint32_t)(0x98))
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0_OFFSET         ((uint32_t)(0x98))
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0_RESET_MASK     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0_USERINTERRUPTSTATUS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS0_USERINTERRUPTSTATUS0_SHIFT 0U

/* Register: IMXDPUV1_comctrl_UserInterruptStatus1 */
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1                ((uint32_t)(0xA8))
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1_OFFSET         ((uint32_t)(0xA8))
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1_RESET_VALUE    0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1_RESET_MASK     0U
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1_USERINTERRUPTSTATUS1_MASK 0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_USERINTERRUPTSTATUS1_USERINTERRUPTSTATUS1_SHIFT 0U

/* Register: IMXDPUV1_comctrl_GeneralPurpose */
#define IMXDPUV1_COMCTRL_GENERALPURPOSE                      ((uint32_t)(0x100))
#define IMXDPUV1_COMCTRL_GENERALPURPOSE_OFFSET               ((uint32_t)(0x100))
#define IMXDPUV1_COMCTRL_GENERALPURPOSE_RESET_VALUE          0U
#define IMXDPUV1_COMCTRL_GENERALPURPOSE_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_GENERALPURPOSE_GENERALPURPOSE_MASK  0xFFFFFFFFU
#define IMXDPUV1_COMCTRL_GENERALPURPOSE_GENERALPURPOSE_SHIFT 0U

/* Register: IMXDPUV1_cmdseq_HIF */
#define IMXDPUV1_CMDSEQ_HIF                                  ((uint32_t)(0x400))
#define IMXDPUV1_CMDSEQ_HIF_OFFSET                           ((uint32_t)(0))
#define IMXDPUV1_CMDSEQ_HIF_RESET_VALUE                      0U
#define IMXDPUV1_CMDSEQ_HIF_RESET_MASK                       0U
#define IMXDPUV1_CMDSEQ_HIF_COMMANDFIFO_MASK                 0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_HIF_COMMANDFIFO_SHIFT                0U

/* Register: IMXDPUV1_cmdseq_LockUnlockHIF */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF                        ((uint32_t)(0x500))
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_OFFSET                 ((uint32_t)(0x100))
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_RESET_VALUE            0U
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_RESET_MASK             0U
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF_MASK     0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF_SHIFT    0U
/* Field Value: LOCKUNLOCKHIF__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCKHIF__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCKHIF__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCKHIF__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCKHIF__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCKHIF_LOCKUNLOCKHIF__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_cmdseq_LockStatusHIF */
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF                        ((uint32_t)(0x504))
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_OFFSET                 ((uint32_t)(0x104))
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_RESET_VALUE            0U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_LOCKSTATUSHIF_MASK     0x1U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_LOCKSTATUSHIF_SHIFT    0U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_PRIVILEGESTATUSHIF_MASK 0x10U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_PRIVILEGESTATUSHIF_SHIFT 4U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_FREEZESTATUSHIF_MASK   0x100U
#define IMXDPUV1_CMDSEQ_LOCKSTATUSHIF_FREEZESTATUSHIF_SHIFT  8U

/* Register: IMXDPUV1_cmdseq_LockUnlock */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK                           ((uint32_t)(0x580))
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_OFFSET                    ((uint32_t)(0x180))
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_RESET_VALUE               0U
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_RESET_MASK                0U
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK_MASK           0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK_SHIFT          0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY      0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY    0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CMDSEQ_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY    0xFBE8B1E6U

/* Register: IMXDPUV1_cmdseq_LockStatus */
#define IMXDPUV1_CMDSEQ_LOCKSTATUS                           ((uint32_t)(0x584))
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_OFFSET                    ((uint32_t)(0x184))
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_RESET_VALUE               0U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_LOCKSTATUS_MASK           0x1U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_LOCKSTATUS_SHIFT          0U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_PRIVILEGESTATUS_MASK      0x10U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_PRIVILEGESTATUS_SHIFT     4U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_FREEZESTATUS_MASK         0x100U
#define IMXDPUV1_CMDSEQ_LOCKSTATUS_FREEZESTATUS_SHIFT        8U

/* Register: IMXDPUV1_cmdseq_BufferAddress */
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS                        ((uint32_t)(0x588))
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_OFFSET                 ((uint32_t)(0x188))
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_RESET_VALUE            0U
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_LOCAL_MASK             0x1U
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_LOCAL_SHIFT            0U
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_ADDR_MASK              0xFFFFFFE0U
#define IMXDPUV1_CMDSEQ_BUFFERADDRESS_ADDR_SHIFT             5U

/* Register: IMXDPUV1_cmdseq_BufferSize */
#define IMXDPUV1_CMDSEQ_BUFFERSIZE                           ((uint32_t)(0x58C))
#define IMXDPUV1_CMDSEQ_BUFFERSIZE_OFFSET                    ((uint32_t)(0x18C))
#define IMXDPUV1_CMDSEQ_BUFFERSIZE_RESET_VALUE               0x80U
#define IMXDPUV1_CMDSEQ_BUFFERSIZE_RESET_MASK                0xFFF8U
#define IMXDPUV1_CMDSEQ_BUFFERSIZE_SIZE_MASK                 0xFFF8U
#define IMXDPUV1_CMDSEQ_BUFFERSIZE_SIZE_SHIFT                3U

/* Register: IMXDPUV1_cmdseq_WatermarkControl */
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL                     ((uint32_t)(0x590))
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_OFFSET              ((uint32_t)(0x190))
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_RESET_VALUE         0x600020U
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_LOWWM_MASK          0xFFFFU
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_LOWWM_SHIFT         0U
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_HIGHWM_MASK         0xFFFF0000U
#define IMXDPUV1_CMDSEQ_WATERMARKCONTROL_HIGHWM_SHIFT        16U

/* Register: IMXDPUV1_cmdseq_Control */
#define IMXDPUV1_CMDSEQ_CONTROL                              ((uint32_t)(0x594))
#define IMXDPUV1_CMDSEQ_CONTROL_OFFSET                       ((uint32_t)(0x194))
#define IMXDPUV1_CMDSEQ_CONTROL_RESET_VALUE                  0U
#define IMXDPUV1_CMDSEQ_CONTROL_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_CONTROL_CLRAXIW_MASK                 0x1U
#define IMXDPUV1_CMDSEQ_CONTROL_CLRAXIW_SHIFT                0U
#define IMXDPUV1_CMDSEQ_CONTROL_CLRRBUF_MASK                 0x4U
#define IMXDPUV1_CMDSEQ_CONTROL_CLRRBUF_SHIFT                2U
#define IMXDPUV1_CMDSEQ_CONTROL_CLRCMDBUF_MASK               0x8U
#define IMXDPUV1_CMDSEQ_CONTROL_CLRCMDBUF_SHIFT              3U
#define IMXDPUV1_CMDSEQ_CONTROL_CLEAR_MASK                   0x80000000U
#define IMXDPUV1_CMDSEQ_CONTROL_CLEAR_SHIFT                  31U

/* Register: IMXDPUV1_cmdseq_Status */
#define IMXDPUV1_CMDSEQ_STATUS                               ((uint32_t)(0x598))
#define IMXDPUV1_CMDSEQ_STATUS_OFFSET                        ((uint32_t)(0x198))
#define IMXDPUV1_CMDSEQ_STATUS_RESET_VALUE                   0x41000080U
#define IMXDPUV1_CMDSEQ_STATUS_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_CMDSEQ_STATUS_FIFOSPACE_MASK                0x1FFFFU
#define IMXDPUV1_CMDSEQ_STATUS_FIFOSPACE_SHIFT               0U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOEMPTY_MASK                0x1000000U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOEMPTY_SHIFT               24U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOFULL_MASK                 0x2000000U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOFULL_SHIFT                25U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOWMSTATE_MASK              0x4000000U
#define IMXDPUV1_CMDSEQ_STATUS_FIFOWMSTATE_SHIFT             26U
#define IMXDPUV1_CMDSEQ_STATUS_WATCHDOG_MASK                 0x8000000U
#define IMXDPUV1_CMDSEQ_STATUS_WATCHDOG_SHIFT                27U
#define IMXDPUV1_CMDSEQ_STATUS_READBUSY_MASK                 0x10000000U
#define IMXDPUV1_CMDSEQ_STATUS_READBUSY_SHIFT                28U
#define IMXDPUV1_CMDSEQ_STATUS_WRITEBUSY_MASK                0x20000000U
#define IMXDPUV1_CMDSEQ_STATUS_WRITEBUSY_SHIFT               29U
#define IMXDPUV1_CMDSEQ_STATUS_IDLE_MASK                     0x40000000U
#define IMXDPUV1_CMDSEQ_STATUS_IDLE_SHIFT                    30U
#define IMXDPUV1_CMDSEQ_STATUS_ERRORHALT_MASK                0x80000000U
#define IMXDPUV1_CMDSEQ_STATUS_ERRORHALT_SHIFT               31U

/* Register: IMXDPUV1_cmdseq_PrefetchWindowStart */
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART                  ((uint32_t)(0x59C))
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART_OFFSET           ((uint32_t)(0x19C))
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART_RESET_VALUE      0U
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART_RESET_MASK       0xFFFFFFFCU
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART_PWSTART_MASK     0xFFFFFFFCU
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWSTART_PWSTART_SHIFT    2U

/* Register: IMXDPUV1_cmdseq_PrefetchWindowEnd */
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND                    ((uint32_t)(0x5A0))
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND_OFFSET             ((uint32_t)(0x1A0))
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND_RESET_VALUE        0xFFFFFFFCU
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND_RESET_MASK         0xFFFFFFFCU
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND_PWEND_MASK         0xFFFFFFFCU
#define IMXDPUV1_CMDSEQ_PREFETCHWINDOWEND_PWEND_SHIFT        2U

/* Register: IMXDPUV1_pixengcfg_SafetyLockUnlock */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK                  ((uint32_t)(0x800))
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_OFFSET           ((uint32_t)(0))
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_RESET_MASK       0U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK_SHIFT 0U
/* Field Value: SAFETYLOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: SAFETYLOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: SAFETYLOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: SAFETYLOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: SAFETYLOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKUNLOCK_SAFETYLOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_SafetyLockStatus */
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS                  ((uint32_t)(0x804))
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_OFFSET           ((uint32_t)(0x4))
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYLOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYLOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYPRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYPRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYFREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_SAFETYLOCKSTATUS_SAFETYFREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_store9_SafetyMask */
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK                 ((uint32_t)(0x808))
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK_OFFSET          ((uint32_t)(0x8))
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK_RESET_VALUE     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK_STORE9_SAFETYMASK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_SAFETYMASK_STORE9_SAFETYMASK_SHIFT 0U

/* Register: IMXDPUV1_pixengcfg_extdst0_SafetyMask */
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK                ((uint32_t)(0x80C))
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK_OFFSET         ((uint32_t)(0xC))
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK_RESET_VALUE    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK_EXTDST0_SAFETYMASK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_SAFETYMASK_EXTDST0_SAFETYMASK_SHIFT 0U

/* Register: IMXDPUV1_pixengcfg_extdst4_SafetyMask */
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK                ((uint32_t)(0x810))
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK_OFFSET         ((uint32_t)(0x10))
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK_RESET_VALUE    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK_EXTDST4_SAFETYMASK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_SAFETYMASK_EXTDST4_SAFETYMASK_SHIFT 0U

/* Register: IMXDPUV1_pixengcfg_extdst1_SafetyMask_0 */
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0              ((uint32_t)(0x814))
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0_OFFSET       ((uint32_t)(0x14))
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0_RESET_VALUE  0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0_EXTDST1_SAFETYMASK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_SAFETYMASK_0_EXTDST1_SAFETYMASK_SHIFT 0U

/* Register: IMXDPUV1_pixengcfg_extdst5_SafetyMask */
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK                ((uint32_t)(0x818))
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK_OFFSET         ((uint32_t)(0x18))
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK_RESET_VALUE    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK_EXTDST5_SAFETYMASK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_SAFETYMASK_EXTDST5_SAFETYMASK_SHIFT 0U

/* Register: IMXDPUV1_pixengcfg_fetchdecode9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK           ((uint32_t)(0x820))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_OFFSET    ((uint32_t)(0x20))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHDECODE9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHDECODE9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHDECODE9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege
 * protection. Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHDECODE9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHDECODE9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKUNLOCK_FETCHDECODE9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchdecode9_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS           ((uint32_t)(0x824))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_OFFSET    ((uint32_t)(0x24))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_LOCKSTATUS_FETCHDECODE9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchdecode9_Dynamic */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC              ((uint32_t)(0x828))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_OFFSET       ((uint32_t)(0x28))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_FETCHDECODE9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_FETCHDECODE9_SRC_SEL_SHIFT 0U
/* Field Value: FETCHDECODE9_SRC_SEL__DISABLE, Unit fetchdecode9 input port
 * src is disabled  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_FETCHDECODE9_SRC_SEL__DISABLE 0U
/* Field Value: FETCHDECODE9_SRC_SEL__FETCHECO9, Unit fetchdecode9 input port
 * src is connected to output of unit fetcheco9  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_FETCHDECODE9_SRC_SEL__FETCHECO9 0x3U
/* Field Value: FETCHDECODE9_SRC_SEL__FETCHPERSP9, Unit fetchdecode9 input
 * port src is connected to output of unit fetchpersp9  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_DYNAMIC_FETCHDECODE9_SRC_SEL__FETCHPERSP9 0x2U

/* Register: IMXDPUV1_pixengcfg_fetchdecode9_Status */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS               ((uint32_t)(0x82C))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_OFFSET        ((uint32_t)(0x2C))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_RESET_MASK    0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL_SHIFT 16U
/* Field Value: FETCHDECODE9_SEL__STORE9, fetchdecode9 module is used from
 * store9 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__STORE9 0x1U
/* Field Value: FETCHDECODE9_SEL__EXTDST0, fetchdecode9 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__EXTDST0 0x2U
/* Field Value: FETCHDECODE9_SEL__EXTDST4, fetchdecode9 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__EXTDST4 0x3U
/* Field Value: FETCHDECODE9_SEL__EXTDST1, fetchdecode9 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__EXTDST1 0x4U
/* Field Value: FETCHDECODE9_SEL__EXTDST5, fetchdecode9 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__EXTDST5 0x5U
/* Field Value: FETCHDECODE9_SEL__STORE4, fetchdecode9 module is used from
 * store4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__STORE4 0x6U
/* Field Value: FETCHDECODE9_SEL__STORE5, fetchdecode9 module is used from
 * store5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__STORE5 0x7U
/* Field Value: FETCHDECODE9_SEL__DISABLE, fetchdecode9 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE9_STATUS_FETCHDECODE9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetchwarp9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK             ((uint32_t)(0x840))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_OFFSET      ((uint32_t)(0x40))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_RESET_MASK  0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHWARP9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHWARP9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHWARP9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHWARP9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHWARP9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKUNLOCK_FETCHWARP9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchwarp9_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS             ((uint32_t)(0x844))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_OFFSET      ((uint32_t)(0x44))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_LOCKSTATUS_FETCHWARP9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchwarp9_Dynamic */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC                ((uint32_t)(0x848))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_OFFSET         ((uint32_t)(0x48))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_FETCHWARP9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_FETCHWARP9_SRC_SEL_SHIFT 0U
/* Field Value: FETCHWARP9_SRC_SEL__DISABLE, Unit fetchpersp9 input port src
 * is disabled  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_FETCHWARP9_SRC_SEL__DISABLE 0U
/* Field Value: FETCHWARP9_SRC_SEL__FETCHECO9, Unit fetchpersp9 input port
 * src is connected to output of unit fetcheco9  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_DYNAMIC_FETCHWARP9_SRC_SEL__FETCHECO9 0x3U

/* Register: IMXDPUV1_pixengcfg_fetchwarp9_Status */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS                 ((uint32_t)(0x84C))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_OFFSET          ((uint32_t)(0x4C))
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_RESET_VALUE     0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_RESET_MASK      0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL_SHIFT 16U
/* Field Value: FETCHWARP9_SEL__STORE9, fetchpersp9 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__STORE9 0x1U
/* Field Value: FETCHWARP9_SEL__EXTDST0, fetchpersp9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__EXTDST0 0x2U
/* Field Value: FETCHWARP9_SEL__EXTDST4, fetchpersp9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__EXTDST4 0x3U
/* Field Value: FETCHWARP9_SEL__EXTDST1, fetchpersp9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__EXTDST1 0x4U
/* Field Value: FETCHWARP9_SEL__EXTDST5, fetchpersp9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__EXTDST5 0x5U
/* Field Value: FETCHWARP9_SEL__STORE4, fetchpersp9 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__STORE4 0x6U
/* Field Value: FETCHWARP9_SEL__STORE5, fetchpersp9 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__STORE5 0x7U
/* Field Value: FETCHWARP9_SEL__DISABLE, fetchpersp9 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP9_STATUS_FETCHWARP9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetcheco9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK              ((uint32_t)(0x850))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_OFFSET       ((uint32_t)(0x50))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_RESET_MASK   0U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHECO9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHECO9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHECO9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHECO9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHECO9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKUNLOCK_FETCHECO9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetcheco9_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS              ((uint32_t)(0x854))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_OFFSET       ((uint32_t)(0x54))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_LOCKSTATUS_FETCHECO9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetcheco9_Status */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS                  ((uint32_t)(0x858))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_OFFSET           ((uint32_t)(0x58))
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_RESET_MASK       0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL_SHIFT 16U
/* Field Value: FETCHECO9_SEL__STORE9, fetcheco9 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__STORE9 0x1U
/* Field Value: FETCHECO9_SEL__EXTDST0, fetcheco9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__EXTDST0 0x2U
/* Field Value: FETCHECO9_SEL__EXTDST4, fetcheco9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__EXTDST4 0x3U
/* Field Value: FETCHECO9_SEL__EXTDST1, fetcheco9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__EXTDST1 0x4U
/* Field Value: FETCHECO9_SEL__EXTDST5, fetcheco9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__EXTDST5 0x5U
/* Field Value: FETCHECO9_SEL__STORE4, fetcheco9 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__STORE4 0x6U
/* Field Value: FETCHECO9_SEL__STORE5, fetcheco9 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__STORE5 0x7U
/* Field Value: FETCHECO9_SEL__DISABLE, fetcheco9 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHECO9_STATUS_FETCHECO9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_rop9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK                   ((uint32_t)(0x860))
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_OFFSET            ((uint32_t)(0x60))
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_RESET_MASK        0U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK_SHIFT 0U
/* Field Value: ROP9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: ROP9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: ROP9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: ROP9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: ROP9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKUNLOCK_ROP9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_rop9_LockStatus */
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS                   ((uint32_t)(0x864))
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_OFFSET            ((uint32_t)(0x64))
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_ROP9_LOCKSTATUS_ROP9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_rop9_Dynamic */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC                      ((uint32_t)(0x868))
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_OFFSET               ((uint32_t)(0x68))
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_RESET_VALUE          0x1000000U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_PRIM_SEL_MASK   0x3FU
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_PRIM_SEL_SHIFT  0U
/* Field Value: ROP9_PRIM_SEL__DISABLE, Unit rop9 input port prim is disabled  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_PRIM_SEL__DISABLE 0U
/* Field Value: ROP9_PRIM_SEL__FETCHDECODE9, Unit rop9 input port prim is
 * connected to output of unit fetchdecode9  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_PRIM_SEL__FETCHDECODE9 0x1U
/* Field Value: ROP9_PRIM_SEL__FETCHPERSP9, Unit rop9 input port prim is connected
 * to output of unit fetchpersp9  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_PRIM_SEL__FETCHPERSP9 0x2U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_SEC_SEL_MASK    0x3F00U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_SEC_SEL_SHIFT   8U
/* Field Value: ROP9_SEC_SEL__DISABLE, Unit rop9 input port sec is disabled  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_SEC_SEL__DISABLE 0U
/* Field Value: ROP9_SEC_SEL__FETCHECO9, Unit rop9 input port sec is connected
 * to output of unit fetcheco9  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_SEC_SEL__FETCHECO9 0x3U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_TERT_SEL_MASK   0x3F0000U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_TERT_SEL_SHIFT  16U
/* Field Value: ROP9_TERT_SEL__DISABLE, Unit rop9 input port tert is disabled  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_TERT_SEL__DISABLE 0U
/* Field Value: ROP9_TERT_SEL__FETCHDECODE9, Unit rop9 input port tert is
 * connected to output of unit fetchdecode9  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_TERT_SEL__FETCHDECODE9 0x1U
/* Field Value: ROP9_TERT_SEL__FETCHPERSP9, Unit rop9 input port tert is connected
 * to output of unit fetchpersp9  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_TERT_SEL__FETCHPERSP9 0x2U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_CLKEN_MASK      0x3000000U
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_CLKEN_SHIFT     24U
/* Field Value: ROP9_CLKEN__DISABLE, Clock for rop9 is disabled  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_CLKEN__DISABLE  0U
/* Field Value: ROP9_CLKEN__AUTOMATIC, Clock is enabled if unit is used, frequency
 * is defined by the register setting for this pipeline (see [endpoint_name]_Static
 * register)  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_CLKEN__AUTOMATIC 0x1U
/* Field Value: ROP9_CLKEN__FULL, Clock for rop9 is without gating  */
#define IMXDPUV1_PIXENGCFG_ROP9_DYNAMIC_ROP9_CLKEN__FULL     0x3U

/* Register: IMXDPUV1_pixengcfg_rop9_Status */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS                       ((uint32_t)(0x86C))
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_OFFSET                ((uint32_t)(0x6C))
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_RESET_VALUE           0U
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_RESET_MASK            0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL_MASK         0x70000U
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL_SHIFT        16U
/* Field Value: ROP9_SEL__STORE9, rop9 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__STORE9      0x1U
/* Field Value: ROP9_SEL__EXTDST0, rop9 module is used from extdst0 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__EXTDST0     0x2U
/* Field Value: ROP9_SEL__EXTDST4, rop9 module is used from extdst4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__EXTDST4     0x3U
/* Field Value: ROP9_SEL__EXTDST1, rop9 module is used from extdst1 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__EXTDST1     0x4U
/* Field Value: ROP9_SEL__EXTDST5, rop9 module is used from extdst5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__EXTDST5     0x5U
/* Field Value: ROP9_SEL__STORE4, rop9 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__STORE4      0x6U
/* Field Value: ROP9_SEL__STORE5, rop9 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__STORE5      0x7U
/* Field Value: ROP9_SEL__DISABLE, rop9 module is not used  */
#define IMXDPUV1_PIXENGCFG_ROP9_STATUS_ROP9_SEL__DISABLE     0U

/* Register: IMXDPUV1_pixengcfg_clut9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK                  ((uint32_t)(0x880))
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_OFFSET           ((uint32_t)(0x80))
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_RESET_MASK       0U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK_SHIFT 0U
/* Field Value: CLUT9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: CLUT9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: CLUT9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: CLUT9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: CLUT9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKUNLOCK_CLUT9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_clut9_LockStatus */
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS                  ((uint32_t)(0x884))
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_OFFSET           ((uint32_t)(0x84))
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_CLUT9_LOCKSTATUS_CLUT9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_clut9_Dynamic */
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC                     ((uint32_t)(0x888))
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_OFFSET              ((uint32_t)(0x88))
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_RESET_VALUE         0U
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_CLUT9_SRC_SEL_MASK  0x3FU
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_CLUT9_SRC_SEL_SHIFT 0U
/* Field Value: CLUT9_SRC_SEL__DISABLE, Unit clut9 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_CLUT9_SRC_SEL__DISABLE 0U
/* Field Value: CLUT9_SRC_SEL__BLITBLEND9, Unit clut9 input port src is connected
 * to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_CLUT9_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: CLUT9_SRC_SEL__ROP9, Unit clut9 input port src is connected
 * to output of unit rop9  */
#define IMXDPUV1_PIXENGCFG_CLUT9_DYNAMIC_CLUT9_SRC_SEL__ROP9 0x4U

/* Register: IMXDPUV1_pixengcfg_clut9_Status */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS                      ((uint32_t)(0x88C))
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_OFFSET               ((uint32_t)(0x8C))
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_RESET_VALUE          0U
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_RESET_MASK           0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL_MASK       0x70000U
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL_SHIFT      16U
/* Field Value: CLUT9_SEL__STORE9, clut9 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__STORE9    0x1U
/* Field Value: CLUT9_SEL__EXTDST0, clut9 module is used from extdst0 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__EXTDST0   0x2U
/* Field Value: CLUT9_SEL__EXTDST4, clut9 module is used from extdst4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__EXTDST4   0x3U
/* Field Value: CLUT9_SEL__EXTDST1, clut9 module is used from extdst1 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__EXTDST1   0x4U
/* Field Value: CLUT9_SEL__EXTDST5, clut9 module is used from extdst5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__EXTDST5   0x5U
/* Field Value: CLUT9_SEL__STORE4, clut9 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__STORE4    0x6U
/* Field Value: CLUT9_SEL__STORE5, clut9 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__STORE5    0x7U
/* Field Value: CLUT9_SEL__DISABLE, clut9 module is not used  */
#define IMXDPUV1_PIXENGCFG_CLUT9_STATUS_CLUT9_SEL__DISABLE   0U

/* Register: IMXDPUV1_pixengcfg_matrix9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK                ((uint32_t)(0x8A0))
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_OFFSET         ((uint32_t)(0xA0))
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK_SHIFT 0U
/* Field Value: MATRIX9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: MATRIX9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: MATRIX9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: MATRIX9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: MATRIX9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKUNLOCK_MATRIX9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_matrix9_LockStatus */
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS                ((uint32_t)(0x8A4))
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_OFFSET         ((uint32_t)(0xA4))
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_MATRIX9_LOCKSTATUS_MATRIX9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_matrix9_Dynamic */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC                   ((uint32_t)(0x8A8))
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_OFFSET            ((uint32_t)(0xA8))
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_RESET_VALUE       0x1000000U
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL_SHIFT 0U
/* Field Value: MATRIX9_SRC_SEL__DISABLE, Unit matrix9 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL__DISABLE 0U
/* Field Value: MATRIX9_SRC_SEL__CLUT9, Unit matrix9 input port src is connected
 * to output of unit clut9  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL__CLUT9 0x5U
/* Field Value: MATRIX9_SRC_SEL__BLITBLEND9, Unit matrix9 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: MATRIX9_SRC_SEL__ROP9, Unit matrix9 input port src is connected
 * to output of unit rop9  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_SRC_SEL__ROP9 0x4U
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_CLKEN_SHIFT 24U
/* Field Value: MATRIX9_CLKEN__DISABLE, Clock for matrix9 is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_CLKEN__DISABLE 0U
/* Field Value: MATRIX9_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_CLKEN__AUTOMATIC 0x1U
/* Field Value: MATRIX9_CLKEN__FULL, Clock for matrix9 is without gating  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_DYNAMIC_MATRIX9_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_matrix9_Status */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS                    ((uint32_t)(0x8AC))
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_OFFSET             ((uint32_t)(0xAC))
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_RESET_MASK         0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL_MASK   0x70000U
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL_SHIFT  16U
/* Field Value: MATRIX9_SEL__STORE9, matrix9 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__STORE9 0x1U
/* Field Value: MATRIX9_SEL__EXTDST0, matrix9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__EXTDST0 0x2U
/* Field Value: MATRIX9_SEL__EXTDST4, matrix9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__EXTDST4 0x3U
/* Field Value: MATRIX9_SEL__EXTDST1, matrix9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__EXTDST1 0x4U
/* Field Value: MATRIX9_SEL__EXTDST5, matrix9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__EXTDST5 0x5U
/* Field Value: MATRIX9_SEL__STORE4, matrix9 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__STORE4 0x6U
/* Field Value: MATRIX9_SEL__STORE5, matrix9 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__STORE5 0x7U
/* Field Value: MATRIX9_SEL__DISABLE, matrix9 module is not used  */
#define IMXDPUV1_PIXENGCFG_MATRIX9_STATUS_MATRIX9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_hscaler9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK               ((uint32_t)(0x8C0))
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_OFFSET        ((uint32_t)(0xC0))
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK_SHIFT 0U
/* Field Value: HSCALER9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: HSCALER9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: HSCALER9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: HSCALER9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: HSCALER9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKUNLOCK_HSCALER9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_hscaler9_LockStatus */
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS               ((uint32_t)(0x8C4))
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_OFFSET        ((uint32_t)(0xC4))
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_HSCALER9_LOCKSTATUS_HSCALER9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_hscaler9_Dynamic */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC                  ((uint32_t)(0x8C8))
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_OFFSET           ((uint32_t)(0xC8))
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL_SHIFT 0U
/* Field Value: HSCALER9_SRC_SEL__DISABLE, Unit hscaler9 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL__DISABLE 0U
/* Field Value: HSCALER9_SRC_SEL__VSCALER9, Unit hscaler9 input port src is
 * connected to output of unit vscaler9  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL__VSCALER9 0x8U
/* Field Value: HSCALER9_SRC_SEL__FILTER9, Unit hscaler9 input port src is
 * connected to output of unit filter9  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL__FILTER9 0x9U
/* Field Value: HSCALER9_SRC_SEL__MATRIX9, Unit hscaler9 input port src is
 * connected to output of unit matrix9  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_SRC_SEL__MATRIX9 0x6U
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_CLKEN_SHIFT 24U
/* Field Value: HSCALER9_CLKEN__DISABLE, Clock for hscaler9 is disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_CLKEN__DISABLE 0U
/* Field Value: HSCALER9_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_CLKEN__AUTOMATIC 0x1U
/* Field Value: HSCALER9_CLKEN__FULL, Clock for hscaler9 is without gating  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_DYNAMIC_HSCALER9_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_hscaler9_Status */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS                   ((uint32_t)(0x8CC))
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_OFFSET            ((uint32_t)(0xCC))
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL_SHIFT 16U
/* Field Value: HSCALER9_SEL__STORE9, hscaler9 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__STORE9 0x1U
/* Field Value: HSCALER9_SEL__EXTDST0, hscaler9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__EXTDST0 0x2U
/* Field Value: HSCALER9_SEL__EXTDST4, hscaler9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__EXTDST4 0x3U
/* Field Value: HSCALER9_SEL__EXTDST1, hscaler9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__EXTDST1 0x4U
/* Field Value: HSCALER9_SEL__EXTDST5, hscaler9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__EXTDST5 0x5U
/* Field Value: HSCALER9_SEL__STORE4, hscaler9 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__STORE4 0x6U
/* Field Value: HSCALER9_SEL__STORE5, hscaler9 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__STORE5 0x7U
/* Field Value: HSCALER9_SEL__DISABLE, hscaler9 module is not used  */
#define IMXDPUV1_PIXENGCFG_HSCALER9_STATUS_HSCALER9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_vscaler9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK               ((uint32_t)(0x8E0))
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_OFFSET        ((uint32_t)(0xE0))
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK_SHIFT 0U
/* Field Value: VSCALER9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: VSCALER9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: VSCALER9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: VSCALER9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: VSCALER9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKUNLOCK_VSCALER9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_vscaler9_LockStatus */
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS               ((uint32_t)(0x8E4))
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_OFFSET        ((uint32_t)(0xE4))
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_VSCALER9_LOCKSTATUS_VSCALER9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_vscaler9_Dynamic */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC                  ((uint32_t)(0x8E8))
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_OFFSET           ((uint32_t)(0xE8))
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_SRC_SEL_SHIFT 0U
/* Field Value: VSCALER9_SRC_SEL__DISABLE, Unit vscaler9 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_SRC_SEL__DISABLE 0U
/* Field Value: VSCALER9_SRC_SEL__HSCALER9, Unit vscaler9 input port src is
 * connected to output of unit hscaler9  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_SRC_SEL__HSCALER9 0x7U
/* Field Value: VSCALER9_SRC_SEL__MATRIX9, Unit vscaler9 input port src is
 * connected to output of unit matrix9  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_SRC_SEL__MATRIX9 0x6U
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_CLKEN_SHIFT 24U
/* Field Value: VSCALER9_CLKEN__DISABLE, Clock for vscaler9 is disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_CLKEN__DISABLE 0U
/* Field Value: VSCALER9_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_CLKEN__AUTOMATIC 0x1U
/* Field Value: VSCALER9_CLKEN__FULL, Clock for vscaler9 is without gating  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_DYNAMIC_VSCALER9_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_vscaler9_Status */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS                   ((uint32_t)(0x8EC))
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_OFFSET            ((uint32_t)(0xEC))
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL_SHIFT 16U
/* Field Value: VSCALER9_SEL__STORE9, vscaler9 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__STORE9 0x1U
/* Field Value: VSCALER9_SEL__EXTDST0, vscaler9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__EXTDST0 0x2U
/* Field Value: VSCALER9_SEL__EXTDST4, vscaler9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__EXTDST4 0x3U
/* Field Value: VSCALER9_SEL__EXTDST1, vscaler9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__EXTDST1 0x4U
/* Field Value: VSCALER9_SEL__EXTDST5, vscaler9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__EXTDST5 0x5U
/* Field Value: VSCALER9_SEL__STORE4, vscaler9 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__STORE4 0x6U
/* Field Value: VSCALER9_SEL__STORE5, vscaler9 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__STORE5 0x7U
/* Field Value: VSCALER9_SEL__DISABLE, vscaler9 module is not used  */
#define IMXDPUV1_PIXENGCFG_VSCALER9_STATUS_VSCALER9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_filter9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK                ((uint32_t)(0x900))
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_OFFSET         ((uint32_t)(0x100))
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK_SHIFT 0U
/* Field Value: FILTER9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FILTER9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FILTER9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FILTER9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FILTER9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKUNLOCK_FILTER9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_filter9_LockStatus */
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS                ((uint32_t)(0x904))
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_OFFSET         ((uint32_t)(0x104))
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FILTER9_LOCKSTATUS_FILTER9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_filter9_Dynamic */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC                   ((uint32_t)(0x908))
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_OFFSET            ((uint32_t)(0x108))
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_RESET_VALUE       0x1000000U
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_SRC_SEL_SHIFT 0U
/* Field Value: FILTER9_SRC_SEL__DISABLE, Unit filter9 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_SRC_SEL__DISABLE 0U
/* Field Value: FILTER9_SRC_SEL__HSCALER9, Unit filter9 input port src is
 * connected to output of unit hscaler9  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_SRC_SEL__HSCALER9 0x7U
/* Field Value: FILTER9_SRC_SEL__MATRIX9, Unit filter9 input port src is connected
 * to output of unit matrix9  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_SRC_SEL__MATRIX9 0x6U
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_CLKEN_SHIFT 24U
/* Field Value: FILTER9_CLKEN__DISABLE, Clock for filter9 is disabled  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_CLKEN__DISABLE 0U
/* Field Value: FILTER9_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_CLKEN__AUTOMATIC 0x1U
/* Field Value: FILTER9_CLKEN__FULL, Clock for filter9 is without gating  */
#define IMXDPUV1_PIXENGCFG_FILTER9_DYNAMIC_FILTER9_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_filter9_Status */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS                    ((uint32_t)(0x90C))
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_OFFSET             ((uint32_t)(0x10C))
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_RESET_MASK         0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL_MASK   0x70000U
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL_SHIFT  16U
/* Field Value: FILTER9_SEL__STORE9, filter9 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__STORE9 0x1U
/* Field Value: FILTER9_SEL__EXTDST0, filter9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__EXTDST0 0x2U
/* Field Value: FILTER9_SEL__EXTDST4, filter9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__EXTDST4 0x3U
/* Field Value: FILTER9_SEL__EXTDST1, filter9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__EXTDST1 0x4U
/* Field Value: FILTER9_SEL__EXTDST5, filter9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__EXTDST5 0x5U
/* Field Value: FILTER9_SEL__STORE4, filter9 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__STORE4 0x6U
/* Field Value: FILTER9_SEL__STORE5, filter9 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__STORE5 0x7U
/* Field Value: FILTER9_SEL__DISABLE, filter9 module is not used  */
#define IMXDPUV1_PIXENGCFG_FILTER9_STATUS_FILTER9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_blitblend9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK             ((uint32_t)(0x920))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_OFFSET      ((uint32_t)(0x120))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_RESET_MASK  0U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK_SHIFT 0U
/* Field Value: BLITBLEND9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: BLITBLEND9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: BLITBLEND9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: BLITBLEND9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: BLITBLEND9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKUNLOCK_BLITBLEND9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_blitblend9_LockStatus */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS             ((uint32_t)(0x924))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_OFFSET      ((uint32_t)(0x124))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_LOCKSTATUS_BLITBLEND9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_blitblend9_Dynamic */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC                ((uint32_t)(0x928))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_OFFSET         ((uint32_t)(0x128))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_RESET_VALUE    0x1000000U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL_SHIFT 0U
/* Field Value: BLITBLEND9_PRIM_SEL__DISABLE, Unit blitblend9 input port prim
 * is disabled  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL__DISABLE 0U
/* Field Value: BLITBLEND9_PRIM_SEL__HSCALER9, Unit blitblend9 input port
 * prim is connected to output of unit hscaler9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL__HSCALER9 0x7U
/* Field Value: BLITBLEND9_PRIM_SEL__VSCALER9, Unit blitblend9 input port
 * prim is connected to output of unit vscaler9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL__VSCALER9 0x8U
/* Field Value: BLITBLEND9_PRIM_SEL__FILTER9, Unit blitblend9 input port prim
 * is connected to output of unit filter9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL__FILTER9 0x9U
/* Field Value: BLITBLEND9_PRIM_SEL__ROP9, Unit blitblend9 input port prim
 * is connected to output of unit rop9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_PRIM_SEL__ROP9 0x4U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_SEC_SEL_MASK 0x3F00U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_SEC_SEL_SHIFT 8U
/* Field Value: BLITBLEND9_SEC_SEL__DISABLE, Unit blitblend9 input port sec
 * is disabled  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_SEC_SEL__DISABLE 0U
/* Field Value: BLITBLEND9_SEC_SEL__FETCHDECODE9, Unit blitblend9 input port
 * sec is connected to output of unit fetchdecode9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_SEC_SEL__FETCHDECODE9 0x1U
/* Field Value: BLITBLEND9_SEC_SEL__FETCHPERSP9, Unit blitblend9 input port
 * sec is connected to output of unit fetchpersp9  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_SEC_SEL__FETCHPERSP9 0x2U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_CLKEN_SHIFT 24U
/* Field Value: BLITBLEND9_CLKEN__DISABLE, Clock for blitblend9 is disabled  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_CLKEN__DISABLE 0U
/* Field Value: BLITBLEND9_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_CLKEN__AUTOMATIC 0x1U
/* Field Value: BLITBLEND9_CLKEN__FULL, Clock for blitblend9 is without gating  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_DYNAMIC_BLITBLEND9_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_blitblend9_Status */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS                 ((uint32_t)(0x92C))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_OFFSET          ((uint32_t)(0x12C))
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_RESET_VALUE     0U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_RESET_MASK      0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL_SHIFT 16U
/* Field Value: BLITBLEND9_SEL__STORE9, blitblend9 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__STORE9 0x1U
/* Field Value: BLITBLEND9_SEL__EXTDST0, blitblend9 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__EXTDST0 0x2U
/* Field Value: BLITBLEND9_SEL__EXTDST4, blitblend9 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__EXTDST4 0x3U
/* Field Value: BLITBLEND9_SEL__EXTDST1, blitblend9 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__EXTDST1 0x4U
/* Field Value: BLITBLEND9_SEL__EXTDST5, blitblend9 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__EXTDST5 0x5U
/* Field Value: BLITBLEND9_SEL__STORE4, blitblend9 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__STORE4 0x6U
/* Field Value: BLITBLEND9_SEL__STORE5, blitblend9 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__STORE5 0x7U
/* Field Value: BLITBLEND9_SEL__DISABLE, blitblend9 module is not used  */
#define IMXDPUV1_PIXENGCFG_BLITBLEND9_STATUS_BLITBLEND9_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_store9_LockUnlock */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK                 ((uint32_t)(0x940))
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_OFFSET          ((uint32_t)(0x140))
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_RESET_VALUE     0U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_RESET_MASK      0U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK_SHIFT 0U
/* Field Value: STORE9_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: STORE9_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: STORE9_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: STORE9_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: STORE9_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKUNLOCK_STORE9_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_store9_LockStatus */
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS                 ((uint32_t)(0x944))
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_OFFSET          ((uint32_t)(0x144))
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_RESET_VALUE     0U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_STORE9_LOCKSTATUS_STORE9_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_store9_Static */
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC                     ((uint32_t)(0x948))
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_OFFSET              ((uint32_t)(0x148))
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_RESET_VALUE         0x800010U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SHDEN_MASK   0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SHDEN_SHIFT  0U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_POWERDOWN_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_POWERDOWN_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SYNC_MODE_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SYNC_MODE_SHIFT 8U
/* Field Value: STORE9_SYNC_MODE__SINGLE, Reconfig pipeline after explicit
 * trigger  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SYNC_MODE__SINGLE 0U
/* Field Value: STORE9_SYNC_MODE__AUTO, Reconfig pipeline after every kick
 * when idle  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SYNC_MODE__AUTO 0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SW_RESET_MASK 0x800U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SW_RESET_SHIFT 11U
/* Field Value: STORE9_SW_RESET__OPERATION, Normal Operation  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SW_RESET__OPERATION 0U
/* Field Value: STORE9_SW_RESET__SWRESET, Software Reset  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_SW_RESET__SWRESET 0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_DIV_MASK     0xFF0000U
#define IMXDPUV1_PIXENGCFG_STORE9_STATIC_STORE9_DIV_SHIFT    16U

/* Register: IMXDPUV1_pixengcfg_store9_Dynamic */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC                    ((uint32_t)(0x94C))
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_OFFSET             ((uint32_t)(0x14C))
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_RESET_VALUE        0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL_SHIFT 0U
/* Field Value: STORE9_SRC_SEL__DISABLE, Unit store9 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__DISABLE 0U
/* Field Value: STORE9_SRC_SEL__HSCALER9, Unit store9 input port src is connected
 * to output of unit hscaler9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__HSCALER9 0x7U
/* Field Value: STORE9_SRC_SEL__VSCALER9, Unit store9 input port src is connected
 * to output of unit vscaler9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__VSCALER9 0x8U
/* Field Value: STORE9_SRC_SEL__FILTER9, Unit store9 input port src is connected
 * to output of unit filter9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__FILTER9 0x9U
/* Field Value: STORE9_SRC_SEL__BLITBLEND9, Unit store9 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: STORE9_SRC_SEL__FETCHDECODE9, Unit store9 input port src is
 * connected to output of unit fetchdecode9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__FETCHDECODE9 0x1U
/* Field Value: STORE9_SRC_SEL__FETCHPERSP9, Unit store9 input port src is
 * connected to output of unit fetchpersp9  */
#define IMXDPUV1_PIXENGCFG_STORE9_DYNAMIC_STORE9_SRC_SEL__FETCHPERSP9 0x2U

/* Register: IMXDPUV1_pixengcfg_store9_Request */
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST                    ((uint32_t)(0x950))
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_OFFSET             ((uint32_t)(0x150))
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_STORE9_SEL_SHDLDREQ_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_STORE9_SEL_SHDLDREQ_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_STORE9_SHDLDREQ_MASK 0x3FFFFEU
#define IMXDPUV1_PIXENGCFG_STORE9_REQUEST_STORE9_SHDLDREQ_SHIFT 1U

/* Register: IMXDPUV1_pixengcfg_store9_Trigger */
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER                    ((uint32_t)(0x954))
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_OFFSET             ((uint32_t)(0x154))
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_RESET_MASK         0xFFFFFFEEU
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_STORE9_SYNC_TRIGGER_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_STORE9_SYNC_TRIGGER_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_STORE9_TRIGGER_SEQUENCE_COMPLETE_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_STORE9_TRIGGER_STORE9_TRIGGER_SEQUENCE_COMPLETE_SHIFT 4U

/* Register: IMXDPUV1_pixengcfg_store9_Status */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS                     ((uint32_t)(0x958))
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_OFFSET              ((uint32_t)(0x158))
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_RESET_VALUE         0U
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS_MASK 0x3U
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS_SHIFT 0U
/* Field Value: STORE9_PIPELINE_STATUS__EMPTY, Pipeline with endpoint store9
 * is empty  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS__EMPTY 0U
/* Field Value: STORE9_PIPELINE_STATUS__RUNNING, Pipeline with endpoint store9
 * is currently processing one operation  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS__RUNNING 0x1U
/* Field Value: STORE9_PIPELINE_STATUS__RUNNING_RETRIGGERED, Pipeline with
 * endpoint store9 is currently processing one operation with a second one
 * already kicked to be processed afterwards  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS__RUNNING_RETRIGGERED 0x2U
/* Field Value: STORE9_PIPELINE_STATUS__RESERVED, reserved  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_PIPELINE_STATUS__RESERVED 0x3U
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_SYNC_BUSY_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_SYNC_BUSY_SHIFT 8U
/* Field Value: STORE9_SYNC_BUSY__IDLE, store9 synchronizer is idle  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_SYNC_BUSY__IDLE 0U
/* Field Value: STORE9_SYNC_BUSY__BUSY, store9 synchronizer is busy  */
#define IMXDPUV1_PIXENGCFG_STORE9_STATUS_STORE9_SYNC_BUSY__BUSY 0x1U

/* Register: IMXDPUV1_pixengcfg_constframe0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK            ((uint32_t)(0x960))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_OFFSET     ((uint32_t)(0x160))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK_SHIFT 0U
/* Field Value: CONSTFRAME0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: CONSTFRAME0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: CONSTFRAME0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: CONSTFRAME0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: CONSTFRAME0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKUNLOCK_CONSTFRAME0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_constframe0_LockStatus */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS            ((uint32_t)(0x964))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_OFFSET     ((uint32_t)(0x164))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_LOCKSTATUS_CONSTFRAME0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_constframe0_Status */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS                ((uint32_t)(0x968))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_OFFSET         ((uint32_t)(0x168))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL_SHIFT 16U
/* Field Value: CONSTFRAME0_SEL__STORE9, constframe0 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__STORE9 0x1U
/* Field Value: CONSTFRAME0_SEL__EXTDST0, constframe0 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__EXTDST0 0x2U
/* Field Value: CONSTFRAME0_SEL__EXTDST4, constframe0 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__EXTDST4 0x3U
/* Field Value: CONSTFRAME0_SEL__EXTDST1, constframe0 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__EXTDST1 0x4U
/* Field Value: CONSTFRAME0_SEL__EXTDST5, constframe0 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__EXTDST5 0x5U
/* Field Value: CONSTFRAME0_SEL__STORE4, constframe0 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__STORE4 0x6U
/* Field Value: CONSTFRAME0_SEL__STORE5, constframe0 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__STORE5 0x7U
/* Field Value: CONSTFRAME0_SEL__DISABLE, constframe0 module is not used  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME0_STATUS_CONSTFRAME0_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_extdst0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK                ((uint32_t)(0x980))
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_OFFSET         ((uint32_t)(0x180))
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK_SHIFT 0U
/* Field Value: EXTDST0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: EXTDST0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: EXTDST0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: EXTDST0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: EXTDST0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKUNLOCK_EXTDST0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_extdst0_LockStatus */
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS                ((uint32_t)(0x984))
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_OFFSET         ((uint32_t)(0x184))
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST0_LOCKSTATUS_EXTDST0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_extdst0_Static */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC                    ((uint32_t)(0x988))
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_OFFSET             ((uint32_t)(0x188))
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_RESET_VALUE        0x800010U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SHDEN_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SHDEN_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_POWERDOWN_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_POWERDOWN_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SYNC_MODE_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SYNC_MODE_SHIFT 8U
/* Field Value: EXTDST0_SYNC_MODE__SINGLE, Reconfig pipeline after explicit
 * trigger  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SYNC_MODE__SINGLE 0U
/* Field Value: EXTDST0_SYNC_MODE__AUTO, Reconfig pipeline after every kick
 * when idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SYNC_MODE__AUTO 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SW_RESET_MASK 0x800U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SW_RESET_SHIFT 11U
/* Field Value: EXTDST0_SW_RESET__OPERATION, Normal Operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SW_RESET__OPERATION 0U
/* Field Value: EXTDST0_SW_RESET__SWRESET, Software Reset  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_SW_RESET__SWRESET 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_DIV_MASK   0xFF0000U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATIC_EXTDST0_DIV_SHIFT  16U

/* Register: IMXDPUV1_pixengcfg_extdst0_Dynamic */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC                   ((uint32_t)(0x98C))
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_OFFSET            ((uint32_t)(0x18C))
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_RESET_VALUE       0x2CU
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL_SHIFT 0U
/* Field Value: EXTDST0_SRC_SEL__DISABLE, Unit extdst0 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__DISABLE 0U
/* Field Value: EXTDST0_SRC_SEL__BLITBLEND9, Unit extdst0 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: EXTDST0_SRC_SEL__CONSTFRAME0, Unit extdst0 input port src
 * is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__CONSTFRAME0 0xCU
/* Field Value: EXTDST0_SRC_SEL__CONSTFRAME1, Unit extdst0 input port src
 * is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__CONSTFRAME1 0x10U
/* Field Value: EXTDST0_SRC_SEL__CONSTFRAME4, Unit extdst0 input port src
 * is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__CONSTFRAME4 0xEU
/* Field Value: EXTDST0_SRC_SEL__CONSTFRAME5, Unit extdst0 input port src
 * is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__CONSTFRAME5 0x12U
/* Field Value: EXTDST0_SRC_SEL__MATRIX4, Unit extdst0 input port src is connected
 * to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__MATRIX4 0x23U
/* Field Value: EXTDST0_SRC_SEL__HSCALER4, Unit extdst0 input port src is
 * connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__HSCALER4 0x24U
/* Field Value: EXTDST0_SRC_SEL__VSCALER4, Unit extdst0 input port src is
 * connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__VSCALER4 0x25U
/* Field Value: EXTDST0_SRC_SEL__EXTSRC4, Unit extdst0 input port src is connected
 * to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__EXTSRC4 0x14U
/* Field Value: EXTDST0_SRC_SEL__MATRIX5, Unit extdst0 input port src is connected
 * to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__MATRIX5 0x28U
/* Field Value: EXTDST0_SRC_SEL__HSCALER5, Unit extdst0 input port src is
 * connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__HSCALER5 0x29U
/* Field Value: EXTDST0_SRC_SEL__VSCALER5, Unit extdst0 input port src is
 * connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__VSCALER5 0x2AU
/* Field Value: EXTDST0_SRC_SEL__EXTSRC5, Unit extdst0 input port src is connected
 * to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__EXTSRC5 0x16U
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND6, Unit extdst0 input port src
 * is connected to output of unit layerblend6  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND6 0x32U
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND5, Unit extdst0 input port src
 * is connected to output of unit layerblend5  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND5 0x31U
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND4, Unit extdst0 input port src
 * is connected to output of unit layerblend4  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND4 0x30U
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND3, Unit extdst0 input port src
 * is connected to output of unit layerblend3  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND3 0x2FU
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND2, Unit extdst0 input port src
 * is connected to output of unit layerblend2  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND2 0x2EU
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND1, Unit extdst0 input port src
 * is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND1 0x2DU
/* Field Value: EXTDST0_SRC_SEL__LAYERBLEND0, Unit extdst0 input port src
 * is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_DYNAMIC_EXTDST0_SRC_SEL__LAYERBLEND0 0x2CU

/* Register: IMXDPUV1_pixengcfg_extdst0_Request */
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST                   ((uint32_t)(0x990))
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_OFFSET            ((uint32_t)(0x190))
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_EXTDST0_SEL_SHDLDREQ_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_EXTDST0_SEL_SHDLDREQ_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_EXTDST0_SHDLDREQ_MASK 0x3FFFFEU
#define IMXDPUV1_PIXENGCFG_EXTDST0_REQUEST_EXTDST0_SHDLDREQ_SHIFT 1U

/* Register: IMXDPUV1_pixengcfg_extdst0_Trigger */
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER                   ((uint32_t)(0x994))
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_OFFSET            ((uint32_t)(0x194))
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_RESET_MASK        0xFFFFFFEEU
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_EXTDST0_SYNC_TRIGGER_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_EXTDST0_SYNC_TRIGGER_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_EXTDST0_TRIGGER_SEQUENCE_COMPLETE_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST0_TRIGGER_EXTDST0_TRIGGER_SEQUENCE_COMPLETE_SHIFT 4U

/* Register: IMXDPUV1_pixengcfg_extdst0_Status */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS                    ((uint32_t)(0x998))
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_OFFSET             ((uint32_t)(0x198))
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS_MASK 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS_SHIFT 0U
/* Field Value: EXTDST0_PIPELINE_STATUS__EMPTY, Pipeline with endpoint extdst0
 * is empty  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS__EMPTY 0U
/* Field Value: EXTDST0_PIPELINE_STATUS__RUNNING, Pipeline with endpoint extdst0
 * is currently processing one operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS__RUNNING 0x1U
/* Field Value: EXTDST0_PIPELINE_STATUS__RUNNING_RETRIGGERED, Pipeline with
 * endpoint extdst0 is currently processing one operation with a second
 * one already kicked to be processed afterwards  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS__RUNNING_RETRIGGERED 0x2U
/* Field Value: EXTDST0_PIPELINE_STATUS__RESERVED, reserved  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_PIPELINE_STATUS__RESERVED 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_SYNC_BUSY_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_SYNC_BUSY_SHIFT 8U
/* Field Value: EXTDST0_SYNC_BUSY__IDLE, extdst0 synchronizer is idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_SYNC_BUSY__IDLE 0U
/* Field Value: EXTDST0_SYNC_BUSY__BUSY, extdst0 synchronizer is busy  */
#define IMXDPUV1_PIXENGCFG_EXTDST0_STATUS_EXTDST0_SYNC_BUSY__BUSY 0x1U

/* Register: IMXDPUV1_pixengcfg_constframe4_LockUnlock */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK            ((uint32_t)(0x9A0))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_OFFSET     ((uint32_t)(0x1A0))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK_SHIFT 0U
/* Field Value: CONSTFRAME4_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: CONSTFRAME4_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: CONSTFRAME4_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: CONSTFRAME4_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: CONSTFRAME4_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKUNLOCK_CONSTFRAME4_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_constframe4_LockStatus */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS            ((uint32_t)(0x9A4))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_OFFSET     ((uint32_t)(0x1A4))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_LOCKSTATUS_CONSTFRAME4_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_constframe4_Status */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS                ((uint32_t)(0x9A8))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_OFFSET         ((uint32_t)(0x1A8))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL_SHIFT 16U
/* Field Value: CONSTFRAME4_SEL__STORE9, constframe4 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__STORE9 0x1U
/* Field Value: CONSTFRAME4_SEL__EXTDST0, constframe4 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__EXTDST0 0x2U
/* Field Value: CONSTFRAME4_SEL__EXTDST4, constframe4 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__EXTDST4 0x3U
/* Field Value: CONSTFRAME4_SEL__EXTDST1, constframe4 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__EXTDST1 0x4U
/* Field Value: CONSTFRAME4_SEL__EXTDST5, constframe4 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__EXTDST5 0x5U
/* Field Value: CONSTFRAME4_SEL__STORE4, constframe4 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__STORE4 0x6U
/* Field Value: CONSTFRAME4_SEL__STORE5, constframe4 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__STORE5 0x7U
/* Field Value: CONSTFRAME4_SEL__DISABLE, constframe4 module is not used  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME4_STATUS_CONSTFRAME4_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_extdst4_LockUnlock */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK                ((uint32_t)(0x9C0))
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_OFFSET         ((uint32_t)(0x1C0))
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK_SHIFT 0U
/* Field Value: EXTDST4_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: EXTDST4_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: EXTDST4_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: EXTDST4_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: EXTDST4_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKUNLOCK_EXTDST4_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_extdst4_LockStatus */
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS                ((uint32_t)(0x9C4))
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_OFFSET         ((uint32_t)(0x1C4))
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST4_LOCKSTATUS_EXTDST4_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_extdst4_Static */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC                    ((uint32_t)(0x9C8))
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_OFFSET             ((uint32_t)(0x1C8))
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_RESET_VALUE        0x800010U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SHDEN_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SHDEN_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_POWERDOWN_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_POWERDOWN_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SYNC_MODE_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SYNC_MODE_SHIFT 8U
/* Field Value: EXTDST4_SYNC_MODE__SINGLE, Reconfig pipeline after explicit
 * trigger  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SYNC_MODE__SINGLE 0U
/* Field Value: EXTDST4_SYNC_MODE__AUTO, Reconfig pipeline after every kick
 * when idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SYNC_MODE__AUTO 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SW_RESET_MASK 0x800U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SW_RESET_SHIFT 11U
/* Field Value: EXTDST4_SW_RESET__OPERATION, Normal Operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SW_RESET__OPERATION 0U
/* Field Value: EXTDST4_SW_RESET__SWRESET, Software Reset  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_SW_RESET__SWRESET 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_DIV_MASK   0xFF0000U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATIC_EXTDST4_DIV_SHIFT  16U

/* Register: IMXDPUV1_pixengcfg_extdst4_Dynamic */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC                   ((uint32_t)(0x9CC))
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_OFFSET            ((uint32_t)(0x1CC))
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_RESET_VALUE       0x30U
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL_SHIFT 0U
/* Field Value: EXTDST4_SRC_SEL__DISABLE, Unit extdst4 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__DISABLE 0U
/* Field Value: EXTDST4_SRC_SEL__BLITBLEND9, Unit extdst4 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: EXTDST4_SRC_SEL__CONSTFRAME0, Unit extdst4 input port src
 * is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__CONSTFRAME0 0xCU
/* Field Value: EXTDST4_SRC_SEL__CONSTFRAME1, Unit extdst4 input port src
 * is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__CONSTFRAME1 0x10U
/* Field Value: EXTDST4_SRC_SEL__CONSTFRAME4, Unit extdst4 input port src
 * is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__CONSTFRAME4 0xEU
/* Field Value: EXTDST4_SRC_SEL__CONSTFRAME5, Unit extdst4 input port src
 * is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__CONSTFRAME5 0x12U
/* Field Value: EXTDST4_SRC_SEL__MATRIX4, Unit extdst4 input port src is connected
 * to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__MATRIX4 0x23U
/* Field Value: EXTDST4_SRC_SEL__HSCALER4, Unit extdst4 input port src is
 * connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__HSCALER4 0x24U
/* Field Value: EXTDST4_SRC_SEL__VSCALER4, Unit extdst4 input port src is
 * connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__VSCALER4 0x25U
/* Field Value: EXTDST4_SRC_SEL__MATRIX5, Unit extdst4 input port src is connected
 * to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__MATRIX5 0x28U
/* Field Value: EXTDST4_SRC_SEL__HSCALER5, Unit extdst4 input port src is
 * connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__HSCALER5 0x29U
/* Field Value: EXTDST4_SRC_SEL__VSCALER5, Unit extdst4 input port src is
 * connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__VSCALER5 0x2AU
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND6, Unit extdst4 input port src
 * is connected to output of unit layerblend6  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND6 0x32U
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND5, Unit extdst4 input port src
 * is connected to output of unit layerblend5  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND5 0x31U
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND4, Unit extdst4 input port src
 * is connected to output of unit layerblend4  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND4 0x30U
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND3, Unit extdst4 input port src
 * is connected to output of unit layerblend3  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND3 0x2FU
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND2, Unit extdst4 input port src
 * is connected to output of unit layerblend2  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND2 0x2EU
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND1, Unit extdst4 input port src
 * is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND1 0x2DU
/* Field Value: EXTDST4_SRC_SEL__LAYERBLEND0, Unit extdst4 input port src
 * is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_DYNAMIC_EXTDST4_SRC_SEL__LAYERBLEND0 0x2CU

/* Register: IMXDPUV1_pixengcfg_extdst4_Request */
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST                   ((uint32_t)(0x9D0))
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_OFFSET            ((uint32_t)(0x1D0))
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_EXTDST4_SEL_SHDLDREQ_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_EXTDST4_SEL_SHDLDREQ_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_EXTDST4_SHDLDREQ_MASK 0x3FFFFEU
#define IMXDPUV1_PIXENGCFG_EXTDST4_REQUEST_EXTDST4_SHDLDREQ_SHIFT 1U

/* Register: IMXDPUV1_pixengcfg_extdst4_Trigger */
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER                   ((uint32_t)(0x9D4))
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_OFFSET            ((uint32_t)(0x1D4))
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_RESET_MASK        0xFFFFFFEEU
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_EXTDST4_SYNC_TRIGGER_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_EXTDST4_SYNC_TRIGGER_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_EXTDST4_TRIGGER_SEQUENCE_COMPLETE_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST4_TRIGGER_EXTDST4_TRIGGER_SEQUENCE_COMPLETE_SHIFT 4U

/* Register: IMXDPUV1_pixengcfg_extdst4_Status */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS                    ((uint32_t)(0x9D8))
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_OFFSET             ((uint32_t)(0x1D8))
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS_MASK 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS_SHIFT 0U
/* Field Value: EXTDST4_PIPELINE_STATUS__EMPTY, Pipeline with endpoint extdst4
 * is empty  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS__EMPTY 0U
/* Field Value: EXTDST4_PIPELINE_STATUS__RUNNING, Pipeline with endpoint extdst4
 * is currently processing one operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS__RUNNING 0x1U
/* Field Value: EXTDST4_PIPELINE_STATUS__RUNNING_RETRIGGERED, Pipeline with
 * endpoint extdst4 is currently processing one operation with a second
 * one already kicked to be processed afterwards  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS__RUNNING_RETRIGGERED 0x2U
/* Field Value: EXTDST4_PIPELINE_STATUS__RESERVED, reserved  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_PIPELINE_STATUS__RESERVED 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_SYNC_BUSY_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_SYNC_BUSY_SHIFT 8U
/* Field Value: EXTDST4_SYNC_BUSY__IDLE, extdst4 synchronizer is idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_SYNC_BUSY__IDLE 0U
/* Field Value: EXTDST4_SYNC_BUSY__BUSY, extdst4 synchronizer is busy  */
#define IMXDPUV1_PIXENGCFG_EXTDST4_STATUS_EXTDST4_SYNC_BUSY__BUSY 0x1U

/* Register: IMXDPUV1_pixengcfg_constframe1_LockUnlock */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK            ((uint32_t)(0x9E0))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_OFFSET     ((uint32_t)(0x1E0))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK_SHIFT 0U
/* Field Value: CONSTFRAME1_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: CONSTFRAME1_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: CONSTFRAME1_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: CONSTFRAME1_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: CONSTFRAME1_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKUNLOCK_CONSTFRAME1_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_constframe1_LockStatus */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS            ((uint32_t)(0x9E4))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_OFFSET     ((uint32_t)(0x1E4))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_LOCKSTATUS_CONSTFRAME1_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_constframe1_Status */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS                ((uint32_t)(0x9E8))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_OFFSET         ((uint32_t)(0x1E8))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL_SHIFT 16U
/* Field Value: CONSTFRAME1_SEL__STORE9, constframe1 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__STORE9 0x1U
/* Field Value: CONSTFRAME1_SEL__EXTDST0, constframe1 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__EXTDST0 0x2U
/* Field Value: CONSTFRAME1_SEL__EXTDST4, constframe1 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__EXTDST4 0x3U
/* Field Value: CONSTFRAME1_SEL__EXTDST1, constframe1 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__EXTDST1 0x4U
/* Field Value: CONSTFRAME1_SEL__EXTDST5, constframe1 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__EXTDST5 0x5U
/* Field Value: CONSTFRAME1_SEL__STORE4, constframe1 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__STORE4 0x6U
/* Field Value: CONSTFRAME1_SEL__STORE5, constframe1 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__STORE5 0x7U
/* Field Value: CONSTFRAME1_SEL__DISABLE, constframe1 module is not used  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME1_STATUS_CONSTFRAME1_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_extdst1_LockUnlock */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK                ((uint32_t)(0xA00))
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_OFFSET         ((uint32_t)(0x200))
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK_SHIFT 0U
/* Field Value: EXTDST1_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: EXTDST1_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: EXTDST1_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: EXTDST1_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: EXTDST1_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKUNLOCK_EXTDST1_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_extdst1_LockStatus */
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS                ((uint32_t)(0xA04))
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_OFFSET         ((uint32_t)(0x204))
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST1_LOCKSTATUS_EXTDST1_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_extdst1_Static */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC                    ((uint32_t)(0xA08))
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_OFFSET             ((uint32_t)(0x208))
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_RESET_VALUE        0x800010U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SHDEN_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SHDEN_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_POWERDOWN_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_POWERDOWN_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SYNC_MODE_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SYNC_MODE_SHIFT 8U
/* Field Value: EXTDST1_SYNC_MODE__SINGLE, Reconfig pipeline after explicit
 * trigger  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SYNC_MODE__SINGLE 0U
/* Field Value: EXTDST1_SYNC_MODE__AUTO, Reconfig pipeline after every kick
 * when idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SYNC_MODE__AUTO 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SW_RESET_MASK 0x800U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SW_RESET_SHIFT 11U
/* Field Value: EXTDST1_SW_RESET__OPERATION, Normal Operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SW_RESET__OPERATION 0U
/* Field Value: EXTDST1_SW_RESET__SWRESET, Software Reset  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_SW_RESET__SWRESET 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_DIV_MASK   0xFF0000U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATIC_EXTDST1_DIV_SHIFT  16U

/* Register: IMXDPUV1_pixengcfg_extdst1_Dynamic */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC                   ((uint32_t)(0xA0C))
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_OFFSET            ((uint32_t)(0x20C))
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_RESET_VALUE       0x2DU
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL_SHIFT 0U
/* Field Value: EXTDST1_SRC_SEL__DISABLE, Unit extdst1 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__DISABLE 0U
/* Field Value: EXTDST1_SRC_SEL__BLITBLEND9, Unit extdst1 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: EXTDST1_SRC_SEL__CONSTFRAME0, Unit extdst1 input port src
 * is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__CONSTFRAME0 0xCU
/* Field Value: EXTDST1_SRC_SEL__CONSTFRAME1, Unit extdst1 input port src
 * is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__CONSTFRAME1 0x10U
/* Field Value: EXTDST1_SRC_SEL__CONSTFRAME4, Unit extdst1 input port src
 * is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__CONSTFRAME4 0xEU
/* Field Value: EXTDST1_SRC_SEL__CONSTFRAME5, Unit extdst1 input port src
 * is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__CONSTFRAME5 0x12U
/* Field Value: EXTDST1_SRC_SEL__MATRIX4, Unit extdst1 input port src is connected
 * to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__MATRIX4 0x23U
/* Field Value: EXTDST1_SRC_SEL__HSCALER4, Unit extdst1 input port src is
 * connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__HSCALER4 0x24U
/* Field Value: EXTDST1_SRC_SEL__VSCALER4, Unit extdst1 input port src is
 * connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__VSCALER4 0x25U
/* Field Value: EXTDST1_SRC_SEL__EXTSRC4, Unit extdst1 input port src is connected
 * to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__EXTSRC4 0x14U
/* Field Value: EXTDST1_SRC_SEL__MATRIX5, Unit extdst1 input port src is connected
 * to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__MATRIX5 0x28U
/* Field Value: EXTDST1_SRC_SEL__HSCALER5, Unit extdst1 input port src is
 * connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__HSCALER5 0x29U
/* Field Value: EXTDST1_SRC_SEL__VSCALER5, Unit extdst1 input port src is
 * connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__VSCALER5 0x2AU
/* Field Value: EXTDST1_SRC_SEL__EXTSRC5, Unit extdst1 input port src is connected
 * to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__EXTSRC5 0x16U
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND6, Unit extdst1 input port src
 * is connected to output of unit layerblend6  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND6 0x32U
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND5, Unit extdst1 input port src
 * is connected to output of unit layerblend5  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND5 0x31U
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND4, Unit extdst1 input port src
 * is connected to output of unit layerblend4  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND4 0x30U
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND3, Unit extdst1 input port src
 * is connected to output of unit layerblend3  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND3 0x2FU
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND2, Unit extdst1 input port src
 * is connected to output of unit layerblend2  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND2 0x2EU
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND1, Unit extdst1 input port src
 * is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND1 0x2DU
/* Field Value: EXTDST1_SRC_SEL__LAYERBLEND0, Unit extdst1 input port src
 * is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_DYNAMIC_EXTDST1_SRC_SEL__LAYERBLEND0 0x2CU

/* Register: IMXDPUV1_pixengcfg_extdst1_Request */
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST                   ((uint32_t)(0xA10))
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_OFFSET            ((uint32_t)(0x210))
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_EXTDST1_SEL_SHDLDREQ_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_EXTDST1_SEL_SHDLDREQ_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_EXTDST1_SHDLDREQ_MASK 0x3FFFFEU
#define IMXDPUV1_PIXENGCFG_EXTDST1_REQUEST_EXTDST1_SHDLDREQ_SHIFT 1U

/* Register: IMXDPUV1_pixengcfg_extdst1_Trigger */
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER                   ((uint32_t)(0xA14))
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_OFFSET            ((uint32_t)(0x214))
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_RESET_MASK        0xFFFFFFEEU
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_EXTDST1_SYNC_TRIGGER_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_EXTDST1_SYNC_TRIGGER_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_EXTDST1_TRIGGER_SEQUENCE_COMPLETE_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST1_TRIGGER_EXTDST1_TRIGGER_SEQUENCE_COMPLETE_SHIFT 4U

/* Register: IMXDPUV1_pixengcfg_extdst1_Status */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS                    ((uint32_t)(0xA18))
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_OFFSET             ((uint32_t)(0x218))
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS_MASK 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS_SHIFT 0U
/* Field Value: EXTDST1_PIPELINE_STATUS__EMPTY, Pipeline with endpoint extdst1
 * is empty  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS__EMPTY 0U
/* Field Value: EXTDST1_PIPELINE_STATUS__RUNNING, Pipeline with endpoint extdst1
 * is currently processing one operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS__RUNNING 0x1U
/* Field Value: EXTDST1_PIPELINE_STATUS__RUNNING_RETRIGGERED, Pipeline with
 * endpoint extdst1 is currently processing one operation with a second
 * one already kicked to be processed afterwards  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS__RUNNING_RETRIGGERED 0x2U
/* Field Value: EXTDST1_PIPELINE_STATUS__RESERVED, reserved  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_PIPELINE_STATUS__RESERVED 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_SYNC_BUSY_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_SYNC_BUSY_SHIFT 8U
/* Field Value: EXTDST1_SYNC_BUSY__IDLE, extdst1 synchronizer is idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_SYNC_BUSY__IDLE 0U
/* Field Value: EXTDST1_SYNC_BUSY__BUSY, extdst1 synchronizer is busy  */
#define IMXDPUV1_PIXENGCFG_EXTDST1_STATUS_EXTDST1_SYNC_BUSY__BUSY 0x1U

/* Register: IMXDPUV1_pixengcfg_constframe5_LockUnlock */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK            ((uint32_t)(0xA20))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_OFFSET     ((uint32_t)(0x220))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK_SHIFT 0U
/* Field Value: CONSTFRAME5_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: CONSTFRAME5_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: CONSTFRAME5_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: CONSTFRAME5_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: CONSTFRAME5_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKUNLOCK_CONSTFRAME5_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_constframe5_LockStatus */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS            ((uint32_t)(0xA24))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_OFFSET     ((uint32_t)(0x224))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_LOCKSTATUS_CONSTFRAME5_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_constframe5_Status */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS                ((uint32_t)(0xA28))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_OFFSET         ((uint32_t)(0x228))
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL_SHIFT 16U
/* Field Value: CONSTFRAME5_SEL__STORE9, constframe5 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__STORE9 0x1U
/* Field Value: CONSTFRAME5_SEL__EXTDST0, constframe5 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__EXTDST0 0x2U
/* Field Value: CONSTFRAME5_SEL__EXTDST4, constframe5 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__EXTDST4 0x3U
/* Field Value: CONSTFRAME5_SEL__EXTDST1, constframe5 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__EXTDST1 0x4U
/* Field Value: CONSTFRAME5_SEL__EXTDST5, constframe5 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__EXTDST5 0x5U
/* Field Value: CONSTFRAME5_SEL__STORE4, constframe5 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__STORE4 0x6U
/* Field Value: CONSTFRAME5_SEL__STORE5, constframe5 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__STORE5 0x7U
/* Field Value: CONSTFRAME5_SEL__DISABLE, constframe5 module is not used  */
#define IMXDPUV1_PIXENGCFG_CONSTFRAME5_STATUS_CONSTFRAME5_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_extdst5_LockUnlock */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK                ((uint32_t)(0xA40))
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_OFFSET         ((uint32_t)(0x240))
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK_SHIFT 0U
/* Field Value: EXTDST5_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: EXTDST5_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: EXTDST5_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: EXTDST5_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: EXTDST5_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKUNLOCK_EXTDST5_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_extdst5_LockStatus */
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS                ((uint32_t)(0xA44))
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_OFFSET         ((uint32_t)(0x244))
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST5_LOCKSTATUS_EXTDST5_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_extdst5_Static */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC                    ((uint32_t)(0xA48))
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_OFFSET             ((uint32_t)(0x248))
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_RESET_VALUE        0x800010U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SHDEN_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SHDEN_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_POWERDOWN_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_POWERDOWN_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SYNC_MODE_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SYNC_MODE_SHIFT 8U
/* Field Value: EXTDST5_SYNC_MODE__SINGLE, Reconfig pipeline after explicit
 * trigger  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SYNC_MODE__SINGLE 0U
/* Field Value: EXTDST5_SYNC_MODE__AUTO, Reconfig pipeline after every kick
 * when idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SYNC_MODE__AUTO 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SW_RESET_MASK 0x800U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SW_RESET_SHIFT 11U
/* Field Value: EXTDST5_SW_RESET__OPERATION, Normal Operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SW_RESET__OPERATION 0U
/* Field Value: EXTDST5_SW_RESET__SWRESET, Software Reset  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_SW_RESET__SWRESET 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_DIV_MASK   0xFF0000U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATIC_EXTDST5_DIV_SHIFT  16U

/* Register: IMXDPUV1_pixengcfg_extdst5_Dynamic */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC                   ((uint32_t)(0xA4C))
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_OFFSET            ((uint32_t)(0x24C))
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_RESET_VALUE       0x31U
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL_SHIFT 0U
/* Field Value: EXTDST5_SRC_SEL__DISABLE, Unit extdst5 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__DISABLE 0U
/* Field Value: EXTDST5_SRC_SEL__BLITBLEND9, Unit extdst5 input port src is
 * connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__BLITBLEND9 0xAU
/* Field Value: EXTDST5_SRC_SEL__CONSTFRAME0, Unit extdst5 input port src
 * is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__CONSTFRAME0 0xCU
/* Field Value: EXTDST5_SRC_SEL__CONSTFRAME1, Unit extdst5 input port src
 * is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__CONSTFRAME1 0x10U
/* Field Value: EXTDST5_SRC_SEL__CONSTFRAME4, Unit extdst5 input port src
 * is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__CONSTFRAME4 0xEU
/* Field Value: EXTDST5_SRC_SEL__CONSTFRAME5, Unit extdst5 input port src
 * is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__CONSTFRAME5 0x12U
/* Field Value: EXTDST5_SRC_SEL__MATRIX4, Unit extdst5 input port src is connected
 * to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__MATRIX4 0x23U
/* Field Value: EXTDST5_SRC_SEL__HSCALER4, Unit extdst5 input port src is
 * connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__HSCALER4 0x24U
/* Field Value: EXTDST5_SRC_SEL__VSCALER4, Unit extdst5 input port src is
 * connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__VSCALER4 0x25U
/* Field Value: EXTDST5_SRC_SEL__MATRIX5, Unit extdst5 input port src is connected
 * to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__MATRIX5 0x28U
/* Field Value: EXTDST5_SRC_SEL__HSCALER5, Unit extdst5 input port src is
 * connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__HSCALER5 0x29U
/* Field Value: EXTDST5_SRC_SEL__VSCALER5, Unit extdst5 input port src is
 * connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__VSCALER5 0x2AU
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND6, Unit extdst5 input port src
 * is connected to output of unit layerblend6  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND6 0x32U
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND5, Unit extdst5 input port src
 * is connected to output of unit layerblend5  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND5 0x31U
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND4, Unit extdst5 input port src
 * is connected to output of unit layerblend4  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND4 0x30U
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND3, Unit extdst5 input port src
 * is connected to output of unit layerblend3  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND3 0x2FU
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND2, Unit extdst5 input port src
 * is connected to output of unit layerblend2  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND2 0x2EU
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND1, Unit extdst5 input port src
 * is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND1 0x2DU
/* Field Value: EXTDST5_SRC_SEL__LAYERBLEND0, Unit extdst5 input port src
 * is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_DYNAMIC_EXTDST5_SRC_SEL__LAYERBLEND0 0x2CU

/* Register: IMXDPUV1_pixengcfg_extdst5_Request */
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST                   ((uint32_t)(0xA50))
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_OFFSET            ((uint32_t)(0x250))
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_EXTDST5_SEL_SHDLDREQ_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_EXTDST5_SEL_SHDLDREQ_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_EXTDST5_SHDLDREQ_MASK 0x3FFFFEU
#define IMXDPUV1_PIXENGCFG_EXTDST5_REQUEST_EXTDST5_SHDLDREQ_SHIFT 1U

/* Register: IMXDPUV1_pixengcfg_extdst5_Trigger */
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER                   ((uint32_t)(0xA54))
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_OFFSET            ((uint32_t)(0x254))
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_RESET_MASK        0xFFFFFFEEU
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_EXTDST5_SYNC_TRIGGER_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_EXTDST5_SYNC_TRIGGER_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_EXTDST5_TRIGGER_SEQUENCE_COMPLETE_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_EXTDST5_TRIGGER_EXTDST5_TRIGGER_SEQUENCE_COMPLETE_SHIFT 4U

/* Register: IMXDPUV1_pixengcfg_extdst5_Status */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS                    ((uint32_t)(0xA58))
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_OFFSET             ((uint32_t)(0x258))
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS_MASK 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS_SHIFT 0U
/* Field Value: EXTDST5_PIPELINE_STATUS__EMPTY, Pipeline with endpoint extdst5
 * is empty  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS__EMPTY 0U
/* Field Value: EXTDST5_PIPELINE_STATUS__RUNNING, Pipeline with endpoint extdst5
 * is currently processing one operation  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS__RUNNING 0x1U
/* Field Value: EXTDST5_PIPELINE_STATUS__RUNNING_RETRIGGERED, Pipeline with
 * endpoint extdst5 is currently processing one operation with a second
 * one already kicked to be processed afterwards  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS__RUNNING_RETRIGGERED 0x2U
/* Field Value: EXTDST5_PIPELINE_STATUS__RESERVED, reserved  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_PIPELINE_STATUS__RESERVED 0x3U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_SYNC_BUSY_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_SYNC_BUSY_SHIFT 8U
/* Field Value: EXTDST5_SYNC_BUSY__IDLE, extdst5 synchronizer is idle  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_SYNC_BUSY__IDLE 0U
/* Field Value: EXTDST5_SYNC_BUSY__BUSY, extdst5 synchronizer is busy  */
#define IMXDPUV1_PIXENGCFG_EXTDST5_STATUS_EXTDST5_SYNC_BUSY__BUSY 0x1U

/* Register: IMXDPUV1_pixengcfg_fetchwarp2_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK             ((uint32_t)(0xA60))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_OFFSET      ((uint32_t)(0x260))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_RESET_MASK  0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHWARP2_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHWARP2_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHWARP2_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHWARP2_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHWARP2_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKUNLOCK_FETCHWARP2_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchwarp2_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS             ((uint32_t)(0xA64))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_OFFSET      ((uint32_t)(0x264))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_LOCKSTATUS_FETCHWARP2_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchwarp2_Dynamic */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC                ((uint32_t)(0xA68))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_OFFSET         ((uint32_t)(0x268))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_FETCHWARP2_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_FETCHWARP2_SRC_SEL_SHIFT 0U
/* Field Value: FETCHWARP2_SRC_SEL__DISABLE, Unit fetchwarp2 input port src
 * is disabled  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_FETCHWARP2_SRC_SEL__DISABLE 0U
/* Field Value: FETCHWARP2_SRC_SEL__FETCHECO2, Unit fetchwarp2 input port
 * src is connected to output of unit fetcheco2  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_DYNAMIC_FETCHWARP2_SRC_SEL__FETCHECO2 0x1BU

/* Register: IMXDPUV1_pixengcfg_fetchwarp2_Status */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS                 ((uint32_t)(0xA6C))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_OFFSET          ((uint32_t)(0x26C))
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_RESET_VALUE     0U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_RESET_MASK      0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL_SHIFT 16U
/* Field Value: FETCHWARP2_SEL__STORE9, fetchwarp2 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__STORE9 0x1U
/* Field Value: FETCHWARP2_SEL__EXTDST0, fetchwarp2 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__EXTDST0 0x2U
/* Field Value: FETCHWARP2_SEL__EXTDST4, fetchwarp2 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__EXTDST4 0x3U
/* Field Value: FETCHWARP2_SEL__EXTDST1, fetchwarp2 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__EXTDST1 0x4U
/* Field Value: FETCHWARP2_SEL__EXTDST5, fetchwarp2 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__EXTDST5 0x5U
/* Field Value: FETCHWARP2_SEL__STORE4, fetchwarp2 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__STORE4 0x6U
/* Field Value: FETCHWARP2_SEL__STORE5, fetchwarp2 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__STORE5 0x7U
/* Field Value: FETCHWARP2_SEL__DISABLE, fetchwarp2 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHWARP2_STATUS_FETCHWARP2_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetcheco2_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK              ((uint32_t)(0xA70))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_OFFSET       ((uint32_t)(0x270))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_RESET_MASK   0U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHECO2_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHECO2_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHECO2_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHECO2_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHECO2_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKUNLOCK_FETCHECO2_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetcheco2_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS              ((uint32_t)(0xA74))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_OFFSET       ((uint32_t)(0x274))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_LOCKSTATUS_FETCHECO2_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetcheco2_Status */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS                  ((uint32_t)(0xA78))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_OFFSET           ((uint32_t)(0x278))
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_RESET_MASK       0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL_SHIFT 16U
/* Field Value: FETCHECO2_SEL__STORE9, fetcheco2 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__STORE9 0x1U
/* Field Value: FETCHECO2_SEL__EXTDST0, fetcheco2 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__EXTDST0 0x2U
/* Field Value: FETCHECO2_SEL__EXTDST4, fetcheco2 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__EXTDST4 0x3U
/* Field Value: FETCHECO2_SEL__EXTDST1, fetcheco2 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__EXTDST1 0x4U
/* Field Value: FETCHECO2_SEL__EXTDST5, fetcheco2 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__EXTDST5 0x5U
/* Field Value: FETCHECO2_SEL__STORE4, fetcheco2 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__STORE4 0x6U
/* Field Value: FETCHECO2_SEL__STORE5, fetcheco2 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__STORE5 0x7U
/* Field Value: FETCHECO2_SEL__DISABLE, fetcheco2 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHECO2_STATUS_FETCHECO2_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetchdecode0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK           ((uint32_t)(0xA80))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_OFFSET    ((uint32_t)(0x280))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHDECODE0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHDECODE0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHDECODE0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege
 * protection. Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHDECODE0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHDECODE0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKUNLOCK_FETCHDECODE0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchdecode0_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS           ((uint32_t)(0xA84))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_OFFSET    ((uint32_t)(0x284))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_LOCKSTATUS_FETCHDECODE0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchdecode0_Dynamic */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC              ((uint32_t)(0xA88))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_OFFSET       ((uint32_t)(0x288))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_FETCHDECODE0_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_FETCHDECODE0_SRC_SEL_SHIFT 0U
/* Field Value: FETCHDECODE0_SRC_SEL__DISABLE, Unit fetchdecode0 input port
 * src is disabled  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_FETCHDECODE0_SRC_SEL__DISABLE 0U
/* Field Value: FETCHDECODE0_SRC_SEL__FETCHECO0, Unit fetchdecode0 input port
 * src is connected to output of unit fetcheco0  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_FETCHDECODE0_SRC_SEL__FETCHECO0 0x1DU
/* Field Value: FETCHDECODE0_SRC_SEL__FETCHDECODE2, Unit fetchdecode0 input
 * port src is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_DYNAMIC_FETCHDECODE0_SRC_SEL__FETCHDECODE2 0x18U

/* Register: IMXDPUV1_pixengcfg_fetchdecode0_Status */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS               ((uint32_t)(0xA8C))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_OFFSET        ((uint32_t)(0x28C))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_RESET_MASK    0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL_SHIFT 16U
/* Field Value: FETCHDECODE0_SEL__STORE9, fetchdecode0 module is used from
 * store9 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__STORE9 0x1U
/* Field Value: FETCHDECODE0_SEL__EXTDST0, fetchdecode0 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__EXTDST0 0x2U
/* Field Value: FETCHDECODE0_SEL__EXTDST4, fetchdecode0 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__EXTDST4 0x3U
/* Field Value: FETCHDECODE0_SEL__EXTDST1, fetchdecode0 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__EXTDST1 0x4U
/* Field Value: FETCHDECODE0_SEL__EXTDST5, fetchdecode0 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__EXTDST5 0x5U
/* Field Value: FETCHDECODE0_SEL__STORE4, fetchdecode0 module is used from
 * store4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__STORE4 0x6U
/* Field Value: FETCHDECODE0_SEL__STORE5, fetchdecode0 module is used from
 * store5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__STORE5 0x7U
/* Field Value: FETCHDECODE0_SEL__DISABLE, fetchdecode0 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE0_STATUS_FETCHDECODE0_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetcheco0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK              ((uint32_t)(0xA90))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_OFFSET       ((uint32_t)(0x290))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_RESET_MASK   0U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHECO0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHECO0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHECO0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHECO0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHECO0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKUNLOCK_FETCHECO0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetcheco0_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS              ((uint32_t)(0xA94))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_OFFSET       ((uint32_t)(0x294))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_LOCKSTATUS_FETCHECO0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetcheco0_Status */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS                  ((uint32_t)(0xA98))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_OFFSET           ((uint32_t)(0x298))
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_RESET_MASK       0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL_SHIFT 16U
/* Field Value: FETCHECO0_SEL__STORE9, fetcheco0 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__STORE9 0x1U
/* Field Value: FETCHECO0_SEL__EXTDST0, fetcheco0 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__EXTDST0 0x2U
/* Field Value: FETCHECO0_SEL__EXTDST4, fetcheco0 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__EXTDST4 0x3U
/* Field Value: FETCHECO0_SEL__EXTDST1, fetcheco0 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__EXTDST1 0x4U
/* Field Value: FETCHECO0_SEL__EXTDST5, fetcheco0 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__EXTDST5 0x5U
/* Field Value: FETCHECO0_SEL__STORE4, fetcheco0 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__STORE4 0x6U
/* Field Value: FETCHECO0_SEL__STORE5, fetcheco0 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__STORE5 0x7U
/* Field Value: FETCHECO0_SEL__DISABLE, fetcheco0 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHECO0_STATUS_FETCHECO0_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetchdecode1_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK           ((uint32_t)(0xAA0))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_OFFSET    ((uint32_t)(0x2A0))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHDECODE1_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHDECODE1_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHDECODE1_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege
 * protection. Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHDECODE1_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHDECODE1_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKUNLOCK_FETCHDECODE1_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchdecode1_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS           ((uint32_t)(0xAA4))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_OFFSET    ((uint32_t)(0x2A4))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_LOCKSTATUS_FETCHDECODE1_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchdecode1_Dynamic */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC              ((uint32_t)(0xAA8))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_OFFSET       ((uint32_t)(0x2A8))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_FETCHDECODE1_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_FETCHDECODE1_SRC_SEL_SHIFT 0U
/* Field Value: FETCHDECODE1_SRC_SEL__DISABLE, Unit fetchdecode1 input port
 * src is disabled  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_FETCHDECODE1_SRC_SEL__DISABLE 0U
/* Field Value: FETCHDECODE1_SRC_SEL__FETCHECO1, Unit fetchdecode1 input port
 * src is connected to output of unit fetcheco1  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_FETCHDECODE1_SRC_SEL__FETCHECO1 0x1FU
/* Field Value: FETCHDECODE1_SRC_SEL__FETCHDECODE3, Unit fetchdecode1 input
 * port src is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_DYNAMIC_FETCHDECODE1_SRC_SEL__FETCHDECODE3 0x19U

/* Register: IMXDPUV1_pixengcfg_fetchdecode1_Status */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS               ((uint32_t)(0xAAC))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_OFFSET        ((uint32_t)(0x2AC))
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_RESET_MASK    0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL_SHIFT 16U
/* Field Value: FETCHDECODE1_SEL__STORE9, fetchdecode1 module is used from
 * store9 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__STORE9 0x1U
/* Field Value: FETCHDECODE1_SEL__EXTDST0, fetchdecode1 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__EXTDST0 0x2U
/* Field Value: FETCHDECODE1_SEL__EXTDST4, fetchdecode1 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__EXTDST4 0x3U
/* Field Value: FETCHDECODE1_SEL__EXTDST1, fetchdecode1 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__EXTDST1 0x4U
/* Field Value: FETCHDECODE1_SEL__EXTDST5, fetchdecode1 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__EXTDST5 0x5U
/* Field Value: FETCHDECODE1_SEL__STORE4, fetchdecode1 module is used from
 * store4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__STORE4 0x6U
/* Field Value: FETCHDECODE1_SEL__STORE5, fetchdecode1 module is used from
 * store5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__STORE5 0x7U
/* Field Value: FETCHDECODE1_SEL__DISABLE, fetchdecode1 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHDECODE1_STATUS_FETCHDECODE1_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetcheco1_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK              ((uint32_t)(0xAB0))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_OFFSET       ((uint32_t)(0x2B0))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_RESET_MASK   0U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHECO1_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHECO1_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHECO1_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHECO1_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHECO1_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKUNLOCK_FETCHECO1_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetcheco1_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS              ((uint32_t)(0xAB4))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_OFFSET       ((uint32_t)(0x2B4))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_RESET_VALUE  0U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_LOCKSTATUS_FETCHECO1_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetcheco1_Status */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS                  ((uint32_t)(0xAB8))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_OFFSET           ((uint32_t)(0x2B8))
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_RESET_VALUE      0U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_RESET_MASK       0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL_SHIFT 16U
/* Field Value: FETCHECO1_SEL__STORE9, fetcheco1 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__STORE9 0x1U
/* Field Value: FETCHECO1_SEL__EXTDST0, fetcheco1 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__EXTDST0 0x2U
/* Field Value: FETCHECO1_SEL__EXTDST4, fetcheco1 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__EXTDST4 0x3U
/* Field Value: FETCHECO1_SEL__EXTDST1, fetcheco1 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__EXTDST1 0x4U
/* Field Value: FETCHECO1_SEL__EXTDST5, fetcheco1 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__EXTDST5 0x5U
/* Field Value: FETCHECO1_SEL__STORE4, fetcheco1 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__STORE4 0x6U
/* Field Value: FETCHECO1_SEL__STORE5, fetcheco1 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__STORE5 0x7U
/* Field Value: FETCHECO1_SEL__DISABLE, fetcheco1 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHECO1_STATUS_FETCHECO1_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_fetchlayer0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK            ((uint32_t)(0xAC0))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_OFFSET     ((uint32_t)(0x2C0))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK_SHIFT 0U
/* Field Value: FETCHLAYER0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: FETCHLAYER0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: FETCHLAYER0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: FETCHLAYER0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: FETCHLAYER0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKUNLOCK_FETCHLAYER0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_fetchlayer0_LockStatus */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS            ((uint32_t)(0xAC4))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_OFFSET     ((uint32_t)(0x2C4))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_LOCKSTATUS_FETCHLAYER0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_fetchlayer0_Status */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS                ((uint32_t)(0xAC8))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_OFFSET         ((uint32_t)(0x2C8))
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL_SHIFT 16U
/* Field Value: FETCHLAYER0_SEL__STORE9, fetchlayer0 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__STORE9 0x1U
/* Field Value: FETCHLAYER0_SEL__EXTDST0, fetchlayer0 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__EXTDST0 0x2U
/* Field Value: FETCHLAYER0_SEL__EXTDST4, fetchlayer0 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__EXTDST4 0x3U
/* Field Value: FETCHLAYER0_SEL__EXTDST1, fetchlayer0 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__EXTDST1 0x4U
/* Field Value: FETCHLAYER0_SEL__EXTDST5, fetchlayer0 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__EXTDST5 0x5U
/* Field Value: FETCHLAYER0_SEL__STORE4, fetchlayer0 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__STORE4 0x6U
/* Field Value: FETCHLAYER0_SEL__STORE5, fetchlayer0 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__STORE5 0x7U
/* Field Value: FETCHLAYER0_SEL__DISABLE, fetchlayer0 module is not used  */
#define IMXDPUV1_PIXENGCFG_FETCHLAYER0_STATUS_FETCHLAYER0_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_matrix4_LockUnlock */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK                ((uint32_t)(0xAE0))
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_OFFSET         ((uint32_t)(0x2E0))
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK_SHIFT 0U
/* Field Value: MATRIX4_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: MATRIX4_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: MATRIX4_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: MATRIX4_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: MATRIX4_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKUNLOCK_MATRIX4_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_matrix4_LockStatus */
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS                ((uint32_t)(0xAE4))
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_OFFSET         ((uint32_t)(0x2E4))
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_MATRIX4_LOCKSTATUS_MATRIX4_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_matrix4_Dynamic */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC                   ((uint32_t)(0xAE8))
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_OFFSET            ((uint32_t)(0x2E8))
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_RESET_VALUE       0x1000000U
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_SRC_SEL_SHIFT 0U
/* Field Value: MATRIX4_SRC_SEL__DISABLE, Unit matrix4 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_SRC_SEL__DISABLE 0U
/* Field Value: MATRIX4_SRC_SEL__GAMMACOR4, Unit matrix4 input port src is
 * connected to output of unit gammacor4  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_SRC_SEL__GAMMACOR4 0x22U
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_CLKEN_SHIFT 24U
/* Field Value: MATRIX4_CLKEN__DISABLE, Clock for matrix4 is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_CLKEN__DISABLE 0U
/* Field Value: MATRIX4_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_CLKEN__AUTOMATIC 0x1U
/* Field Value: MATRIX4_CLKEN__FULL, Clock for matrix4 is without gating  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_DYNAMIC_MATRIX4_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_matrix4_Status */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS                    ((uint32_t)(0xAEC))
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_OFFSET             ((uint32_t)(0x2EC))
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_RESET_MASK         0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL_MASK   0x70000U
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL_SHIFT  16U
/* Field Value: MATRIX4_SEL__STORE9, matrix4 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__STORE9 0x1U
/* Field Value: MATRIX4_SEL__EXTDST0, matrix4 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__EXTDST0 0x2U
/* Field Value: MATRIX4_SEL__EXTDST4, matrix4 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__EXTDST4 0x3U
/* Field Value: MATRIX4_SEL__EXTDST1, matrix4 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__EXTDST1 0x4U
/* Field Value: MATRIX4_SEL__EXTDST5, matrix4 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__EXTDST5 0x5U
/* Field Value: MATRIX4_SEL__STORE4, matrix4 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__STORE4 0x6U
/* Field Value: MATRIX4_SEL__STORE5, matrix4 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__STORE5 0x7U
/* Field Value: MATRIX4_SEL__DISABLE, matrix4 module is not used  */
#define IMXDPUV1_PIXENGCFG_MATRIX4_STATUS_MATRIX4_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_hscaler4_LockUnlock */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK               ((uint32_t)(0xB00))
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_OFFSET        ((uint32_t)(0x300))
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK_SHIFT 0U
/* Field Value: HSCALER4_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: HSCALER4_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: HSCALER4_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: HSCALER4_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: HSCALER4_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKUNLOCK_HSCALER4_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_hscaler4_LockStatus */
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS               ((uint32_t)(0xB04))
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_OFFSET        ((uint32_t)(0x304))
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_HSCALER4_LOCKSTATUS_HSCALER4_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_hscaler4_Dynamic */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC                  ((uint32_t)(0xB08))
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_OFFSET           ((uint32_t)(0x308))
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL_SHIFT 0U
/* Field Value: HSCALER4_SRC_SEL__DISABLE, Unit hscaler4 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__DISABLE 0U
/* Field Value: HSCALER4_SRC_SEL__EXTSRC4, Unit hscaler4 input port src is
 * connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__EXTSRC4 0x14U
/* Field Value: HSCALER4_SRC_SEL__FETCHDECODE0, Unit hscaler4 input port src
 * is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__FETCHDECODE0 0x1CU
/* Field Value: HSCALER4_SRC_SEL__FETCHDECODE2, Unit hscaler4 input port src
 * is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__FETCHDECODE2 0x18U
/* Field Value: HSCALER4_SRC_SEL__MATRIX4, Unit hscaler4 input port src is
 * connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__MATRIX4 0x23U
/* Field Value: HSCALER4_SRC_SEL__VSCALER4, Unit hscaler4 input port src is
 * connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_SRC_SEL__VSCALER4 0x25U
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_CLKEN_SHIFT 24U
/* Field Value: HSCALER4_CLKEN__DISABLE, Clock for hscaler4 is disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_CLKEN__DISABLE 0U
/* Field Value: HSCALER4_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_CLKEN__AUTOMATIC 0x1U
/* Field Value: HSCALER4_CLKEN__FULL, Clock for hscaler4 is without gating  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_DYNAMIC_HSCALER4_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_hscaler4_Status */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS                   ((uint32_t)(0xB0C))
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_OFFSET            ((uint32_t)(0x30C))
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL_SHIFT 16U
/* Field Value: HSCALER4_SEL__STORE9, hscaler4 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__STORE9 0x1U
/* Field Value: HSCALER4_SEL__EXTDST0, hscaler4 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__EXTDST0 0x2U
/* Field Value: HSCALER4_SEL__EXTDST4, hscaler4 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__EXTDST4 0x3U
/* Field Value: HSCALER4_SEL__EXTDST1, hscaler4 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__EXTDST1 0x4U
/* Field Value: HSCALER4_SEL__EXTDST5, hscaler4 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__EXTDST5 0x5U
/* Field Value: HSCALER4_SEL__STORE4, hscaler4 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__STORE4 0x6U
/* Field Value: HSCALER4_SEL__STORE5, hscaler4 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__STORE5 0x7U
/* Field Value: HSCALER4_SEL__DISABLE, hscaler4 module is not used  */
#define IMXDPUV1_PIXENGCFG_HSCALER4_STATUS_HSCALER4_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_vscaler4_LockUnlock */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK               ((uint32_t)(0xB20))
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_OFFSET        ((uint32_t)(0x320))
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK_SHIFT 0U
/* Field Value: VSCALER4_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: VSCALER4_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: VSCALER4_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: VSCALER4_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: VSCALER4_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKUNLOCK_VSCALER4_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_vscaler4_LockStatus */
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS               ((uint32_t)(0xB24))
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_OFFSET        ((uint32_t)(0x324))
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_VSCALER4_LOCKSTATUS_VSCALER4_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_vscaler4_Dynamic */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC                  ((uint32_t)(0xB28))
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_OFFSET           ((uint32_t)(0x328))
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL_SHIFT 0U
/* Field Value: VSCALER4_SRC_SEL__DISABLE, Unit vscaler4 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__DISABLE 0U
/* Field Value: VSCALER4_SRC_SEL__EXTSRC4, Unit vscaler4 input port src is
 * connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__EXTSRC4 0x14U
/* Field Value: VSCALER4_SRC_SEL__FETCHDECODE0, Unit vscaler4 input port src
 * is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__FETCHDECODE0 0x1CU
/* Field Value: VSCALER4_SRC_SEL__FETCHDECODE2, Unit vscaler4 input port src
 * is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__FETCHDECODE2 0x18U
/* Field Value: VSCALER4_SRC_SEL__HSCALER4, Unit vscaler4 input port src is
 * connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__HSCALER4 0x24U
/* Field Value: VSCALER4_SRC_SEL__MATRIX4, Unit vscaler4 input port src is
 * connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_SRC_SEL__MATRIX4 0x23U
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_CLKEN_SHIFT 24U
/* Field Value: VSCALER4_CLKEN__DISABLE, Clock for vscaler4 is disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_CLKEN__DISABLE 0U
/* Field Value: VSCALER4_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_CLKEN__AUTOMATIC 0x1U
/* Field Value: VSCALER4_CLKEN__FULL, Clock for vscaler4 is without gating  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_DYNAMIC_VSCALER4_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_vscaler4_Status */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS                   ((uint32_t)(0xB2C))
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_OFFSET            ((uint32_t)(0x32C))
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL_SHIFT 16U
/* Field Value: VSCALER4_SEL__STORE9, vscaler4 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__STORE9 0x1U
/* Field Value: VSCALER4_SEL__EXTDST0, vscaler4 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__EXTDST0 0x2U
/* Field Value: VSCALER4_SEL__EXTDST4, vscaler4 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__EXTDST4 0x3U
/* Field Value: VSCALER4_SEL__EXTDST1, vscaler4 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__EXTDST1 0x4U
/* Field Value: VSCALER4_SEL__EXTDST5, vscaler4 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__EXTDST5 0x5U
/* Field Value: VSCALER4_SEL__STORE4, vscaler4 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__STORE4 0x6U
/* Field Value: VSCALER4_SEL__STORE5, vscaler4 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__STORE5 0x7U
/* Field Value: VSCALER4_SEL__DISABLE, vscaler4 module is not used  */
#define IMXDPUV1_PIXENGCFG_VSCALER4_STATUS_VSCALER4_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_matrix5_LockUnlock */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK                ((uint32_t)(0xB40))
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_OFFSET         ((uint32_t)(0x340))
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_RESET_MASK     0U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK_SHIFT 0U
/* Field Value: MATRIX5_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: MATRIX5_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: MATRIX5_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: MATRIX5_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: MATRIX5_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKUNLOCK_MATRIX5_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_matrix5_LockStatus */
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS                ((uint32_t)(0xB44))
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_OFFSET         ((uint32_t)(0x344))
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_MATRIX5_LOCKSTATUS_MATRIX5_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_matrix5_Dynamic */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC                   ((uint32_t)(0xB48))
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_OFFSET            ((uint32_t)(0x348))
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_RESET_VALUE       0x1000000U
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_SRC_SEL_SHIFT 0U
/* Field Value: MATRIX5_SRC_SEL__DISABLE, Unit matrix5 input port src is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_SRC_SEL__DISABLE 0U
/* Field Value: MATRIX5_SRC_SEL__GAMMACOR5, Unit matrix5 input port src is
 * connected to output of unit gammacor5  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_SRC_SEL__GAMMACOR5 0x27U
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_CLKEN_SHIFT 24U
/* Field Value: MATRIX5_CLKEN__DISABLE, Clock for matrix5 is disabled  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_CLKEN__DISABLE 0U
/* Field Value: MATRIX5_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_CLKEN__AUTOMATIC 0x1U
/* Field Value: MATRIX5_CLKEN__FULL, Clock for matrix5 is without gating  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_DYNAMIC_MATRIX5_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_matrix5_Status */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS                    ((uint32_t)(0xB4C))
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_OFFSET             ((uint32_t)(0x34C))
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_RESET_VALUE        0U
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_RESET_MASK         0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL_MASK   0x70000U
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL_SHIFT  16U
/* Field Value: MATRIX5_SEL__STORE9, matrix5 module is used from store9 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__STORE9 0x1U
/* Field Value: MATRIX5_SEL__EXTDST0, matrix5 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__EXTDST0 0x2U
/* Field Value: MATRIX5_SEL__EXTDST4, matrix5 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__EXTDST4 0x3U
/* Field Value: MATRIX5_SEL__EXTDST1, matrix5 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__EXTDST1 0x4U
/* Field Value: MATRIX5_SEL__EXTDST5, matrix5 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__EXTDST5 0x5U
/* Field Value: MATRIX5_SEL__STORE4, matrix5 module is used from store4 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__STORE4 0x6U
/* Field Value: MATRIX5_SEL__STORE5, matrix5 module is used from store5 processing
 * path  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__STORE5 0x7U
/* Field Value: MATRIX5_SEL__DISABLE, matrix5 module is not used  */
#define IMXDPUV1_PIXENGCFG_MATRIX5_STATUS_MATRIX5_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_hscaler5_LockUnlock */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK               ((uint32_t)(0xB60))
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_OFFSET        ((uint32_t)(0x360))
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK_SHIFT 0U
/* Field Value: HSCALER5_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: HSCALER5_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: HSCALER5_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: HSCALER5_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: HSCALER5_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKUNLOCK_HSCALER5_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_hscaler5_LockStatus */
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS               ((uint32_t)(0xB64))
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_OFFSET        ((uint32_t)(0x364))
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_HSCALER5_LOCKSTATUS_HSCALER5_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_hscaler5_Dynamic */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC                  ((uint32_t)(0xB68))
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_OFFSET           ((uint32_t)(0x368))
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL_SHIFT 0U
/* Field Value: HSCALER5_SRC_SEL__DISABLE, Unit hscaler5 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__DISABLE 0U
/* Field Value: HSCALER5_SRC_SEL__EXTSRC5, Unit hscaler5 input port src is
 * connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__EXTSRC5 0x16U
/* Field Value: HSCALER5_SRC_SEL__FETCHDECODE1, Unit hscaler5 input port src
 * is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__FETCHDECODE1 0x1EU
/* Field Value: HSCALER5_SRC_SEL__FETCHDECODE3, Unit hscaler5 input port src
 * is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__FETCHDECODE3 0x19U
/* Field Value: HSCALER5_SRC_SEL__MATRIX5, Unit hscaler5 input port src is
 * connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__MATRIX5 0x28U
/* Field Value: HSCALER5_SRC_SEL__VSCALER5, Unit hscaler5 input port src is
 * connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_SRC_SEL__VSCALER5 0x2AU
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_CLKEN_SHIFT 24U
/* Field Value: HSCALER5_CLKEN__DISABLE, Clock for hscaler5 is disabled  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_CLKEN__DISABLE 0U
/* Field Value: HSCALER5_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_CLKEN__AUTOMATIC 0x1U
/* Field Value: HSCALER5_CLKEN__FULL, Clock for hscaler5 is without gating  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_DYNAMIC_HSCALER5_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_hscaler5_Status */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS                   ((uint32_t)(0xB6C))
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_OFFSET            ((uint32_t)(0x36C))
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL_SHIFT 16U
/* Field Value: HSCALER5_SEL__STORE9, hscaler5 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__STORE9 0x1U
/* Field Value: HSCALER5_SEL__EXTDST0, hscaler5 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__EXTDST0 0x2U
/* Field Value: HSCALER5_SEL__EXTDST4, hscaler5 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__EXTDST4 0x3U
/* Field Value: HSCALER5_SEL__EXTDST1, hscaler5 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__EXTDST1 0x4U
/* Field Value: HSCALER5_SEL__EXTDST5, hscaler5 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__EXTDST5 0x5U
/* Field Value: HSCALER5_SEL__STORE4, hscaler5 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__STORE4 0x6U
/* Field Value: HSCALER5_SEL__STORE5, hscaler5 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__STORE5 0x7U
/* Field Value: HSCALER5_SEL__DISABLE, hscaler5 module is not used  */
#define IMXDPUV1_PIXENGCFG_HSCALER5_STATUS_HSCALER5_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_vscaler5_LockUnlock */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK               ((uint32_t)(0xB80))
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_OFFSET        ((uint32_t)(0x380))
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_RESET_MASK    0U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK_SHIFT 0U
/* Field Value: VSCALER5_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset counter
 * value is 1.  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: VSCALER5_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter.
 * Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: VSCALER5_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: VSCALER5_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: VSCALER5_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKUNLOCK_VSCALER5_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_vscaler5_LockStatus */
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS               ((uint32_t)(0xB84))
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_OFFSET        ((uint32_t)(0x384))
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_RESET_VALUE   0U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_VSCALER5_LOCKSTATUS_VSCALER5_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_vscaler5_Dynamic */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC                  ((uint32_t)(0xB88))
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_OFFSET           ((uint32_t)(0x388))
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_RESET_VALUE      0x1000000U
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL_SHIFT 0U
/* Field Value: VSCALER5_SRC_SEL__DISABLE, Unit vscaler5 input port src is
 * disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__DISABLE 0U
/* Field Value: VSCALER5_SRC_SEL__EXTSRC5, Unit vscaler5 input port src is
 * connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__EXTSRC5 0x16U
/* Field Value: VSCALER5_SRC_SEL__FETCHDECODE1, Unit vscaler5 input port src
 * is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__FETCHDECODE1 0x1EU
/* Field Value: VSCALER5_SRC_SEL__FETCHDECODE3, Unit vscaler5 input port src
 * is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__FETCHDECODE3 0x19U
/* Field Value: VSCALER5_SRC_SEL__HSCALER5, Unit vscaler5 input port src is
 * connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__HSCALER5 0x29U
/* Field Value: VSCALER5_SRC_SEL__MATRIX5, Unit vscaler5 input port src is
 * connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_SRC_SEL__MATRIX5 0x28U
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_CLKEN_SHIFT 24U
/* Field Value: VSCALER5_CLKEN__DISABLE, Clock for vscaler5 is disabled  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_CLKEN__DISABLE 0U
/* Field Value: VSCALER5_CLKEN__AUTOMATIC, Clock is enabled if unit is used,
 * frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_CLKEN__AUTOMATIC 0x1U
/* Field Value: VSCALER5_CLKEN__FULL, Clock for vscaler5 is without gating  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_DYNAMIC_VSCALER5_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_vscaler5_Status */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS                   ((uint32_t)(0xB8C))
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_OFFSET            ((uint32_t)(0x38C))
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_RESET_VALUE       0U
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_RESET_MASK        0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL_SHIFT 16U
/* Field Value: VSCALER5_SEL__STORE9, vscaler5 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__STORE9 0x1U
/* Field Value: VSCALER5_SEL__EXTDST0, vscaler5 module is used from extdst0
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__EXTDST0 0x2U
/* Field Value: VSCALER5_SEL__EXTDST4, vscaler5 module is used from extdst4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__EXTDST4 0x3U
/* Field Value: VSCALER5_SEL__EXTDST1, vscaler5 module is used from extdst1
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__EXTDST1 0x4U
/* Field Value: VSCALER5_SEL__EXTDST5, vscaler5 module is used from extdst5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__EXTDST5 0x5U
/* Field Value: VSCALER5_SEL__STORE4, vscaler5 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__STORE4 0x6U
/* Field Value: VSCALER5_SEL__STORE5, vscaler5 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__STORE5 0x7U
/* Field Value: VSCALER5_SEL__DISABLE, vscaler5 module is not used  */
#define IMXDPUV1_PIXENGCFG_VSCALER5_STATUS_VSCALER5_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_layerblend0_LockUnlock */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK            ((uint32_t)(0xBA0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_OFFSET     ((uint32_t)(0x3A0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK_SHIFT 0U
/* Field Value: LAYERBLEND0_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LAYERBLEND0_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LAYERBLEND0_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LAYERBLEND0_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LAYERBLEND0_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKUNLOCK_LAYERBLEND0_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_layerblend0_LockStatus */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS            ((uint32_t)(0xBA4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_OFFSET     ((uint32_t)(0x3A4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_LOCKSTATUS_LAYERBLEND0_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_layerblend0_Dynamic */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC               ((uint32_t)(0xBA8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_OFFSET        ((uint32_t)(0x3A8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_RESET_VALUE   0x1001C0CU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL_SHIFT 0U
/* Field Value: LAYERBLEND0_PRIM_SEL__DISABLE, Unit layerblend0 input port
 * prim is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__DISABLE 0U
/* Field Value: LAYERBLEND0_PRIM_SEL__BLITBLEND9, Unit layerblend0 input port
 * prim is connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__BLITBLEND9 0xAU
/* Field Value: LAYERBLEND0_PRIM_SEL__CONSTFRAME0, Unit layerblend0 input
 * port prim is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__CONSTFRAME0 0xCU
/* Field Value: LAYERBLEND0_PRIM_SEL__CONSTFRAME1, Unit layerblend0 input
 * port prim is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__CONSTFRAME1 0x10U
/* Field Value: LAYERBLEND0_PRIM_SEL__CONSTFRAME4, Unit layerblend0 input
 * port prim is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__CONSTFRAME4 0xEU
/* Field Value: LAYERBLEND0_PRIM_SEL__CONSTFRAME5, Unit layerblend0 input
 * port prim is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__CONSTFRAME5 0x12U
/* Field Value: LAYERBLEND0_PRIM_SEL__MATRIX4, Unit layerblend0 input port
 * prim is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND0_PRIM_SEL__HSCALER4, Unit layerblend0 input port
 * prim is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND0_PRIM_SEL__VSCALER4, Unit layerblend0 input port
 * prim is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND0_PRIM_SEL__EXTSRC4, Unit layerblend0 input port
 * prim is connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__EXTSRC4 0x14U
/* Field Value: LAYERBLEND0_PRIM_SEL__MATRIX5, Unit layerblend0 input port
 * prim is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND0_PRIM_SEL__HSCALER5, Unit layerblend0 input port
 * prim is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND0_PRIM_SEL__VSCALER5, Unit layerblend0 input port
 * prim is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND0_PRIM_SEL__EXTSRC5, Unit layerblend0 input port
 * prim is connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_PRIM_SEL__EXTSRC5 0x16U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL_MASK 0x3F00U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL_SHIFT 8U
/* Field Value: LAYERBLEND0_SEC_SEL__DISABLE, Unit layerblend0 input port
 * sec is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__DISABLE 0U
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHDECODE2, Unit layerblend0 input
 * port sec is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHDECODE2 0x18U
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHDECODE3, Unit layerblend0 input
 * port sec is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHDECODE3 0x19U
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHWARP2, Unit layerblend0 input port
 * sec is connected to output of unit fetchwarp2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHWARP2 0x1AU
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHDECODE0, Unit layerblend0 input
 * port sec is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHDECODE0 0x1CU
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHDECODE1, Unit layerblend0 input
 * port sec is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHDECODE1 0x1EU
/* Field Value: LAYERBLEND0_SEC_SEL__MATRIX4, Unit layerblend0 input port
 * sec is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND0_SEC_SEL__HSCALER4, Unit layerblend0 input port
 * sec is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND0_SEC_SEL__VSCALER4, Unit layerblend0 input port
 * sec is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND0_SEC_SEL__MATRIX5, Unit layerblend0 input port
 * sec is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND0_SEC_SEL__HSCALER5, Unit layerblend0 input port
 * sec is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND0_SEC_SEL__VSCALER5, Unit layerblend0 input port
 * sec is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHLAYER0, Unit layerblend0 input port
 * sec is connected to output of unit fetchlayer0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHLAYER0 0x20U
/* Field Value: LAYERBLEND0_SEC_SEL__FETCHLAYER1, Unit layerblend0 input port
 * sec is connected to output of unit fetchlayer1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_SEC_SEL__FETCHLAYER1 0x21U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_CLKEN_SHIFT 24U
/* Field Value: LAYERBLEND0_CLKEN__DISABLE, Clock for layerblend0 is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_CLKEN__DISABLE 0U
/* Field Value: LAYERBLEND0_CLKEN__AUTOMATIC, Clock is enabled if unit is
 * used, frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_CLKEN__AUTOMATIC 0x1U
/* Field Value: LAYERBLEND0_CLKEN__FULL, Clock for layerblend0 is without
 * gating  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_DYNAMIC_LAYERBLEND0_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_layerblend0_Status */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS                ((uint32_t)(0xBAC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_OFFSET         ((uint32_t)(0x3AC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL_SHIFT 16U
/* Field Value: LAYERBLEND0_SEL__STORE9, layerblend0 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__STORE9 0x1U
/* Field Value: LAYERBLEND0_SEL__EXTDST0, layerblend0 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__EXTDST0 0x2U
/* Field Value: LAYERBLEND0_SEL__EXTDST4, layerblend0 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__EXTDST4 0x3U
/* Field Value: LAYERBLEND0_SEL__EXTDST1, layerblend0 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__EXTDST1 0x4U
/* Field Value: LAYERBLEND0_SEL__EXTDST5, layerblend0 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__EXTDST5 0x5U
/* Field Value: LAYERBLEND0_SEL__STORE4, layerblend0 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__STORE4 0x6U
/* Field Value: LAYERBLEND0_SEL__STORE5, layerblend0 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__STORE5 0x7U
/* Field Value: LAYERBLEND0_SEL__DISABLE, layerblend0 module is not used  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND0_STATUS_LAYERBLEND0_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_layerblend1_LockUnlock */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK            ((uint32_t)(0xBC0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_OFFSET     ((uint32_t)(0x3C0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK_SHIFT 0U
/* Field Value: LAYERBLEND1_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LAYERBLEND1_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LAYERBLEND1_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LAYERBLEND1_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LAYERBLEND1_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKUNLOCK_LAYERBLEND1_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_layerblend1_LockStatus */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS            ((uint32_t)(0xBC4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_OFFSET     ((uint32_t)(0x3C4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_LOCKSTATUS_LAYERBLEND1_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_layerblend1_Dynamic */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC               ((uint32_t)(0xBC8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_OFFSET        ((uint32_t)(0x3C8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_RESET_VALUE   0x1001E10U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL_SHIFT 0U
/* Field Value: LAYERBLEND1_PRIM_SEL__DISABLE, Unit layerblend1 input port
 * prim is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__DISABLE 0U
/* Field Value: LAYERBLEND1_PRIM_SEL__BLITBLEND9, Unit layerblend1 input port
 * prim is connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__BLITBLEND9 0xAU
/* Field Value: LAYERBLEND1_PRIM_SEL__CONSTFRAME0, Unit layerblend1 input
 * port prim is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__CONSTFRAME0 0xCU
/* Field Value: LAYERBLEND1_PRIM_SEL__CONSTFRAME1, Unit layerblend1 input
 * port prim is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__CONSTFRAME1 0x10U
/* Field Value: LAYERBLEND1_PRIM_SEL__CONSTFRAME4, Unit layerblend1 input
 * port prim is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__CONSTFRAME4 0xEU
/* Field Value: LAYERBLEND1_PRIM_SEL__CONSTFRAME5, Unit layerblend1 input
 * port prim is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__CONSTFRAME5 0x12U
/* Field Value: LAYERBLEND1_PRIM_SEL__MATRIX4, Unit layerblend1 input port
 * prim is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND1_PRIM_SEL__HSCALER4, Unit layerblend1 input port
 * prim is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND1_PRIM_SEL__VSCALER4, Unit layerblend1 input port
 * prim is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND1_PRIM_SEL__EXTSRC4, Unit layerblend1 input port
 * prim is connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__EXTSRC4 0x14U
/* Field Value: LAYERBLEND1_PRIM_SEL__MATRIX5, Unit layerblend1 input port
 * prim is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND1_PRIM_SEL__HSCALER5, Unit layerblend1 input port
 * prim is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND1_PRIM_SEL__VSCALER5, Unit layerblend1 input port
 * prim is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND1_PRIM_SEL__EXTSRC5, Unit layerblend1 input port
 * prim is connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__EXTSRC5 0x16U
/* Field Value: LAYERBLEND1_PRIM_SEL__LAYERBLEND0, Unit layerblend1 input
 * port prim is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_PRIM_SEL__LAYERBLEND0 0x2CU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL_MASK 0x3F00U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL_SHIFT 8U
/* Field Value: LAYERBLEND1_SEC_SEL__DISABLE, Unit layerblend1 input port
 * sec is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__DISABLE 0U
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHDECODE2, Unit layerblend1 input
 * port sec is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHDECODE2 0x18U
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHDECODE3, Unit layerblend1 input
 * port sec is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHDECODE3 0x19U
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHWARP2, Unit layerblend1 input port
 * sec is connected to output of unit fetchwarp2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHWARP2 0x1AU
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHDECODE0, Unit layerblend1 input
 * port sec is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHDECODE0 0x1CU
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHDECODE1, Unit layerblend1 input
 * port sec is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHDECODE1 0x1EU
/* Field Value: LAYERBLEND1_SEC_SEL__MATRIX4, Unit layerblend1 input port
 * sec is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND1_SEC_SEL__HSCALER4, Unit layerblend1 input port
 * sec is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND1_SEC_SEL__VSCALER4, Unit layerblend1 input port
 * sec is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND1_SEC_SEL__MATRIX5, Unit layerblend1 input port
 * sec is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND1_SEC_SEL__HSCALER5, Unit layerblend1 input port
 * sec is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND1_SEC_SEL__VSCALER5, Unit layerblend1 input port
 * sec is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHLAYER0, Unit layerblend1 input port
 * sec is connected to output of unit fetchlayer0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHLAYER0 0x20U
/* Field Value: LAYERBLEND1_SEC_SEL__FETCHLAYER1, Unit layerblend1 input port
 * sec is connected to output of unit fetchlayer1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_SEC_SEL__FETCHLAYER1 0x21U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_CLKEN_SHIFT 24U
/* Field Value: LAYERBLEND1_CLKEN__DISABLE, Clock for layerblend1 is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_CLKEN__DISABLE 0U
/* Field Value: LAYERBLEND1_CLKEN__AUTOMATIC, Clock is enabled if unit is
 * used, frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_CLKEN__AUTOMATIC 0x1U
/* Field Value: LAYERBLEND1_CLKEN__FULL, Clock for layerblend1 is without
 * gating  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_DYNAMIC_LAYERBLEND1_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_layerblend1_Status */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS                ((uint32_t)(0xBCC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_OFFSET         ((uint32_t)(0x3CC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL_SHIFT 16U
/* Field Value: LAYERBLEND1_SEL__STORE9, layerblend1 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__STORE9 0x1U
/* Field Value: LAYERBLEND1_SEL__EXTDST0, layerblend1 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__EXTDST0 0x2U
/* Field Value: LAYERBLEND1_SEL__EXTDST4, layerblend1 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__EXTDST4 0x3U
/* Field Value: LAYERBLEND1_SEL__EXTDST1, layerblend1 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__EXTDST1 0x4U
/* Field Value: LAYERBLEND1_SEL__EXTDST5, layerblend1 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__EXTDST5 0x5U
/* Field Value: LAYERBLEND1_SEL__STORE4, layerblend1 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__STORE4 0x6U
/* Field Value: LAYERBLEND1_SEL__STORE5, layerblend1 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__STORE5 0x7U
/* Field Value: LAYERBLEND1_SEL__DISABLE, layerblend1 module is not used  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND1_STATUS_LAYERBLEND1_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_layerblend2_LockUnlock */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK            ((uint32_t)(0xBE0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_OFFSET     ((uint32_t)(0x3E0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK_SHIFT 0U
/* Field Value: LAYERBLEND2_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LAYERBLEND2_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LAYERBLEND2_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LAYERBLEND2_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LAYERBLEND2_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKUNLOCK_LAYERBLEND2_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_layerblend2_LockStatus */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS            ((uint32_t)(0xBE4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_OFFSET     ((uint32_t)(0x3E4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_LOCKSTATUS_LAYERBLEND2_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_layerblend2_Dynamic */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC               ((uint32_t)(0xBE8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_OFFSET        ((uint32_t)(0x3E8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_RESET_VALUE   0x1000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL_SHIFT 0U
/* Field Value: LAYERBLEND2_PRIM_SEL__DISABLE, Unit layerblend2 input port
 * prim is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__DISABLE 0U
/* Field Value: LAYERBLEND2_PRIM_SEL__BLITBLEND9, Unit layerblend2 input port
 * prim is connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__BLITBLEND9 0xAU
/* Field Value: LAYERBLEND2_PRIM_SEL__CONSTFRAME0, Unit layerblend2 input
 * port prim is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__CONSTFRAME0 0xCU
/* Field Value: LAYERBLEND2_PRIM_SEL__CONSTFRAME1, Unit layerblend2 input
 * port prim is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__CONSTFRAME1 0x10U
/* Field Value: LAYERBLEND2_PRIM_SEL__CONSTFRAME4, Unit layerblend2 input
 * port prim is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__CONSTFRAME4 0xEU
/* Field Value: LAYERBLEND2_PRIM_SEL__CONSTFRAME5, Unit layerblend2 input
 * port prim is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__CONSTFRAME5 0x12U
/* Field Value: LAYERBLEND2_PRIM_SEL__MATRIX4, Unit layerblend2 input port
 * prim is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND2_PRIM_SEL__HSCALER4, Unit layerblend2 input port
 * prim is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND2_PRIM_SEL__VSCALER4, Unit layerblend2 input port
 * prim is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND2_PRIM_SEL__EXTSRC4, Unit layerblend2 input port
 * prim is connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__EXTSRC4 0x14U
/* Field Value: LAYERBLEND2_PRIM_SEL__MATRIX5, Unit layerblend2 input port
 * prim is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND2_PRIM_SEL__HSCALER5, Unit layerblend2 input port
 * prim is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND2_PRIM_SEL__VSCALER5, Unit layerblend2 input port
 * prim is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND2_PRIM_SEL__EXTSRC5, Unit layerblend2 input port
 * prim is connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__EXTSRC5 0x16U
/* Field Value: LAYERBLEND2_PRIM_SEL__LAYERBLEND1, Unit layerblend2 input
 * port prim is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__LAYERBLEND1 0x2DU
/* Field Value: LAYERBLEND2_PRIM_SEL__LAYERBLEND0, Unit layerblend2 input
 * port prim is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_PRIM_SEL__LAYERBLEND0 0x2CU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL_MASK 0x3F00U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL_SHIFT 8U
/* Field Value: LAYERBLEND2_SEC_SEL__DISABLE, Unit layerblend2 input port
 * sec is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__DISABLE 0U
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHDECODE2, Unit layerblend2 input
 * port sec is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHDECODE2 0x18U
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHDECODE3, Unit layerblend2 input
 * port sec is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHDECODE3 0x19U
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHWARP2, Unit layerblend2 input port
 * sec is connected to output of unit fetchwarp2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHWARP2 0x1AU
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHDECODE0, Unit layerblend2 input
 * port sec is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHDECODE0 0x1CU
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHDECODE1, Unit layerblend2 input
 * port sec is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHDECODE1 0x1EU
/* Field Value: LAYERBLEND2_SEC_SEL__MATRIX4, Unit layerblend2 input port
 * sec is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND2_SEC_SEL__HSCALER4, Unit layerblend2 input port
 * sec is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND2_SEC_SEL__VSCALER4, Unit layerblend2 input port
 * sec is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND2_SEC_SEL__MATRIX5, Unit layerblend2 input port
 * sec is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND2_SEC_SEL__HSCALER5, Unit layerblend2 input port
 * sec is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND2_SEC_SEL__VSCALER5, Unit layerblend2 input port
 * sec is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHLAYER0, Unit layerblend2 input port
 * sec is connected to output of unit fetchlayer0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHLAYER0 0x20U
/* Field Value: LAYERBLEND2_SEC_SEL__FETCHLAYER1, Unit layerblend2 input port
 * sec is connected to output of unit fetchlayer1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_SEC_SEL__FETCHLAYER1 0x21U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_CLKEN_SHIFT 24U
/* Field Value: LAYERBLEND2_CLKEN__DISABLE, Clock for layerblend2 is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_CLKEN__DISABLE 0U
/* Field Value: LAYERBLEND2_CLKEN__AUTOMATIC, Clock is enabled if unit is
 * used, frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_CLKEN__AUTOMATIC 0x1U
/* Field Value: LAYERBLEND2_CLKEN__FULL, Clock for layerblend2 is without
 * gating  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_DYNAMIC_LAYERBLEND2_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_layerblend2_Status */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS                ((uint32_t)(0xBEC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_OFFSET         ((uint32_t)(0x3EC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL_SHIFT 16U
/* Field Value: LAYERBLEND2_SEL__STORE9, layerblend2 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__STORE9 0x1U
/* Field Value: LAYERBLEND2_SEL__EXTDST0, layerblend2 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__EXTDST0 0x2U
/* Field Value: LAYERBLEND2_SEL__EXTDST4, layerblend2 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__EXTDST4 0x3U
/* Field Value: LAYERBLEND2_SEL__EXTDST1, layerblend2 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__EXTDST1 0x4U
/* Field Value: LAYERBLEND2_SEL__EXTDST5, layerblend2 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__EXTDST5 0x5U
/* Field Value: LAYERBLEND2_SEL__STORE4, layerblend2 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__STORE4 0x6U
/* Field Value: LAYERBLEND2_SEL__STORE5, layerblend2 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__STORE5 0x7U
/* Field Value: LAYERBLEND2_SEL__DISABLE, layerblend2 module is not used  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND2_STATUS_LAYERBLEND2_SEL__DISABLE 0U

/* Register: IMXDPUV1_pixengcfg_layerblend3_LockUnlock */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK            ((uint32_t)(0xC00))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_OFFSET     ((uint32_t)(0))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_RESET_MASK 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK_SHIFT 0U
/* Field Value: LAYERBLEND3_LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter.
 * When the counter value is null, lock protection is active. Reset
 * counter value is 1.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LAYERBLEND3_LOCKUNLOCK__UNLOCK_KEY, Increments the unlock
 * counter. Max allowed value is 15.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LAYERBLEND3_LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection.
 * Disabled after reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LAYERBLEND3_LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege
 * protection.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LAYERBLEND3_LOCKUNLOCK__FREEZE_KEY, Freezes current protection
 * status. Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKUNLOCK_LAYERBLEND3_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_pixengcfg_layerblend3_LockStatus */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS            ((uint32_t)(0xC04))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_OFFSET     ((uint32_t)(0x4))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_RESET_VALUE 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_LOCKSTATUS_MASK 0x1U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_LOCKSTATUS_SHIFT 0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_FREEZESTATUS_MASK 0x100U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_LOCKSTATUS_LAYERBLEND3_FREEZESTATUS_SHIFT 8U

/* Register: IMXDPUV1_pixengcfg_layerblend3_Dynamic */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC               ((uint32_t)(0xC08))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_OFFSET        ((uint32_t)(0x8))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_RESET_VALUE   0x1000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL_MASK 0x3FU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL_SHIFT 0U
/* Field Value: LAYERBLEND3_PRIM_SEL__DISABLE, Unit layerblend3 input port
 * prim is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__DISABLE 0U
/* Field Value: LAYERBLEND3_PRIM_SEL__BLITBLEND9, Unit layerblend3 input port
 * prim is connected to output of unit blitblend9  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__BLITBLEND9 0xAU
/* Field Value: LAYERBLEND3_PRIM_SEL__CONSTFRAME0, Unit layerblend3 input
 * port prim is connected to output of unit constframe0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__CONSTFRAME0 0xCU
/* Field Value: LAYERBLEND3_PRIM_SEL__CONSTFRAME1, Unit layerblend3 input
 * port prim is connected to output of unit constframe1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__CONSTFRAME1 0x10U
/* Field Value: LAYERBLEND3_PRIM_SEL__CONSTFRAME4, Unit layerblend3 input
 * port prim is connected to output of unit constframe4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__CONSTFRAME4 0xEU
/* Field Value: LAYERBLEND3_PRIM_SEL__CONSTFRAME5, Unit layerblend3 input
 * port prim is connected to output of unit constframe5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__CONSTFRAME5 0x12U
/* Field Value: LAYERBLEND3_PRIM_SEL__MATRIX4, Unit layerblend3 input port
 * prim is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND3_PRIM_SEL__HSCALER4, Unit layerblend3 input port
 * prim is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND3_PRIM_SEL__VSCALER4, Unit layerblend3 input port
 * prim is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND3_PRIM_SEL__EXTSRC4, Unit layerblend3 input port
 * prim is connected to output of unit extsrc4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__EXTSRC4 0x14U
/* Field Value: LAYERBLEND3_PRIM_SEL__MATRIX5, Unit layerblend3 input port
 * prim is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND3_PRIM_SEL__HSCALER5, Unit layerblend3 input port
 * prim is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND3_PRIM_SEL__VSCALER5, Unit layerblend3 input port
 * prim is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND3_PRIM_SEL__EXTSRC5, Unit layerblend3 input port
 * prim is connected to output of unit extsrc5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__EXTSRC5 0x16U
/* Field Value: LAYERBLEND3_PRIM_SEL__LAYERBLEND2, Unit layerblend3 input
 * port prim is connected to output of unit layerblend2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__LAYERBLEND2 0x2EU
/* Field Value: LAYERBLEND3_PRIM_SEL__LAYERBLEND1, Unit layerblend3 input
 * port prim is connected to output of unit layerblend1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__LAYERBLEND1 0x2DU
/* Field Value: LAYERBLEND3_PRIM_SEL__LAYERBLEND0, Unit layerblend3 input
 * port prim is connected to output of unit layerblend0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_PRIM_SEL__LAYERBLEND0 0x2CU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL_MASK 0x3F00U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL_SHIFT 8U
/* Field Value: LAYERBLEND3_SEC_SEL__DISABLE, Unit layerblend3 input port
 * sec is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__DISABLE 0U
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHDECODE2, Unit layerblend3 input
 * port sec is connected to output of unit fetchdecode2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHDECODE2 0x18U
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHDECODE3, Unit layerblend3 input
 * port sec is connected to output of unit fetchdecode3  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHDECODE3 0x19U
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHWARP2, Unit layerblend3 input port
 * sec is connected to output of unit fetchwarp2  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHWARP2 0x1AU
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHDECODE0, Unit layerblend3 input
 * port sec is connected to output of unit fetchdecode0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHDECODE0 0x1CU
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHDECODE1, Unit layerblend3 input
 * port sec is connected to output of unit fetchdecode1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHDECODE1 0x1EU
/* Field Value: LAYERBLEND3_SEC_SEL__MATRIX4, Unit layerblend3 input port
 * sec is connected to output of unit matrix4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__MATRIX4 0x23U
/* Field Value: LAYERBLEND3_SEC_SEL__HSCALER4, Unit layerblend3 input port
 * sec is connected to output of unit hscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__HSCALER4 0x24U
/* Field Value: LAYERBLEND3_SEC_SEL__VSCALER4, Unit layerblend3 input port
 * sec is connected to output of unit vscaler4  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__VSCALER4 0x25U
/* Field Value: LAYERBLEND3_SEC_SEL__MATRIX5, Unit layerblend3 input port
 * sec is connected to output of unit matrix5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__MATRIX5 0x28U
/* Field Value: LAYERBLEND3_SEC_SEL__HSCALER5, Unit layerblend3 input port
 * sec is connected to output of unit hscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__HSCALER5 0x29U
/* Field Value: LAYERBLEND3_SEC_SEL__VSCALER5, Unit layerblend3 input port
 * sec is connected to output of unit vscaler5  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__VSCALER5 0x2AU
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHLAYER0, Unit layerblend3 input port
 * sec is connected to output of unit fetchlayer0  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHLAYER0 0x20U
/* Field Value: LAYERBLEND3_SEC_SEL__FETCHLAYER1, Unit layerblend3 input port
 * sec is connected to output of unit fetchlayer1  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_SEC_SEL__FETCHLAYER1 0x21U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_CLKEN_MASK 0x3000000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_CLKEN_SHIFT 24U
/* Field Value: LAYERBLEND3_CLKEN__DISABLE, Clock for layerblend3 is disabled  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_CLKEN__DISABLE 0U
/* Field Value: LAYERBLEND3_CLKEN__AUTOMATIC, Clock is enabled if unit is
 * used, frequency is defined by the register setting for this pipeline (see
 * [endpoint_name]_Static register)  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_CLKEN__AUTOMATIC 0x1U
/* Field Value: LAYERBLEND3_CLKEN__FULL, Clock for layerblend3 is without
 * gating  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_DYNAMIC_LAYERBLEND3_CLKEN__FULL 0x3U

/* Register: IMXDPUV1_pixengcfg_layerblend3_Status */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS                ((uint32_t)(0xC0C))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_OFFSET         ((uint32_t)(0xC))
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_RESET_VALUE    0U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_RESET_MASK     0xFFF8FFFFU
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL_MASK 0x70000U
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL_SHIFT 16U
/* Field Value: LAYERBLEND3_SEL__STORE9, layerblend3 module is used from store9
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__STORE9 0x1U
/* Field Value: LAYERBLEND3_SEL__EXTDST0, layerblend3 module is used from
 * extdst0 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__EXTDST0 0x2U
/* Field Value: LAYERBLEND3_SEL__EXTDST4, layerblend3 module is used from
 * extdst4 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__EXTDST4 0x3U
/* Field Value: LAYERBLEND3_SEL__EXTDST1, layerblend3 module is used from
 * extdst1 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__EXTDST1 0x4U
/* Field Value: LAYERBLEND3_SEL__EXTDST5, layerblend3 module is used from
 * extdst5 processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__EXTDST5 0x5U
/* Field Value: LAYERBLEND3_SEL__STORE4, layerblend3 module is used from store4
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__STORE4 0x6U
/* Field Value: LAYERBLEND3_SEL__STORE5, layerblend3 module is used from store5
 * processing path  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__STORE5 0x7U
/* Field Value: LAYERBLEND3_SEL__DISABLE, layerblend3 module is not used  */
#define IMXDPUV1_PIXENGCFG_LAYERBLEND3_STATUS_LAYERBLEND3_SEL__DISABLE 0U

/* Register: IMXDPUV1_FetchDecode9_LockUnlock */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK                     ((uint32_t)(0x1000))
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_OFFSET              ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_RESET_MASK          0U
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK_SHIFT    0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHDECODE9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_FetchDecode9_LockStatus */
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS                     ((uint32_t)(0x1004))
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_OFFSET              ((uint32_t)(0x4))
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_LOCKSTATUS_MASK     0x1U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_LOCKSTATUS_SHIFT    0U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_FREEZESTATUS_MASK   0x100U
#define IMXDPUV1_FETCHDECODE9_LOCKSTATUS_FREEZESTATUS_SHIFT  8U

/* Register: IMXDPUV1_FetchDecode9_StaticControl */
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL                  ((uint32_t)(0x1008))
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_OFFSET           ((uint32_t)(0x8))
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_SHDEN_MASK       0x1U
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_SHDEN_SHIFT      0U
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE9_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_BurstBufferManagement */
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT          ((uint32_t)(0x100C))
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_OFFSET   ((uint32_t)(0xC))
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_FetchDecode9_RingBufStartAddr0 */
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0              ((uint32_t)(0x1010))
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0_OFFSET       ((uint32_t)(0x10))
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_RingBufWrapAddr0 */
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0               ((uint32_t)(0x1014))
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0_OFFSET        ((uint32_t)(0x14))
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_FrameProperties0 */
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0               ((uint32_t)(0x1018))
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0_OFFSET        ((uint32_t)(0x18))
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0_FIELDID0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE9_FRAMEPROPERTIES0_FIELDID0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_BaseAddress0 */
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0                   ((uint32_t)(0x101C))
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0_OFFSET            ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0_BASEADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_BASEADDRESS0_BASEADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0        ((uint32_t)(0x1020))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_OFFSET ((uint32_t)(0x20))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_SourceBufferDimension0 */
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0         ((uint32_t)(0x1024))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_OFFSET  ((uint32_t)(0x24))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_ColorComponentBits0 */
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0            ((uint32_t)(0x1028))
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_OFFSET     ((uint32_t)(0x28))
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode9_ColorComponentShift0 */
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0           ((uint32_t)(0x102C))
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_OFFSET    ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHDECODE9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode9_LayerOffset0 */
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0                   ((uint32_t)(0x1030))
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_OFFSET            ((uint32_t)(0x30))
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_LAYERXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_LAYERYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE9_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_ClipWindowOffset0 */
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0              ((uint32_t)(0x1034))
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_OFFSET       ((uint32_t)(0x34))
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0          ((uint32_t)(0x1038))
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_OFFSET   ((uint32_t)(0x38))
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode9_ConstantColor0 */
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0                 ((uint32_t)(0x103C))
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_OFFSET          ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHDECODE9_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode9_LayerProperty0 */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0                 ((uint32_t)(0x1040))
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_OFFSET          ((uint32_t)(0x40))
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RESET_VALUE     0x80000100U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_PALETTEENABLE0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_PALETTEENABLE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0_MASK  0x30U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0_SHIFT 4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHAMASKENABLE0_MASK 0x400U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHAMASKENABLE0_SHIFT 10U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHAMASKENABLE0_MASK 0x4000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHAMASKENABLE0_SHIFT 14U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode9_FrameDimensions */
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS                ((uint32_t)(0x1044))
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_OFFSET         ((uint32_t)(0x44))
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_RESET_VALUE    0xEF013FU
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE9_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode9_FrameResampling */
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING                ((uint32_t)(0x1048))
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_OFFSET         ((uint32_t)(0x48))
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_RESET_VALUE    0x104000U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_STARTX_MASK    0x3FU
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_STARTX_SHIFT   0U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_STARTY_MASK    0xFC0U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_STARTY_SHIFT   6U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_DELTAX_MASK    0x3F000U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_DELTAX_SHIFT   12U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_DELTAY_MASK    0xFC0000U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_DELTAY_SHIFT   18U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHDECODE9_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode9_DecodeControl */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL                  ((uint32_t)(0x104C))
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_OFFSET           ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RESET_VALUE      0x88880001U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE_MASK 0x3U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE_SHIFT 0U
/* Field Value: COMPRESSIONMODE__RLAD, Run-Length Adaptive Dithering (lossy
 * compression).  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE__RLAD 0U
/* Field Value: COMPRESSIONMODE__RLAD_UNIFORM, Run-Length Adaptive Dithering
 * (lossy compression; uniform package size).  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE__RLAD_UNIFORM 0x1U
/* Field Value: COMPRESSIONMODE__RLA, Run-Length Adaptive (lossless compression).  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE__RLA 0x2U
/* Field Value: COMPRESSIONMODE__RL, Standard Run-Length.  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_COMPRESSIONMODE__RL 0x3U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADENDIANNESS_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADENDIANNESS_SHIFT 15U
/* Field Value: RLADENDIANNESS__BIGENDIAN, Big endian format  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADENDIANNESS__BIGENDIAN 0U
/* Field Value: RLADENDIANNESS__LITTLEENDIAN, Little endian format  */
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADENDIANNESS__LITTLEENDIAN 0x1U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSRED_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSRED_SHIFT 16U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSGREEN_MASK 0xF00000U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSGREEN_SHIFT 20U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSBLUE_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSBLUE_SHIFT 24U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSALPHA_MASK 0xF0000000U
#define IMXDPUV1_FETCHDECODE9_DECODECONTROL_RLADCOMPBITSALPHA_SHIFT 28U

/* Register: IMXDPUV1_FetchDecode9_SourceBufferLength */
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH             ((uint32_t)(0x1050))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH_RLEWORDS_MASK 0x1FFFFFFFU
#define IMXDPUV1_FETCHDECODE9_SOURCEBUFFERLENGTH_RLEWORDS_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_Control */
#define IMXDPUV1_FETCHDECODE9_CONTROL                        ((uint32_t)(0x1054))
#define IMXDPUV1_FETCHDECODE9_CONTROL_OFFSET                 ((uint32_t)(0x54))
#define IMXDPUV1_FETCHDECODE9_CONTROL_RESET_VALUE            0x10700U
#define IMXDPUV1_FETCHDECODE9_CONTROL_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE_MASK        0x7U
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE_SHIFT       0U
/* Field Value: RASTERMODE__NORMAL, First sample at StartX/Y relative to origin.
 * Hor/ver increments using DeltaX/Y and DeltaSwap setup.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__NORMAL     0U
/* Field Value: RASTERMODE__DECODE, [FetchDecode/FetchDecodeL only] Source
 * buffer is an encoded bit stream. First sample at origin (0,0). Hor/ver
 * increments = (1,0)/(0,1).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__DECODE     0x1U
/* Field Value: RASTERMODE__ARBITRARY, [FetchPersp/Warp/Rot/RotL only] Arbitrary
 * warping (filter is active). Coordinates are read from frame input
 * port. InputSelect must be set to COORDINATE. ArbStartX/Y and ArbDeltaXX/XY/YX/YY
 * must be setup.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__ARBITRARY  0x2U
/* Field Value: RASTERMODE__PERSPECTIVE, [FetchPersp only] Affine/Perspective
 * warping (filter is active). First sample at PerspStartX/Y/W. Hor/ver
 * increments using PerspDeltaXX/XY/YX/YY/WX/WY. Homogeneous coordinates.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__PERSPECTIVE 0x3U
/* Field Value: RASTERMODE__YUV422, [FetchPersp/Decode only] Source buffer
 * is packed YUV 4:2:2. First sample at origin (0,0). Hor/ver increments
 * = (1,0)/(0,1). All corellated window widths and horizontal offsets must
 * be even.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__YUV422     0x4U
/* Field Value: RASTERMODE__AFFINE, [FetchRot/RotL only] Affine warping (filter
 * is active). First sample at AffineStartX/Y. Hor/ver increments using
 * AffineDeltaXX/XY/YX/YY. Cartesian coordinates.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_RASTERMODE__AFFINE     0x5U
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT_MASK       0x18U
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT_SHIFT      3U
/* Field Value: INPUTSELECT__INACTIVE, Not used.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT__INACTIVE  0U
/* Field Value: INPUTSELECT__COMPPACK, Used for component packing (e.g. UV
 * or source alpha buffer).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT__COMPPACK  0x1U
/* Field Value: INPUTSELECT__ALPHAMASK, Used for RGB and alpha pre-multiply
 * stage (mask alpha buffer).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT__ALPHAMASK 0x2U
/* Field Value: INPUTSELECT__COORDINATE, Used for arbitrary warping (coordinate
 * buffer).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_INPUTSELECT__COORDINATE 0x3U
#define IMXDPUV1_FETCHDECODE9_CONTROL_YUV422UPSAMPLINGMODE_MASK 0x20U
#define IMXDPUV1_FETCHDECODE9_CONTROL_YUV422UPSAMPLINGMODE_SHIFT 5U
/* Field Value: YUV422UPSAMPLINGMODE__REPLICATE, Replicate mode for interspersed
 * samples (UV samples between Y samples).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_YUV422UPSAMPLINGMODE__REPLICATE 0U
/* Field Value: YUV422UPSAMPLINGMODE__INTERPOLATE, Interpolate mode for coaligned
 * samples (UV samples at Y sample positions).  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_YUV422UPSAMPLINGMODE__INTERPOLATE 0x1U
#define IMXDPUV1_FETCHDECODE9_CONTROL_RAWPIXEL_MASK          0x80U
#define IMXDPUV1_FETCHDECODE9_CONTROL_RAWPIXEL_SHIFT         7U
#define IMXDPUV1_FETCHDECODE9_CONTROL_PALETTEIDXWIDTH_MASK   0x700U
#define IMXDPUV1_FETCHDECODE9_CONTROL_PALETTEIDXWIDTH_SHIFT  8U
#define IMXDPUV1_FETCHDECODE9_CONTROL_CLIPCOLOR_MASK         0x10000U
#define IMXDPUV1_FETCHDECODE9_CONTROL_CLIPCOLOR_SHIFT        16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_CLIPCOLOR__NULL        0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHDECODE9_CONTROL_CLIPCOLOR__LAYER       0x1U

/* Register: IMXDPUV1_FetchDecode9_ControlTrigger */
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER                 ((uint32_t)(0x1058))
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER_OFFSET          ((uint32_t)(0x58))
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER_RESET_MASK      0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER_SHDTOKGEN_MASK  0x1U
#define IMXDPUV1_FETCHDECODE9_CONTROLTRIGGER_SHDTOKGEN_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_Start */
#define IMXDPUV1_FETCHDECODE9_START                          ((uint32_t)(0x105C))
#define IMXDPUV1_FETCHDECODE9_START_OFFSET                   ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHDECODE9_START_RESET_VALUE              0U
#define IMXDPUV1_FETCHDECODE9_START_RESET_MASK               0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE9_START_START_MASK               0x1U
#define IMXDPUV1_FETCHDECODE9_START_START_SHIFT              0U

/* Register: IMXDPUV1_FetchDecode9_FetchType */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE                      ((uint32_t)(0x1060))
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_OFFSET               ((uint32_t)(0x60))
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_RESET_VALUE          0U
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_RESET_MASK           0xFFFFFFF0U
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE_MASK       0xFU
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE_SHIFT      0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__DECODE    0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__LAYER     0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__WARP      0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__ECO       0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__PERSP     0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__ROT       0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__DECODEL   0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__LAYERL    0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE9_FETCHTYPE_FETCHTYPE__ROTL      0x8U

/* Register: IMXDPUV1_FetchDecode9_DecoderStatus */
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS                  ((uint32_t)(0x1064))
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_OFFSET           ((uint32_t)(0x64))
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_BUFFERTOOSMALL_MASK 0x1U
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_BUFFERTOOSMALL_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_BUFFERTOOLARGE_MASK 0x2U
#define IMXDPUV1_FETCHDECODE9_DECODERSTATUS_BUFFERTOOLARGE_SHIFT 1U

/* Register: IMXDPUV1_FetchDecode9_ReadAddress0 */
#define IMXDPUV1_FETCHDECODE9_READADDRESS0                   ((uint32_t)(0x1068))
#define IMXDPUV1_FETCHDECODE9_READADDRESS0_OFFSET            ((uint32_t)(0x68))
#define IMXDPUV1_FETCHDECODE9_READADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE9_READADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_READADDRESS0_READADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_READADDRESS0_READADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode9_BurstBufferProperties */
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES          ((uint32_t)(0x106C))
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_OFFSET   ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode9_Status */
#define IMXDPUV1_FETCHDECODE9_STATUS                         ((uint32_t)(0x1070))
#define IMXDPUV1_FETCHDECODE9_STATUS_OFFSET                  ((uint32_t)(0x70))
#define IMXDPUV1_FETCHDECODE9_STATUS_RESET_VALUE             0U
#define IMXDPUV1_FETCHDECODE9_STATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE9_STATUS_WRITETIMEOUT_MASK       0x1U
#define IMXDPUV1_FETCHDECODE9_STATUS_WRITETIMEOUT_SHIFT      0U
#define IMXDPUV1_FETCHDECODE9_STATUS_READTIMEOUT_MASK        0x10U
#define IMXDPUV1_FETCHDECODE9_STATUS_READTIMEOUT_SHIFT       4U

/* Register: IMXDPUV1_FetchDecode9_HiddenStatus */
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS                   ((uint32_t)(0x1074))
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_OFFSET            ((uint32_t)(0x74))
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_RESET_MASK        0xFFFF008EU
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSBUSY_MASK   0x1U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSBUSY_SHIFT  0U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSREQUEST_MASK 0x20U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_SHADOWSTATUS_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE9_HIDDENSTATUS_SHADOWSTATUS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode9_ColorPalette */
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE                   ((uint32_t)(0x1400))
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE_OFFSET            ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE_RESET_MASK        0xFF000000U
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE_COLORPALETTE_MASK 0xFFFFFFU
#define IMXDPUV1_FETCHDECODE9_COLORPALETTE_COLORPALETTE_SHIFT 0U

/* Register: IMXDPUV1_fetchwarp9_LockUnlock */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK                       ((uint32_t)(0x1800))
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_OFFSET                ((uint32_t)(0))
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_RESET_VALUE           0U
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_RESET_MASK            0U
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK_SHIFT      0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY  0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHWARP9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetchwarp9_LockStatus */
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS                       ((uint32_t)(0x1804))
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_OFFSET                ((uint32_t)(0x4))
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_RESET_VALUE           0U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_LOCKSTATUS_MASK       0x1U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_LOCKSTATUS_SHIFT      0U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_PRIVILEGESTATUS_MASK  0x10U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_FREEZESTATUS_MASK     0x100U
#define IMXDPUV1_FETCHWARP9_LOCKSTATUS_FREEZESTATUS_SHIFT    8U

/* Register: IMXDPUV1_fetchwarp9_StaticControl */
#define IMXDPUV1_FETCHWARP9_STATICCONTROL                    ((uint32_t)(0x1808))
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_OFFSET             ((uint32_t)(0x8))
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_RESET_VALUE        0xFF000000U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_SHDEN_MASK         0x1U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_SHDEN_SHIFT        0U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_SHDLDREQSTICKY_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_STATICCONTROL_SHDLDREQSTICKY_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_BurstBufferManagement */
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT            ((uint32_t)(0x180C))
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_OFFSET     ((uint32_t)(0xC))
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress0 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0                     ((uint32_t)(0x1810))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0_OFFSET              ((uint32_t)(0x10))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0_BASEADDRESS0_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS0_BASEADDRESS0_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0          ((uint32_t)(0x1814))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_OFFSET   ((uint32_t)(0x14))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension0 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0           ((uint32_t)(0x1818))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_OFFSET    ((uint32_t)(0x18))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits0 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0              ((uint32_t)(0x181C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_OFFSET       ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift0 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0             ((uint32_t)(0x1820))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_OFFSET      ((uint32_t)(0x20))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset0 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0                     ((uint32_t)(0x1824))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_OFFSET              ((uint32_t)(0x24))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_LAYERXOFFSET0_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_LAYERYOFFSET0_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset0 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0                ((uint32_t)(0x1828))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_OFFSET         ((uint32_t)(0x28))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0            ((uint32_t)(0x182C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_OFFSET     ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor0 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0                   ((uint32_t)(0x1830))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_OFFSET            ((uint32_t)(0x30))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty0 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0                   ((uint32_t)(0x1834))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_OFFSET            ((uint32_t)(0x34))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RESET_VALUE       0x80000100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0_SHIFT   4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHAMASKENABLE0_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHAMASKENABLE0_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHAMASKENABLE0_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHAMASKENABLE0_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress1 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1                     ((uint32_t)(0x1838))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1_OFFSET              ((uint32_t)(0x38))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1_BASEADDRESS1_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS1_BASEADDRESS1_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes1 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1          ((uint32_t)(0x183C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_OFFSET   ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_STRIDE1_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_STRIDE1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension1 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1           ((uint32_t)(0x1840))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_OFFSET    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_LINEWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_LINEWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_LINECOUNT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION1_LINECOUNT1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits1 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1              ((uint32_t)(0x1844))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_OFFSET       ((uint32_t)(0x44))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSRED1_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_COMPONENTBITSRED1_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_ITUFORMAT1_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS1_ITUFORMAT1_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift1 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1             ((uint32_t)(0x1848))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_OFFSET      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset1 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1                     ((uint32_t)(0x184C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_OFFSET              ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_LAYERXOFFSET1_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_LAYERXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_LAYERYOFFSET1_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET1_LAYERYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset1 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1                ((uint32_t)(0x1850))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_OFFSET         ((uint32_t)(0x50))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions1 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1            ((uint32_t)(0x1854))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_OFFSET     ((uint32_t)(0x54))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor1 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1                   ((uint32_t)(0x1858))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_OFFSET            ((uint32_t)(0x58))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTALPHA1_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTBLUE1_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTGREEN1_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTRED1_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR1_CONSTANTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty1 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1                   ((uint32_t)(0x185C))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_OFFSET            ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1_SHIFT   4U
/* Field Value: TILEMODE1__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE1__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE1__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1__TILE_PAD 0x2U
/* Field Value: TILEMODE1__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_TILEMODE1__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHASRCENABLE1_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHASRCENABLE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHACONSTENABLE1_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHACONSTENABLE1_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHAMASKENABLE1_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHAMASKENABLE1_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHATRANSENABLE1_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_ALPHATRANSENABLE1_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHASRCENABLE1_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHASRCENABLE1_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHACONSTENABLE1_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHACONSTENABLE1_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHAMASKENABLE1_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHAMASKENABLE1_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHATRANSENABLE1_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_RGBALPHATRANSENABLE1_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_PREMULCONSTRGB1_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_PREMULCONSTRGB1_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE1__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1__OFF 0U
/* Field Value: YUVCONVERSIONMODE1__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE1__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE1__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_GAMMAREMOVEENABLE1_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_GAMMAREMOVEENABLE1_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_CLIPWINDOWENABLE1_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_CLIPWINDOWENABLE1_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_SOURCEBUFFERENABLE1_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY1_SOURCEBUFFERENABLE1_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress2 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2                     ((uint32_t)(0x1860))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2_OFFSET              ((uint32_t)(0x60))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2_BASEADDRESS2_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS2_BASEADDRESS2_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes2 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2          ((uint32_t)(0x1864))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_OFFSET   ((uint32_t)(0x64))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_STRIDE2_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_STRIDE2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension2 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2           ((uint32_t)(0x1868))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_OFFSET    ((uint32_t)(0x68))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_LINEWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_LINEWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_LINECOUNT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION2_LINECOUNT2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits2 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2              ((uint32_t)(0x186C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_OFFSET       ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSRED2_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_COMPONENTBITSRED2_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_ITUFORMAT2_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS2_ITUFORMAT2_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift2 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2             ((uint32_t)(0x1870))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_OFFSET      ((uint32_t)(0x70))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset2 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2                     ((uint32_t)(0x1874))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_OFFSET              ((uint32_t)(0x74))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_LAYERXOFFSET2_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_LAYERXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_LAYERYOFFSET2_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET2_LAYERYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset2 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2                ((uint32_t)(0x1878))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_OFFSET         ((uint32_t)(0x78))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions2 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2            ((uint32_t)(0x187C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_OFFSET     ((uint32_t)(0x7C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor2 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2                   ((uint32_t)(0x1880))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_OFFSET            ((uint32_t)(0x80))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTALPHA2_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTBLUE2_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTGREEN2_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTRED2_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR2_CONSTANTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty2 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2                   ((uint32_t)(0x1884))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_OFFSET            ((uint32_t)(0x84))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2_SHIFT   4U
/* Field Value: TILEMODE2__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE2__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE2__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2__TILE_PAD 0x2U
/* Field Value: TILEMODE2__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_TILEMODE2__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHASRCENABLE2_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHASRCENABLE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHACONSTENABLE2_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHACONSTENABLE2_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHAMASKENABLE2_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHAMASKENABLE2_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHATRANSENABLE2_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_ALPHATRANSENABLE2_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHASRCENABLE2_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHASRCENABLE2_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHACONSTENABLE2_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHACONSTENABLE2_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHAMASKENABLE2_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHAMASKENABLE2_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHATRANSENABLE2_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_RGBALPHATRANSENABLE2_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_PREMULCONSTRGB2_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_PREMULCONSTRGB2_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE2__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2__OFF 0U
/* Field Value: YUVCONVERSIONMODE2__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE2__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE2__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_GAMMAREMOVEENABLE2_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_GAMMAREMOVEENABLE2_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_CLIPWINDOWENABLE2_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_CLIPWINDOWENABLE2_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_SOURCEBUFFERENABLE2_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY2_SOURCEBUFFERENABLE2_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress3 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3                     ((uint32_t)(0x1888))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3_OFFSET              ((uint32_t)(0x88))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3_BASEADDRESS3_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS3_BASEADDRESS3_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes3 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3          ((uint32_t)(0x188C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_OFFSET   ((uint32_t)(0x8C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_STRIDE3_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_STRIDE3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension3 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3           ((uint32_t)(0x1890))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_OFFSET    ((uint32_t)(0x90))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_LINEWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_LINEWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_LINECOUNT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION3_LINECOUNT3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits3 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3              ((uint32_t)(0x1894))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_OFFSET       ((uint32_t)(0x94))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSRED3_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_COMPONENTBITSRED3_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_ITUFORMAT3_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS3_ITUFORMAT3_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift3 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3             ((uint32_t)(0x1898))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_OFFSET      ((uint32_t)(0x98))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset3 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3                     ((uint32_t)(0x189C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_OFFSET              ((uint32_t)(0x9C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_LAYERXOFFSET3_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_LAYERXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_LAYERYOFFSET3_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET3_LAYERYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset3 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3                ((uint32_t)(0x18A0))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_OFFSET         ((uint32_t)(0xA0))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions3 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3            ((uint32_t)(0x18A4))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_OFFSET     ((uint32_t)(0xA4))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor3 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3                   ((uint32_t)(0x18A8))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_OFFSET            ((uint32_t)(0xA8))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTALPHA3_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTBLUE3_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTGREEN3_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTRED3_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR3_CONSTANTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty3 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3                   ((uint32_t)(0x18AC))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_OFFSET            ((uint32_t)(0xAC))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3_SHIFT   4U
/* Field Value: TILEMODE3__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE3__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE3__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3__TILE_PAD 0x2U
/* Field Value: TILEMODE3__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_TILEMODE3__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHASRCENABLE3_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHASRCENABLE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHACONSTENABLE3_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHACONSTENABLE3_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHAMASKENABLE3_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHAMASKENABLE3_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHATRANSENABLE3_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_ALPHATRANSENABLE3_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHASRCENABLE3_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHASRCENABLE3_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHACONSTENABLE3_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHACONSTENABLE3_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHAMASKENABLE3_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHAMASKENABLE3_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHATRANSENABLE3_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_RGBALPHATRANSENABLE3_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_PREMULCONSTRGB3_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_PREMULCONSTRGB3_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE3__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3__OFF 0U
/* Field Value: YUVCONVERSIONMODE3__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE3__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE3__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_GAMMAREMOVEENABLE3_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_GAMMAREMOVEENABLE3_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_CLIPWINDOWENABLE3_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_CLIPWINDOWENABLE3_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_SOURCEBUFFERENABLE3_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY3_SOURCEBUFFERENABLE3_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress4 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4                     ((uint32_t)(0x18B0))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4_OFFSET              ((uint32_t)(0xB0))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4_BASEADDRESS4_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS4_BASEADDRESS4_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes4 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4          ((uint32_t)(0x18B4))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_OFFSET   ((uint32_t)(0xB4))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_STRIDE4_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_STRIDE4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension4 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4           ((uint32_t)(0x18B8))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_OFFSET    ((uint32_t)(0xB8))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_LINEWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_LINEWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_LINECOUNT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION4_LINECOUNT4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits4 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4              ((uint32_t)(0x18BC))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_OFFSET       ((uint32_t)(0xBC))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSRED4_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_COMPONENTBITSRED4_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_ITUFORMAT4_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS4_ITUFORMAT4_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift4 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4             ((uint32_t)(0x18C0))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_OFFSET      ((uint32_t)(0xC0))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset4 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4                     ((uint32_t)(0x18C4))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_OFFSET              ((uint32_t)(0xC4))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_LAYERXOFFSET4_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_LAYERXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_LAYERYOFFSET4_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET4_LAYERYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset4 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4                ((uint32_t)(0x18C8))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_OFFSET         ((uint32_t)(0xC8))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions4 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4            ((uint32_t)(0x18CC))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_OFFSET     ((uint32_t)(0xCC))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor4 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4                   ((uint32_t)(0x18D0))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_OFFSET            ((uint32_t)(0xD0))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTALPHA4_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTBLUE4_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTGREEN4_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTRED4_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR4_CONSTANTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty4 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4                   ((uint32_t)(0x18D4))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_OFFSET            ((uint32_t)(0xD4))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4_SHIFT   4U
/* Field Value: TILEMODE4__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE4__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE4__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4__TILE_PAD 0x2U
/* Field Value: TILEMODE4__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_TILEMODE4__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHASRCENABLE4_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHASRCENABLE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHACONSTENABLE4_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHACONSTENABLE4_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHAMASKENABLE4_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHAMASKENABLE4_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHATRANSENABLE4_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_ALPHATRANSENABLE4_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHASRCENABLE4_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHASRCENABLE4_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHACONSTENABLE4_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHACONSTENABLE4_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHAMASKENABLE4_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHAMASKENABLE4_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHATRANSENABLE4_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_RGBALPHATRANSENABLE4_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_PREMULCONSTRGB4_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_PREMULCONSTRGB4_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE4__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4__OFF 0U
/* Field Value: YUVCONVERSIONMODE4__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE4__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE4__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_GAMMAREMOVEENABLE4_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_GAMMAREMOVEENABLE4_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_CLIPWINDOWENABLE4_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_CLIPWINDOWENABLE4_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_SOURCEBUFFERENABLE4_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY4_SOURCEBUFFERENABLE4_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress5 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5                     ((uint32_t)(0x18D8))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5_OFFSET              ((uint32_t)(0xD8))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5_BASEADDRESS5_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS5_BASEADDRESS5_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes5 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5          ((uint32_t)(0x18DC))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_OFFSET   ((uint32_t)(0xDC))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_STRIDE5_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_STRIDE5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension5 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5           ((uint32_t)(0x18E0))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_OFFSET    ((uint32_t)(0xE0))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_LINEWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_LINEWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_LINECOUNT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION5_LINECOUNT5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits5 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5              ((uint32_t)(0x18E4))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_OFFSET       ((uint32_t)(0xE4))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSRED5_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_COMPONENTBITSRED5_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_ITUFORMAT5_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS5_ITUFORMAT5_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift5 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5             ((uint32_t)(0x18E8))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_OFFSET      ((uint32_t)(0xE8))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset5 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5                     ((uint32_t)(0x18EC))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_OFFSET              ((uint32_t)(0xEC))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_LAYERXOFFSET5_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_LAYERXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_LAYERYOFFSET5_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET5_LAYERYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset5 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5                ((uint32_t)(0x18F0))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_OFFSET         ((uint32_t)(0xF0))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions5 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5            ((uint32_t)(0x18F4))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_OFFSET     ((uint32_t)(0xF4))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor5 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5                   ((uint32_t)(0x18F8))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_OFFSET            ((uint32_t)(0xF8))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTALPHA5_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTBLUE5_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTGREEN5_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTRED5_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR5_CONSTANTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty5 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5                   ((uint32_t)(0x18FC))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_OFFSET            ((uint32_t)(0xFC))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5_SHIFT   4U
/* Field Value: TILEMODE5__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE5__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE5__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5__TILE_PAD 0x2U
/* Field Value: TILEMODE5__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_TILEMODE5__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHASRCENABLE5_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHASRCENABLE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHACONSTENABLE5_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHACONSTENABLE5_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHAMASKENABLE5_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHAMASKENABLE5_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHATRANSENABLE5_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_ALPHATRANSENABLE5_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHASRCENABLE5_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHASRCENABLE5_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHACONSTENABLE5_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHACONSTENABLE5_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHAMASKENABLE5_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHAMASKENABLE5_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHATRANSENABLE5_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_RGBALPHATRANSENABLE5_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_PREMULCONSTRGB5_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_PREMULCONSTRGB5_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE5__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5__OFF 0U
/* Field Value: YUVCONVERSIONMODE5__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE5__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE5__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_GAMMAREMOVEENABLE5_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_GAMMAREMOVEENABLE5_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_CLIPWINDOWENABLE5_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_CLIPWINDOWENABLE5_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_SOURCEBUFFERENABLE5_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY5_SOURCEBUFFERENABLE5_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress6 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6                     ((uint32_t)(0x1900))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6_OFFSET              ((uint32_t)(0x100))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6_BASEADDRESS6_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS6_BASEADDRESS6_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes6 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6          ((uint32_t)(0x1904))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_OFFSET   ((uint32_t)(0x104))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_STRIDE6_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_STRIDE6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension6 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6           ((uint32_t)(0x1908))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_OFFSET    ((uint32_t)(0x108))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_LINEWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_LINEWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_LINECOUNT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION6_LINECOUNT6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits6 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6              ((uint32_t)(0x190C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_OFFSET       ((uint32_t)(0x10C))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSRED6_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_COMPONENTBITSRED6_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_ITUFORMAT6_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS6_ITUFORMAT6_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift6 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6             ((uint32_t)(0x1910))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_OFFSET      ((uint32_t)(0x110))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset6 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6                     ((uint32_t)(0x1914))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_OFFSET              ((uint32_t)(0x114))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_LAYERXOFFSET6_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_LAYERXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_LAYERYOFFSET6_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET6_LAYERYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset6 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6                ((uint32_t)(0x1918))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_OFFSET         ((uint32_t)(0x118))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions6 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6            ((uint32_t)(0x191C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_OFFSET     ((uint32_t)(0x11C))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor6 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6                   ((uint32_t)(0x1920))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_OFFSET            ((uint32_t)(0x120))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTALPHA6_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTBLUE6_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTGREEN6_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTRED6_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR6_CONSTANTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty6 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6                   ((uint32_t)(0x1924))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_OFFSET            ((uint32_t)(0x124))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6_SHIFT   4U
/* Field Value: TILEMODE6__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE6__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE6__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6__TILE_PAD 0x2U
/* Field Value: TILEMODE6__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_TILEMODE6__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHASRCENABLE6_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHASRCENABLE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHACONSTENABLE6_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHACONSTENABLE6_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHAMASKENABLE6_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHAMASKENABLE6_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHATRANSENABLE6_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_ALPHATRANSENABLE6_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHASRCENABLE6_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHASRCENABLE6_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHACONSTENABLE6_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHACONSTENABLE6_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHAMASKENABLE6_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHAMASKENABLE6_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHATRANSENABLE6_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_RGBALPHATRANSENABLE6_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_PREMULCONSTRGB6_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_PREMULCONSTRGB6_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE6__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6__OFF 0U
/* Field Value: YUVCONVERSIONMODE6__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE6__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE6__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_GAMMAREMOVEENABLE6_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_GAMMAREMOVEENABLE6_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_CLIPWINDOWENABLE6_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_CLIPWINDOWENABLE6_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_SOURCEBUFFERENABLE6_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY6_SOURCEBUFFERENABLE6_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_BaseAddress7 */
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7                     ((uint32_t)(0x1928))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7_OFFSET              ((uint32_t)(0x128))
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7_BASEADDRESS7_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_BASEADDRESS7_BASEADDRESS7_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferAttributes7 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7          ((uint32_t)(0x192C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_OFFSET   ((uint32_t)(0x12C))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_STRIDE7_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_STRIDE7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_SourceBufferDimension7 */
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7           ((uint32_t)(0x1930))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_OFFSET    ((uint32_t)(0x130))
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_LINEWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_LINEWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_LINECOUNT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_SOURCEBUFFERDIMENSION7_LINECOUNT7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentBits7 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7              ((uint32_t)(0x1934))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_OFFSET       ((uint32_t)(0x134))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_MASK 0xFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_MASK 0xF00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSRED7_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_COMPONENTBITSRED7_SHIFT 24U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_ITUFORMAT7_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTBITS7_ITUFORMAT7_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_ColorComponentShift7 */
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7             ((uint32_t)(0x1938))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_OFFSET      ((uint32_t)(0x138))
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_MASK 0x1FU
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP9_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerOffset7 */
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7                     ((uint32_t)(0x193C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_OFFSET              ((uint32_t)(0x13C))
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_LAYERXOFFSET7_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_LAYERXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_LAYERYOFFSET7_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_LAYEROFFSET7_LAYERYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowOffset7 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7                ((uint32_t)(0x1940))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_OFFSET         ((uint32_t)(0x140))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ClipWindowDimensions7 */
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7            ((uint32_t)(0x1944))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_OFFSET     ((uint32_t)(0x144))
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp9_ConstantColor7 */
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7                   ((uint32_t)(0x1948))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_OFFSET            ((uint32_t)(0x148))
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTALPHA7_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTBLUE7_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTGREEN7_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTRED7_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_CONSTANTCOLOR7_CONSTANTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_LayerProperty7 */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7                   ((uint32_t)(0x194C))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_OFFSET            ((uint32_t)(0x14C))
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7_MASK    0x30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7_SHIFT   4U
/* Field Value: TILEMODE7__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE7__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE7__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7__TILE_PAD 0x2U
/* Field Value: TILEMODE7__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_TILEMODE7__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHASRCENABLE7_MASK 0x100U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHASRCENABLE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHACONSTENABLE7_MASK 0x200U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHACONSTENABLE7_SHIFT 9U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHAMASKENABLE7_MASK 0x400U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHAMASKENABLE7_SHIFT 10U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHATRANSENABLE7_MASK 0x800U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_ALPHATRANSENABLE7_SHIFT 11U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHASRCENABLE7_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHASRCENABLE7_SHIFT 12U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHACONSTENABLE7_MASK 0x2000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHACONSTENABLE7_SHIFT 13U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHAMASKENABLE7_MASK 0x4000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHAMASKENABLE7_SHIFT 14U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHATRANSENABLE7_MASK 0x8000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_RGBALPHATRANSENABLE7_SHIFT 15U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_PREMULCONSTRGB7_MASK 0x10000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_PREMULCONSTRGB7_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7_MASK 0x60000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE7__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7__OFF 0U
/* Field Value: YUVCONVERSIONMODE7__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE7__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE7__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU709 0x3U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_GAMMAREMOVEENABLE7_MASK 0x100000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_GAMMAREMOVEENABLE7_SHIFT 20U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_CLIPWINDOWENABLE7_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_CLIPWINDOWENABLE7_SHIFT 30U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_SOURCEBUFFERENABLE7_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP9_LAYERPROPERTY7_SOURCEBUFFERENABLE7_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_FrameDimensions */
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS                  ((uint32_t)(0x1950))
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_OFFSET           ((uint32_t)(0x150))
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_RESET_VALUE      0xEF013FU
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_FRAMEWIDTH_MASK  0x3FFFU
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_EMPTYFRAME_MASK  0x80000000U
#define IMXDPUV1_FETCHWARP9_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp9_FrameResampling */
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING                  ((uint32_t)(0x1954))
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_OFFSET           ((uint32_t)(0x154))
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_RESET_VALUE      0x104000U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_STARTX_MASK      0x3FU
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_STARTX_SHIFT     0U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_STARTY_MASK      0xFC0U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_STARTY_SHIFT     6U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_DELTAX_MASK      0x3F000U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_DELTAX_SHIFT     12U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_DELTAY_MASK      0xFC0000U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_DELTAY_SHIFT     18U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHWARP9_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_WarpControl */
#define IMXDPUV1_FETCHWARP9_WARPCONTROL                      ((uint32_t)(0x1958))
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_OFFSET               ((uint32_t)(0x158))
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_RESET_VALUE          0x20U
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPBITSPERPIXEL_MASK 0x3FU
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPBITSPERPIXEL_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPCOORDINATEMODE_MASK 0x300U
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPCOORDINATEMODE_SHIFT 8U
/* Field Value: WARPCOORDINATEMODE__PNT, x and y (sample points).  */
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPCOORDINATEMODE__PNT 0U
/* Field Value: WARPCOORDINATEMODE__D_PNT, dx and dy (vectors between adjacent
 * sample points).  */
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPCOORDINATEMODE__D_PNT 0x1U
/* Field Value: WARPCOORDINATEMODE__DD_PNT, ddx and ddy (deltas between adjacent
 * vectors).  */
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPCOORDINATEMODE__DD_PNT 0x2U
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPSYMMETRICOFFSET_MASK 0x1000U
#define IMXDPUV1_FETCHWARP9_WARPCONTROL_WARPSYMMETRICOFFSET_SHIFT 12U

/* Register: IMXDPUV1_fetchwarp9_ArbStartX */
#define IMXDPUV1_FETCHWARP9_ARBSTARTX                        ((uint32_t)(0x195C))
#define IMXDPUV1_FETCHWARP9_ARBSTARTX_OFFSET                 ((uint32_t)(0x15C))
#define IMXDPUV1_FETCHWARP9_ARBSTARTX_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP9_ARBSTARTX_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_ARBSTARTX_ARBSTARTX_MASK         0x1FFFFFU
#define IMXDPUV1_FETCHWARP9_ARBSTARTX_ARBSTARTX_SHIFT        0U

/* Register: IMXDPUV1_fetchwarp9_ArbStartY */
#define IMXDPUV1_FETCHWARP9_ARBSTARTY                        ((uint32_t)(0x1960))
#define IMXDPUV1_FETCHWARP9_ARBSTARTY_OFFSET                 ((uint32_t)(0x160))
#define IMXDPUV1_FETCHWARP9_ARBSTARTY_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP9_ARBSTARTY_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_ARBSTARTY_ARBSTARTY_MASK         0x1FFFFFU
#define IMXDPUV1_FETCHWARP9_ARBSTARTY_ARBSTARTY_SHIFT        0U

/* Register: IMXDPUV1_fetchwarp9_ArbDelta */
#define IMXDPUV1_FETCHWARP9_ARBDELTA                         ((uint32_t)(0x1964))
#define IMXDPUV1_FETCHWARP9_ARBDELTA_OFFSET                  ((uint32_t)(0x164))
#define IMXDPUV1_FETCHWARP9_ARBDELTA_RESET_VALUE             0U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAXX_MASK         0xFFU
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAXX_SHIFT        0U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAXY_MASK         0xFF00U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAXY_SHIFT        8U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAYX_MASK         0xFF0000U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAYX_SHIFT        16U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAYY_MASK         0xFF000000U
#define IMXDPUV1_FETCHWARP9_ARBDELTA_ARBDELTAYY_SHIFT        24U

/* Register: IMXDPUV1_fetchwarp9_FIRPositions */
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS                     ((uint32_t)(0x1968))
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_OFFSET              ((uint32_t)(0x168))
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_RESET_VALUE         0xA965U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR0POSITION_MASK   0xFU
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR0POSITION_SHIFT  0U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR1POSITION_MASK   0xF0U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR1POSITION_SHIFT  4U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR2POSITION_MASK   0xF00U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR2POSITION_SHIFT  8U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR3POSITION_MASK   0xF000U
#define IMXDPUV1_FETCHWARP9_FIRPOSITIONS_FIR3POSITION_SHIFT  12U

/* Register: IMXDPUV1_fetchwarp9_FIRCoefficients */
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS                  ((uint32_t)(0x196C))
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_OFFSET           ((uint32_t)(0x16C))
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_RESET_VALUE      0x20U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR0COEFFICIENT_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR0COEFFICIENT_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR1COEFFICIENT_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR1COEFFICIENT_SHIFT 8U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR2COEFFICIENT_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR2COEFFICIENT_SHIFT 16U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR3COEFFICIENT_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP9_FIRCOEFFICIENTS_FIR3COEFFICIENT_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp9_Control */
#define IMXDPUV1_FETCHWARP9_CONTROL                          ((uint32_t)(0x1970))
#define IMXDPUV1_FETCHWARP9_CONTROL_OFFSET                   ((uint32_t)(0x170))
#define IMXDPUV1_FETCHWARP9_CONTROL_RESET_VALUE              0x10000U
#define IMXDPUV1_FETCHWARP9_CONTROL_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE_MASK          0x7U
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE_SHIFT         0U
/* Field Value: RASTERMODE__NORMAL, First sample at StartX/Y relative to origin.
 * Hor/ver increments using DeltaX/Y and DeltaSwap setup.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__NORMAL       0U
/* Field Value: RASTERMODE__DECODE, [FetchDecode/FetchDecodeL only] Source
 * buffer is an encoded bit stream. First sample at origin (0,0). Hor/ver
 * increments = (1,0)/(0,1).  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__DECODE       0x1U
/* Field Value: RASTERMODE__ARBITRARY, [FetchPersp/Warp/Rot/RotL only] Arbitrary
 * warping (filter is active). Coordinates are read from frame input
 * port. InputSelect must be set to COORDINATE. ArbStartX/Y and ArbDeltaXX/XY/YX/YY
 * must be setup.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__ARBITRARY    0x2U
/* Field Value: RASTERMODE__PERSPECTIVE, [FetchPersp only] Affine/Perspective
 * warping (filter is active). First sample at PerspStartX/Y/W. Hor/ver
 * increments using PerspDeltaXX/XY/YX/YY/WX/WY. Homogeneous coordinates.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__PERSPECTIVE  0x3U
/* Field Value: RASTERMODE__YUV422, [FetchPersp/Decode only] Source buffer
 * is packed YUV 4:2:2. First sample at origin (0,0). Hor/ver increments
 * = (1,0)/(0,1). All corellated window widths and horizontal offsets must
 * be even.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__YUV422       0x4U
/* Field Value: RASTERMODE__AFFINE, [FetchRot/RotL only] Affine warping (filter
 * is active). First sample at AffineStartX/Y. Hor/ver increments using
 * AffineDeltaXX/XY/YX/YY. Cartesian coordinates.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_RASTERMODE__AFFINE       0x5U
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT_MASK         0x18U
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT_SHIFT        3U
/* Field Value: INPUTSELECT__INACTIVE, Not used.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT__INACTIVE    0U
/* Field Value: INPUTSELECT__COMPPACK, Used for component packing (e.g. UV
 * or source alpha buffer).  */
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT__COMPPACK    0x1U
/* Field Value: INPUTSELECT__ALPHAMASK, Used for RGB and alpha pre-multiply
 * stage (mask alpha buffer).  */
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT__ALPHAMASK   0x2U
/* Field Value: INPUTSELECT__COORDINATE, Used for arbitrary warping (coordinate
 * buffer).  */
#define IMXDPUV1_FETCHWARP9_CONTROL_INPUTSELECT__COORDINATE  0x3U
#define IMXDPUV1_FETCHWARP9_CONTROL_RAWPIXEL_MASK            0x80U
#define IMXDPUV1_FETCHWARP9_CONTROL_RAWPIXEL_SHIFT           7U
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPCOLOR_MASK           0x10000U
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPCOLOR_SHIFT          16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPCOLOR__NULL          0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPCOLOR__LAYER         0x1U
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPLAYER_MASK           0xE0000U
#define IMXDPUV1_FETCHWARP9_CONTROL_CLIPLAYER_SHIFT          17U
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE_MASK          0x700000U
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE_SHIFT         20U
/* Field Value: FILTERMODE__NEAREST, Chooses pixel closest to sample point  */
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE__NEAREST      0U
/* Field Value: FILTERMODE__BILINEAR, Calculates result from 4 pixels closest
 * to sample point  */
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE__BILINEAR     0x1U
/* Field Value: FILTERMODE__FIR2, FIR mode with 2 programmable pixel positions
 * and coefficients  */
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE__FIR2         0x2U
/* Field Value: FILTERMODE__FIR4, FIR mode with 4 programmable pixel positions
 * and coefficients  */
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE__FIR4         0x3U
/* Field Value: FILTERMODE__HOR_LINEAR, Calculates result from 2 pixels closest
 * to the sample point and on the same line  */
#define IMXDPUV1_FETCHWARP9_CONTROL_FILTERMODE__HOR_LINEAR   0x4U

/* Register: IMXDPUV1_fetchwarp9_TriggerEnable */
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE                    ((uint32_t)(0x1974))
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE_OFFSET             ((uint32_t)(0x174))
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE_RESET_VALUE        0U
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE_SHDLDREQ_MASK      0xFFU
#define IMXDPUV1_FETCHWARP9_TRIGGERENABLE_SHDLDREQ_SHIFT     0U

/* Register: IMXDPUV1_fetchwarp9_ControlTrigger */
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER                   ((uint32_t)(0x1978))
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER_OFFSET            ((uint32_t)(0x178))
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER_RESET_MASK        0xFFFFFFFEU
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER_SHDTOKGEN_MASK    0x1U
#define IMXDPUV1_FETCHWARP9_CONTROLTRIGGER_SHDTOKGEN_SHIFT   0U

/* Register: IMXDPUV1_fetchwarp9_Start */
#define IMXDPUV1_FETCHWARP9_START                            ((uint32_t)(0x197C))
#define IMXDPUV1_FETCHWARP9_START_OFFSET                     ((uint32_t)(0x17C))
#define IMXDPUV1_FETCHWARP9_START_RESET_VALUE                0U
#define IMXDPUV1_FETCHWARP9_START_RESET_MASK                 0xFFFFFFFEU
#define IMXDPUV1_FETCHWARP9_START_START_MASK                 0x1U
#define IMXDPUV1_FETCHWARP9_START_START_SHIFT                0U

/* Register: IMXDPUV1_fetchwarp9_FetchType */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE                        ((uint32_t)(0x1980))
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_OFFSET                 ((uint32_t)(0x180))
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_RESET_MASK             0xFFFFFFF0U
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE_MASK         0xFU
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE_SHIFT        0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__DECODE      0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__LAYER       0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__WARP        0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__ECO         0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__PERSP       0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__ROT         0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__DECODEL     0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__LAYERL      0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHWARP9_FETCHTYPE_FETCHTYPE__ROTL        0x8U

/* Register: IMXDPUV1_fetchwarp9_BurstBufferProperties */
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES            ((uint32_t)(0x1984))
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_OFFSET     ((uint32_t)(0x184))
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetchwarp9_Status */
#define IMXDPUV1_FETCHWARP9_STATUS                           ((uint32_t)(0x1988))
#define IMXDPUV1_FETCHWARP9_STATUS_OFFSET                    ((uint32_t)(0x188))
#define IMXDPUV1_FETCHWARP9_STATUS_RESET_VALUE               0U
#define IMXDPUV1_FETCHWARP9_STATUS_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP9_STATUS_WRITETIMEOUT_MASK         0x1U
#define IMXDPUV1_FETCHWARP9_STATUS_WRITETIMEOUT_SHIFT        0U
#define IMXDPUV1_FETCHWARP9_STATUS_READTIMEOUT_MASK          0x10U
#define IMXDPUV1_FETCHWARP9_STATUS_READTIMEOUT_SHIFT         4U

/* Register: IMXDPUV1_fetchwarp9_HiddenStatus */
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS                     ((uint32_t)(0x198C))
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_OFFSET              ((uint32_t)(0x18C))
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_RESET_MASK          0xFFFF008EU
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSBUSY_MASK     0x1U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSBUSY_SHIFT    0U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSREQUEST_MASK  0x20U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_SHADOWSTATUS_MASK   0xFF00U
#define IMXDPUV1_FETCHWARP9_HIDDENSTATUS_SHADOWSTATUS_SHIFT  8U

/* Register: IMXDPUV1_fetcheco9_LockUnlock */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK                        ((uint32_t)(0x1C00))
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_OFFSET                 ((uint32_t)(0))
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_RESET_MASK             0U
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK_SHIFT       0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY   0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHECO9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetcheco9_LockStatus */
#define IMXDPUV1_FETCHECO9_LOCKSTATUS                        ((uint32_t)(0x1C04))
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_OFFSET                 ((uint32_t)(0x4))
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_LOCKSTATUS_MASK        0x1U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_LOCKSTATUS_SHIFT       0U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_PRIVILEGESTATUS_MASK   0x10U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT  4U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_FREEZESTATUS_MASK      0x100U
#define IMXDPUV1_FETCHECO9_LOCKSTATUS_FREEZESTATUS_SHIFT     8U

/* Register: IMXDPUV1_fetcheco9_StaticControl */
#define IMXDPUV1_FETCHECO9_STATICCONTROL                     ((uint32_t)(0x1C08))
#define IMXDPUV1_FETCHECO9_STATICCONTROL_OFFSET              ((uint32_t)(0x8))
#define IMXDPUV1_FETCHECO9_STATICCONTROL_RESET_VALUE         0U
#define IMXDPUV1_FETCHECO9_STATICCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_STATICCONTROL_SHDEN_MASK          0x1U
#define IMXDPUV1_FETCHECO9_STATICCONTROL_SHDEN_SHIFT         0U
#define IMXDPUV1_FETCHECO9_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO9_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_fetcheco9_BurstBufferManagement */
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT             ((uint32_t)(0x1C0C))
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_OFFSET      ((uint32_t)(0xC))
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHECO9_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetcheco9_BaseAddress0 */
#define IMXDPUV1_FETCHECO9_BASEADDRESS0                      ((uint32_t)(0x1C10))
#define IMXDPUV1_FETCHECO9_BASEADDRESS0_OFFSET               ((uint32_t)(0x10))
#define IMXDPUV1_FETCHECO9_BASEADDRESS0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO9_BASEADDRESS0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_BASEADDRESS0_BASEADDRESS0_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_BASEADDRESS0_BASEADDRESS0_SHIFT   0U

/* Register: IMXDPUV1_fetcheco9_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0           ((uint32_t)(0x1C14))
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_OFFSET    ((uint32_t)(0x14))
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco9_SourceBufferDimension0 */
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0            ((uint32_t)(0x1C18))
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_OFFSET     ((uint32_t)(0x18))
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO9_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco9_ColorComponentBits0 */
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0               ((uint32_t)(0x1C1C))
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_OFFSET        ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_RESET_VALUE   0x8080808U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco9_ColorComponentShift0 */
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0              ((uint32_t)(0x1C20))
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_OFFSET       ((uint32_t)(0x20))
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_RESET_VALUE  0x18100800U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHECO9_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco9_LayerOffset0 */
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0                      ((uint32_t)(0x1C24))
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_OFFSET               ((uint32_t)(0x24))
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_LAYERXOFFSET0_MASK   0x7FFFU
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_LAYERXOFFSET0_SHIFT  0U
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_LAYERYOFFSET0_MASK   0x7FFF0000U
#define IMXDPUV1_FETCHECO9_LAYEROFFSET0_LAYERYOFFSET0_SHIFT  16U

/* Register: IMXDPUV1_fetcheco9_ClipWindowOffset0 */
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0                 ((uint32_t)(0x1C28))
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_OFFSET          ((uint32_t)(0x28))
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_RESET_VALUE     0U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco9_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0             ((uint32_t)(0x1C2C))
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_OFFSET      ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO9_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco9_ConstantColor0 */
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0                    ((uint32_t)(0x1C30))
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_OFFSET             ((uint32_t)(0x30))
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTRED0_MASK  0xFF000000U
#define IMXDPUV1_FETCHECO9_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco9_LayerProperty0 */
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0                    ((uint32_t)(0x1C34))
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_OFFSET             ((uint32_t)(0x34))
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_RESET_VALUE        0x80000000U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0_MASK     0x30U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0_SHIFT    4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO9_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco9_FrameDimensions */
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS                   ((uint32_t)(0x1C38))
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_OFFSET            ((uint32_t)(0x38))
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_RESET_VALUE       0xEF013FU
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_FRAMEWIDTH_MASK   0x3FFFU
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT  0U
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK  0x3FFF0000U
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_EMPTYFRAME_MASK   0x80000000U
#define IMXDPUV1_FETCHECO9_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT  31U

/* Register: IMXDPUV1_fetcheco9_FrameResampling */
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING                   ((uint32_t)(0x1C3C))
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_OFFSET            ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_RESET_VALUE       0x104000U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_STARTX_MASK       0x3FU
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_STARTX_SHIFT      0U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_STARTY_MASK       0xFC0U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_STARTY_SHIFT      6U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_DELTAX_MASK       0x3F000U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_DELTAX_SHIFT      12U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_DELTAY_MASK       0xFC0000U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_DELTAY_SHIFT      18U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHECO9_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetcheco9_Control */
#define IMXDPUV1_FETCHECO9_CONTROL                           ((uint32_t)(0x1C40))
#define IMXDPUV1_FETCHECO9_CONTROL_OFFSET                    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHECO9_CONTROL_RESET_VALUE               0x10000U
#define IMXDPUV1_FETCHECO9_CONTROL_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHECO9_CONTROL_RAWPIXEL_MASK             0x80U
#define IMXDPUV1_FETCHECO9_CONTROL_RAWPIXEL_SHIFT            7U
#define IMXDPUV1_FETCHECO9_CONTROL_CLIPCOLOR_MASK            0x10000U
#define IMXDPUV1_FETCHECO9_CONTROL_CLIPCOLOR_SHIFT           16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHECO9_CONTROL_CLIPCOLOR__NULL           0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHECO9_CONTROL_CLIPCOLOR__LAYER          0x1U

/* Register: IMXDPUV1_fetcheco9_ControlTrigger */
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER                    ((uint32_t)(0x1C44))
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER_OFFSET             ((uint32_t)(0x44))
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER_RESET_MASK         0xFFFFFFFEU
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER_SHDTOKGEN_MASK     0x1U
#define IMXDPUV1_FETCHECO9_CONTROLTRIGGER_SHDTOKGEN_SHIFT    0U

/* Register: IMXDPUV1_fetcheco9_Start */
#define IMXDPUV1_FETCHECO9_START                             ((uint32_t)(0x1C48))
#define IMXDPUV1_FETCHECO9_START_OFFSET                      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHECO9_START_RESET_VALUE                 0U
#define IMXDPUV1_FETCHECO9_START_RESET_MASK                  0xFFFFFFFEU
#define IMXDPUV1_FETCHECO9_START_START_MASK                  0x1U
#define IMXDPUV1_FETCHECO9_START_START_SHIFT                 0U

/* Register: IMXDPUV1_fetcheco9_FetchType */
#define IMXDPUV1_FETCHECO9_FETCHTYPE                         ((uint32_t)(0x1C4C))
#define IMXDPUV1_FETCHECO9_FETCHTYPE_OFFSET                  ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHECO9_FETCHTYPE_RESET_VALUE             0U
#define IMXDPUV1_FETCHECO9_FETCHTYPE_RESET_MASK              0xFFFFFFF0U
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE_MASK          0xFU
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE_SHIFT         0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__DECODE       0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__LAYER        0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__WARP         0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__ECO          0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__PERSP        0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__ROT          0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__DECODEL      0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__LAYERL       0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO9_FETCHTYPE_FETCHTYPE__ROTL         0x8U

/* Register: IMXDPUV1_fetcheco9_BurstBufferProperties */
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES             ((uint32_t)(0x1C50))
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_RESET_MASK  0xFFFFE000U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHECO9_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetcheco9_HiddenStatus */
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS                      ((uint32_t)(0x1C54))
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_OFFSET               ((uint32_t)(0x54))
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_RESET_MASK           0xFFFF008EU
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSBUSY_MASK      0x1U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSBUSY_SHIFT     0U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSREQUEST_MASK   0x20U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSREQUEST_SHIFT  5U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSCOMPLETE_MASK  0x40U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_SHADOWSTATUS_MASK    0xFF00U
#define IMXDPUV1_FETCHECO9_HIDDENSTATUS_SHADOWSTATUS_SHIFT   8U

/* Register: IMXDPUV1_rop9_LockUnlock */
#define IMXDPUV1_ROP9_LOCKUNLOCK                             ((uint32_t)(0x2000))
#define IMXDPUV1_ROP9_LOCKUNLOCK_OFFSET                      ((uint32_t)(0))
#define IMXDPUV1_ROP9_LOCKUNLOCK_RESET_VALUE                 0U
#define IMXDPUV1_ROP9_LOCKUNLOCK_RESET_MASK                  0U
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK_MASK             0xFFFFFFFFU
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK_SHIFT            0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY        0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY      0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY   0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_ROP9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY      0xFBE8B1E6U

/* Register: IMXDPUV1_rop9_LockStatus */
#define IMXDPUV1_ROP9_LOCKSTATUS                             ((uint32_t)(0x2004))
#define IMXDPUV1_ROP9_LOCKSTATUS_OFFSET                      ((uint32_t)(0x4))
#define IMXDPUV1_ROP9_LOCKSTATUS_RESET_VALUE                 0U
#define IMXDPUV1_ROP9_LOCKSTATUS_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_ROP9_LOCKSTATUS_LOCKSTATUS_MASK             0x1U
#define IMXDPUV1_ROP9_LOCKSTATUS_LOCKSTATUS_SHIFT            0U
#define IMXDPUV1_ROP9_LOCKSTATUS_PRIVILEGESTATUS_MASK        0x10U
#define IMXDPUV1_ROP9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT       4U
#define IMXDPUV1_ROP9_LOCKSTATUS_FREEZESTATUS_MASK           0x100U
#define IMXDPUV1_ROP9_LOCKSTATUS_FREEZESTATUS_SHIFT          8U

/* Register: IMXDPUV1_rop9_StaticControl */
#define IMXDPUV1_ROP9_STATICCONTROL                          ((uint32_t)(0x2008))
#define IMXDPUV1_ROP9_STATICCONTROL_OFFSET                   ((uint32_t)(0x8))
#define IMXDPUV1_ROP9_STATICCONTROL_RESET_VALUE              0U
#define IMXDPUV1_ROP9_STATICCONTROL_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_ROP9_STATICCONTROL_SHDEN_MASK               0x1U
#define IMXDPUV1_ROP9_STATICCONTROL_SHDEN_SHIFT              0U

/* Register: IMXDPUV1_rop9_Control */
#define IMXDPUV1_ROP9_CONTROL                                ((uint32_t)(0x200C))
#define IMXDPUV1_ROP9_CONTROL_OFFSET                         ((uint32_t)(0xC))
#define IMXDPUV1_ROP9_CONTROL_RESET_VALUE                    0U
#define IMXDPUV1_ROP9_CONTROL_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_ROP9_CONTROL_MODE_MASK                      0x1U
#define IMXDPUV1_ROP9_CONTROL_MODE_SHIFT                     0U
/* Field Value: MODE__NEUTRAL, Neutral mode  */
#define IMXDPUV1_ROP9_CONTROL_MODE__NEUTRAL                  0U
/* Field Value: MODE__OPERATION, Normal Operation  */
#define IMXDPUV1_ROP9_CONTROL_MODE__OPERATION                0x1U
#define IMXDPUV1_ROP9_CONTROL_ALPHAMODE_MASK                 0x10U
#define IMXDPUV1_ROP9_CONTROL_ALPHAMODE_SHIFT                4U
/* Field Value: ALPHAMODE__ROP, Normal raster operation mode, using the operation
 * index  */
#define IMXDPUV1_ROP9_CONTROL_ALPHAMODE__ROP                 0U
/* Field Value: ALPHAMODE__ADD, Add mode, adds this component from all enabled
 * inputs, clamps to 1  */
#define IMXDPUV1_ROP9_CONTROL_ALPHAMODE__ADD                 0x1U
#define IMXDPUV1_ROP9_CONTROL_BLUEMODE_MASK                  0x20U
#define IMXDPUV1_ROP9_CONTROL_BLUEMODE_SHIFT                 5U
/* Field Value: BLUEMODE__ROP, Normal raster operation mode, using the operation
 * index  */
#define IMXDPUV1_ROP9_CONTROL_BLUEMODE__ROP                  0U
/* Field Value: BLUEMODE__ADD, Add mode, adds this component from all enabled
 * inputs, clamps to 1  */
#define IMXDPUV1_ROP9_CONTROL_BLUEMODE__ADD                  0x1U
#define IMXDPUV1_ROP9_CONTROL_GREENMODE_MASK                 0x40U
#define IMXDPUV1_ROP9_CONTROL_GREENMODE_SHIFT                6U
/* Field Value: GREENMODE__ROP, Normal raster operation mode, using the operation
 * index  */
#define IMXDPUV1_ROP9_CONTROL_GREENMODE__ROP                 0U
/* Field Value: GREENMODE__ADD, Add mode, adds this component from all enabled
 * inputs, clamps to 1  */
#define IMXDPUV1_ROP9_CONTROL_GREENMODE__ADD                 0x1U
#define IMXDPUV1_ROP9_CONTROL_REDMODE_MASK                   0x80U
#define IMXDPUV1_ROP9_CONTROL_REDMODE_SHIFT                  7U
/* Field Value: REDMODE__ROP, Normal raster operation mode, using the operation
 * index  */
#define IMXDPUV1_ROP9_CONTROL_REDMODE__ROP                   0U
/* Field Value: REDMODE__ADD, Add mode, adds this component from all enabled
 * inputs, clamps to 1  */
#define IMXDPUV1_ROP9_CONTROL_REDMODE__ADD                   0x1U
#define IMXDPUV1_ROP9_CONTROL_PRIMDIV2_MASK                  0x100U
#define IMXDPUV1_ROP9_CONTROL_PRIMDIV2_SHIFT                 8U
/* Field Value: PRIMDIV2__BYPASS, No change to input  */
#define IMXDPUV1_ROP9_CONTROL_PRIMDIV2__BYPASS               0U
/* Field Value: PRIMDIV2__DIVIDEBY2, Input is divided by two/shift to the
 * right by one  */
#define IMXDPUV1_ROP9_CONTROL_PRIMDIV2__DIVIDEBY2            0x1U
#define IMXDPUV1_ROP9_CONTROL_SECDIV2_MASK                   0x200U
#define IMXDPUV1_ROP9_CONTROL_SECDIV2_SHIFT                  9U
/* Field Value: SECDIV2__BYPASS, No change to input  */
#define IMXDPUV1_ROP9_CONTROL_SECDIV2__BYPASS                0U
/* Field Value: SECDIV2__DIVIDEBY2, Input is divided by two/shift to the right
 * by one  */
#define IMXDPUV1_ROP9_CONTROL_SECDIV2__DIVIDEBY2             0x1U
#define IMXDPUV1_ROP9_CONTROL_TERTDIV2_MASK                  0x400U
#define IMXDPUV1_ROP9_CONTROL_TERTDIV2_SHIFT                 10U
/* Field Value: TERTDIV2__BYPASS, No change to input  */
#define IMXDPUV1_ROP9_CONTROL_TERTDIV2__BYPASS               0U
/* Field Value: TERTDIV2__DIVIDEBY2, Input is divided by two/shift to the
 * right by one  */
#define IMXDPUV1_ROP9_CONTROL_TERTDIV2__DIVIDEBY2            0x1U

/* Register: IMXDPUV1_rop9_RasterOperationIndices */
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES                 ((uint32_t)(0x2010))
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OFFSET          ((uint32_t)(0x10))
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_RESET_VALUE     0U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXALPHA_MASK 0xFFU
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXALPHA_SHIFT 0U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXBLUE_MASK 0xFF00U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXBLUE_SHIFT 8U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXGREEN_MASK 0xFF0000U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXGREEN_SHIFT 16U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXRED_MASK 0xFF000000U
#define IMXDPUV1_ROP9_RASTEROPERATIONINDICES_OPINDEXRED_SHIFT 24U

/* Register: IMXDPUV1_rop9_PrimControlWord */
#define IMXDPUV1_ROP9_PRIMCONTROLWORD                        ((uint32_t)(0x2014))
#define IMXDPUV1_ROP9_PRIMCONTROLWORD_OFFSET                 ((uint32_t)(0x14))
#define IMXDPUV1_ROP9_PRIMCONTROLWORD_RESET_VALUE            0U
#define IMXDPUV1_ROP9_PRIMCONTROLWORD_RESET_MASK             0U
#define IMXDPUV1_ROP9_PRIMCONTROLWORD_P_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_ROP9_PRIMCONTROLWORD_P_VAL_SHIFT            0U

/* Register: IMXDPUV1_rop9_SecControlWord */
#define IMXDPUV1_ROP9_SECCONTROLWORD                         ((uint32_t)(0x2018))
#define IMXDPUV1_ROP9_SECCONTROLWORD_OFFSET                  ((uint32_t)(0x18))
#define IMXDPUV1_ROP9_SECCONTROLWORD_RESET_VALUE             0U
#define IMXDPUV1_ROP9_SECCONTROLWORD_RESET_MASK              0U
#define IMXDPUV1_ROP9_SECCONTROLWORD_S_VAL_MASK              0xFFFFFFFFU
#define IMXDPUV1_ROP9_SECCONTROLWORD_S_VAL_SHIFT             0U

/* Register: IMXDPUV1_rop9_TertControlWord */
#define IMXDPUV1_ROP9_TERTCONTROLWORD                        ((uint32_t)(0x201C))
#define IMXDPUV1_ROP9_TERTCONTROLWORD_OFFSET                 ((uint32_t)(0x1C))
#define IMXDPUV1_ROP9_TERTCONTROLWORD_RESET_VALUE            0U
#define IMXDPUV1_ROP9_TERTCONTROLWORD_RESET_MASK             0U
#define IMXDPUV1_ROP9_TERTCONTROLWORD_T_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_ROP9_TERTCONTROLWORD_T_VAL_SHIFT            0U

/* Register: IMXDPUV1_clut9_LockUnlock */
#define IMXDPUV1_CLUT9_LOCKUNLOCK                            ((uint32_t)(0x2400))
#define IMXDPUV1_CLUT9_LOCKUNLOCK_OFFSET                     ((uint32_t)(0))
#define IMXDPUV1_CLUT9_LOCKUNLOCK_RESET_VALUE                0U
#define IMXDPUV1_CLUT9_LOCKUNLOCK_RESET_MASK                 0U
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK_MASK            0xFFFFFFFFU
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK_SHIFT           0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY       0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY     0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY  0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CLUT9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY     0xFBE8B1E6U

/* Register: IMXDPUV1_clut9_LockStatus */
#define IMXDPUV1_CLUT9_LOCKSTATUS                            ((uint32_t)(0x2404))
#define IMXDPUV1_CLUT9_LOCKSTATUS_OFFSET                     ((uint32_t)(0x4))
#define IMXDPUV1_CLUT9_LOCKSTATUS_RESET_VALUE                0U
#define IMXDPUV1_CLUT9_LOCKSTATUS_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_CLUT9_LOCKSTATUS_LOCKSTATUS_MASK            0x1U
#define IMXDPUV1_CLUT9_LOCKSTATUS_LOCKSTATUS_SHIFT           0U
#define IMXDPUV1_CLUT9_LOCKSTATUS_PRIVILEGESTATUS_MASK       0x10U
#define IMXDPUV1_CLUT9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT      4U
#define IMXDPUV1_CLUT9_LOCKSTATUS_FREEZESTATUS_MASK          0x100U
#define IMXDPUV1_CLUT9_LOCKSTATUS_FREEZESTATUS_SHIFT         8U

/* Register: IMXDPUV1_clut9_StaticControl */
#define IMXDPUV1_CLUT9_STATICCONTROL                         ((uint32_t)(0x2408))
#define IMXDPUV1_CLUT9_STATICCONTROL_OFFSET                  ((uint32_t)(0x8))
#define IMXDPUV1_CLUT9_STATICCONTROL_RESET_VALUE             0U
#define IMXDPUV1_CLUT9_STATICCONTROL_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_CLUT9_STATICCONTROL_SHDEN_MASK              0x1U
#define IMXDPUV1_CLUT9_STATICCONTROL_SHDEN_SHIFT             0U

/* Register: IMXDPUV1_clut9_UnshadowedControl */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL                     ((uint32_t)(0x240C))
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_OFFSET              ((uint32_t)(0xC))
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_RESET_VALUE         0U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_B_EN_MASK           0x1U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_B_EN_SHIFT          0U
/* Field Value: B_EN__DISABLE, disable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_B_EN__DISABLE       0U
/* Field Value: B_EN__ENABLE, enable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_B_EN__ENABLE        0x1U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_G_EN_MASK           0x2U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_G_EN_SHIFT          1U
/* Field Value: G_EN__DISABLE, disable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_G_EN__DISABLE       0U
/* Field Value: G_EN__ENABLE, enable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_G_EN__ENABLE        0x1U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_R_EN_MASK           0x4U
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_R_EN_SHIFT          2U
/* Field Value: R_EN__DISABLE, disable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_R_EN__DISABLE       0U
/* Field Value: R_EN__ENABLE, enable  */
#define IMXDPUV1_CLUT9_UNSHADOWEDCONTROL_R_EN__ENABLE        0x1U

/* Register: IMXDPUV1_clut9_Control */
#define IMXDPUV1_CLUT9_CONTROL                               ((uint32_t)(0x2410))
#define IMXDPUV1_CLUT9_CONTROL_OFFSET                        ((uint32_t)(0x10))
#define IMXDPUV1_CLUT9_CONTROL_RESET_VALUE                   0x800U
#define IMXDPUV1_CLUT9_CONTROL_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_CLUT9_CONTROL_MODE_MASK                     0x3U
#define IMXDPUV1_CLUT9_CONTROL_MODE_SHIFT                    0U
/* Field Value: MODE__NEUTRAL, module in neutral mode, input data is bypassed
 * to the output  */
#define IMXDPUV1_CLUT9_CONTROL_MODE__NEUTRAL                 0U
/* Field Value: MODE__LUT, module in color lookup mode (LUT holds a 10bit
 * color value for CLut derivate and 8bit color value for CLutL derivate
 * for each input color)  */
#define IMXDPUV1_CLUT9_CONTROL_MODE__LUT                     0x1U
/* Field Value: MODE__INDEX_10BIT, module in 10bit color index table mode
 * (LUT holds a 3x10bit color value for derivate CLut and 3x8bit color value
 * for CLUTL derivate, indexed with the red input color)  */
#define IMXDPUV1_CLUT9_CONTROL_MODE__INDEX_10BIT             0x2U
/* Field Value: MODE__INDEX_RGBA, module in RGBA color index table mode (LUT
 * holds a 3x8bit color value and a 6bit alpha value for CLut derivate
 * and 3x6bit color value and 6bit alpha value for CLutL derivate, indexed
 * with the red input color)  */
#define IMXDPUV1_CLUT9_CONTROL_MODE__INDEX_RGBA              0x3U
#define IMXDPUV1_CLUT9_CONTROL_COL_8BIT_MASK                 0x10U
#define IMXDPUV1_CLUT9_CONTROL_COL_8BIT_SHIFT                4U
/* Field Value: COL_8BIT__DISABLE, color is 10bit output  */
#define IMXDPUV1_CLUT9_CONTROL_COL_8BIT__DISABLE             0U
/* Field Value: COL_8BIT__ENABLE, color is 8bit output (dithering of internal
 * 10bit value)  */
#define IMXDPUV1_CLUT9_CONTROL_COL_8BIT__ENABLE              0x1U
#define IMXDPUV1_CLUT9_CONTROL_ALPHAMASK_MASK                0x20U
#define IMXDPUV1_CLUT9_CONTROL_ALPHAMASK_SHIFT               5U
/* Field Value: ALPHAMASK__DISABLE, Alpha mask mode disabled  */
#define IMXDPUV1_CLUT9_CONTROL_ALPHAMASK__DISABLE            0U
/* Field Value: ALPHAMASK__ENABLE, Alpha mask mode enabled  */
#define IMXDPUV1_CLUT9_CONTROL_ALPHAMASK__ENABLE             0x1U
#define IMXDPUV1_CLUT9_CONTROL_ALPHAINVERT_MASK              0x40U
#define IMXDPUV1_CLUT9_CONTROL_ALPHAINVERT_SHIFT             6U
/* Field Value: ALPHAINVERT__NORMAL, Disable computation for alpha smaller
 * than 128  */
#define IMXDPUV1_CLUT9_CONTROL_ALPHAINVERT__NORMAL           0U
/* Field Value: ALPHAINVERT__INVERT, Disable computation for alpha greater
 * than or equal to 128  */
#define IMXDPUV1_CLUT9_CONTROL_ALPHAINVERT__INVERT           0x1U
#define IMXDPUV1_CLUT9_CONTROL_IDX_BITS_MASK                 0xF00U
#define IMXDPUV1_CLUT9_CONTROL_IDX_BITS_SHIFT                8U

/* Register: IMXDPUV1_clut9_Status */
#define IMXDPUV1_CLUT9_STATUS                                ((uint32_t)(0x2414))
#define IMXDPUV1_CLUT9_STATUS_OFFSET                         ((uint32_t)(0x14))
#define IMXDPUV1_CLUT9_STATUS_RESET_VALUE                    0U
#define IMXDPUV1_CLUT9_STATUS_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_CLUT9_STATUS_WRITE_TIMEOUT_MASK             0x1U
#define IMXDPUV1_CLUT9_STATUS_WRITE_TIMEOUT_SHIFT            0U
#define IMXDPUV1_CLUT9_STATUS_READ_TIMEOUT_MASK              0x10U
#define IMXDPUV1_CLUT9_STATUS_READ_TIMEOUT_SHIFT             4U

/* Register: IMXDPUV1_clut9_LastControlWord */
#define IMXDPUV1_CLUT9_LASTCONTROLWORD                       ((uint32_t)(0x2418))
#define IMXDPUV1_CLUT9_LASTCONTROLWORD_OFFSET                ((uint32_t)(0x18))
#define IMXDPUV1_CLUT9_LASTCONTROLWORD_RESET_VALUE           0U
#define IMXDPUV1_CLUT9_LASTCONTROLWORD_RESET_MASK            0U
#define IMXDPUV1_CLUT9_LASTCONTROLWORD_L_VAL_MASK            0xFFFFFFFFU
#define IMXDPUV1_CLUT9_LASTCONTROLWORD_L_VAL_SHIFT           0U

/* Register: IMXDPUV1_clut9_LUT */
#define IMXDPUV1_CLUT9_LUT                                   ((uint32_t)(0x2800))
#define IMXDPUV1_CLUT9_LUT_OFFSET                            ((uint32_t)(0))
#define IMXDPUV1_CLUT9_LUT_RESET_VALUE                       0U
#define IMXDPUV1_CLUT9_LUT_RESET_MASK                        0xC0000000U
#define IMXDPUV1_CLUT9_LUT_BLUE_MASK                         0x3FFU
#define IMXDPUV1_CLUT9_LUT_BLUE_SHIFT                        0U
#define IMXDPUV1_CLUT9_LUT_GREEN_MASK                        0xFFC00U
#define IMXDPUV1_CLUT9_LUT_GREEN_SHIFT                       10U
#define IMXDPUV1_CLUT9_LUT_RED_MASK                          0x3FF00000U
#define IMXDPUV1_CLUT9_LUT_RED_SHIFT                         20U

/* Register: IMXDPUV1_matrix9_LockUnlock */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK                          ((uint32_t)(0x2C00))
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_MATRIX9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_matrix9_LockStatus */
#define IMXDPUV1_MATRIX9_LOCKSTATUS                          ((uint32_t)(0x2C04))
#define IMXDPUV1_MATRIX9_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_MATRIX9_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_MATRIX9_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_matrix9_StaticControl */
#define IMXDPUV1_MATRIX9_STATICCONTROL                       ((uint32_t)(0x2C08))
#define IMXDPUV1_MATRIX9_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_MATRIX9_STATICCONTROL_RESET_VALUE           0U
#define IMXDPUV1_MATRIX9_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_MATRIX9_STATICCONTROL_SHDEN_SHIFT           0U

/* Register: IMXDPUV1_matrix9_Control */
#define IMXDPUV1_MATRIX9_CONTROL                             ((uint32_t)(0x2C0C))
#define IMXDPUV1_MATRIX9_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_MATRIX9_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_MATRIX9_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_CONTROL_MODE_MASK                   0x3U
#define IMXDPUV1_MATRIX9_CONTROL_MODE_SHIFT                  0U
/* Field Value: MODE__NEUTRAL, Module in neutral mode, input data is bypassed  */
#define IMXDPUV1_MATRIX9_CONTROL_MODE__NEUTRAL               0U
/* Field Value: MODE__MATRIX, Module in matrix mode, input data is multiplied
 * with matrix values  */
#define IMXDPUV1_MATRIX9_CONTROL_MODE__MATRIX                0x1U
/* Field Value: MODE__PREMUL, Module in alpha pre-multiplication mode, input
 * color is multiplied with input alpha  */
#define IMXDPUV1_MATRIX9_CONTROL_MODE__PREMUL                0x2U
/* Field Value: MODE__RSVD, Reserved, do not use  */
#define IMXDPUV1_MATRIX9_CONTROL_MODE__RSVD                  0x3U
#define IMXDPUV1_MATRIX9_CONTROL_ALPHAMASK_MASK              0x10U
#define IMXDPUV1_MATRIX9_CONTROL_ALPHAMASK_SHIFT             4U
#define IMXDPUV1_MATRIX9_CONTROL_ALPHAINVERT_MASK            0x20U
#define IMXDPUV1_MATRIX9_CONTROL_ALPHAINVERT_SHIFT           5U

/* Register: IMXDPUV1_matrix9_Red0 */
#define IMXDPUV1_MATRIX9_RED0                                ((uint32_t)(0x2C10))
#define IMXDPUV1_MATRIX9_RED0_OFFSET                         ((uint32_t)(0x10))
#define IMXDPUV1_MATRIX9_RED0_RESET_VALUE                    0x400U
#define IMXDPUV1_MATRIX9_RED0_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_RED0_A11_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX9_RED0_A11_SHIFT                      0U
#define IMXDPUV1_MATRIX9_RED0_A12_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX9_RED0_A12_SHIFT                      16U

/* Register: IMXDPUV1_matrix9_Red1 */
#define IMXDPUV1_MATRIX9_RED1                                ((uint32_t)(0x2C14))
#define IMXDPUV1_MATRIX9_RED1_OFFSET                         ((uint32_t)(0x14))
#define IMXDPUV1_MATRIX9_RED1_RESET_VALUE                    0U
#define IMXDPUV1_MATRIX9_RED1_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_RED1_A13_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX9_RED1_A13_SHIFT                      0U
#define IMXDPUV1_MATRIX9_RED1_A14_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX9_RED1_A14_SHIFT                      16U

/* Register: IMXDPUV1_matrix9_Green0 */
#define IMXDPUV1_MATRIX9_GREEN0                              ((uint32_t)(0x2C18))
#define IMXDPUV1_MATRIX9_GREEN0_OFFSET                       ((uint32_t)(0x18))
#define IMXDPUV1_MATRIX9_GREEN0_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX9_GREEN0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_GREEN0_A21_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX9_GREEN0_A21_SHIFT                    0U
#define IMXDPUV1_MATRIX9_GREEN0_A22_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX9_GREEN0_A22_SHIFT                    16U

/* Register: IMXDPUV1_matrix9_Green1 */
#define IMXDPUV1_MATRIX9_GREEN1                              ((uint32_t)(0x2C1C))
#define IMXDPUV1_MATRIX9_GREEN1_OFFSET                       ((uint32_t)(0x1C))
#define IMXDPUV1_MATRIX9_GREEN1_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX9_GREEN1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_GREEN1_A23_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX9_GREEN1_A23_SHIFT                    0U
#define IMXDPUV1_MATRIX9_GREEN1_A24_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX9_GREEN1_A24_SHIFT                    16U

/* Register: IMXDPUV1_matrix9_Blue0 */
#define IMXDPUV1_MATRIX9_BLUE0                               ((uint32_t)(0x2C20))
#define IMXDPUV1_MATRIX9_BLUE0_OFFSET                        ((uint32_t)(0x20))
#define IMXDPUV1_MATRIX9_BLUE0_RESET_VALUE                   0U
#define IMXDPUV1_MATRIX9_BLUE0_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_BLUE0_A31_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX9_BLUE0_A31_SHIFT                     0U
#define IMXDPUV1_MATRIX9_BLUE0_A32_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX9_BLUE0_A32_SHIFT                     16U

/* Register: IMXDPUV1_matrix9_Blue1 */
#define IMXDPUV1_MATRIX9_BLUE1                               ((uint32_t)(0x2C24))
#define IMXDPUV1_MATRIX9_BLUE1_OFFSET                        ((uint32_t)(0x24))
#define IMXDPUV1_MATRIX9_BLUE1_RESET_VALUE                   0x400U
#define IMXDPUV1_MATRIX9_BLUE1_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_BLUE1_A33_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX9_BLUE1_A33_SHIFT                     0U
#define IMXDPUV1_MATRIX9_BLUE1_A34_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX9_BLUE1_A34_SHIFT                     16U

/* Register: IMXDPUV1_matrix9_Alpha0 */
#define IMXDPUV1_MATRIX9_ALPHA0                              ((uint32_t)(0x2C28))
#define IMXDPUV1_MATRIX9_ALPHA0_OFFSET                       ((uint32_t)(0x28))
#define IMXDPUV1_MATRIX9_ALPHA0_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX9_ALPHA0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_ALPHA0_A41_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX9_ALPHA0_A41_SHIFT                    0U
#define IMXDPUV1_MATRIX9_ALPHA0_A42_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX9_ALPHA0_A42_SHIFT                    16U

/* Register: IMXDPUV1_matrix9_Alpha1 */
#define IMXDPUV1_MATRIX9_ALPHA1                              ((uint32_t)(0x2C2C))
#define IMXDPUV1_MATRIX9_ALPHA1_OFFSET                       ((uint32_t)(0x2C))
#define IMXDPUV1_MATRIX9_ALPHA1_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX9_ALPHA1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_ALPHA1_A43_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX9_ALPHA1_A43_SHIFT                    0U
#define IMXDPUV1_MATRIX9_ALPHA1_A44_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX9_ALPHA1_A44_SHIFT                    16U

/* Register: IMXDPUV1_matrix9_OffsetVector0 */
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0                       ((uint32_t)(0x2C30))
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_OFFSET                ((uint32_t)(0x30))
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_RESET_VALUE           0U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_C1_MASK               0x1FFFU
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_C1_SHIFT              0U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_C2_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR0_C2_SHIFT              16U

/* Register: IMXDPUV1_matrix9_OffsetVector1 */
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1                       ((uint32_t)(0x2C34))
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_OFFSET                ((uint32_t)(0x34))
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_RESET_VALUE           0U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_C3_MASK               0x1FFFU
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_C3_SHIFT              0U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_C4_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX9_OFFSETVECTOR1_C4_SHIFT              16U

/* Register: IMXDPUV1_matrix9_LastControlWord */
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD                     ((uint32_t)(0x2C38))
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD_OFFSET              ((uint32_t)(0x38))
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD_RESET_VALUE         0U
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD_RESET_MASK          0U
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD_L_VAL_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX9_LASTCONTROLWORD_L_VAL_SHIFT         0U

/* Register: IMXDPUV1_hscaler9_LockUnlock */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK                         ((uint32_t)(0x3000))
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_HSCALER9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_hscaler9_LockStatus */
#define IMXDPUV1_HSCALER9_LOCKSTATUS                         ((uint32_t)(0x3004))
#define IMXDPUV1_HSCALER9_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_HSCALER9_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_HSCALER9_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_hscaler9_StaticControl */
#define IMXDPUV1_HSCALER9_STATICCONTROL                      ((uint32_t)(0x3008))
#define IMXDPUV1_HSCALER9_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_HSCALER9_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_HSCALER9_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_HSCALER9_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_hscaler9_Setup1 */
#define IMXDPUV1_HSCALER9_SETUP1                             ((uint32_t)(0x300C))
#define IMXDPUV1_HSCALER9_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_HSCALER9_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_HSCALER9_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_HSCALER9_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_hscaler9_Setup2 */
#define IMXDPUV1_HSCALER9_SETUP2                             ((uint32_t)(0x3010))
#define IMXDPUV1_HSCALER9_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_HSCALER9_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_HSCALER9_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_HSCALER9_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_hscaler9_Control */
#define IMXDPUV1_HSCALER9_CONTROL                            ((uint32_t)(0x3014))
#define IMXDPUV1_HSCALER9_CONTROL_OFFSET                     ((uint32_t)(0x14))
#define IMXDPUV1_HSCALER9_CONTROL_RESET_VALUE                0U
#define IMXDPUV1_HSCALER9_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_HSCALER9_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_HSCALER9_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_HSCALER9_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_HSCALER9_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_HSCALER9_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_HSCALER9_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_HSCALER9_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size)  */
#define IMXDPUV1_HSCALER9_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_HSCALER9_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_HSCALER9_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_HSCALER9_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_HSCALER9_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_HSCALER9_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_HSCALER9_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_vscaler9_LockUnlock */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK                         ((uint32_t)(0x3400))
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_VSCALER9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_vscaler9_LockStatus */
#define IMXDPUV1_VSCALER9_LOCKSTATUS                         ((uint32_t)(0x3404))
#define IMXDPUV1_VSCALER9_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_VSCALER9_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_VSCALER9_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_vscaler9_StaticControl */
#define IMXDPUV1_VSCALER9_STATICCONTROL                      ((uint32_t)(0x3408))
#define IMXDPUV1_VSCALER9_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_VSCALER9_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_VSCALER9_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_VSCALER9_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_vscaler9_Setup1 */
#define IMXDPUV1_VSCALER9_SETUP1                             ((uint32_t)(0x340C))
#define IMXDPUV1_VSCALER9_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_VSCALER9_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_VSCALER9_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_VSCALER9_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_vscaler9_Setup2 */
#define IMXDPUV1_VSCALER9_SETUP2                             ((uint32_t)(0x3410))
#define IMXDPUV1_VSCALER9_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_VSCALER9_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER9_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_VSCALER9_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_vscaler9_Setup3 */
#define IMXDPUV1_VSCALER9_SETUP3                             ((uint32_t)(0x3414))
#define IMXDPUV1_VSCALER9_SETUP3_OFFSET                      ((uint32_t)(0x14))
#define IMXDPUV1_VSCALER9_SETUP3_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER9_SETUP3_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_SETUP3_PHASE_OFFSET1_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER9_SETUP3_PHASE_OFFSET1_SHIFT         0U

/* Register: IMXDPUV1_vscaler9_Setup4 */
#define IMXDPUV1_VSCALER9_SETUP4                             ((uint32_t)(0x3418))
#define IMXDPUV1_VSCALER9_SETUP4_OFFSET                      ((uint32_t)(0x18))
#define IMXDPUV1_VSCALER9_SETUP4_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER9_SETUP4_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_SETUP4_PHASE_OFFSET2_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER9_SETUP4_PHASE_OFFSET2_SHIFT         0U

/* Register: IMXDPUV1_vscaler9_Setup5 */
#define IMXDPUV1_VSCALER9_SETUP5                             ((uint32_t)(0x341C))
#define IMXDPUV1_VSCALER9_SETUP5_OFFSET                      ((uint32_t)(0x1C))
#define IMXDPUV1_VSCALER9_SETUP5_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER9_SETUP5_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_SETUP5_PHASE_OFFSET3_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER9_SETUP5_PHASE_OFFSET3_SHIFT         0U

/* Register: IMXDPUV1_vscaler9_Control */
#define IMXDPUV1_VSCALER9_CONTROL                            ((uint32_t)(0x3420))
#define IMXDPUV1_VSCALER9_CONTROL_OFFSET                     ((uint32_t)(0x20))
#define IMXDPUV1_VSCALER9_CONTROL_RESET_VALUE                0x2000U
#define IMXDPUV1_VSCALER9_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_VSCALER9_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_VSCALER9_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_VSCALER9_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_VSCALER9_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_VSCALER9_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_VSCALER9_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_VSCALER9_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size).  */
#define IMXDPUV1_VSCALER9_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_VSCALER9_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_VSCALER9_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_VSCALER9_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_VSCALER9_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE_MASK            0x3000U
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE_SHIFT           12U
/* Field Value: FIELD_MODE__ALWAYS0, Constant 0 indicates frame or top field.  */
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE__ALWAYS0        0U
/* Field Value: FIELD_MODE__ALWAYS1, Constant 1 indicates bottom field.  */
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE__ALWAYS1        0x1U
/* Field Value: FIELD_MODE__INPUT, Output field polarity is taken from input
 * field polarity.  */
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE__INPUT          0x2U
/* Field Value: FIELD_MODE__TOGGLE, Output field polarity toggles, starting
 * with 0 after reset.  */
#define IMXDPUV1_VSCALER9_CONTROL_FIELD_MODE__TOGGLE         0x3U
#define IMXDPUV1_VSCALER9_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_VSCALER9_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_filter9_LockUnlock */
#define IMXDPUV1_FILTER9_LOCKUNLOCK                          ((uint32_t)(0x3800))
#define IMXDPUV1_FILTER9_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_FILTER9_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_FILTER9_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FILTER9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_filter9_LockStatus */
#define IMXDPUV1_FILTER9_LOCKSTATUS                          ((uint32_t)(0x3804))
#define IMXDPUV1_FILTER9_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_FILTER9_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_FILTER9_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_FILTER9_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_FILTER9_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_FILTER9_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_FILTER9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_FILTER9_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_FILTER9_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_filter9_StaticControl */
#define IMXDPUV1_FILTER9_STATICCONTROL                       ((uint32_t)(0x3808))
#define IMXDPUV1_FILTER9_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_FILTER9_STATICCONTROL_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_FILTER9_STATICCONTROL_SHDEN_SHIFT           0U

/* Register: IMXDPUV1_filter9_Control */
#define IMXDPUV1_FILTER9_CONTROL                             ((uint32_t)(0x380C))
#define IMXDPUV1_FILTER9_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_FILTER9_CONTROL_RESET_VALUE                 0x5500U
#define IMXDPUV1_FILTER9_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_FILTER9_CONTROL_MODE_MASK                   0x1U
#define IMXDPUV1_FILTER9_CONTROL_MODE_SHIFT                  0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the filter, all
 * other settings are ignored.  */
#define IMXDPUV1_FILTER9_CONTROL_MODE__NEUTRAL               0U
/* Field Value: MODE__ACTIVE, Filter is active.  */
#define IMXDPUV1_FILTER9_CONTROL_MODE__ACTIVE                0x1U
#define IMXDPUV1_FILTER9_CONTROL_TILE_MODE_MASK              0x30U
#define IMXDPUV1_FILTER9_CONTROL_TILE_MODE_SHIFT             4U
/* Field Value: TILE_MODE__PAD, Samples outside the frame are padded with
 * the last valid border pixels.  */
#define IMXDPUV1_FILTER9_CONTROL_TILE_MODE__PAD              0U
/* Field Value: TILE_MODE__ZERO, Samples outside the frame are treated as
 * zero pixel value.  */
#define IMXDPUV1_FILTER9_CONTROL_TILE_MODE__ZERO             0x1U
/* Field Value: TILE_MODE__PAD_ZERO, Applies tile mode PAD to RGB channels
 * and tile mode ZERO to alpha channel.  */
#define IMXDPUV1_FILTER9_CONTROL_TILE_MODE__PAD_ZERO         0x2U
#define IMXDPUV1_FILTER9_CONTROL_FILTER_MODE_MASK            0xFFFF00U
#define IMXDPUV1_FILTER9_CONTROL_FILTER_MODE_SHIFT           8U
/* Field Value: FILTER_MODE__FIR_5X5, FIR filter 5x5 window.  */
#define IMXDPUV1_FILTER9_CONTROL_FILTER_MODE__FIR_5X5        0x55U
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT_MASK          0x30000000U
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT_SHIFT         28U
/* Field Value: BUFFER_FORMAT__RGB888, RGB888 format. Alpha is not filtered
 * but set to constant value 255.  */
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT__RGB888       0U
/* Field Value: BUFFER_FORMAT__RGBA5658, RGBA5658 format. Alpha is filtered.  */
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT__RGBA5658     0x1U
/* Field Value: BUFFER_FORMAT__RGBA8888, RGBA8888 format. Alpha is filtered.
 * The filter window is limited to 5x4.  */
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT__RGBA8888     0x2U
/* Field Value: BUFFER_FORMAT__RGBA1010108, RGBA10.10.10.8 format. Alpha is
 * filtered. The filter window is limited to 5x3.  */
#define IMXDPUV1_FILTER9_CONTROL_BUFFER_FORMAT__RGBA1010108  0x3U

/* Register: IMXDPUV1_filter9_FIR_control */
#define IMXDPUV1_FILTER9_FIR_CONTROL                         ((uint32_t)(0x3810))
#define IMXDPUV1_FILTER9_FIR_CONTROL_OFFSET                  ((uint32_t)(0x10))
#define IMXDPUV1_FILTER9_FIR_CONTROL_RESET_VALUE             0xEU
#define IMXDPUV1_FILTER9_FIR_CONTROL_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FILTER9_FIR_CONTROL_FIR_COMPONENT_SELECT_MASK 0xFU
#define IMXDPUV1_FILTER9_FIR_CONTROL_FIR_COMPONENT_SELECT_SHIFT 0U
#define IMXDPUV1_FILTER9_FIR_CONTROL_FIR_EXPONENT_MASK       0xF00U
#define IMXDPUV1_FILTER9_FIR_CONTROL_FIR_EXPONENT_SHIFT      8U

/* Register: IMXDPUV1_filter9_Coefficients0 */
#define IMXDPUV1_FILTER9_COEFFICIENTS0                       ((uint32_t)(0x3814))
#define IMXDPUV1_FILTER9_COEFFICIENTS0_OFFSET                ((uint32_t)(0x14))
#define IMXDPUV1_FILTER9_COEFFICIENTS0_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF0_0_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF0_0_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF1_0_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF1_0_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF2_0_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF2_0_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF3_0_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS0_COEFF3_0_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients1 */
#define IMXDPUV1_FILTER9_COEFFICIENTS1                       ((uint32_t)(0x3818))
#define IMXDPUV1_FILTER9_COEFFICIENTS1_OFFSET                ((uint32_t)(0x18))
#define IMXDPUV1_FILTER9_COEFFICIENTS1_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF4_0_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF4_0_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF0_1_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF0_1_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF1_1_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF1_1_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF2_1_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS1_COEFF2_1_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients2 */
#define IMXDPUV1_FILTER9_COEFFICIENTS2                       ((uint32_t)(0x381C))
#define IMXDPUV1_FILTER9_COEFFICIENTS2_OFFSET                ((uint32_t)(0x1C))
#define IMXDPUV1_FILTER9_COEFFICIENTS2_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF3_1_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF3_1_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF4_1_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF4_1_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF0_2_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF0_2_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF1_2_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS2_COEFF1_2_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients3 */
#define IMXDPUV1_FILTER9_COEFFICIENTS3                       ((uint32_t)(0x3820))
#define IMXDPUV1_FILTER9_COEFFICIENTS3_OFFSET                ((uint32_t)(0x20))
#define IMXDPUV1_FILTER9_COEFFICIENTS3_RESET_VALUE           0x1U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF2_2_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF2_2_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF3_2_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF3_2_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF4_2_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF4_2_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF0_3_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS3_COEFF0_3_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients4 */
#define IMXDPUV1_FILTER9_COEFFICIENTS4                       ((uint32_t)(0x3824))
#define IMXDPUV1_FILTER9_COEFFICIENTS4_OFFSET                ((uint32_t)(0x24))
#define IMXDPUV1_FILTER9_COEFFICIENTS4_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF1_3_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF1_3_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF2_3_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF2_3_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF3_3_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF3_3_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF4_3_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS4_COEFF4_3_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients5 */
#define IMXDPUV1_FILTER9_COEFFICIENTS5                       ((uint32_t)(0x3828))
#define IMXDPUV1_FILTER9_COEFFICIENTS5_OFFSET                ((uint32_t)(0x28))
#define IMXDPUV1_FILTER9_COEFFICIENTS5_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF0_4_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF0_4_SHIFT        0U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF1_4_MASK         0xFF00U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF1_4_SHIFT        8U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF2_4_MASK         0xFF0000U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF2_4_SHIFT        16U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF3_4_MASK         0xFF000000U
#define IMXDPUV1_FILTER9_COEFFICIENTS5_COEFF3_4_SHIFT        24U

/* Register: IMXDPUV1_filter9_Coefficients6 */
#define IMXDPUV1_FILTER9_COEFFICIENTS6                       ((uint32_t)(0x382C))
#define IMXDPUV1_FILTER9_COEFFICIENTS6_OFFSET                ((uint32_t)(0x2C))
#define IMXDPUV1_FILTER9_COEFFICIENTS6_RESET_VALUE           0U
#define IMXDPUV1_FILTER9_COEFFICIENTS6_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS6_COEFF4_4_MASK         0xFFU
#define IMXDPUV1_FILTER9_COEFFICIENTS6_COEFF4_4_SHIFT        0U

/* Register: IMXDPUV1_blitblend9_LockUnlock */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK                       ((uint32_t)(0x3C00))
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_OFFSET                ((uint32_t)(0))
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_RESET_VALUE           0U
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_RESET_MASK            0U
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK_MASK       0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK_SHIFT      0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY  0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_BLITBLEND9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_blitblend9_LockStatus */
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS                       ((uint32_t)(0x3C04))
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_OFFSET                ((uint32_t)(0x4))
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_RESET_VALUE           0U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_LOCKSTATUS_MASK       0x1U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_LOCKSTATUS_SHIFT      0U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_PRIVILEGESTATUS_MASK  0x10U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_FREEZESTATUS_MASK     0x100U
#define IMXDPUV1_BLITBLEND9_LOCKSTATUS_FREEZESTATUS_SHIFT    8U

/* Register: IMXDPUV1_blitblend9_StaticControl */
#define IMXDPUV1_BLITBLEND9_STATICCONTROL                    ((uint32_t)(0x3C08))
#define IMXDPUV1_BLITBLEND9_STATICCONTROL_OFFSET             ((uint32_t)(0x8))
#define IMXDPUV1_BLITBLEND9_STATICCONTROL_RESET_VALUE        0U
#define IMXDPUV1_BLITBLEND9_STATICCONTROL_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_STATICCONTROL_SHDEN_MASK         0x1U
#define IMXDPUV1_BLITBLEND9_STATICCONTROL_SHDEN_SHIFT        0U

/* Register: IMXDPUV1_blitblend9_Control */
#define IMXDPUV1_BLITBLEND9_CONTROL                          ((uint32_t)(0x3C0C))
#define IMXDPUV1_BLITBLEND9_CONTROL_OFFSET                   ((uint32_t)(0xC))
#define IMXDPUV1_BLITBLEND9_CONTROL_RESET_VALUE              0U
#define IMXDPUV1_BLITBLEND9_CONTROL_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_CONTROL_MODE_MASK                0x1U
#define IMXDPUV1_BLITBLEND9_CONTROL_MODE_SHIFT               0U
/* Field Value: MODE__NEUTRAL, Neutral mode, only route pixels and commands
 * from primary input to output  */
#define IMXDPUV1_BLITBLEND9_CONTROL_MODE__NEUTRAL            0U
/* Field Value: MODE__OPERATION, Normal Operation  */
#define IMXDPUV1_BLITBLEND9_CONTROL_MODE__OPERATION          0x1U

/* Register: IMXDPUV1_blitblend9_NeutralBorder */
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER                    ((uint32_t)(0x3C10))
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_OFFSET             ((uint32_t)(0x10))
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_RESET_VALUE        0U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERMODE_MASK 0x1U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERMODE_SHIFT 0U
/* Field Value: NEUTRALBORDERMODE__PRIMARY, Bypasses primary pixel  */
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERMODE__PRIMARY 0U
/* Field Value: NEUTRALBORDERMODE__SECONDARY, Bypasses secondary pixel  */
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERMODE__SECONDARY 0x1U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERLEFT_MASK 0x700U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERLEFT_SHIFT 8U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERRIGHT_MASK 0x7000U
#define IMXDPUV1_BLITBLEND9_NEUTRALBORDER_NEUTRALBORDERRIGHT_SHIFT 12U

/* Register: IMXDPUV1_blitblend9_ConstantColor */
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR                    ((uint32_t)(0x3C14))
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_OFFSET             ((uint32_t)(0x14))
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_RESET_VALUE        0U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTALPHA_MASK 0xFFU
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTALPHA_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTBLUE_MASK  0xFF00U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTBLUE_SHIFT 8U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTGREEN_MASK 0xFF0000U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTGREEN_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTRED_MASK   0xFF000000U
#define IMXDPUV1_BLITBLEND9_CONSTANTCOLOR_CONSTANTRED_SHIFT  24U

/* Register: IMXDPUV1_blitblend9_ColorRedBlendFunction */
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION            ((uint32_t)(0x3C18))
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_OFFSET     ((uint32_t)(0x18))
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_RESET_VALUE 0x3000300U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDSRC__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST_MASK 0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORREDBLENDFUNCTION_BLENDFUNCCOLORREDDST__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U

/* Register: IMXDPUV1_blitblend9_ColorGreenBlendFunction */
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION          ((uint32_t)(0x3C1C))
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_OFFSET   ((uint32_t)(0x1C))
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_RESET_VALUE 0x3000300U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENSRC__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST_MASK 0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORGREENBLENDFUNCTION_BLENDFUNCCOLORGREENDST__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U

/* Register: IMXDPUV1_blitblend9_ColorBlueBlendFunction */
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION           ((uint32_t)(0x3C20))
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_OFFSET    ((uint32_t)(0x20))
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_RESET_VALUE 0x3000300U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUESRC__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST_MASK 0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_COLORBLUEBLENDFUNCTION_BLENDFUNCCOLORBLUEDST__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U

/* Register: IMXDPUV1_blitblend9_AlphaBlendFunction */
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION               ((uint32_t)(0x3C24))
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_OFFSET        ((uint32_t)(0x24))
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_RESET_VALUE   0x3000300U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHASRC__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST_MASK 0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ZERO 0U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE 0x1U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_SRC_COLOR 0x300U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_SRC_COLOR 0x301U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_SRC_ALPHA 0x302U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_SRC_ALPHA 0x303U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_DST_ALPHA 0x304U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_DST_ALPHA 0x305U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_DST_COLOR 0x306U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_DST_COLOR 0x307U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_SRC_ALPHA_SATURATE 0x308U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_CONSTANT_COLOR 0x8001U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_CONSTANT_COLOR 0x8002U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_CONSTANT_ALPHA 0x8003U
#define IMXDPUV1_BLITBLEND9_ALPHABLENDFUNCTION_BLENDFUNCALPHADST__GL_ONE_MINUS_CONSTANT_ALPHA 0x8004U

/* Register: IMXDPUV1_blitblend9_BlendMode1 */
#define IMXDPUV1_BLITBLEND9_BLENDMODE1                       ((uint32_t)(0x3C28))
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_OFFSET                ((uint32_t)(0x28))
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_RESET_VALUE           0x80068006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__GL_FUNC_ADD 0x8006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__GL_MIN 0x8007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__GL_MAX 0x8008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__GL_FUNC_SUBTRACT 0x800AU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__GL_FUNC_REVERSE_SUBTRACT 0x800BU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_SRC 0x2000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_SRC_OVER 0x2001U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_DST_OVER 0x2002U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_SRC_IN 0x2003U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_DST_IN 0x2004U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_MULTIPLY 0x2005U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_SCREEN 0x2006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_DARKEN 0x2007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_LIGHTEN 0x2008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORRED__VG_BLEND_ADDITIVE 0x2009U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN_MASK 0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN_SHIFT 16U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__GL_FUNC_ADD 0x8006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__GL_MIN 0x8007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__GL_MAX 0x8008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__GL_FUNC_SUBTRACT 0x800AU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__GL_FUNC_REVERSE_SUBTRACT 0x800BU
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_SRC 0x2000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_SRC_OVER 0x2001U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_DST_OVER 0x2002U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_SRC_IN 0x2003U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_DST_IN 0x2004U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_MULTIPLY 0x2005U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_SCREEN 0x2006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_DARKEN 0x2007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_LIGHTEN 0x2008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE1_BLENDMODECOLORGREEN__VG_BLEND_ADDITIVE 0x2009U

/* Register: IMXDPUV1_blitblend9_BlendMode2 */
#define IMXDPUV1_BLITBLEND9_BLENDMODE2                       ((uint32_t)(0x3C2C))
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_OFFSET                ((uint32_t)(0x2C))
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_RESET_VALUE           0x80068006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE_MASK 0xFFFFU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE_SHIFT 0U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__GL_FUNC_ADD 0x8006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__GL_MIN 0x8007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__GL_MAX 0x8008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__GL_FUNC_SUBTRACT 0x800AU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__GL_FUNC_REVERSE_SUBTRACT 0x800BU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_SRC 0x2000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_SRC_OVER 0x2001U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_DST_OVER 0x2002U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_SRC_IN 0x2003U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_DST_IN 0x2004U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_MULTIPLY 0x2005U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_SCREEN 0x2006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_DARKEN 0x2007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_LIGHTEN 0x2008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODECOLORBLUE__VG_BLEND_ADDITIVE 0x2009U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA_MASK   0xFFFF0000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA_SHIFT  16U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__GL_FUNC_ADD 0x8006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__GL_MIN 0x8007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__GL_MAX 0x8008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__GL_FUNC_SUBTRACT 0x800AU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__GL_FUNC_REVERSE_SUBTRACT 0x800BU
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_SRC 0x2000U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_SRC_OVER 0x2001U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_DST_OVER 0x2002U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_SRC_IN 0x2003U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_DST_IN 0x2004U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_MULTIPLY 0x2005U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_SCREEN 0x2006U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_DARKEN 0x2007U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_LIGHTEN 0x2008U
#define IMXDPUV1_BLITBLEND9_BLENDMODE2_BLENDMODEALPHA__VG_BLEND_ADDITIVE 0x2009U

/* Register: IMXDPUV1_blitblend9_DirectSetup */
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP                      ((uint32_t)(0x3C30))
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_OFFSET               ((uint32_t)(0x30))
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_RESET_VALUE          0U
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_COLORDEBUG_MASK      0x3FFU
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_COLORDEBUG_SHIFT     0U
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_ALPHADEBUG_MASK      0x3FF0000U
#define IMXDPUV1_BLITBLEND9_DIRECTSETUP_ALPHADEBUG_SHIFT     16U

/* Register: IMXDPUV1_blitblend9_PrimControlWord */
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD                  ((uint32_t)(0x3C34))
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD_OFFSET           ((uint32_t)(0x34))
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD_RESET_VALUE      0U
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD_RESET_MASK       0U
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD_P_VAL_MASK       0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_PRIMCONTROLWORD_P_VAL_SHIFT      0U

/* Register: IMXDPUV1_blitblend9_SecControlWord */
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD                   ((uint32_t)(0x3C38))
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD_OFFSET            ((uint32_t)(0x38))
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD_RESET_VALUE       0U
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD_RESET_MASK        0U
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD_S_VAL_MASK        0xFFFFFFFFU
#define IMXDPUV1_BLITBLEND9_SECCONTROLWORD_S_VAL_SHIFT       0U

/* Register: IMXDPUV1_store9_LockUnlock */
#define IMXDPUV1_STORE9_LOCKUNLOCK                           ((uint32_t)(0x4000))
#define IMXDPUV1_STORE9_LOCKUNLOCK_OFFSET                    ((uint32_t)(0))
#define IMXDPUV1_STORE9_LOCKUNLOCK_RESET_VALUE               0U
#define IMXDPUV1_STORE9_LOCKUNLOCK_RESET_MASK                0U
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK_MASK           0xFFFFFFFFU
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK_SHIFT          0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY      0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY    0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_STORE9_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY    0xFBE8B1E6U

/* Register: IMXDPUV1_store9_LockStatus */
#define IMXDPUV1_STORE9_LOCKSTATUS                           ((uint32_t)(0x4004))
#define IMXDPUV1_STORE9_LOCKSTATUS_OFFSET                    ((uint32_t)(0x4))
#define IMXDPUV1_STORE9_LOCKSTATUS_RESET_VALUE               0U
#define IMXDPUV1_STORE9_LOCKSTATUS_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_STORE9_LOCKSTATUS_LOCKSTATUS_MASK           0x1U
#define IMXDPUV1_STORE9_LOCKSTATUS_LOCKSTATUS_SHIFT          0U
#define IMXDPUV1_STORE9_LOCKSTATUS_PRIVILEGESTATUS_MASK      0x10U
#define IMXDPUV1_STORE9_LOCKSTATUS_PRIVILEGESTATUS_SHIFT     4U
#define IMXDPUV1_STORE9_LOCKSTATUS_FREEZESTATUS_MASK         0x100U
#define IMXDPUV1_STORE9_LOCKSTATUS_FREEZESTATUS_SHIFT        8U

/* Register: IMXDPUV1_store9_StaticControl */
#define IMXDPUV1_STORE9_STATICCONTROL                        ((uint32_t)(0x4008))
#define IMXDPUV1_STORE9_STATICCONTROL_OFFSET                 ((uint32_t)(0x8))
#define IMXDPUV1_STORE9_STATICCONTROL_RESET_VALUE            0U
#define IMXDPUV1_STORE9_STATICCONTROL_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_STORE9_STATICCONTROL_SHDEN_MASK             0x1U
#define IMXDPUV1_STORE9_STATICCONTROL_SHDEN_SHIFT            0U
#define IMXDPUV1_STORE9_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0x100U
#define IMXDPUV1_STORE9_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 8U

/* Register: IMXDPUV1_store9_BurstBufferManagement */
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT                ((uint32_t)(0x400C))
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT_OFFSET         ((uint32_t)(0xC))
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT_RESET_VALUE    0x400U
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_STORE9_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U

/* Register: IMXDPUV1_store9_RingBufStartAddr */
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR                     ((uint32_t)(0x4010))
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR_OFFSET              ((uint32_t)(0x10))
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR_RESET_VALUE         0U
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR_RINGBUFSTARTADDR_MASK 0xFFFFFFFFU
#define IMXDPUV1_STORE9_RINGBUFSTARTADDR_RINGBUFSTARTADDR_SHIFT 0U

/* Register: IMXDPUV1_store9_RingBufWrapAddr */
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR                      ((uint32_t)(0x4014))
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR_OFFSET               ((uint32_t)(0x14))
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR_RESET_VALUE          0U
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR_RINGBUFWRAPADDR_MASK 0xFFFFFFFFU
#define IMXDPUV1_STORE9_RINGBUFWRAPADDR_RINGBUFWRAPADDR_SHIFT 0U

/* Register: IMXDPUV1_store9_BaseAddress */
#define IMXDPUV1_STORE9_BASEADDRESS                          ((uint32_t)(0x4018))
#define IMXDPUV1_STORE9_BASEADDRESS_OFFSET                   ((uint32_t)(0x18))
#define IMXDPUV1_STORE9_BASEADDRESS_RESET_VALUE              0U
#define IMXDPUV1_STORE9_BASEADDRESS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_STORE9_BASEADDRESS_BASEADDRESS_MASK         0xFFFFFFFFU
#define IMXDPUV1_STORE9_BASEADDRESS_BASEADDRESS_SHIFT        0U

/* Register: IMXDPUV1_store9_DestinationBufferAttributes */
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES          ((uint32_t)(0x401C))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_OFFSET   ((uint32_t)(0x1C))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_RESET_VALUE 0x200004FFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_STRIDE_MASK 0x1FFFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_STRIDE_SHIFT 0U
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_BITSPERPIXEL_MASK 0x7F000000U
#define IMXDPUV1_STORE9_DESTINATIONBUFFERATTRIBUTES_BITSPERPIXEL_SHIFT 24U

/* Register: IMXDPUV1_store9_DestinationBufferDimension */
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION           ((uint32_t)(0x4020))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_OFFSET    ((uint32_t)(0x20))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_LINEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_LINEWIDTH_SHIFT 0U
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_LINECOUNT_MASK 0x3FFF0000U
#define IMXDPUV1_STORE9_DESTINATIONBUFFERDIMENSION_LINECOUNT_SHIFT 16U

/* Register: IMXDPUV1_store9_FrameOffset */
#define IMXDPUV1_STORE9_FRAMEOFFSET                          ((uint32_t)(0x4024))
#define IMXDPUV1_STORE9_FRAMEOFFSET_OFFSET                   ((uint32_t)(0x24))
#define IMXDPUV1_STORE9_FRAMEOFFSET_RESET_VALUE              0U
#define IMXDPUV1_STORE9_FRAMEOFFSET_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_STORE9_FRAMEOFFSET_FRAMEXOFFSET_MASK        0x7FFFU
#define IMXDPUV1_STORE9_FRAMEOFFSET_FRAMEXOFFSET_SHIFT       0U
#define IMXDPUV1_STORE9_FRAMEOFFSET_FRAMEYOFFSET_MASK        0x7FFF0000U
#define IMXDPUV1_STORE9_FRAMEOFFSET_FRAMEYOFFSET_SHIFT       16U

/* Register: IMXDPUV1_store9_ColorComponentBits */
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS                   ((uint32_t)(0x4028))
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_OFFSET            ((uint32_t)(0x28))
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_RESET_VALUE       0x8080808U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSALPHA_MASK 0xFU
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSALPHA_SHIFT 0U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSBLUE_MASK 0xF00U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSBLUE_SHIFT 8U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSGREEN_MASK 0xF0000U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSGREEN_SHIFT 16U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSRED_MASK 0xF000000U
#define IMXDPUV1_STORE9_COLORCOMPONENTBITS_COMPONENTBITSRED_SHIFT 24U

/* Register: IMXDPUV1_store9_ColorComponentShift */
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT                  ((uint32_t)(0x402C))
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_OFFSET           ((uint32_t)(0x2C))
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_RESET_VALUE      0x18100800U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTALPHA_MASK 0x1FU
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTALPHA_SHIFT 0U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTBLUE_MASK 0x1F00U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTBLUE_SHIFT 8U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTGREEN_MASK 0x1F0000U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTGREEN_SHIFT 16U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTRED_MASK 0x1F000000U
#define IMXDPUV1_STORE9_COLORCOMPONENTSHIFT_COMPONENTSHIFTRED_SHIFT 24U

/* Register: IMXDPUV1_store9_Control */
#define IMXDPUV1_STORE9_CONTROL                              ((uint32_t)(0x4030))
#define IMXDPUV1_STORE9_CONTROL_OFFSET                       ((uint32_t)(0x30))
#define IMXDPUV1_STORE9_CONTROL_RESET_VALUE                  0U
#define IMXDPUV1_STORE9_CONTROL_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_STORE9_CONTROL_COLORDITHERENABLE_MASK       0x1U
#define IMXDPUV1_STORE9_CONTROL_COLORDITHERENABLE_SHIFT      0U
#define IMXDPUV1_STORE9_CONTROL_ALPHADITHERENABLE_MASK       0x2U
#define IMXDPUV1_STORE9_CONTROL_ALPHADITHERENABLE_SHIFT      1U
#define IMXDPUV1_STORE9_CONTROL_DITHEROFFSET_MASK            0xF0U
#define IMXDPUV1_STORE9_CONTROL_DITHEROFFSET_SHIFT           4U
#define IMXDPUV1_STORE9_CONTROL_GAMMAAPPLYENABLE_MASK        0x1000U
#define IMXDPUV1_STORE9_CONTROL_GAMMAAPPLYENABLE_SHIFT       12U
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE_MASK       0x30000U
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE_SHIFT      16U
/* Field Value: YUVCONVERSIONMODE__OFF, No conversion. Input data must be
 * RGB.  */
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE__OFF       0U
/* Field Value: YUVCONVERSIONMODE__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE__ITU601    0x1U
/* Field Value: YUVCONVERSIONMODE__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_STORE9_CONTROL_YUVCONVERSIONMODE__ITU709    0x3U
#define IMXDPUV1_STORE9_CONTROL_RASTERMODE_MASK              0xC0000U
#define IMXDPUV1_STORE9_CONTROL_RASTERMODE_SHIFT             18U
/* Field Value: RASTERMODE__NORMAL, RGBA or YUV 4:4:4 pixel buffer.  */
#define IMXDPUV1_STORE9_CONTROL_RASTERMODE__NORMAL           0U
/* Field Value: RASTERMODE__YUV422, [Store derivate only] Packed YUV 4:2:2
 * pixel buffer. Effect is that U samples are written for pixels with even
 * and V samples for odd column index only. So BitsPerPixel must be set
 * to the size that a pair of YU or YV has in memory (most typically 16
 * bits). All correlated widths and horizontal offsets must be even.  */
#define IMXDPUV1_STORE9_CONTROL_RASTERMODE__YUV422           0x1U
/* Field Value: RASTERMODE__ENCODE, [Store derivate only] RLAD compressed
 * bit stream.  */
#define IMXDPUV1_STORE9_CONTROL_RASTERMODE__ENCODE           0x2U
#define IMXDPUV1_STORE9_CONTROL_YUV422DOWNSAMPLINGMODE_MASK  0x300000U
#define IMXDPUV1_STORE9_CONTROL_YUV422DOWNSAMPLINGMODE_SHIFT 20U
/* Field Value: YUV422DOWNSAMPLINGMODE__NEAREST, Nearest mode. Discards all
 * odd samples, outputs even samples.  */
#define IMXDPUV1_STORE9_CONTROL_YUV422DOWNSAMPLINGMODE__NEAREST 0U
/* Field Value: YUV422DOWNSAMPLINGMODE__COALIGNED, Linear coaligned mode.
 * 3 nearest UV samples are combined in linear filter to get one output sample.  */
#define IMXDPUV1_STORE9_CONTROL_YUV422DOWNSAMPLINGMODE__COALIGNED 0x1U
/* Field Value: YUV422DOWNSAMPLINGMODE__INTERSPERSED, Linear interspersed
 * mode. 2 nearest UV samples are combined in linear filter to get one output
 * sample.  */
#define IMXDPUV1_STORE9_CONTROL_YUV422DOWNSAMPLINGMODE__INTERSPERSED 0x2U

/* Register: IMXDPUV1_store9_EncodeControl */
#define IMXDPUV1_STORE9_ENCODECONTROL                        ((uint32_t)(0x4034))
#define IMXDPUV1_STORE9_ENCODECONTROL_OFFSET                 ((uint32_t)(0x34))
#define IMXDPUV1_STORE9_ENCODECONTROL_RESET_VALUE            0x88880001U
#define IMXDPUV1_STORE9_ENCODECONTROL_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_STORE9_ENCODECONTROL_COMPRESSIONMODE_MASK   0x1U
#define IMXDPUV1_STORE9_ENCODECONTROL_COMPRESSIONMODE_SHIFT  0U
/* Field Value: COMPRESSIONMODE__RLAD, Run-Length Adaptive Dithering (lossy
 * compression).  */
#define IMXDPUV1_STORE9_ENCODECONTROL_COMPRESSIONMODE__RLAD  0U
/* Field Value: COMPRESSIONMODE__RLAD_UNIFORM, Run-Length Adaptive Dithering
 * (lossy compression; uniform package size).  */
#define IMXDPUV1_STORE9_ENCODECONTROL_COMPRESSIONMODE__RLAD_UNIFORM 0x1U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSRED_MASK   0xF0000U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSRED_SHIFT  16U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSGREEN_MASK 0xF00000U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSGREEN_SHIFT 20U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSBLUE_MASK  0xF000000U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSBLUE_SHIFT 24U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSALPHA_MASK 0xF0000000U
#define IMXDPUV1_STORE9_ENCODECONTROL_RLADCOMPBITSALPHA_SHIFT 28U

/* Register: IMXDPUV1_store9_DestinationBufferLength */
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH              ((uint32_t)(0x4038))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH_OFFSET       ((uint32_t)(0x38))
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH_RESET_VALUE  0U
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH_RLEWORDSMAX_MASK 0x1FFFFFFFU
#define IMXDPUV1_STORE9_DESTINATIONBUFFERLENGTH_RLEWORDSMAX_SHIFT 0U

/* Register: IMXDPUV1_store9_Start */
#define IMXDPUV1_STORE9_START                                ((uint32_t)(0x403C))
#define IMXDPUV1_STORE9_START_OFFSET                         ((uint32_t)(0x3C))
#define IMXDPUV1_STORE9_START_RESET_VALUE                    0U
#define IMXDPUV1_STORE9_START_RESET_MASK                     0xFFFFFFFEU
#define IMXDPUV1_STORE9_START_START_MASK                     0x1U
#define IMXDPUV1_STORE9_START_START_SHIFT                    0U

/* Register: IMXDPUV1_store9_EncoderStatus */
#define IMXDPUV1_STORE9_ENCODERSTATUS                        ((uint32_t)(0x4040))
#define IMXDPUV1_STORE9_ENCODERSTATUS_OFFSET                 ((uint32_t)(0x40))
#define IMXDPUV1_STORE9_ENCODERSTATUS_RESET_VALUE            0x1FFFFFFFU
#define IMXDPUV1_STORE9_ENCODERSTATUS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_STORE9_ENCODERSTATUS_RLEWORDS_MASK          0x1FFFFFFFU
#define IMXDPUV1_STORE9_ENCODERSTATUS_RLEWORDS_SHIFT         0U
#define IMXDPUV1_STORE9_ENCODERSTATUS_BUFFERTOOSMALL_MASK    0x80000000U
#define IMXDPUV1_STORE9_ENCODERSTATUS_BUFFERTOOSMALL_SHIFT   31U

/* Register: IMXDPUV1_store9_WriteAddress */
#define IMXDPUV1_STORE9_WRITEADDRESS                         ((uint32_t)(0x4044))
#define IMXDPUV1_STORE9_WRITEADDRESS_OFFSET                  ((uint32_t)(0x44))
#define IMXDPUV1_STORE9_WRITEADDRESS_RESET_VALUE             0U
#define IMXDPUV1_STORE9_WRITEADDRESS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_STORE9_WRITEADDRESS_WRITEADDRESS_MASK       0xFFFFFFFFU
#define IMXDPUV1_STORE9_WRITEADDRESS_WRITEADDRESS_SHIFT      0U

/* Register: IMXDPUV1_store9_FrameProperties */
#define IMXDPUV1_STORE9_FRAMEPROPERTIES                      ((uint32_t)(0x4048))
#define IMXDPUV1_STORE9_FRAMEPROPERTIES_OFFSET               ((uint32_t)(0x48))
#define IMXDPUV1_STORE9_FRAMEPROPERTIES_RESET_VALUE          0U
#define IMXDPUV1_STORE9_FRAMEPROPERTIES_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_STORE9_FRAMEPROPERTIES_FIELDID_MASK         0x1U
#define IMXDPUV1_STORE9_FRAMEPROPERTIES_FIELDID_SHIFT        0U

/* Register: IMXDPUV1_store9_BurstBufferProperties */
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES                ((uint32_t)(0x404C))
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES_OFFSET         ((uint32_t)(0x4C))
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES_RESET_VALUE    0U
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES_RESET_MASK     0xFFFFE0FFU
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES_MAXBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_STORE9_BURSTBUFFERPROPERTIES_MAXBURSTLENGTH_SHIFT 8U

/* Register: IMXDPUV1_store9_LastControlWord */
#define IMXDPUV1_STORE9_LASTCONTROLWORD                      ((uint32_t)(0x4050))
#define IMXDPUV1_STORE9_LASTCONTROLWORD_OFFSET               ((uint32_t)(0x50))
#define IMXDPUV1_STORE9_LASTCONTROLWORD_RESET_VALUE          0U
#define IMXDPUV1_STORE9_LASTCONTROLWORD_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_STORE9_LASTCONTROLWORD_L_VAL_MASK           0xFFFFFFFFU
#define IMXDPUV1_STORE9_LASTCONTROLWORD_L_VAL_SHIFT          0U

/* Register: IMXDPUV1_store9_PerfCounter */
#define IMXDPUV1_STORE9_PERFCOUNTER                          ((uint32_t)(0x4054))
#define IMXDPUV1_STORE9_PERFCOUNTER_OFFSET                   ((uint32_t)(0x54))
#define IMXDPUV1_STORE9_PERFCOUNTER_RESET_VALUE              0U
#define IMXDPUV1_STORE9_PERFCOUNTER_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_STORE9_PERFCOUNTER_PERFRESULT_MASK          0xFFFFFFFFU
#define IMXDPUV1_STORE9_PERFCOUNTER_PERFRESULT_SHIFT         0U

/* Register: IMXDPUV1_store9_Status */
#define IMXDPUV1_STORE9_STATUS                               ((uint32_t)(0x4058))
#define IMXDPUV1_STORE9_STATUS_OFFSET                        ((uint32_t)(0x58))
#define IMXDPUV1_STORE9_STATUS_RESET_VALUE                   0U
#define IMXDPUV1_STORE9_STATUS_RESET_MASK                    0xFFFFFF8EU
#define IMXDPUV1_STORE9_STATUS_STATUSBUSY_MASK               0x1U
#define IMXDPUV1_STORE9_STATUS_STATUSBUSY_SHIFT              0U
#define IMXDPUV1_STORE9_STATUS_STATUSBUFFERSIDLE_MASK        0x10U
#define IMXDPUV1_STORE9_STATUS_STATUSBUFFERSIDLE_SHIFT       4U
#define IMXDPUV1_STORE9_STATUS_STATUSREQUEST_MASK            0x20U
#define IMXDPUV1_STORE9_STATUS_STATUSREQUEST_SHIFT           5U
#define IMXDPUV1_STORE9_STATUS_STATUSCOMPLETE_MASK           0x40U
#define IMXDPUV1_STORE9_STATUS_STATUSCOMPLETE_SHIFT          6U
#define IMXDPUV1_STORE9_STATUS_PIXELBUSERROR_MASK            0x100U
#define IMXDPUV1_STORE9_STATUS_PIXELBUSERROR_SHIFT           8U
#define IMXDPUV1_STORE9_STATUS_ENCODEROVERFLOW_MASK          0x10000U
#define IMXDPUV1_STORE9_STATUS_ENCODEROVERFLOW_SHIFT         16U
#define IMXDPUV1_STORE9_STATUS_ENCODERSTALLPIXEL_MASK        0x20000U
#define IMXDPUV1_STORE9_STATUS_ENCODERSTALLPIXEL_SHIFT       17U

/* Register: IMXDPUV1_constframe0_LockUnlock */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK                      ((uint32_t)(0x4400))
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CONSTFRAME0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_constframe0_LockStatus */
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS                      ((uint32_t)(0x4404))
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_CONSTFRAME0_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_constframe0_StaticControl */
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL                   ((uint32_t)(0x4408))
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_CONSTFRAME0_STATICCONTROL_SHDEN_SHIFT       0U

/* Register: IMXDPUV1_constframe0_FrameDimensions */
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS                 ((uint32_t)(0x440C))
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_OFFSET          ((uint32_t)(0xC))
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_RESET_VALUE     0xEF013FU
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_CONSTFRAME0_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_constframe0_ConstantColor */
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR                   ((uint32_t)(0x4410))
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_OFFSET            ((uint32_t)(0x10))
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTALPHA_MASK 0xFFU
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTALPHA_SHIFT 0U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTBLUE_MASK 0xFF00U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTBLUE_SHIFT 8U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTGREEN_MASK 0xFF0000U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTGREEN_SHIFT 16U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTRED_MASK  0xFF000000U
#define IMXDPUV1_CONSTFRAME0_CONSTANTCOLOR_CONSTANTRED_SHIFT 24U

/* Register: IMXDPUV1_constframe0_ControlTrigger */
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER                  ((uint32_t)(0x4414))
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER_OFFSET           ((uint32_t)(0x14))
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER_RESET_VALUE      0U
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER_RESET_MASK       0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER_SHDTOKGEN_MASK   0x1U
#define IMXDPUV1_CONSTFRAME0_CONTROLTRIGGER_SHDTOKGEN_SHIFT  0U

/* Register: IMXDPUV1_constframe0_Start */
#define IMXDPUV1_CONSTFRAME0_START                           ((uint32_t)(0x4418))
#define IMXDPUV1_CONSTFRAME0_START_OFFSET                    ((uint32_t)(0x18))
#define IMXDPUV1_CONSTFRAME0_START_RESET_VALUE               0U
#define IMXDPUV1_CONSTFRAME0_START_RESET_MASK                0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME0_START_START_MASK                0x1U
#define IMXDPUV1_CONSTFRAME0_START_START_SHIFT               0U

/* Register: IMXDPUV1_constframe0_Status */
#define IMXDPUV1_CONSTFRAME0_STATUS                          ((uint32_t)(0x441C))
#define IMXDPUV1_CONSTFRAME0_STATUS_OFFSET                   ((uint32_t)(0x1C))
#define IMXDPUV1_CONSTFRAME0_STATUS_RESET_VALUE              0U
#define IMXDPUV1_CONSTFRAME0_STATUS_RESET_MASK               0xFFFFFFFCU
#define IMXDPUV1_CONSTFRAME0_STATUS_STATUSBUSY_MASK          0x1U
#define IMXDPUV1_CONSTFRAME0_STATUS_STATUSBUSY_SHIFT         0U
#define IMXDPUV1_CONSTFRAME0_STATUS_SHADOWSTATUS_MASK        0x2U
#define IMXDPUV1_CONSTFRAME0_STATUS_SHADOWSTATUS_SHIFT       1U

/* Register: IMXDPUV1_extdst0_LockUnlock */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK                          ((uint32_t)(0x4800))
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_EXTDST0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_extdst0_LockStatus */
#define IMXDPUV1_EXTDST0_LOCKSTATUS                          ((uint32_t)(0x4804))
#define IMXDPUV1_EXTDST0_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_EXTDST0_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_EXTDST0_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_extdst0_StaticControl */
#define IMXDPUV1_EXTDST0_STATICCONTROL                       ((uint32_t)(0x4808))
#define IMXDPUV1_EXTDST0_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_EXTDST0_STATICCONTROL_RESET_VALUE           0x100U
#define IMXDPUV1_EXTDST0_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_EXTDST0_STATICCONTROL_SHDEN_SHIFT           0U
#define IMXDPUV1_EXTDST0_STATICCONTROL_KICK_MODE_MASK        0x100U
#define IMXDPUV1_EXTDST0_STATICCONTROL_KICK_MODE_SHIFT       8U
/* Field Value: KICK_MODE__SOFTWARE, kick generation by KICK field only  */
#define IMXDPUV1_EXTDST0_STATICCONTROL_KICK_MODE__SOFTWARE   0U
/* Field Value: KICK_MODE__EXTERNAL, kick signal from external allowed  */
#define IMXDPUV1_EXTDST0_STATICCONTROL_KICK_MODE__EXTERNAL   0x1U
#define IMXDPUV1_EXTDST0_STATICCONTROL_PERFCOUNTMODE_MASK    0x1000U
#define IMXDPUV1_EXTDST0_STATICCONTROL_PERFCOUNTMODE_SHIFT   12U

/* Register: IMXDPUV1_extdst0_Control */
#define IMXDPUV1_EXTDST0_CONTROL                             ((uint32_t)(0x480C))
#define IMXDPUV1_EXTDST0_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_EXTDST0_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_EXTDST0_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_CONTROL_GAMMAAPPLYENABLE_MASK       0x1U
#define IMXDPUV1_EXTDST0_CONTROL_GAMMAAPPLYENABLE_SHIFT      0U

/* Register: IMXDPUV1_extdst0_SoftwareKick */
#define IMXDPUV1_EXTDST0_SOFTWAREKICK                        ((uint32_t)(0x4810))
#define IMXDPUV1_EXTDST0_SOFTWAREKICK_OFFSET                 ((uint32_t)(0x10))
#define IMXDPUV1_EXTDST0_SOFTWAREKICK_RESET_VALUE            0U
#define IMXDPUV1_EXTDST0_SOFTWAREKICK_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_SOFTWAREKICK_KICK_MASK              0x1U
#define IMXDPUV1_EXTDST0_SOFTWAREKICK_KICK_SHIFT             0U

/* Register: IMXDPUV1_extdst0_Status */
#define IMXDPUV1_EXTDST0_STATUS                              ((uint32_t)(0x4814))
#define IMXDPUV1_EXTDST0_STATUS_OFFSET                       ((uint32_t)(0x14))
#define IMXDPUV1_EXTDST0_STATUS_RESET_VALUE                  0U
#define IMXDPUV1_EXTDST0_STATUS_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_STATUS_CNT_ERR_STS_MASK             0x1U
#define IMXDPUV1_EXTDST0_STATUS_CNT_ERR_STS_SHIFT            0U

/* Register: IMXDPUV1_extdst0_ControlWord */
#define IMXDPUV1_EXTDST0_CONTROLWORD                         ((uint32_t)(0x4818))
#define IMXDPUV1_EXTDST0_CONTROLWORD_OFFSET                  ((uint32_t)(0x18))
#define IMXDPUV1_EXTDST0_CONTROLWORD_RESET_VALUE             0U
#define IMXDPUV1_EXTDST0_CONTROLWORD_RESET_MASK              0U
#define IMXDPUV1_EXTDST0_CONTROLWORD_CW_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_CONTROLWORD_CW_VAL_SHIFT            0U

/* Register: IMXDPUV1_extdst0_CurPixelCnt */
#define IMXDPUV1_EXTDST0_CURPIXELCNT                         ((uint32_t)(0x481C))
#define IMXDPUV1_EXTDST0_CURPIXELCNT_OFFSET                  ((uint32_t)(0x1C))
#define IMXDPUV1_EXTDST0_CURPIXELCNT_RESET_VALUE             0U
#define IMXDPUV1_EXTDST0_CURPIXELCNT_RESET_MASK              0U
#define IMXDPUV1_EXTDST0_CURPIXELCNT_C_XVAL_MASK             0xFFFFU
#define IMXDPUV1_EXTDST0_CURPIXELCNT_C_XVAL_SHIFT            0U
#define IMXDPUV1_EXTDST0_CURPIXELCNT_C_YVAL_MASK             0xFFFF0000U
#define IMXDPUV1_EXTDST0_CURPIXELCNT_C_YVAL_SHIFT            16U

/* Register: IMXDPUV1_extdst0_LastPixelCnt */
#define IMXDPUV1_EXTDST0_LASTPIXELCNT                        ((uint32_t)(0x4820))
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_OFFSET                 ((uint32_t)(0x20))
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_RESET_VALUE            0U
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_RESET_MASK             0U
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_L_XVAL_MASK            0xFFFFU
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_L_XVAL_SHIFT           0U
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_L_YVAL_MASK            0xFFFF0000U
#define IMXDPUV1_EXTDST0_LASTPIXELCNT_L_YVAL_SHIFT           16U

/* Register: IMXDPUV1_extdst0_PerfCounter */
#define IMXDPUV1_EXTDST0_PERFCOUNTER                         ((uint32_t)(0x4824))
#define IMXDPUV1_EXTDST0_PERFCOUNTER_OFFSET                  ((uint32_t)(0x24))
#define IMXDPUV1_EXTDST0_PERFCOUNTER_RESET_VALUE             0U
#define IMXDPUV1_EXTDST0_PERFCOUNTER_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_PERFCOUNTER_PERFRESULT_MASK         0xFFFFFFFFU
#define IMXDPUV1_EXTDST0_PERFCOUNTER_PERFRESULT_SHIFT        0U

/* Register: IMXDPUV1_constframe4_LockUnlock */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK                      ((uint32_t)(0x4C00))
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CONSTFRAME4_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_constframe4_LockStatus */
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS                      ((uint32_t)(0x4C04))
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_CONSTFRAME4_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_constframe4_StaticControl */
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL                   ((uint32_t)(0x4C08))
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_CONSTFRAME4_STATICCONTROL_SHDEN_SHIFT       0U

/* Register: IMXDPUV1_constframe4_FrameDimensions */
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS                 ((uint32_t)(0x4C0C))
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_OFFSET          ((uint32_t)(0xC))
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_RESET_VALUE     0xEF013FU
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_CONSTFRAME4_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_constframe4_ConstantColor */
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR                   ((uint32_t)(0x4C10))
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_OFFSET            ((uint32_t)(0x10))
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTALPHA_MASK 0xFFU
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTALPHA_SHIFT 0U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTBLUE_MASK 0xFF00U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTBLUE_SHIFT 8U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTGREEN_MASK 0xFF0000U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTGREEN_SHIFT 16U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTRED_MASK  0xFF000000U
#define IMXDPUV1_CONSTFRAME4_CONSTANTCOLOR_CONSTANTRED_SHIFT 24U

/* Register: IMXDPUV1_constframe4_ControlTrigger */
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER                  ((uint32_t)(0x4C14))
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER_OFFSET           ((uint32_t)(0x14))
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER_RESET_VALUE      0U
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER_RESET_MASK       0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER_SHDTOKGEN_MASK   0x1U
#define IMXDPUV1_CONSTFRAME4_CONTROLTRIGGER_SHDTOKGEN_SHIFT  0U

/* Register: IMXDPUV1_constframe4_Start */
#define IMXDPUV1_CONSTFRAME4_START                           ((uint32_t)(0x4C18))
#define IMXDPUV1_CONSTFRAME4_START_OFFSET                    ((uint32_t)(0x18))
#define IMXDPUV1_CONSTFRAME4_START_RESET_VALUE               0U
#define IMXDPUV1_CONSTFRAME4_START_RESET_MASK                0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME4_START_START_MASK                0x1U
#define IMXDPUV1_CONSTFRAME4_START_START_SHIFT               0U

/* Register: IMXDPUV1_constframe4_Status */
#define IMXDPUV1_CONSTFRAME4_STATUS                          ((uint32_t)(0x4C1C))
#define IMXDPUV1_CONSTFRAME4_STATUS_OFFSET                   ((uint32_t)(0x1C))
#define IMXDPUV1_CONSTFRAME4_STATUS_RESET_VALUE              0U
#define IMXDPUV1_CONSTFRAME4_STATUS_RESET_MASK               0xFFFFFFFCU
#define IMXDPUV1_CONSTFRAME4_STATUS_STATUSBUSY_MASK          0x1U
#define IMXDPUV1_CONSTFRAME4_STATUS_STATUSBUSY_SHIFT         0U
#define IMXDPUV1_CONSTFRAME4_STATUS_SHADOWSTATUS_MASK        0x2U
#define IMXDPUV1_CONSTFRAME4_STATUS_SHADOWSTATUS_SHIFT       1U

/* Register: IMXDPUV1_extdst4_LockUnlock */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK                          ((uint32_t)(0x5000))
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_EXTDST4_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_extdst4_LockStatus */
#define IMXDPUV1_EXTDST4_LOCKSTATUS                          ((uint32_t)(0x5004))
#define IMXDPUV1_EXTDST4_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_EXTDST4_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_EXTDST4_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_extdst4_StaticControl */
#define IMXDPUV1_EXTDST4_STATICCONTROL                       ((uint32_t)(0x5008))
#define IMXDPUV1_EXTDST4_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_EXTDST4_STATICCONTROL_RESET_VALUE           0x100U
#define IMXDPUV1_EXTDST4_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_EXTDST4_STATICCONTROL_SHDEN_SHIFT           0U
#define IMXDPUV1_EXTDST4_STATICCONTROL_KICK_MODE_MASK        0x100U
#define IMXDPUV1_EXTDST4_STATICCONTROL_KICK_MODE_SHIFT       8U
/* Field Value: KICK_MODE__SOFTWARE, kick generation by KICK field only  */
#define IMXDPUV1_EXTDST4_STATICCONTROL_KICK_MODE__SOFTWARE   0U
/* Field Value: KICK_MODE__EXTERNAL, kick signal from external allowed  */
#define IMXDPUV1_EXTDST4_STATICCONTROL_KICK_MODE__EXTERNAL   0x1U
#define IMXDPUV1_EXTDST4_STATICCONTROL_PERFCOUNTMODE_MASK    0x1000U
#define IMXDPUV1_EXTDST4_STATICCONTROL_PERFCOUNTMODE_SHIFT   12U

/* Register: IMXDPUV1_extdst4_Control */
#define IMXDPUV1_EXTDST4_CONTROL                             ((uint32_t)(0x500C))
#define IMXDPUV1_EXTDST4_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_EXTDST4_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_EXTDST4_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_CONTROL_GAMMAAPPLYENABLE_MASK       0x1U
#define IMXDPUV1_EXTDST4_CONTROL_GAMMAAPPLYENABLE_SHIFT      0U

/* Register: IMXDPUV1_extdst4_SoftwareKick */
#define IMXDPUV1_EXTDST4_SOFTWAREKICK                        ((uint32_t)(0x5010))
#define IMXDPUV1_EXTDST4_SOFTWAREKICK_OFFSET                 ((uint32_t)(0x10))
#define IMXDPUV1_EXTDST4_SOFTWAREKICK_RESET_VALUE            0U
#define IMXDPUV1_EXTDST4_SOFTWAREKICK_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_SOFTWAREKICK_KICK_MASK              0x1U
#define IMXDPUV1_EXTDST4_SOFTWAREKICK_KICK_SHIFT             0U

/* Register: IMXDPUV1_extdst4_Status */
#define IMXDPUV1_EXTDST4_STATUS                              ((uint32_t)(0x5014))
#define IMXDPUV1_EXTDST4_STATUS_OFFSET                       ((uint32_t)(0x14))
#define IMXDPUV1_EXTDST4_STATUS_RESET_VALUE                  0U
#define IMXDPUV1_EXTDST4_STATUS_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_STATUS_CNT_ERR_STS_MASK             0x1U
#define IMXDPUV1_EXTDST4_STATUS_CNT_ERR_STS_SHIFT            0U

/* Register: IMXDPUV1_extdst4_ControlWord */
#define IMXDPUV1_EXTDST4_CONTROLWORD                         ((uint32_t)(0x5018))
#define IMXDPUV1_EXTDST4_CONTROLWORD_OFFSET                  ((uint32_t)(0x18))
#define IMXDPUV1_EXTDST4_CONTROLWORD_RESET_VALUE             0U
#define IMXDPUV1_EXTDST4_CONTROLWORD_RESET_MASK              0U
#define IMXDPUV1_EXTDST4_CONTROLWORD_CW_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_CONTROLWORD_CW_VAL_SHIFT            0U

/* Register: IMXDPUV1_extdst4_CurPixelCnt */
#define IMXDPUV1_EXTDST4_CURPIXELCNT                         ((uint32_t)(0x501C))
#define IMXDPUV1_EXTDST4_CURPIXELCNT_OFFSET                  ((uint32_t)(0x1C))
#define IMXDPUV1_EXTDST4_CURPIXELCNT_RESET_VALUE             0U
#define IMXDPUV1_EXTDST4_CURPIXELCNT_RESET_MASK              0U
#define IMXDPUV1_EXTDST4_CURPIXELCNT_C_XVAL_MASK             0xFFFFU
#define IMXDPUV1_EXTDST4_CURPIXELCNT_C_XVAL_SHIFT            0U
#define IMXDPUV1_EXTDST4_CURPIXELCNT_C_YVAL_MASK             0xFFFF0000U
#define IMXDPUV1_EXTDST4_CURPIXELCNT_C_YVAL_SHIFT            16U

/* Register: IMXDPUV1_extdst4_LastPixelCnt */
#define IMXDPUV1_EXTDST4_LASTPIXELCNT                        ((uint32_t)(0x5020))
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_OFFSET                 ((uint32_t)(0x20))
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_RESET_VALUE            0U
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_RESET_MASK             0U
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_L_XVAL_MASK            0xFFFFU
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_L_XVAL_SHIFT           0U
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_L_YVAL_MASK            0xFFFF0000U
#define IMXDPUV1_EXTDST4_LASTPIXELCNT_L_YVAL_SHIFT           16U

/* Register: IMXDPUV1_extdst4_PerfCounter */
#define IMXDPUV1_EXTDST4_PERFCOUNTER                         ((uint32_t)(0x5024))
#define IMXDPUV1_EXTDST4_PERFCOUNTER_OFFSET                  ((uint32_t)(0x24))
#define IMXDPUV1_EXTDST4_PERFCOUNTER_RESET_VALUE             0U
#define IMXDPUV1_EXTDST4_PERFCOUNTER_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_PERFCOUNTER_PERFRESULT_MASK         0xFFFFFFFFU
#define IMXDPUV1_EXTDST4_PERFCOUNTER_PERFRESULT_SHIFT        0U

/* Register: IMXDPUV1_constframe1_LockUnlock */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK                      ((uint32_t)(0x5400))
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CONSTFRAME1_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_constframe1_LockStatus */
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS                      ((uint32_t)(0x5404))
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_CONSTFRAME1_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_constframe1_StaticControl */
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL                   ((uint32_t)(0x5408))
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_CONSTFRAME1_STATICCONTROL_SHDEN_SHIFT       0U

/* Register: IMXDPUV1_constframe1_FrameDimensions */
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS                 ((uint32_t)(0x540C))
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_OFFSET          ((uint32_t)(0xC))
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_RESET_VALUE     0xEF013FU
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_CONSTFRAME1_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_constframe1_ConstantColor */
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR                   ((uint32_t)(0x5410))
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_OFFSET            ((uint32_t)(0x10))
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTALPHA_MASK 0xFFU
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTALPHA_SHIFT 0U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTBLUE_MASK 0xFF00U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTBLUE_SHIFT 8U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTGREEN_MASK 0xFF0000U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTGREEN_SHIFT 16U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTRED_MASK  0xFF000000U
#define IMXDPUV1_CONSTFRAME1_CONSTANTCOLOR_CONSTANTRED_SHIFT 24U

/* Register: IMXDPUV1_constframe1_ControlTrigger */
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER                  ((uint32_t)(0x5414))
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER_OFFSET           ((uint32_t)(0x14))
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER_RESET_VALUE      0U
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER_RESET_MASK       0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER_SHDTOKGEN_MASK   0x1U
#define IMXDPUV1_CONSTFRAME1_CONTROLTRIGGER_SHDTOKGEN_SHIFT  0U

/* Register: IMXDPUV1_constframe1_Start */
#define IMXDPUV1_CONSTFRAME1_START                           ((uint32_t)(0x5418))
#define IMXDPUV1_CONSTFRAME1_START_OFFSET                    ((uint32_t)(0x18))
#define IMXDPUV1_CONSTFRAME1_START_RESET_VALUE               0U
#define IMXDPUV1_CONSTFRAME1_START_RESET_MASK                0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME1_START_START_MASK                0x1U
#define IMXDPUV1_CONSTFRAME1_START_START_SHIFT               0U

/* Register: IMXDPUV1_constframe1_Status */
#define IMXDPUV1_CONSTFRAME1_STATUS                          ((uint32_t)(0x541C))
#define IMXDPUV1_CONSTFRAME1_STATUS_OFFSET                   ((uint32_t)(0x1C))
#define IMXDPUV1_CONSTFRAME1_STATUS_RESET_VALUE              0U
#define IMXDPUV1_CONSTFRAME1_STATUS_RESET_MASK               0xFFFFFFFCU
#define IMXDPUV1_CONSTFRAME1_STATUS_STATUSBUSY_MASK          0x1U
#define IMXDPUV1_CONSTFRAME1_STATUS_STATUSBUSY_SHIFT         0U
#define IMXDPUV1_CONSTFRAME1_STATUS_SHADOWSTATUS_MASK        0x2U
#define IMXDPUV1_CONSTFRAME1_STATUS_SHADOWSTATUS_SHIFT       1U

/* Register: IMXDPUV1_extdst1_LockUnlock */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK                          ((uint32_t)(0x5800))
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_EXTDST1_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_extdst1_LockStatus */
#define IMXDPUV1_EXTDST1_LOCKSTATUS                          ((uint32_t)(0x5804))
#define IMXDPUV1_EXTDST1_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_EXTDST1_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_EXTDST1_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_extdst1_StaticControl */
#define IMXDPUV1_EXTDST1_STATICCONTROL                       ((uint32_t)(0x5808))
#define IMXDPUV1_EXTDST1_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_EXTDST1_STATICCONTROL_RESET_VALUE           0x100U
#define IMXDPUV1_EXTDST1_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_EXTDST1_STATICCONTROL_SHDEN_SHIFT           0U
#define IMXDPUV1_EXTDST1_STATICCONTROL_KICK_MODE_MASK        0x100U
#define IMXDPUV1_EXTDST1_STATICCONTROL_KICK_MODE_SHIFT       8U
/* Field Value: KICK_MODE__SOFTWARE, kick generation by KICK field only  */
#define IMXDPUV1_EXTDST1_STATICCONTROL_KICK_MODE__SOFTWARE   0U
/* Field Value: KICK_MODE__EXTERNAL, kick signal from external allowed  */
#define IMXDPUV1_EXTDST1_STATICCONTROL_KICK_MODE__EXTERNAL   0x1U
#define IMXDPUV1_EXTDST1_STATICCONTROL_PERFCOUNTMODE_MASK    0x1000U
#define IMXDPUV1_EXTDST1_STATICCONTROL_PERFCOUNTMODE_SHIFT   12U

/* Register: IMXDPUV1_extdst1_Control */
#define IMXDPUV1_EXTDST1_CONTROL                             ((uint32_t)(0x580C))
#define IMXDPUV1_EXTDST1_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_EXTDST1_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_EXTDST1_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_CONTROL_GAMMAAPPLYENABLE_MASK       0x1U
#define IMXDPUV1_EXTDST1_CONTROL_GAMMAAPPLYENABLE_SHIFT      0U

/* Register: IMXDPUV1_extdst1_SoftwareKick */
#define IMXDPUV1_EXTDST1_SOFTWAREKICK                        ((uint32_t)(0x5810))
#define IMXDPUV1_EXTDST1_SOFTWAREKICK_OFFSET                 ((uint32_t)(0x10))
#define IMXDPUV1_EXTDST1_SOFTWAREKICK_RESET_VALUE            0U
#define IMXDPUV1_EXTDST1_SOFTWAREKICK_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_SOFTWAREKICK_KICK_MASK              0x1U
#define IMXDPUV1_EXTDST1_SOFTWAREKICK_KICK_SHIFT             0U

/* Register: IMXDPUV1_extdst1_Status */
#define IMXDPUV1_EXTDST1_STATUS                              ((uint32_t)(0x5814))
#define IMXDPUV1_EXTDST1_STATUS_OFFSET                       ((uint32_t)(0x14))
#define IMXDPUV1_EXTDST1_STATUS_RESET_VALUE                  0U
#define IMXDPUV1_EXTDST1_STATUS_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_STATUS_CNT_ERR_STS_MASK             0x1U
#define IMXDPUV1_EXTDST1_STATUS_CNT_ERR_STS_SHIFT            0U

/* Register: IMXDPUV1_extdst1_ControlWord */
#define IMXDPUV1_EXTDST1_CONTROLWORD                         ((uint32_t)(0x5818))
#define IMXDPUV1_EXTDST1_CONTROLWORD_OFFSET                  ((uint32_t)(0x18))
#define IMXDPUV1_EXTDST1_CONTROLWORD_RESET_VALUE             0U
#define IMXDPUV1_EXTDST1_CONTROLWORD_RESET_MASK              0U
#define IMXDPUV1_EXTDST1_CONTROLWORD_CW_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_CONTROLWORD_CW_VAL_SHIFT            0U

/* Register: IMXDPUV1_extdst1_CurPixelCnt */
#define IMXDPUV1_EXTDST1_CURPIXELCNT                         ((uint32_t)(0x581C))
#define IMXDPUV1_EXTDST1_CURPIXELCNT_OFFSET                  ((uint32_t)(0x1C))
#define IMXDPUV1_EXTDST1_CURPIXELCNT_RESET_VALUE             0U
#define IMXDPUV1_EXTDST1_CURPIXELCNT_RESET_MASK              0U
#define IMXDPUV1_EXTDST1_CURPIXELCNT_C_XVAL_MASK             0xFFFFU
#define IMXDPUV1_EXTDST1_CURPIXELCNT_C_XVAL_SHIFT            0U
#define IMXDPUV1_EXTDST1_CURPIXELCNT_C_YVAL_MASK             0xFFFF0000U
#define IMXDPUV1_EXTDST1_CURPIXELCNT_C_YVAL_SHIFT            16U

/* Register: IMXDPUV1_extdst1_LastPixelCnt */
#define IMXDPUV1_EXTDST1_LASTPIXELCNT                        ((uint32_t)(0x5820))
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_OFFSET                 ((uint32_t)(0x20))
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_RESET_VALUE            0U
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_RESET_MASK             0U
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_L_XVAL_MASK            0xFFFFU
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_L_XVAL_SHIFT           0U
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_L_YVAL_MASK            0xFFFF0000U
#define IMXDPUV1_EXTDST1_LASTPIXELCNT_L_YVAL_SHIFT           16U

/* Register: IMXDPUV1_extdst1_PerfCounter */
#define IMXDPUV1_EXTDST1_PERFCOUNTER                         ((uint32_t)(0x5824))
#define IMXDPUV1_EXTDST1_PERFCOUNTER_OFFSET                  ((uint32_t)(0x24))
#define IMXDPUV1_EXTDST1_PERFCOUNTER_RESET_VALUE             0U
#define IMXDPUV1_EXTDST1_PERFCOUNTER_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_PERFCOUNTER_PERFRESULT_MASK         0xFFFFFFFFU
#define IMXDPUV1_EXTDST1_PERFCOUNTER_PERFRESULT_SHIFT        0U

/* Register: IMXDPUV1_constframe5_LockUnlock */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK                      ((uint32_t)(0x5C00))
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_CONSTFRAME5_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_constframe5_LockStatus */
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS                      ((uint32_t)(0x5C04))
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_CONSTFRAME5_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_constframe5_StaticControl */
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL                   ((uint32_t)(0x5C08))
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_CONSTFRAME5_STATICCONTROL_SHDEN_SHIFT       0U

/* Register: IMXDPUV1_constframe5_FrameDimensions */
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS                 ((uint32_t)(0x5C0C))
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_OFFSET          ((uint32_t)(0xC))
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_RESET_VALUE     0xEF013FU
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_CONSTFRAME5_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_constframe5_ConstantColor */
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR                   ((uint32_t)(0x5C10))
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_OFFSET            ((uint32_t)(0x10))
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_RESET_VALUE       0U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTALPHA_MASK 0xFFU
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTALPHA_SHIFT 0U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTBLUE_MASK 0xFF00U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTBLUE_SHIFT 8U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTGREEN_MASK 0xFF0000U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTGREEN_SHIFT 16U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTRED_MASK  0xFF000000U
#define IMXDPUV1_CONSTFRAME5_CONSTANTCOLOR_CONSTANTRED_SHIFT 24U

/* Register: IMXDPUV1_constframe5_ControlTrigger */
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER                  ((uint32_t)(0x5C14))
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER_OFFSET           ((uint32_t)(0x14))
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER_RESET_VALUE      0U
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER_RESET_MASK       0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER_SHDTOKGEN_MASK   0x1U
#define IMXDPUV1_CONSTFRAME5_CONTROLTRIGGER_SHDTOKGEN_SHIFT  0U

/* Register: IMXDPUV1_constframe5_Start */
#define IMXDPUV1_CONSTFRAME5_START                           ((uint32_t)(0x5C18))
#define IMXDPUV1_CONSTFRAME5_START_OFFSET                    ((uint32_t)(0x18))
#define IMXDPUV1_CONSTFRAME5_START_RESET_VALUE               0U
#define IMXDPUV1_CONSTFRAME5_START_RESET_MASK                0xFFFFFFFEU
#define IMXDPUV1_CONSTFRAME5_START_START_MASK                0x1U
#define IMXDPUV1_CONSTFRAME5_START_START_SHIFT               0U

/* Register: IMXDPUV1_constframe5_Status */
#define IMXDPUV1_CONSTFRAME5_STATUS                          ((uint32_t)(0x5C1C))
#define IMXDPUV1_CONSTFRAME5_STATUS_OFFSET                   ((uint32_t)(0x1C))
#define IMXDPUV1_CONSTFRAME5_STATUS_RESET_VALUE              0U
#define IMXDPUV1_CONSTFRAME5_STATUS_RESET_MASK               0xFFFFFFFCU
#define IMXDPUV1_CONSTFRAME5_STATUS_STATUSBUSY_MASK          0x1U
#define IMXDPUV1_CONSTFRAME5_STATUS_STATUSBUSY_SHIFT         0U
#define IMXDPUV1_CONSTFRAME5_STATUS_SHADOWSTATUS_MASK        0x2U
#define IMXDPUV1_CONSTFRAME5_STATUS_SHADOWSTATUS_SHIFT       1U

/* Register: IMXDPUV1_extdst5_LockUnlock */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK                          ((uint32_t)(0x6000))
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_EXTDST5_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_extdst5_LockStatus */
#define IMXDPUV1_EXTDST5_LOCKSTATUS                          ((uint32_t)(0x6004))
#define IMXDPUV1_EXTDST5_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_EXTDST5_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_EXTDST5_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_extdst5_StaticControl */
#define IMXDPUV1_EXTDST5_STATICCONTROL                       ((uint32_t)(0x6008))
#define IMXDPUV1_EXTDST5_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_EXTDST5_STATICCONTROL_RESET_VALUE           0x100U
#define IMXDPUV1_EXTDST5_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_EXTDST5_STATICCONTROL_SHDEN_SHIFT           0U
#define IMXDPUV1_EXTDST5_STATICCONTROL_KICK_MODE_MASK        0x100U
#define IMXDPUV1_EXTDST5_STATICCONTROL_KICK_MODE_SHIFT       8U
/* Field Value: KICK_MODE__SOFTWARE, kick generation by KICK field only  */
#define IMXDPUV1_EXTDST5_STATICCONTROL_KICK_MODE__SOFTWARE   0U
/* Field Value: KICK_MODE__EXTERNAL, kick signal from external allowed  */
#define IMXDPUV1_EXTDST5_STATICCONTROL_KICK_MODE__EXTERNAL   0x1U
#define IMXDPUV1_EXTDST5_STATICCONTROL_PERFCOUNTMODE_MASK    0x1000U
#define IMXDPUV1_EXTDST5_STATICCONTROL_PERFCOUNTMODE_SHIFT   12U

/* Register: IMXDPUV1_extdst5_Control */
#define IMXDPUV1_EXTDST5_CONTROL                             ((uint32_t)(0x600C))
#define IMXDPUV1_EXTDST5_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_EXTDST5_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_EXTDST5_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_CONTROL_GAMMAAPPLYENABLE_MASK       0x1U
#define IMXDPUV1_EXTDST5_CONTROL_GAMMAAPPLYENABLE_SHIFT      0U

/* Register: IMXDPUV1_extdst5_SoftwareKick */
#define IMXDPUV1_EXTDST5_SOFTWAREKICK                        ((uint32_t)(0x6010))
#define IMXDPUV1_EXTDST5_SOFTWAREKICK_OFFSET                 ((uint32_t)(0x10))
#define IMXDPUV1_EXTDST5_SOFTWAREKICK_RESET_VALUE            0U
#define IMXDPUV1_EXTDST5_SOFTWAREKICK_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_SOFTWAREKICK_KICK_MASK              0x1U
#define IMXDPUV1_EXTDST5_SOFTWAREKICK_KICK_SHIFT             0U

/* Register: IMXDPUV1_extdst5_Status */
#define IMXDPUV1_EXTDST5_STATUS                              ((uint32_t)(0x6014))
#define IMXDPUV1_EXTDST5_STATUS_OFFSET                       ((uint32_t)(0x14))
#define IMXDPUV1_EXTDST5_STATUS_RESET_VALUE                  0U
#define IMXDPUV1_EXTDST5_STATUS_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_STATUS_CNT_ERR_STS_MASK             0x1U
#define IMXDPUV1_EXTDST5_STATUS_CNT_ERR_STS_SHIFT            0U

/* Register: IMXDPUV1_extdst5_ControlWord */
#define IMXDPUV1_EXTDST5_CONTROLWORD                         ((uint32_t)(0x6018))
#define IMXDPUV1_EXTDST5_CONTROLWORD_OFFSET                  ((uint32_t)(0x18))
#define IMXDPUV1_EXTDST5_CONTROLWORD_RESET_VALUE             0U
#define IMXDPUV1_EXTDST5_CONTROLWORD_RESET_MASK              0U
#define IMXDPUV1_EXTDST5_CONTROLWORD_CW_VAL_MASK             0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_CONTROLWORD_CW_VAL_SHIFT            0U

/* Register: IMXDPUV1_extdst5_CurPixelCnt */
#define IMXDPUV1_EXTDST5_CURPIXELCNT                         ((uint32_t)(0x601C))
#define IMXDPUV1_EXTDST5_CURPIXELCNT_OFFSET                  ((uint32_t)(0x1C))
#define IMXDPUV1_EXTDST5_CURPIXELCNT_RESET_VALUE             0U
#define IMXDPUV1_EXTDST5_CURPIXELCNT_RESET_MASK              0U
#define IMXDPUV1_EXTDST5_CURPIXELCNT_C_XVAL_MASK             0xFFFFU
#define IMXDPUV1_EXTDST5_CURPIXELCNT_C_XVAL_SHIFT            0U
#define IMXDPUV1_EXTDST5_CURPIXELCNT_C_YVAL_MASK             0xFFFF0000U
#define IMXDPUV1_EXTDST5_CURPIXELCNT_C_YVAL_SHIFT            16U

/* Register: IMXDPUV1_extdst5_LastPixelCnt */
#define IMXDPUV1_EXTDST5_LASTPIXELCNT                        ((uint32_t)(0x6020))
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_OFFSET                 ((uint32_t)(0x20))
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_RESET_VALUE            0U
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_RESET_MASK             0U
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_L_XVAL_MASK            0xFFFFU
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_L_XVAL_SHIFT           0U
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_L_YVAL_MASK            0xFFFF0000U
#define IMXDPUV1_EXTDST5_LASTPIXELCNT_L_YVAL_SHIFT           16U

/* Register: IMXDPUV1_extdst5_PerfCounter */
#define IMXDPUV1_EXTDST5_PERFCOUNTER                         ((uint32_t)(0x6024))
#define IMXDPUV1_EXTDST5_PERFCOUNTER_OFFSET                  ((uint32_t)(0x24))
#define IMXDPUV1_EXTDST5_PERFCOUNTER_RESET_VALUE             0U
#define IMXDPUV1_EXTDST5_PERFCOUNTER_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_PERFCOUNTER_PERFRESULT_MASK         0xFFFFFFFFU
#define IMXDPUV1_EXTDST5_PERFCOUNTER_PERFRESULT_SHIFT        0U

/* Register: IMXDPUV1_fetchwarp2_LockUnlock */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK                       ((uint32_t)(0x6400))
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_OFFSET                ((uint32_t)(0))
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_RESET_VALUE           0U
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_RESET_MASK            0U
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK_SHIFT      0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY  0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHWARP2_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetchwarp2_LockStatus */
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS                       ((uint32_t)(0x6404))
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_OFFSET                ((uint32_t)(0x4))
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_RESET_VALUE           0U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_LOCKSTATUS_MASK       0x1U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_LOCKSTATUS_SHIFT      0U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_PRIVILEGESTATUS_MASK  0x10U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_FREEZESTATUS_MASK     0x100U
#define IMXDPUV1_FETCHWARP2_LOCKSTATUS_FREEZESTATUS_SHIFT    8U

/* Register: IMXDPUV1_fetchwarp2_StaticControl */
#define IMXDPUV1_FETCHWARP2_STATICCONTROL                    ((uint32_t)(0x6408))
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_OFFSET             ((uint32_t)(0x8))
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_RESET_VALUE        0xFF000000U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_SHDEN_MASK         0x1U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_SHDEN_SHIFT        0U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_SHDLDREQSTICKY_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_STATICCONTROL_SHDLDREQSTICKY_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_BurstBufferManagement */
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT            ((uint32_t)(0x640C))
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_OFFSET     ((uint32_t)(0xC))
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress0 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0                     ((uint32_t)(0x6410))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0_OFFSET              ((uint32_t)(0x10))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0_BASEADDRESS0_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS0_BASEADDRESS0_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0          ((uint32_t)(0x6414))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_OFFSET   ((uint32_t)(0x14))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension0 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0           ((uint32_t)(0x6418))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_OFFSET    ((uint32_t)(0x18))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits0 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0              ((uint32_t)(0x641C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_OFFSET       ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift0 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0             ((uint32_t)(0x6420))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_OFFSET      ((uint32_t)(0x20))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset0 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0                     ((uint32_t)(0x6424))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_OFFSET              ((uint32_t)(0x24))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_LAYERXOFFSET0_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_LAYERYOFFSET0_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset0 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0                ((uint32_t)(0x6428))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_OFFSET         ((uint32_t)(0x28))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0            ((uint32_t)(0x642C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_OFFSET     ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor0 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0                   ((uint32_t)(0x6430))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_OFFSET            ((uint32_t)(0x30))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty0 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0                   ((uint32_t)(0x6434))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_OFFSET            ((uint32_t)(0x34))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RESET_VALUE       0x80000100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0_SHIFT   4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHAMASKENABLE0_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHAMASKENABLE0_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHAMASKENABLE0_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHAMASKENABLE0_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress1 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1                     ((uint32_t)(0x6438))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1_OFFSET              ((uint32_t)(0x38))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1_BASEADDRESS1_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS1_BASEADDRESS1_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes1 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1          ((uint32_t)(0x643C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_OFFSET   ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_STRIDE1_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_STRIDE1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension1 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1           ((uint32_t)(0x6440))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_OFFSET    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_LINEWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_LINEWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_LINECOUNT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION1_LINECOUNT1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits1 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1              ((uint32_t)(0x6444))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_OFFSET       ((uint32_t)(0x44))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSRED1_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_COMPONENTBITSRED1_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_ITUFORMAT1_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS1_ITUFORMAT1_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift1 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1             ((uint32_t)(0x6448))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_OFFSET      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset1 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1                     ((uint32_t)(0x644C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_OFFSET              ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_LAYERXOFFSET1_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_LAYERXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_LAYERYOFFSET1_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET1_LAYERYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset1 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1                ((uint32_t)(0x6450))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_OFFSET         ((uint32_t)(0x50))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions1 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1            ((uint32_t)(0x6454))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_OFFSET     ((uint32_t)(0x54))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor1 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1                   ((uint32_t)(0x6458))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_OFFSET            ((uint32_t)(0x58))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTALPHA1_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTBLUE1_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTGREEN1_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTRED1_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR1_CONSTANTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty1 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1                   ((uint32_t)(0x645C))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_OFFSET            ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1_SHIFT   4U
/* Field Value: TILEMODE1__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE1__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE1__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1__TILE_PAD 0x2U
/* Field Value: TILEMODE1__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_TILEMODE1__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHASRCENABLE1_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHASRCENABLE1_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHACONSTENABLE1_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHACONSTENABLE1_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHAMASKENABLE1_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHAMASKENABLE1_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHATRANSENABLE1_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_ALPHATRANSENABLE1_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHASRCENABLE1_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHASRCENABLE1_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHACONSTENABLE1_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHACONSTENABLE1_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHAMASKENABLE1_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHAMASKENABLE1_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHATRANSENABLE1_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_RGBALPHATRANSENABLE1_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_PREMULCONSTRGB1_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_PREMULCONSTRGB1_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE1__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1__OFF 0U
/* Field Value: YUVCONVERSIONMODE1__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE1__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE1__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_GAMMAREMOVEENABLE1_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_GAMMAREMOVEENABLE1_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_CLIPWINDOWENABLE1_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_CLIPWINDOWENABLE1_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_SOURCEBUFFERENABLE1_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY1_SOURCEBUFFERENABLE1_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress2 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2                     ((uint32_t)(0x6460))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2_OFFSET              ((uint32_t)(0x60))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2_BASEADDRESS2_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS2_BASEADDRESS2_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes2 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2          ((uint32_t)(0x6464))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_OFFSET   ((uint32_t)(0x64))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_STRIDE2_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_STRIDE2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension2 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2           ((uint32_t)(0x6468))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_OFFSET    ((uint32_t)(0x68))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_LINEWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_LINEWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_LINECOUNT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION2_LINECOUNT2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits2 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2              ((uint32_t)(0x646C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_OFFSET       ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSRED2_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_COMPONENTBITSRED2_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_ITUFORMAT2_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS2_ITUFORMAT2_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift2 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2             ((uint32_t)(0x6470))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_OFFSET      ((uint32_t)(0x70))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset2 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2                     ((uint32_t)(0x6474))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_OFFSET              ((uint32_t)(0x74))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_LAYERXOFFSET2_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_LAYERXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_LAYERYOFFSET2_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET2_LAYERYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset2 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2                ((uint32_t)(0x6478))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_OFFSET         ((uint32_t)(0x78))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions2 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2            ((uint32_t)(0x647C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_OFFSET     ((uint32_t)(0x7C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor2 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2                   ((uint32_t)(0x6480))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_OFFSET            ((uint32_t)(0x80))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTALPHA2_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTBLUE2_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTGREEN2_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTRED2_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR2_CONSTANTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty2 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2                   ((uint32_t)(0x6484))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_OFFSET            ((uint32_t)(0x84))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2_SHIFT   4U
/* Field Value: TILEMODE2__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE2__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE2__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2__TILE_PAD 0x2U
/* Field Value: TILEMODE2__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_TILEMODE2__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHASRCENABLE2_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHASRCENABLE2_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHACONSTENABLE2_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHACONSTENABLE2_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHAMASKENABLE2_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHAMASKENABLE2_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHATRANSENABLE2_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_ALPHATRANSENABLE2_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHASRCENABLE2_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHASRCENABLE2_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHACONSTENABLE2_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHACONSTENABLE2_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHAMASKENABLE2_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHAMASKENABLE2_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHATRANSENABLE2_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_RGBALPHATRANSENABLE2_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_PREMULCONSTRGB2_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_PREMULCONSTRGB2_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE2__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2__OFF 0U
/* Field Value: YUVCONVERSIONMODE2__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE2__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE2__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_GAMMAREMOVEENABLE2_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_GAMMAREMOVEENABLE2_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_CLIPWINDOWENABLE2_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_CLIPWINDOWENABLE2_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_SOURCEBUFFERENABLE2_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY2_SOURCEBUFFERENABLE2_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress3 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3                     ((uint32_t)(0x6488))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3_OFFSET              ((uint32_t)(0x88))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3_BASEADDRESS3_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS3_BASEADDRESS3_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes3 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3          ((uint32_t)(0x648C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_OFFSET   ((uint32_t)(0x8C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_STRIDE3_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_STRIDE3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension3 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3           ((uint32_t)(0x6490))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_OFFSET    ((uint32_t)(0x90))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_LINEWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_LINEWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_LINECOUNT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION3_LINECOUNT3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits3 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3              ((uint32_t)(0x6494))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_OFFSET       ((uint32_t)(0x94))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSRED3_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_COMPONENTBITSRED3_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_ITUFORMAT3_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS3_ITUFORMAT3_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift3 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3             ((uint32_t)(0x6498))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_OFFSET      ((uint32_t)(0x98))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset3 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3                     ((uint32_t)(0x649C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_OFFSET              ((uint32_t)(0x9C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_LAYERXOFFSET3_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_LAYERXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_LAYERYOFFSET3_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET3_LAYERYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset3 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3                ((uint32_t)(0x64A0))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_OFFSET         ((uint32_t)(0xA0))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions3 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3            ((uint32_t)(0x64A4))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_OFFSET     ((uint32_t)(0xA4))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor3 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3                   ((uint32_t)(0x64A8))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_OFFSET            ((uint32_t)(0xA8))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTALPHA3_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTBLUE3_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTGREEN3_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTRED3_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR3_CONSTANTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty3 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3                   ((uint32_t)(0x64AC))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_OFFSET            ((uint32_t)(0xAC))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3_SHIFT   4U
/* Field Value: TILEMODE3__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE3__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE3__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3__TILE_PAD 0x2U
/* Field Value: TILEMODE3__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_TILEMODE3__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHASRCENABLE3_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHASRCENABLE3_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHACONSTENABLE3_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHACONSTENABLE3_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHAMASKENABLE3_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHAMASKENABLE3_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHATRANSENABLE3_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_ALPHATRANSENABLE3_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHASRCENABLE3_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHASRCENABLE3_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHACONSTENABLE3_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHACONSTENABLE3_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHAMASKENABLE3_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHAMASKENABLE3_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHATRANSENABLE3_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_RGBALPHATRANSENABLE3_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_PREMULCONSTRGB3_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_PREMULCONSTRGB3_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE3__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3__OFF 0U
/* Field Value: YUVCONVERSIONMODE3__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE3__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE3__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_GAMMAREMOVEENABLE3_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_GAMMAREMOVEENABLE3_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_CLIPWINDOWENABLE3_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_CLIPWINDOWENABLE3_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_SOURCEBUFFERENABLE3_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY3_SOURCEBUFFERENABLE3_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress4 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4                     ((uint32_t)(0x64B0))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4_OFFSET              ((uint32_t)(0xB0))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4_BASEADDRESS4_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS4_BASEADDRESS4_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes4 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4          ((uint32_t)(0x64B4))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_OFFSET   ((uint32_t)(0xB4))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_STRIDE4_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_STRIDE4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension4 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4           ((uint32_t)(0x64B8))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_OFFSET    ((uint32_t)(0xB8))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_LINEWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_LINEWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_LINECOUNT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION4_LINECOUNT4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits4 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4              ((uint32_t)(0x64BC))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_OFFSET       ((uint32_t)(0xBC))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSRED4_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_COMPONENTBITSRED4_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_ITUFORMAT4_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS4_ITUFORMAT4_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift4 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4             ((uint32_t)(0x64C0))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_OFFSET      ((uint32_t)(0xC0))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset4 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4                     ((uint32_t)(0x64C4))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_OFFSET              ((uint32_t)(0xC4))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_LAYERXOFFSET4_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_LAYERXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_LAYERYOFFSET4_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET4_LAYERYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset4 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4                ((uint32_t)(0x64C8))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_OFFSET         ((uint32_t)(0xC8))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions4 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4            ((uint32_t)(0x64CC))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_OFFSET     ((uint32_t)(0xCC))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor4 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4                   ((uint32_t)(0x64D0))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_OFFSET            ((uint32_t)(0xD0))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTALPHA4_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTBLUE4_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTGREEN4_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTRED4_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR4_CONSTANTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty4 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4                   ((uint32_t)(0x64D4))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_OFFSET            ((uint32_t)(0xD4))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4_SHIFT   4U
/* Field Value: TILEMODE4__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE4__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE4__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4__TILE_PAD 0x2U
/* Field Value: TILEMODE4__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_TILEMODE4__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHASRCENABLE4_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHASRCENABLE4_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHACONSTENABLE4_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHACONSTENABLE4_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHAMASKENABLE4_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHAMASKENABLE4_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHATRANSENABLE4_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_ALPHATRANSENABLE4_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHASRCENABLE4_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHASRCENABLE4_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHACONSTENABLE4_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHACONSTENABLE4_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHAMASKENABLE4_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHAMASKENABLE4_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHATRANSENABLE4_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_RGBALPHATRANSENABLE4_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_PREMULCONSTRGB4_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_PREMULCONSTRGB4_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE4__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4__OFF 0U
/* Field Value: YUVCONVERSIONMODE4__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE4__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE4__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_GAMMAREMOVEENABLE4_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_GAMMAREMOVEENABLE4_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_CLIPWINDOWENABLE4_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_CLIPWINDOWENABLE4_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_SOURCEBUFFERENABLE4_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY4_SOURCEBUFFERENABLE4_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress5 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5                     ((uint32_t)(0x64D8))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5_OFFSET              ((uint32_t)(0xD8))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5_BASEADDRESS5_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS5_BASEADDRESS5_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes5 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5          ((uint32_t)(0x64DC))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_OFFSET   ((uint32_t)(0xDC))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_STRIDE5_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_STRIDE5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension5 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5           ((uint32_t)(0x64E0))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_OFFSET    ((uint32_t)(0xE0))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_LINEWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_LINEWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_LINECOUNT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION5_LINECOUNT5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits5 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5              ((uint32_t)(0x64E4))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_OFFSET       ((uint32_t)(0xE4))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSRED5_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_COMPONENTBITSRED5_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_ITUFORMAT5_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS5_ITUFORMAT5_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift5 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5             ((uint32_t)(0x64E8))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_OFFSET      ((uint32_t)(0xE8))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset5 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5                     ((uint32_t)(0x64EC))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_OFFSET              ((uint32_t)(0xEC))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_LAYERXOFFSET5_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_LAYERXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_LAYERYOFFSET5_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET5_LAYERYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset5 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5                ((uint32_t)(0x64F0))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_OFFSET         ((uint32_t)(0xF0))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions5 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5            ((uint32_t)(0x64F4))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_OFFSET     ((uint32_t)(0xF4))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor5 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5                   ((uint32_t)(0x64F8))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_OFFSET            ((uint32_t)(0xF8))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTALPHA5_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTBLUE5_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTGREEN5_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTRED5_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR5_CONSTANTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty5 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5                   ((uint32_t)(0x64FC))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_OFFSET            ((uint32_t)(0xFC))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5_SHIFT   4U
/* Field Value: TILEMODE5__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE5__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE5__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5__TILE_PAD 0x2U
/* Field Value: TILEMODE5__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_TILEMODE5__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHASRCENABLE5_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHASRCENABLE5_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHACONSTENABLE5_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHACONSTENABLE5_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHAMASKENABLE5_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHAMASKENABLE5_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHATRANSENABLE5_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_ALPHATRANSENABLE5_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHASRCENABLE5_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHASRCENABLE5_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHACONSTENABLE5_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHACONSTENABLE5_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHAMASKENABLE5_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHAMASKENABLE5_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHATRANSENABLE5_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_RGBALPHATRANSENABLE5_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_PREMULCONSTRGB5_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_PREMULCONSTRGB5_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE5__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5__OFF 0U
/* Field Value: YUVCONVERSIONMODE5__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE5__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE5__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_GAMMAREMOVEENABLE5_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_GAMMAREMOVEENABLE5_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_CLIPWINDOWENABLE5_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_CLIPWINDOWENABLE5_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_SOURCEBUFFERENABLE5_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY5_SOURCEBUFFERENABLE5_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress6 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6                     ((uint32_t)(0x6500))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6_OFFSET              ((uint32_t)(0x100))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6_BASEADDRESS6_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS6_BASEADDRESS6_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes6 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6          ((uint32_t)(0x6504))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_OFFSET   ((uint32_t)(0x104))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_STRIDE6_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_STRIDE6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension6 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6           ((uint32_t)(0x6508))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_OFFSET    ((uint32_t)(0x108))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_LINEWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_LINEWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_LINECOUNT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION6_LINECOUNT6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits6 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6              ((uint32_t)(0x650C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_OFFSET       ((uint32_t)(0x10C))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSRED6_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_COMPONENTBITSRED6_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_ITUFORMAT6_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS6_ITUFORMAT6_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift6 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6             ((uint32_t)(0x6510))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_OFFSET      ((uint32_t)(0x110))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset6 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6                     ((uint32_t)(0x6514))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_OFFSET              ((uint32_t)(0x114))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_LAYERXOFFSET6_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_LAYERXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_LAYERYOFFSET6_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET6_LAYERYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset6 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6                ((uint32_t)(0x6518))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_OFFSET         ((uint32_t)(0x118))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions6 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6            ((uint32_t)(0x651C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_OFFSET     ((uint32_t)(0x11C))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor6 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6                   ((uint32_t)(0x6520))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_OFFSET            ((uint32_t)(0x120))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTALPHA6_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTBLUE6_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTGREEN6_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTRED6_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR6_CONSTANTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty6 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6                   ((uint32_t)(0x6524))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_OFFSET            ((uint32_t)(0x124))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6_SHIFT   4U
/* Field Value: TILEMODE6__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE6__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE6__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6__TILE_PAD 0x2U
/* Field Value: TILEMODE6__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_TILEMODE6__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHASRCENABLE6_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHASRCENABLE6_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHACONSTENABLE6_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHACONSTENABLE6_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHAMASKENABLE6_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHAMASKENABLE6_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHATRANSENABLE6_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_ALPHATRANSENABLE6_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHASRCENABLE6_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHASRCENABLE6_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHACONSTENABLE6_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHACONSTENABLE6_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHAMASKENABLE6_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHAMASKENABLE6_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHATRANSENABLE6_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_RGBALPHATRANSENABLE6_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_PREMULCONSTRGB6_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_PREMULCONSTRGB6_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE6__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6__OFF 0U
/* Field Value: YUVCONVERSIONMODE6__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE6__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE6__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_GAMMAREMOVEENABLE6_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_GAMMAREMOVEENABLE6_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_CLIPWINDOWENABLE6_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_CLIPWINDOWENABLE6_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_SOURCEBUFFERENABLE6_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY6_SOURCEBUFFERENABLE6_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_BaseAddress7 */
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7                     ((uint32_t)(0x6528))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7_OFFSET              ((uint32_t)(0x128))
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7_BASEADDRESS7_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_BASEADDRESS7_BASEADDRESS7_SHIFT  0U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferAttributes7 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7          ((uint32_t)(0x652C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_OFFSET   ((uint32_t)(0x12C))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_STRIDE7_MASK 0xFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_STRIDE7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_MASK 0x3F0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_SourceBufferDimension7 */
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7           ((uint32_t)(0x6530))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_OFFSET    ((uint32_t)(0x130))
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_LINEWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_LINEWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_LINECOUNT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_SOURCEBUFFERDIMENSION7_LINECOUNT7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentBits7 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7              ((uint32_t)(0x6534))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_OFFSET       ((uint32_t)(0x134))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_RESET_VALUE  0x8080808U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_MASK 0xFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_MASK 0xF00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_MASK 0xF0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSRED7_MASK 0xF000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_COMPONENTBITSRED7_SHIFT 24U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_ITUFORMAT7_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTBITS7_ITUFORMAT7_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_ColorComponentShift7 */
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7             ((uint32_t)(0x6538))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_OFFSET      ((uint32_t)(0x138))
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_MASK 0x1FU
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_MASK 0x1F0000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_MASK 0x1F000000U
#define IMXDPUV1_FETCHWARP2_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerOffset7 */
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7                     ((uint32_t)(0x653C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_OFFSET              ((uint32_t)(0x13C))
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_LAYERXOFFSET7_MASK  0x7FFFU
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_LAYERXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_LAYERYOFFSET7_MASK  0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_LAYEROFFSET7_LAYERYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowOffset7 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7                ((uint32_t)(0x6540))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_OFFSET         ((uint32_t)(0x140))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_RESET_VALUE    0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_MASK 0x7FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ClipWindowDimensions7 */
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7            ((uint32_t)(0x6544))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_OFFSET     ((uint32_t)(0x144))
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_SHIFT 16U

/* Register: IMXDPUV1_fetchwarp2_ConstantColor7 */
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7                   ((uint32_t)(0x6548))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_OFFSET            ((uint32_t)(0x148))
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTALPHA7_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTBLUE7_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTGREEN7_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTRED7_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_CONSTANTCOLOR7_CONSTANTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_LayerProperty7 */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7                   ((uint32_t)(0x654C))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_OFFSET            ((uint32_t)(0x14C))
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RESET_VALUE       0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7_MASK    0x30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7_SHIFT   4U
/* Field Value: TILEMODE7__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE7__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE7__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7__TILE_PAD 0x2U
/* Field Value: TILEMODE7__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_TILEMODE7__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHASRCENABLE7_MASK 0x100U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHASRCENABLE7_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHACONSTENABLE7_MASK 0x200U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHACONSTENABLE7_SHIFT 9U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHAMASKENABLE7_MASK 0x400U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHAMASKENABLE7_SHIFT 10U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHATRANSENABLE7_MASK 0x800U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_ALPHATRANSENABLE7_SHIFT 11U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHASRCENABLE7_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHASRCENABLE7_SHIFT 12U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHACONSTENABLE7_MASK 0x2000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHACONSTENABLE7_SHIFT 13U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHAMASKENABLE7_MASK 0x4000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHAMASKENABLE7_SHIFT 14U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHATRANSENABLE7_MASK 0x8000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_RGBALPHATRANSENABLE7_SHIFT 15U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_PREMULCONSTRGB7_MASK 0x10000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_PREMULCONSTRGB7_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7_MASK 0x60000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE7__OFF, No conversion.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7__OFF 0U
/* Field Value: YUVCONVERSIONMODE7__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE7__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE7__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU709 0x3U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_GAMMAREMOVEENABLE7_MASK 0x100000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_GAMMAREMOVEENABLE7_SHIFT 20U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_CLIPWINDOWENABLE7_MASK 0x40000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_CLIPWINDOWENABLE7_SHIFT 30U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_SOURCEBUFFERENABLE7_MASK 0x80000000U
#define IMXDPUV1_FETCHWARP2_LAYERPROPERTY7_SOURCEBUFFERENABLE7_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_FrameDimensions */
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS                  ((uint32_t)(0x6550))
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_OFFSET           ((uint32_t)(0x150))
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_RESET_VALUE      0xEF013FU
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_FRAMEWIDTH_MASK  0x3FFFU
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_EMPTYFRAME_MASK  0x80000000U
#define IMXDPUV1_FETCHWARP2_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_fetchwarp2_FrameResampling */
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING                  ((uint32_t)(0x6554))
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_OFFSET           ((uint32_t)(0x154))
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_RESET_VALUE      0x104000U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_STARTX_MASK      0x3FU
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_STARTX_SHIFT     0U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_STARTY_MASK      0xFC0U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_STARTY_SHIFT     6U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_DELTAX_MASK      0x3F000U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_DELTAX_SHIFT     12U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_DELTAY_MASK      0xFC0000U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_DELTAY_SHIFT     18U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHWARP2_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_WarpControl */
#define IMXDPUV1_FETCHWARP2_WARPCONTROL                      ((uint32_t)(0x6558))
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_OFFSET               ((uint32_t)(0x158))
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_RESET_VALUE          0x20U
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPBITSPERPIXEL_MASK 0x3FU
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPBITSPERPIXEL_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPCOORDINATEMODE_MASK 0x300U
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPCOORDINATEMODE_SHIFT 8U
/* Field Value: WARPCOORDINATEMODE__PNT, x and y (sample points).  */
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPCOORDINATEMODE__PNT 0U
/* Field Value: WARPCOORDINATEMODE__D_PNT, dx and dy (vectors between adjacent
 * sample points).  */
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPCOORDINATEMODE__D_PNT 0x1U
/* Field Value: WARPCOORDINATEMODE__DD_PNT, ddx and ddy (deltas between adjacent
 * vectors).  */
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPCOORDINATEMODE__DD_PNT 0x2U
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPSYMMETRICOFFSET_MASK 0x1000U
#define IMXDPUV1_FETCHWARP2_WARPCONTROL_WARPSYMMETRICOFFSET_SHIFT 12U

/* Register: IMXDPUV1_fetchwarp2_ArbStartX */
#define IMXDPUV1_FETCHWARP2_ARBSTARTX                        ((uint32_t)(0x655C))
#define IMXDPUV1_FETCHWARP2_ARBSTARTX_OFFSET                 ((uint32_t)(0x15C))
#define IMXDPUV1_FETCHWARP2_ARBSTARTX_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP2_ARBSTARTX_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_ARBSTARTX_ARBSTARTX_MASK         0x1FFFFFU
#define IMXDPUV1_FETCHWARP2_ARBSTARTX_ARBSTARTX_SHIFT        0U

/* Register: IMXDPUV1_fetchwarp2_ArbStartY */
#define IMXDPUV1_FETCHWARP2_ARBSTARTY                        ((uint32_t)(0x6560))
#define IMXDPUV1_FETCHWARP2_ARBSTARTY_OFFSET                 ((uint32_t)(0x160))
#define IMXDPUV1_FETCHWARP2_ARBSTARTY_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP2_ARBSTARTY_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_ARBSTARTY_ARBSTARTY_MASK         0x1FFFFFU
#define IMXDPUV1_FETCHWARP2_ARBSTARTY_ARBSTARTY_SHIFT        0U

/* Register: IMXDPUV1_fetchwarp2_ArbDelta */
#define IMXDPUV1_FETCHWARP2_ARBDELTA                         ((uint32_t)(0x6564))
#define IMXDPUV1_FETCHWARP2_ARBDELTA_OFFSET                  ((uint32_t)(0x164))
#define IMXDPUV1_FETCHWARP2_ARBDELTA_RESET_VALUE             0U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAXX_MASK         0xFFU
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAXX_SHIFT        0U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAXY_MASK         0xFF00U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAXY_SHIFT        8U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAYX_MASK         0xFF0000U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAYX_SHIFT        16U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAYY_MASK         0xFF000000U
#define IMXDPUV1_FETCHWARP2_ARBDELTA_ARBDELTAYY_SHIFT        24U

/* Register: IMXDPUV1_fetchwarp2_FIRPositions */
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS                     ((uint32_t)(0x6568))
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_OFFSET              ((uint32_t)(0x168))
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_RESET_VALUE         0xA965U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR0POSITION_MASK   0xFU
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR0POSITION_SHIFT  0U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR1POSITION_MASK   0xF0U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR1POSITION_SHIFT  4U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR2POSITION_MASK   0xF00U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR2POSITION_SHIFT  8U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR3POSITION_MASK   0xF000U
#define IMXDPUV1_FETCHWARP2_FIRPOSITIONS_FIR3POSITION_SHIFT  12U

/* Register: IMXDPUV1_fetchwarp2_FIRCoefficients */
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS                  ((uint32_t)(0x656C))
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_OFFSET           ((uint32_t)(0x16C))
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_RESET_VALUE      0x20U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR0COEFFICIENT_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR0COEFFICIENT_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR1COEFFICIENT_MASK 0xFF00U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR1COEFFICIENT_SHIFT 8U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR2COEFFICIENT_MASK 0xFF0000U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR2COEFFICIENT_SHIFT 16U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR3COEFFICIENT_MASK 0xFF000000U
#define IMXDPUV1_FETCHWARP2_FIRCOEFFICIENTS_FIR3COEFFICIENT_SHIFT 24U

/* Register: IMXDPUV1_fetchwarp2_Control */
#define IMXDPUV1_FETCHWARP2_CONTROL                          ((uint32_t)(0x6570))
#define IMXDPUV1_FETCHWARP2_CONTROL_OFFSET                   ((uint32_t)(0x170))
#define IMXDPUV1_FETCHWARP2_CONTROL_RESET_VALUE              0x10000U
#define IMXDPUV1_FETCHWARP2_CONTROL_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE_MASK          0x7U
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE_SHIFT         0U
/* Field Value: RASTERMODE__NORMAL, First sample at StartX/Y relative to origin.
 * Hor/ver increments using DeltaX/Y and DeltaSwap setup.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__NORMAL       0U
/* Field Value: RASTERMODE__DECODE, [FetchDecode/FetchDecodeL only] Source
 * buffer is an encoded bit stream. First sample at origin (0,0). Hor/ver
 * increments = (1,0)/(0,1).  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__DECODE       0x1U
/* Field Value: RASTERMODE__ARBITRARY, [FetchPersp/Warp/Rot/RotL only] Arbitrary
 * warping (filter is active). Coordinates are read from frame input
 * port. InputSelect must be set to COORDINATE. ArbStartX/Y and ArbDeltaXX/XY/YX/YY
 * must be setup.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__ARBITRARY    0x2U
/* Field Value: RASTERMODE__PERSPECTIVE, [FetchPersp only] Affine/Perspective
 * warping (filter is active). First sample at PerspStartX/Y/W. Hor/ver
 * increments using PerspDeltaXX/XY/YX/YY/WX/WY. Homogeneous coordinates.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__PERSPECTIVE  0x3U
/* Field Value: RASTERMODE__YUV422, [FetchPersp/Decode only] Source buffer
 * is packed YUV 4:2:2. First sample at origin (0,0). Hor/ver increments
 * = (1,0)/(0,1). All corellated window widths and horizontal offsets must
 * be even.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__YUV422       0x4U
/* Field Value: RASTERMODE__AFFINE, [FetchRot/RotL only] Affine warping (filter
 * is active). First sample at AffineStartX/Y. Hor/ver increments using
 * AffineDeltaXX/XY/YX/YY. Cartesian coordinates.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_RASTERMODE__AFFINE       0x5U
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT_MASK         0x18U
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT_SHIFT        3U
/* Field Value: INPUTSELECT__INACTIVE, Not used.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT__INACTIVE    0U
/* Field Value: INPUTSELECT__COMPPACK, Used for component packing (e.g. UV
 * or source alpha buffer).  */
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT__COMPPACK    0x1U
/* Field Value: INPUTSELECT__ALPHAMASK, Used for RGB and alpha pre-multiply
 * stage (mask alpha buffer).  */
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT__ALPHAMASK   0x2U
/* Field Value: INPUTSELECT__COORDINATE, Used for arbitrary warping (coordinate
 * buffer).  */
#define IMXDPUV1_FETCHWARP2_CONTROL_INPUTSELECT__COORDINATE  0x3U
#define IMXDPUV1_FETCHWARP2_CONTROL_RAWPIXEL_MASK            0x80U
#define IMXDPUV1_FETCHWARP2_CONTROL_RAWPIXEL_SHIFT           7U
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPCOLOR_MASK           0x10000U
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPCOLOR_SHIFT          16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPCOLOR__NULL          0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPCOLOR__LAYER         0x1U
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPLAYER_MASK           0xE0000U
#define IMXDPUV1_FETCHWARP2_CONTROL_CLIPLAYER_SHIFT          17U
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE_MASK          0x700000U
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE_SHIFT         20U
/* Field Value: FILTERMODE__NEAREST, Chooses pixel closest to sample point  */
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE__NEAREST      0U
/* Field Value: FILTERMODE__BILINEAR, Calculates result from 4 pixels closest
 * to sample point  */
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE__BILINEAR     0x1U
/* Field Value: FILTERMODE__FIR2, FIR mode with 2 programmable pixel positions
 * and coefficients  */
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE__FIR2         0x2U
/* Field Value: FILTERMODE__FIR4, FIR mode with 4 programmable pixel positions
 * and coefficients  */
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE__FIR4         0x3U
/* Field Value: FILTERMODE__HOR_LINEAR, Calculates result from 2 pixels closest
 * to the sample point and on the same line  */
#define IMXDPUV1_FETCHWARP2_CONTROL_FILTERMODE__HOR_LINEAR   0x4U

/* Register: IMXDPUV1_fetchwarp2_TriggerEnable */
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE                    ((uint32_t)(0x6574))
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE_OFFSET             ((uint32_t)(0x174))
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE_RESET_VALUE        0U
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE_SHDLDREQ_MASK      0xFFU
#define IMXDPUV1_FETCHWARP2_TRIGGERENABLE_SHDLDREQ_SHIFT     0U

/* Register: IMXDPUV1_fetchwarp2_ControlTrigger */
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER                   ((uint32_t)(0x6578))
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER_OFFSET            ((uint32_t)(0x178))
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER_RESET_VALUE       0U
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER_RESET_MASK        0xFFFFFFFEU
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER_SHDTOKGEN_MASK    0x1U
#define IMXDPUV1_FETCHWARP2_CONTROLTRIGGER_SHDTOKGEN_SHIFT   0U

/* Register: IMXDPUV1_fetchwarp2_Start */
#define IMXDPUV1_FETCHWARP2_START                            ((uint32_t)(0x657C))
#define IMXDPUV1_FETCHWARP2_START_OFFSET                     ((uint32_t)(0x17C))
#define IMXDPUV1_FETCHWARP2_START_RESET_VALUE                0U
#define IMXDPUV1_FETCHWARP2_START_RESET_MASK                 0xFFFFFFFEU
#define IMXDPUV1_FETCHWARP2_START_START_MASK                 0x1U
#define IMXDPUV1_FETCHWARP2_START_START_SHIFT                0U

/* Register: IMXDPUV1_fetchwarp2_FetchType */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE                        ((uint32_t)(0x6580))
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_OFFSET                 ((uint32_t)(0x180))
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_RESET_VALUE            0U
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_RESET_MASK             0xFFFFFFF0U
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE_MASK         0xFU
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE_SHIFT        0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__DECODE      0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__LAYER       0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__WARP        0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__ECO         0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__PERSP       0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__ROT         0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__DECODEL     0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__LAYERL      0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHWARP2_FETCHTYPE_FETCHTYPE__ROTL        0x8U

/* Register: IMXDPUV1_fetchwarp2_BurstBufferProperties */
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES            ((uint32_t)(0x6584))
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_OFFSET     ((uint32_t)(0x184))
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHWARP2_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetchwarp2_Status */
#define IMXDPUV1_FETCHWARP2_STATUS                           ((uint32_t)(0x6588))
#define IMXDPUV1_FETCHWARP2_STATUS_OFFSET                    ((uint32_t)(0x188))
#define IMXDPUV1_FETCHWARP2_STATUS_RESET_VALUE               0U
#define IMXDPUV1_FETCHWARP2_STATUS_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHWARP2_STATUS_WRITETIMEOUT_MASK         0x1U
#define IMXDPUV1_FETCHWARP2_STATUS_WRITETIMEOUT_SHIFT        0U
#define IMXDPUV1_FETCHWARP2_STATUS_READTIMEOUT_MASK          0x10U
#define IMXDPUV1_FETCHWARP2_STATUS_READTIMEOUT_SHIFT         4U

/* Register: IMXDPUV1_fetchwarp2_HiddenStatus */
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS                     ((uint32_t)(0x658C))
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_OFFSET              ((uint32_t)(0x18C))
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_RESET_VALUE         0U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_RESET_MASK          0xFFFF008EU
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSBUSY_MASK     0x1U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSBUSY_SHIFT    0U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSREQUEST_MASK  0x20U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_SHADOWSTATUS_MASK   0xFF00U
#define IMXDPUV1_FETCHWARP2_HIDDENSTATUS_SHADOWSTATUS_SHIFT  8U

/* Register: IMXDPUV1_fetcheco2_LockUnlock */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK                        ((uint32_t)(0x6800))
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_OFFSET                 ((uint32_t)(0))
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_RESET_MASK             0U
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK_SHIFT       0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY   0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHECO2_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetcheco2_LockStatus */
#define IMXDPUV1_FETCHECO2_LOCKSTATUS                        ((uint32_t)(0x6804))
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_OFFSET                 ((uint32_t)(0x4))
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_LOCKSTATUS_MASK        0x1U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_LOCKSTATUS_SHIFT       0U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_PRIVILEGESTATUS_MASK   0x10U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_PRIVILEGESTATUS_SHIFT  4U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_FREEZESTATUS_MASK      0x100U
#define IMXDPUV1_FETCHECO2_LOCKSTATUS_FREEZESTATUS_SHIFT     8U

/* Register: IMXDPUV1_fetcheco2_StaticControl */
#define IMXDPUV1_FETCHECO2_STATICCONTROL                     ((uint32_t)(0x6808))
#define IMXDPUV1_FETCHECO2_STATICCONTROL_OFFSET              ((uint32_t)(0x8))
#define IMXDPUV1_FETCHECO2_STATICCONTROL_RESET_VALUE         0U
#define IMXDPUV1_FETCHECO2_STATICCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_STATICCONTROL_SHDEN_MASK          0x1U
#define IMXDPUV1_FETCHECO2_STATICCONTROL_SHDEN_SHIFT         0U
#define IMXDPUV1_FETCHECO2_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO2_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_fetcheco2_BurstBufferManagement */
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT             ((uint32_t)(0x680C))
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_OFFSET      ((uint32_t)(0xC))
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHECO2_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetcheco2_BaseAddress0 */
#define IMXDPUV1_FETCHECO2_BASEADDRESS0                      ((uint32_t)(0x6810))
#define IMXDPUV1_FETCHECO2_BASEADDRESS0_OFFSET               ((uint32_t)(0x10))
#define IMXDPUV1_FETCHECO2_BASEADDRESS0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO2_BASEADDRESS0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_BASEADDRESS0_BASEADDRESS0_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_BASEADDRESS0_BASEADDRESS0_SHIFT   0U

/* Register: IMXDPUV1_fetcheco2_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0           ((uint32_t)(0x6814))
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_OFFSET    ((uint32_t)(0x14))
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco2_SourceBufferDimension0 */
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0            ((uint32_t)(0x6818))
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_OFFSET     ((uint32_t)(0x18))
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO2_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco2_ColorComponentBits0 */
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0               ((uint32_t)(0x681C))
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_OFFSET        ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_RESET_VALUE   0x8080808U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco2_ColorComponentShift0 */
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0              ((uint32_t)(0x6820))
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_OFFSET       ((uint32_t)(0x20))
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_RESET_VALUE  0x18100800U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHECO2_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco2_LayerOffset0 */
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0                      ((uint32_t)(0x6824))
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_OFFSET               ((uint32_t)(0x24))
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_LAYERXOFFSET0_MASK   0x7FFFU
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_LAYERXOFFSET0_SHIFT  0U
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_LAYERYOFFSET0_MASK   0x7FFF0000U
#define IMXDPUV1_FETCHECO2_LAYEROFFSET0_LAYERYOFFSET0_SHIFT  16U

/* Register: IMXDPUV1_fetcheco2_ClipWindowOffset0 */
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0                 ((uint32_t)(0x6828))
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_OFFSET          ((uint32_t)(0x28))
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_RESET_VALUE     0U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco2_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0             ((uint32_t)(0x682C))
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_OFFSET      ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO2_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco2_ConstantColor0 */
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0                    ((uint32_t)(0x6830))
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_OFFSET             ((uint32_t)(0x30))
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTRED0_MASK  0xFF000000U
#define IMXDPUV1_FETCHECO2_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco2_LayerProperty0 */
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0                    ((uint32_t)(0x6834))
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_OFFSET             ((uint32_t)(0x34))
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_RESET_VALUE        0x80000000U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0_MASK     0x30U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0_SHIFT    4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO2_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco2_FrameDimensions */
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS                   ((uint32_t)(0x6838))
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_OFFSET            ((uint32_t)(0x38))
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_RESET_VALUE       0xEF013FU
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_FRAMEWIDTH_MASK   0x3FFFU
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT  0U
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK  0x3FFF0000U
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_EMPTYFRAME_MASK   0x80000000U
#define IMXDPUV1_FETCHECO2_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT  31U

/* Register: IMXDPUV1_fetcheco2_FrameResampling */
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING                   ((uint32_t)(0x683C))
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_OFFSET            ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_RESET_VALUE       0x104000U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_STARTX_MASK       0x3FU
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_STARTX_SHIFT      0U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_STARTY_MASK       0xFC0U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_STARTY_SHIFT      6U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_DELTAX_MASK       0x3F000U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_DELTAX_SHIFT      12U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_DELTAY_MASK       0xFC0000U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_DELTAY_SHIFT      18U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHECO2_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetcheco2_Control */
#define IMXDPUV1_FETCHECO2_CONTROL                           ((uint32_t)(0x6840))
#define IMXDPUV1_FETCHECO2_CONTROL_OFFSET                    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHECO2_CONTROL_RESET_VALUE               0x10000U
#define IMXDPUV1_FETCHECO2_CONTROL_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHECO2_CONTROL_RAWPIXEL_MASK             0x80U
#define IMXDPUV1_FETCHECO2_CONTROL_RAWPIXEL_SHIFT            7U
#define IMXDPUV1_FETCHECO2_CONTROL_CLIPCOLOR_MASK            0x10000U
#define IMXDPUV1_FETCHECO2_CONTROL_CLIPCOLOR_SHIFT           16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHECO2_CONTROL_CLIPCOLOR__NULL           0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHECO2_CONTROL_CLIPCOLOR__LAYER          0x1U

/* Register: IMXDPUV1_fetcheco2_ControlTrigger */
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER                    ((uint32_t)(0x6844))
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER_OFFSET             ((uint32_t)(0x44))
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER_RESET_MASK         0xFFFFFFFEU
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER_SHDTOKGEN_MASK     0x1U
#define IMXDPUV1_FETCHECO2_CONTROLTRIGGER_SHDTOKGEN_SHIFT    0U

/* Register: IMXDPUV1_fetcheco2_Start */
#define IMXDPUV1_FETCHECO2_START                             ((uint32_t)(0x6848))
#define IMXDPUV1_FETCHECO2_START_OFFSET                      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHECO2_START_RESET_VALUE                 0U
#define IMXDPUV1_FETCHECO2_START_RESET_MASK                  0xFFFFFFFEU
#define IMXDPUV1_FETCHECO2_START_START_MASK                  0x1U
#define IMXDPUV1_FETCHECO2_START_START_SHIFT                 0U

/* Register: IMXDPUV1_fetcheco2_FetchType */
#define IMXDPUV1_FETCHECO2_FETCHTYPE                         ((uint32_t)(0x684C))
#define IMXDPUV1_FETCHECO2_FETCHTYPE_OFFSET                  ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHECO2_FETCHTYPE_RESET_VALUE             0U
#define IMXDPUV1_FETCHECO2_FETCHTYPE_RESET_MASK              0xFFFFFFF0U
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE_MASK          0xFU
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE_SHIFT         0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__DECODE       0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__LAYER        0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__WARP         0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__ECO          0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__PERSP        0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__ROT          0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__DECODEL      0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__LAYERL       0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO2_FETCHTYPE_FETCHTYPE__ROTL         0x8U

/* Register: IMXDPUV1_fetcheco2_BurstBufferProperties */
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES             ((uint32_t)(0x6850))
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_RESET_MASK  0xFFFFE000U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHECO2_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetcheco2_HiddenStatus */
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS                      ((uint32_t)(0x6854))
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_OFFSET               ((uint32_t)(0x54))
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_RESET_MASK           0xFFFF008EU
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSBUSY_MASK      0x1U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSBUSY_SHIFT     0U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSREQUEST_MASK   0x20U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSREQUEST_SHIFT  5U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSCOMPLETE_MASK  0x40U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_SHADOWSTATUS_MASK    0xFF00U
#define IMXDPUV1_FETCHECO2_HIDDENSTATUS_SHADOWSTATUS_SHIFT   8U

/* Register: IMXDPUV1_FetchDecode0_LockUnlock */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK                     ((uint32_t)(0x6C00))
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_OFFSET              ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_RESET_MASK          0U
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK_SHIFT    0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHDECODE0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_FetchDecode0_LockStatus */
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS                     ((uint32_t)(0x6C04))
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_OFFSET              ((uint32_t)(0x4))
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_LOCKSTATUS_MASK     0x1U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_LOCKSTATUS_SHIFT    0U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_FREEZESTATUS_MASK   0x100U
#define IMXDPUV1_FETCHDECODE0_LOCKSTATUS_FREEZESTATUS_SHIFT  8U

/* Register: IMXDPUV1_FetchDecode0_StaticControl */
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL                  ((uint32_t)(0x6C08))
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_OFFSET           ((uint32_t)(0x8))
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_SHDEN_MASK       0x1U
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_SHDEN_SHIFT      0U
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE0_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_BurstBufferManagement */
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT          ((uint32_t)(0x6C0C))
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_OFFSET   ((uint32_t)(0xC))
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_FetchDecode0_RingBufStartAddr0 */
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0              ((uint32_t)(0x6C10))
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0_OFFSET       ((uint32_t)(0x10))
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_RingBufWrapAddr0 */
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0               ((uint32_t)(0x6C14))
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0_OFFSET        ((uint32_t)(0x14))
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_FrameProperties0 */
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0               ((uint32_t)(0x6C18))
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0_OFFSET        ((uint32_t)(0x18))
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0_FIELDID0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE0_FRAMEPROPERTIES0_FIELDID0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_BaseAddress0 */
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0                   ((uint32_t)(0x6C1C))
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0_OFFSET            ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0_BASEADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_BASEADDRESS0_BASEADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0        ((uint32_t)(0x6C20))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_OFFSET ((uint32_t)(0x20))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_SourceBufferDimension0 */
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0         ((uint32_t)(0x6C24))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_OFFSET  ((uint32_t)(0x24))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_ColorComponentBits0 */
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0            ((uint32_t)(0x6C28))
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_OFFSET     ((uint32_t)(0x28))
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode0_ColorComponentShift0 */
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0           ((uint32_t)(0x6C2C))
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_OFFSET    ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHDECODE0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode0_LayerOffset0 */
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0                   ((uint32_t)(0x6C30))
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_OFFSET            ((uint32_t)(0x30))
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_LAYERXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_LAYERYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE0_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_ClipWindowOffset0 */
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0              ((uint32_t)(0x6C34))
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_OFFSET       ((uint32_t)(0x34))
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0          ((uint32_t)(0x6C38))
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_OFFSET   ((uint32_t)(0x38))
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode0_ConstantColor0 */
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0                 ((uint32_t)(0x6C3C))
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_OFFSET          ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHDECODE0_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode0_LayerProperty0 */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0                 ((uint32_t)(0x6C40))
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_OFFSET          ((uint32_t)(0x40))
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RESET_VALUE     0x80000100U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_PALETTEENABLE0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_PALETTEENABLE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0_MASK  0x30U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0_SHIFT 4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHAMASKENABLE0_MASK 0x400U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHAMASKENABLE0_SHIFT 10U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHAMASKENABLE0_MASK 0x4000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHAMASKENABLE0_SHIFT 14U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode0_FrameDimensions */
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS                ((uint32_t)(0x6C44))
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_OFFSET         ((uint32_t)(0x44))
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_RESET_VALUE    0xEF013FU
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE0_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode0_FrameResampling */
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING                ((uint32_t)(0x6C48))
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_OFFSET         ((uint32_t)(0x48))
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_RESET_VALUE    0x104000U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_STARTX_MASK    0x3FU
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_STARTX_SHIFT   0U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_STARTY_MASK    0xFC0U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_STARTY_SHIFT   6U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_DELTAX_MASK    0x3F000U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_DELTAX_SHIFT   12U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_DELTAY_MASK    0xFC0000U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_DELTAY_SHIFT   18U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHDECODE0_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode0_DecodeControl */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL                  ((uint32_t)(0x6C4C))
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_OFFSET           ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RESET_VALUE      0x88880001U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE_MASK 0x3U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE_SHIFT 0U
/* Field Value: COMPRESSIONMODE__RLAD, Run-Length Adaptive Dithering (lossy
 * compression).  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE__RLAD 0U
/* Field Value: COMPRESSIONMODE__RLAD_UNIFORM, Run-Length Adaptive Dithering
 * (lossy compression; uniform package size).  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE__RLAD_UNIFORM 0x1U
/* Field Value: COMPRESSIONMODE__RLA, Run-Length Adaptive (lossless compression).  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE__RLA 0x2U
/* Field Value: COMPRESSIONMODE__RL, Standard Run-Length.  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_COMPRESSIONMODE__RL 0x3U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADENDIANNESS_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADENDIANNESS_SHIFT 15U
/* Field Value: RLADENDIANNESS__BIGENDIAN, Big endian format  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADENDIANNESS__BIGENDIAN 0U
/* Field Value: RLADENDIANNESS__LITTLEENDIAN, Little endian format  */
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADENDIANNESS__LITTLEENDIAN 0x1U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSRED_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSRED_SHIFT 16U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSGREEN_MASK 0xF00000U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSGREEN_SHIFT 20U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSBLUE_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSBLUE_SHIFT 24U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSALPHA_MASK 0xF0000000U
#define IMXDPUV1_FETCHDECODE0_DECODECONTROL_RLADCOMPBITSALPHA_SHIFT 28U

/* Register: IMXDPUV1_FetchDecode0_SourceBufferLength */
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH             ((uint32_t)(0x6C50))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH_RLEWORDS_MASK 0x1FFFFFFFU
#define IMXDPUV1_FETCHDECODE0_SOURCEBUFFERLENGTH_RLEWORDS_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_Control */
#define IMXDPUV1_FETCHDECODE0_CONTROL                        ((uint32_t)(0x6C54))
#define IMXDPUV1_FETCHDECODE0_CONTROL_OFFSET                 ((uint32_t)(0x54))
#define IMXDPUV1_FETCHDECODE0_CONTROL_RESET_VALUE            0x10700U
#define IMXDPUV1_FETCHDECODE0_CONTROL_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE_MASK        0x7U
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE_SHIFT       0U
/* Field Value: RASTERMODE__NORMAL, First sample at StartX/Y relative to origin.
 * Hor/ver increments using DeltaX/Y and DeltaSwap setup.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__NORMAL     0U
/* Field Value: RASTERMODE__DECODE, [FetchDecode/FetchDecodeL only] Source
 * buffer is an encoded bit stream. First sample at origin (0,0). Hor/ver
 * increments = (1,0)/(0,1).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__DECODE     0x1U
/* Field Value: RASTERMODE__ARBITRARY, [FetchPersp/Warp/Rot/RotL only] Arbitrary
 * warping (filter is active). Coordinates are read from frame input
 * port. InputSelect must be set to COORDINATE. ArbStartX/Y and ArbDeltaXX/XY/YX/YY
 * must be setup.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__ARBITRARY  0x2U
/* Field Value: RASTERMODE__PERSPECTIVE, [FetchPersp only] Affine/Perspective
 * warping (filter is active). First sample at PerspStartX/Y/W. Hor/ver
 * increments using PerspDeltaXX/XY/YX/YY/WX/WY. Homogeneous coordinates.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__PERSPECTIVE 0x3U
/* Field Value: RASTERMODE__YUV422, [FetchPersp/Decode only] Source buffer
 * is packed YUV 4:2:2. First sample at origin (0,0). Hor/ver increments
 * = (1,0)/(0,1). All corellated window widths and horizontal offsets must
 * be even.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__YUV422     0x4U
/* Field Value: RASTERMODE__AFFINE, [FetchRot/RotL only] Affine warping (filter
 * is active). First sample at AffineStartX/Y. Hor/ver increments using
 * AffineDeltaXX/XY/YX/YY. Cartesian coordinates.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_RASTERMODE__AFFINE     0x5U
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT_MASK       0x18U
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT_SHIFT      3U
/* Field Value: INPUTSELECT__INACTIVE, Not used.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT__INACTIVE  0U
/* Field Value: INPUTSELECT__COMPPACK, Used for component packing (e.g. UV
 * or source alpha buffer).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT__COMPPACK  0x1U
/* Field Value: INPUTSELECT__ALPHAMASK, Used for RGB and alpha pre-multiply
 * stage (mask alpha buffer).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT__ALPHAMASK 0x2U
/* Field Value: INPUTSELECT__COORDINATE, Used for arbitrary warping (coordinate
 * buffer).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_INPUTSELECT__COORDINATE 0x3U
#define IMXDPUV1_FETCHDECODE0_CONTROL_YUV422UPSAMPLINGMODE_MASK 0x20U
#define IMXDPUV1_FETCHDECODE0_CONTROL_YUV422UPSAMPLINGMODE_SHIFT 5U
/* Field Value: YUV422UPSAMPLINGMODE__REPLICATE, Replicate mode for interspersed
 * samples (UV samples between Y samples).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_YUV422UPSAMPLINGMODE__REPLICATE 0U
/* Field Value: YUV422UPSAMPLINGMODE__INTERPOLATE, Interpolate mode for coaligned
 * samples (UV samples at Y sample positions).  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_YUV422UPSAMPLINGMODE__INTERPOLATE 0x1U
#define IMXDPUV1_FETCHDECODE0_CONTROL_RAWPIXEL_MASK          0x80U
#define IMXDPUV1_FETCHDECODE0_CONTROL_RAWPIXEL_SHIFT         7U
#define IMXDPUV1_FETCHDECODE0_CONTROL_PALETTEIDXWIDTH_MASK   0x700U
#define IMXDPUV1_FETCHDECODE0_CONTROL_PALETTEIDXWIDTH_SHIFT  8U
#define IMXDPUV1_FETCHDECODE0_CONTROL_CLIPCOLOR_MASK         0x10000U
#define IMXDPUV1_FETCHDECODE0_CONTROL_CLIPCOLOR_SHIFT        16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_CLIPCOLOR__NULL        0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHDECODE0_CONTROL_CLIPCOLOR__LAYER       0x1U

/* Register: IMXDPUV1_FetchDecode0_ControlTrigger */
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER                 ((uint32_t)(0x6C58))
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER_OFFSET          ((uint32_t)(0x58))
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER_RESET_MASK      0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER_SHDTOKGEN_MASK  0x1U
#define IMXDPUV1_FETCHDECODE0_CONTROLTRIGGER_SHDTOKGEN_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_Start */
#define IMXDPUV1_FETCHDECODE0_START                          ((uint32_t)(0x6C5C))
#define IMXDPUV1_FETCHDECODE0_START_OFFSET                   ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHDECODE0_START_RESET_VALUE              0U
#define IMXDPUV1_FETCHDECODE0_START_RESET_MASK               0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE0_START_START_MASK               0x1U
#define IMXDPUV1_FETCHDECODE0_START_START_SHIFT              0U

/* Register: IMXDPUV1_FetchDecode0_FetchType */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE                      ((uint32_t)(0x6C60))
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_OFFSET               ((uint32_t)(0x60))
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_RESET_VALUE          0U
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_RESET_MASK           0xFFFFFFF0U
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE_MASK       0xFU
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE_SHIFT      0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__DECODE    0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__LAYER     0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__WARP      0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__ECO       0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__PERSP     0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__ROT       0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__DECODEL   0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__LAYERL    0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE0_FETCHTYPE_FETCHTYPE__ROTL      0x8U

/* Register: IMXDPUV1_FetchDecode0_DecoderStatus */
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS                  ((uint32_t)(0x6C64))
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_OFFSET           ((uint32_t)(0x64))
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_BUFFERTOOSMALL_MASK 0x1U
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_BUFFERTOOSMALL_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_BUFFERTOOLARGE_MASK 0x2U
#define IMXDPUV1_FETCHDECODE0_DECODERSTATUS_BUFFERTOOLARGE_SHIFT 1U

/* Register: IMXDPUV1_FetchDecode0_ReadAddress0 */
#define IMXDPUV1_FETCHDECODE0_READADDRESS0                   ((uint32_t)(0x6C68))
#define IMXDPUV1_FETCHDECODE0_READADDRESS0_OFFSET            ((uint32_t)(0x68))
#define IMXDPUV1_FETCHDECODE0_READADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE0_READADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_READADDRESS0_READADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_READADDRESS0_READADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode0_BurstBufferProperties */
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES          ((uint32_t)(0x6C6C))
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_OFFSET   ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode0_Status */
#define IMXDPUV1_FETCHDECODE0_STATUS                         ((uint32_t)(0x6C70))
#define IMXDPUV1_FETCHDECODE0_STATUS_OFFSET                  ((uint32_t)(0x70))
#define IMXDPUV1_FETCHDECODE0_STATUS_RESET_VALUE             0U
#define IMXDPUV1_FETCHDECODE0_STATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE0_STATUS_WRITETIMEOUT_MASK       0x1U
#define IMXDPUV1_FETCHDECODE0_STATUS_WRITETIMEOUT_SHIFT      0U
#define IMXDPUV1_FETCHDECODE0_STATUS_READTIMEOUT_MASK        0x10U
#define IMXDPUV1_FETCHDECODE0_STATUS_READTIMEOUT_SHIFT       4U

/* Register: IMXDPUV1_FetchDecode0_HiddenStatus */
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS                   ((uint32_t)(0x6C74))
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_OFFSET            ((uint32_t)(0x74))
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_RESET_MASK        0xFFFF008EU
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSBUSY_MASK   0x1U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSBUSY_SHIFT  0U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSREQUEST_MASK 0x20U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_SHADOWSTATUS_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE0_HIDDENSTATUS_SHADOWSTATUS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode0_ColorPalette */
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE                   ((uint32_t)(0x7000))
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE_OFFSET            ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE_RESET_MASK        0xFF000000U
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE_COLORPALETTE_MASK 0xFFFFFFU
#define IMXDPUV1_FETCHDECODE0_COLORPALETTE_COLORPALETTE_SHIFT 0U

/* Register: IMXDPUV1_fetcheco0_LockUnlock */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK                        ((uint32_t)(0x7400))
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_OFFSET                 ((uint32_t)(0))
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_RESET_MASK             0U
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK_SHIFT       0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY   0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHECO0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetcheco0_LockStatus */
#define IMXDPUV1_FETCHECO0_LOCKSTATUS                        ((uint32_t)(0x7404))
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_OFFSET                 ((uint32_t)(0x4))
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_LOCKSTATUS_MASK        0x1U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_LOCKSTATUS_SHIFT       0U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_PRIVILEGESTATUS_MASK   0x10U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT  4U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_FREEZESTATUS_MASK      0x100U
#define IMXDPUV1_FETCHECO0_LOCKSTATUS_FREEZESTATUS_SHIFT     8U

/* Register: IMXDPUV1_fetcheco0_StaticControl */
#define IMXDPUV1_FETCHECO0_STATICCONTROL                     ((uint32_t)(0x7408))
#define IMXDPUV1_FETCHECO0_STATICCONTROL_OFFSET              ((uint32_t)(0x8))
#define IMXDPUV1_FETCHECO0_STATICCONTROL_RESET_VALUE         0U
#define IMXDPUV1_FETCHECO0_STATICCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_STATICCONTROL_SHDEN_MASK          0x1U
#define IMXDPUV1_FETCHECO0_STATICCONTROL_SHDEN_SHIFT         0U
#define IMXDPUV1_FETCHECO0_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO0_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_fetcheco0_BurstBufferManagement */
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT             ((uint32_t)(0x740C))
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_OFFSET      ((uint32_t)(0xC))
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHECO0_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetcheco0_BaseAddress0 */
#define IMXDPUV1_FETCHECO0_BASEADDRESS0                      ((uint32_t)(0x7410))
#define IMXDPUV1_FETCHECO0_BASEADDRESS0_OFFSET               ((uint32_t)(0x10))
#define IMXDPUV1_FETCHECO0_BASEADDRESS0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO0_BASEADDRESS0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_BASEADDRESS0_BASEADDRESS0_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_BASEADDRESS0_BASEADDRESS0_SHIFT   0U

/* Register: IMXDPUV1_fetcheco0_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0           ((uint32_t)(0x7414))
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_OFFSET    ((uint32_t)(0x14))
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco0_SourceBufferDimension0 */
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0            ((uint32_t)(0x7418))
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_OFFSET     ((uint32_t)(0x18))
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO0_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco0_ColorComponentBits0 */
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0               ((uint32_t)(0x741C))
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_OFFSET        ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_RESET_VALUE   0x8080808U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco0_ColorComponentShift0 */
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0              ((uint32_t)(0x7420))
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_OFFSET       ((uint32_t)(0x20))
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_RESET_VALUE  0x18100800U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHECO0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco0_LayerOffset0 */
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0                      ((uint32_t)(0x7424))
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_OFFSET               ((uint32_t)(0x24))
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_LAYERXOFFSET0_MASK   0x7FFFU
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_LAYERXOFFSET0_SHIFT  0U
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_LAYERYOFFSET0_MASK   0x7FFF0000U
#define IMXDPUV1_FETCHECO0_LAYEROFFSET0_LAYERYOFFSET0_SHIFT  16U

/* Register: IMXDPUV1_fetcheco0_ClipWindowOffset0 */
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0                 ((uint32_t)(0x7428))
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_OFFSET          ((uint32_t)(0x28))
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_RESET_VALUE     0U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco0_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0             ((uint32_t)(0x742C))
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_OFFSET      ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco0_ConstantColor0 */
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0                    ((uint32_t)(0x7430))
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_OFFSET             ((uint32_t)(0x30))
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTRED0_MASK  0xFF000000U
#define IMXDPUV1_FETCHECO0_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco0_LayerProperty0 */
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0                    ((uint32_t)(0x7434))
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_OFFSET             ((uint32_t)(0x34))
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_RESET_VALUE        0x80000000U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0_MASK     0x30U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0_SHIFT    4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco0_FrameDimensions */
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS                   ((uint32_t)(0x7438))
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_OFFSET            ((uint32_t)(0x38))
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_RESET_VALUE       0xEF013FU
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_FRAMEWIDTH_MASK   0x3FFFU
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT  0U
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK  0x3FFF0000U
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_EMPTYFRAME_MASK   0x80000000U
#define IMXDPUV1_FETCHECO0_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT  31U

/* Register: IMXDPUV1_fetcheco0_FrameResampling */
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING                   ((uint32_t)(0x743C))
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_OFFSET            ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_RESET_VALUE       0x104000U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_STARTX_MASK       0x3FU
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_STARTX_SHIFT      0U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_STARTY_MASK       0xFC0U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_STARTY_SHIFT      6U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_DELTAX_MASK       0x3F000U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_DELTAX_SHIFT      12U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_DELTAY_MASK       0xFC0000U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_DELTAY_SHIFT      18U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHECO0_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetcheco0_Control */
#define IMXDPUV1_FETCHECO0_CONTROL                           ((uint32_t)(0x7440))
#define IMXDPUV1_FETCHECO0_CONTROL_OFFSET                    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHECO0_CONTROL_RESET_VALUE               0x10000U
#define IMXDPUV1_FETCHECO0_CONTROL_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHECO0_CONTROL_RAWPIXEL_MASK             0x80U
#define IMXDPUV1_FETCHECO0_CONTROL_RAWPIXEL_SHIFT            7U
#define IMXDPUV1_FETCHECO0_CONTROL_CLIPCOLOR_MASK            0x10000U
#define IMXDPUV1_FETCHECO0_CONTROL_CLIPCOLOR_SHIFT           16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHECO0_CONTROL_CLIPCOLOR__NULL           0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHECO0_CONTROL_CLIPCOLOR__LAYER          0x1U

/* Register: IMXDPUV1_fetcheco0_ControlTrigger */
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER                    ((uint32_t)(0x7444))
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER_OFFSET             ((uint32_t)(0x44))
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER_RESET_MASK         0xFFFFFFFEU
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER_SHDTOKGEN_MASK     0x1U
#define IMXDPUV1_FETCHECO0_CONTROLTRIGGER_SHDTOKGEN_SHIFT    0U

/* Register: IMXDPUV1_fetcheco0_Start */
#define IMXDPUV1_FETCHECO0_START                             ((uint32_t)(0x7448))
#define IMXDPUV1_FETCHECO0_START_OFFSET                      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHECO0_START_RESET_VALUE                 0U
#define IMXDPUV1_FETCHECO0_START_RESET_MASK                  0xFFFFFFFEU
#define IMXDPUV1_FETCHECO0_START_START_MASK                  0x1U
#define IMXDPUV1_FETCHECO0_START_START_SHIFT                 0U

/* Register: IMXDPUV1_fetcheco0_FetchType */
#define IMXDPUV1_FETCHECO0_FETCHTYPE                         ((uint32_t)(0x744C))
#define IMXDPUV1_FETCHECO0_FETCHTYPE_OFFSET                  ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHECO0_FETCHTYPE_RESET_VALUE             0U
#define IMXDPUV1_FETCHECO0_FETCHTYPE_RESET_MASK              0xFFFFFFF0U
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE_MASK          0xFU
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE_SHIFT         0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__DECODE       0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__LAYER        0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__WARP         0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__ECO          0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__PERSP        0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__ROT          0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__DECODEL      0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__LAYERL       0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO0_FETCHTYPE_FETCHTYPE__ROTL         0x8U

/* Register: IMXDPUV1_fetcheco0_BurstBufferProperties */
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES             ((uint32_t)(0x7450))
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_RESET_MASK  0xFFFFE000U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHECO0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetcheco0_HiddenStatus */
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS                      ((uint32_t)(0x7454))
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_OFFSET               ((uint32_t)(0x54))
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_RESET_MASK           0xFFFF008EU
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSBUSY_MASK      0x1U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSBUSY_SHIFT     0U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSREQUEST_MASK   0x20U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSREQUEST_SHIFT  5U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSCOMPLETE_MASK  0x40U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_SHADOWSTATUS_MASK    0xFF00U
#define IMXDPUV1_FETCHECO0_HIDDENSTATUS_SHADOWSTATUS_SHIFT   8U

/* Register: IMXDPUV1_FetchDecode1_LockUnlock */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK                     ((uint32_t)(0x7800))
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_OFFSET              ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_RESET_MASK          0U
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK_SHIFT    0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHDECODE1_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_FetchDecode1_LockStatus */
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS                     ((uint32_t)(0x7804))
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_OFFSET              ((uint32_t)(0x4))
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_RESET_VALUE         0U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_LOCKSTATUS_MASK     0x1U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_LOCKSTATUS_SHIFT    0U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_FREEZESTATUS_MASK   0x100U
#define IMXDPUV1_FETCHDECODE1_LOCKSTATUS_FREEZESTATUS_SHIFT  8U

/* Register: IMXDPUV1_FetchDecode1_StaticControl */
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL                  ((uint32_t)(0x7808))
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_OFFSET           ((uint32_t)(0x8))
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_SHDEN_MASK       0x1U
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_SHDEN_SHIFT      0U
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE1_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_BurstBufferManagement */
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT          ((uint32_t)(0x780C))
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_OFFSET   ((uint32_t)(0xC))
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_FetchDecode1_RingBufStartAddr0 */
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0              ((uint32_t)(0x7810))
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0_OFFSET       ((uint32_t)(0x10))
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_RINGBUFSTARTADDR0_RINGBUFSTARTADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_RingBufWrapAddr0 */
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0               ((uint32_t)(0x7814))
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0_OFFSET        ((uint32_t)(0x14))
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_RINGBUFWRAPADDR0_RINGBUFWRAPADDR0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_FrameProperties0 */
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0               ((uint32_t)(0x7818))
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0_OFFSET        ((uint32_t)(0x18))
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0_RESET_VALUE   0U
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0_FIELDID0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE1_FRAMEPROPERTIES0_FIELDID0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_BaseAddress0 */
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0                   ((uint32_t)(0x781C))
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0_OFFSET            ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0_BASEADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_BASEADDRESS0_BASEADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0        ((uint32_t)(0x7820))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_OFFSET ((uint32_t)(0x20))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_SourceBufferDimension0 */
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0         ((uint32_t)(0x7824))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_OFFSET  ((uint32_t)(0x24))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_ColorComponentBits0 */
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0            ((uint32_t)(0x7828))
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_OFFSET     ((uint32_t)(0x28))
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode1_ColorComponentShift0 */
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0           ((uint32_t)(0x782C))
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_OFFSET    ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHDECODE1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode1_LayerOffset0 */
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0                   ((uint32_t)(0x7830))
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_OFFSET            ((uint32_t)(0x30))
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_LAYERXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_LAYERYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE1_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_ClipWindowOffset0 */
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0              ((uint32_t)(0x7834))
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_OFFSET       ((uint32_t)(0x34))
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_RESET_VALUE  0U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0          ((uint32_t)(0x7838))
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_OFFSET   ((uint32_t)(0x38))
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_FetchDecode1_ConstantColor0 */
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0                 ((uint32_t)(0x783C))
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_OFFSET          ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHDECODE1_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode1_LayerProperty0 */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0                 ((uint32_t)(0x7840))
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_OFFSET          ((uint32_t)(0x40))
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RESET_VALUE     0x80000100U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_PALETTEENABLE0_MASK 0x1U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_PALETTEENABLE0_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0_MASK  0x30U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0_SHIFT 4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHAMASKENABLE0_MASK 0x400U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHAMASKENABLE0_SHIFT 10U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHAMASKENABLE0_MASK 0x4000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHAMASKENABLE0_SHIFT 14U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE1_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode1_FrameDimensions */
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS                ((uint32_t)(0x7844))
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_OFFSET         ((uint32_t)(0x44))
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_RESET_VALUE    0xEF013FU
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_FETCHDECODE1_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_FetchDecode1_FrameResampling */
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING                ((uint32_t)(0x7848))
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_OFFSET         ((uint32_t)(0x48))
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_RESET_VALUE    0x104000U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_RESET_MASK     0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_STARTX_MASK    0x3FU
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_STARTX_SHIFT   0U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_STARTY_MASK    0xFC0U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_STARTY_SHIFT   6U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_DELTAX_MASK    0x3F000U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_DELTAX_SHIFT   12U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_DELTAY_MASK    0xFC0000U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_DELTAY_SHIFT   18U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHDECODE1_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_FetchDecode1_DecodeControl */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL                  ((uint32_t)(0x784C))
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_OFFSET           ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RESET_VALUE      0x88880001U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE_MASK 0x3U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE_SHIFT 0U
/* Field Value: COMPRESSIONMODE__RLAD, Run-Length Adaptive Dithering (lossy
 * compression).  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE__RLAD 0U
/* Field Value: COMPRESSIONMODE__RLAD_UNIFORM, Run-Length Adaptive Dithering
 * (lossy compression; uniform package size).  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE__RLAD_UNIFORM 0x1U
/* Field Value: COMPRESSIONMODE__RLA, Run-Length Adaptive (lossless compression).  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE__RLA 0x2U
/* Field Value: COMPRESSIONMODE__RL, Standard Run-Length.  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_COMPRESSIONMODE__RL 0x3U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADENDIANNESS_MASK 0x8000U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADENDIANNESS_SHIFT 15U
/* Field Value: RLADENDIANNESS__BIGENDIAN, Big endian format  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADENDIANNESS__BIGENDIAN 0U
/* Field Value: RLADENDIANNESS__LITTLEENDIAN, Little endian format  */
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADENDIANNESS__LITTLEENDIAN 0x1U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSRED_MASK 0xF0000U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSRED_SHIFT 16U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSGREEN_MASK 0xF00000U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSGREEN_SHIFT 20U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSBLUE_MASK 0xF000000U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSBLUE_SHIFT 24U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSALPHA_MASK 0xF0000000U
#define IMXDPUV1_FETCHDECODE1_DECODECONTROL_RLADCOMPBITSALPHA_SHIFT 28U

/* Register: IMXDPUV1_FetchDecode1_SourceBufferLength */
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH             ((uint32_t)(0x7850))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH_RLEWORDS_MASK 0x1FFFFFFFU
#define IMXDPUV1_FETCHDECODE1_SOURCEBUFFERLENGTH_RLEWORDS_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_Control */
#define IMXDPUV1_FETCHDECODE1_CONTROL                        ((uint32_t)(0x7854))
#define IMXDPUV1_FETCHDECODE1_CONTROL_OFFSET                 ((uint32_t)(0x54))
#define IMXDPUV1_FETCHDECODE1_CONTROL_RESET_VALUE            0x10700U
#define IMXDPUV1_FETCHDECODE1_CONTROL_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE_MASK        0x7U
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE_SHIFT       0U
/* Field Value: RASTERMODE__NORMAL, First sample at StartX/Y relative to origin.
 * Hor/ver increments using DeltaX/Y and DeltaSwap setup.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__NORMAL     0U
/* Field Value: RASTERMODE__DECODE, [FetchDecode/FetchDecodeL only] Source
 * buffer is an encoded bit stream. First sample at origin (0,0). Hor/ver
 * increments = (1,0)/(0,1).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__DECODE     0x1U
/* Field Value: RASTERMODE__ARBITRARY, [FetchPersp/Warp/Rot/RotL only] Arbitrary
 * warping (filter is active). Coordinates are read from frame input
 * port. InputSelect must be set to COORDINATE. ArbStartX/Y and ArbDeltaXX/XY/YX/YY
 * must be setup.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__ARBITRARY  0x2U
/* Field Value: RASTERMODE__PERSPECTIVE, [FetchPersp only] Affine/Perspective
 * warping (filter is active). First sample at PerspStartX/Y/W. Hor/ver
 * increments using PerspDeltaXX/XY/YX/YY/WX/WY. Homogeneous coordinates.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__PERSPECTIVE 0x3U
/* Field Value: RASTERMODE__YUV422, [FetchPersp/Decode only] Source buffer
 * is packed YUV 4:2:2. First sample at origin (0,0). Hor/ver increments
 * = (1,0)/(0,1). All corellated window widths and horizontal offsets must
 * be even.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__YUV422     0x4U
/* Field Value: RASTERMODE__AFFINE, [FetchRot/RotL only] Affine warping (filter
 * is active). First sample at AffineStartX/Y. Hor/ver increments using
 * AffineDeltaXX/XY/YX/YY. Cartesian coordinates.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_RASTERMODE__AFFINE     0x5U
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT_MASK       0x18U
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT_SHIFT      3U
/* Field Value: INPUTSELECT__INACTIVE, Not used.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT__INACTIVE  0U
/* Field Value: INPUTSELECT__COMPPACK, Used for component packing (e.g. UV
 * or source alpha buffer).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT__COMPPACK  0x1U
/* Field Value: INPUTSELECT__ALPHAMASK, Used for RGB and alpha pre-multiply
 * stage (mask alpha buffer).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT__ALPHAMASK 0x2U
/* Field Value: INPUTSELECT__COORDINATE, Used for arbitrary warping (coordinate
 * buffer).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_INPUTSELECT__COORDINATE 0x3U
#define IMXDPUV1_FETCHDECODE1_CONTROL_YUV422UPSAMPLINGMODE_MASK 0x20U
#define IMXDPUV1_FETCHDECODE1_CONTROL_YUV422UPSAMPLINGMODE_SHIFT 5U
/* Field Value: YUV422UPSAMPLINGMODE__REPLICATE, Replicate mode for interspersed
 * samples (UV samples between Y samples).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_YUV422UPSAMPLINGMODE__REPLICATE 0U
/* Field Value: YUV422UPSAMPLINGMODE__INTERPOLATE, Interpolate mode for coaligned
 * samples (UV samples at Y sample positions).  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_YUV422UPSAMPLINGMODE__INTERPOLATE 0x1U
#define IMXDPUV1_FETCHDECODE1_CONTROL_RAWPIXEL_MASK          0x80U
#define IMXDPUV1_FETCHDECODE1_CONTROL_RAWPIXEL_SHIFT         7U
#define IMXDPUV1_FETCHDECODE1_CONTROL_PALETTEIDXWIDTH_MASK   0x700U
#define IMXDPUV1_FETCHDECODE1_CONTROL_PALETTEIDXWIDTH_SHIFT  8U
#define IMXDPUV1_FETCHDECODE1_CONTROL_CLIPCOLOR_MASK         0x10000U
#define IMXDPUV1_FETCHDECODE1_CONTROL_CLIPCOLOR_SHIFT        16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_CLIPCOLOR__NULL        0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHDECODE1_CONTROL_CLIPCOLOR__LAYER       0x1U

/* Register: IMXDPUV1_FetchDecode1_ControlTrigger */
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER                 ((uint32_t)(0x7858))
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER_OFFSET          ((uint32_t)(0x58))
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER_RESET_VALUE     0U
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER_RESET_MASK      0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER_SHDTOKGEN_MASK  0x1U
#define IMXDPUV1_FETCHDECODE1_CONTROLTRIGGER_SHDTOKGEN_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_Start */
#define IMXDPUV1_FETCHDECODE1_START                          ((uint32_t)(0x785C))
#define IMXDPUV1_FETCHDECODE1_START_OFFSET                   ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHDECODE1_START_RESET_VALUE              0U
#define IMXDPUV1_FETCHDECODE1_START_RESET_MASK               0xFFFFFFFEU
#define IMXDPUV1_FETCHDECODE1_START_START_MASK               0x1U
#define IMXDPUV1_FETCHDECODE1_START_START_SHIFT              0U

/* Register: IMXDPUV1_FetchDecode1_FetchType */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE                      ((uint32_t)(0x7860))
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_OFFSET               ((uint32_t)(0x60))
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_RESET_VALUE          0U
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_RESET_MASK           0xFFFFFFF0U
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE_MASK       0xFU
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE_SHIFT      0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__DECODE    0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__LAYER     0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__WARP      0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__ECO       0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__PERSP     0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__ROT       0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__DECODEL   0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__LAYERL    0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHDECODE1_FETCHTYPE_FETCHTYPE__ROTL      0x8U

/* Register: IMXDPUV1_FetchDecode1_DecoderStatus */
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS                  ((uint32_t)(0x7864))
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_OFFSET           ((uint32_t)(0x64))
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_RESET_VALUE      0U
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_BUFFERTOOSMALL_MASK 0x1U
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_BUFFERTOOSMALL_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_BUFFERTOOLARGE_MASK 0x2U
#define IMXDPUV1_FETCHDECODE1_DECODERSTATUS_BUFFERTOOLARGE_SHIFT 1U

/* Register: IMXDPUV1_FetchDecode1_ReadAddress0 */
#define IMXDPUV1_FETCHDECODE1_READADDRESS0                   ((uint32_t)(0x7868))
#define IMXDPUV1_FETCHDECODE1_READADDRESS0_OFFSET            ((uint32_t)(0x68))
#define IMXDPUV1_FETCHDECODE1_READADDRESS0_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE1_READADDRESS0_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_READADDRESS0_READADDRESS0_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_READADDRESS0_READADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_FetchDecode1_BurstBufferProperties */
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES          ((uint32_t)(0x786C))
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_OFFSET   ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHDECODE1_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode1_Status */
#define IMXDPUV1_FETCHDECODE1_STATUS                         ((uint32_t)(0x7870))
#define IMXDPUV1_FETCHDECODE1_STATUS_OFFSET                  ((uint32_t)(0x70))
#define IMXDPUV1_FETCHDECODE1_STATUS_RESET_VALUE             0U
#define IMXDPUV1_FETCHDECODE1_STATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHDECODE1_STATUS_WRITETIMEOUT_MASK       0x1U
#define IMXDPUV1_FETCHDECODE1_STATUS_WRITETIMEOUT_SHIFT      0U
#define IMXDPUV1_FETCHDECODE1_STATUS_READTIMEOUT_MASK        0x10U
#define IMXDPUV1_FETCHDECODE1_STATUS_READTIMEOUT_SHIFT       4U

/* Register: IMXDPUV1_FetchDecode1_HiddenStatus */
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS                   ((uint32_t)(0x7874))
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_OFFSET            ((uint32_t)(0x74))
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_RESET_MASK        0xFFFF008EU
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSBUSY_MASK   0x1U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSBUSY_SHIFT  0U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSREQUEST_MASK 0x20U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_SHADOWSTATUS_MASK 0xFF00U
#define IMXDPUV1_FETCHDECODE1_HIDDENSTATUS_SHADOWSTATUS_SHIFT 8U

/* Register: IMXDPUV1_FetchDecode1_ColorPalette */
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE                   ((uint32_t)(0x7C00))
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE_OFFSET            ((uint32_t)(0))
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE_RESET_VALUE       0U
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE_RESET_MASK        0xFF000000U
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE_COLORPALETTE_MASK 0xFFFFFFU
#define IMXDPUV1_FETCHDECODE1_COLORPALETTE_COLORPALETTE_SHIFT 0U

/* Register: IMXDPUV1_fetcheco1_LockUnlock */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK                        ((uint32_t)(0x8000))
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_OFFSET                 ((uint32_t)(0))
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_RESET_MASK             0U
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK_SHIFT       0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY   0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHECO1_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetcheco1_LockStatus */
#define IMXDPUV1_FETCHECO1_LOCKSTATUS                        ((uint32_t)(0x8004))
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_OFFSET                 ((uint32_t)(0x4))
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_RESET_VALUE            0U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_LOCKSTATUS_MASK        0x1U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_LOCKSTATUS_SHIFT       0U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_PRIVILEGESTATUS_MASK   0x10U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_PRIVILEGESTATUS_SHIFT  4U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_FREEZESTATUS_MASK      0x100U
#define IMXDPUV1_FETCHECO1_LOCKSTATUS_FREEZESTATUS_SHIFT     8U

/* Register: IMXDPUV1_fetcheco1_StaticControl */
#define IMXDPUV1_FETCHECO1_STATICCONTROL                     ((uint32_t)(0x8008))
#define IMXDPUV1_FETCHECO1_STATICCONTROL_OFFSET              ((uint32_t)(0x8))
#define IMXDPUV1_FETCHECO1_STATICCONTROL_RESET_VALUE         0U
#define IMXDPUV1_FETCHECO1_STATICCONTROL_RESET_MASK          0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_STATICCONTROL_SHDEN_MASK          0x1U
#define IMXDPUV1_FETCHECO1_STATICCONTROL_SHDEN_SHIFT         0U
#define IMXDPUV1_FETCHECO1_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO1_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U

/* Register: IMXDPUV1_fetcheco1_BurstBufferManagement */
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT             ((uint32_t)(0x800C))
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_OFFSET      ((uint32_t)(0xC))
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHECO1_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetcheco1_BaseAddress0 */
#define IMXDPUV1_FETCHECO1_BASEADDRESS0                      ((uint32_t)(0x8010))
#define IMXDPUV1_FETCHECO1_BASEADDRESS0_OFFSET               ((uint32_t)(0x10))
#define IMXDPUV1_FETCHECO1_BASEADDRESS0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO1_BASEADDRESS0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_BASEADDRESS0_BASEADDRESS0_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_BASEADDRESS0_BASEADDRESS0_SHIFT   0U

/* Register: IMXDPUV1_fetcheco1_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0           ((uint32_t)(0x8014))
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_OFFSET    ((uint32_t)(0x14))
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco1_SourceBufferDimension0 */
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0            ((uint32_t)(0x8018))
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_OFFSET     ((uint32_t)(0x18))
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO1_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco1_ColorComponentBits0 */
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0               ((uint32_t)(0x801C))
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_OFFSET        ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_RESET_VALUE   0x8080808U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco1_ColorComponentShift0 */
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0              ((uint32_t)(0x8020))
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_OFFSET       ((uint32_t)(0x20))
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_RESET_VALUE  0x18100800U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_RESET_MASK   0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHECO1_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco1_LayerOffset0 */
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0                      ((uint32_t)(0x8024))
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_OFFSET               ((uint32_t)(0x24))
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_LAYERXOFFSET0_MASK   0x7FFFU
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_LAYERXOFFSET0_SHIFT  0U
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_LAYERYOFFSET0_MASK   0x7FFF0000U
#define IMXDPUV1_FETCHECO1_LAYEROFFSET0_LAYERYOFFSET0_SHIFT  16U

/* Register: IMXDPUV1_fetcheco1_ClipWindowOffset0 */
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0                 ((uint32_t)(0x8028))
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_OFFSET          ((uint32_t)(0x28))
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_RESET_VALUE     0U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco1_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0             ((uint32_t)(0x802C))
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_OFFSET      ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHECO1_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetcheco1_ConstantColor0 */
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0                    ((uint32_t)(0x8030))
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_OFFSET             ((uint32_t)(0x30))
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTRED0_MASK  0xFF000000U
#define IMXDPUV1_FETCHECO1_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetcheco1_LayerProperty0 */
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0                    ((uint32_t)(0x8034))
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_OFFSET             ((uint32_t)(0x34))
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_RESET_VALUE        0x80000000U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0_MASK     0x30U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0_SHIFT    4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHECO1_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetcheco1_FrameDimensions */
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS                   ((uint32_t)(0x8038))
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_OFFSET            ((uint32_t)(0x38))
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_RESET_VALUE       0xEF013FU
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_FRAMEWIDTH_MASK   0x3FFFU
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT  0U
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK  0x3FFF0000U
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_EMPTYFRAME_MASK   0x80000000U
#define IMXDPUV1_FETCHECO1_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT  31U

/* Register: IMXDPUV1_fetcheco1_FrameResampling */
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING                   ((uint32_t)(0x803C))
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_OFFSET            ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_RESET_VALUE       0x104000U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_STARTX_MASK       0x3FU
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_STARTX_SHIFT      0U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_STARTY_MASK       0xFC0U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_STARTY_SHIFT      6U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_DELTAX_MASK       0x3F000U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_DELTAX_SHIFT      12U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_DELTAY_MASK       0xFC0000U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_DELTAY_SHIFT      18U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHECO1_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetcheco1_Control */
#define IMXDPUV1_FETCHECO1_CONTROL                           ((uint32_t)(0x8040))
#define IMXDPUV1_FETCHECO1_CONTROL_OFFSET                    ((uint32_t)(0x40))
#define IMXDPUV1_FETCHECO1_CONTROL_RESET_VALUE               0x10000U
#define IMXDPUV1_FETCHECO1_CONTROL_RESET_MASK                0xFFFFFFFFU
#define IMXDPUV1_FETCHECO1_CONTROL_RAWPIXEL_MASK             0x80U
#define IMXDPUV1_FETCHECO1_CONTROL_RAWPIXEL_SHIFT            7U
#define IMXDPUV1_FETCHECO1_CONTROL_CLIPCOLOR_MASK            0x10000U
#define IMXDPUV1_FETCHECO1_CONTROL_CLIPCOLOR_SHIFT           16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHECO1_CONTROL_CLIPCOLOR__NULL           0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHECO1_CONTROL_CLIPCOLOR__LAYER          0x1U

/* Register: IMXDPUV1_fetcheco1_ControlTrigger */
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER                    ((uint32_t)(0x8044))
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER_OFFSET             ((uint32_t)(0x44))
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER_RESET_VALUE        0U
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER_RESET_MASK         0xFFFFFFFEU
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER_SHDTOKGEN_MASK     0x1U
#define IMXDPUV1_FETCHECO1_CONTROLTRIGGER_SHDTOKGEN_SHIFT    0U

/* Register: IMXDPUV1_fetcheco1_Start */
#define IMXDPUV1_FETCHECO1_START                             ((uint32_t)(0x8048))
#define IMXDPUV1_FETCHECO1_START_OFFSET                      ((uint32_t)(0x48))
#define IMXDPUV1_FETCHECO1_START_RESET_VALUE                 0U
#define IMXDPUV1_FETCHECO1_START_RESET_MASK                  0xFFFFFFFEU
#define IMXDPUV1_FETCHECO1_START_START_MASK                  0x1U
#define IMXDPUV1_FETCHECO1_START_START_SHIFT                 0U

/* Register: IMXDPUV1_fetcheco1_FetchType */
#define IMXDPUV1_FETCHECO1_FETCHTYPE                         ((uint32_t)(0x804C))
#define IMXDPUV1_FETCHECO1_FETCHTYPE_OFFSET                  ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHECO1_FETCHTYPE_RESET_VALUE             0U
#define IMXDPUV1_FETCHECO1_FETCHTYPE_RESET_MASK              0xFFFFFFF0U
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE_MASK          0xFU
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE_SHIFT         0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__DECODE       0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__LAYER        0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__WARP         0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__ECO          0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__PERSP        0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__ROT          0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__DECODEL      0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__LAYERL       0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHECO1_FETCHTYPE_FETCHTYPE__ROTL         0x8U

/* Register: IMXDPUV1_fetcheco1_BurstBufferProperties */
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES             ((uint32_t)(0x8050))
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_OFFSET      ((uint32_t)(0x50))
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_RESET_MASK  0xFFFFE000U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHECO1_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetcheco1_HiddenStatus */
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS                      ((uint32_t)(0x8054))
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_OFFSET               ((uint32_t)(0x54))
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_RESET_VALUE          0U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_RESET_MASK           0xFFFF008EU
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSBUSY_MASK      0x1U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSBUSY_SHIFT     0U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSREQUEST_MASK   0x20U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSREQUEST_SHIFT  5U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSCOMPLETE_MASK  0x40U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_SHADOWSTATUS_MASK    0xFF00U
#define IMXDPUV1_FETCHECO1_HIDDENSTATUS_SHADOWSTATUS_SHIFT   8U

/* Register: IMXDPUV1_fetchlayer0_LockUnlock */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK                      ((uint32_t)(0x8400))
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_FETCHLAYER0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_fetchlayer0_LockStatus */
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS                      ((uint32_t)(0x8404))
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_FETCHLAYER0_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_fetchlayer0_StaticControl */
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL                   ((uint32_t)(0x8408))
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_RESET_VALUE       0xFF000000U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_SHDEN_SHIFT       0U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_BASEADDRESSAUTOUPDATE_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_BASEADDRESSAUTOUPDATE_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_SHDLDREQSTICKY_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_STATICCONTROL_SHDLDREQSTICKY_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_BurstBufferManagement */
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT           ((uint32_t)(0x840C))
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_OFFSET    ((uint32_t)(0xC))
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_RESET_VALUE 0x404U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_SETNUMBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_SETBURSTLENGTH_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_LINEMODE_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_LINEMODE_SHIFT 31U
/* Field Value: LINEMODE__DISPLAY, Mandatory setting for operation in the
 * Display Controller. Works also for Blit Engine with marginal performance
 * impact.  */
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_LINEMODE__DISPLAY 0U
/* Field Value: LINEMODE__BLIT, Recommended setting for operation in the Blit
 * Engine.  */
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERMANAGEMENT_LINEMODE__BLIT 0x1U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress0 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0                    ((uint32_t)(0x8410))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0_OFFSET             ((uint32_t)(0x10))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0_BASEADDRESS0_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS0_BASEADDRESS0_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes0 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0         ((uint32_t)(0x8414))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_OFFSET  ((uint32_t)(0x14))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_RESET_VALUE 0x2004FFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_STRIDE0_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_STRIDE0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES0_BITSPERPIXEL0_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension0 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0          ((uint32_t)(0x8418))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_OFFSET   ((uint32_t)(0x18))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_LINEWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_LINECOUNT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION0_LINECOUNT0_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits0 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0             ((uint32_t)(0x841C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_OFFSET      ((uint32_t)(0x1C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_COMPONENTBITSRED0_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_ITUFORMAT0_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS0_ITUFORMAT0_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift0 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0            ((uint32_t)(0x8420))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_OFFSET     ((uint32_t)(0x20))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT0_COMPONENTSHIFTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset0 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0                    ((uint32_t)(0x8424))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_OFFSET             ((uint32_t)(0x24))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_LAYERXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_LAYERXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_LAYERYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET0_LAYERYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset0 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0               ((uint32_t)(0x8428))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_OFFSET        ((uint32_t)(0x28))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_CLIPWINDOWXOFFSET0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET0_CLIPWINDOWYOFFSET0_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions0 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0           ((uint32_t)(0x842C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_OFFSET    ((uint32_t)(0x2C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWWIDTH0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS0_CLIPWINDOWHEIGHT0_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor0 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0                  ((uint32_t)(0x8430))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_OFFSET           ((uint32_t)(0x30))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTALPHA0_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTALPHA0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTBLUE0_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTBLUE0_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTGREEN0_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTGREEN0_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTRED0_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR0_CONSTANTRED0_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty0 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0                  ((uint32_t)(0x8434))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_OFFSET           ((uint32_t)(0x34))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RESET_VALUE      0x80000100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_PALETTEENABLE0_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_PALETTEENABLE0_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0_SHIFT  4U
/* Field Value: TILEMODE0__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE0__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE0__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0__TILE_PAD 0x2U
/* Field Value: TILEMODE0__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_TILEMODE0__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHASRCENABLE0_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHASRCENABLE0_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHACONSTENABLE0_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHACONSTENABLE0_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHATRANSENABLE0_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_ALPHATRANSENABLE0_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHASRCENABLE0_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHASRCENABLE0_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHACONSTENABLE0_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHACONSTENABLE0_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHATRANSENABLE0_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_RGBALPHATRANSENABLE0_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_PREMULCONSTRGB0_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_PREMULCONSTRGB0_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE0__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0__OFF 0U
/* Field Value: YUVCONVERSIONMODE0__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE0__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE0__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_YUVCONVERSIONMODE0__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_GAMMAREMOVEENABLE0_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_GAMMAREMOVEENABLE0_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_CLIPWINDOWENABLE0_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_CLIPWINDOWENABLE0_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY0_SOURCEBUFFERENABLE0_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress1 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1                    ((uint32_t)(0x8438))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1_OFFSET             ((uint32_t)(0x38))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1_BASEADDRESS1_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS1_BASEADDRESS1_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes1 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1         ((uint32_t)(0x843C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_OFFSET  ((uint32_t)(0x3C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_STRIDE1_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_STRIDE1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES1_BITSPERPIXEL1_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension1 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1          ((uint32_t)(0x8440))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_OFFSET   ((uint32_t)(0x40))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_LINEWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_LINEWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_LINECOUNT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION1_LINECOUNT1_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits1 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1             ((uint32_t)(0x8444))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_OFFSET      ((uint32_t)(0x44))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSRED1_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_COMPONENTBITSRED1_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_ITUFORMAT1_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS1_ITUFORMAT1_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift1 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1            ((uint32_t)(0x8448))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_OFFSET     ((uint32_t)(0x48))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT1_COMPONENTSHIFTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset1 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1                    ((uint32_t)(0x844C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_OFFSET             ((uint32_t)(0x4C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_LAYERXOFFSET1_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_LAYERXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_LAYERYOFFSET1_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET1_LAYERYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset1 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1               ((uint32_t)(0x8450))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_OFFSET        ((uint32_t)(0x50))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_CLIPWINDOWXOFFSET1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET1_CLIPWINDOWYOFFSET1_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions1 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1           ((uint32_t)(0x8454))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_OFFSET    ((uint32_t)(0x54))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_CLIPWINDOWWIDTH1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS1_CLIPWINDOWHEIGHT1_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor1 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1                  ((uint32_t)(0x8458))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_OFFSET           ((uint32_t)(0x58))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTALPHA1_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTALPHA1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTBLUE1_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTBLUE1_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTGREEN1_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTGREEN1_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTRED1_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR1_CONSTANTRED1_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty1 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1                  ((uint32_t)(0x845C))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_OFFSET           ((uint32_t)(0x5C))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_PALETTEENABLE1_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_PALETTEENABLE1_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1_SHIFT  4U
/* Field Value: TILEMODE1__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE1__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE1__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1__TILE_PAD 0x2U
/* Field Value: TILEMODE1__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_TILEMODE1__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHASRCENABLE1_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHASRCENABLE1_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHACONSTENABLE1_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHACONSTENABLE1_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHATRANSENABLE1_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_ALPHATRANSENABLE1_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHASRCENABLE1_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHASRCENABLE1_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHACONSTENABLE1_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHACONSTENABLE1_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHATRANSENABLE1_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_RGBALPHATRANSENABLE1_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_PREMULCONSTRGB1_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_PREMULCONSTRGB1_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE1__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1__OFF 0U
/* Field Value: YUVCONVERSIONMODE1__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE1__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE1__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_YUVCONVERSIONMODE1__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_GAMMAREMOVEENABLE1_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_GAMMAREMOVEENABLE1_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_CLIPWINDOWENABLE1_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_CLIPWINDOWENABLE1_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_SOURCEBUFFERENABLE1_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY1_SOURCEBUFFERENABLE1_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress2 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2                    ((uint32_t)(0x8460))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2_OFFSET             ((uint32_t)(0x60))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2_BASEADDRESS2_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS2_BASEADDRESS2_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes2 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2         ((uint32_t)(0x8464))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_OFFSET  ((uint32_t)(0x64))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_STRIDE2_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_STRIDE2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES2_BITSPERPIXEL2_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension2 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2          ((uint32_t)(0x8468))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_OFFSET   ((uint32_t)(0x68))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_LINEWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_LINEWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_LINECOUNT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION2_LINECOUNT2_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits2 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2             ((uint32_t)(0x846C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_OFFSET      ((uint32_t)(0x6C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSRED2_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_COMPONENTBITSRED2_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_ITUFORMAT2_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS2_ITUFORMAT2_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift2 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2            ((uint32_t)(0x8470))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_OFFSET     ((uint32_t)(0x70))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT2_COMPONENTSHIFTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset2 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2                    ((uint32_t)(0x8474))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_OFFSET             ((uint32_t)(0x74))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_LAYERXOFFSET2_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_LAYERXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_LAYERYOFFSET2_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET2_LAYERYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset2 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2               ((uint32_t)(0x8478))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_OFFSET        ((uint32_t)(0x78))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_CLIPWINDOWXOFFSET2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET2_CLIPWINDOWYOFFSET2_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions2 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2           ((uint32_t)(0x847C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_OFFSET    ((uint32_t)(0x7C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_CLIPWINDOWWIDTH2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS2_CLIPWINDOWHEIGHT2_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor2 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2                  ((uint32_t)(0x8480))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_OFFSET           ((uint32_t)(0x80))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTALPHA2_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTALPHA2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTBLUE2_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTBLUE2_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTGREEN2_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTGREEN2_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTRED2_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR2_CONSTANTRED2_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty2 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2                  ((uint32_t)(0x8484))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_OFFSET           ((uint32_t)(0x84))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_PALETTEENABLE2_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_PALETTEENABLE2_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2_SHIFT  4U
/* Field Value: TILEMODE2__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE2__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE2__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2__TILE_PAD 0x2U
/* Field Value: TILEMODE2__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_TILEMODE2__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHASRCENABLE2_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHASRCENABLE2_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHACONSTENABLE2_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHACONSTENABLE2_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHATRANSENABLE2_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_ALPHATRANSENABLE2_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHASRCENABLE2_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHASRCENABLE2_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHACONSTENABLE2_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHACONSTENABLE2_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHATRANSENABLE2_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_RGBALPHATRANSENABLE2_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_PREMULCONSTRGB2_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_PREMULCONSTRGB2_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE2__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2__OFF 0U
/* Field Value: YUVCONVERSIONMODE2__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE2__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE2__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_YUVCONVERSIONMODE2__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_GAMMAREMOVEENABLE2_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_GAMMAREMOVEENABLE2_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_CLIPWINDOWENABLE2_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_CLIPWINDOWENABLE2_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_SOURCEBUFFERENABLE2_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY2_SOURCEBUFFERENABLE2_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress3 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3                    ((uint32_t)(0x8488))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3_OFFSET             ((uint32_t)(0x88))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3_BASEADDRESS3_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS3_BASEADDRESS3_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes3 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3         ((uint32_t)(0x848C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_OFFSET  ((uint32_t)(0x8C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_STRIDE3_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_STRIDE3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES3_BITSPERPIXEL3_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension3 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3          ((uint32_t)(0x8490))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_OFFSET   ((uint32_t)(0x90))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_LINEWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_LINEWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_LINECOUNT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION3_LINECOUNT3_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits3 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3             ((uint32_t)(0x8494))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_OFFSET      ((uint32_t)(0x94))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSRED3_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_COMPONENTBITSRED3_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_ITUFORMAT3_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS3_ITUFORMAT3_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift3 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3            ((uint32_t)(0x8498))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_OFFSET     ((uint32_t)(0x98))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT3_COMPONENTSHIFTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset3 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3                    ((uint32_t)(0x849C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_OFFSET             ((uint32_t)(0x9C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_LAYERXOFFSET3_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_LAYERXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_LAYERYOFFSET3_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET3_LAYERYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset3 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3               ((uint32_t)(0x84A0))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_OFFSET        ((uint32_t)(0xA0))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_CLIPWINDOWXOFFSET3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET3_CLIPWINDOWYOFFSET3_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions3 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3           ((uint32_t)(0x84A4))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_OFFSET    ((uint32_t)(0xA4))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_CLIPWINDOWWIDTH3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS3_CLIPWINDOWHEIGHT3_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor3 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3                  ((uint32_t)(0x84A8))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_OFFSET           ((uint32_t)(0xA8))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTALPHA3_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTALPHA3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTBLUE3_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTBLUE3_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTGREEN3_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTGREEN3_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTRED3_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR3_CONSTANTRED3_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty3 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3                  ((uint32_t)(0x84AC))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_OFFSET           ((uint32_t)(0xAC))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_PALETTEENABLE3_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_PALETTEENABLE3_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3_SHIFT  4U
/* Field Value: TILEMODE3__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE3__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE3__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3__TILE_PAD 0x2U
/* Field Value: TILEMODE3__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_TILEMODE3__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHASRCENABLE3_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHASRCENABLE3_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHACONSTENABLE3_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHACONSTENABLE3_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHATRANSENABLE3_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_ALPHATRANSENABLE3_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHASRCENABLE3_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHASRCENABLE3_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHACONSTENABLE3_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHACONSTENABLE3_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHATRANSENABLE3_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_RGBALPHATRANSENABLE3_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_PREMULCONSTRGB3_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_PREMULCONSTRGB3_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE3__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3__OFF 0U
/* Field Value: YUVCONVERSIONMODE3__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE3__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE3__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_YUVCONVERSIONMODE3__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_GAMMAREMOVEENABLE3_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_GAMMAREMOVEENABLE3_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_CLIPWINDOWENABLE3_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_CLIPWINDOWENABLE3_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_SOURCEBUFFERENABLE3_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY3_SOURCEBUFFERENABLE3_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress4 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4                    ((uint32_t)(0x84B0))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4_OFFSET             ((uint32_t)(0xB0))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4_BASEADDRESS4_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS4_BASEADDRESS4_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes4 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4         ((uint32_t)(0x84B4))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_OFFSET  ((uint32_t)(0xB4))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_STRIDE4_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_STRIDE4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES4_BITSPERPIXEL4_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension4 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4          ((uint32_t)(0x84B8))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_OFFSET   ((uint32_t)(0xB8))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_LINEWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_LINEWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_LINECOUNT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION4_LINECOUNT4_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits4 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4             ((uint32_t)(0x84BC))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_OFFSET      ((uint32_t)(0xBC))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSRED4_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_COMPONENTBITSRED4_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_ITUFORMAT4_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS4_ITUFORMAT4_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift4 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4            ((uint32_t)(0x84C0))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_OFFSET     ((uint32_t)(0xC0))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT4_COMPONENTSHIFTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset4 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4                    ((uint32_t)(0x84C4))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_OFFSET             ((uint32_t)(0xC4))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_LAYERXOFFSET4_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_LAYERXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_LAYERYOFFSET4_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET4_LAYERYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset4 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4               ((uint32_t)(0x84C8))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_OFFSET        ((uint32_t)(0xC8))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_CLIPWINDOWXOFFSET4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET4_CLIPWINDOWYOFFSET4_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions4 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4           ((uint32_t)(0x84CC))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_OFFSET    ((uint32_t)(0xCC))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_CLIPWINDOWWIDTH4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS4_CLIPWINDOWHEIGHT4_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor4 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4                  ((uint32_t)(0x84D0))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_OFFSET           ((uint32_t)(0xD0))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTALPHA4_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTALPHA4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTBLUE4_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTBLUE4_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTGREEN4_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTGREEN4_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTRED4_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR4_CONSTANTRED4_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty4 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4                  ((uint32_t)(0x84D4))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_OFFSET           ((uint32_t)(0xD4))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_PALETTEENABLE4_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_PALETTEENABLE4_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4_SHIFT  4U
/* Field Value: TILEMODE4__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE4__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE4__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4__TILE_PAD 0x2U
/* Field Value: TILEMODE4__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_TILEMODE4__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHASRCENABLE4_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHASRCENABLE4_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHACONSTENABLE4_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHACONSTENABLE4_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHATRANSENABLE4_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_ALPHATRANSENABLE4_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHASRCENABLE4_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHASRCENABLE4_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHACONSTENABLE4_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHACONSTENABLE4_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHATRANSENABLE4_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_RGBALPHATRANSENABLE4_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_PREMULCONSTRGB4_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_PREMULCONSTRGB4_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE4__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4__OFF 0U
/* Field Value: YUVCONVERSIONMODE4__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE4__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE4__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_YUVCONVERSIONMODE4__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_GAMMAREMOVEENABLE4_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_GAMMAREMOVEENABLE4_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_CLIPWINDOWENABLE4_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_CLIPWINDOWENABLE4_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_SOURCEBUFFERENABLE4_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY4_SOURCEBUFFERENABLE4_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress5 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5                    ((uint32_t)(0x84D8))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5_OFFSET             ((uint32_t)(0xD8))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5_BASEADDRESS5_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS5_BASEADDRESS5_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes5 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5         ((uint32_t)(0x84DC))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_OFFSET  ((uint32_t)(0xDC))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_STRIDE5_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_STRIDE5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES5_BITSPERPIXEL5_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension5 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5          ((uint32_t)(0x84E0))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_OFFSET   ((uint32_t)(0xE0))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_LINEWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_LINEWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_LINECOUNT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION5_LINECOUNT5_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits5 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5             ((uint32_t)(0x84E4))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_OFFSET      ((uint32_t)(0xE4))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSRED5_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_COMPONENTBITSRED5_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_ITUFORMAT5_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS5_ITUFORMAT5_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift5 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5            ((uint32_t)(0x84E8))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_OFFSET     ((uint32_t)(0xE8))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT5_COMPONENTSHIFTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset5 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5                    ((uint32_t)(0x84EC))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_OFFSET             ((uint32_t)(0xEC))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_LAYERXOFFSET5_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_LAYERXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_LAYERYOFFSET5_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET5_LAYERYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset5 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5               ((uint32_t)(0x84F0))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_OFFSET        ((uint32_t)(0xF0))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_CLIPWINDOWXOFFSET5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET5_CLIPWINDOWYOFFSET5_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions5 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5           ((uint32_t)(0x84F4))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_OFFSET    ((uint32_t)(0xF4))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_CLIPWINDOWWIDTH5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS5_CLIPWINDOWHEIGHT5_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor5 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5                  ((uint32_t)(0x84F8))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_OFFSET           ((uint32_t)(0xF8))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTALPHA5_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTALPHA5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTBLUE5_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTBLUE5_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTGREEN5_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTGREEN5_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTRED5_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR5_CONSTANTRED5_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty5 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5                  ((uint32_t)(0x84FC))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_OFFSET           ((uint32_t)(0xFC))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_PALETTEENABLE5_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_PALETTEENABLE5_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5_SHIFT  4U
/* Field Value: TILEMODE5__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE5__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE5__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5__TILE_PAD 0x2U
/* Field Value: TILEMODE5__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_TILEMODE5__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHASRCENABLE5_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHASRCENABLE5_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHACONSTENABLE5_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHACONSTENABLE5_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHATRANSENABLE5_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_ALPHATRANSENABLE5_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHASRCENABLE5_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHASRCENABLE5_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHACONSTENABLE5_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHACONSTENABLE5_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHATRANSENABLE5_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_RGBALPHATRANSENABLE5_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_PREMULCONSTRGB5_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_PREMULCONSTRGB5_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE5__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5__OFF 0U
/* Field Value: YUVCONVERSIONMODE5__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE5__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE5__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_YUVCONVERSIONMODE5__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_GAMMAREMOVEENABLE5_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_GAMMAREMOVEENABLE5_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_CLIPWINDOWENABLE5_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_CLIPWINDOWENABLE5_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_SOURCEBUFFERENABLE5_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY5_SOURCEBUFFERENABLE5_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress6 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6                    ((uint32_t)(0x8500))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6_OFFSET             ((uint32_t)(0x100))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6_BASEADDRESS6_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS6_BASEADDRESS6_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes6 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6         ((uint32_t)(0x8504))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_OFFSET  ((uint32_t)(0x104))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_STRIDE6_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_STRIDE6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES6_BITSPERPIXEL6_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension6 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6          ((uint32_t)(0x8508))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_OFFSET   ((uint32_t)(0x108))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_LINEWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_LINEWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_LINECOUNT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION6_LINECOUNT6_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits6 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6             ((uint32_t)(0x850C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_OFFSET      ((uint32_t)(0x10C))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSRED6_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_COMPONENTBITSRED6_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_ITUFORMAT6_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS6_ITUFORMAT6_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift6 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6            ((uint32_t)(0x8510))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_OFFSET     ((uint32_t)(0x110))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT6_COMPONENTSHIFTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset6 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6                    ((uint32_t)(0x8514))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_OFFSET             ((uint32_t)(0x114))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_LAYERXOFFSET6_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_LAYERXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_LAYERYOFFSET6_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET6_LAYERYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset6 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6               ((uint32_t)(0x8518))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_OFFSET        ((uint32_t)(0x118))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_CLIPWINDOWXOFFSET6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET6_CLIPWINDOWYOFFSET6_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions6 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6           ((uint32_t)(0x851C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_OFFSET    ((uint32_t)(0x11C))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_CLIPWINDOWWIDTH6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS6_CLIPWINDOWHEIGHT6_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor6 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6                  ((uint32_t)(0x8520))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_OFFSET           ((uint32_t)(0x120))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTALPHA6_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTALPHA6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTBLUE6_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTBLUE6_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTGREEN6_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTGREEN6_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTRED6_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR6_CONSTANTRED6_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty6 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6                  ((uint32_t)(0x8524))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_OFFSET           ((uint32_t)(0x124))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_PALETTEENABLE6_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_PALETTEENABLE6_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6_SHIFT  4U
/* Field Value: TILEMODE6__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE6__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE6__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6__TILE_PAD 0x2U
/* Field Value: TILEMODE6__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_TILEMODE6__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHASRCENABLE6_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHASRCENABLE6_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHACONSTENABLE6_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHACONSTENABLE6_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHATRANSENABLE6_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_ALPHATRANSENABLE6_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHASRCENABLE6_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHASRCENABLE6_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHACONSTENABLE6_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHACONSTENABLE6_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHATRANSENABLE6_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_RGBALPHATRANSENABLE6_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_PREMULCONSTRGB6_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_PREMULCONSTRGB6_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE6__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6__OFF 0U
/* Field Value: YUVCONVERSIONMODE6__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE6__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE6__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_YUVCONVERSIONMODE6__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_GAMMAREMOVEENABLE6_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_GAMMAREMOVEENABLE6_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_CLIPWINDOWENABLE6_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_CLIPWINDOWENABLE6_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_SOURCEBUFFERENABLE6_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY6_SOURCEBUFFERENABLE6_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_BaseAddress7 */
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7                    ((uint32_t)(0x8528))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7_OFFSET             ((uint32_t)(0x128))
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7_BASEADDRESS7_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_BASEADDRESS7_BASEADDRESS7_SHIFT 0U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferAttributes7 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7         ((uint32_t)(0x852C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_OFFSET  ((uint32_t)(0x12C))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_RESET_VALUE 0x200003U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_STRIDE7_MASK 0xFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_STRIDE7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_MASK 0x3F0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERATTRIBUTES7_BITSPERPIXEL7_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_SourceBufferDimension7 */
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7          ((uint32_t)(0x8530))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_OFFSET   ((uint32_t)(0x130))
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_RESET_VALUE 0x3FFF3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_LINEWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_LINEWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_LINECOUNT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_SOURCEBUFFERDIMENSION7_LINECOUNT7_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentBits7 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7             ((uint32_t)(0x8534))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_OFFSET      ((uint32_t)(0x134))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_RESET_VALUE 0x8080808U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_RESET_MASK  0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_MASK 0xFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_MASK 0xF00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_MASK 0xF0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSRED7_MASK 0xF000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_COMPONENTBITSRED7_SHIFT 24U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_ITUFORMAT7_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTBITS7_ITUFORMAT7_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_ColorComponentShift7 */
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7            ((uint32_t)(0x8538))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_OFFSET     ((uint32_t)(0x138))
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_RESET_VALUE 0x18100800U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_MASK 0x1FU
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_MASK 0x1F0000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_MASK 0x1F000000U
#define IMXDPUV1_FETCHLAYER0_COLORCOMPONENTSHIFT7_COMPONENTSHIFTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerOffset7 */
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7                    ((uint32_t)(0x853C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_OFFSET             ((uint32_t)(0x13C))
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_LAYERXOFFSET7_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_LAYERXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_LAYERYOFFSET7_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_LAYEROFFSET7_LAYERYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowOffset7 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7               ((uint32_t)(0x8540))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_OFFSET        ((uint32_t)(0x140))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_RESET_VALUE   0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_RESET_MASK    0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_MASK 0x7FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_CLIPWINDOWXOFFSET7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_MASK 0x7FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWOFFSET7_CLIPWINDOWYOFFSET7_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ClipWindowDimensions7 */
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7           ((uint32_t)(0x8544))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_OFFSET    ((uint32_t)(0x144))
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_RESET_MASK 0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_CLIPWINDOWWIDTH7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_CLIPWINDOWDIMENSIONS7_CLIPWINDOWHEIGHT7_SHIFT 16U

/* Register: IMXDPUV1_fetchlayer0_ConstantColor7 */
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7                  ((uint32_t)(0x8548))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_OFFSET           ((uint32_t)(0x148))
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTALPHA7_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTALPHA7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTBLUE7_MASK 0xFF00U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTBLUE7_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTGREEN7_MASK 0xFF0000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTGREEN7_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTRED7_MASK 0xFF000000U
#define IMXDPUV1_FETCHLAYER0_CONSTANTCOLOR7_CONSTANTRED7_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_LayerProperty7 */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7                  ((uint32_t)(0x854C))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_OFFSET           ((uint32_t)(0x14C))
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RESET_VALUE      0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RESET_MASK       0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_PALETTEENABLE7_MASK 0x1U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_PALETTEENABLE7_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7_MASK   0x30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7_SHIFT  4U
/* Field Value: TILEMODE7__TILE_FILL_ZERO, Use zero value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7__TILE_FILL_ZERO 0U
/* Field Value: TILEMODE7__TILE_FILL_CONSTANT, Use constant color register
 * value  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7__TILE_FILL_CONSTANT 0x1U
/* Field Value: TILEMODE7__TILE_PAD, Use closest pixel from source buffer.
 * Must not be used for DECODE or YUV422 operations or when SourceBufferEnable
 * is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7__TILE_PAD 0x2U
/* Field Value: TILEMODE7__TILE_PAD_ZERO, Use closest pixel from source buffer
 * but zero for alpha component. Must not be used for DECODE or YUV422
 * operations or when SourceBufferEnable is 0.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_TILEMODE7__TILE_PAD_ZERO 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHASRCENABLE7_MASK 0x100U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHASRCENABLE7_SHIFT 8U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHACONSTENABLE7_MASK 0x200U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHACONSTENABLE7_SHIFT 9U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHATRANSENABLE7_MASK 0x800U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_ALPHATRANSENABLE7_SHIFT 11U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHASRCENABLE7_MASK 0x1000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHASRCENABLE7_SHIFT 12U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHACONSTENABLE7_MASK 0x2000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHACONSTENABLE7_SHIFT 13U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHATRANSENABLE7_MASK 0x8000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_RGBALPHATRANSENABLE7_SHIFT 15U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_PREMULCONSTRGB7_MASK 0x10000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_PREMULCONSTRGB7_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7_MASK 0x60000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7_SHIFT 17U
/* Field Value: YUVCONVERSIONMODE7__OFF, No conversion.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7__OFF 0U
/* Field Value: YUVCONVERSIONMODE7__ITU601, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.601-6 (standard definition TV).
 * Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601 0x1U
/* Field Value: YUVCONVERSIONMODE7__ITU601_FR, Conversion from YCbCr (YUV)
 * to RGB according to ITU recommendation BT.601-6, but assuming full range
 * YUV inputs (0..255). Most typically used for computer graphics (e.g.
 * for JPEG encoding).  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU601_FR 0x2U
/* Field Value: YUVCONVERSIONMODE7__ITU709, Conversion from YCbCr (YUV) to
 * RGB according to ITU recommendation BT.709-5 part 2 (high definition
 * TV). Input range is 16..235 for Y and 16..240 for U/V.  */
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_YUVCONVERSIONMODE7__ITU709 0x3U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_GAMMAREMOVEENABLE7_MASK 0x100000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_GAMMAREMOVEENABLE7_SHIFT 20U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_CLIPWINDOWENABLE7_MASK 0x40000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_CLIPWINDOWENABLE7_SHIFT 30U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_SOURCEBUFFERENABLE7_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_LAYERPROPERTY7_SOURCEBUFFERENABLE7_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_FrameDimensions */
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS                 ((uint32_t)(0x8550))
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_OFFSET          ((uint32_t)(0x150))
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_RESET_VALUE     0xEF013FU
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_FRAMEWIDTH_MASK 0x3FFFU
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_FRAMEWIDTH_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_FRAMEHEIGHT_MASK 0x3FFF0000U
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_FRAMEHEIGHT_SHIFT 16U
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_EMPTYFRAME_MASK 0x80000000U
#define IMXDPUV1_FETCHLAYER0_FRAMEDIMENSIONS_EMPTYFRAME_SHIFT 31U

/* Register: IMXDPUV1_fetchlayer0_FrameResampling */
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING                 ((uint32_t)(0x8554))
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_OFFSET          ((uint32_t)(0x154))
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_RESET_VALUE     0x104000U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_RESET_MASK      0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_STARTX_MASK     0x3FU
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_STARTX_SHIFT    0U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_STARTY_MASK     0xFC0U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_STARTY_SHIFT    6U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_DELTAX_MASK     0x3F000U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_DELTAX_SHIFT    12U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_DELTAY_MASK     0xFC0000U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_DELTAY_SHIFT    18U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_SWAPDIRECTION_MASK 0x1000000U
#define IMXDPUV1_FETCHLAYER0_FRAMERESAMPLING_SWAPDIRECTION_SHIFT 24U

/* Register: IMXDPUV1_fetchlayer0_Control */
#define IMXDPUV1_FETCHLAYER0_CONTROL                         ((uint32_t)(0x8558))
#define IMXDPUV1_FETCHLAYER0_CONTROL_OFFSET                  ((uint32_t)(0x158))
#define IMXDPUV1_FETCHLAYER0_CONTROL_RESET_VALUE             0x10700U
#define IMXDPUV1_FETCHLAYER0_CONTROL_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_CONTROL_RAWPIXEL_MASK           0x80U
#define IMXDPUV1_FETCHLAYER0_CONTROL_RAWPIXEL_SHIFT          7U
#define IMXDPUV1_FETCHLAYER0_CONTROL_PALETTEIDXWIDTH_MASK    0x700U
#define IMXDPUV1_FETCHLAYER0_CONTROL_PALETTEIDXWIDTH_SHIFT   8U
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPCOLOR_MASK          0x10000U
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPCOLOR_SHIFT         16U
/* Field Value: CLIPCOLOR__NULL, Null color.  */
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPCOLOR__NULL         0U
/* Field Value: CLIPCOLOR__LAYER, Color of layer number given by ClipLayer
 * (or layer 0 when Fetch unit has one layer only). The color is then the
 * layer's source or tiling color.  */
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPCOLOR__LAYER        0x1U
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPLAYER_MASK          0xE0000U
#define IMXDPUV1_FETCHLAYER0_CONTROL_CLIPLAYER_SHIFT         17U

/* Register: IMXDPUV1_fetchlayer0_TriggerEnable */
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE                   ((uint32_t)(0x855C))
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE_OFFSET            ((uint32_t)(0x15C))
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE_RESET_VALUE       0U
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE_SHDLDREQ_MASK     0xFFU
#define IMXDPUV1_FETCHLAYER0_TRIGGERENABLE_SHDLDREQ_SHIFT    0U

/* Register: IMXDPUV1_fetchlayer0_ControlTrigger */
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER                  ((uint32_t)(0x8560))
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER_OFFSET           ((uint32_t)(0x160))
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER_RESET_VALUE      0U
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER_RESET_MASK       0xFFFFFFFEU
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER_SHDTOKGEN_MASK   0x1U
#define IMXDPUV1_FETCHLAYER0_CONTROLTRIGGER_SHDTOKGEN_SHIFT  0U

/* Register: IMXDPUV1_fetchlayer0_Start */
#define IMXDPUV1_FETCHLAYER0_START                           ((uint32_t)(0x8564))
#define IMXDPUV1_FETCHLAYER0_START_OFFSET                    ((uint32_t)(0x164))
#define IMXDPUV1_FETCHLAYER0_START_RESET_VALUE               0U
#define IMXDPUV1_FETCHLAYER0_START_RESET_MASK                0xFFFFFFFEU
#define IMXDPUV1_FETCHLAYER0_START_START_MASK                0x1U
#define IMXDPUV1_FETCHLAYER0_START_START_SHIFT               0U

/* Register: IMXDPUV1_fetchlayer0_FetchType */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE                       ((uint32_t)(0x8568))
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_OFFSET                ((uint32_t)(0x168))
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_RESET_VALUE           0U
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_RESET_MASK            0xFFFFFFF0U
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE_MASK        0xFU
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE_SHIFT       0U
/* Field Value: FETCHTYPE__DECODE, Fetch unit with RL and RLAD decoder.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__DECODE     0U
/* Field Value: FETCHTYPE__LAYER, Fetch unit with fractional plane (8 layers).  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__LAYER      0x1U
/* Field Value: FETCHTYPE__WARP, Fetch unit with arbitrary warping and fractional
 * plane (8 layers).  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__WARP       0x2U
/* Field Value: FETCHTYPE__ECO, Fetch unit with minimum feature set for alpha,
 * chroma and coordinate planes.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__ECO        0x3U
/* Field Value: FETCHTYPE__PERSP, Fetch unit with affine, perspective and
 * arbitrary warping.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__PERSP      0x4U
/* Field Value: FETCHTYPE__ROT, Fetch unit with affine and arbitrary warping.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__ROT        0x5U
/* Field Value: FETCHTYPE__DECODEL, Fetch unit with RL and RLAD decoder, reduced
 * feature set.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__DECODEL    0x6U
/* Field Value: FETCHTYPE__LAYERL, Fetch unit with fractional plane (8 layers),
 * reduced feature set.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__LAYERL     0x7U
/* Field Value: FETCHTYPE__ROTL, Fetch unit with affine and arbitrary warping,
 * reduced feature set.  */
#define IMXDPUV1_FETCHLAYER0_FETCHTYPE_FETCHTYPE__ROTL       0x8U

/* Register: IMXDPUV1_fetchlayer0_BurstBufferProperties */
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES           ((uint32_t)(0x856C))
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_OFFSET    ((uint32_t)(0x16C))
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_RESET_VALUE 0U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_RESET_MASK 0xFFFFE000U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_MASK 0xFFU
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_MANAGEDBURSTBUFFERS_SHIFT 0U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_MASK 0x1F00U
#define IMXDPUV1_FETCHLAYER0_BURSTBUFFERPROPERTIES_BURSTLENGTHFORMAXBUFFERS_SHIFT 8U

/* Register: IMXDPUV1_fetchlayer0_Status */
#define IMXDPUV1_FETCHLAYER0_STATUS                          ((uint32_t)(0x8570))
#define IMXDPUV1_FETCHLAYER0_STATUS_OFFSET                   ((uint32_t)(0x170))
#define IMXDPUV1_FETCHLAYER0_STATUS_RESET_VALUE              0U
#define IMXDPUV1_FETCHLAYER0_STATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_FETCHLAYER0_STATUS_WRITETIMEOUT_MASK        0x1U
#define IMXDPUV1_FETCHLAYER0_STATUS_WRITETIMEOUT_SHIFT       0U
#define IMXDPUV1_FETCHLAYER0_STATUS_READTIMEOUT_MASK         0x10U
#define IMXDPUV1_FETCHLAYER0_STATUS_READTIMEOUT_SHIFT        4U

/* Register: IMXDPUV1_fetchlayer0_HiddenStatus */
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS                    ((uint32_t)(0x8574))
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_OFFSET             ((uint32_t)(0x174))
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_RESET_MASK         0xFFFF008EU
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSBUSY_MASK    0x1U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSBUSY_SHIFT   0U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSBUFFERSIDLE_MASK 0x10U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSBUFFERSIDLE_SHIFT 4U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSREQUEST_MASK 0x20U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSREQUEST_SHIFT 5U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSCOMPLETE_MASK 0x40U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_STATUSCOMPLETE_SHIFT 6U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_SHADOWSTATUS_MASK  0xFF00U
#define IMXDPUV1_FETCHLAYER0_HIDDENSTATUS_SHADOWSTATUS_SHIFT 8U

/* Register: IMXDPUV1_fetchlayer0_ColorPalette */
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE                    ((uint32_t)(0x8800))
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE_OFFSET             ((uint32_t)(0))
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE_RESET_VALUE        0U
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE_RESET_MASK         0xFF000000U
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE_COLORPALETTE_MASK  0xFFFFFFU
#define IMXDPUV1_FETCHLAYER0_COLORPALETTE_COLORPALETTE_SHIFT 0U

/* Register: IMXDPUV1_matrix4_LockUnlock */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK                          ((uint32_t)(0x8C00))
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_MATRIX4_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_matrix4_LockStatus */
#define IMXDPUV1_MATRIX4_LOCKSTATUS                          ((uint32_t)(0x8C04))
#define IMXDPUV1_MATRIX4_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_MATRIX4_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_MATRIX4_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_matrix4_StaticControl */
#define IMXDPUV1_MATRIX4_STATICCONTROL                       ((uint32_t)(0x8C08))
#define IMXDPUV1_MATRIX4_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_MATRIX4_STATICCONTROL_RESET_VALUE           0U
#define IMXDPUV1_MATRIX4_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_MATRIX4_STATICCONTROL_SHDEN_SHIFT           0U

/* Register: IMXDPUV1_matrix4_Control */
#define IMXDPUV1_MATRIX4_CONTROL                             ((uint32_t)(0x8C0C))
#define IMXDPUV1_MATRIX4_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_MATRIX4_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_MATRIX4_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_CONTROL_MODE_MASK                   0x3U
#define IMXDPUV1_MATRIX4_CONTROL_MODE_SHIFT                  0U
/* Field Value: MODE__NEUTRAL, Module in neutral mode, input data is bypassed  */
#define IMXDPUV1_MATRIX4_CONTROL_MODE__NEUTRAL               0U
/* Field Value: MODE__MATRIX, Module in matrix mode, input data is multiplied
 * with matrix values  */
#define IMXDPUV1_MATRIX4_CONTROL_MODE__MATRIX                0x1U
/* Field Value: MODE__PREMUL, Module in alpha pre-multiplication mode, input
 * color is multiplied with input alpha  */
#define IMXDPUV1_MATRIX4_CONTROL_MODE__PREMUL                0x2U
/* Field Value: MODE__RSVD, Reserved, do not use  */
#define IMXDPUV1_MATRIX4_CONTROL_MODE__RSVD                  0x3U
#define IMXDPUV1_MATRIX4_CONTROL_ALPHAMASK_MASK              0x10U
#define IMXDPUV1_MATRIX4_CONTROL_ALPHAMASK_SHIFT             4U
#define IMXDPUV1_MATRIX4_CONTROL_ALPHAINVERT_MASK            0x20U
#define IMXDPUV1_MATRIX4_CONTROL_ALPHAINVERT_SHIFT           5U

/* Register: IMXDPUV1_matrix4_Red0 */
#define IMXDPUV1_MATRIX4_RED0                                ((uint32_t)(0x8C10))
#define IMXDPUV1_MATRIX4_RED0_OFFSET                         ((uint32_t)(0x10))
#define IMXDPUV1_MATRIX4_RED0_RESET_VALUE                    0x400U
#define IMXDPUV1_MATRIX4_RED0_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_RED0_A11_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX4_RED0_A11_SHIFT                      0U
#define IMXDPUV1_MATRIX4_RED0_A12_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX4_RED0_A12_SHIFT                      16U

/* Register: IMXDPUV1_matrix4_Red1 */
#define IMXDPUV1_MATRIX4_RED1                                ((uint32_t)(0x8C14))
#define IMXDPUV1_MATRIX4_RED1_OFFSET                         ((uint32_t)(0x14))
#define IMXDPUV1_MATRIX4_RED1_RESET_VALUE                    0U
#define IMXDPUV1_MATRIX4_RED1_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_RED1_A13_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX4_RED1_A13_SHIFT                      0U
#define IMXDPUV1_MATRIX4_RED1_A14_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX4_RED1_A14_SHIFT                      16U

/* Register: IMXDPUV1_matrix4_Green0 */
#define IMXDPUV1_MATRIX4_GREEN0                              ((uint32_t)(0x8C18))
#define IMXDPUV1_MATRIX4_GREEN0_OFFSET                       ((uint32_t)(0x18))
#define IMXDPUV1_MATRIX4_GREEN0_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX4_GREEN0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_GREEN0_A21_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX4_GREEN0_A21_SHIFT                    0U
#define IMXDPUV1_MATRIX4_GREEN0_A22_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX4_GREEN0_A22_SHIFT                    16U

/* Register: IMXDPUV1_matrix4_Green1 */
#define IMXDPUV1_MATRIX4_GREEN1                              ((uint32_t)(0x8C1C))
#define IMXDPUV1_MATRIX4_GREEN1_OFFSET                       ((uint32_t)(0x1C))
#define IMXDPUV1_MATRIX4_GREEN1_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX4_GREEN1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_GREEN1_A23_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX4_GREEN1_A23_SHIFT                    0U
#define IMXDPUV1_MATRIX4_GREEN1_A24_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX4_GREEN1_A24_SHIFT                    16U

/* Register: IMXDPUV1_matrix4_Blue0 */
#define IMXDPUV1_MATRIX4_BLUE0                               ((uint32_t)(0x8C20))
#define IMXDPUV1_MATRIX4_BLUE0_OFFSET                        ((uint32_t)(0x20))
#define IMXDPUV1_MATRIX4_BLUE0_RESET_VALUE                   0U
#define IMXDPUV1_MATRIX4_BLUE0_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_BLUE0_A31_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX4_BLUE0_A31_SHIFT                     0U
#define IMXDPUV1_MATRIX4_BLUE0_A32_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX4_BLUE0_A32_SHIFT                     16U

/* Register: IMXDPUV1_matrix4_Blue1 */
#define IMXDPUV1_MATRIX4_BLUE1                               ((uint32_t)(0x8C24))
#define IMXDPUV1_MATRIX4_BLUE1_OFFSET                        ((uint32_t)(0x24))
#define IMXDPUV1_MATRIX4_BLUE1_RESET_VALUE                   0x400U
#define IMXDPUV1_MATRIX4_BLUE1_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_BLUE1_A33_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX4_BLUE1_A33_SHIFT                     0U
#define IMXDPUV1_MATRIX4_BLUE1_A34_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX4_BLUE1_A34_SHIFT                     16U

/* Register: IMXDPUV1_matrix4_Alpha0 */
#define IMXDPUV1_MATRIX4_ALPHA0                              ((uint32_t)(0x8C28))
#define IMXDPUV1_MATRIX4_ALPHA0_OFFSET                       ((uint32_t)(0x28))
#define IMXDPUV1_MATRIX4_ALPHA0_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX4_ALPHA0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_ALPHA0_A41_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX4_ALPHA0_A41_SHIFT                    0U
#define IMXDPUV1_MATRIX4_ALPHA0_A42_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX4_ALPHA0_A42_SHIFT                    16U

/* Register: IMXDPUV1_matrix4_Alpha1 */
#define IMXDPUV1_MATRIX4_ALPHA1                              ((uint32_t)(0x8C2C))
#define IMXDPUV1_MATRIX4_ALPHA1_OFFSET                       ((uint32_t)(0x2C))
#define IMXDPUV1_MATRIX4_ALPHA1_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX4_ALPHA1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_ALPHA1_A43_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX4_ALPHA1_A43_SHIFT                    0U
#define IMXDPUV1_MATRIX4_ALPHA1_A44_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX4_ALPHA1_A44_SHIFT                    16U

/* Register: IMXDPUV1_matrix4_OffsetVector0 */
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0                       ((uint32_t)(0x8C30))
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_OFFSET                ((uint32_t)(0x30))
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_RESET_VALUE           0U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_C1_MASK               0x1FFFU
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_C1_SHIFT              0U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_C2_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR0_C2_SHIFT              16U

/* Register: IMXDPUV1_matrix4_OffsetVector1 */
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1                       ((uint32_t)(0x8C34))
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_OFFSET                ((uint32_t)(0x34))
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_RESET_VALUE           0U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_C3_MASK               0x1FFFU
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_C3_SHIFT              0U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_C4_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX4_OFFSETVECTOR1_C4_SHIFT              16U

/* Register: IMXDPUV1_matrix4_LastControlWord */
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD                     ((uint32_t)(0x8C38))
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD_OFFSET              ((uint32_t)(0x38))
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD_RESET_VALUE         0U
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD_RESET_MASK          0U
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD_L_VAL_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX4_LASTCONTROLWORD_L_VAL_SHIFT         0U

/* Register: IMXDPUV1_hscaler4_LockUnlock */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK                         ((uint32_t)(0x9000))
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_HSCALER4_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_hscaler4_LockStatus */
#define IMXDPUV1_HSCALER4_LOCKSTATUS                         ((uint32_t)(0x9004))
#define IMXDPUV1_HSCALER4_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_HSCALER4_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_HSCALER4_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_hscaler4_StaticControl */
#define IMXDPUV1_HSCALER4_STATICCONTROL                      ((uint32_t)(0x9008))
#define IMXDPUV1_HSCALER4_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_HSCALER4_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_HSCALER4_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_HSCALER4_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_hscaler4_Setup1 */
#define IMXDPUV1_HSCALER4_SETUP1                             ((uint32_t)(0x900C))
#define IMXDPUV1_HSCALER4_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_HSCALER4_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_HSCALER4_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_HSCALER4_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_hscaler4_Setup2 */
#define IMXDPUV1_HSCALER4_SETUP2                             ((uint32_t)(0x9010))
#define IMXDPUV1_HSCALER4_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_HSCALER4_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_HSCALER4_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_HSCALER4_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_hscaler4_Control */
#define IMXDPUV1_HSCALER4_CONTROL                            ((uint32_t)(0x9014))
#define IMXDPUV1_HSCALER4_CONTROL_OFFSET                     ((uint32_t)(0x14))
#define IMXDPUV1_HSCALER4_CONTROL_RESET_VALUE                0U
#define IMXDPUV1_HSCALER4_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_HSCALER4_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_HSCALER4_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_HSCALER4_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_HSCALER4_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_HSCALER4_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_HSCALER4_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_HSCALER4_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size)  */
#define IMXDPUV1_HSCALER4_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_HSCALER4_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_HSCALER4_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_HSCALER4_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_HSCALER4_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_HSCALER4_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_HSCALER4_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_vscaler4_LockUnlock */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK                         ((uint32_t)(0x9400))
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_VSCALER4_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_vscaler4_LockStatus */
#define IMXDPUV1_VSCALER4_LOCKSTATUS                         ((uint32_t)(0x9404))
#define IMXDPUV1_VSCALER4_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_VSCALER4_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_VSCALER4_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_vscaler4_StaticControl */
#define IMXDPUV1_VSCALER4_STATICCONTROL                      ((uint32_t)(0x9408))
#define IMXDPUV1_VSCALER4_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_VSCALER4_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_VSCALER4_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_VSCALER4_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_vscaler4_Setup1 */
#define IMXDPUV1_VSCALER4_SETUP1                             ((uint32_t)(0x940C))
#define IMXDPUV1_VSCALER4_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_VSCALER4_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_VSCALER4_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_VSCALER4_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_vscaler4_Setup2 */
#define IMXDPUV1_VSCALER4_SETUP2                             ((uint32_t)(0x9410))
#define IMXDPUV1_VSCALER4_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_VSCALER4_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER4_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_VSCALER4_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_vscaler4_Setup3 */
#define IMXDPUV1_VSCALER4_SETUP3                             ((uint32_t)(0x9414))
#define IMXDPUV1_VSCALER4_SETUP3_OFFSET                      ((uint32_t)(0x14))
#define IMXDPUV1_VSCALER4_SETUP3_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER4_SETUP3_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_SETUP3_PHASE_OFFSET1_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER4_SETUP3_PHASE_OFFSET1_SHIFT         0U

/* Register: IMXDPUV1_vscaler4_Setup4 */
#define IMXDPUV1_VSCALER4_SETUP4                             ((uint32_t)(0x9418))
#define IMXDPUV1_VSCALER4_SETUP4_OFFSET                      ((uint32_t)(0x18))
#define IMXDPUV1_VSCALER4_SETUP4_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER4_SETUP4_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_SETUP4_PHASE_OFFSET2_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER4_SETUP4_PHASE_OFFSET2_SHIFT         0U

/* Register: IMXDPUV1_vscaler4_Setup5 */
#define IMXDPUV1_VSCALER4_SETUP5                             ((uint32_t)(0x941C))
#define IMXDPUV1_VSCALER4_SETUP5_OFFSET                      ((uint32_t)(0x1C))
#define IMXDPUV1_VSCALER4_SETUP5_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER4_SETUP5_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_SETUP5_PHASE_OFFSET3_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER4_SETUP5_PHASE_OFFSET3_SHIFT         0U

/* Register: IMXDPUV1_vscaler4_Control */
#define IMXDPUV1_VSCALER4_CONTROL                            ((uint32_t)(0x9420))
#define IMXDPUV1_VSCALER4_CONTROL_OFFSET                     ((uint32_t)(0x20))
#define IMXDPUV1_VSCALER4_CONTROL_RESET_VALUE                0x2000U
#define IMXDPUV1_VSCALER4_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_VSCALER4_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_VSCALER4_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_VSCALER4_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_VSCALER4_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_VSCALER4_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_VSCALER4_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_VSCALER4_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size).  */
#define IMXDPUV1_VSCALER4_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_VSCALER4_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_VSCALER4_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_VSCALER4_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_VSCALER4_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE_MASK            0x3000U
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE_SHIFT           12U
/* Field Value: FIELD_MODE__ALWAYS0, Constant 0 indicates frame or top field.  */
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE__ALWAYS0        0U
/* Field Value: FIELD_MODE__ALWAYS1, Constant 1 indicates bottom field.  */
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE__ALWAYS1        0x1U
/* Field Value: FIELD_MODE__INPUT, Output field polarity is taken from input
 * field polarity.  */
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE__INPUT          0x2U
/* Field Value: FIELD_MODE__TOGGLE, Output field polarity toggles, starting
 * with 0 after reset.  */
#define IMXDPUV1_VSCALER4_CONTROL_FIELD_MODE__TOGGLE         0x3U
#define IMXDPUV1_VSCALER4_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_VSCALER4_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_matrix5_LockUnlock */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK                          ((uint32_t)(0x9800))
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_OFFSET                   ((uint32_t)(0))
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_RESET_VALUE              0U
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_RESET_MASK               0U
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK_SHIFT         0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY     0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY   0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_MATRIX5_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY   0xFBE8B1E6U

/* Register: IMXDPUV1_matrix5_LockStatus */
#define IMXDPUV1_MATRIX5_LOCKSTATUS                          ((uint32_t)(0x9804))
#define IMXDPUV1_MATRIX5_LOCKSTATUS_OFFSET                   ((uint32_t)(0x4))
#define IMXDPUV1_MATRIX5_LOCKSTATUS_RESET_VALUE              0U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_RESET_MASK               0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_LOCKSTATUS_LOCKSTATUS_MASK          0x1U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_LOCKSTATUS_SHIFT         0U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_PRIVILEGESTATUS_MASK     0x10U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_PRIVILEGESTATUS_SHIFT    4U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_FREEZESTATUS_MASK        0x100U
#define IMXDPUV1_MATRIX5_LOCKSTATUS_FREEZESTATUS_SHIFT       8U

/* Register: IMXDPUV1_matrix5_StaticControl */
#define IMXDPUV1_MATRIX5_STATICCONTROL                       ((uint32_t)(0x9808))
#define IMXDPUV1_MATRIX5_STATICCONTROL_OFFSET                ((uint32_t)(0x8))
#define IMXDPUV1_MATRIX5_STATICCONTROL_RESET_VALUE           0U
#define IMXDPUV1_MATRIX5_STATICCONTROL_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_STATICCONTROL_SHDEN_MASK            0x1U
#define IMXDPUV1_MATRIX5_STATICCONTROL_SHDEN_SHIFT           0U

/* Register: IMXDPUV1_matrix5_Control */
#define IMXDPUV1_MATRIX5_CONTROL                             ((uint32_t)(0x980C))
#define IMXDPUV1_MATRIX5_CONTROL_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_MATRIX5_CONTROL_RESET_VALUE                 0U
#define IMXDPUV1_MATRIX5_CONTROL_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_CONTROL_MODE_MASK                   0x3U
#define IMXDPUV1_MATRIX5_CONTROL_MODE_SHIFT                  0U
/* Field Value: MODE__NEUTRAL, Module in neutral mode, input data is bypassed  */
#define IMXDPUV1_MATRIX5_CONTROL_MODE__NEUTRAL               0U
/* Field Value: MODE__MATRIX, Module in matrix mode, input data is multiplied
 * with matrix values  */
#define IMXDPUV1_MATRIX5_CONTROL_MODE__MATRIX                0x1U
/* Field Value: MODE__PREMUL, Module in alpha pre-multiplication mode, input
 * color is multiplied with input alpha  */
#define IMXDPUV1_MATRIX5_CONTROL_MODE__PREMUL                0x2U
/* Field Value: MODE__RSVD, Reserved, do not use  */
#define IMXDPUV1_MATRIX5_CONTROL_MODE__RSVD                  0x3U
#define IMXDPUV1_MATRIX5_CONTROL_ALPHAMASK_MASK              0x10U
#define IMXDPUV1_MATRIX5_CONTROL_ALPHAMASK_SHIFT             4U
#define IMXDPUV1_MATRIX5_CONTROL_ALPHAINVERT_MASK            0x20U
#define IMXDPUV1_MATRIX5_CONTROL_ALPHAINVERT_SHIFT           5U

/* Register: IMXDPUV1_matrix5_Red0 */
#define IMXDPUV1_MATRIX5_RED0                                ((uint32_t)(0x9810))
#define IMXDPUV1_MATRIX5_RED0_OFFSET                         ((uint32_t)(0x10))
#define IMXDPUV1_MATRIX5_RED0_RESET_VALUE                    0x400U
#define IMXDPUV1_MATRIX5_RED0_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_RED0_A11_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX5_RED0_A11_SHIFT                      0U
#define IMXDPUV1_MATRIX5_RED0_A12_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX5_RED0_A12_SHIFT                      16U

/* Register: IMXDPUV1_matrix5_Red1 */
#define IMXDPUV1_MATRIX5_RED1                                ((uint32_t)(0x9814))
#define IMXDPUV1_MATRIX5_RED1_OFFSET                         ((uint32_t)(0x14))
#define IMXDPUV1_MATRIX5_RED1_RESET_VALUE                    0U
#define IMXDPUV1_MATRIX5_RED1_RESET_MASK                     0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_RED1_A13_MASK                       0x1FFFU
#define IMXDPUV1_MATRIX5_RED1_A13_SHIFT                      0U
#define IMXDPUV1_MATRIX5_RED1_A14_MASK                       0x1FFF0000U
#define IMXDPUV1_MATRIX5_RED1_A14_SHIFT                      16U

/* Register: IMXDPUV1_matrix5_Green0 */
#define IMXDPUV1_MATRIX5_GREEN0                              ((uint32_t)(0x9818))
#define IMXDPUV1_MATRIX5_GREEN0_OFFSET                       ((uint32_t)(0x18))
#define IMXDPUV1_MATRIX5_GREEN0_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX5_GREEN0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_GREEN0_A21_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX5_GREEN0_A21_SHIFT                    0U
#define IMXDPUV1_MATRIX5_GREEN0_A22_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX5_GREEN0_A22_SHIFT                    16U

/* Register: IMXDPUV1_matrix5_Green1 */
#define IMXDPUV1_MATRIX5_GREEN1                              ((uint32_t)(0x981C))
#define IMXDPUV1_MATRIX5_GREEN1_OFFSET                       ((uint32_t)(0x1C))
#define IMXDPUV1_MATRIX5_GREEN1_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX5_GREEN1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_GREEN1_A23_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX5_GREEN1_A23_SHIFT                    0U
#define IMXDPUV1_MATRIX5_GREEN1_A24_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX5_GREEN1_A24_SHIFT                    16U

/* Register: IMXDPUV1_matrix5_Blue0 */
#define IMXDPUV1_MATRIX5_BLUE0                               ((uint32_t)(0x9820))
#define IMXDPUV1_MATRIX5_BLUE0_OFFSET                        ((uint32_t)(0x20))
#define IMXDPUV1_MATRIX5_BLUE0_RESET_VALUE                   0U
#define IMXDPUV1_MATRIX5_BLUE0_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_BLUE0_A31_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX5_BLUE0_A31_SHIFT                     0U
#define IMXDPUV1_MATRIX5_BLUE0_A32_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX5_BLUE0_A32_SHIFT                     16U

/* Register: IMXDPUV1_matrix5_Blue1 */
#define IMXDPUV1_MATRIX5_BLUE1                               ((uint32_t)(0x9824))
#define IMXDPUV1_MATRIX5_BLUE1_OFFSET                        ((uint32_t)(0x24))
#define IMXDPUV1_MATRIX5_BLUE1_RESET_VALUE                   0x400U
#define IMXDPUV1_MATRIX5_BLUE1_RESET_MASK                    0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_BLUE1_A33_MASK                      0x1FFFU
#define IMXDPUV1_MATRIX5_BLUE1_A33_SHIFT                     0U
#define IMXDPUV1_MATRIX5_BLUE1_A34_MASK                      0x1FFF0000U
#define IMXDPUV1_MATRIX5_BLUE1_A34_SHIFT                     16U

/* Register: IMXDPUV1_matrix5_Alpha0 */
#define IMXDPUV1_MATRIX5_ALPHA0                              ((uint32_t)(0x9828))
#define IMXDPUV1_MATRIX5_ALPHA0_OFFSET                       ((uint32_t)(0x28))
#define IMXDPUV1_MATRIX5_ALPHA0_RESET_VALUE                  0U
#define IMXDPUV1_MATRIX5_ALPHA0_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_ALPHA0_A41_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX5_ALPHA0_A41_SHIFT                    0U
#define IMXDPUV1_MATRIX5_ALPHA0_A42_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX5_ALPHA0_A42_SHIFT                    16U

/* Register: IMXDPUV1_matrix5_Alpha1 */
#define IMXDPUV1_MATRIX5_ALPHA1                              ((uint32_t)(0x982C))
#define IMXDPUV1_MATRIX5_ALPHA1_OFFSET                       ((uint32_t)(0x2C))
#define IMXDPUV1_MATRIX5_ALPHA1_RESET_VALUE                  0x4000000U
#define IMXDPUV1_MATRIX5_ALPHA1_RESET_MASK                   0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_ALPHA1_A43_MASK                     0x1FFFU
#define IMXDPUV1_MATRIX5_ALPHA1_A43_SHIFT                    0U
#define IMXDPUV1_MATRIX5_ALPHA1_A44_MASK                     0x1FFF0000U
#define IMXDPUV1_MATRIX5_ALPHA1_A44_SHIFT                    16U

/* Register: IMXDPUV1_matrix5_OffsetVector0 */
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0                       ((uint32_t)(0x9830))
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_OFFSET                ((uint32_t)(0x30))
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_RESET_VALUE           0U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_C1_MASK               0x1FFFU
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_C1_SHIFT              0U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_C2_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR0_C2_SHIFT              16U

/* Register: IMXDPUV1_matrix5_OffsetVector1 */
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1                       ((uint32_t)(0x9834))
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_OFFSET                ((uint32_t)(0x34))
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_RESET_VALUE           0U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_RESET_MASK            0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_C3_MASK               0x1FFFU
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_C3_SHIFT              0U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_C4_MASK               0x1FFF0000U
#define IMXDPUV1_MATRIX5_OFFSETVECTOR1_C4_SHIFT              16U

/* Register: IMXDPUV1_matrix5_LastControlWord */
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD                     ((uint32_t)(0x9838))
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD_OFFSET              ((uint32_t)(0x38))
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD_RESET_VALUE         0U
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD_RESET_MASK          0U
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD_L_VAL_MASK          0xFFFFFFFFU
#define IMXDPUV1_MATRIX5_LASTCONTROLWORD_L_VAL_SHIFT         0U

/* Register: IMXDPUV1_hscaler5_LockUnlock */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK                         ((uint32_t)(0x9C00))
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_HSCALER5_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_hscaler5_LockStatus */
#define IMXDPUV1_HSCALER5_LOCKSTATUS                         ((uint32_t)(0x9C04))
#define IMXDPUV1_HSCALER5_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_HSCALER5_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_HSCALER5_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_hscaler5_StaticControl */
#define IMXDPUV1_HSCALER5_STATICCONTROL                      ((uint32_t)(0x9C08))
#define IMXDPUV1_HSCALER5_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_HSCALER5_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_HSCALER5_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_HSCALER5_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_hscaler5_Setup1 */
#define IMXDPUV1_HSCALER5_SETUP1                             ((uint32_t)(0x9C0C))
#define IMXDPUV1_HSCALER5_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_HSCALER5_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_HSCALER5_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_HSCALER5_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_hscaler5_Setup2 */
#define IMXDPUV1_HSCALER5_SETUP2                             ((uint32_t)(0x9C10))
#define IMXDPUV1_HSCALER5_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_HSCALER5_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_HSCALER5_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_HSCALER5_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_hscaler5_Control */
#define IMXDPUV1_HSCALER5_CONTROL                            ((uint32_t)(0x9C14))
#define IMXDPUV1_HSCALER5_CONTROL_OFFSET                     ((uint32_t)(0x14))
#define IMXDPUV1_HSCALER5_CONTROL_RESET_VALUE                0U
#define IMXDPUV1_HSCALER5_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_HSCALER5_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_HSCALER5_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_HSCALER5_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_HSCALER5_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_HSCALER5_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_HSCALER5_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_HSCALER5_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size)  */
#define IMXDPUV1_HSCALER5_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_HSCALER5_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_HSCALER5_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_HSCALER5_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_HSCALER5_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_HSCALER5_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_HSCALER5_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_vscaler5_LockUnlock */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK                         ((uint32_t)(0xA000))
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_OFFSET                  ((uint32_t)(0))
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_RESET_VALUE             0U
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_RESET_MASK              0U
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK_MASK         0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK_SHIFT        0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY    0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY  0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_VSCALER5_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY  0xFBE8B1E6U

/* Register: IMXDPUV1_vscaler5_LockStatus */
#define IMXDPUV1_VSCALER5_LOCKSTATUS                         ((uint32_t)(0xA004))
#define IMXDPUV1_VSCALER5_LOCKSTATUS_OFFSET                  ((uint32_t)(0x4))
#define IMXDPUV1_VSCALER5_LOCKSTATUS_RESET_VALUE             0U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_LOCKSTATUS_LOCKSTATUS_MASK         0x1U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_LOCKSTATUS_SHIFT        0U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_PRIVILEGESTATUS_MASK    0x10U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_PRIVILEGESTATUS_SHIFT   4U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_FREEZESTATUS_MASK       0x100U
#define IMXDPUV1_VSCALER5_LOCKSTATUS_FREEZESTATUS_SHIFT      8U

/* Register: IMXDPUV1_vscaler5_StaticControl */
#define IMXDPUV1_VSCALER5_STATICCONTROL                      ((uint32_t)(0xA008))
#define IMXDPUV1_VSCALER5_STATICCONTROL_OFFSET               ((uint32_t)(0x8))
#define IMXDPUV1_VSCALER5_STATICCONTROL_RESET_VALUE          0U
#define IMXDPUV1_VSCALER5_STATICCONTROL_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_STATICCONTROL_SHDEN_MASK           0x1U
#define IMXDPUV1_VSCALER5_STATICCONTROL_SHDEN_SHIFT          0U

/* Register: IMXDPUV1_vscaler5_Setup1 */
#define IMXDPUV1_VSCALER5_SETUP1                             ((uint32_t)(0xA00C))
#define IMXDPUV1_VSCALER5_SETUP1_OFFSET                      ((uint32_t)(0xC))
#define IMXDPUV1_VSCALER5_SETUP1_RESET_VALUE                 0x80000U
#define IMXDPUV1_VSCALER5_SETUP1_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_SETUP1_SCALE_FACTOR_MASK           0xFFFFFU
#define IMXDPUV1_VSCALER5_SETUP1_SCALE_FACTOR_SHIFT          0U

/* Register: IMXDPUV1_vscaler5_Setup2 */
#define IMXDPUV1_VSCALER5_SETUP2                             ((uint32_t)(0xA010))
#define IMXDPUV1_VSCALER5_SETUP2_OFFSET                      ((uint32_t)(0x10))
#define IMXDPUV1_VSCALER5_SETUP2_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER5_SETUP2_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_SETUP2_PHASE_OFFSET_MASK           0x1FFFFFU
#define IMXDPUV1_VSCALER5_SETUP2_PHASE_OFFSET_SHIFT          0U

/* Register: IMXDPUV1_vscaler5_Setup3 */
#define IMXDPUV1_VSCALER5_SETUP3                             ((uint32_t)(0xA014))
#define IMXDPUV1_VSCALER5_SETUP3_OFFSET                      ((uint32_t)(0x14))
#define IMXDPUV1_VSCALER5_SETUP3_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER5_SETUP3_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_SETUP3_PHASE_OFFSET1_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER5_SETUP3_PHASE_OFFSET1_SHIFT         0U

/* Register: IMXDPUV1_vscaler5_Setup4 */
#define IMXDPUV1_VSCALER5_SETUP4                             ((uint32_t)(0xA018))
#define IMXDPUV1_VSCALER5_SETUP4_OFFSET                      ((uint32_t)(0x18))
#define IMXDPUV1_VSCALER5_SETUP4_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER5_SETUP4_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_SETUP4_PHASE_OFFSET2_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER5_SETUP4_PHASE_OFFSET2_SHIFT         0U

/* Register: IMXDPUV1_vscaler5_Setup5 */
#define IMXDPUV1_VSCALER5_SETUP5                             ((uint32_t)(0xA01C))
#define IMXDPUV1_VSCALER5_SETUP5_OFFSET                      ((uint32_t)(0x1C))
#define IMXDPUV1_VSCALER5_SETUP5_RESET_VALUE                 0U
#define IMXDPUV1_VSCALER5_SETUP5_RESET_MASK                  0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_SETUP5_PHASE_OFFSET3_MASK          0x1FFFFFU
#define IMXDPUV1_VSCALER5_SETUP5_PHASE_OFFSET3_SHIFT         0U

/* Register: IMXDPUV1_vscaler5_Control */
#define IMXDPUV1_VSCALER5_CONTROL                            ((uint32_t)(0xA020))
#define IMXDPUV1_VSCALER5_CONTROL_OFFSET                     ((uint32_t)(0x20))
#define IMXDPUV1_VSCALER5_CONTROL_RESET_VALUE                0x2000U
#define IMXDPUV1_VSCALER5_CONTROL_RESET_MASK                 0xFFFFFFFFU
#define IMXDPUV1_VSCALER5_CONTROL_MODE_MASK                  0x1U
#define IMXDPUV1_VSCALER5_CONTROL_MODE_SHIFT                 0U
/* Field Value: MODE__NEUTRAL, Neutral mode. Pixels by-pass the scaler, all
 * other settings are ignored.  */
#define IMXDPUV1_VSCALER5_CONTROL_MODE__NEUTRAL              0U
/* Field Value: MODE__ACTIVE, Scaler is active.  */
#define IMXDPUV1_VSCALER5_CONTROL_MODE__ACTIVE               0x1U
#define IMXDPUV1_VSCALER5_CONTROL_SCALE_MODE_MASK            0x10U
#define IMXDPUV1_VSCALER5_CONTROL_SCALE_MODE_SHIFT           4U
/* Field Value: SCALE_MODE__DOWNSCALE, Down-scaling (output size less or equal
 * input size).  */
#define IMXDPUV1_VSCALER5_CONTROL_SCALE_MODE__DOWNSCALE      0U
/* Field Value: SCALE_MODE__UPSCALE, Up-scaling (output size greater or equal
 * input size).  */
#define IMXDPUV1_VSCALER5_CONTROL_SCALE_MODE__UPSCALE        0x1U
#define IMXDPUV1_VSCALER5_CONTROL_FILTER_MODE_MASK           0x100U
#define IMXDPUV1_VSCALER5_CONTROL_FILTER_MODE_SHIFT          8U
/* Field Value: FILTER_MODE__NEAREST, Nearest filter (point-sampling)  */
#define IMXDPUV1_VSCALER5_CONTROL_FILTER_MODE__NEAREST       0U
/* Field Value: FILTER_MODE__LINEAR, Box filter (linear)  */
#define IMXDPUV1_VSCALER5_CONTROL_FILTER_MODE__LINEAR        0x1U
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE_MASK            0x3000U
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE_SHIFT           12U
/* Field Value: FIELD_MODE__ALWAYS0, Constant 0 indicates frame or top field.  */
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE__ALWAYS0        0U
/* Field Value: FIELD_MODE__ALWAYS1, Constant 1 indicates bottom field.  */
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE__ALWAYS1        0x1U
/* Field Value: FIELD_MODE__INPUT, Output field polarity is taken from input
 * field polarity.  */
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE__INPUT          0x2U
/* Field Value: FIELD_MODE__TOGGLE, Output field polarity toggles, starting
 * with 0 after reset.  */
#define IMXDPUV1_VSCALER5_CONTROL_FIELD_MODE__TOGGLE         0x3U
#define IMXDPUV1_VSCALER5_CONTROL_OUTPUT_SIZE_MASK           0x3FFF0000U
#define IMXDPUV1_VSCALER5_CONTROL_OUTPUT_SIZE_SHIFT          16U

/* Register: IMXDPUV1_layerblend0_LockUnlock */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK                      ((uint32_t)(0xA400))
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_LAYERBLEND0_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_layerblend0_LockStatus */
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS                      ((uint32_t)(0xA404))
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_LAYERBLEND0_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_layerblend0_StaticControl */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL                   ((uint32_t)(0xA408))
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_RESET_VALUE       0x14U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDEN_SHIFT       0U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDLDSEL_MASK     0x6U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDLDSEL_SHIFT    1U
/* Field Value: SHDLDSEL__PRIMARY, Load shadows with shadow load token on
 * primary input (background plane).  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDLDSEL__PRIMARY 0U
/* Field Value: SHDLDSEL__SECONDARY, Load shadows with shadow load token on
 * secondary input (foreground plane).  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDLDSEL__SECONDARY 0x1U
/* Field Value: SHDLDSEL__BOTH, Load shadows with shadow load token on any
 * input.  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDLDSEL__BOTH    0x2U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDTOKSEL_MASK    0x18U
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDTOKSEL_SHIFT   3U
/* Field Value: SHDTOKSEL__PRIMARY, When a token was received on the primary
 * input (background plane).  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDTOKSEL__PRIMARY 0U
/* Field Value: SHDTOKSEL__SECONDARY, When a token was received on the secondary
 * input (foreground plane).  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDTOKSEL__SECONDARY 0x1U
/* Field Value: SHDTOKSEL__BOTH, When a token was received on any input.  */
#define IMXDPUV1_LAYERBLEND0_STATICCONTROL_SHDTOKSEL__BOTH   0x2U

/* Register: IMXDPUV1_layerblend0_Control */
#define IMXDPUV1_LAYERBLEND0_CONTROL                         ((uint32_t)(0xA40C))
#define IMXDPUV1_LAYERBLEND0_CONTROL_OFFSET                  ((uint32_t)(0xC))
#define IMXDPUV1_LAYERBLEND0_CONTROL_RESET_VALUE             0x1U
#define IMXDPUV1_LAYERBLEND0_CONTROL_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_CONTROL_MODE_MASK               0x1U
#define IMXDPUV1_LAYERBLEND0_CONTROL_MODE_SHIFT              0U
/* Field Value: MODE__NEUTRAL, Module is in neutral mode. Output is same as
 * primary input.  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_MODE__NEUTRAL           0U
/* Field Value: MODE__BLEND, Module is in blending mode.  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_MODE__BLEND             0x1U
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKENABLE_MASK    0x4U
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKENABLE_SHIFT   2U
/* Field Value: ALPHAMASKENABLE__DISABLE, AlphaMask feature disabled  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKENABLE__DISABLE 0U
/* Field Value: ALPHAMASKENABLE__ENABLE, AlphaMask feature enabled  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKENABLE__ENABLE 0x1U
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE_MASK      0x70U
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE_SHIFT     4U
/* Field Value: ALPHAMASKMODE__PRIM, Areas with primary input alpha > 128
 * will be mapped to 255 and the rest will have an alpha value of 0  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM     0U
/* Field Value: ALPHAMASKMODE__SEC, The area of the secondary input will get
 * an alpha value of 255 and the rest will be 0  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__SEC      0x1U
/* Field Value: ALPHAMASKMODE__PRIM_OR_SEC, Behaves as if the output of modes
 * PRIM and SEC would be ORed together  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM_OR_SEC 0x2U
/* Field Value: ALPHAMASKMODE__PRIM_AND_SEC, Behaves as if the output of modes
 * PRIM and SEC would be ANDed together  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM_AND_SEC 0x3U
/* Field Value: ALPHAMASKMODE__PRIM_INV, Behaves as if the output of mode
 * PRIM would be inverted  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM_INV 0x4U
/* Field Value: ALPHAMASKMODE__SEC_INV, Behaves as if the output of mode SEC
 * would be inverted  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__SEC_INV  0x5U
/* Field Value: ALPHAMASKMODE__PRIM_OR_SEC_INV, Behaves as if the output of
 * modes PRIM and SEC_INV would be ORed together  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM_OR_SEC_INV 0x6U
/* Field Value: ALPHAMASKMODE__PRIM_AND_SEC_INV, Behaves as if the output
 * of modes PRIM and SEC_INV would be ANDed together  */
#define IMXDPUV1_LAYERBLEND0_CONTROL_ALPHAMASKMODE__PRIM_AND_SEC_INV 0x7U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECLOWPASSEN_MASK       0x100U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECLOWPASSEN_SHIFT      8U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECREPLICATEEN_MASK     0x200U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECREPLICATEEN_SHIFT    9U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECEVENROWEVENCOLDIS_MASK 0x3C00U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECEVENROWEVENCOLDIS_SHIFT 10U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECEVENROWODDCOLDIS_MASK 0x3C000U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECEVENROWODDCOLDIS_SHIFT 14U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECODDROWEVENCOLDIS_MASK 0x3C0000U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECODDROWEVENCOLDIS_SHIFT 18U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECODDROWODDCOLDIS_MASK 0x3C00000U
#define IMXDPUV1_LAYERBLEND0_CONTROL_SECODDROWODDCOLDIS_SHIFT 22U

/* Register: IMXDPUV1_layerblend0_BlendControl */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL                    ((uint32_t)(0xA410))
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_OFFSET             ((uint32_t)(0x10))
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_RESET_VALUE        0x1010U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC_MASK 0x7U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC_SHIFT 0U
/* Field Value: PRIM_C_BLD_FUNC__ZERO, Cout = Cin * 0  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__ZERO 0U
/* Field Value: PRIM_C_BLD_FUNC__ONE, Cout = Cin * 1  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__ONE 0x1U
/* Field Value: PRIM_C_BLD_FUNC__PRIM_ALPHA, Cout = Cin * ALPHA_prim  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__PRIM_ALPHA 0x2U
/* Field Value: PRIM_C_BLD_FUNC__ONE_MINUS_PRIM_ALPHA, Cout = Cin * (1 - ALPHA_prim)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__ONE_MINUS_PRIM_ALPHA 0x3U
/* Field Value: PRIM_C_BLD_FUNC__SEC_ALPHA, Cout = Cin * ALPHA_sec  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__SEC_ALPHA 0x4U
/* Field Value: PRIM_C_BLD_FUNC__ONE_MINUS_SEC_ALPHA, Cout = Cin * (1 - ALPHA_sec)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__ONE_MINUS_SEC_ALPHA 0x5U
/* Field Value: PRIM_C_BLD_FUNC__CONST_ALPHA, Cout = Cin * ALPHA_const  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__CONST_ALPHA 0x6U
/* Field Value: PRIM_C_BLD_FUNC__ONE_MINUS_CONST_ALPHA, Cout = Cin * (1 -
 * ALPHA_const)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_C_BLD_FUNC__ONE_MINUS_CONST_ALPHA 0x7U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC_MASK 0x70U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC_SHIFT 4U
/* Field Value: SEC_C_BLD_FUNC__ZERO, Cout = Cin * 0  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__ZERO 0U
/* Field Value: SEC_C_BLD_FUNC__ONE, Cout = Cin * 1  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__ONE 0x1U
/* Field Value: SEC_C_BLD_FUNC__PRIM_ALPHA, Cout = Cin * ALPHA_prim  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__PRIM_ALPHA 0x2U
/* Field Value: SEC_C_BLD_FUNC__ONE_MINUS_PRIM_ALPHA, Cout = Cin * (1 - ALPHA_prim)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__ONE_MINUS_PRIM_ALPHA 0x3U
/* Field Value: SEC_C_BLD_FUNC__SEC_ALPHA, Cout = Cin * ALPHA_sec  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__SEC_ALPHA 0x4U
/* Field Value: SEC_C_BLD_FUNC__ONE_MINUS_SEC_ALPHA, Cout = Cin * (1 - ALPHA_sec)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__ONE_MINUS_SEC_ALPHA 0x5U
/* Field Value: SEC_C_BLD_FUNC__CONST_ALPHA, Cout = Cin * ALPHA_const  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__CONST_ALPHA 0x6U
/* Field Value: SEC_C_BLD_FUNC__ONE_MINUS_CONST_ALPHA, Cout = Cin * (1 - ALPHA_const)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_C_BLD_FUNC__ONE_MINUS_CONST_ALPHA 0x7U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC_MASK 0x700U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC_SHIFT 8U
/* Field Value: PRIM_A_BLD_FUNC__ZERO, Aout = Ain * 0  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__ZERO 0U
/* Field Value: PRIM_A_BLD_FUNC__ONE, Aout = Ain * 1  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__ONE 0x1U
/* Field Value: PRIM_A_BLD_FUNC__PRIM_ALPHA, Aout = Ain * ALPHA_prim  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__PRIM_ALPHA 0x2U
/* Field Value: PRIM_A_BLD_FUNC__ONE_MINUS_PRIM_ALPHA, Aout = Ain * (1 - ALPHA_prim)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__ONE_MINUS_PRIM_ALPHA 0x3U
/* Field Value: PRIM_A_BLD_FUNC__SEC_ALPHA, Aout = Ain * ALPHA_sec  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__SEC_ALPHA 0x4U
/* Field Value: PRIM_A_BLD_FUNC__ONE_MINUS_SEC_ALPHA, Aout = Ain * (1 - ALPHA_sec)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__ONE_MINUS_SEC_ALPHA 0x5U
/* Field Value: PRIM_A_BLD_FUNC__CONST_ALPHA, Aout = Ain * ALPHA_const  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__CONST_ALPHA 0x6U
/* Field Value: PRIM_A_BLD_FUNC__ONE_MINUS_CONST_ALPHA, Aout = Ain * (1 -
 * ALPHA_const)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_PRIM_A_BLD_FUNC__ONE_MINUS_CONST_ALPHA 0x7U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC_MASK 0x7000U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC_SHIFT 12U
/* Field Value: SEC_A_BLD_FUNC__ZERO, Aout = Ain * 0  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__ZERO 0U
/* Field Value: SEC_A_BLD_FUNC__ONE, Aout = Ain * 1  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__ONE 0x1U
/* Field Value: SEC_A_BLD_FUNC__PRIM_ALPHA, Aout = Ain * ALPHA_prim  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__PRIM_ALPHA 0x2U
/* Field Value: SEC_A_BLD_FUNC__ONE_MINUS_PRIM_ALPHA, Aout = Ain * (1 - ALPHA_prim)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__ONE_MINUS_PRIM_ALPHA 0x3U
/* Field Value: SEC_A_BLD_FUNC__SEC_ALPHA, Aout = Ain * ALPHA_sec  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__SEC_ALPHA 0x4U
/* Field Value: SEC_A_BLD_FUNC__ONE_MINUS_SEC_ALPHA, Aout = Ain * (1 - ALPHA_sec)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__ONE_MINUS_SEC_ALPHA 0x5U
/* Field Value: SEC_A_BLD_FUNC__CONST_ALPHA, Aout = Ain * ALPHA_const  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__CONST_ALPHA 0x6U
/* Field Value: SEC_A_BLD_FUNC__ONE_MINUS_CONST_ALPHA, Aout = Ain * (1 - ALPHA_const)  */
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_SEC_A_BLD_FUNC__ONE_MINUS_CONST_ALPHA 0x7U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_BLENDALPHA_MASK    0xFF0000U
#define IMXDPUV1_LAYERBLEND0_BLENDCONTROL_BLENDALPHA_SHIFT   16U

/* Register: IMXDPUV1_layerblend0_Position */
#define IMXDPUV1_LAYERBLEND0_POSITION                        ((uint32_t)(0xA414))
#define IMXDPUV1_LAYERBLEND0_POSITION_OFFSET                 ((uint32_t)(0x14))
#define IMXDPUV1_LAYERBLEND0_POSITION_RESET_VALUE            0U
#define IMXDPUV1_LAYERBLEND0_POSITION_RESET_MASK             0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_POSITION_XPOS_MASK              0xFFFFU
#define IMXDPUV1_LAYERBLEND0_POSITION_XPOS_SHIFT             0U
#define IMXDPUV1_LAYERBLEND0_POSITION_YPOS_MASK              0xFFFF0000U
#define IMXDPUV1_LAYERBLEND0_POSITION_YPOS_SHIFT             16U

/* Register: IMXDPUV1_layerblend0_PrimControlWord */
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD                 ((uint32_t)(0xA418))
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD_OFFSET          ((uint32_t)(0x18))
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD_RESET_VALUE     0U
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD_RESET_MASK      0U
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD_P_VAL_MASK      0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_PRIMCONTROLWORD_P_VAL_SHIFT     0U

/* Register: IMXDPUV1_layerblend0_SecControlWord */
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD                  ((uint32_t)(0xA41C))
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD_OFFSET           ((uint32_t)(0x1C))
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD_RESET_VALUE      0U
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD_RESET_MASK       0U
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD_S_VAL_MASK       0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND0_SECCONTROLWORD_S_VAL_SHIFT      0U

/* Register: IMXDPUV1_layerblend1_LockUnlock */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK                      ((uint32_t)(0xA800))
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_OFFSET               ((uint32_t)(0))
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_RESET_VALUE          0U
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_RESET_MASK           0U
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK_MASK      0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK_SHIFT     0U
/* Field Value: LOCKUNLOCK__LOCK_KEY, Decrements the unlock counter. When
 * the counter value is null, lock protection is active. Reset counter value
 * is 1.  */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK__LOCK_KEY 0x5651F763U
/* Field Value: LOCKUNLOCK__UNLOCK_KEY, Increments the unlock counter. Max
 * allowed value is 15.  */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK__UNLOCK_KEY 0x691DB936U
/* Field Value: LOCKUNLOCK__PRIVILEGE_KEY, Enables privilege protection. Disabled
 * after reset.  */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK__PRIVILEGE_KEY 0xAEE95CDCU
/* Field Value: LOCKUNLOCK__UNPRIVILEGE_KEY, Disables privilege protection.  */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK__UNPRIVILEGE_KEY 0xB5E2466EU
/* Field Value: LOCKUNLOCK__FREEZE_KEY, Freezes current protection status.
 * Writing keys to this register has no more effect until reset.  */
#define IMXDPUV1_LAYERBLEND1_LOCKUNLOCK_LOCKUNLOCK__FREEZE_KEY 0xFBE8B1E6U

/* Register: IMXDPUV1_layerblend1_LockStatus */
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS                      ((uint32_t)(0xA804))
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_OFFSET               ((uint32_t)(0x4))
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_RESET_VALUE          0U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_RESET_MASK           0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_LOCKSTATUS_MASK      0x1U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_LOCKSTATUS_SHIFT     0U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_PRIVILEGESTATUS_MASK 0x10U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_PRIVILEGESTATUS_SHIFT 4U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_FREEZESTATUS_MASK    0x100U
#define IMXDPUV1_LAYERBLEND1_LOCKSTATUS_FREEZESTATUS_SHIFT   8U

/* Register: IMXDPUV1_layerblend1_StaticControl */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL                   ((uint32_t)(0xA808))
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_OFFSET            ((uint32_t)(0x8))
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_RESET_VALUE       0x14U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_RESET_MASK        0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDEN_MASK        0x1U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDEN_SHIFT       0U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDLDSEL_MASK     0x6U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDLDSEL_SHIFT    1U
/* Field Value: SHDLDSEL__PRIMARY, Load shadows with shadow load token on
 * primary input (background plane).  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDLDSEL__PRIMARY 0U
/* Field Value: SHDLDSEL__SECONDARY, Load shadows with shadow load token on
 * secondary input (foreground plane).  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDLDSEL__SECONDARY 0x1U
/* Field Value: SHDLDSEL__BOTH, Load shadows with shadow load token on any
 * input.  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDLDSEL__BOTH    0x2U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDTOKSEL_MASK    0x18U
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDTOKSEL_SHIFT   3U
/* Field Value: SHDTOKSEL__PRIMARY, When a token was received on the primary
 * input (background plane).  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDTOKSEL__PRIMARY 0U
/* Field Value: SHDTOKSEL__SECONDARY, When a token was received on the secondary
 * input (foreground plane).  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDTOKSEL__SECONDARY 0x1U
/* Field Value: SHDTOKSEL__BOTH, When a token was received on any input.  */
#define IMXDPUV1_LAYERBLEND1_STATICCONTROL_SHDTOKSEL__BOTH   0x2U

/* Register: IMXDPUV1_layerblend1_Control */
#define IMXDPUV1_LAYERBLEND1_CONTROL                         ((uint32_t)(0xA80C))
#define IMXDPUV1_LAYERBLEND1_CONTROL_OFFSET                  ((uint32_t)(0xC))
#define IMXDPUV1_LAYERBLEND1_CONTROL_RESET_VALUE             0x1U
#define IMXDPUV1_LAYERBLEND1_CONTROL_RESET_MASK              0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND1_CONTROL_MODE_MASK               0x1U
#define IMXDPUV1_LAYERBLEND1_CONTROL_MODE_SHIFT              0U
/* Field Value: MODE__NEUTRAL, Module is in neutral mode. Output is same as
 * primary input.  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_MODE__NEUTRAL           0U
/* Field Value: MODE__BLEND, Module is in blending mode.  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_MODE__BLEND             0x1U
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKENABLE_MASK    0x4U
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKENABLE_SHIFT   2U
/* Field Value: ALPHAMASKENABLE__DISABLE, AlphaMask feature disabled  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKENABLE__DISABLE 0U
/* Field Value: ALPHAMASKENABLE__ENABLE, AlphaMask feature enabled  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKENABLE__ENABLE 0x1U
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE_MASK      0x70U
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE_SHIFT     4U
/* Field Value: ALPHAMASKMODE__PRIM, Areas with primary input alpha > 128
 * will be mapped to 255 and the rest will have an alpha value of 0  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM     0U
/* Field Value: ALPHAMASKMODE__SEC, The area of the secondary input will get
 * an alpha value of 255 and the rest will be 0  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__SEC      0x1U
/* Field Value: ALPHAMASKMODE__PRIM_OR_SEC, Behaves as if the output of modes
 * PRIM and SEC would be ORed together  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM_OR_SEC 0x2U
/* Field Value: ALPHAMASKMODE__PRIM_AND_SEC, Behaves as if the output of modes
 * PRIM and SEC would be ANDed together  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM_AND_SEC 0x3U
/* Field Value: ALPHAMASKMODE__PRIM_INV, Behaves as if the output of mode
 * PRIM would be inverted  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM_INV 0x4U
/* Field Value: ALPHAMASKMODE__SEC_INV, Behaves as if the output of mode SEC
 * would be inverted  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__SEC_INV  0x5U
/* Field Value: ALPHAMASKMODE__PRIM_OR_SEC_INV, Behaves as if the output of
 * modes PRIM and SEC_INV would be ORed together  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM_OR_SEC_INV 0x6U
/* Field Value: ALPHAMASKMODE__PRIM_AND_SEC_INV, Behaves as if the output
 * of modes PRIM and SEC_INV would be ANDed together  */
#define IMXDPUV1_LAYERBLEND1_CONTROL_ALPHAMASKMODE__PRIM_AND_SEC_INV 0x7U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECLOWPASSEN_MASK       0x100U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECLOWPASSEN_SHIFT      8U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECREPLICATEEN_MASK     0x200U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECREPLICATEEN_SHIFT    9U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECEVENROWEVENCOLDIS_MASK 0x3C00U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECEVENROWEVENCOLDIS_SHIFT 10U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECEVENROWODDCOLDIS_MASK 0x3C000U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECEVENROWODDCOLDIS_SHIFT 14U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECODDROWEVENCOLDIS_MASK 0x3C0000U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECODDROWEVENCOLDIS_SHIFT 18U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECODDROWODDCOLDIS_MASK 0x3C00000U
#define IMXDPUV1_LAYERBLEND1_CONTROL_SECODDROWODDCOLDIS_SHIFT 22U

/* Register: IMXDPUV1_layerblend1_BlendControl */
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL                    ((uint32_t)(0xA810))
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_OFFSET             ((uint32_t)(0x10))
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_RESET_VALUE        0x1010U
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_RESET_MASK         0xFFFFFFFFU
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_PRIM_C_BLD_FUNC_MASK 0x7U
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_PRIM_C_BLD_FUNC_SHIFT 0U
/* Field Value: PRIM_C_BLD_FUNC__ZERO, Cout = Cin * 0  */
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_PRIM_C_BLD_FUNC__ZERO 0U
/* Field Value: PRIM_C_BLD_FUNC__ONE, Cout = Cin * 1  */
#define IMXDPUV1_LAYERBLEND1_BLENDCONTROL_PRIM_C_BLD_FUNC__ONE 0x1U
/* Field Value: PRIM_C_BLD_FUNC__PRIM_ALPHA, Cout = Cin * ALPHA_prim