/*
* This module works like a uboot boot-script
* It sets the mmcpart environment variable depending on the environment variables BOOT_ORDER, BOOT_A_LEFT, BOOT_B_LEFT 
* and the ext_csd register of the eMMC. 
*/


#ifndef __BOOTCONTROL_H
#define __BOOTCONTROL_H

#include <common.h>
#include <mmc.h>

#define MMC_DEVICE              2   /* default mmc device */

/* RAUC environment variables */
#define uvar_BOOT_A_LEFT	    "BOOT_A_LEFT"
#define uvar_BOOT_B_LEFT	    "BOOT_B_LEFT"
#define uvar_BOOT_ORDER		    "BOOT_ORDER"

#define default_BOOT_A_LEFT		"3"
#define default_BOOT_B_LEFT		"3"
#define default_BOOT_ORDER		"A B"
#define MMCBLK2BOOT0			1
#define MMCBLK2BOOT1			2
#define ACK						(u8)1
#define ACCESS					(u8)1

#define PRINT_COLORED_OUTPUT

/* Definition list for terminal colors */
/* copied from main.c in the rauc package */
#ifdef PRINT_COLORED_OUTPUT
    #define KNRM  "\x1B[0m"
    #define KRED  "\x1B[31m"
    #define KGRN  "\x1B[32m"
    #define KYEL  "\x1B[33m"
    #define KBLU  "\x1B[34m"
    #define KMAG  "\x1B[35m"
    #define KCYN  "\x1B[36m"
    #define KWHT  "\x1B[37m"
    #define KBLD  "\x1B[1m"
#else
    #define KNRM  ""
    #define KRED  ""
    #define KGRN  ""
    #define KYEL  ""
    #define KBLU  ""
    #define KMAG  ""
    #define KCYN  ""
    #define KWHT  ""
    #define KBLD  ""
#endif
int bootControl(void);
void resetBoard(int delaySec);

void printBox(char* lines[], char* textColor, char* boxColor);

#endif