/*
 * Copyright (C) 2011-2015 Freescale Semiconductor, Inc. All Rights Reserved.
 * Copyright 2019 NXP
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/ctype.h>
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/clk.h>
#include <linux/of_device.h>
#include <linux/i2c.h>
#include <linux/of_gpio.h>
#include <linux/pinctrl/consumer.h>
#include <linux/regulator/consumer.h>
#include <linux/fsl_devices.h>
#include <linux/mipi_csi2.h>
#include <media/v4l2-chip-ident.h>
#include "v4l2-int-device.h"
#include "mxc_v4l2_capture.h"

#define OV5640_VOLTAGE_ANALOG               2800000
#define OV5640_VOLTAGE_DIGITAL_CORE         1500000
#define OV5640_VOLTAGE_DIGITAL_IO           1800000

#define MIN_FPS 15
#define MAX_FPS 30
#define DEFAULT_FPS 30

#define OV5640_XCLK_MIN 6000000
#define OV5640_XCLK_MAX 24000000

#define OV5640_CHIP_ID_HIGH_BYTE	0x300A
#define OV5640_CHIP_ID_LOW_BYTE		0x300B
/* AF Mode registers */
#define OV5640_AF_MODE		0x3022
#define OV5640_REG_AF_X_POS	0x3024
#define OV5640_REG_AF_Y_POS	0x3025
#define OV5640_REG_AF_STATUS	0x3029


/* OV5640 has 80x60 AF window size */
#define OV5640_AF_WINDOW_WIDTH	80
#define OV5640_AF_WINDOW_HEIGHT	60

/*AF Mode Values*/
#define OV5640_AF_MODE_SINGLE		0x03
#define OV5640_AF_MODE_CONT		0x04
#define OV5640_AF_MODE_PAUSE		0x06
#define OV5640_AF_MODE_RELEASE		0x08
#define OV5640_AF_MODE_RESTART		0x80
#define OV5640_AF_MODE_SET_ZONE		0x81

/* OV5640 AF MCU status */
#define OV5640_AF_STATUS_RUN	0x00
#define OV5640_AF_STATUS_FINISH	0x10
#define OV5640_AF_STATUS_DL	0x7f
#define OV5640_AF_STATUS_INIT	0x7e
#define OV5640_AF_STATUS_IDLE	0x70

static int focus_mode = V4L2_CID_AUTO_FOCUS_STOP;
static int focus_range = V4L2_AUTO_FOCUS_RANGE_NORMAL;
static uint16_t g_roi_x;
static uint16_t g_roi_y;


enum ov5640_mode {
	ov5640_mode_MIN = 0,
	ov5640_mode_VGA_640_480 = 0,
	ov5640_mode_QVGA_320_240 = 1,
	ov5640_mode_NTSC_720_480 = 2,
	ov5640_mode_PAL_720_576 = 3,
	ov5640_mode_720P_1280_720 = 4,
	ov5640_mode_1080P_1920_1080 = 5,
	ov5640_mode_QSXGA_2592_1944 = 6,
	ov5640_mode_QCIF_176_144 = 7,
	ov5640_mode_XGA_1024_768 = 8,
	ov5640_mode_MAX = 8,
	ov5640_mode_INIT = 0xff, /*only for sensor init*/
};

enum ov5640_frame_rate {
	ov5640_15_fps,
	ov5640_30_fps
};

static int ov5640_framerates[] = {
	[ov5640_15_fps] = 15,
	[ov5640_30_fps] = 30,
};

/* image size under 1280 * 960 are SUBSAMPLING
 * image size upper 1280 * 960 are SCALING
 */
enum ov5640_downsize_mode {
	SUBSAMPLING,
	SCALING,
};

struct reg_value {
	u16 u16RegAddr;
	u8 u8Val;
	u8 u8Mask;
	u32 u32Delay_ms;
};

struct ov5640_mode_info {
	enum ov5640_mode mode;
	enum ov5640_downsize_mode dn_mode;
	u32 width;
	u32 height;
	struct reg_value *init_data_ptr;
	u32 init_data_size;
};

/*!
 * Maintains the information on the current state of the sesor.
 */
static struct sensor_data ov5640_data;
static int pwn_gpio, rst_gpio;

static struct reg_value ov5640_init_setting_30fps_VGA[] = {

	{0x3103, 0x11, 0, 0}, {0x3008, 0x82, 0, 5}, {0x3008, 0x42, 0, 0},
	{0x3103, 0x03, 0, 0}, {0x3017, 0x00, 0, 0}, {0x3018, 0x00, 0, 0},
	{0x3034, 0x18, 0, 0}, {0x3035, 0x14, 0, 0}, {0x3036, 0x38, 0, 0},
	{0x3037, 0x13, 0, 0}, {0x3108, 0x01, 0, 0}, {0x3630, 0x36, 0, 0},
	{0x3631, 0x0e, 0, 0}, {0x3632, 0xe2, 0, 0}, {0x3633, 0x12, 0, 0},
	{0x3621, 0xe0, 0, 0}, {0x3704, 0xa0, 0, 0}, {0x3703, 0x5a, 0, 0},
	{0x3715, 0x78, 0, 0}, {0x3717, 0x01, 0, 0}, {0x370b, 0x60, 0, 0},
	{0x3705, 0x1a, 0, 0}, {0x3905, 0x02, 0, 0}, {0x3906, 0x10, 0, 0},
	{0x3901, 0x0a, 0, 0}, {0x3731, 0x12, 0, 0}, {0x3600, 0x08, 0, 0},
	{0x3601, 0x33, 0, 0}, {0x302d, 0x60, 0, 0}, {0x3620, 0x52, 0, 0},
	{0x371b, 0x20, 0, 0}, {0x471c, 0x50, 0, 0}, {0x3a13, 0x43, 0, 0},
	{0x3a18, 0x00, 0, 0}, {0x3a19, 0xf8, 0, 0}, {0x3635, 0x13, 0, 0},
	{0x3636, 0x03, 0, 0}, {0x3634, 0x40, 0, 0}, {0x3622, 0x01, 0, 0},
	{0x3c01, 0xa4, 0, 0}, {0x3c04, 0x28, 0, 0}, {0x3c05, 0x98, 0, 0},
	{0x3c06, 0x00, 0, 0}, {0x3c07, 0x08, 0, 0}, {0x3c08, 0x00, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0x80, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x3000, 0x00, 0, 0},
	{0x3002, 0x1c, 0, 0}, {0x3004, 0xff, 0, 0}, {0x3006, 0xc3, 0, 0},
	{0x300e, 0x45, 0, 0}, {0x302e, 0x08, 0, 0}, {0x4300, 0x3f, 0, 0},
	{0x501f, 0x00, 0, 0}, {0x4713, 0x03, 0, 0}, {0x4407, 0x04, 0, 0},
	{0x440e, 0x00, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x4837, 0x0a, 0, 0}, {0x4800, 0x04, 0, 0}, {0x3824, 0x02, 0, 0},
	{0x5000, 0xa7, 0, 0}, {0x5001, 0xa3, 0, 0}, {0x5180, 0xff, 0, 0},
	{0x5181, 0xf2, 0, 0}, {0x5182, 0x00, 0, 0}, {0x5183, 0x14, 0, 0},
	{0x5184, 0x25, 0, 0}, {0x5185, 0x24, 0, 0}, {0x5186, 0x09, 0, 0},
	{0x5187, 0x09, 0, 0}, {0x5188, 0x09, 0, 0}, {0x5189, 0x88, 0, 0},
	{0x518a, 0x54, 0, 0}, {0x518b, 0xee, 0, 0}, {0x518c, 0xb2, 0, 0},
	{0x518d, 0x50, 0, 0}, {0x518e, 0x34, 0, 0}, {0x518f, 0x6b, 0, 0},
	{0x5190, 0x46, 0, 0}, {0x5191, 0xf8, 0, 0}, {0x5192, 0x04, 0, 0},
	{0x5193, 0x70, 0, 0}, {0x5194, 0xf0, 0, 0}, {0x5195, 0xf0, 0, 0},
	{0x5196, 0x03, 0, 0}, {0x5197, 0x01, 0, 0}, {0x5198, 0x04, 0, 0},
	{0x5199, 0x6c, 0, 0}, {0x519a, 0x04, 0, 0}, {0x519b, 0x00, 0, 0},
	{0x519c, 0x09, 0, 0}, {0x519d, 0x2b, 0, 0}, {0x519e, 0x38, 0, 0},
	{0x5381, 0x1e, 0, 0}, {0x5382, 0x5b, 0, 0}, {0x5383, 0x08, 0, 0},
	{0x5384, 0x0a, 0, 0}, {0x5385, 0x7e, 0, 0}, {0x5386, 0x88, 0, 0},
	{0x5387, 0x7c, 0, 0}, {0x5388, 0x6c, 0, 0}, {0x5389, 0x10, 0, 0},
	{0x538a, 0x01, 0, 0}, {0x538b, 0x98, 0, 0}, {0x5300, 0x08, 0, 0},
	{0x5301, 0x30, 0, 0}, {0x5302, 0x10, 0, 0}, {0x5303, 0x00, 0, 0},
	{0x5304, 0x08, 0, 0}, {0x5305, 0x30, 0, 0}, {0x5306, 0x08, 0, 0},
	{0x5307, 0x16, 0, 0}, {0x5309, 0x08, 0, 0}, {0x530a, 0x30, 0, 0},
	{0x530b, 0x04, 0, 0}, {0x530c, 0x06, 0, 0}, {0x5480, 0x01, 0, 0},
	{0x5481, 0x08, 0, 0}, {0x5482, 0x14, 0, 0}, {0x5483, 0x28, 0, 0},
	{0x5484, 0x51, 0, 0}, {0x5485, 0x65, 0, 0}, {0x5486, 0x71, 0, 0},
	{0x5487, 0x7d, 0, 0}, {0x5488, 0x87, 0, 0}, {0x5489, 0x91, 0, 0},
	{0x548a, 0x9a, 0, 0}, {0x548b, 0xaa, 0, 0}, {0x548c, 0xb8, 0, 0},
	{0x548d, 0xcd, 0, 0}, {0x548e, 0xdd, 0, 0}, {0x548f, 0xea, 0, 0},
	{0x5490, 0x1d, 0, 0}, {0x5580, 0x02, 0, 0}, {0x5583, 0x40, 0, 0},
	{0x5584, 0x10, 0, 0}, {0x5589, 0x10, 0, 0}, {0x558a, 0x00, 0, 0},
	{0x558b, 0xf8, 0, 0}, {0x5800, 0x23, 0, 0}, {0x5801, 0x14, 0, 0},
	{0x5802, 0x0f, 0, 0}, {0x5803, 0x0f, 0, 0}, {0x5804, 0x12, 0, 0},
	{0x5805, 0x26, 0, 0}, {0x5806, 0x0c, 0, 0}, {0x5807, 0x08, 0, 0},
	{0x5808, 0x05, 0, 0}, {0x5809, 0x05, 0, 0}, {0x580a, 0x08, 0, 0},
	{0x580b, 0x0d, 0, 0}, {0x580c, 0x08, 0, 0}, {0x580d, 0x03, 0, 0},
	{0x580e, 0x00, 0, 0}, {0x580f, 0x00, 0, 0}, {0x5810, 0x03, 0, 0},
	{0x5811, 0x09, 0, 0}, {0x5812, 0x07, 0, 0}, {0x5813, 0x03, 0, 0},
	{0x5814, 0x00, 0, 0}, {0x5815, 0x01, 0, 0}, {0x5816, 0x03, 0, 0},
	{0x5817, 0x08, 0, 0}, {0x5818, 0x0d, 0, 0}, {0x5819, 0x08, 0, 0},
	{0x581a, 0x05, 0, 0}, {0x581b, 0x06, 0, 0}, {0x581c, 0x08, 0, 0},
	{0x581d, 0x0e, 0, 0}, {0x581e, 0x29, 0, 0}, {0x581f, 0x17, 0, 0},
	{0x5820, 0x11, 0, 0}, {0x5821, 0x11, 0, 0}, {0x5822, 0x15, 0, 0},
	{0x5823, 0x28, 0, 0}, {0x5824, 0x46, 0, 0}, {0x5825, 0x26, 0, 0},
	{0x5826, 0x08, 0, 0}, {0x5827, 0x26, 0, 0}, {0x5828, 0x64, 0, 0},
	{0x5829, 0x26, 0, 0}, {0x582a, 0x24, 0, 0}, {0x582b, 0x22, 0, 0},
	{0x582c, 0x24, 0, 0}, {0x582d, 0x24, 0, 0}, {0x582e, 0x06, 0, 0},
	{0x582f, 0x22, 0, 0}, {0x5830, 0x40, 0, 0}, {0x5831, 0x42, 0, 0},
	{0x5832, 0x24, 0, 0}, {0x5833, 0x26, 0, 0}, {0x5834, 0x24, 0, 0},
	{0x5835, 0x22, 0, 0}, {0x5836, 0x22, 0, 0}, {0x5837, 0x26, 0, 0},
	{0x5838, 0x44, 0, 0}, {0x5839, 0x24, 0, 0}, {0x583a, 0x26, 0, 0},
	{0x583b, 0x28, 0, 0}, {0x583c, 0x42, 0, 0}, {0x583d, 0xce, 0, 0},
	{0x5025, 0x00, 0, 0}, {0x3a0f, 0x30, 0, 0}, {0x3a10, 0x28, 0, 0},
	{0x3a1b, 0x30, 0, 0}, {0x3a1e, 0x26, 0, 0}, {0x3a11, 0x60, 0, 0},
	{0x3a1f, 0x14, 0, 0}, {0x3008, 0x02, 0, 0}, {0x3c00, 0x04, 0, 300},
};

static struct reg_value ov5640_setting_30fps_VGA_640_480[] = {

	{0x3035, 0x14, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0x80, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x04, 0, 0}, {0x380f, 0x38, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x0e, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0}, {0x3503, 0x00, 0, 0},
};

static struct reg_value ov5640_setting_15fps_VGA_640_480[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0x80, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_30fps_XGA_1024_768[] = {

	{0x3035, 0x14, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0x80, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x04, 0, 0}, {0x380f, 0x38, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x0e, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0}, {0x3503, 0x00, 0, 0},
	{0x3808, 0x04, 0, 0}, {0x3809, 0x00, 0, 0}, {0x380a, 0x03, 0, 0},
	{0x380b, 0x00, 0, 0}, {0x3035, 0x12, 0, 0},
};

static struct reg_value ov5640_setting_15fps_XGA_1024_768[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0x80, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0}, {0x3808, 0x04, 0, 0},
	{0x3809, 0x00, 0, 0}, {0x380a, 0x03, 0, 0}, {0x380b, 0x00, 0, 0},
};

static struct reg_value ov5640_setting_30fps_QVGA_320_240[] = {
	{0x3035, 0x14, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x01, 0, 0}, {0x3809, 0x40, 0, 0}, {0x380a, 0x00, 0, 0},
	{0x380b, 0xf0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_15fps_QVGA_320_240[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x01, 0, 0}, {0x3809, 0x40, 0, 0}, {0x380a, 0x00, 0, 0},
	{0x380b, 0xf0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_30fps_QCIF_176_144[] = {
	{0x3035, 0x14, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x00, 0, 0}, {0x3809, 0xb0, 0, 0}, {0x380a, 0x00, 0, 0},
	{0x380b, 0x90, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};
static struct reg_value ov5640_setting_15fps_QCIF_176_144[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x00, 0, 0}, {0x3809, 0xb0, 0, 0}, {0x380a, 0x00, 0, 0},
	{0x380b, 0x90, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_30fps_NTSC_720_480[] = {
	{0x3035, 0x12, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0xd0, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x3c, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_15fps_NTSC_720_480[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0xd0, 0, 0}, {0x380a, 0x01, 0, 0},
	{0x380b, 0xe0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x3c, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_30fps_PAL_720_576[] = {
	{0x3035, 0x12, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0xd0, 0, 0}, {0x380a, 0x02, 0, 0},
	{0x380b, 0x40, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x38, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_15fps_PAL_720_576[] = {
	{0x3035, 0x22, 0, 0}, {0x3036, 0x38, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x04, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9b, 0, 0},
	{0x3808, 0x02, 0, 0}, {0x3809, 0xd0, 0, 0}, {0x380a, 0x02, 0, 0},
	{0x380b, 0x40, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x68, 0, 0},
	{0x380e, 0x03, 0, 0}, {0x380f, 0xd8, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x38, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x06, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0xa3, 0, 0},
};

static struct reg_value ov5640_setting_30fps_720P_1280_720[] = {
	{0x3008, 0x42, 0, 0},
	{0x3035, 0x21, 0, 0}, {0x3036, 0x54, 0, 0}, {0x3c07, 0x07, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0xfa, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x06, 0, 0}, {0x3807, 0xa9, 0, 0},
	{0x3808, 0x05, 0, 0}, {0x3809, 0x00, 0, 0}, {0x380a, 0x02, 0, 0},
	{0x380b, 0xd0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x64, 0, 0},
	{0x380e, 0x02, 0, 0}, {0x380f, 0xe4, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x04, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x02, 0, 0},
	{0x3a03, 0xe4, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0xbc, 0, 0},
	{0x3a0a, 0x01, 0, 0}, {0x3a0b, 0x72, 0, 0}, {0x3a0e, 0x01, 0, 0},
	{0x3a0d, 0x02, 0, 0}, {0x3a14, 0x02, 0, 0}, {0x3a15, 0xe4, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x02, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x37, 0, 0}, {0x460c, 0x20, 0, 0},
	{0x3824, 0x04, 0, 0}, {0x5001, 0x83, 0, 0}, {0x4005, 0x1a, 0, 0},
	{0x3008, 0x02, 0, 0}, {0x3503, 0,    0, 0},
};

static struct reg_value ov5640_setting_15fps_720P_1280_720[] = {
	{0x3035, 0x41, 0, 0}, {0x3036, 0x54, 0, 0}, {0x3c07, 0x07, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x41, 0, 0}, {0x3821, 0x07, 0, 0}, {0x3814, 0x31, 0, 0},
	{0x3815, 0x31, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0xfa, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x06, 0, 0}, {0x3807, 0xa9, 0, 0},
	{0x3808, 0x05, 0, 0}, {0x3809, 0x00, 0, 0}, {0x380a, 0x02, 0, 0},
	{0x380b, 0xd0, 0, 0}, {0x380c, 0x07, 0, 0}, {0x380d, 0x64, 0, 0},
	{0x380e, 0x02, 0, 0}, {0x380f, 0xe4, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x04, 0, 0},
	{0x3618, 0x00, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3709, 0x52, 0, 0}, {0x370c, 0x03, 0, 0}, {0x3a02, 0x02, 0, 0},
	{0x3a03, 0xe4, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0xbc, 0, 0},
	{0x3a0a, 0x01, 0, 0}, {0x3a0b, 0x72, 0, 0}, {0x3a0e, 0x01, 0, 0},
	{0x3a0d, 0x02, 0, 0}, {0x3a14, 0x02, 0, 0}, {0x3a15, 0xe4, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x02, 0, 0}, {0x4713, 0x02, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x37, 0, 0}, {0x460c, 0x20, 0, 0},
	{0x3824, 0x04, 0, 0}, {0x5001, 0x83, 0, 0},
};

static struct reg_value ov5640_setting_30fps_1080P_1920_1080[] = {
	{0x3008, 0x42, 0, 0},
	{0x3035, 0x21, 0, 0}, {0x3036, 0x54, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x40, 0, 0}, {0x3821, 0x06, 0, 0}, {0x3814, 0x11, 0, 0},
	{0x3815, 0x11, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x00, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9f, 0, 0},
	{0x3808, 0x0a, 0, 0}, {0x3809, 0x20, 0, 0}, {0x380a, 0x07, 0, 0},
	{0x380b, 0x98, 0, 0}, {0x380c, 0x0b, 0, 0}, {0x380d, 0x1c, 0, 0},
	{0x380e, 0x07, 0, 0}, {0x380f, 0xb0, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x04, 0, 0},
	{0x3618, 0x04, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x21, 0, 0},
	{0x3709, 0x12, 0, 0}, {0x370c, 0x00, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x06, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0x83, 0, 0}, {0x3035, 0x11, 0, 0},
	{0x3036, 0x54, 0, 0}, {0x3c07, 0x07, 0, 0}, {0x3c08, 0x00, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3800, 0x01, 0, 0}, {0x3801, 0x50, 0, 0}, {0x3802, 0x01, 0, 0},
	{0x3803, 0xb2, 0, 0}, {0x3804, 0x08, 0, 0}, {0x3805, 0xef, 0, 0},
	{0x3806, 0x05, 0, 0}, {0x3807, 0xf1, 0, 0}, {0x3808, 0x07, 0, 0},
	{0x3809, 0x80, 0, 0}, {0x380a, 0x04, 0, 0}, {0x380b, 0x38, 0, 0},
	{0x380c, 0x09, 0, 0}, {0x380d, 0xc4, 0, 0}, {0x380e, 0x04, 0, 0},
	{0x380f, 0x60, 0, 0}, {0x3612, 0x2b, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3a02, 0x04, 0, 0}, {0x3a03, 0x60, 0, 0}, {0x3a08, 0x01, 0, 0},
	{0x3a09, 0x50, 0, 0}, {0x3a0a, 0x01, 0, 0}, {0x3a0b, 0x18, 0, 0},
	{0x3a0e, 0x03, 0, 0}, {0x3a0d, 0x04, 0, 0}, {0x3a14, 0x04, 0, 0},
	{0x3a15, 0x60, 0, 0}, {0x4713, 0x02, 0, 0}, {0x4407, 0x04, 0, 0},
	{0x460b, 0x37, 0, 0}, {0x460c, 0x20, 0, 0}, {0x3824, 0x04, 0, 0},
	{0x4005, 0x1a, 0, 0}, {0x3008, 0x02, 0, 0},
	{0x3503, 0, 0, 0},
};

static struct reg_value ov5640_setting_15fps_1080P_1920_1080[] = {
	{0x3008, 0x42, 0, 0},
	{0x3035, 0x21, 0, 0}, {0x3036, 0x54, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x40, 0, 0}, {0x3821, 0x06, 0, 0}, {0x3814, 0x11, 0, 0},
	{0x3815, 0x11, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x00, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9f, 0, 0},
	{0x3808, 0x0a, 0, 0}, {0x3809, 0x20, 0, 0}, {0x380a, 0x07, 0, 0},
	{0x380b, 0x98, 0, 0}, {0x380c, 0x0b, 0, 0}, {0x380d, 0x1c, 0, 0},
	{0x380e, 0x07, 0, 0}, {0x380f, 0xb0, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x04, 0, 0},
	{0x3618, 0x04, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x21, 0, 0},
	{0x3709, 0x12, 0, 0}, {0x370c, 0x00, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x06, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0x83, 0, 0}, {0x3035, 0x21, 0, 0},
	{0x3036, 0x54, 0, 1}, {0x3c07, 0x07, 0, 0}, {0x3c08, 0x00, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3800, 0x01, 0, 0}, {0x3801, 0x50, 0, 0}, {0x3802, 0x01, 0, 0},
	{0x3803, 0xb2, 0, 0}, {0x3804, 0x08, 0, 0}, {0x3805, 0xef, 0, 0},
	{0x3806, 0x05, 0, 0}, {0x3807, 0xf1, 0, 0}, {0x3808, 0x07, 0, 0},
	{0x3809, 0x80, 0, 0}, {0x380a, 0x04, 0, 0}, {0x380b, 0x38, 0, 0},
	{0x380c, 0x09, 0, 0}, {0x380d, 0xc4, 0, 0}, {0x380e, 0x04, 0, 0},
	{0x380f, 0x60, 0, 0}, {0x3612, 0x2b, 0, 0}, {0x3708, 0x64, 0, 0},
	{0x3a02, 0x04, 0, 0}, {0x3a03, 0x60, 0, 0}, {0x3a08, 0x01, 0, 0},
	{0x3a09, 0x50, 0, 0}, {0x3a0a, 0x01, 0, 0}, {0x3a0b, 0x18, 0, 0},
	{0x3a0e, 0x03, 0, 0}, {0x3a0d, 0x04, 0, 0}, {0x3a14, 0x04, 0, 0},
	{0x3a15, 0x60, 0, 0}, {0x4713, 0x02, 0, 0}, {0x4407, 0x04, 0, 0},
	{0x460b, 0x37, 0, 0}, {0x460c, 0x20, 0, 0}, {0x3824, 0x04, 0, 0},
	{0x4005, 0x1a, 0, 0}, {0x3008, 0x02, 0, 0}, {0x3503, 0, 0, 0},
};

static struct reg_value ov5640_setting_15fps_QSXGA_2592_1944[] = {
	{0x4202, 0x0f, 0, 0},	/* stream off the sensor */
	{0x3820, 0x40, 0, 0}, {0x3821, 0x06, 0, 0}, /*disable flip*/
	{0x3035, 0x21, 0, 0}, {0x3036, 0x54, 0, 0}, {0x3c07, 0x08, 0, 0},
	{0x3c09, 0x1c, 0, 0}, {0x3c0a, 0x9c, 0, 0}, {0x3c0b, 0x40, 0, 0},
	{0x3820, 0x40, 0, 0}, {0x3821, 0x06, 0, 0}, {0x3814, 0x11, 0, 0},
	{0x3815, 0x11, 0, 0}, {0x3800, 0x00, 0, 0}, {0x3801, 0x00, 0, 0},
	{0x3802, 0x00, 0, 0}, {0x3803, 0x00, 0, 0}, {0x3804, 0x0a, 0, 0},
	{0x3805, 0x3f, 0, 0}, {0x3806, 0x07, 0, 0}, {0x3807, 0x9f, 0, 0},
	{0x3808, 0x0a, 0, 0}, {0x3809, 0x20, 0, 0}, {0x380a, 0x07, 0, 0},
	{0x380b, 0x98, 0, 0}, {0x380c, 0x0b, 0, 0}, {0x380d, 0x1c, 0, 0},
	{0x380e, 0x07, 0, 0}, {0x380f, 0xb0, 0, 0}, {0x3810, 0x00, 0, 0},
	{0x3811, 0x10, 0, 0}, {0x3812, 0x00, 0, 0}, {0x3813, 0x04, 0, 0},
	{0x3618, 0x04, 0, 0}, {0x3612, 0x29, 0, 0}, {0x3708, 0x21, 0, 0},
	{0x3709, 0x12, 0, 0}, {0x370c, 0x00, 0, 0}, {0x3a02, 0x03, 0, 0},
	{0x3a03, 0xd8, 0, 0}, {0x3a08, 0x01, 0, 0}, {0x3a09, 0x27, 0, 0},
	{0x3a0a, 0x00, 0, 0}, {0x3a0b, 0xf6, 0, 0}, {0x3a0e, 0x03, 0, 0},
	{0x3a0d, 0x04, 0, 0}, {0x3a14, 0x03, 0, 0}, {0x3a15, 0xd8, 0, 0},
	{0x4001, 0x02, 0, 0}, {0x4004, 0x06, 0, 0}, {0x4713, 0x03, 0, 0},
	{0x4407, 0x04, 0, 0}, {0x460b, 0x35, 0, 0}, {0x460c, 0x22, 0, 0},
	{0x3824, 0x02, 0, 0}, {0x5001, 0x83, 0, 70},
	{0x4202, 0x00, 0, 0},	/* stream on the sensor */
};

/* OV5640 AF MCU Firmware*/
static struct reg_value af_firmware[] = {
	{0x3000, 0x20, 0, 0}, {0x8000, 0x02, 0, 0}, {0x8001, 0x0d, 0, 0},
	{0x8002, 0xf3, 0, 0}, {0x8003, 0x02, 0, 0}, {0x8004, 0x0a, 0, 0},
	{0x8005, 0x5f, 0, 0}, {0x8006, 0xc2, 0, 0}, {0x8007, 0x01, 0, 0},
	{0x8008, 0x22, 0, 0}, {0x8009, 0x22, 0, 0}, {0x800a, 0x00, 0, 0},
	{0x800b, 0x02, 0, 0}, {0x800c, 0x0f, 0, 0}, {0x800d, 0x31, 0, 0},
	{0x800e, 0x30, 0, 0}, {0x800f, 0x01, 0, 0}, {0x8010, 0x03, 0, 0},
	{0x8011, 0x02, 0, 0}, {0x8012, 0x03, 0, 0}, {0x8013, 0x09, 0, 0},
	{0x8014, 0x30, 0, 0}, {0x8015, 0x02, 0, 0}, {0x8016, 0x03, 0, 0},
	{0x8017, 0x02, 0, 0}, {0x8018, 0x03, 0, 0}, {0x8019, 0x09, 0, 0},
	{0x801a, 0x90, 0, 0}, {0x801b, 0x51, 0, 0}, {0x801c, 0xa5, 0, 0},
	{0x801d, 0xe0, 0, 0}, {0x801e, 0x78, 0, 0}, {0x801f, 0xbb, 0, 0},
	{0x8020, 0xf6, 0, 0}, {0x8021, 0xa3, 0, 0}, {0x8022, 0xe0, 0, 0},
	{0x8023, 0x08, 0, 0}, {0x8024, 0xf6, 0, 0}, {0x8025, 0xa3, 0, 0},
	{0x8026, 0xe0, 0, 0}, {0x8027, 0x08, 0, 0}, {0x8028, 0xf6, 0, 0},
	{0x8029, 0xe5, 0, 0}, {0x802a, 0x1f, 0, 0}, {0x802b, 0x70, 0, 0},
	{0x802c, 0x45, 0, 0}, {0x802d, 0x75, 0, 0}, {0x802e, 0x1e, 0, 0},
	{0x802f, 0x20, 0, 0}, {0x8030, 0xd2, 0, 0}, {0x8031, 0x34, 0, 0},
	{0x8032, 0x12, 0, 0}, {0x8033, 0x0c, 0, 0}, {0x8034, 0x0c, 0, 0},
	{0x8035, 0x78, 0, 0}, {0x8036, 0x9c, 0, 0}, {0x8037, 0x12, 0, 0},
	{0x8038, 0x0b, 0, 0}, {0x8039, 0xd2, 0, 0}, {0x803a, 0x78, 0, 0},
	{0x803b, 0xa8, 0, 0}, {0x803c, 0xa6, 0, 0}, {0x803d, 0x14, 0, 0},
	{0x803e, 0x08, 0, 0}, {0x803f, 0xa6, 0, 0}, {0x8040, 0x15, 0, 0},
	{0x8041, 0x78, 0, 0}, {0x8042, 0xb3, 0, 0}, {0x8043, 0xa6, 0, 0},
	{0x8044, 0x09, 0, 0}, {0x8045, 0x18, 0, 0}, {0x8046, 0x76, 0, 0},
	{0x8047, 0x01, 0, 0}, {0x8048, 0x78, 0, 0}, {0x8049, 0x4c, 0, 0},
	{0x804a, 0xa6, 0, 0}, {0x804b, 0x0a, 0, 0}, {0x804c, 0x08, 0, 0},
	{0x804d, 0xa6, 0, 0}, {0x804e, 0x0b, 0, 0}, {0x804f, 0x78, 0, 0},
	{0x8050, 0x6c, 0, 0}, {0x8051, 0xa6, 0, 0}, {0x8052, 0x14, 0, 0},
	{0x8053, 0x08, 0, 0}, {0x8054, 0xa6, 0, 0}, {0x8055, 0x15, 0, 0},
	{0x8056, 0x78, 0, 0}, {0x8057, 0xb3, 0, 0}, {0x8058, 0xe6, 0, 0},
	{0x8059, 0x78, 0, 0}, {0x805a, 0x8c, 0, 0}, {0x805b, 0xf6, 0, 0},
	{0x805c, 0x75, 0, 0}, {0x805d, 0x1f, 0, 0}, {0x805e, 0x01, 0, 0},
	{0x805f, 0x78, 0, 0}, {0x8060, 0xbb, 0, 0}, {0x8061, 0xe6, 0, 0},
	{0x8062, 0x78, 0, 0}, {0x8063, 0xb8, 0, 0}, {0x8064, 0xf6, 0, 0},
	{0x8065, 0x78, 0, 0}, {0x8066, 0xbc, 0, 0}, {0x8067, 0xe6, 0, 0},
	{0x8068, 0x78, 0, 0}, {0x8069, 0xb9, 0, 0}, {0x806a, 0xf6, 0, 0},
	{0x806b, 0x78, 0, 0}, {0x806c, 0xbd, 0, 0}, {0x806d, 0xe6, 0, 0},
	{0x806e, 0x78, 0, 0}, {0x806f, 0xba, 0, 0}, {0x8070, 0xf6, 0, 0},
	{0x8071, 0x22, 0, 0}, {0x8072, 0x79, 0, 0}, {0x8073, 0xb8, 0, 0},
	{0x8074, 0xe7, 0, 0}, {0x8075, 0xd3, 0, 0}, {0x8076, 0x78, 0, 0},
	{0x8077, 0xbb, 0, 0}, {0x8078, 0x96, 0, 0}, {0x8079, 0x40, 0, 0},
	{0x807a, 0x05, 0, 0}, {0x807b, 0xe7, 0, 0}, {0x807c, 0x96, 0, 0},
	{0x807d, 0xff, 0, 0}, {0x807e, 0x80, 0, 0}, {0x807f, 0x08, 0, 0},
	{0x8080, 0xc3, 0, 0}, {0x8081, 0x79, 0, 0}, {0x8082, 0xbb, 0, 0},
	{0x8083, 0xe7, 0, 0}, {0x8084, 0x78, 0, 0}, {0x8085, 0xb8, 0, 0},
	{0x8086, 0x96, 0, 0}, {0x8087, 0xff, 0, 0}, {0x8088, 0x78, 0, 0},
	{0x8089, 0xa6, 0, 0}, {0x808a, 0x76, 0, 0}, {0x808b, 0x00, 0, 0},
	{0x808c, 0x08, 0, 0}, {0x808d, 0xa6, 0, 0}, {0x808e, 0x07, 0, 0},
	{0x808f, 0x79, 0, 0}, {0x8090, 0xb9, 0, 0}, {0x8091, 0xe7, 0, 0},
	{0x8092, 0xd3, 0, 0}, {0x8093, 0x78, 0, 0}, {0x8094, 0xbc, 0, 0},
	{0x8095, 0x96, 0, 0}, {0x8096, 0x40, 0, 0}, {0x8097, 0x05, 0, 0},
	{0x8098, 0xe7, 0, 0}, {0x8099, 0x96, 0, 0}, {0x809a, 0xff, 0, 0},
	{0x809b, 0x80, 0, 0}, {0x809c, 0x08, 0, 0}, {0x809d, 0xc3, 0, 0},
	{0x809e, 0x79, 0, 0}, {0x809f, 0xbc, 0, 0}, {0x80a0, 0xe7, 0, 0},
	{0x80a1, 0x78, 0, 0}, {0x80a2, 0xb9, 0, 0}, {0x80a3, 0x96, 0, 0},
	{0x80a4, 0xff, 0, 0}, {0x80a5, 0x12, 0, 0}, {0x80a6, 0x0c, 0, 0},
	{0x80a7, 0x13, 0, 0}, {0x80a8, 0x79, 0, 0}, {0x80a9, 0xba, 0, 0},
	{0x80aa, 0xe7, 0, 0}, {0x80ab, 0xd3, 0, 0}, {0x80ac, 0x78, 0, 0},
	{0x80ad, 0xbd, 0, 0}, {0x80ae, 0x96, 0, 0}, {0x80af, 0x40, 0, 0},
	{0x80b0, 0x05, 0, 0}, {0x80b1, 0xe7, 0, 0}, {0x80b2, 0x96, 0, 0},
	{0x80b3, 0xff, 0, 0}, {0x80b4, 0x80, 0, 0}, {0x80b5, 0x08, 0, 0},
	{0x80b6, 0xc3, 0, 0}, {0x80b7, 0x79, 0, 0}, {0x80b8, 0xbd, 0, 0},
	{0x80b9, 0xe7, 0, 0}, {0x80ba, 0x78, 0, 0}, {0x80bb, 0xba, 0, 0},
	{0x80bc, 0x96, 0, 0}, {0x80bd, 0xff, 0, 0}, {0x80be, 0x12, 0, 0},
	{0x80bf, 0x0c, 0, 0}, {0x80c0, 0x13, 0, 0}, {0x80c1, 0x78, 0, 0},
	{0x80c2, 0xb2, 0, 0}, {0x80c3, 0xe6, 0, 0}, {0x80c4, 0x25, 0, 0},
	{0x80c5, 0xe0, 0, 0}, {0x80c6, 0x24, 0, 0}, {0x80c7, 0x4c, 0, 0},
	{0x80c8, 0xf8, 0, 0}, {0x80c9, 0xa6, 0, 0}, {0x80ca, 0x0a, 0, 0},
	{0x80cb, 0x08, 0, 0}, {0x80cc, 0xa6, 0, 0}, {0x80cd, 0x0b, 0, 0},
	{0x80ce, 0x78, 0, 0}, {0x80cf, 0xb2, 0, 0}, {0x80d0, 0xe6, 0, 0},
	{0x80d1, 0x25, 0, 0}, {0x80d2, 0xe0, 0, 0}, {0x80d3, 0x24, 0, 0},
	{0x80d4, 0x6c, 0, 0}, {0x80d5, 0xf8, 0, 0}, {0x80d6, 0xa6, 0, 0},
	{0x80d7, 0x14, 0, 0}, {0x80d8, 0x08, 0, 0}, {0x80d9, 0xa6, 0, 0},
	{0x80da, 0x15, 0, 0}, {0x80db, 0x78, 0, 0}, {0x80dc, 0xb2, 0, 0},
	{0x80dd, 0xe6, 0, 0}, {0x80de, 0x24, 0, 0}, {0x80df, 0x8c, 0, 0},
	{0x80e0, 0xf8, 0, 0}, {0x80e1, 0xa6, 0, 0}, {0x80e2, 0x09, 0, 0},
	{0x80e3, 0x78, 0, 0}, {0x80e4, 0xb2, 0, 0}, {0x80e5, 0xe6, 0, 0},
	{0x80e6, 0x24, 0, 0}, {0x80e7, 0x01, 0, 0}, {0x80e8, 0xff, 0, 0},
	{0x80e9, 0xe4, 0, 0}, {0x80ea, 0x33, 0, 0}, {0x80eb, 0xfe, 0, 0},
	{0x80ec, 0xd3, 0, 0}, {0x80ed, 0xef, 0, 0}, {0x80ee, 0x94, 0, 0},
	{0x80ef, 0x0f, 0, 0}, {0x80f0, 0xee, 0, 0}, {0x80f1, 0x64, 0, 0},
	{0x80f2, 0x80, 0, 0}, {0x80f3, 0x94, 0, 0}, {0x80f4, 0x80, 0, 0},
	{0x80f5, 0x40, 0, 0}, {0x80f6, 0x04, 0, 0}, {0x80f7, 0x7f, 0, 0},
	{0x80f8, 0x00, 0, 0}, {0x80f9, 0x80, 0, 0}, {0x80fa, 0x05, 0, 0},
	{0x80fb, 0x78, 0, 0}, {0x80fc, 0xb2, 0, 0}, {0x80fd, 0xe6, 0, 0},
	{0x80fe, 0x04, 0, 0}, {0x80ff, 0xff, 0, 0}, {0x8100, 0x78, 0, 0},
	{0x8101, 0xb2, 0, 0}, {0x8102, 0xa6, 0, 0}, {0x8103, 0x07, 0, 0},
	{0x8104, 0xe5, 0, 0}, {0x8105, 0x1f, 0, 0}, {0x8106, 0xb4, 0, 0},
	{0x8107, 0x01, 0, 0}, {0x8108, 0x0a, 0, 0}, {0x8109, 0xe6, 0, 0},
	{0x810a, 0x60, 0, 0}, {0x810b, 0x03, 0, 0}, {0x810c, 0x02, 0, 0},
	{0x810d, 0x03, 0, 0}, {0x810e, 0x09, 0, 0}, {0x810f, 0x75, 0, 0},
	{0x8110, 0x1f, 0, 0}, {0x8111, 0x02, 0, 0}, {0x8112, 0x22, 0, 0},
	{0x8113, 0x12, 0, 0}, {0x8114, 0x0c, 0, 0}, {0x8115, 0x0c, 0, 0},
	{0x8116, 0x78, 0, 0}, {0x8117, 0x9e, 0, 0}, {0x8118, 0x12, 0, 0},
	{0x8119, 0x0b, 0, 0}, {0x811a, 0xd2, 0, 0}, {0x811b, 0x12, 0, 0},
	{0x811c, 0x0c, 0, 0}, {0x811d, 0x0c, 0, 0}, {0x811e, 0x78, 0, 0},
	{0x811f, 0xa0, 0, 0}, {0x8120, 0x12, 0, 0}, {0x8121, 0x0b, 0, 0},
	{0x8122, 0xff, 0, 0}, {0x8123, 0x78, 0, 0}, {0x8124, 0xaa, 0, 0},
	{0x8125, 0x12, 0, 0}, {0x8126, 0x0b, 0, 0}, {0x8127, 0xff, 0, 0},
	{0x8128, 0xff, 0, 0}, {0x8129, 0x78, 0, 0}, {0x812a, 0xac, 0, 0},
	{0x812b, 0xa6, 0, 0}, {0x812c, 0x06, 0, 0}, {0x812d, 0x08, 0, 0},
	{0x812e, 0xa6, 0, 0}, {0x812f, 0x07, 0, 0}, {0x8130, 0x78, 0, 0},
	{0x8131, 0x8c, 0, 0}, {0x8132, 0xe6, 0, 0}, {0x8133, 0x78, 0, 0},
	{0x8134, 0xb4, 0, 0}, {0x8135, 0xf6, 0, 0}, {0x8136, 0x78, 0, 0},
	{0x8137, 0x8c, 0, 0}, {0x8138, 0xe6, 0, 0}, {0x8139, 0x78, 0, 0},
	{0x813a, 0xb5, 0, 0}, {0x813b, 0xf6, 0, 0}, {0x813c, 0x7f, 0, 0},
	{0x813d, 0x01, 0, 0}, {0x813e, 0xef, 0, 0}, {0x813f, 0x25, 0, 0},
	{0x8140, 0xe0, 0, 0}, {0x8141, 0x24, 0, 0}, {0x8142, 0x4d, 0, 0},
	{0x8143, 0x78, 0, 0}, {0x8144, 0x9f, 0, 0}, {0x8145, 0x12, 0, 0},
	{0x8146, 0x0b, 0, 0}, {0x8147, 0xc9, 0, 0}, {0x8148, 0x50, 0, 0},
	{0x8149, 0x0a, 0, 0}, {0x814a, 0x12, 0, 0}, {0x814b, 0x0b, 0, 0},
	{0x814c, 0xab, 0, 0}, {0x814d, 0x78, 0, 0}, {0x814e, 0x9e, 0, 0},
	{0x814f, 0xa6, 0, 0}, {0x8150, 0x04, 0, 0}, {0x8151, 0x08, 0, 0},
	{0x8152, 0xa6, 0, 0}, {0x8153, 0x05, 0, 0}, {0x8154, 0xef, 0, 0},
	{0x8155, 0x25, 0, 0}, {0x8156, 0xe0, 0, 0}, {0x8157, 0x24, 0, 0},
	{0x8158, 0x6d, 0, 0}, {0x8159, 0x78, 0, 0}, {0x815a, 0xab, 0, 0},
	{0x815b, 0x12, 0, 0}, {0x815c, 0x0b, 0, 0}, {0x815d, 0xc9, 0, 0},
	{0x815e, 0x50, 0, 0}, {0x815f, 0x0f, 0, 0}, {0x8160, 0xef, 0, 0},
	{0x8161, 0x25, 0, 0}, {0x8162, 0xe0, 0, 0}, {0x8163, 0x24, 0, 0},
	{0x8164, 0x6c, 0, 0}, {0x8165, 0x12, 0, 0}, {0x8166, 0x0b, 0, 0},
	{0x8167, 0xb0, 0, 0}, {0x8168, 0x78, 0, 0}, {0x8169, 0xaa, 0, 0},
	{0x816a, 0xa6, 0, 0}, {0x816b, 0x04, 0, 0}, {0x816c, 0x08, 0, 0},
	{0x816d, 0xa6, 0, 0}, {0x816e, 0x05, 0, 0}, {0x816f, 0x74, 0, 0},
	{0x8170, 0x8c, 0, 0}, {0x8171, 0x2f, 0, 0}, {0x8172, 0xf9, 0, 0},
	{0x8173, 0x78, 0, 0}, {0x8174, 0xb4, 0, 0}, {0x8175, 0xe6, 0, 0},
	{0x8176, 0xc3, 0, 0}, {0x8177, 0x97, 0, 0}, {0x8178, 0x50, 0, 0},
	{0x8179, 0x08, 0, 0}, {0x817a, 0x74, 0, 0}, {0x817b, 0x8c, 0, 0},
	{0x817c, 0x2f, 0, 0}, {0x817d, 0xf8, 0, 0}, {0x817e, 0xe6, 0, 0},
	{0x817f, 0x78, 0, 0}, {0x8180, 0xb4, 0, 0}, {0x8181, 0xf6, 0, 0},
	{0x8182, 0xef, 0, 0}, {0x8183, 0x25, 0, 0}, {0x8184, 0xe0, 0, 0},
	{0x8185, 0x24, 0, 0}, {0x8186, 0x4d, 0, 0}, {0x8187, 0xf9, 0, 0},
	{0x8188, 0xd3, 0, 0}, {0x8189, 0x78, 0, 0}, {0x818a, 0xa1, 0, 0},
	{0x818b, 0x12, 0, 0}, {0x818c, 0x0b, 0, 0}, {0x818d, 0xcb, 0, 0},
	{0x818e, 0x40, 0, 0}, {0x818f, 0x0a, 0, 0}, {0x8190, 0x12, 0, 0},
	{0x8191, 0x0b, 0, 0}, {0x8192, 0xab, 0, 0}, {0x8193, 0x78, 0, 0},
	{0x8194, 0xa0, 0, 0}, {0x8195, 0xa6, 0, 0}, {0x8196, 0x04, 0, 0},
	{0x8197, 0x08, 0, 0}, {0x8198, 0xa6, 0, 0}, {0x8199, 0x05, 0, 0},
	{0x819a, 0xef, 0, 0}, {0x819b, 0x25, 0, 0}, {0x819c, 0xe0, 0, 0},
	{0x819d, 0x24, 0, 0}, {0x819e, 0x6d, 0, 0}, {0x819f, 0xf9, 0, 0},
	{0x81a0, 0xd3, 0, 0}, {0x81a1, 0x78, 0, 0}, {0x81a2, 0xad, 0, 0},
	{0x81a3, 0x12, 0, 0}, {0x81a4, 0x0b, 0, 0}, {0x81a5, 0xcb, 0, 0},
	{0x81a6, 0x40, 0, 0}, {0x81a7, 0x0f, 0, 0}, {0x81a8, 0xef, 0, 0},
	{0x81a9, 0x25, 0, 0}, {0x81aa, 0xe0, 0, 0}, {0x81ab, 0x24, 0, 0},
	{0x81ac, 0x6c, 0, 0}, {0x81ad, 0x12, 0, 0}, {0x81ae, 0x0b, 0, 0},
	{0x81af, 0xb0, 0, 0}, {0x81b0, 0x78, 0, 0}, {0x81b1, 0xac, 0, 0},
	{0x81b2, 0xa6, 0, 0}, {0x81b3, 0x04, 0, 0}, {0x81b4, 0x08, 0, 0},
	{0x81b5, 0xa6, 0, 0}, {0x81b6, 0x05, 0, 0}, {0x81b7, 0x74, 0, 0},
	{0x81b8, 0x8c, 0, 0}, {0x81b9, 0x2f, 0, 0}, {0x81ba, 0xf9, 0, 0},
	{0x81bb, 0x78, 0, 0}, {0x81bc, 0xb5, 0, 0}, {0x81bd, 0xe6, 0, 0},
	{0x81be, 0xd3, 0, 0}, {0x81bf, 0x97, 0, 0}, {0x81c0, 0x40, 0, 0},
	{0x81c1, 0x08, 0, 0}, {0x81c2, 0x74, 0, 0}, {0x81c3, 0x8c, 0, 0},
	{0x81c4, 0x2f, 0, 0}, {0x81c5, 0xf8, 0, 0}, {0x81c6, 0xe6, 0, 0},
	{0x81c7, 0x78, 0, 0}, {0x81c8, 0xb5, 0, 0}, {0x81c9, 0xf6, 0, 0},
	{0x81ca, 0x0f, 0, 0}, {0x81cb, 0xef, 0, 0}, {0x81cc, 0x64, 0, 0},
	{0x81cd, 0x10, 0, 0}, {0x81ce, 0x60, 0, 0}, {0x81cf, 0x03, 0, 0},
	{0x81d0, 0x02, 0, 0}, {0x81d1, 0x01, 0, 0}, {0x81d2, 0x3e, 0, 0},
	{0x81d3, 0xc3, 0, 0}, {0x81d4, 0x79, 0, 0}, {0x81d5, 0x9f, 0, 0},
	{0x81d6, 0x78, 0, 0}, {0x81d7, 0xa1, 0, 0}, {0x81d8, 0x12, 0, 0},
	{0x81d9, 0x0b, 0, 0}, {0x81da, 0xf7, 0, 0}, {0x81db, 0x78, 0, 0},
	{0x81dc, 0xa2, 0, 0}, {0x81dd, 0xf6, 0, 0}, {0x81de, 0x08, 0, 0},
	{0x81df, 0xa6, 0, 0}, {0x81e0, 0x07, 0, 0}, {0x81e1, 0xc3, 0, 0},
	{0x81e2, 0x79, 0, 0}, {0x81e3, 0xab, 0, 0}, {0x81e4, 0x78, 0, 0},
	{0x81e5, 0xad, 0, 0}, {0x81e6, 0x12, 0, 0}, {0x81e7, 0x0b, 0, 0},
	{0x81e8, 0xf7, 0, 0}, {0x81e9, 0x78, 0, 0}, {0x81ea, 0xae, 0, 0},
	{0x81eb, 0xf6, 0, 0}, {0x81ec, 0x08, 0, 0}, {0x81ed, 0xa6, 0, 0},
	{0x81ee, 0x07, 0, 0}, {0x81ef, 0xc3, 0, 0}, {0x81f0, 0x79, 0, 0},
	{0x81f1, 0xb4, 0, 0}, {0x81f2, 0xe7, 0, 0}, {0x81f3, 0x78, 0, 0},
	{0x81f4, 0xb5, 0, 0}, {0x81f5, 0x96, 0, 0}, {0x81f6, 0x08, 0, 0},
	{0x81f7, 0xf6, 0, 0}, {0x81f8, 0xd3, 0, 0}, {0x81f9, 0x79, 0, 0},
	{0x81fa, 0x9f, 0, 0}, {0x81fb, 0xe7, 0, 0}, {0x81fc, 0x78, 0, 0},
	{0x81fd, 0x9d, 0, 0}, {0x81fe, 0x96, 0, 0}, {0x81ff, 0x19, 0, 0},
	{0x8200, 0xe7, 0, 0}, {0x8201, 0x18, 0, 0}, {0x8202, 0x96, 0, 0},
	{0x8203, 0x40, 0, 0}, {0x8204, 0x05, 0, 0}, {0x8205, 0x09, 0, 0},
	{0x8206, 0xe7, 0, 0}, {0x8207, 0x08, 0, 0}, {0x8208, 0x80, 0, 0},
	{0x8209, 0x06, 0, 0}, {0x820a, 0xc3, 0, 0}, {0x820b, 0x79, 0, 0},
	{0x820c, 0x9d, 0, 0}, {0x820d, 0xe7, 0, 0}, {0x820e, 0x78, 0, 0},
	{0x820f, 0x9f, 0, 0}, {0x8210, 0x12, 0, 0}, {0x8211, 0x0b, 0, 0},
	{0x8212, 0xf8, 0, 0}, {0x8213, 0xfe, 0, 0}, {0x8214, 0x78, 0, 0},
	{0x8215, 0xa4, 0, 0}, {0x8216, 0xa6, 0, 0}, {0x8217, 0x06, 0, 0},
	{0x8218, 0x08, 0, 0}, {0x8219, 0xa6, 0, 0}, {0x821a, 0x07, 0, 0},
	{0x821b, 0xd3, 0, 0}, {0x821c, 0x79, 0, 0}, {0x821d, 0xab, 0, 0},
	{0x821e, 0xe7, 0, 0}, {0x821f, 0x78, 0, 0}, {0x8220, 0xa9, 0, 0},
	{0x8221, 0x96, 0, 0}, {0x8222, 0x19, 0, 0}, {0x8223, 0xe7, 0, 0},
	{0x8224, 0x18, 0, 0}, {0x8225, 0x96, 0, 0}, {0x8226, 0x40, 0, 0},
	{0x8227, 0x05, 0, 0}, {0x8228, 0x09, 0, 0}, {0x8229, 0xe7, 0, 0},
	{0x822a, 0x08, 0, 0}, {0x822b, 0x80, 0, 0}, {0x822c, 0x06, 0, 0},
	{0x822d, 0xc3, 0, 0}, {0x822e, 0x79, 0, 0}, {0x822f, 0xa9, 0, 0},
	{0x8230, 0xe7, 0, 0}, {0x8231, 0x78, 0, 0}, {0x8232, 0xab, 0, 0},
	{0x8233, 0x12, 0, 0}, {0x8234, 0x0b, 0, 0}, {0x8235, 0xf8, 0, 0},
	{0x8236, 0xfe, 0, 0}, {0x8237, 0x78, 0, 0}, {0x8238, 0xb0, 0, 0},
	{0x8239, 0xa6, 0, 0}, {0x823a, 0x06, 0, 0}, {0x823b, 0x08, 0, 0},
	{0x823c, 0xa6, 0, 0}, {0x823d, 0x07, 0, 0}, {0x823e, 0x79, 0, 0},
	{0x823f, 0xb4, 0, 0}, {0x8240, 0xe7, 0, 0}, {0x8241, 0xd3, 0, 0},
	{0x8242, 0x78, 0, 0}, {0x8243, 0xb3, 0, 0}, {0x8244, 0x96, 0, 0},
	{0x8245, 0x40, 0, 0}, {0x8246, 0x05, 0, 0}, {0x8247, 0xe7, 0, 0},
	{0x8248, 0x96, 0, 0}, {0x8249, 0xff, 0, 0}, {0x824a, 0x80, 0, 0},
	{0x824b, 0x08, 0, 0}, {0x824c, 0xc3, 0, 0}, {0x824d, 0x79, 0, 0},
	{0x824e, 0xb3, 0, 0}, {0x824f, 0xe7, 0, 0}, {0x8250, 0x78, 0, 0},
	{0x8251, 0xb4, 0, 0}, {0x8252, 0x96, 0, 0}, {0x8253, 0xff, 0, 0},
	{0x8254, 0x78, 0, 0}, {0x8255, 0xb7, 0, 0}, {0x8256, 0xa6, 0, 0},
	{0x8257, 0x07, 0, 0}, {0x8258, 0xe5, 0, 0}, {0x8259, 0x1f, 0, 0},
	{0x825a, 0x64, 0, 0}, {0x825b, 0x02, 0, 0}, {0x825c, 0x60, 0, 0},
	{0x825d, 0x03, 0, 0}, {0x825e, 0x02, 0, 0}, {0x825f, 0x02, 0, 0},
	{0x8260, 0xef, 0, 0}, {0x8261, 0x90, 0, 0}, {0x8262, 0x30, 0, 0},
	{0x8263, 0x24, 0, 0}, {0x8264, 0x74, 0, 0}, {0x8265, 0x0f, 0, 0},
	{0x8266, 0xf0, 0, 0}, {0x8267, 0x90, 0, 0}, {0x8268, 0x0e, 0, 0},
	{0x8269, 0x8a, 0, 0}, {0x826a, 0xe4, 0, 0}, {0x826b, 0x93, 0, 0},
	{0x826c, 0xff, 0, 0}, {0x826d, 0x18, 0, 0}, {0x826e, 0xe6, 0, 0},
	{0x826f, 0xc3, 0, 0}, {0x8270, 0x9f, 0, 0}, {0x8271, 0x40, 0, 0},
	{0x8272, 0x03, 0, 0}, {0x8273, 0x02, 0, 0}, {0x8274, 0x03, 0, 0},
	{0x8275, 0x09, 0, 0}, {0x8276, 0x90, 0, 0}, {0x8277, 0x30, 0, 0},
	{0x8278, 0x24, 0, 0}, {0x8279, 0x74, 0, 0}, {0x827a, 0x0e, 0, 0},
	{0x827b, 0xf0, 0, 0}, {0x827c, 0x78, 0, 0}, {0x827d, 0xa2, 0, 0},
	{0x827e, 0x12, 0, 0}, {0x827f, 0x0b, 0, 0}, {0x8280, 0xd9, 0, 0},
	{0x8281, 0x12, 0, 0}, {0x8282, 0x0b, 0, 0}, {0x8283, 0xa2, 0, 0},
	{0x8284, 0x90, 0, 0}, {0x8285, 0x0e, 0, 0}, {0x8286, 0x87, 0, 0},
	{0x8287, 0x12, 0, 0}, {0x8288, 0x0b, 0, 0}, {0x8289, 0xb7, 0, 0},
	{0x828a, 0x78, 0, 0}, {0x828b, 0x9e, 0, 0}, {0x828c, 0x12, 0, 0},
	{0x828d, 0x0b, 0, 0}, {0x828e, 0xe8, 0, 0}, {0x828f, 0x7b, 0, 0},
	{0x8290, 0x04, 0, 0}, {0x8291, 0x12, 0, 0}, {0x8292, 0x0b, 0, 0},
	{0x8293, 0x90, 0, 0}, {0x8294, 0xc3, 0, 0}, {0x8295, 0x12, 0, 0},
	{0x8296, 0x07, 0, 0}, {0x8297, 0x0e, 0, 0}, {0x8298, 0x50, 0, 0},
	{0x8299, 0x6f, 0, 0}, {0x829a, 0x90, 0, 0}, {0x829b, 0x0e, 0, 0},
	{0x829c, 0x8b, 0, 0}, {0x829d, 0xe4, 0, 0}, {0x829e, 0x93, 0, 0},
	{0x829f, 0xff, 0, 0}, {0x82a0, 0x78, 0, 0}, {0x82a1, 0xb7, 0, 0},
	{0x82a2, 0xe6, 0, 0}, {0x82a3, 0x9f, 0, 0}, {0x82a4, 0x40, 0, 0},
	{0x82a5, 0x07, 0, 0}, {0x82a6, 0x90, 0, 0}, {0x82a7, 0x30, 0, 0},
	{0x82a8, 0x24, 0, 0}, {0x82a9, 0x74, 0, 0}, {0x82aa, 0x0a, 0, 0},
	{0x82ab, 0x80, 0, 0}, {0x82ac, 0x16, 0, 0}, {0x82ad, 0x90, 0, 0},
	{0x82ae, 0x0e, 0, 0}, {0x82af, 0x89, 0, 0}, {0x82b0, 0xe4, 0, 0},
	{0x82b1, 0x93, 0, 0}, {0x82b2, 0xff, 0, 0}, {0x82b3, 0xd3, 0, 0},
	{0x82b4, 0x78, 0, 0}, {0x82b5, 0xa7, 0, 0}, {0x82b6, 0xe6, 0, 0},
	{0x82b7, 0x9f, 0, 0}, {0x82b8, 0x18, 0, 0}, {0x82b9, 0xe6, 0, 0},
	{0x82ba, 0x94, 0, 0}, {0x82bb, 0x00, 0, 0}, {0x82bc, 0x40, 0, 0},
	{0x82bd, 0x09, 0, 0}, {0x82be, 0x90, 0, 0}, {0x82bf, 0x30, 0, 0},
	{0x82c0, 0x24, 0, 0}, {0x82c1, 0x74, 0, 0}, {0x82c2, 0x0b, 0, 0},
	{0x82c3, 0xf0, 0, 0}, {0x82c4, 0x75, 0, 0}, {0x82c5, 0x1f, 0, 0},
	{0x82c6, 0x05, 0, 0}, {0x82c7, 0x78, 0, 0}, {0x82c8, 0xae, 0, 0},
	{0x82c9, 0x12, 0, 0}, {0x82ca, 0x0b, 0, 0}, {0x82cb, 0xd9, 0, 0},
	{0x82cc, 0x12, 0, 0}, {0x82cd, 0x0b, 0, 0}, {0x82ce, 0xa2, 0, 0},
	{0x82cf, 0x90, 0, 0}, {0x82d0, 0x0e, 0, 0}, {0x82d1, 0x88, 0, 0},
	{0x82d2, 0x12, 0, 0}, {0x82d3, 0x0b, 0, 0}, {0x82d4, 0xb7, 0, 0},
	{0x82d5, 0x78, 0, 0}, {0x82d6, 0xa8, 0, 0}, {0x82d7, 0x12, 0, 0},
	{0x82d8, 0x0b, 0, 0}, {0x82d9, 0xe8, 0, 0}, {0x82da, 0x7b, 0, 0},
	{0x82db, 0x40, 0, 0}, {0x82dc, 0x12, 0, 0}, {0x82dd, 0x0b, 0, 0},
	{0x82de, 0x90, 0, 0}, {0x82df, 0xd3, 0, 0}, {0x82e0, 0x12, 0, 0},
	{0x82e1, 0x07, 0, 0}, {0x82e2, 0x0e, 0, 0}, {0x82e3, 0x40, 0, 0},
	{0x82e4, 0x24, 0, 0}, {0x82e5, 0x90, 0, 0}, {0x82e6, 0x30, 0, 0},
	{0x82e7, 0x24, 0, 0}, {0x82e8, 0x74, 0, 0}, {0x82e9, 0x0c, 0, 0},
	{0x82ea, 0xf0, 0, 0}, {0x82eb, 0x75, 0, 0}, {0x82ec, 0x1f, 0, 0},
	{0x82ed, 0x05, 0, 0}, {0x82ee, 0x22, 0, 0}, {0x82ef, 0x90, 0, 0},
	{0x82f0, 0x30, 0, 0}, {0x82f1, 0x24, 0, 0}, {0x82f2, 0x74, 0, 0},
	{0x82f3, 0x01, 0, 0}, {0x82f4, 0xf0, 0, 0}, {0x82f5, 0xe5, 0, 0},
	{0x82f6, 0x1f, 0, 0}, {0x82f7, 0xb4, 0, 0}, {0x82f8, 0x05, 0, 0},
	{0x82f9, 0x0f, 0, 0}, {0x82fa, 0xd2, 0, 0}, {0x82fb, 0x01, 0, 0},
	{0x82fc, 0xc2, 0, 0}, {0x82fd, 0x02, 0, 0}, {0x82fe, 0xe4, 0, 0},
	{0x82ff, 0xf5, 0, 0}, {0x8300, 0x1f, 0, 0}, {0x8301, 0xf5, 0, 0},
	{0x8302, 0x1e, 0, 0}, {0x8303, 0xd2, 0, 0}, {0x8304, 0x34, 0, 0},
	{0x8305, 0xd2, 0, 0}, {0x8306, 0x32, 0, 0}, {0x8307, 0xd2, 0, 0},
	{0x8308, 0x35, 0, 0}, {0x8309, 0x22, 0, 0}, {0x830a, 0xe5, 0, 0},
	{0x830b, 0x1f, 0, 0}, {0x830c, 0x60, 0, 0}, {0x830d, 0x03, 0, 0},
	{0x830e, 0x02, 0, 0}, {0x830f, 0x03, 0, 0}, {0x8310, 0x93, 0, 0},
	{0x8311, 0xf5, 0, 0}, {0x8312, 0x1e, 0, 0}, {0x8313, 0xd2, 0, 0},
	{0x8314, 0x34, 0, 0}, {0x8315, 0x75, 0, 0}, {0x8316, 0x34, 0, 0},
	{0x8317, 0xff, 0, 0}, {0x8318, 0x75, 0, 0}, {0x8319, 0x35, 0, 0},
	{0x831a, 0x0e, 0, 0}, {0x831b, 0x75, 0, 0}, {0x831c, 0x36, 0, 0},
	{0x831d, 0x55, 0, 0}, {0x831e, 0x75, 0, 0}, {0x831f, 0x37, 0, 0},
	{0x8320, 0x01, 0, 0}, {0x8321, 0x12, 0, 0}, {0x8322, 0x0d, 0, 0},
	{0x8323, 0x85, 0, 0}, {0x8324, 0xe4, 0, 0}, {0x8325, 0xff, 0, 0},
	{0x8326, 0xef, 0, 0}, {0x8327, 0x25, 0, 0}, {0x8328, 0xe0, 0, 0},
	{0x8329, 0x24, 0, 0}, {0x832a, 0x4c, 0, 0}, {0x832b, 0xf8, 0, 0},
	{0x832c, 0xe4, 0, 0}, {0x832d, 0xf6, 0, 0}, {0x832e, 0x08, 0, 0},
	{0x832f, 0xf6, 0, 0}, {0x8330, 0x0f, 0, 0}, {0x8331, 0xbf, 0, 0},
	{0x8332, 0x34, 0, 0}, {0x8333, 0xf2, 0, 0}, {0x8334, 0x90, 0, 0},
	{0x8335, 0x0e, 0, 0}, {0x8336, 0x8c, 0, 0}, {0x8337, 0xe4, 0, 0},
	{0x8338, 0x93, 0, 0}, {0x8339, 0xff, 0, 0}, {0x833a, 0xe5, 0, 0},
	{0x833b, 0x49, 0, 0}, {0x833c, 0xc3, 0, 0}, {0x833d, 0x9f, 0, 0},
	{0x833e, 0x50, 0, 0}, {0x833f, 0x04, 0, 0}, {0x8340, 0x7f, 0, 0},
	{0x8341, 0x05, 0, 0}, {0x8342, 0x80, 0, 0}, {0x8343, 0x02, 0, 0},
	{0x8344, 0x7f, 0, 0}, {0x8345, 0xfb, 0, 0}, {0x8346, 0x78, 0, 0},
	{0x8347, 0xbb, 0, 0}, {0x8348, 0xa6, 0, 0}, {0x8349, 0x07, 0, 0},
	{0x834a, 0x12, 0, 0}, {0x834b, 0x0e, 0, 0}, {0x834c, 0xbc, 0, 0},
	{0x834d, 0x40, 0, 0}, {0x834e, 0x04, 0, 0}, {0x834f, 0x7f, 0, 0},
	{0x8350, 0x03, 0, 0}, {0x8351, 0x80, 0, 0}, {0x8352, 0x02, 0, 0},
	{0x8353, 0x7f, 0, 0}, {0x8354, 0x30, 0, 0}, {0x8355, 0x78, 0, 0},
	{0x8356, 0xba, 0, 0}, {0x8357, 0xa6, 0, 0}, {0x8358, 0x07, 0, 0},
	{0x8359, 0xe6, 0, 0}, {0x835a, 0x18, 0, 0}, {0x835b, 0xf6, 0, 0},
	{0x835c, 0x08, 0, 0}, {0x835d, 0xe6, 0, 0}, {0x835e, 0x78, 0, 0},
	{0x835f, 0xb7, 0, 0}, {0x8360, 0xf6, 0, 0}, {0x8361, 0x78, 0, 0},
	{0x8362, 0xba, 0, 0}, {0x8363, 0xe6, 0, 0}, {0x8364, 0x78, 0, 0},
	{0x8365, 0xb8, 0, 0}, {0x8366, 0xf6, 0, 0}, {0x8367, 0x78, 0, 0},
	{0x8368, 0xbd, 0, 0}, {0x8369, 0x76, 0, 0}, {0x836a, 0x33, 0, 0},
	{0x836b, 0xe4, 0, 0}, {0x836c, 0x08, 0, 0}, {0x836d, 0xf6, 0, 0},
	{0x836e, 0x78, 0, 0}, {0x836f, 0xb6, 0, 0}, {0x8370, 0x76, 0, 0},
	{0x8371, 0x01, 0, 0}, {0x8372, 0x75, 0, 0}, {0x8373, 0x48, 0, 0},
	{0x8374, 0x02, 0, 0}, {0x8375, 0x78, 0, 0}, {0x8376, 0xb4, 0, 0},
	{0x8377, 0xf6, 0, 0}, {0x8378, 0x08, 0, 0}, {0x8379, 0xf6, 0, 0},
	{0x837a, 0x74, 0, 0}, {0x837b, 0xff, 0, 0}, {0x837c, 0x78, 0, 0},
	{0x837d, 0xbf, 0, 0}, {0x837e, 0xf6, 0, 0}, {0x837f, 0x08, 0, 0},
	{0x8380, 0xf6, 0, 0}, {0x8381, 0x75, 0, 0}, {0x8382, 0x1f, 0, 0},
	{0x8383, 0x01, 0, 0}, {0x8384, 0x78, 0, 0}, {0x8385, 0xba, 0, 0},
	{0x8386, 0xe6, 0, 0}, {0x8387, 0x75, 0, 0}, {0x8388, 0xf0, 0, 0},
	{0x8389, 0x05, 0, 0}, {0x838a, 0xa4, 0, 0}, {0x838b, 0xf5, 0, 0},
	{0x838c, 0x49, 0, 0}, {0x838d, 0x12, 0, 0}, {0x838e, 0x0a, 0, 0},
	{0x838f, 0xfd, 0, 0}, {0x8390, 0xc2, 0, 0}, {0x8391, 0x36, 0, 0},
	{0x8392, 0x22, 0, 0}, {0x8393, 0x78, 0, 0}, {0x8394, 0xb6, 0, 0},
	{0x8395, 0xe6, 0, 0}, {0x8396, 0xd3, 0, 0}, {0x8397, 0x94, 0, 0},
	{0x8398, 0x00, 0, 0}, {0x8399, 0x40, 0, 0}, {0x839a, 0x02, 0, 0},
	{0x839b, 0x16, 0, 0}, {0x839c, 0x22, 0, 0}, {0x839d, 0xe5, 0, 0},
	{0x839e, 0x1f, 0, 0}, {0x839f, 0xb4, 0, 0}, {0x83a0, 0x05, 0, 0},
	{0x83a1, 0x23, 0, 0}, {0x83a2, 0xe4, 0, 0}, {0x83a3, 0xf5, 0, 0},
	{0x83a4, 0x1f, 0, 0}, {0x83a5, 0xc2, 0, 0}, {0x83a6, 0x01, 0, 0},
	{0x83a7, 0x78, 0, 0}, {0x83a8, 0xb4, 0, 0}, {0x83a9, 0xe6, 0, 0},
	{0x83aa, 0xfe, 0, 0}, {0x83ab, 0x08, 0, 0}, {0x83ac, 0xe6, 0, 0},
	{0x83ad, 0xff, 0, 0}, {0x83ae, 0x78, 0, 0}, {0x83af, 0x4c, 0, 0},
	{0x83b0, 0xa6, 0, 0}, {0x83b1, 0x06, 0, 0}, {0x83b2, 0x08, 0, 0},
	{0x83b3, 0xa6, 0, 0}, {0x83b4, 0x07, 0, 0}, {0x83b5, 0xa2, 0, 0},
	{0x83b6, 0x36, 0, 0}, {0x83b7, 0xe4, 0, 0}, {0x83b8, 0x33, 0, 0},
	{0x83b9, 0xf5, 0, 0}, {0x83ba, 0x3c, 0, 0}, {0x83bb, 0x90, 0, 0},
	{0x83bc, 0x30, 0, 0}, {0x83bd, 0x28, 0, 0}, {0x83be, 0xf0, 0, 0},
	{0x83bf, 0x75, 0, 0}, {0x83c0, 0x1e, 0, 0}, {0x83c1, 0x10, 0, 0},
	{0x83c2, 0xd2, 0, 0}, {0x83c3, 0x34, 0, 0}, {0x83c4, 0x22, 0, 0},
	{0x83c5, 0xe5, 0, 0}, {0x83c6, 0x49, 0, 0}, {0x83c7, 0x75, 0, 0},
	{0x83c8, 0xf0, 0, 0}, {0x83c9, 0x05, 0, 0}, {0x83ca, 0x84, 0, 0},
	{0x83cb, 0x78, 0, 0}, {0x83cc, 0xba, 0, 0}, {0x83cd, 0xf6, 0, 0},
	{0x83ce, 0x90, 0, 0}, {0x83cf, 0x0e, 0, 0}, {0x83d0, 0x85, 0, 0},
	{0x83d1, 0xe4, 0, 0}, {0x83d2, 0x93, 0, 0}, {0x83d3, 0xff, 0, 0},
	{0x83d4, 0x25, 0, 0}, {0x83d5, 0xe0, 0, 0}, {0x83d6, 0x24, 0, 0},
	{0x83d7, 0x0a, 0, 0}, {0x83d8, 0xf8, 0, 0}, {0x83d9, 0xe6, 0, 0},
	{0x83da, 0xfc, 0, 0}, {0x83db, 0x08, 0, 0}, {0x83dc, 0xe6, 0, 0},
	{0x83dd, 0xfd, 0, 0}, {0x83de, 0x78, 0, 0}, {0x83df, 0xba, 0, 0},
	{0x83e0, 0xe6, 0, 0}, {0x83e1, 0x25, 0, 0}, {0x83e2, 0xe0, 0, 0},
	{0x83e3, 0x24, 0, 0}, {0x83e4, 0x4c, 0, 0}, {0x83e5, 0xf8, 0, 0},
	{0x83e6, 0xa6, 0, 0}, {0x83e7, 0x04, 0, 0}, {0x83e8, 0x08, 0, 0},
	{0x83e9, 0xa6, 0, 0}, {0x83ea, 0x05, 0, 0}, {0x83eb, 0xef, 0, 0},
	{0x83ec, 0x12, 0, 0}, {0x83ed, 0x0e, 0, 0}, {0x83ee, 0xc3, 0, 0},
	{0x83ef, 0xd3, 0, 0}, {0x83f0, 0x78, 0, 0}, {0x83f1, 0xb5, 0, 0},
	{0x83f2, 0x96, 0, 0}, {0x83f3, 0xee, 0, 0}, {0x83f4, 0x18, 0, 0},
	{0x83f5, 0x96, 0, 0}, {0x83f6, 0x40, 0, 0}, {0x83f7, 0x0d, 0, 0},
	{0x83f8, 0x78, 0, 0}, {0x83f9, 0xba, 0, 0}, {0x83fa, 0xe6, 0, 0},
	{0x83fb, 0x78, 0, 0}, {0x83fc, 0xb7, 0, 0}, {0x83fd, 0xf6, 0, 0},
	{0x83fe, 0x78, 0, 0}, {0x83ff, 0xb4, 0, 0}, {0x8400, 0xa6, 0, 0},
	{0x8401, 0x06, 0, 0}, {0x8402, 0x08, 0, 0}, {0x8403, 0xa6, 0, 0},
	{0x8404, 0x07, 0, 0}, {0x8405, 0x90, 0, 0}, {0x8406, 0x0e, 0, 0},
	{0x8407, 0x85, 0, 0}, {0x8408, 0xe4, 0, 0}, {0x8409, 0x93, 0, 0},
	{0x840a, 0x12, 0, 0}, {0x840b, 0x0e, 0, 0}, {0x840c, 0xc3, 0, 0},
	{0x840d, 0xc3, 0, 0}, {0x840e, 0x78, 0, 0}, {0x840f, 0xc0, 0, 0},
	{0x8410, 0x96, 0, 0}, {0x8411, 0xee, 0, 0}, {0x8412, 0x18, 0, 0},
	{0x8413, 0x96, 0, 0}, {0x8414, 0x50, 0, 0}, {0x8415, 0x0d, 0, 0},
	{0x8416, 0x78, 0, 0}, {0x8417, 0xba, 0, 0}, {0x8418, 0xe6, 0, 0},
	{0x8419, 0x78, 0, 0}, {0x841a, 0xb8, 0, 0}, {0x841b, 0xf6, 0, 0},
	{0x841c, 0x78, 0, 0}, {0x841d, 0xbf, 0, 0}, {0x841e, 0xa6, 0, 0},
	{0x841f, 0x06, 0, 0}, {0x8420, 0x08, 0, 0}, {0x8421, 0xa6, 0, 0},
	{0x8422, 0x07, 0, 0}, {0x8423, 0x78, 0, 0}, {0x8424, 0xb4, 0, 0},
	{0x8425, 0xe6, 0, 0}, {0x8426, 0xfe, 0, 0}, {0x8427, 0x08, 0, 0},
	{0x8428, 0xe6, 0, 0}, {0x8429, 0xc3, 0, 0}, {0x842a, 0x78, 0, 0},
	{0x842b, 0xc0, 0, 0}, {0x842c, 0x96, 0, 0}, {0x842d, 0xff, 0, 0},
	{0x842e, 0xee, 0, 0}, {0x842f, 0x18, 0, 0}, {0x8430, 0x96, 0, 0},
	{0x8431, 0x78, 0, 0}, {0x8432, 0xc1, 0, 0}, {0x8433, 0xf6, 0, 0},
	{0x8434, 0x08, 0, 0}, {0x8435, 0xa6, 0, 0}, {0x8436, 0x07, 0, 0},
	{0x8437, 0x90, 0, 0}, {0x8438, 0x0e, 0, 0}, {0x8439, 0x8e, 0, 0},
	{0x843a, 0xe4, 0, 0}, {0x843b, 0x18, 0, 0}, {0x843c, 0x12, 0, 0},
	{0x843d, 0x0e, 0, 0}, {0x843e, 0xa1, 0, 0}, {0x843f, 0x40, 0, 0},
	{0x8440, 0x02, 0, 0}, {0x8441, 0xd2, 0, 0}, {0x8442, 0x36, 0, 0},
	{0x8443, 0x78, 0, 0}, {0x8444, 0xba, 0, 0}, {0x8445, 0xe6, 0, 0},
	{0x8446, 0x08, 0, 0}, {0x8447, 0x26, 0, 0}, {0x8448, 0x08, 0, 0},
	{0x8449, 0xf6, 0, 0}, {0x844a, 0xe5, 0, 0}, {0x844b, 0x1f, 0, 0},
	{0x844c, 0x64, 0, 0}, {0x844d, 0x01, 0, 0}, {0x844e, 0x70, 0, 0},
	{0x844f, 0x4a, 0, 0}, {0x8450, 0xe6, 0, 0}, {0x8451, 0xc3, 0, 0},
	{0x8452, 0x78, 0, 0}, {0x8453, 0xbe, 0, 0}, {0x8454, 0x12, 0, 0},
	{0x8455, 0x0e, 0, 0}, {0x8456, 0x97, 0, 0}, {0x8457, 0x40, 0, 0},
	{0x8458, 0x05, 0, 0}, {0x8459, 0x12, 0, 0}, {0x845a, 0x0e, 0, 0},
	{0x845b, 0x92, 0, 0}, {0x845c, 0x40, 0, 0}, {0x845d, 0x39, 0, 0},
	{0x845e, 0x12, 0, 0}, {0x845f, 0x0e, 0, 0}, {0x8460, 0xba, 0, 0},
	{0x8461, 0x40, 0, 0}, {0x8462, 0x04, 0, 0}, {0x8463, 0x7f, 0, 0},
	{0x8464, 0xfe, 0, 0}, {0x8465, 0x80, 0, 0}, {0x8466, 0x02, 0, 0},
	{0x8467, 0x7f, 0, 0}, {0x8468, 0x02, 0, 0}, {0x8469, 0x78, 0, 0},
	{0x846a, 0xbb, 0, 0}, {0x846b, 0xa6, 0, 0}, {0x846c, 0x07, 0, 0},
	{0x846d, 0x78, 0, 0}, {0x846e, 0xb7, 0, 0}, {0x846f, 0xe6, 0, 0},
	{0x8470, 0x24, 0, 0}, {0x8471, 0x03, 0, 0}, {0x8472, 0x78, 0, 0},
	{0x8473, 0xbd, 0, 0}, {0x8474, 0xf6, 0, 0}, {0x8475, 0x78, 0, 0},
	{0x8476, 0xb7, 0, 0}, {0x8477, 0xe6, 0, 0}, {0x8478, 0x24, 0, 0},
	{0x8479, 0xfd, 0, 0}, {0x847a, 0x78, 0, 0}, {0x847b, 0xbe, 0, 0},
	{0x847c, 0xf6, 0, 0}, {0x847d, 0x12, 0, 0}, {0x847e, 0x0e, 0, 0},
	{0x847f, 0xba, 0, 0}, {0x8480, 0x40, 0, 0}, {0x8481, 0x06, 0, 0},
	{0x8482, 0x78, 0, 0}, {0x8483, 0xbe, 0, 0}, {0x8484, 0xe6, 0, 0},
	{0x8485, 0xff, 0, 0}, {0x8486, 0x80, 0, 0}, {0x8487, 0x04, 0, 0},
	{0x8488, 0x78, 0, 0}, {0x8489, 0xbd, 0, 0}, {0x848a, 0xe6, 0, 0},
	{0x848b, 0xff, 0, 0}, {0x848c, 0x78, 0, 0}, {0x848d, 0xbc, 0, 0},
	{0x848e, 0xa6, 0, 0}, {0x848f, 0x07, 0, 0}, {0x8490, 0x75, 0, 0},
	{0x8491, 0x1f, 0, 0}, {0x8492, 0x02, 0, 0}, {0x8493, 0x78, 0, 0},
	{0x8494, 0xb6, 0, 0}, {0x8495, 0x76, 0, 0}, {0x8496, 0x01, 0, 0},
	{0x8497, 0x02, 0, 0}, {0x8498, 0x05, 0, 0}, {0x8499, 0x59, 0, 0},
	{0x849a, 0xe5, 0, 0}, {0x849b, 0x1f, 0, 0}, {0x849c, 0x64, 0, 0},
	{0x849d, 0x02, 0, 0}, {0x849e, 0x60, 0, 0}, {0x849f, 0x03, 0, 0},
	{0x84a0, 0x02, 0, 0}, {0x84a1, 0x05, 0, 0}, {0x84a2, 0x39, 0, 0},
	{0x84a3, 0x78, 0, 0}, {0x84a4, 0xbc, 0, 0}, {0x84a5, 0xe6, 0, 0},
	{0x84a6, 0xff, 0, 0}, {0x84a7, 0xc3, 0, 0}, {0x84a8, 0x78, 0, 0},
	{0x84a9, 0xbe, 0, 0}, {0x84aa, 0x12, 0, 0}, {0x84ab, 0x0e, 0, 0},
	{0x84ac, 0x98, 0, 0}, {0x84ad, 0x40, 0, 0}, {0x84ae, 0x08, 0, 0},
	{0x84af, 0x12, 0, 0}, {0x84b0, 0x0e, 0, 0}, {0x84b1, 0x92, 0, 0},
	{0x84b2, 0x50, 0, 0}, {0x84b3, 0x03, 0, 0}, {0x84b4, 0x02, 0, 0},
	{0x84b5, 0x05, 0, 0}, {0x84b6, 0x37, 0, 0}, {0x84b7, 0x12, 0, 0},
	{0x84b8, 0x0e, 0, 0}, {0x84b9, 0xba, 0, 0}, {0x84ba, 0x40, 0, 0},
	{0x84bb, 0x04, 0, 0}, {0x84bc, 0x7f, 0, 0}, {0x84bd, 0xff, 0, 0},
	{0x84be, 0x80, 0, 0}, {0x84bf, 0x02, 0, 0}, {0x84c0, 0x7f, 0, 0},
	{0x84c1, 0x01, 0, 0}, {0x84c2, 0x78, 0, 0}, {0x84c3, 0xbb, 0, 0},
	{0x84c4, 0xa6, 0, 0}, {0x84c5, 0x07, 0, 0}, {0x84c6, 0x78, 0, 0},
	{0x84c7, 0xb7, 0, 0}, {0x84c8, 0xe6, 0, 0}, {0x84c9, 0x04, 0, 0},
	{0x84ca, 0x78, 0, 0}, {0x84cb, 0xbd, 0, 0}, {0x84cc, 0xf6, 0, 0},
	{0x84cd, 0x78, 0, 0}, {0x84ce, 0xb7, 0, 0}, {0x84cf, 0xe6, 0, 0},
	{0x84d0, 0x14, 0, 0}, {0x84d1, 0x78, 0, 0}, {0x84d2, 0xbe, 0, 0},
	{0x84d3, 0xf6, 0, 0}, {0x84d4, 0x18, 0, 0}, {0x84d5, 0x12, 0, 0},
	{0x84d6, 0x0e, 0, 0}, {0x84d7, 0xbc, 0, 0}, {0x84d8, 0x40, 0, 0},
	{0x84d9, 0x04, 0, 0}, {0x84da, 0xe6, 0, 0}, {0x84db, 0xff, 0, 0},
	{0x84dc, 0x80, 0, 0}, {0x84dd, 0x02, 0, 0}, {0x84de, 0x7f, 0, 0},
	{0x84df, 0x00, 0, 0}, {0x84e0, 0x78, 0, 0}, {0x84e1, 0xbd, 0, 0},
	{0x84e2, 0xa6, 0, 0}, {0x84e3, 0x07, 0, 0}, {0x84e4, 0xd3, 0, 0},
	{0x84e5, 0x08, 0, 0}, {0x84e6, 0xe6, 0, 0}, {0x84e7, 0x64, 0, 0},
	{0x84e8, 0x80, 0, 0}, {0x84e9, 0x94, 0, 0}, {0x84ea, 0x80, 0, 0},
	{0x84eb, 0x40, 0, 0}, {0x84ec, 0x04, 0, 0}, {0x84ed, 0xe6, 0, 0},
	{0x84ee, 0xff, 0, 0}, {0x84ef, 0x80, 0, 0}, {0x84f0, 0x02, 0, 0},
	{0x84f1, 0x7f, 0, 0}, {0x84f2, 0x00, 0, 0}, {0x84f3, 0x78, 0, 0},
	{0x84f4, 0xbe, 0, 0}, {0x84f5, 0xa6, 0, 0}, {0x84f6, 0x07, 0, 0},
	{0x84f7, 0xc3, 0, 0}, {0x84f8, 0x18, 0, 0}, {0x84f9, 0xe6, 0, 0},
	{0x84fa, 0x64, 0, 0}, {0x84fb, 0x80, 0, 0}, {0x84fc, 0x94, 0, 0},
	{0x84fd, 0xb3, 0, 0}, {0x84fe, 0x50, 0, 0}, {0x84ff, 0x04, 0, 0},
	{0x8500, 0xe6, 0, 0}, {0x8501, 0xff, 0, 0}, {0x8502, 0x80, 0, 0},
	{0x8503, 0x02, 0, 0}, {0x8504, 0x7f, 0, 0}, {0x8505, 0x33, 0, 0},
	{0x8506, 0x78, 0, 0}, {0x8507, 0xbd, 0, 0}, {0x8508, 0xa6, 0, 0},
	{0x8509, 0x07, 0, 0}, {0x850a, 0xc3, 0, 0}, {0x850b, 0x08, 0, 0},
	{0x850c, 0xe6, 0, 0}, {0x850d, 0x64, 0, 0}, {0x850e, 0x80, 0, 0},
	{0x850f, 0x94, 0, 0}, {0x8510, 0xb3, 0, 0}, {0x8511, 0x50, 0, 0},
	{0x8512, 0x04, 0, 0}, {0x8513, 0xe6, 0, 0}, {0x8514, 0xff, 0, 0},
	{0x8515, 0x80, 0, 0}, {0x8516, 0x02, 0, 0}, {0x8517, 0x7f, 0, 0},
	{0x8518, 0x33, 0, 0}, {0x8519, 0x78, 0, 0}, {0x851a, 0xbe, 0, 0},
	{0x851b, 0xa6, 0, 0}, {0x851c, 0x07, 0, 0}, {0x851d, 0x12, 0, 0},
	{0x851e, 0x0e, 0, 0}, {0x851f, 0xba, 0, 0}, {0x8520, 0x40, 0, 0},
	{0x8521, 0x06, 0, 0}, {0x8522, 0x78, 0, 0}, {0x8523, 0xbe, 0, 0},
	{0x8524, 0xe6, 0, 0}, {0x8525, 0xff, 0, 0}, {0x8526, 0x80, 0, 0},
	{0x8527, 0x04, 0, 0}, {0x8528, 0x78, 0, 0}, {0x8529, 0xbd, 0, 0},
	{0x852a, 0xe6, 0, 0}, {0x852b, 0xff, 0, 0}, {0x852c, 0x78, 0, 0},
	{0x852d, 0xbc, 0, 0}, {0x852e, 0xa6, 0, 0}, {0x852f, 0x07, 0, 0},
	{0x8530, 0x75, 0, 0}, {0x8531, 0x1f, 0, 0}, {0x8532, 0x03, 0, 0},
	{0x8533, 0x78, 0, 0}, {0x8534, 0xb6, 0, 0}, {0x8535, 0x76, 0, 0},
	{0x8536, 0x01, 0, 0}, {0x8537, 0x80, 0, 0}, {0x8538, 0x20, 0, 0},
	{0x8539, 0xe5, 0, 0}, {0x853a, 0x1f, 0, 0}, {0x853b, 0x64, 0, 0},
	{0x853c, 0x03, 0, 0}, {0x853d, 0x70, 0, 0}, {0x853e, 0x26, 0, 0},
	{0x853f, 0x78, 0, 0}, {0x8540, 0xbc, 0, 0}, {0x8541, 0xe6, 0, 0},
	{0x8542, 0xff, 0, 0}, {0x8543, 0xc3, 0, 0}, {0x8544, 0x78, 0, 0},
	{0x8545, 0xbe, 0, 0}, {0x8546, 0x12, 0, 0}, {0x8547, 0x0e, 0, 0},
	{0x8548, 0x98, 0, 0}, {0x8549, 0x40, 0, 0}, {0x854a, 0x05, 0, 0},
	{0x854b, 0x12, 0, 0}, {0x854c, 0x0e, 0, 0}, {0x854d, 0x92, 0, 0},
	{0x854e, 0x40, 0, 0}, {0x854f, 0x09, 0, 0}, {0x8550, 0x78, 0, 0},
	{0x8551, 0xb7, 0, 0}, {0x8552, 0xe6, 0, 0}, {0x8553, 0x78, 0, 0},
	{0x8554, 0xbc, 0, 0}, {0x8555, 0xf6, 0, 0}, {0x8556, 0x75, 0, 0},
	{0x8557, 0x1f, 0, 0}, {0x8558, 0x04, 0, 0}, {0x8559, 0x78, 0, 0},
	{0x855a, 0xbc, 0, 0}, {0x855b, 0xe6, 0, 0}, {0x855c, 0x75, 0, 0},
	{0x855d, 0xf0, 0, 0}, {0x855e, 0x05, 0, 0}, {0x855f, 0xa4, 0, 0},
	{0x8560, 0xf5, 0, 0}, {0x8561, 0x49, 0, 0}, {0x8562, 0x02, 0, 0},
	{0x8563, 0x0a, 0, 0}, {0x8564, 0xfd, 0, 0}, {0x8565, 0xe5, 0, 0},
	{0x8566, 0x1f, 0, 0}, {0x8567, 0xb4, 0, 0}, {0x8568, 0x04, 0, 0},
	{0x8569, 0x1f, 0, 0}, {0x856a, 0x90, 0, 0}, {0x856b, 0x0e, 0, 0},
	{0x856c, 0x8d, 0, 0}, {0x856d, 0xe4, 0, 0}, {0x856e, 0x78, 0, 0},
	{0x856f, 0xc1, 0, 0}, {0x8570, 0x12, 0, 0}, {0x8571, 0x0e, 0, 0},
	{0x8572, 0xa1, 0, 0}, {0x8573, 0x40, 0, 0}, {0x8574, 0x02, 0, 0},
	{0x8575, 0xd2, 0, 0}, {0x8576, 0x36, 0, 0}, {0x8577, 0x75, 0, 0},
	{0x8578, 0x1f, 0, 0}, {0x8579, 0x05, 0, 0}, {0x857a, 0x75, 0, 0},
	{0x857b, 0x34, 0, 0}, {0x857c, 0xff, 0, 0}, {0x857d, 0x75, 0, 0},
	{0x857e, 0x35, 0, 0}, {0x857f, 0x0e, 0, 0}, {0x8580, 0x75, 0, 0},
	{0x8581, 0x36, 0, 0}, {0x8582, 0x59, 0, 0}, {0x8583, 0x75, 0, 0},
	{0x8584, 0x37, 0, 0}, {0x8585, 0x01, 0, 0}, {0x8586, 0x12, 0, 0},
	{0x8587, 0x0d, 0, 0}, {0x8588, 0x85, 0, 0}, {0x8589, 0x22, 0, 0},
	{0x858a, 0xef, 0, 0}, {0x858b, 0x8d, 0, 0}, {0x858c, 0xf0, 0, 0},
	{0x858d, 0xa4, 0, 0}, {0x858e, 0xa8, 0, 0}, {0x858f, 0xf0, 0, 0},
	{0x8590, 0xcf, 0, 0}, {0x8591, 0x8c, 0, 0}, {0x8592, 0xf0, 0, 0},
	{0x8593, 0xa4, 0, 0}, {0x8594, 0x28, 0, 0}, {0x8595, 0xce, 0, 0},
	{0x8596, 0x8d, 0, 0}, {0x8597, 0xf0, 0, 0}, {0x8598, 0xa4, 0, 0},
	{0x8599, 0x2e, 0, 0}, {0x859a, 0xfe, 0, 0}, {0x859b, 0x22, 0, 0},
	{0x859c, 0xbc, 0, 0}, {0x859d, 0x00, 0, 0}, {0x859e, 0x0b, 0, 0},
	{0x859f, 0xbe, 0, 0}, {0x85a0, 0x00, 0, 0}, {0x85a1, 0x29, 0, 0},
	{0x85a2, 0xef, 0, 0}, {0x85a3, 0x8d, 0, 0}, {0x85a4, 0xf0, 0, 0},
	{0x85a5, 0x84, 0, 0}, {0x85a6, 0xff, 0, 0}, {0x85a7, 0xad, 0, 0},
	{0x85a8, 0xf0, 0, 0}, {0x85a9, 0x22, 0, 0}, {0x85aa, 0xe4, 0, 0},
	{0x85ab, 0xcc, 0, 0}, {0x85ac, 0xf8, 0, 0}, {0x85ad, 0x75, 0, 0},
	{0x85ae, 0xf0, 0, 0}, {0x85af, 0x08, 0, 0}, {0x85b0, 0xef, 0, 0},
	{0x85b1, 0x2f, 0, 0}, {0x85b2, 0xff, 0, 0}, {0x85b3, 0xee, 0, 0},
	{0x85b4, 0x33, 0, 0}, {0x85b5, 0xfe, 0, 0}, {0x85b6, 0xec, 0, 0},
	{0x85b7, 0x33, 0, 0}, {0x85b8, 0xfc, 0, 0}, {0x85b9, 0xee, 0, 0},
	{0x85ba, 0x9d, 0, 0}, {0x85bb, 0xec, 0, 0}, {0x85bc, 0x98, 0, 0},
	{0x85bd, 0x40, 0, 0}, {0x85be, 0x05, 0, 0}, {0x85bf, 0xfc, 0, 0},
	{0x85c0, 0xee, 0, 0}, {0x85c1, 0x9d, 0, 0}, {0x85c2, 0xfe, 0, 0},
	{0x85c3, 0x0f, 0, 0}, {0x85c4, 0xd5, 0, 0}, {0x85c5, 0xf0, 0, 0},
	{0x85c6, 0xe9, 0, 0}, {0x85c7, 0xe4, 0, 0}, {0x85c8, 0xce, 0, 0},
	{0x85c9, 0xfd, 0, 0}, {0x85ca, 0x22, 0, 0}, {0x85cb, 0xed, 0, 0},
	{0x85cc, 0xf8, 0, 0}, {0x85cd, 0xf5, 0, 0}, {0x85ce, 0xf0, 0, 0},
	{0x85cf, 0xee, 0, 0}, {0x85d0, 0x84, 0, 0}, {0x85d1, 0x20, 0, 0},
	{0x85d2, 0xd2, 0, 0}, {0x85d3, 0x1c, 0, 0}, {0x85d4, 0xfe, 0, 0},
	{0x85d5, 0xad, 0, 0}, {0x85d6, 0xf0, 0, 0}, {0x85d7, 0x75, 0, 0},
	{0x85d8, 0xf0, 0, 0}, {0x85d9, 0x08, 0, 0}, {0x85da, 0xef, 0, 0},
	{0x85db, 0x2f, 0, 0}, {0x85dc, 0xff, 0, 0}, {0x85dd, 0xed, 0, 0},
	{0x85de, 0x33, 0, 0}, {0x85df, 0xfd, 0, 0}, {0x85e0, 0x40, 0, 0},
	{0x85e1, 0x07, 0, 0}, {0x85e2, 0x98, 0, 0}, {0x85e3, 0x50, 0, 0},
	{0x85e4, 0x06, 0, 0}, {0x85e5, 0xd5, 0, 0}, {0x85e6, 0xf0, 0, 0},
	{0x85e7, 0xf2, 0, 0}, {0x85e8, 0x22, 0, 0}, {0x85e9, 0xc3, 0, 0},
	{0x85ea, 0x98, 0, 0}, {0x85eb, 0xfd, 0, 0}, {0x85ec, 0x0f, 0, 0},
	{0x85ed, 0xd5, 0, 0}, {0x85ee, 0xf0, 0, 0}, {0x85ef, 0xea, 0, 0},
	{0x85f0, 0x22, 0, 0}, {0x85f1, 0xe8, 0, 0}, {0x85f2, 0x8f, 0, 0},
	{0x85f3, 0xf0, 0, 0}, {0x85f4, 0xa4, 0, 0}, {0x85f5, 0xcc, 0, 0},
	{0x85f6, 0x8b, 0, 0}, {0x85f7, 0xf0, 0, 0}, {0x85f8, 0xa4, 0, 0},
	{0x85f9, 0x2c, 0, 0}, {0x85fa, 0xfc, 0, 0}, {0x85fb, 0xe9, 0, 0},
	{0x85fc, 0x8e, 0, 0}, {0x85fd, 0xf0, 0, 0}, {0x85fe, 0xa4, 0, 0},
	{0x85ff, 0x2c, 0, 0}, {0x8600, 0xfc, 0, 0}, {0x8601, 0x8a, 0, 0},
	{0x8602, 0xf0, 0, 0}, {0x8603, 0xed, 0, 0}, {0x8604, 0xa4, 0, 0},
	{0x8605, 0x2c, 0, 0}, {0x8606, 0xfc, 0, 0}, {0x8607, 0xea, 0, 0},
	{0x8608, 0x8e, 0, 0}, {0x8609, 0xf0, 0, 0}, {0x860a, 0xa4, 0, 0},
	{0x860b, 0xcd, 0, 0}, {0x860c, 0xa8, 0, 0}, {0x860d, 0xf0, 0, 0},
	{0x860e, 0x8b, 0, 0}, {0x860f, 0xf0, 0, 0}, {0x8610, 0xa4, 0, 0},
	{0x8611, 0x2d, 0, 0}, {0x8612, 0xcc, 0, 0}, {0x8613, 0x38, 0, 0},
	{0x8614, 0x25, 0, 0}, {0x8615, 0xf0, 0, 0}, {0x8616, 0xfd, 0, 0},
	{0x8617, 0xe9, 0, 0}, {0x8618, 0x8f, 0, 0}, {0x8619, 0xf0, 0, 0},
	{0x861a, 0xa4, 0, 0}, {0x861b, 0x2c, 0, 0}, {0x861c, 0xcd, 0, 0},
	{0x861d, 0x35, 0, 0}, {0x861e, 0xf0, 0, 0}, {0x861f, 0xfc, 0, 0},
	{0x8620, 0xeb, 0, 0}, {0x8621, 0x8e, 0, 0}, {0x8622, 0xf0, 0, 0},
	{0x8623, 0xa4, 0, 0}, {0x8624, 0xfe, 0, 0}, {0x8625, 0xa9, 0, 0},
	{0x8626, 0xf0, 0, 0}, {0x8627, 0xeb, 0, 0}, {0x8628, 0x8f, 0, 0},
	{0x8629, 0xf0, 0, 0}, {0x862a, 0xa4, 0, 0}, {0x862b, 0xcf, 0, 0},
	{0x862c, 0xc5, 0, 0}, {0x862d, 0xf0, 0, 0}, {0x862e, 0x2e, 0, 0},
	{0x862f, 0xcd, 0, 0}, {0x8630, 0x39, 0, 0}, {0x8631, 0xfe, 0, 0},
	{0x8632, 0xe4, 0, 0}, {0x8633, 0x3c, 0, 0}, {0x8634, 0xfc, 0, 0},
	{0x8635, 0xea, 0, 0}, {0x8636, 0xa4, 0, 0}, {0x8637, 0x2d, 0, 0},
	{0x8638, 0xce, 0, 0}, {0x8639, 0x35, 0, 0}, {0x863a, 0xf0, 0, 0},
	{0x863b, 0xfd, 0, 0}, {0x863c, 0xe4, 0, 0}, {0x863d, 0x3c, 0, 0},
	{0x863e, 0xfc, 0, 0}, {0x863f, 0x22, 0, 0}, {0x8640, 0x75, 0, 0},
	{0x8641, 0xf0, 0, 0}, {0x8642, 0x08, 0, 0}, {0x8643, 0x75, 0, 0},
	{0x8644, 0x82, 0, 0}, {0x8645, 0x00, 0, 0}, {0x8646, 0xef, 0, 0},
	{0x8647, 0x2f, 0, 0}, {0x8648, 0xff, 0, 0}, {0x8649, 0xee, 0, 0},
	{0x864a, 0x33, 0, 0}, {0x864b, 0xfe, 0, 0}, {0x864c, 0xcd, 0, 0},
	{0x864d, 0x33, 0, 0}, {0x864e, 0xcd, 0, 0}, {0x864f, 0xcc, 0, 0},
	{0x8650, 0x33, 0, 0}, {0x8651, 0xcc, 0, 0}, {0x8652, 0xc5, 0, 0},
	{0x8653, 0x82, 0, 0}, {0x8654, 0x33, 0, 0}, {0x8655, 0xc5, 0, 0},
	{0x8656, 0x82, 0, 0}, {0x8657, 0x9b, 0, 0}, {0x8658, 0xed, 0, 0},
	{0x8659, 0x9a, 0, 0}, {0x865a, 0xec, 0, 0}, {0x865b, 0x99, 0, 0},
	{0x865c, 0xe5, 0, 0}, {0x865d, 0x82, 0, 0}, {0x865e, 0x98, 0, 0},
	{0x865f, 0x40, 0, 0}, {0x8660, 0x0c, 0, 0}, {0x8661, 0xf5, 0, 0},
	{0x8662, 0x82, 0, 0}, {0x8663, 0xee, 0, 0}, {0x8664, 0x9b, 0, 0},
	{0x8665, 0xfe, 0, 0}, {0x8666, 0xed, 0, 0}, {0x8667, 0x9a, 0, 0},
	{0x8668, 0xfd, 0, 0}, {0x8669, 0xec, 0, 0}, {0x866a, 0x99, 0, 0},
	{0x866b, 0xfc, 0, 0}, {0x866c, 0x0f, 0, 0}, {0x866d, 0xd5, 0, 0},
	{0x866e, 0xf0, 0, 0}, {0x866f, 0xd6, 0, 0}, {0x8670, 0xe4, 0, 0},
	{0x8671, 0xce, 0, 0}, {0x8672, 0xfb, 0, 0}, {0x8673, 0xe4, 0, 0},
	{0x8674, 0xcd, 0, 0}, {0x8675, 0xfa, 0, 0}, {0x8676, 0xe4, 0, 0},
	{0x8677, 0xcc, 0, 0}, {0x8678, 0xf9, 0, 0}, {0x8679, 0xa8, 0, 0},
	{0x867a, 0x82, 0, 0}, {0x867b, 0x22, 0, 0}, {0x867c, 0xb8, 0, 0},
	{0x867d, 0x00, 0, 0}, {0x867e, 0xc1, 0, 0}, {0x867f, 0xb9, 0, 0},
	{0x8680, 0x00, 0, 0}, {0x8681, 0x59, 0, 0}, {0x8682, 0xba, 0, 0},
	{0x8683, 0x00, 0, 0}, {0x8684, 0x2d, 0, 0}, {0x8685, 0xec, 0, 0},
	{0x8686, 0x8b, 0, 0}, {0x8687, 0xf0, 0, 0}, {0x8688, 0x84, 0, 0},
	{0x8689, 0xcf, 0, 0}, {0x868a, 0xce, 0, 0}, {0x868b, 0xcd, 0, 0},
	{0x868c, 0xfc, 0, 0}, {0x868d, 0xe5, 0, 0}, {0x868e, 0xf0, 0, 0},
	{0x868f, 0xcb, 0, 0}, {0x8690, 0xf9, 0, 0}, {0x8691, 0x78, 0, 0},
	{0x8692, 0x18, 0, 0}, {0x8693, 0xef, 0, 0}, {0x8694, 0x2f, 0, 0},
	{0x8695, 0xff, 0, 0}, {0x8696, 0xee, 0, 0}, {0x8697, 0x33, 0, 0},
	{0x8698, 0xfe, 0, 0}, {0x8699, 0xed, 0, 0}, {0x869a, 0x33, 0, 0},
	{0x869b, 0xfd, 0, 0}, {0x869c, 0xec, 0, 0}, {0x869d, 0x33, 0, 0},
	{0x869e, 0xfc, 0, 0}, {0x869f, 0xeb, 0, 0}, {0x86a0, 0x33, 0, 0},
	{0x86a1, 0xfb, 0, 0}, {0x86a2, 0x10, 0, 0}, {0x86a3, 0xd7, 0, 0},
	{0x86a4, 0x03, 0, 0}, {0x86a5, 0x99, 0, 0}, {0x86a6, 0x40, 0, 0},
	{0x86a7, 0x04, 0, 0}, {0x86a8, 0xeb, 0, 0}, {0x86a9, 0x99, 0, 0},
	{0x86aa, 0xfb, 0, 0}, {0x86ab, 0x0f, 0, 0}, {0x86ac, 0xd8, 0, 0},
	{0x86ad, 0xe5, 0, 0}, {0x86ae, 0xe4, 0, 0}, {0x86af, 0xf9, 0, 0},
	{0x86b0, 0xfa, 0, 0}, {0x86b1, 0x22, 0, 0}, {0x86b2, 0x78, 0, 0},
	{0x86b3, 0x18, 0, 0}, {0x86b4, 0xef, 0, 0}, {0x86b5, 0x2f, 0, 0},
	{0x86b6, 0xff, 0, 0}, {0x86b7, 0xee, 0, 0}, {0x86b8, 0x33, 0, 0},
	{0x86b9, 0xfe, 0, 0}, {0x86ba, 0xed, 0, 0}, {0x86bb, 0x33, 0, 0},
	{0x86bc, 0xfd, 0, 0}, {0x86bd, 0xec, 0, 0}, {0x86be, 0x33, 0, 0},
	{0x86bf, 0xfc, 0, 0}, {0x86c0, 0xc9, 0, 0}, {0x86c1, 0x33, 0, 0},
	{0x86c2, 0xc9, 0, 0}, {0x86c3, 0x10, 0, 0}, {0x86c4, 0xd7, 0, 0},
	{0x86c5, 0x05, 0, 0}, {0x86c6, 0x9b, 0, 0}, {0x86c7, 0xe9, 0, 0},
	{0x86c8, 0x9a, 0, 0}, {0x86c9, 0x40, 0, 0}, {0x86ca, 0x07, 0, 0},
	{0x86cb, 0xec, 0, 0}, {0x86cc, 0x9b, 0, 0}, {0x86cd, 0xfc, 0, 0},
	{0x86ce, 0xe9, 0, 0}, {0x86cf, 0x9a, 0, 0}, {0x86d0, 0xf9, 0, 0},
	{0x86d1, 0x0f, 0, 0}, {0x86d2, 0xd8, 0, 0}, {0x86d3, 0xe0, 0, 0},
	{0x86d4, 0xe4, 0, 0}, {0x86d5, 0xc9, 0, 0}, {0x86d6, 0xfa, 0, 0},
	{0x86d7, 0xe4, 0, 0}, {0x86d8, 0xcc, 0, 0}, {0x86d9, 0xfb, 0, 0},
	{0x86da, 0x22, 0, 0}, {0x86db, 0x75, 0, 0}, {0x86dc, 0xf0, 0, 0},
	{0x86dd, 0x10, 0, 0}, {0x86de, 0xef, 0, 0}, {0x86df, 0x2f, 0, 0},
	{0x86e0, 0xff, 0, 0}, {0x86e1, 0xee, 0, 0}, {0x86e2, 0x33, 0, 0},
	{0x86e3, 0xfe, 0, 0}, {0x86e4, 0xed, 0, 0}, {0x86e5, 0x33, 0, 0},
	{0x86e6, 0xfd, 0, 0}, {0x86e7, 0xcc, 0, 0}, {0x86e8, 0x33, 0, 0},
	{0x86e9, 0xcc, 0, 0}, {0x86ea, 0xc8, 0, 0}, {0x86eb, 0x33, 0, 0},
	{0x86ec, 0xc8, 0, 0}, {0x86ed, 0x10, 0, 0}, {0x86ee, 0xd7, 0, 0},
	{0x86ef, 0x07, 0, 0}, {0x86f0, 0x9b, 0, 0}, {0x86f1, 0xec, 0, 0},
	{0x86f2, 0x9a, 0, 0}, {0x86f3, 0xe8, 0, 0}, {0x86f4, 0x99, 0, 0},
	{0x86f5, 0x40, 0, 0}, {0x86f6, 0x0a, 0, 0}, {0x86f7, 0xed, 0, 0},
	{0x86f8, 0x9b, 0, 0}, {0x86f9, 0xfd, 0, 0}, {0x86fa, 0xec, 0, 0},
	{0x86fb, 0x9a, 0, 0}, {0x86fc, 0xfc, 0, 0}, {0x86fd, 0xe8, 0, 0},
	{0x86fe, 0x99, 0, 0}, {0x86ff, 0xf8, 0, 0}, {0x8700, 0x0f, 0, 0},
	{0x8701, 0xd5, 0, 0}, {0x8702, 0xf0, 0, 0}, {0x8703, 0xda, 0, 0},
	{0x8704, 0xe4, 0, 0}, {0x8705, 0xcd, 0, 0}, {0x8706, 0xfb, 0, 0},
	{0x8707, 0xe4, 0, 0}, {0x8708, 0xcc, 0, 0}, {0x8709, 0xfa, 0, 0},
	{0x870a, 0xe4, 0, 0}, {0x870b, 0xc8, 0, 0}, {0x870c, 0xf9, 0, 0},
	{0x870d, 0x22, 0, 0}, {0x870e, 0xeb, 0, 0}, {0x870f, 0x9f, 0, 0},
	{0x8710, 0xf5, 0, 0}, {0x8711, 0xf0, 0, 0}, {0x8712, 0xea, 0, 0},
	{0x8713, 0x9e, 0, 0}, {0x8714, 0x42, 0, 0}, {0x8715, 0xf0, 0, 0},
	{0x8716, 0xe9, 0, 0}, {0x8717, 0x9d, 0, 0}, {0x8718, 0x42, 0, 0},
	{0x8719, 0xf0, 0, 0}, {0x871a, 0xe8, 0, 0}, {0x871b, 0x9c, 0, 0},
	{0x871c, 0x45, 0, 0}, {0x871d, 0xf0, 0, 0}, {0x871e, 0x22, 0, 0},
	{0x871f, 0xe8, 0, 0}, {0x8720, 0x60, 0, 0}, {0x8721, 0x0f, 0, 0},
	{0x8722, 0xef, 0, 0}, {0x8723, 0xc3, 0, 0}, {0x8724, 0x33, 0, 0},
	{0x8725, 0xff, 0, 0}, {0x8726, 0xee, 0, 0}, {0x8727, 0x33, 0, 0},
	{0x8728, 0xfe, 0, 0}, {0x8729, 0xed, 0, 0}, {0x872a, 0x33, 0, 0},
	{0x872b, 0xfd, 0, 0}, {0x872c, 0xec, 0, 0}, {0x872d, 0x33, 0, 0},
	{0x872e, 0xfc, 0, 0}, {0x872f, 0xd8, 0, 0}, {0x8730, 0xf1, 0, 0},
	{0x8731, 0x22, 0, 0}, {0x8732, 0xe4, 0, 0}, {0x8733, 0x93, 0, 0},
	{0x8734, 0xfc, 0, 0}, {0x8735, 0x74, 0, 0}, {0x8736, 0x01, 0, 0},
	{0x8737, 0x93, 0, 0}, {0x8738, 0xfd, 0, 0}, {0x8739, 0x74, 0, 0},
	{0x873a, 0x02, 0, 0}, {0x873b, 0x93, 0, 0}, {0x873c, 0xfe, 0, 0},
	{0x873d, 0x74, 0, 0}, {0x873e, 0x03, 0, 0}, {0x873f, 0x93, 0, 0},
	{0x8740, 0xff, 0, 0}, {0x8741, 0x22, 0, 0}, {0x8742, 0xe6, 0, 0},
	{0x8743, 0xfb, 0, 0}, {0x8744, 0x08, 0, 0}, {0x8745, 0xe6, 0, 0},
	{0x8746, 0xf9, 0, 0}, {0x8747, 0x08, 0, 0}, {0x8748, 0xe6, 0, 0},
	{0x8749, 0xfa, 0, 0}, {0x874a, 0x08, 0, 0}, {0x874b, 0xe6, 0, 0},
	{0x874c, 0xcb, 0, 0}, {0x874d, 0xf8, 0, 0}, {0x874e, 0x22, 0, 0},
	{0x874f, 0xec, 0, 0}, {0x8750, 0xf6, 0, 0}, {0x8751, 0x08, 0, 0},
	{0x8752, 0xed, 0, 0}, {0x8753, 0xf6, 0, 0}, {0x8754, 0x08, 0, 0},
	{0x8755, 0xee, 0, 0}, {0x8756, 0xf6, 0, 0}, {0x8757, 0x08, 0, 0},
	{0x8758, 0xef, 0, 0}, {0x8759, 0xf6, 0, 0}, {0x875a, 0x22, 0, 0},
	{0x875b, 0xa4, 0, 0}, {0x875c, 0x25, 0, 0}, {0x875d, 0x82, 0, 0},
	{0x875e, 0xf5, 0, 0}, {0x875f, 0x82, 0, 0}, {0x8760, 0xe5, 0, 0},
	{0x8761, 0xf0, 0, 0}, {0x8762, 0x35, 0, 0}, {0x8763, 0x83, 0, 0},
	{0x8764, 0xf5, 0, 0}, {0x8765, 0x83, 0, 0}, {0x8766, 0x22, 0, 0},
	{0x8767, 0xd0, 0, 0}, {0x8768, 0x83, 0, 0}, {0x8769, 0xd0, 0, 0},
	{0x876a, 0x82, 0, 0}, {0x876b, 0xf8, 0, 0}, {0x876c, 0xe4, 0, 0},
	{0x876d, 0x93, 0, 0}, {0x876e, 0x70, 0, 0}, {0x876f, 0x12, 0, 0},
	{0x8770, 0x74, 0, 0}, {0x8771, 0x01, 0, 0}, {0x8772, 0x93, 0, 0},
	{0x8773, 0x70, 0, 0}, {0x8774, 0x0d, 0, 0}, {0x8775, 0xa3, 0, 0},
	{0x8776, 0xa3, 0, 0}, {0x8777, 0x93, 0, 0}, {0x8778, 0xf8, 0, 0},
	{0x8779, 0x74, 0, 0}, {0x877a, 0x01, 0, 0}, {0x877b, 0x93, 0, 0},
	{0x877c, 0xf5, 0, 0}, {0x877d, 0x82, 0, 0}, {0x877e, 0x88, 0, 0},
	{0x877f, 0x83, 0, 0}, {0x8780, 0xe4, 0, 0}, {0x8781, 0x73, 0, 0},
	{0x8782, 0x74, 0, 0}, {0x8783, 0x02, 0, 0}, {0x8784, 0x93, 0, 0},
	{0x8785, 0x68, 0, 0}, {0x8786, 0x60, 0, 0}, {0x8787, 0xef, 0, 0},
	{0x8788, 0xa3, 0, 0}, {0x8789, 0xa3, 0, 0}, {0x878a, 0xa3, 0, 0},
	{0x878b, 0x80, 0, 0}, {0x878c, 0xdf, 0, 0}, {0x878d, 0x90, 0, 0},
	{0x878e, 0x38, 0, 0}, {0x878f, 0x04, 0, 0}, {0x8790, 0x78, 0, 0},
	{0x8791, 0x50, 0, 0}, {0x8792, 0x12, 0, 0}, {0x8793, 0x0c, 0, 0},
	{0x8794, 0x7f, 0, 0}, {0x8795, 0x90, 0, 0}, {0x8796, 0x38, 0, 0},
	{0x8797, 0x00, 0, 0}, {0x8798, 0xe0, 0, 0}, {0x8799, 0xfe, 0, 0},
	{0x879a, 0xa3, 0, 0}, {0x879b, 0xe0, 0, 0}, {0x879c, 0xfd, 0, 0},
	{0x879d, 0xed, 0, 0}, {0x879e, 0xff, 0, 0}, {0x879f, 0xc3, 0, 0},
	{0x87a0, 0x12, 0, 0}, {0x87a1, 0x0c, 0, 0}, {0x87a2, 0x38, 0, 0},
	{0x87a3, 0x90, 0, 0}, {0x87a4, 0x38, 0, 0}, {0x87a5, 0x10, 0, 0},
	{0x87a6, 0x12, 0, 0}, {0x87a7, 0x0c, 0, 0}, {0x87a8, 0x2c, 0, 0},
	{0x87a9, 0x90, 0, 0}, {0x87aa, 0x38, 0, 0}, {0x87ab, 0x06, 0, 0},
	{0x87ac, 0x78, 0, 0}, {0x87ad, 0x52, 0, 0}, {0x87ae, 0x12, 0, 0},
	{0x87af, 0x0c, 0, 0}, {0x87b0, 0x7f, 0, 0}, {0x87b1, 0x90, 0, 0},
	{0x87b2, 0x38, 0, 0}, {0x87b3, 0x02, 0, 0}, {0x87b4, 0xe0, 0, 0},
	{0x87b5, 0xfe, 0, 0}, {0x87b6, 0xa3, 0, 0}, {0x87b7, 0xe0, 0, 0},
	{0x87b8, 0xfd, 0, 0}, {0x87b9, 0xed, 0, 0}, {0x87ba, 0xff, 0, 0},
	{0x87bb, 0xc3, 0, 0}, {0x87bc, 0x12, 0, 0}, {0x87bd, 0x0c, 0, 0},
	{0x87be, 0x38, 0, 0}, {0x87bf, 0x90, 0, 0}, {0x87c0, 0x38, 0, 0},
	{0x87c1, 0x12, 0, 0}, {0x87c2, 0x12, 0, 0}, {0x87c3, 0x0c, 0, 0},
	{0x87c4, 0x2c, 0, 0}, {0x87c5, 0xa3, 0, 0}, {0x87c6, 0xe0, 0, 0},
	{0x87c7, 0xb4, 0, 0}, {0x87c8, 0x31, 0, 0}, {0x87c9, 0x07, 0, 0},
	{0x87ca, 0x78, 0, 0}, {0x87cb, 0x50, 0, 0}, {0x87cc, 0x79, 0, 0},
	{0x87cd, 0x50, 0, 0}, {0x87ce, 0x12, 0, 0}, {0x87cf, 0x0c, 0, 0},
	{0x87d0, 0x95, 0, 0}, {0x87d1, 0x90, 0, 0}, {0x87d2, 0x38, 0, 0},
	{0x87d3, 0x14, 0, 0}, {0x87d4, 0xe0, 0, 0}, {0x87d5, 0xb4, 0, 0},
	{0x87d6, 0x71, 0, 0}, {0x87d7, 0x15, 0, 0}, {0x87d8, 0x78, 0, 0},
	{0x87d9, 0x50, 0, 0}, {0x87da, 0xe6, 0, 0}, {0x87db, 0xfe, 0, 0},
	{0x87dc, 0x08, 0, 0}, {0x87dd, 0xe6, 0, 0}, {0x87de, 0x78, 0, 0},
	{0x87df, 0x02, 0, 0}, {0x87e0, 0xce, 0, 0}, {0x87e1, 0xc3, 0, 0},
	{0x87e2, 0x13, 0, 0}, {0x87e3, 0xce, 0, 0}, {0x87e4, 0x13, 0, 0},
	{0x87e5, 0xd8, 0, 0}, {0x87e6, 0xf9, 0, 0}, {0x87e7, 0x79, 0, 0},
	{0x87e8, 0x51, 0, 0}, {0x87e9, 0xf7, 0, 0}, {0x87ea, 0xee, 0, 0},
	{0x87eb, 0x19, 0, 0}, {0x87ec, 0xf7, 0, 0}, {0x87ed, 0x90, 0, 0},
	{0x87ee, 0x38, 0, 0}, {0x87ef, 0x15, 0, 0}, {0x87f0, 0xe0, 0, 0},
	{0x87f1, 0xb4, 0, 0}, {0x87f2, 0x31, 0, 0}, {0x87f3, 0x07, 0, 0},
	{0x87f4, 0x78, 0, 0}, {0x87f5, 0x52, 0, 0}, {0x87f6, 0x79, 0, 0},
	{0x87f7, 0x52, 0, 0}, {0x87f8, 0x12, 0, 0}, {0x87f9, 0x0c, 0, 0},
	{0x87fa, 0x95, 0, 0}, {0x87fb, 0x90, 0, 0}, {0x87fc, 0x38, 0, 0},
	{0x87fd, 0x15, 0, 0}, {0x87fe, 0xe0, 0, 0}, {0x87ff, 0xb4, 0, 0},
	{0x8800, 0x71, 0, 0}, {0x8801, 0x15, 0, 0}, {0x8802, 0x78, 0, 0},
	{0x8803, 0x52, 0, 0}, {0x8804, 0xe6, 0, 0}, {0x8805, 0xfe, 0, 0},
	{0x8806, 0x08, 0, 0}, {0x8807, 0xe6, 0, 0}, {0x8808, 0x78, 0, 0},
	{0x8809, 0x02, 0, 0}, {0x880a, 0xce, 0, 0}, {0x880b, 0xc3, 0, 0},
	{0x880c, 0x13, 0, 0}, {0x880d, 0xce, 0, 0}, {0x880e, 0x13, 0, 0},
	{0x880f, 0xd8, 0, 0}, {0x8810, 0xf9, 0, 0}, {0x8811, 0x79, 0, 0},
	{0x8812, 0x53, 0, 0}, {0x8813, 0xf7, 0, 0}, {0x8814, 0xee, 0, 0},
	{0x8815, 0x19, 0, 0}, {0x8816, 0xf7, 0, 0}, {0x8817, 0x79, 0, 0},
	{0x8818, 0x50, 0, 0}, {0x8819, 0x12, 0, 0}, {0x881a, 0x0c, 0, 0},
	{0x881b, 0x67, 0, 0}, {0x881c, 0x09, 0, 0}, {0x881d, 0x12, 0, 0},
	{0x881e, 0x0c, 0, 0}, {0x881f, 0x67, 0, 0}, {0x8820, 0xaf, 0, 0},
	{0x8821, 0x45, 0, 0}, {0x8822, 0x12, 0, 0}, {0x8823, 0x0c, 0, 0},
	{0x8824, 0x1d, 0, 0}, {0x8825, 0x7d, 0, 0}, {0x8826, 0x50, 0, 0},
	{0x8827, 0x12, 0, 0}, {0x8828, 0x05, 0, 0}, {0x8829, 0x9c, 0, 0},
	{0x882a, 0x78, 0, 0}, {0x882b, 0x58, 0, 0}, {0x882c, 0xa6, 0, 0},
	{0x882d, 0x06, 0, 0}, {0x882e, 0x08, 0, 0}, {0x882f, 0xa6, 0, 0},
	{0x8830, 0x07, 0, 0}, {0x8831, 0xaf, 0, 0}, {0x8832, 0x43, 0, 0},
	{0x8833, 0x12, 0, 0}, {0x8834, 0x0c, 0, 0}, {0x8835, 0x1d, 0, 0},
	{0x8836, 0x7d, 0, 0}, {0x8837, 0x50, 0, 0}, {0x8838, 0x12, 0, 0},
	{0x8839, 0x05, 0, 0}, {0x883a, 0x9c, 0, 0}, {0x883b, 0x78, 0, 0},
	{0x883c, 0x54, 0, 0}, {0x883d, 0xa6, 0, 0}, {0x883e, 0x06, 0, 0},
	{0x883f, 0x08, 0, 0}, {0x8840, 0xa6, 0, 0}, {0x8841, 0x07, 0, 0},
	{0x8842, 0xaf, 0, 0}, {0x8843, 0x46, 0, 0}, {0x8844, 0x78, 0, 0},
	{0x8845, 0x52, 0, 0}, {0x8846, 0x12, 0, 0}, {0x8847, 0x0c, 0, 0},
	{0x8848, 0x1f, 0, 0}, {0x8849, 0x7d, 0, 0}, {0x884a, 0x3c, 0, 0},
	{0x884b, 0x12, 0, 0}, {0x884c, 0x05, 0, 0}, {0x884d, 0x9c, 0, 0},
	{0x884e, 0x78, 0, 0}, {0x884f, 0x5a, 0, 0}, {0x8850, 0xa6, 0, 0},
	{0x8851, 0x06, 0, 0}, {0x8852, 0x08, 0, 0}, {0x8853, 0xa6, 0, 0},
	{0x8854, 0x07, 0, 0}, {0x8855, 0xaf, 0, 0}, {0x8856, 0x44, 0, 0},
	{0x8857, 0x7e, 0, 0}, {0x8858, 0x00, 0, 0}, {0x8859, 0x78, 0, 0},
	{0x885a, 0x52, 0, 0}, {0x885b, 0x12, 0, 0}, {0x885c, 0x0c, 0, 0},
	{0x885d, 0x21, 0, 0}, {0x885e, 0x7d, 0, 0}, {0x885f, 0x3c, 0, 0},
	{0x8860, 0x12, 0, 0}, {0x8861, 0x05, 0, 0}, {0x8862, 0x9c, 0, 0},
	{0x8863, 0x78, 0, 0}, {0x8864, 0x56, 0, 0}, {0x8865, 0xa6, 0, 0},
	{0x8866, 0x06, 0, 0}, {0x8867, 0x08, 0, 0}, {0x8868, 0xa6, 0, 0},
	{0x8869, 0x07, 0, 0}, {0x886a, 0xc3, 0, 0}, {0x886b, 0x78, 0, 0},
	{0x886c, 0x59, 0, 0}, {0x886d, 0xe6, 0, 0}, {0x886e, 0x94, 0, 0},
	{0x886f, 0x08, 0, 0}, {0x8870, 0x18, 0, 0}, {0x8871, 0xe6, 0, 0},
	{0x8872, 0x94, 0, 0}, {0x8873, 0x00, 0, 0}, {0x8874, 0x50, 0, 0},
	{0x8875, 0x05, 0, 0}, {0x8876, 0x76, 0, 0}, {0x8877, 0x00, 0, 0},
	{0x8878, 0x08, 0, 0}, {0x8879, 0x76, 0, 0}, {0x887a, 0x08, 0, 0},
	{0x887b, 0xc3, 0, 0}, {0x887c, 0x78, 0, 0}, {0x887d, 0x5b, 0, 0},
	{0x887e, 0xe6, 0, 0}, {0x887f, 0x94, 0, 0}, {0x8880, 0x08, 0, 0},
	{0x8881, 0x18, 0, 0}, {0x8882, 0xe6, 0, 0}, {0x8883, 0x94, 0, 0},
	{0x8884, 0x00, 0, 0}, {0x8885, 0x50, 0, 0}, {0x8886, 0x05, 0, 0},
	{0x8887, 0x76, 0, 0}, {0x8888, 0x00, 0, 0}, {0x8889, 0x08, 0, 0},
	{0x888a, 0x76, 0, 0}, {0x888b, 0x08, 0, 0}, {0x888c, 0x78, 0, 0},
	{0x888d, 0x58, 0, 0}, {0x888e, 0x12, 0, 0}, {0x888f, 0x0c, 0, 0},
	{0x8890, 0x54, 0, 0}, {0x8891, 0xff, 0, 0}, {0x8892, 0xd3, 0, 0},
	{0x8893, 0x78, 0, 0}, {0x8894, 0x55, 0, 0}, {0x8895, 0xe6, 0, 0},
	{0x8896, 0x9f, 0, 0}, {0x8897, 0x18, 0, 0}, {0x8898, 0xe6, 0, 0},
	{0x8899, 0x9e, 0, 0}, {0x889a, 0x40, 0, 0}, {0x889b, 0x0e, 0, 0},
	{0x889c, 0x78, 0, 0}, {0x889d, 0x58, 0, 0}, {0x889e, 0xe6, 0, 0},
	{0x889f, 0x13, 0, 0}, {0x88a0, 0xfe, 0, 0}, {0x88a1, 0x08, 0, 0},
	{0x88a2, 0xe6, 0, 0}, {0x88a3, 0x78, 0, 0}, {0x88a4, 0x55, 0, 0},
	{0x88a5, 0x12, 0, 0}, {0x88a6, 0x0c, 0, 0}, {0x88a7, 0x8a, 0, 0},
	{0x88a8, 0x80, 0, 0}, {0x88a9, 0x04, 0, 0}, {0x88aa, 0x7e, 0, 0},
	{0x88ab, 0x00, 0, 0}, {0x88ac, 0x7f, 0, 0}, {0x88ad, 0x00, 0, 0},
	{0x88ae, 0x78, 0, 0}, {0x88af, 0x5c, 0, 0}, {0x88b0, 0x12, 0, 0},
	{0x88b1, 0x0c, 0, 0}, {0x88b2, 0x4c, 0, 0}, {0x88b3, 0xff, 0, 0},
	{0x88b4, 0xd3, 0, 0}, {0x88b5, 0x78, 0, 0}, {0x88b6, 0x57, 0, 0},
	{0x88b7, 0xe6, 0, 0}, {0x88b8, 0x9f, 0, 0}, {0x88b9, 0x18, 0, 0},
	{0x88ba, 0xe6, 0, 0}, {0x88bb, 0x9e, 0, 0}, {0x88bc, 0x40, 0, 0},
	{0x88bd, 0x0e, 0, 0}, {0x88be, 0x78, 0, 0}, {0x88bf, 0x5a, 0, 0},
	{0x88c0, 0xe6, 0, 0}, {0x88c1, 0x13, 0, 0}, {0x88c2, 0xfe, 0, 0},
	{0x88c3, 0x08, 0, 0}, {0x88c4, 0xe6, 0, 0}, {0x88c5, 0x78, 0, 0},
	{0x88c6, 0x57, 0, 0}, {0x88c7, 0x12, 0, 0}, {0x88c8, 0x0c, 0, 0},
	{0x88c9, 0x8a, 0, 0}, {0x88ca, 0x80, 0, 0}, {0x88cb, 0x04, 0, 0},
	{0x88cc, 0x7e, 0, 0}, {0x88cd, 0x00, 0, 0}, {0x88ce, 0x7f, 0, 0},
	{0x88cf, 0x00, 0, 0}, {0x88d0, 0xe4, 0, 0}, {0x88d1, 0xfc, 0, 0},
	{0x88d2, 0xfd, 0, 0}, {0x88d3, 0x78, 0, 0}, {0x88d4, 0x60, 0, 0},
	{0x88d5, 0x12, 0, 0}, {0x88d6, 0x07, 0, 0}, {0x88d7, 0x4f, 0, 0},
	{0x88d8, 0x78, 0, 0}, {0x88d9, 0x58, 0, 0}, {0x88da, 0x12, 0, 0},
	{0x88db, 0x0c, 0, 0}, {0x88dc, 0x54, 0, 0}, {0x88dd, 0x78, 0, 0},
	{0x88de, 0x55, 0, 0}, {0x88df, 0x26, 0, 0}, {0x88e0, 0xff, 0, 0},
	{0x88e1, 0xee, 0, 0}, {0x88e2, 0x18, 0, 0}, {0x88e3, 0x36, 0, 0},
	{0x88e4, 0xfe, 0, 0}, {0x88e5, 0x78, 0, 0}, {0x88e6, 0x64, 0, 0},
	{0x88e7, 0x12, 0, 0}, {0x88e8, 0x0c, 0, 0}, {0x88e9, 0x4c, 0, 0},
	{0x88ea, 0x78, 0, 0}, {0x88eb, 0x57, 0, 0}, {0x88ec, 0x26, 0, 0},
	{0x88ed, 0xff, 0, 0}, {0x88ee, 0xee, 0, 0}, {0x88ef, 0x18, 0, 0},
	{0x88f0, 0x36, 0, 0}, {0x88f1, 0xfe, 0, 0}, {0x88f2, 0xe4, 0, 0},
	{0x88f3, 0xfc, 0, 0}, {0x88f4, 0xfd, 0, 0}, {0x88f5, 0x78, 0, 0},
	{0x88f6, 0x68, 0, 0}, {0x88f7, 0x12, 0, 0}, {0x88f8, 0x07, 0, 0},
	{0x88f9, 0x4f, 0, 0}, {0x88fa, 0x12, 0, 0}, {0x88fb, 0x0c, 0, 0},
	{0x88fc, 0x5c, 0, 0}, {0x88fd, 0x78, 0, 0}, {0x88fe, 0x64, 0, 0},
	{0x88ff, 0x12, 0, 0}, {0x8900, 0x07, 0, 0}, {0x8901, 0x42, 0, 0},
	{0x8902, 0xd3, 0, 0}, {0x8903, 0x12, 0, 0}, {0x8904, 0x07, 0, 0},
	{0x8905, 0x0e, 0, 0}, {0x8906, 0x40, 0, 0}, {0x8907, 0x08, 0, 0},
	{0x8908, 0x12, 0, 0}, {0x8909, 0x0c, 0, 0}, {0x890a, 0x5c, 0, 0},
	{0x890b, 0x78, 0, 0}, {0x890c, 0x64, 0, 0}, {0x890d, 0x12, 0, 0},
	{0x890e, 0x07, 0, 0}, {0x890f, 0x4f, 0, 0}, {0x8910, 0x78, 0, 0},
	{0x8911, 0x52, 0, 0}, {0x8912, 0x12, 0, 0}, {0x8913, 0x0c, 0, 0},
	{0x8914, 0x5e, 0, 0}, {0x8915, 0x78, 0, 0}, {0x8916, 0x68, 0, 0},
	{0x8917, 0x12, 0, 0}, {0x8918, 0x07, 0, 0}, {0x8919, 0x42, 0, 0},
	{0x891a, 0xd3, 0, 0}, {0x891b, 0x12, 0, 0}, {0x891c, 0x07, 0, 0},
	{0x891d, 0x0e, 0, 0}, {0x891e, 0x40, 0, 0}, {0x891f, 0x0a, 0, 0},
	{0x8920, 0x78, 0, 0}, {0x8921, 0x52, 0, 0}, {0x8922, 0x12, 0, 0},
	{0x8923, 0x0c, 0, 0}, {0x8924, 0x5e, 0, 0}, {0x8925, 0x78, 0, 0},
	{0x8926, 0x68, 0, 0}, {0x8927, 0x12, 0, 0}, {0x8928, 0x07, 0, 0},
	{0x8929, 0x4f, 0, 0}, {0x892a, 0xe4, 0, 0}, {0x892b, 0xfd, 0, 0},
	{0x892c, 0x78, 0, 0}, {0x892d, 0x5f, 0, 0}, {0x892e, 0x12, 0, 0},
	{0x892f, 0x0c, 0, 0}, {0x8930, 0x77, 0, 0}, {0x8931, 0x24, 0, 0},
	{0x8932, 0x01, 0, 0}, {0x8933, 0x12, 0, 0}, {0x8934, 0x0c, 0, 0},
	{0x8935, 0x40, 0, 0}, {0x8936, 0x78, 0, 0}, {0x8937, 0x63, 0, 0},
	{0x8938, 0x12, 0, 0}, {0x8939, 0x0c, 0, 0}, {0x893a, 0x77, 0, 0},
	{0x893b, 0x24, 0, 0}, {0x893c, 0x02, 0, 0}, {0x893d, 0x12, 0, 0},
	{0x893e, 0x0c, 0, 0}, {0x893f, 0x40, 0, 0}, {0x8940, 0x78, 0, 0},
	{0x8941, 0x67, 0, 0}, {0x8942, 0x12, 0, 0}, {0x8943, 0x0c, 0, 0},
	{0x8944, 0x77, 0, 0}, {0x8945, 0x24, 0, 0}, {0x8946, 0x03, 0, 0},
	{0x8947, 0x12, 0, 0}, {0x8948, 0x0c, 0, 0}, {0x8949, 0x40, 0, 0},
	{0x894a, 0x78, 0, 0}, {0x894b, 0x6b, 0, 0}, {0x894c, 0x12, 0, 0},
	{0x894d, 0x0c, 0, 0}, {0x894e, 0x77, 0, 0}, {0x894f, 0x24, 0, 0},
	{0x8950, 0x04, 0, 0}, {0x8951, 0x12, 0, 0}, {0x8952, 0x0c, 0, 0},
	{0x8953, 0x40, 0, 0}, {0x8954, 0x0d, 0, 0}, {0x8955, 0xbd, 0, 0},
	{0x8956, 0x05, 0, 0}, {0x8957, 0xd4, 0, 0}, {0x8958, 0xc2, 0, 0},
	{0x8959, 0x0e, 0, 0}, {0x895a, 0xc2, 0, 0}, {0x895b, 0x06, 0, 0},
	{0x895c, 0x22, 0, 0}, {0x895d, 0x85, 0, 0}, {0x895e, 0x08, 0, 0},
	{0x895f, 0x41, 0, 0}, {0x8960, 0x90, 0, 0}, {0x8961, 0x30, 0, 0},
	{0x8962, 0x24, 0, 0}, {0x8963, 0xe0, 0, 0}, {0x8964, 0xf5, 0, 0},
	{0x8965, 0x3d, 0, 0}, {0x8966, 0xa3, 0, 0}, {0x8967, 0xe0, 0, 0},
	{0x8968, 0xf5, 0, 0}, {0x8969, 0x3e, 0, 0}, {0x896a, 0xa3, 0, 0},
	{0x896b, 0xe0, 0, 0}, {0x896c, 0xf5, 0, 0}, {0x896d, 0x3f, 0, 0},
	{0x896e, 0xa3, 0, 0}, {0x896f, 0xe0, 0, 0}, {0x8970, 0xf5, 0, 0},
	{0x8971, 0x40, 0, 0}, {0x8972, 0xa3, 0, 0}, {0x8973, 0xe0, 0, 0},
	{0x8974, 0xf5, 0, 0}, {0x8975, 0x3c, 0, 0}, {0x8976, 0xd2, 0, 0},
	{0x8977, 0x33, 0, 0}, {0x8978, 0xe5, 0, 0}, {0x8979, 0x41, 0, 0},
	{0x897a, 0x12, 0, 0}, {0x897b, 0x07, 0, 0}, {0x897c, 0x67, 0, 0},
	{0x897d, 0x09, 0, 0}, {0x897e, 0xb4, 0, 0}, {0x897f, 0x03, 0, 0},
	{0x8980, 0x09, 0, 0}, {0x8981, 0xb8, 0, 0}, {0x8982, 0x04, 0, 0},
	{0x8983, 0x09, 0, 0}, {0x8984, 0xbe, 0, 0}, {0x8985, 0x05, 0, 0},
	{0x8986, 0x09, 0, 0}, {0x8987, 0xc1, 0, 0}, {0x8988, 0x06, 0, 0},
	{0x8989, 0x09, 0, 0}, {0x898a, 0xc4, 0, 0}, {0x898b, 0x07, 0, 0},
	{0x898c, 0x09, 0, 0}, {0x898d, 0xcd, 0, 0}, {0x898e, 0x08, 0, 0},
	{0x898f, 0x09, 0, 0}, {0x8990, 0xde, 0, 0}, {0x8991, 0x12, 0, 0},
	{0x8992, 0x09, 0, 0}, {0x8993, 0xe0, 0, 0}, {0x8994, 0x80, 0, 0},
	{0x8995, 0x09, 0, 0}, {0x8996, 0xe5, 0, 0}, {0x8997, 0x81, 0, 0},
	{0x8998, 0x0a, 0, 0}, {0x8999, 0x43, 0, 0}, {0x899a, 0x8f, 0, 0},
	{0x899b, 0x0a, 0, 0}, {0x899c, 0x32, 0, 0}, {0x899d, 0x90, 0, 0},
	{0x899e, 0x0a, 0, 0}, {0x899f, 0x43, 0, 0}, {0x89a0, 0x91, 0, 0},
	{0x89a1, 0x0a, 0, 0}, {0x89a2, 0x43, 0, 0}, {0x89a3, 0x92, 0, 0},
	{0x89a4, 0x0a, 0, 0}, {0x89a5, 0x43, 0, 0}, {0x89a6, 0x93, 0, 0},
	{0x89a7, 0x0a, 0, 0}, {0x89a8, 0x43, 0, 0}, {0x89a9, 0x94, 0, 0},
	{0x89aa, 0x0a, 0, 0}, {0x89ab, 0x43, 0, 0}, {0x89ac, 0x98, 0, 0},
	{0x89ad, 0x0a, 0, 0}, {0x89ae, 0x40, 0, 0}, {0x89af, 0x9f, 0, 0},
	{0x89b0, 0x00, 0, 0}, {0x89b1, 0x00, 0, 0}, {0x89b2, 0x0a, 0, 0},
	{0x89b3, 0x5e, 0, 0}, {0x89b4, 0x12, 0, 0}, {0x89b5, 0x0e, 0, 0},
	{0x89b6, 0xce, 0, 0}, {0x89b7, 0x22, 0, 0}, {0x89b8, 0x12, 0, 0},
	{0x89b9, 0x0e, 0, 0}, {0x89ba, 0xce, 0, 0}, {0x89bb, 0xd2, 0, 0},
	{0x89bc, 0x03, 0, 0}, {0x89bd, 0x22, 0, 0}, {0x89be, 0xd2, 0, 0},
	{0x89bf, 0x03, 0, 0}, {0x89c0, 0x22, 0, 0}, {0x89c1, 0xc2, 0, 0},
	{0x89c2, 0x03, 0, 0}, {0x89c3, 0x22, 0, 0}, {0x89c4, 0xa2, 0, 0},
	{0x89c5, 0x36, 0, 0}, {0x89c6, 0xe4, 0, 0}, {0x89c7, 0x33, 0, 0},
	{0x89c8, 0xf5, 0, 0}, {0x89c9, 0x3c, 0, 0}, {0x89ca, 0x02, 0, 0},
	{0x89cb, 0x0a, 0, 0}, {0x89cc, 0x43, 0, 0}, {0x89cd, 0xc2, 0, 0},
	{0x89ce, 0x01, 0, 0}, {0x89cf, 0xc2, 0, 0}, {0x89d0, 0x02, 0, 0},
	{0x89d1, 0xc2, 0, 0}, {0x89d2, 0x03, 0, 0}, {0x89d3, 0x12, 0, 0},
	{0x89d4, 0x0d, 0, 0}, {0x89d5, 0x14, 0, 0}, {0x89d6, 0x75, 0, 0},
	{0x89d7, 0x1e, 0, 0}, {0x89d8, 0x70, 0, 0}, {0x89d9, 0xd2, 0, 0},
	{0x89da, 0x34, 0, 0}, {0x89db, 0x02, 0, 0}, {0x89dc, 0x0a, 0, 0},
	{0x89dd, 0x43, 0, 0}, {0x89de, 0x80, 0, 0}, {0x89df, 0x4d, 0, 0},
	{0x89e0, 0x12, 0, 0}, {0x89e1, 0x0f, 0, 0}, {0x89e2, 0x17, 0, 0},
	{0x89e3, 0x80, 0, 0}, {0x89e4, 0x5e, 0, 0}, {0x89e5, 0x85, 0, 0},
	{0x89e6, 0x3d, 0, 0}, {0x89e7, 0x43, 0, 0}, {0x89e8, 0x85, 0, 0},
	{0x89e9, 0x3e, 0, 0}, {0x89ea, 0x44, 0, 0}, {0x89eb, 0xe5, 0, 0},
	{0x89ec, 0x45, 0, 0}, {0x89ed, 0xc3, 0, 0}, {0x89ee, 0x13, 0, 0},
	{0x89ef, 0xff, 0, 0}, {0x89f0, 0xe5, 0, 0}, {0x89f1, 0x43, 0, 0},
	{0x89f2, 0xc3, 0, 0}, {0x89f3, 0x9f, 0, 0}, {0x89f4, 0x50, 0, 0},
	{0x89f5, 0x02, 0, 0}, {0x89f6, 0x8f, 0, 0}, {0x89f7, 0x43, 0, 0},
	{0x89f8, 0xe5, 0, 0}, {0x89f9, 0x46, 0, 0}, {0x89fa, 0xc3, 0, 0},
	{0x89fb, 0x13, 0, 0}, {0x89fc, 0xff, 0, 0}, {0x89fd, 0xe5, 0, 0},
	{0x89fe, 0x44, 0, 0}, {0x89ff, 0xc3, 0, 0}, {0x8a00, 0x9f, 0, 0},
	{0x8a01, 0x50, 0, 0}, {0x8a02, 0x02, 0, 0}, {0x8a03, 0x8f, 0, 0},
	{0x8a04, 0x44, 0, 0}, {0x8a05, 0xe5, 0, 0}, {0x8a06, 0x45, 0, 0},
	{0x8a07, 0xc3, 0, 0}, {0x8a08, 0x13, 0, 0}, {0x8a09, 0xff, 0, 0},
	{0x8a0a, 0xfd, 0, 0}, {0x8a0b, 0xe5, 0, 0}, {0x8a0c, 0x43, 0, 0},
	{0x8a0d, 0x90, 0, 0}, {0x8a0e, 0x0e, 0, 0}, {0x8a0f, 0x7f, 0, 0},
	{0x8a10, 0x12, 0, 0}, {0x8a11, 0x0e, 0, 0}, {0x8a12, 0xea, 0, 0},
	{0x8a13, 0x40, 0, 0}, {0x8a14, 0x04, 0, 0}, {0x8a15, 0xee, 0, 0},
	{0x8a16, 0x9f, 0, 0}, {0x8a17, 0xf5, 0, 0}, {0x8a18, 0x43, 0, 0},
	{0x8a19, 0xe5, 0, 0}, {0x8a1a, 0x46, 0, 0}, {0x8a1b, 0xc3, 0, 0},
	{0x8a1c, 0x13, 0, 0}, {0x8a1d, 0xff, 0, 0}, {0x8a1e, 0xfd, 0, 0},
	{0x8a1f, 0xe5, 0, 0}, {0x8a20, 0x44, 0, 0}, {0x8a21, 0x90, 0, 0},
	{0x8a22, 0x0e, 0, 0}, {0x8a23, 0x80, 0, 0}, {0x8a24, 0x12, 0, 0},
	{0x8a25, 0x0e, 0, 0}, {0x8a26, 0xea, 0, 0}, {0x8a27, 0x40, 0, 0},
	{0x8a28, 0x04, 0, 0}, {0x8a29, 0xee, 0, 0}, {0x8a2a, 0x9f, 0, 0},
	{0x8a2b, 0xf5, 0, 0}, {0x8a2c, 0x44, 0, 0}, {0x8a2d, 0x12, 0, 0},
	{0x8a2e, 0x07, 0, 0}, {0x8a2f, 0x8d, 0, 0}, {0x8a30, 0x80, 0, 0},
	{0x8a31, 0x11, 0, 0}, {0x8a32, 0x85, 0, 0}, {0x8a33, 0x40, 0, 0},
	{0x8a34, 0x46, 0, 0}, {0x8a35, 0x85, 0, 0}, {0x8a36, 0x3f, 0, 0},
	{0x8a37, 0x45, 0, 0}, {0x8a38, 0x85, 0, 0}, {0x8a39, 0x3e, 0, 0},
	{0x8a3a, 0x44, 0, 0}, {0x8a3b, 0x85, 0, 0}, {0x8a3c, 0x3d, 0, 0},
	{0x8a3d, 0x43, 0, 0}, {0x8a3e, 0x80, 0, 0}, {0x8a3f, 0x03, 0, 0},
	{0x8a40, 0x02, 0, 0}, {0x8a41, 0x07, 0, 0}, {0x8a42, 0x8d, 0, 0},
	{0x8a43, 0x90, 0, 0}, {0x8a44, 0x30, 0, 0}, {0x8a45, 0x24, 0, 0},
	{0x8a46, 0xe5, 0, 0}, {0x8a47, 0x3d, 0, 0}, {0x8a48, 0xf0, 0, 0},
	{0x8a49, 0xa3, 0, 0}, {0x8a4a, 0xe5, 0, 0}, {0x8a4b, 0x3e, 0, 0},
	{0x8a4c, 0xf0, 0, 0}, {0x8a4d, 0xa3, 0, 0}, {0x8a4e, 0xe5, 0, 0},
	{0x8a4f, 0x3f, 0, 0}, {0x8a50, 0xf0, 0, 0}, {0x8a51, 0xa3, 0, 0},
	{0x8a52, 0xe5, 0, 0}, {0x8a53, 0x40, 0, 0}, {0x8a54, 0xf0, 0, 0},
	{0x8a55, 0xa3, 0, 0}, {0x8a56, 0xe5, 0, 0}, {0x8a57, 0x3c, 0, 0},
	{0x8a58, 0xf0, 0, 0}, {0x8a59, 0x90, 0, 0}, {0x8a5a, 0x30, 0, 0},
	{0x8a5b, 0x23, 0, 0}, {0x8a5c, 0xe4, 0, 0}, {0x8a5d, 0xf0, 0, 0},
	{0x8a5e, 0x22, 0, 0}, {0x8a5f, 0xc0, 0, 0}, {0x8a60, 0xe0, 0, 0},
	{0x8a61, 0xc0, 0, 0}, {0x8a62, 0x83, 0, 0}, {0x8a63, 0xc0, 0, 0},
	{0x8a64, 0x82, 0, 0}, {0x8a65, 0xc0, 0, 0}, {0x8a66, 0xd0, 0, 0},
	{0x8a67, 0x90, 0, 0}, {0x8a68, 0x3f, 0, 0}, {0x8a69, 0x0c, 0, 0},
	{0x8a6a, 0xe0, 0, 0}, {0x8a6b, 0xf5, 0, 0}, {0x8a6c, 0x32, 0, 0},
	{0x8a6d, 0xe5, 0, 0}, {0x8a6e, 0x32, 0, 0}, {0x8a6f, 0x30, 0, 0},
	{0x8a70, 0xe3, 0, 0}, {0x8a71, 0x4c, 0, 0}, {0x8a72, 0x30, 0, 0},
	{0x8a73, 0x35, 0, 0}, {0x8a74, 0x3e, 0, 0}, {0x8a75, 0x90, 0, 0},
	{0x8a76, 0x60, 0, 0}, {0x8a77, 0x19, 0, 0}, {0x8a78, 0xe0, 0, 0},
	{0x8a79, 0xf5, 0, 0}, {0x8a7a, 0x0a, 0, 0}, {0x8a7b, 0xa3, 0, 0},
	{0x8a7c, 0xe0, 0, 0}, {0x8a7d, 0xf5, 0, 0}, {0x8a7e, 0x0b, 0, 0},
	{0x8a7f, 0x90, 0, 0}, {0x8a80, 0x60, 0, 0}, {0x8a81, 0x1d, 0, 0},
	{0x8a82, 0xe0, 0, 0}, {0x8a83, 0xf5, 0, 0}, {0x8a84, 0x14, 0, 0},
	{0x8a85, 0xa3, 0, 0}, {0x8a86, 0xe0, 0, 0}, {0x8a87, 0xf5, 0, 0},
	{0x8a88, 0x15, 0, 0}, {0x8a89, 0x30, 0, 0}, {0x8a8a, 0x01, 0, 0},
	{0x8a8b, 0x06, 0, 0}, {0x8a8c, 0x30, 0, 0}, {0x8a8d, 0x32, 0, 0},
	{0x8a8e, 0x03, 0, 0}, {0x8a8f, 0xd3, 0, 0}, {0x8a90, 0x80, 0, 0},
	{0x8a91, 0x01, 0, 0}, {0x8a92, 0xc3, 0, 0}, {0x8a93, 0x92, 0, 0},
	{0x8a94, 0x09, 0, 0}, {0x8a95, 0x30, 0, 0}, {0x8a96, 0x02, 0, 0},
	{0x8a97, 0x06, 0, 0}, {0x8a98, 0x30, 0, 0}, {0x8a99, 0x32, 0, 0},
	{0x8a9a, 0x03, 0, 0}, {0x8a9b, 0xd3, 0, 0}, {0x8a9c, 0x80, 0, 0},
	{0x8a9d, 0x01, 0, 0}, {0x8a9e, 0xc3, 0, 0}, {0x8a9f, 0x92, 0, 0},
	{0x8aa0, 0x0a, 0, 0}, {0x8aa1, 0x30, 0, 0}, {0x8aa2, 0x32, 0, 0},
	{0x8aa3, 0x0c, 0, 0}, {0x8aa4, 0x30, 0, 0}, {0x8aa5, 0x03, 0, 0},
	{0x8aa6, 0x09, 0, 0}, {0x8aa7, 0x20, 0, 0}, {0x8aa8, 0x02, 0, 0},
	{0x8aa9, 0x06, 0, 0}, {0x8aaa, 0x20, 0, 0}, {0x8aab, 0x01, 0, 0},
	{0x8aac, 0x03, 0, 0}, {0x8aad, 0xd3, 0, 0}, {0x8aae, 0x80, 0, 0},
	{0x8aaf, 0x01, 0, 0}, {0x8ab0, 0xc3, 0, 0}, {0x8ab1, 0x92, 0, 0},
	{0x8ab2, 0x0b, 0, 0}, {0x8ab3, 0x90, 0, 0}, {0x8ab4, 0x30, 0, 0},
	{0x8ab5, 0x01, 0, 0}, {0x8ab6, 0xe0, 0, 0}, {0x8ab7, 0x44, 0, 0},
	{0x8ab8, 0x40, 0, 0}, {0x8ab9, 0xf0, 0, 0}, {0x8aba, 0xe0, 0, 0},
	{0x8abb, 0x54, 0, 0}, {0x8abc, 0xbf, 0, 0}, {0x8abd, 0xf0, 0, 0},
	{0x8abe, 0xe5, 0, 0}, {0x8abf, 0x32, 0, 0}, {0x8ac0, 0x30, 0, 0},
	{0x8ac1, 0xe1, 0, 0}, {0x8ac2, 0x14, 0, 0}, {0x8ac3, 0x30, 0, 0},
	{0x8ac4, 0x33, 0, 0}, {0x8ac5, 0x11, 0, 0}, {0x8ac6, 0x90, 0, 0},
	{0x8ac7, 0x30, 0, 0}, {0x8ac8, 0x22, 0, 0}, {0x8ac9, 0xe0, 0, 0},
	{0x8aca, 0xf5, 0, 0}, {0x8acb, 0x08, 0, 0}, {0x8acc, 0xe4, 0, 0},
	{0x8acd, 0xf0, 0, 0}, {0x8ace, 0x30, 0, 0}, {0x8acf, 0x00, 0, 0},
	{0x8ad0, 0x03, 0, 0}, {0x8ad1, 0xd3, 0, 0}, {0x8ad2, 0x80, 0, 0},
	{0x8ad3, 0x01, 0, 0}, {0x8ad4, 0xc3, 0, 0}, {0x8ad5, 0x92, 0, 0},
	{0x8ad6, 0x08, 0, 0}, {0x8ad7, 0xe5, 0, 0}, {0x8ad8, 0x32, 0, 0},
	{0x8ad9, 0x30, 0, 0}, {0x8ada, 0xe5, 0, 0}, {0x8adb, 0x12, 0, 0},
	{0x8adc, 0x90, 0, 0}, {0x8add, 0x56, 0, 0}, {0x8ade, 0xa1, 0, 0},
	{0x8adf, 0xe0, 0, 0}, {0x8ae0, 0xf5, 0, 0}, {0x8ae1, 0x09, 0, 0},
	{0x8ae2, 0x30, 0, 0}, {0x8ae3, 0x30, 0, 0}, {0x8ae4, 0x09, 0, 0},
	{0x8ae5, 0x30, 0, 0}, {0x8ae6, 0x05, 0, 0}, {0x8ae7, 0x03, 0, 0},
	{0x8ae8, 0xd3, 0, 0}, {0x8ae9, 0x80, 0, 0}, {0x8aea, 0x01, 0, 0},
	{0x8aeb, 0xc3, 0, 0}, {0x8aec, 0x92, 0, 0}, {0x8aed, 0x0d, 0, 0},
	{0x8aee, 0x90, 0, 0}, {0x8aef, 0x3f, 0, 0}, {0x8af0, 0x0c, 0, 0},
	{0x8af1, 0xe5, 0, 0}, {0x8af2, 0x32, 0, 0}, {0x8af3, 0xf0, 0, 0},
	{0x8af4, 0xd0, 0, 0}, {0x8af5, 0xd0, 0, 0}, {0x8af6, 0xd0, 0, 0},
	{0x8af7, 0x82, 0, 0}, {0x8af8, 0xd0, 0, 0}, {0x8af9, 0x83, 0, 0},
	{0x8afa, 0xd0, 0, 0}, {0x8afb, 0xe0, 0, 0}, {0x8afc, 0x32, 0, 0},
	{0x8afd, 0x90, 0, 0}, {0x8afe, 0x0e, 0, 0}, {0x8aff, 0x7d, 0, 0},
	{0x8b00, 0xe4, 0, 0}, {0x8b01, 0x93, 0, 0}, {0x8b02, 0xfe, 0, 0},
	{0x8b03, 0x74, 0, 0}, {0x8b04, 0x01, 0, 0}, {0x8b05, 0x93, 0, 0},
	{0x8b06, 0xff, 0, 0}, {0x8b07, 0xc3, 0, 0}, {0x8b08, 0x90, 0, 0},
	{0x8b09, 0x0e, 0, 0}, {0x8b0a, 0x7b, 0, 0}, {0x8b0b, 0x74, 0, 0},
	{0x8b0c, 0x01, 0, 0}, {0x8b0d, 0x93, 0, 0}, {0x8b0e, 0x9f, 0, 0},
	{0x8b0f, 0xff, 0, 0}, {0x8b10, 0xe4, 0, 0}, {0x8b11, 0x93, 0, 0},
	{0x8b12, 0x9e, 0, 0}, {0x8b13, 0xfe, 0, 0}, {0x8b14, 0xe4, 0, 0},
	{0x8b15, 0x8f, 0, 0}, {0x8b16, 0x3b, 0, 0}, {0x8b17, 0x8e, 0, 0},
	{0x8b18, 0x3a, 0, 0}, {0x8b19, 0xf5, 0, 0}, {0x8b1a, 0x39, 0, 0},
	{0x8b1b, 0xf5, 0, 0}, {0x8b1c, 0x38, 0, 0}, {0x8b1d, 0xab, 0, 0},
	{0x8b1e, 0x3b, 0, 0}, {0x8b1f, 0xaa, 0, 0}, {0x8b20, 0x3a, 0, 0},
	{0x8b21, 0xa9, 0, 0}, {0x8b22, 0x39, 0, 0}, {0x8b23, 0xa8, 0, 0},
	{0x8b24, 0x38, 0, 0}, {0x8b25, 0xaf, 0, 0}, {0x8b26, 0x49, 0, 0},
	{0x8b27, 0xfc, 0, 0}, {0x8b28, 0xfd, 0, 0}, {0x8b29, 0xfe, 0, 0},
	{0x8b2a, 0x12, 0, 0}, {0x8b2b, 0x05, 0, 0}, {0x8b2c, 0xf1, 0, 0},
	{0x8b2d, 0x12, 0, 0}, {0x8b2e, 0x0e, 0, 0}, {0x8b2f, 0xfc, 0, 0},
	{0x8b30, 0xe4, 0, 0}, {0x8b31, 0x7b, 0, 0}, {0x8b32, 0xff, 0, 0},
	{0x8b33, 0xfa, 0, 0}, {0x8b34, 0xf9, 0, 0}, {0x8b35, 0xf8, 0, 0},
	{0x8b36, 0x12, 0, 0}, {0x8b37, 0x06, 0, 0}, {0x8b38, 0x7c, 0, 0},
	{0x8b39, 0x12, 0, 0}, {0x8b3a, 0x0e, 0, 0}, {0x8b3b, 0xfc, 0, 0},
	{0x8b3c, 0x90, 0, 0}, {0x8b3d, 0x0e, 0, 0}, {0x8b3e, 0x69, 0, 0},
	{0x8b3f, 0xe4, 0, 0}, {0x8b40, 0x12, 0, 0}, {0x8b41, 0x0f, 0, 0},
	{0x8b42, 0x11, 0, 0}, {0x8b43, 0x12, 0, 0}, {0x8b44, 0x0e, 0, 0},
	{0x8b45, 0xfc, 0, 0}, {0x8b46, 0xe4, 0, 0}, {0x8b47, 0x85, 0, 0},
	{0x8b48, 0x48, 0, 0}, {0x8b49, 0x37, 0, 0}, {0x8b4a, 0xf5, 0, 0},
	{0x8b4b, 0x36, 0, 0}, {0x8b4c, 0xf5, 0, 0}, {0x8b4d, 0x35, 0, 0},
	{0x8b4e, 0xf5, 0, 0}, {0x8b4f, 0x34, 0, 0}, {0x8b50, 0xaf, 0, 0},
	{0x8b51, 0x37, 0, 0}, {0x8b52, 0xae, 0, 0}, {0x8b53, 0x36, 0, 0},
	{0x8b54, 0xad, 0, 0}, {0x8b55, 0x35, 0, 0}, {0x8b56, 0xac, 0, 0},
	{0x8b57, 0x34, 0, 0}, {0x8b58, 0xa3, 0, 0}, {0x8b59, 0x12, 0, 0},
	{0x8b5a, 0x0f, 0, 0}, {0x8b5b, 0x11, 0, 0}, {0x8b5c, 0x8f, 0, 0},
	{0x8b5d, 0x37, 0, 0}, {0x8b5e, 0x8e, 0, 0}, {0x8b5f, 0x36, 0, 0},
	{0x8b60, 0x8d, 0, 0}, {0x8b61, 0x35, 0, 0}, {0x8b62, 0x8c, 0, 0},
	{0x8b63, 0x34, 0, 0}, {0x8b64, 0xe5, 0, 0}, {0x8b65, 0x3b, 0, 0},
	{0x8b66, 0x45, 0, 0}, {0x8b67, 0x37, 0, 0}, {0x8b68, 0xf5, 0, 0},
	{0x8b69, 0x3b, 0, 0}, {0x8b6a, 0xe5, 0, 0}, {0x8b6b, 0x3a, 0, 0},
	{0x8b6c, 0x45, 0, 0}, {0x8b6d, 0x36, 0, 0}, {0x8b6e, 0xf5, 0, 0},
	{0x8b6f, 0x3a, 0, 0}, {0x8b70, 0xe5, 0, 0}, {0x8b71, 0x39, 0, 0},
	{0x8b72, 0x45, 0, 0}, {0x8b73, 0x35, 0, 0}, {0x8b74, 0xf5, 0, 0},
	{0x8b75, 0x39, 0, 0}, {0x8b76, 0xe5, 0, 0}, {0x8b77, 0x38, 0, 0},
	{0x8b78, 0x45, 0, 0}, {0x8b79, 0x34, 0, 0}, {0x8b7a, 0xf5, 0, 0},
	{0x8b7b, 0x38, 0, 0}, {0x8b7c, 0xe4, 0, 0}, {0x8b7d, 0xf5, 0, 0},
	{0x8b7e, 0x22, 0, 0}, {0x8b7f, 0xf5, 0, 0}, {0x8b80, 0x23, 0, 0},
	{0x8b81, 0x85, 0, 0}, {0x8b82, 0x3b, 0, 0}, {0x8b83, 0x31, 0, 0},
	{0x8b84, 0x85, 0, 0}, {0x8b85, 0x3a, 0, 0}, {0x8b86, 0x30, 0, 0},
	{0x8b87, 0x85, 0, 0}, {0x8b88, 0x39, 0, 0}, {0x8b89, 0x2f, 0, 0},
	{0x8b8a, 0x85, 0, 0}, {0x8b8b, 0x38, 0, 0}, {0x8b8c, 0x2e, 0, 0},
	{0x8b8d, 0x02, 0, 0}, {0x8b8e, 0x0d, 0, 0}, {0x8b8f, 0xc5, 0, 0},
	{0x8b90, 0xad, 0, 0}, {0x8b91, 0x39, 0, 0}, {0x8b92, 0xac, 0, 0},
	{0x8b93, 0x38, 0, 0}, {0x8b94, 0xfa, 0, 0}, {0x8b95, 0xf9, 0, 0},
	{0x8b96, 0xf8, 0, 0}, {0x8b97, 0x12, 0, 0}, {0x8b98, 0x05, 0, 0},
	{0x8b99, 0xf1, 0, 0}, {0x8b9a, 0x8f, 0, 0}, {0x8b9b, 0x3b, 0, 0},
	{0x8b9c, 0x8e, 0, 0}, {0x8b9d, 0x3a, 0, 0}, {0x8b9e, 0x8d, 0, 0},
	{0x8b9f, 0x39, 0, 0}, {0x8ba0, 0x8c, 0, 0}, {0x8ba1, 0x38, 0, 0},
	{0x8ba2, 0xab, 0, 0}, {0x8ba3, 0x37, 0, 0}, {0x8ba4, 0xaa, 0, 0},
	{0x8ba5, 0x36, 0, 0}, {0x8ba6, 0xa9, 0, 0}, {0x8ba7, 0x35, 0, 0},
	{0x8ba8, 0xa8, 0, 0}, {0x8ba9, 0x34, 0, 0}, {0x8baa, 0x22, 0, 0},
	{0x8bab, 0xef, 0, 0}, {0x8bac, 0x25, 0, 0}, {0x8bad, 0xe0, 0, 0},
	{0x8bae, 0x24, 0, 0}, {0x8baf, 0x4c, 0, 0}, {0x8bb0, 0xf8, 0, 0},
	{0x8bb1, 0xe6, 0, 0}, {0x8bb2, 0xfc, 0, 0}, {0x8bb3, 0x08, 0, 0},
	{0x8bb4, 0xe6, 0, 0}, {0x8bb5, 0xfd, 0, 0}, {0x8bb6, 0x22, 0, 0},
	{0x8bb7, 0x93, 0, 0}, {0x8bb8, 0xff, 0, 0}, {0x8bb9, 0xe4, 0, 0},
	{0x8bba, 0xfc, 0, 0}, {0x8bbb, 0xfd, 0, 0}, {0x8bbc, 0xfe, 0, 0},
	{0x8bbd, 0x12, 0, 0}, {0x8bbe, 0x05, 0, 0}, {0x8bbf, 0xf1, 0, 0},
	{0x8bc0, 0x8f, 0, 0}, {0x8bc1, 0x37, 0, 0}, {0x8bc2, 0x8e, 0, 0},
	{0x8bc3, 0x36, 0, 0}, {0x8bc4, 0x8d, 0, 0}, {0x8bc5, 0x35, 0, 0},
	{0x8bc6, 0x8c, 0, 0}, {0x8bc7, 0x34, 0, 0}, {0x8bc8, 0x22, 0, 0},
	{0x8bc9, 0xf9, 0, 0}, {0x8bca, 0xc3, 0, 0}, {0x8bcb, 0xe6, 0, 0},
	{0x8bcc, 0x97, 0, 0}, {0x8bcd, 0x18, 0, 0}, {0x8bce, 0xe6, 0, 0},
	{0x8bcf, 0x19, 0, 0}, {0x8bd0, 0x97, 0, 0}, {0x8bd1, 0x22, 0, 0},
	{0x8bd2, 0xff, 0, 0}, {0x8bd3, 0xa6, 0, 0}, {0x8bd4, 0x06, 0, 0},
	{0x8bd5, 0x08, 0, 0}, {0x8bd6, 0xa6, 0, 0}, {0x8bd7, 0x07, 0, 0},
	{0x8bd8, 0x22, 0, 0}, {0x8bd9, 0xe6, 0, 0}, {0x8bda, 0xfe, 0, 0},
	{0x8bdb, 0x08, 0, 0}, {0x8bdc, 0xe6, 0, 0}, {0x8bdd, 0xff, 0, 0},
	{0x8bde, 0xe4, 0, 0}, {0x8bdf, 0x8f, 0, 0}, {0x8be0, 0x37, 0, 0},
	{0x8be1, 0x8e, 0, 0}, {0x8be2, 0x36, 0, 0}, {0x8be3, 0xf5, 0, 0},
	{0x8be4, 0x35, 0, 0}, {0x8be5, 0xf5, 0, 0}, {0x8be6, 0x34, 0, 0},
	{0x8be7, 0x22, 0, 0}, {0x8be8, 0xe6, 0, 0}, {0x8be9, 0xfe, 0, 0},
	{0x8bea, 0x08, 0, 0}, {0x8beb, 0xe6, 0, 0}, {0x8bec, 0xff, 0, 0},
	{0x8bed, 0xe4, 0, 0}, {0x8bee, 0x8f, 0, 0}, {0x8bef, 0x3b, 0, 0},
	{0x8bf0, 0x8e, 0, 0}, {0x8bf1, 0x3a, 0, 0}, {0x8bf2, 0xf5, 0, 0},
	{0x8bf3, 0x39, 0, 0}, {0x8bf4, 0xf5, 0, 0}, {0x8bf5, 0x38, 0, 0},
	{0x8bf6, 0x22, 0, 0}, {0x8bf7, 0xe7, 0, 0}, {0x8bf8, 0x96, 0, 0},
	{0x8bf9, 0xff, 0, 0}, {0x8bfa, 0x19, 0, 0}, {0x8bfb, 0xe7, 0, 0},
	{0x8bfc, 0x18, 0, 0}, {0x8bfd, 0x96, 0, 0}, {0x8bfe, 0x22, 0, 0},
	{0x8bff, 0xff, 0, 0}, {0x8c00, 0xa6, 0, 0}, {0x8c01, 0x06, 0, 0},
	{0x8c02, 0x08, 0, 0}, {0x8c03, 0xa6, 0, 0}, {0x8c04, 0x07, 0, 0},
	{0x8c05, 0x78, 0, 0}, {0x8c06, 0x6c, 0, 0}, {0x8c07, 0xe6, 0, 0},
	{0x8c08, 0xfe, 0, 0}, {0x8c09, 0x08, 0, 0}, {0x8c0a, 0xe6, 0, 0},
	{0x8c0b, 0x22, 0, 0}, {0x8c0c, 0x78, 0, 0}, {0x8c0d, 0x4c, 0, 0},
	{0x8c0e, 0xe6, 0, 0}, {0x8c0f, 0xfe, 0, 0}, {0x8c10, 0x08, 0, 0},
	{0x8c11, 0xe6, 0, 0}, {0x8c12, 0x22, 0, 0}, {0x8c13, 0x78, 0, 0},
	{0x8c14, 0xa7, 0, 0}, {0x8c15, 0xef, 0, 0}, {0x8c16, 0x26, 0, 0},
	{0x8c17, 0xf6, 0, 0}, {0x8c18, 0x18, 0, 0}, {0x8c19, 0xe4, 0, 0},
	{0x8c1a, 0x36, 0, 0}, {0x8c1b, 0xf6, 0, 0}, {0x8c1c, 0x22, 0, 0},
	{0x8c1d, 0x78, 0, 0}, {0x8c1e, 0x50, 0, 0}, {0x8c1f, 0x7e, 0, 0},
	{0x8c20, 0x00, 0, 0}, {0x8c21, 0xe6, 0, 0}, {0x8c22, 0xfc, 0, 0},
	{0x8c23, 0x08, 0, 0}, {0x8c24, 0xe6, 0, 0}, {0x8c25, 0xfd, 0, 0},
	{0x8c26, 0x12, 0, 0}, {0x8c27, 0x05, 0, 0}, {0x8c28, 0x8a, 0, 0},
	{0x8c29, 0x7c, 0, 0}, {0x8c2a, 0x00, 0, 0}, {0x8c2b, 0x22, 0, 0},
	{0x8c2c, 0xe0, 0, 0}, {0x8c2d, 0xa3, 0, 0}, {0x8c2e, 0xe0, 0, 0},
	{0x8c2f, 0x75, 0, 0}, {0x8c30, 0xf0, 0, 0}, {0x8c31, 0x02, 0, 0},
	{0x8c32, 0xa4, 0, 0}, {0x8c33, 0xff, 0, 0}, {0x8c34, 0xae, 0, 0},
	{0x8c35, 0xf0, 0, 0}, {0x8c36, 0xc3, 0, 0}, {0x8c37, 0x08, 0, 0},
	{0x8c38, 0xe6, 0, 0}, {0x8c39, 0x9f, 0, 0}, {0x8c3a, 0xf6, 0, 0},
	{0x8c3b, 0x18, 0, 0}, {0x8c3c, 0xe6, 0, 0}, {0x8c3d, 0x9e, 0, 0},
	{0x8c3e, 0xf6, 0, 0}, {0x8c3f, 0x22, 0, 0}, {0x8c40, 0xff, 0, 0},
	{0x8c41, 0xe5, 0, 0}, {0x8c42, 0xf0, 0, 0}, {0x8c43, 0x34, 0, 0},
	{0x8c44, 0x60, 0, 0}, {0x8c45, 0x8f, 0, 0}, {0x8c46, 0x82, 0, 0},
	{0x8c47, 0xf5, 0, 0}, {0x8c48, 0x83, 0, 0}, {0x8c49, 0xec, 0, 0},
	{0x8c4a, 0xf0, 0, 0}, {0x8c4b, 0x22, 0, 0}, {0x8c4c, 0xe4, 0, 0},
	{0x8c4d, 0xfc, 0, 0}, {0x8c4e, 0xfd, 0, 0}, {0x8c4f, 0x12, 0, 0},
	{0x8c50, 0x07, 0, 0}, {0x8c51, 0x4f, 0, 0}, {0x8c52, 0x78, 0, 0},
	{0x8c53, 0x5a, 0, 0}, {0x8c54, 0xe6, 0, 0}, {0x8c55, 0xc3, 0, 0},
	{0x8c56, 0x13, 0, 0}, {0x8c57, 0xfe, 0, 0}, {0x8c58, 0x08, 0, 0},
	{0x8c59, 0xe6, 0, 0}, {0x8c5a, 0x13, 0, 0}, {0x8c5b, 0x22, 0, 0},
	{0x8c5c, 0x78, 0, 0}, {0x8c5d, 0x50, 0, 0}, {0x8c5e, 0xe6, 0, 0},
	{0x8c5f, 0xfe, 0, 0}, {0x8c60, 0x08, 0, 0}, {0x8c61, 0xe6, 0, 0},
	{0x8c62, 0xff, 0, 0}, {0x8c63, 0xe4, 0, 0}, {0x8c64, 0xfc, 0, 0},
	{0x8c65, 0xfd, 0, 0}, {0x8c66, 0x22, 0, 0}, {0x8c67, 0xe7, 0, 0},
	{0x8c68, 0xc4, 0, 0}, {0x8c69, 0xf8, 0, 0}, {0x8c6a, 0x54, 0, 0},
	{0x8c6b, 0xf0, 0, 0}, {0x8c6c, 0xc8, 0, 0}, {0x8c6d, 0x68, 0, 0},
	{0x8c6e, 0xf7, 0, 0}, {0x8c6f, 0x09, 0, 0}, {0x8c70, 0xe7, 0, 0},
	{0x8c71, 0xc4, 0, 0}, {0x8c72, 0x54, 0, 0}, {0x8c73, 0x0f, 0, 0},
	{0x8c74, 0x48, 0, 0}, {0x8c75, 0xf7, 0, 0}, {0x8c76, 0x22, 0, 0},
	{0x8c77, 0xe6, 0, 0}, {0x8c78, 0xfc, 0, 0}, {0x8c79, 0xed, 0, 0},
	{0x8c7a, 0x75, 0, 0}, {0x8c7b, 0xf0, 0, 0}, {0x8c7c, 0x04, 0, 0},
	{0x8c7d, 0xa4, 0, 0}, {0x8c7e, 0x22, 0, 0}, {0x8c7f, 0xe0, 0, 0},
	{0x8c80, 0xfe, 0, 0}, {0x8c81, 0xa3, 0, 0}, {0x8c82, 0xe0, 0, 0},
	{0x8c83, 0xfd, 0, 0}, {0x8c84, 0xee, 0, 0}, {0x8c85, 0xf6, 0, 0},
	{0x8c86, 0xed, 0, 0}, {0x8c87, 0x08, 0, 0}, {0x8c88, 0xf6, 0, 0},
	{0x8c89, 0x22, 0, 0}, {0x8c8a, 0x13, 0, 0}, {0x8c8b, 0xff, 0, 0},
	{0x8c8c, 0xc3, 0, 0}, {0x8c8d, 0xe6, 0, 0}, {0x8c8e, 0x9f, 0, 0},
	{0x8c8f, 0xff, 0, 0}, {0x8c90, 0x18, 0, 0}, {0x8c91, 0xe6, 0, 0},
	{0x8c92, 0x9e, 0, 0}, {0x8c93, 0xfe, 0, 0}, {0x8c94, 0x22, 0, 0},
	{0x8c95, 0xe6, 0, 0}, {0x8c96, 0xc3, 0, 0}, {0x8c97, 0x13, 0, 0},
	{0x8c98, 0xf7, 0, 0}, {0x8c99, 0x08, 0, 0}, {0x8c9a, 0xe6, 0, 0},
	{0x8c9b, 0x13, 0, 0}, {0x8c9c, 0x09, 0, 0}, {0x8c9d, 0xf7, 0, 0},
	{0x8c9e, 0x22, 0, 0}, {0x8c9f, 0x75, 0, 0}, {0x8ca0, 0x89, 0, 0},
	{0x8ca1, 0x03, 0, 0}, {0x8ca2, 0x75, 0, 0}, {0x8ca3, 0xa8, 0, 0},
	{0x8ca4, 0x01, 0, 0}, {0x8ca5, 0x75, 0, 0}, {0x8ca6, 0xb8, 0, 0},
	{0x8ca7, 0x04, 0, 0}, {0x8ca8, 0x75, 0, 0}, {0x8ca9, 0x34, 0, 0},
	{0x8caa, 0xff, 0, 0}, {0x8cab, 0x75, 0, 0}, {0x8cac, 0x35, 0, 0},
	{0x8cad, 0x0e, 0, 0}, {0x8cae, 0x75, 0, 0}, {0x8caf, 0x36, 0, 0},
	{0x8cb0, 0x15, 0, 0}, {0x8cb1, 0x75, 0, 0}, {0x8cb2, 0x37, 0, 0},
	{0x8cb3, 0x0d, 0, 0}, {0x8cb4, 0x12, 0, 0}, {0x8cb5, 0x0d, 0, 0},
	{0x8cb6, 0x85, 0, 0}, {0x8cb7, 0x12, 0, 0}, {0x8cb8, 0x00, 0, 0},
	{0x8cb9, 0x09, 0, 0}, {0x8cba, 0x12, 0, 0}, {0x8cbb, 0x0f, 0, 0},
	{0x8cbc, 0x17, 0, 0}, {0x8cbd, 0x12, 0, 0}, {0x8cbe, 0x00, 0, 0},
	{0x8cbf, 0x06, 0, 0}, {0x8cc0, 0xd2, 0, 0}, {0x8cc1, 0x00, 0, 0},
	{0x8cc2, 0xd2, 0, 0}, {0x8cc3, 0x33, 0, 0}, {0x8cc4, 0xd2, 0, 0},
	{0x8cc5, 0xaf, 0, 0}, {0x8cc6, 0x75, 0, 0}, {0x8cc7, 0x34, 0, 0},
	{0x8cc8, 0xff, 0, 0}, {0x8cc9, 0x75, 0, 0}, {0x8cca, 0x35, 0, 0},
	{0x8ccb, 0x0e, 0, 0}, {0x8ccc, 0x75, 0, 0}, {0x8ccd, 0x36, 0, 0},
	{0x8cce, 0x49, 0, 0}, {0x8ccf, 0x75, 0, 0}, {0x8cd0, 0x37, 0, 0},
	{0x8cd1, 0x03, 0, 0}, {0x8cd2, 0x12, 0, 0}, {0x8cd3, 0x0d, 0, 0},
	{0x8cd4, 0x85, 0, 0}, {0x8cd5, 0x30, 0, 0}, {0x8cd6, 0x08, 0, 0},
	{0x8cd7, 0x09, 0, 0}, {0x8cd8, 0xc2, 0, 0}, {0x8cd9, 0x33, 0, 0},
	{0x8cda, 0x12, 0, 0}, {0x8cdb, 0x09, 0, 0}, {0x8cdc, 0x5d, 0, 0},
	{0x8cdd, 0xc2, 0, 0}, {0x8cde, 0x08, 0, 0}, {0x8cdf, 0xd2, 0, 0},
	{0x8ce0, 0x33, 0, 0}, {0x8ce1, 0x30, 0, 0}, {0x8ce2, 0x0b, 0, 0},
	{0x8ce3, 0x09, 0, 0}, {0x8ce4, 0xc2, 0, 0}, {0x8ce5, 0x35, 0, 0},
	{0x8ce6, 0x12, 0, 0}, {0x8ce7, 0x00, 0, 0}, {0x8ce8, 0x0e, 0, 0},
	{0x8ce9, 0xc2, 0, 0}, {0x8cea, 0x0b, 0, 0}, {0x8ceb, 0xd2, 0, 0},
	{0x8cec, 0x35, 0, 0}, {0x8ced, 0x30, 0, 0}, {0x8cee, 0x09, 0, 0},
	{0x8cef, 0x09, 0, 0}, {0x8cf0, 0xc2, 0, 0}, {0x8cf1, 0x35, 0, 0},
	{0x8cf2, 0x12, 0, 0}, {0x8cf3, 0x03, 0, 0}, {0x8cf4, 0x0a, 0, 0},
	{0x8cf5, 0xc2, 0, 0}, {0x8cf6, 0x09, 0, 0}, {0x8cf7, 0xd2, 0, 0},
	{0x8cf8, 0x35, 0, 0}, {0x8cf9, 0x30, 0, 0}, {0x8cfa, 0x0e, 0, 0},
	{0x8cfb, 0x03, 0, 0}, {0x8cfc, 0x12, 0, 0}, {0x8cfd, 0x07, 0, 0},
	{0x8cfe, 0x8d, 0, 0}, {0x8cff, 0x30, 0, 0}, {0x8d00, 0x34, 0, 0},
	{0x8d01, 0xd3, 0, 0}, {0x8d02, 0x90, 0, 0}, {0x8d03, 0x30, 0, 0},
	{0x8d04, 0x29, 0, 0}, {0x8d05, 0xe5, 0, 0}, {0x8d06, 0x1e, 0, 0},
	{0x8d07, 0xf0, 0, 0}, {0x8d08, 0xb4, 0, 0}, {0x8d09, 0x10, 0, 0},
	{0x8d0a, 0x05, 0, 0}, {0x8d0b, 0x90, 0, 0}, {0x8d0c, 0x30, 0, 0},
	{0x8d0d, 0x23, 0, 0}, {0x8d0e, 0xe4, 0, 0}, {0x8d0f, 0xf0, 0, 0},
	{0x8d10, 0xc2, 0, 0}, {0x8d11, 0x34, 0, 0}, {0x8d12, 0x80, 0, 0},
	{0x8d13, 0xc1, 0, 0}, {0x8d14, 0xe4, 0, 0}, {0x8d15, 0xf5, 0, 0},
	{0x8d16, 0x49, 0, 0}, {0x8d17, 0x90, 0, 0}, {0x8d18, 0x0e, 0, 0},
	{0x8d19, 0x77, 0, 0}, {0x8d1a, 0x93, 0, 0}, {0x8d1b, 0xff, 0, 0},
	{0x8d1c, 0xe4, 0, 0}, {0x8d1d, 0x8f, 0, 0}, {0x8d1e, 0x37, 0, 0},
	{0x8d1f, 0xf5, 0, 0}, {0x8d20, 0x36, 0, 0}, {0x8d21, 0xf5, 0, 0},
	{0x8d22, 0x35, 0, 0}, {0x8d23, 0xf5, 0, 0}, {0x8d24, 0x34, 0, 0},
	{0x8d25, 0xaf, 0, 0}, {0x8d26, 0x37, 0, 0}, {0x8d27, 0xae, 0, 0},
	{0x8d28, 0x36, 0, 0}, {0x8d29, 0xad, 0, 0}, {0x8d2a, 0x35, 0, 0},
	{0x8d2b, 0xac, 0, 0}, {0x8d2c, 0x34, 0, 0}, {0x8d2d, 0x90, 0, 0},
	{0x8d2e, 0x0e, 0, 0}, {0x8d2f, 0x6a, 0, 0}, {0x8d30, 0x12, 0, 0},
	{0x8d31, 0x0f, 0, 0}, {0x8d32, 0x11, 0, 0}, {0x8d33, 0x8f, 0, 0},
	{0x8d34, 0x37, 0, 0}, {0x8d35, 0x8e, 0, 0}, {0x8d36, 0x36, 0, 0},
	{0x8d37, 0x8d, 0, 0}, {0x8d38, 0x35, 0, 0}, {0x8d39, 0x8c, 0, 0},
	{0x8d3a, 0x34, 0, 0}, {0x8d3b, 0x90, 0, 0}, {0x8d3c, 0x0e, 0, 0},
	{0x8d3d, 0x72, 0, 0}, {0x8d3e, 0x12, 0, 0}, {0x8d3f, 0x07, 0, 0},
	{0x8d40, 0x32, 0, 0}, {0x8d41, 0xef, 0, 0}, {0x8d42, 0x45, 0, 0},
	{0x8d43, 0x37, 0, 0}, {0x8d44, 0xf5, 0, 0}, {0x8d45, 0x37, 0, 0},
	{0x8d46, 0xee, 0, 0}, {0x8d47, 0x45, 0, 0}, {0x8d48, 0x36, 0, 0},
	{0x8d49, 0xf5, 0, 0}, {0x8d4a, 0x36, 0, 0}, {0x8d4b, 0xed, 0, 0},
	{0x8d4c, 0x45, 0, 0}, {0x8d4d, 0x35, 0, 0}, {0x8d4e, 0xf5, 0, 0},
	{0x8d4f, 0x35, 0, 0}, {0x8d50, 0xec, 0, 0}, {0x8d51, 0x45, 0, 0},
	{0x8d52, 0x34, 0, 0}, {0x8d53, 0xf5, 0, 0}, {0x8d54, 0x34, 0, 0},
	{0x8d55, 0xe4, 0, 0}, {0x8d56, 0xf5, 0, 0}, {0x8d57, 0x22, 0, 0},
	{0x8d58, 0xf5, 0, 0}, {0x8d59, 0x23, 0, 0}, {0x8d5a, 0x85, 0, 0},
	{0x8d5b, 0x37, 0, 0}, {0x8d5c, 0x31, 0, 0}, {0x8d5d, 0x85, 0, 0},
	{0x8d5e, 0x36, 0, 0}, {0x8d5f, 0x30, 0, 0}, {0x8d60, 0x85, 0, 0},
	{0x8d61, 0x35, 0, 0}, {0x8d62, 0x2f, 0, 0}, {0x8d63, 0x85, 0, 0},
	{0x8d64, 0x34, 0, 0}, {0x8d65, 0x2e, 0, 0}, {0x8d66, 0x12, 0, 0},
	{0x8d67, 0x0d, 0, 0}, {0x8d68, 0xc5, 0, 0}, {0x8d69, 0xe4, 0, 0},
	{0x8d6a, 0xf5, 0, 0}, {0x8d6b, 0x22, 0, 0}, {0x8d6c, 0xf5, 0, 0},
	{0x8d6d, 0x23, 0, 0}, {0x8d6e, 0x90, 0, 0}, {0x8d6f, 0x0e, 0, 0},
	{0x8d70, 0x72, 0, 0}, {0x8d71, 0x12, 0, 0}, {0x8d72, 0x0f, 0, 0},
	{0x8d73, 0x05, 0, 0}, {0x8d74, 0x12, 0, 0}, {0x8d75, 0x0d, 0, 0},
	{0x8d76, 0xc5, 0, 0}, {0x8d77, 0xe4, 0, 0}, {0x8d78, 0xf5, 0, 0},
	{0x8d79, 0x22, 0, 0}, {0x8d7a, 0xf5, 0, 0}, {0x8d7b, 0x23, 0, 0},
	{0x8d7c, 0x90, 0, 0}, {0x8d7d, 0x0e, 0, 0}, {0x8d7e, 0x6e, 0, 0},
	{0x8d7f, 0x12, 0, 0}, {0x8d80, 0x0f, 0, 0}, {0x8d81, 0x05, 0, 0},
	{0x8d82, 0x02, 0, 0}, {0x8d83, 0x0d, 0, 0}, {0x8d84, 0xc5, 0, 0},
	{0x8d85, 0xae, 0, 0}, {0x8d86, 0x35, 0, 0}, {0x8d87, 0xaf, 0, 0},
	{0x8d88, 0x36, 0, 0}, {0x8d89, 0xe4, 0, 0}, {0x8d8a, 0xfd, 0, 0},
	{0x8d8b, 0xed, 0, 0}, {0x8d8c, 0xc3, 0, 0}, {0x8d8d, 0x95, 0, 0},
	{0x8d8e, 0x37, 0, 0}, {0x8d8f, 0x50, 0, 0}, {0x8d90, 0x33, 0, 0},
	{0x8d91, 0x12, 0, 0}, {0x8d92, 0x0f, 0, 0}, {0x8d93, 0x52, 0, 0},
	{0x8d94, 0xe4, 0, 0}, {0x8d95, 0x93, 0, 0}, {0x8d96, 0xf5, 0, 0},
	{0x8d97, 0x38, 0, 0}, {0x8d98, 0x74, 0, 0}, {0x8d99, 0x01, 0, 0},
	{0x8d9a, 0x93, 0, 0}, {0x8d9b, 0xf5, 0, 0}, {0x8d9c, 0x39, 0, 0},
	{0x8d9d, 0x45, 0, 0}, {0x8d9e, 0x38, 0, 0}, {0x8d9f, 0x60, 0, 0},
	{0x8da0, 0x23, 0, 0}, {0x8da1, 0x85, 0, 0}, {0x8da2, 0x39, 0, 0},
	{0x8da3, 0x82, 0, 0}, {0x8da4, 0x85, 0, 0}, {0x8da5, 0x38, 0, 0},
	{0x8da6, 0x83, 0, 0}, {0x8da7, 0xe0, 0, 0}, {0x8da8, 0xfc, 0, 0},
	{0x8da9, 0x12, 0, 0}, {0x8daa, 0x0f, 0, 0}, {0x8dab, 0x52, 0, 0},
	{0x8dac, 0x74, 0, 0}, {0x8dad, 0x03, 0, 0}, {0x8dae, 0x93, 0, 0},
	{0x8daf, 0x52, 0, 0}, {0x8db0, 0x04, 0, 0}, {0x8db1, 0x12, 0, 0},
	{0x8db2, 0x0f, 0, 0}, {0x8db3, 0x52, 0, 0}, {0x8db4, 0x74, 0, 0},
	{0x8db5, 0x02, 0, 0}, {0x8db6, 0x93, 0, 0}, {0x8db7, 0x42, 0, 0},
	{0x8db8, 0x04, 0, 0}, {0x8db9, 0x85, 0, 0}, {0x8dba, 0x39, 0, 0},
	{0x8dbb, 0x82, 0, 0}, {0x8dbc, 0x85, 0, 0}, {0x8dbd, 0x38, 0, 0},
	{0x8dbe, 0x83, 0, 0}, {0x8dbf, 0xec, 0, 0}, {0x8dc0, 0xf0, 0, 0},
	{0x8dc1, 0x0d, 0, 0}, {0x8dc2, 0x80, 0, 0}, {0x8dc3, 0xc7, 0, 0},
	{0x8dc4, 0x22, 0, 0}, {0x8dc5, 0xa2, 0, 0}, {0x8dc6, 0xaf, 0, 0},
	{0x8dc7, 0x92, 0, 0}, {0x8dc8, 0x31, 0, 0}, {0x8dc9, 0xc2, 0, 0},
	{0x8dca, 0xaf, 0, 0}, {0x8dcb, 0xe5, 0, 0}, {0x8dcc, 0x23, 0, 0},
	{0x8dcd, 0x45, 0, 0}, {0x8dce, 0x22, 0, 0}, {0x8dcf, 0x90, 0, 0},
	{0x8dd0, 0x0e, 0, 0}, {0x8dd1, 0x5d, 0, 0}, {0x8dd2, 0x60, 0, 0},
	{0x8dd3, 0x0b, 0, 0}, {0x8dd4, 0x12, 0, 0}, {0x8dd5, 0x0f, 0, 0},
	{0x8dd6, 0x47, 0, 0}, {0x8dd7, 0xe0, 0, 0}, {0x8dd8, 0xf5, 0, 0},
	{0x8dd9, 0x2c, 0, 0}, {0x8dda, 0xe0, 0, 0}, {0x8ddb, 0xf5, 0, 0},
	{0x8ddc, 0x2d, 0, 0}, {0x8ddd, 0x80, 0, 0}, {0x8dde, 0x0f, 0, 0},
	{0x8ddf, 0x12, 0, 0}, {0x8de0, 0x0f, 0, 0}, {0x8de1, 0x47, 0, 0},
	{0x8de2, 0xe5, 0, 0}, {0x8de3, 0x30, 0, 0}, {0x8de4, 0xf0, 0, 0},
	{0x8de5, 0x90, 0, 0}, {0x8de6, 0x0e, 0, 0}, {0x8de7, 0x5f, 0, 0},
	{0x8de8, 0x12, 0, 0}, {0x8de9, 0x0f, 0, 0}, {0x8dea, 0x47, 0, 0},
	{0x8deb, 0xe5, 0, 0}, {0x8dec, 0x31, 0, 0}, {0x8ded, 0xf0, 0, 0},
	{0x8dee, 0xa2, 0, 0}, {0x8def, 0x31, 0, 0}, {0x8df0, 0x92, 0, 0},
	{0x8df1, 0xaf, 0, 0}, {0x8df2, 0x22, 0, 0}, {0x8df3, 0x78, 0, 0},
	{0x8df4, 0x7f, 0, 0}, {0x8df5, 0xe4, 0, 0}, {0x8df6, 0xf6, 0, 0},
	{0x8df7, 0xd8, 0, 0}, {0x8df8, 0xfd, 0, 0}, {0x8df9, 0x75, 0, 0},
	{0x8dfa, 0x81, 0, 0}, {0x8dfb, 0xcb, 0, 0}, {0x8dfc, 0x02, 0, 0},
	{0x8dfd, 0x0c, 0, 0}, {0x8dfe, 0x9f, 0, 0}, {0x8dff, 0x00, 0, 0},
	{0x8e00, 0x11, 0, 0}, {0x8e01, 0x05, 0, 0}, {0x8e02, 0x25, 0, 0},
	{0x8e03, 0x16, 0, 0}, {0x8e04, 0x33, 0, 0}, {0x8e05, 0x02, 0, 0},
	{0x8e06, 0x50, 0, 0}, {0x8e07, 0x72, 0, 0}, {0x8e08, 0x6f, 0, 0},
	{0x8e09, 0x66, 0, 0}, {0x8e0a, 0x69, 0, 0}, {0x8e0b, 0x74, 0, 0},
	{0x8e0c, 0x20, 0, 0}, {0x8e0d, 0x20, 0, 0}, {0x8e0e, 0x14, 0, 0},
	{0x8e0f, 0x00, 0, 0}, {0x8e10, 0x10, 0, 0}, {0x8e11, 0x00, 0, 0},
	{0x8e12, 0x56, 0, 0}, {0x8e13, 0x40, 0, 0}, {0x8e14, 0x1a, 0, 0},
	{0x8e15, 0x30, 0, 0}, {0x8e16, 0x29, 0, 0}, {0x8e17, 0x7e, 0, 0},
	{0x8e18, 0x00, 0, 0}, {0x8e19, 0x30, 0, 0}, {0x8e1a, 0x04, 0, 0},
	{0x8e1b, 0x20, 0, 0}, {0x8e1c, 0xdf, 0, 0}, {0x8e1d, 0x30, 0, 0},
	{0x8e1e, 0x05, 0, 0}, {0x8e1f, 0x40, 0, 0}, {0x8e20, 0xbf, 0, 0},
	{0x8e21, 0x50, 0, 0}, {0x8e22, 0x03, 0, 0}, {0x8e23, 0x00, 0, 0},
	{0x8e24, 0xfd, 0, 0}, {0x8e25, 0x50, 0, 0}, {0x8e26, 0x27, 0, 0},
	{0x8e27, 0x01, 0, 0}, {0x8e28, 0xfe, 0, 0}, {0x8e29, 0x60, 0, 0},
	{0x8e2a, 0x00, 0, 0}, {0x8e2b, 0x11, 0, 0}, {0x8e2c, 0x00, 0, 0},
	{0x8e2d, 0x3f, 0, 0}, {0x8e2e, 0x05, 0, 0}, {0x8e2f, 0x30, 0, 0},
	{0x8e30, 0x00, 0, 0}, {0x8e31, 0x3f, 0, 0}, {0x8e32, 0x06, 0, 0},
	{0x8e33, 0x22, 0, 0}, {0x8e34, 0x00, 0, 0}, {0x8e35, 0x3f, 0, 0},
	{0x8e36, 0x01, 0, 0}, {0x8e37, 0x2a, 0, 0}, {0x8e38, 0x00, 0, 0},
	{0x8e39, 0x3f, 0, 0}, {0x8e3a, 0x02, 0, 0}, {0x8e3b, 0x00, 0, 0},
	{0x8e3c, 0x00, 0, 0}, {0x8e3d, 0x36, 0, 0}, {0x8e3e, 0x06, 0, 0},
	{0x8e3f, 0x07, 0, 0}, {0x8e40, 0x00, 0, 0}, {0x8e41, 0x3f, 0, 0},
	{0x8e42, 0x0b, 0, 0}, {0x8e43, 0x0f, 0, 0}, {0x8e44, 0xf0, 0, 0},
	{0x8e45, 0x00, 0, 0}, {0x8e46, 0x00, 0, 0}, {0x8e47, 0x00, 0, 0},
	{0x8e48, 0x00, 0, 0}, {0x8e49, 0x30, 0, 0}, {0x8e4a, 0x01, 0, 0},
	{0x8e4b, 0x40, 0, 0}, {0x8e4c, 0xbf, 0, 0}, {0x8e4d, 0x30, 0, 0},
	{0x8e4e, 0x01, 0, 0}, {0x8e4f, 0x00, 0, 0}, {0x8e50, 0xbf, 0, 0},
	{0x8e51, 0x30, 0, 0}, {0x8e52, 0x29, 0, 0}, {0x8e53, 0x70, 0, 0},
	{0x8e54, 0x00, 0, 0}, {0x8e55, 0x3a, 0, 0}, {0x8e56, 0x00, 0, 0},
	{0x8e57, 0x00, 0, 0}, {0x8e58, 0xff, 0, 0}, {0x8e59, 0x3a, 0, 0},
	{0x8e5a, 0x00, 0, 0}, {0x8e5b, 0x00, 0, 0}, {0x8e5c, 0xff, 0, 0},
	{0x8e5d, 0x36, 0, 0}, {0x8e5e, 0x03, 0, 0}, {0x8e5f, 0x36, 0, 0},
	{0x8e60, 0x02, 0, 0}, {0x8e61, 0x41, 0, 0}, {0x8e62, 0x44, 0, 0},
	{0x8e63, 0x58, 0, 0}, {0x8e64, 0x20, 0, 0}, {0x8e65, 0x18, 0, 0},
	{0x8e66, 0x10, 0, 0}, {0x8e67, 0x0a, 0, 0}, {0x8e68, 0x04, 0, 0},
	{0x8e69, 0x04, 0, 0}, {0x8e6a, 0x00, 0, 0}, {0x8e6b, 0x03, 0, 0},
	{0x8e6c, 0xff, 0, 0}, {0x8e6d, 0x64, 0, 0}, {0x8e6e, 0x00, 0, 0},
	{0x8e6f, 0x00, 0, 0}, {0x8e70, 0x80, 0, 0}, {0x8e71, 0x00, 0, 0},
	{0x8e72, 0x00, 0, 0}, {0x8e73, 0x00, 0, 0}, {0x8e74, 0x00, 0, 0},
	{0x8e75, 0x00, 0, 0}, {0x8e76, 0x00, 0, 0}, {0x8e77, 0x02, 0, 0},
	{0x8e78, 0x04, 0, 0}, {0x8e79, 0x06, 0, 0}, {0x8e7a, 0x00, 0, 0},
	{0x8e7b, 0x03, 0, 0}, {0x8e7c, 0x98, 0, 0}, {0x8e7d, 0x00, 0, 0},
	{0x8e7e, 0xcc, 0, 0}, {0x8e7f, 0x50, 0, 0}, {0x8e80, 0x3c, 0, 0},
	{0x8e81, 0x28, 0, 0}, {0x8e82, 0x1e, 0, 0}, {0x8e83, 0x0c, 0, 0},
	{0x8e84, 0x0c, 0, 0}, {0x8e85, 0x00, 0, 0}, {0x8e86, 0x00, 0, 0},
	{0x8e87, 0x10, 0, 0}, {0x8e88, 0x0c, 0, 0}, {0x8e89, 0x10, 0, 0},
	{0x8e8a, 0x04, 0, 0}, {0x8e8b, 0x0c, 0, 0}, {0x8e8c, 0x6e, 0, 0},
	{0x8e8d, 0x06, 0, 0}, {0x8e8e, 0x05, 0, 0}, {0x8e8f, 0x00, 0, 0},
	{0x8e90, 0xa5, 0, 0}, {0x8e91, 0x5a, 0, 0}, {0x8e92, 0x78, 0, 0},
	{0x8e93, 0xbc, 0, 0}, {0x8e94, 0xe6, 0, 0}, {0x8e95, 0xd3, 0, 0},
	{0x8e96, 0x08, 0, 0}, {0x8e97, 0xff, 0, 0}, {0x8e98, 0xe6, 0, 0},
	{0x8e99, 0x64, 0, 0}, {0x8e9a, 0x80, 0, 0}, {0x8e9b, 0xf8, 0, 0},
	{0x8e9c, 0xef, 0, 0}, {0x8e9d, 0x64, 0, 0}, {0x8e9e, 0x80, 0, 0},
	{0x8e9f, 0x98, 0, 0}, {0x8ea0, 0x22, 0, 0}, {0x8ea1, 0x93, 0, 0},
	{0x8ea2, 0xff, 0, 0}, {0x8ea3, 0x7e, 0, 0}, {0x8ea4, 0x00, 0, 0},
	{0x8ea5, 0xe6, 0, 0}, {0x8ea6, 0xfc, 0, 0}, {0x8ea7, 0x08, 0, 0},
	{0x8ea8, 0xe6, 0, 0}, {0x8ea9, 0xfd, 0, 0}, {0x8eaa, 0x12, 0, 0},
	{0x8eab, 0x05, 0, 0}, {0x8eac, 0x8a, 0, 0}, {0x8ead, 0x78, 0, 0},
	{0x8eae, 0xbf, 0, 0}, {0x8eaf, 0xe6, 0, 0}, {0x8eb0, 0xfc, 0, 0},
	{0x8eb1, 0x08, 0, 0}, {0x8eb2, 0xe6, 0, 0}, {0x8eb3, 0xfd, 0, 0},
	{0x8eb4, 0xd3, 0, 0}, {0x8eb5, 0xef, 0, 0}, {0x8eb6, 0x9d, 0, 0},
	{0x8eb7, 0xee, 0, 0}, {0x8eb8, 0x9c, 0, 0}, {0x8eb9, 0x22, 0, 0},
	{0x8eba, 0x78, 0, 0}, {0x8ebb, 0xbb, 0, 0}, {0x8ebc, 0xd3, 0, 0},
	{0x8ebd, 0xe6, 0, 0}, {0x8ebe, 0x64, 0, 0}, {0x8ebf, 0x80, 0, 0},
	{0x8ec0, 0x94, 0, 0}, {0x8ec1, 0x80, 0, 0}, {0x8ec2, 0x22, 0, 0},
	{0x8ec3, 0x25, 0, 0}, {0x8ec4, 0xe0, 0, 0}, {0x8ec5, 0x24, 0, 0},
	{0x8ec6, 0x0a, 0, 0}, {0x8ec7, 0xf8, 0, 0}, {0x8ec8, 0xe6, 0, 0},
	{0x8ec9, 0xfe, 0, 0}, {0x8eca, 0x08, 0, 0}, {0x8ecb, 0xe6, 0, 0},
	{0x8ecc, 0xff, 0, 0}, {0x8ecd, 0x22, 0, 0}, {0x8ece, 0xd2, 0, 0},
	{0x8ecf, 0x01, 0, 0}, {0x8ed0, 0xc2, 0, 0}, {0x8ed1, 0x02, 0, 0},
	{0x8ed2, 0xe4, 0, 0}, {0x8ed3, 0xf5, 0, 0}, {0x8ed4, 0x1f, 0, 0},
	{0x8ed5, 0xf5, 0, 0}, {0x8ed6, 0x1e, 0, 0}, {0x8ed7, 0xd2, 0, 0},
	{0x8ed8, 0x34, 0, 0}, {0x8ed9, 0xd2, 0, 0}, {0x8eda, 0x32, 0, 0},
	{0x8edb, 0xd2, 0, 0}, {0x8edc, 0x35, 0, 0}, {0x8edd, 0xd2, 0, 0},
	{0x8ede, 0x01, 0, 0}, {0x8edf, 0xc2, 0, 0}, {0x8ee0, 0x02, 0, 0},
	{0x8ee1, 0xf5, 0, 0}, {0x8ee2, 0x1f, 0, 0}, {0x8ee3, 0xf5, 0, 0},
	{0x8ee4, 0x1e, 0, 0}, {0x8ee5, 0xd2, 0, 0}, {0x8ee6, 0x34, 0, 0},
	{0x8ee7, 0xd2, 0, 0}, {0x8ee8, 0x32, 0, 0}, {0x8ee9, 0x22, 0, 0},
	{0x8eea, 0x2d, 0, 0}, {0x8eeb, 0xfd, 0, 0}, {0x8eec, 0xe4, 0, 0},
	{0x8eed, 0x33, 0, 0}, {0x8eee, 0xfc, 0, 0}, {0x8eef, 0xe4, 0, 0},
	{0x8ef0, 0x93, 0, 0}, {0x8ef1, 0xfe, 0, 0}, {0x8ef2, 0xfb, 0, 0},
	{0x8ef3, 0xd3, 0, 0}, {0x8ef4, 0xed, 0, 0}, {0x8ef5, 0x9b, 0, 0},
	{0x8ef6, 0x74, 0, 0}, {0x8ef7, 0x80, 0, 0}, {0x8ef8, 0xf8, 0, 0},
	{0x8ef9, 0x6c, 0, 0}, {0x8efa, 0x98, 0, 0}, {0x8efb, 0x22, 0, 0},
	{0x8efc, 0x8f, 0, 0}, {0x8efd, 0x3b, 0, 0}, {0x8efe, 0x8e, 0, 0},
	{0x8eff, 0x3a, 0, 0}, {0x8f00, 0x8d, 0, 0}, {0x8f01, 0x39, 0, 0},
	{0x8f02, 0x8c, 0, 0}, {0x8f03, 0x38, 0, 0}, {0x8f04, 0x22, 0, 0},
	{0x8f05, 0x12, 0, 0}, {0x8f06, 0x07, 0, 0}, {0x8f07, 0x32, 0, 0},
	{0x8f08, 0x8f, 0, 0}, {0x8f09, 0x31, 0, 0}, {0x8f0a, 0x8e, 0, 0},
	{0x8f0b, 0x30, 0, 0}, {0x8f0c, 0x8d, 0, 0}, {0x8f0d, 0x2f, 0, 0},
	{0x8f0e, 0x8c, 0, 0}, {0x8f0f, 0x2e, 0, 0}, {0x8f10, 0x22, 0, 0},
	{0x8f11, 0x93, 0, 0}, {0x8f12, 0xf9, 0, 0}, {0x8f13, 0xf8, 0, 0},
	{0x8f14, 0x02, 0, 0}, {0x8f15, 0x07, 0, 0}, {0x8f16, 0x1f, 0, 0},
	{0x8f17, 0x90, 0, 0}, {0x8f18, 0x0e, 0, 0}, {0x8f19, 0x81, 0, 0},
	{0x8f1a, 0x12, 0, 0}, {0x8f1b, 0x07, 0, 0}, {0x8f1c, 0x32, 0, 0},
	{0x8f1d, 0x8f, 0, 0}, {0x8f1e, 0x46, 0, 0}, {0x8f1f, 0x8e, 0, 0},
	{0x8f20, 0x45, 0, 0}, {0x8f21, 0x8d, 0, 0}, {0x8f22, 0x44, 0, 0},
	{0x8f23, 0x8c, 0, 0}, {0x8f24, 0x43, 0, 0}, {0x8f25, 0xd2, 0, 0},
	{0x8f26, 0x06, 0, 0}, {0x8f27, 0x30, 0, 0}, {0x8f28, 0x06, 0, 0},
	{0x8f29, 0x03, 0, 0}, {0x8f2a, 0xd3, 0, 0}, {0x8f2b, 0x80, 0, 0},
	{0x8f2c, 0x01, 0, 0}, {0x8f2d, 0xc3, 0, 0}, {0x8f2e, 0x92, 0, 0},
	{0x8f2f, 0x0e, 0, 0}, {0x8f30, 0x22, 0, 0}, {0x8f31, 0xc0, 0, 0},
	{0x8f32, 0xe0, 0, 0}, {0x8f33, 0xc0, 0, 0}, {0x8f34, 0x83, 0, 0},
	{0x8f35, 0xc0, 0, 0}, {0x8f36, 0x82, 0, 0}, {0x8f37, 0x90, 0, 0},
	{0x8f38, 0x3f, 0, 0}, {0x8f39, 0x0d, 0, 0}, {0x8f3a, 0xe0, 0, 0},
	{0x8f3b, 0xf5, 0, 0}, {0x8f3c, 0x33, 0, 0}, {0x8f3d, 0xe5, 0, 0},
	{0x8f3e, 0x33, 0, 0}, {0x8f3f, 0xf0, 0, 0}, {0x8f40, 0xd0, 0, 0},
	{0x8f41, 0x82, 0, 0}, {0x8f42, 0xd0, 0, 0}, {0x8f43, 0x83, 0, 0},
	{0x8f44, 0xd0, 0, 0}, {0x8f45, 0xe0, 0, 0}, {0x8f46, 0x32, 0, 0},
	{0x8f47, 0xe4, 0, 0}, {0x8f48, 0x93, 0, 0}, {0x8f49, 0xfe, 0, 0},
	{0x8f4a, 0x74, 0, 0}, {0x8f4b, 0x01, 0, 0}, {0x8f4c, 0x93, 0, 0},
	{0x8f4d, 0xf5, 0, 0}, {0x8f4e, 0x82, 0, 0}, {0x8f4f, 0x8e, 0, 0},
	{0x8f50, 0x83, 0, 0}, {0x8f51, 0x22, 0, 0}, {0x8f52, 0x8f, 0, 0},
	{0x8f53, 0x82, 0, 0}, {0x8f54, 0x8e, 0, 0}, {0x8f55, 0x83, 0, 0},
	{0x8f56, 0x75, 0, 0}, {0x8f57, 0xf0, 0, 0}, {0x8f58, 0x04, 0, 0},
	{0x8f59, 0xed, 0, 0}, {0x8f5a, 0x02, 0, 0}, {0x8f5b, 0x07, 0, 0},
	{0x8f5c, 0x5b, 0, 0}, {0x3022, 0x00, 0, 0}, {0x3023, 0x00, 0, 0},
	{0x3024, 0x00, 0, 0}, {0x3025, 0x00, 0, 0}, {0x3026, 0x00, 0, 0},
	{0x3027, 0x00, 0, 0}, {0x3028, 0x00, 0, 0}, {0x3029, 0xFF, 0, 0},
	{0x3000, 0x00, 0, 0}, {0x3004, 0xFF, 0, 0},
};

static struct ov5640_mode_info ov5640_mode_info_data[2][ov5640_mode_MAX + 1] = {
	{
		{ov5640_mode_VGA_640_480, SUBSAMPLING, 640,  480,
		ov5640_setting_15fps_VGA_640_480,
		ARRAY_SIZE(ov5640_setting_15fps_VGA_640_480)},
		{ov5640_mode_QVGA_320_240, SUBSAMPLING, 320,  240,
		ov5640_setting_15fps_QVGA_320_240,
		ARRAY_SIZE(ov5640_setting_15fps_QVGA_320_240)},
		{ov5640_mode_NTSC_720_480, SUBSAMPLING, 720, 480,
		ov5640_setting_15fps_NTSC_720_480,
		ARRAY_SIZE(ov5640_setting_15fps_NTSC_720_480)},
		{ov5640_mode_PAL_720_576, SUBSAMPLING, 720, 576,
		ov5640_setting_15fps_PAL_720_576,
		ARRAY_SIZE(ov5640_setting_15fps_PAL_720_576)},
		{ov5640_mode_720P_1280_720, SUBSAMPLING, 1280, 720,
		ov5640_setting_15fps_720P_1280_720,
		ARRAY_SIZE(ov5640_setting_15fps_720P_1280_720)},
		{ov5640_mode_1080P_1920_1080, SCALING, 1920, 1080,
		ov5640_setting_15fps_1080P_1920_1080,
		ARRAY_SIZE(ov5640_setting_15fps_1080P_1920_1080)},
		{ov5640_mode_QSXGA_2592_1944, SCALING, 2592, 1944,
		ov5640_setting_15fps_QSXGA_2592_1944,
		ARRAY_SIZE(ov5640_setting_15fps_QSXGA_2592_1944)},
		{ov5640_mode_QCIF_176_144, SUBSAMPLING, 176, 144,
		ov5640_setting_15fps_QCIF_176_144,
		ARRAY_SIZE(ov5640_setting_15fps_QCIF_176_144)},
		{ov5640_mode_XGA_1024_768, SUBSAMPLING, 1024, 768,
		ov5640_setting_15fps_XGA_1024_768,
		ARRAY_SIZE(ov5640_setting_15fps_XGA_1024_768)},
	},
	{
		{ov5640_mode_VGA_640_480, SUBSAMPLING, 640,  480,
		ov5640_setting_30fps_VGA_640_480,
		ARRAY_SIZE(ov5640_setting_30fps_VGA_640_480)},
		{ov5640_mode_QVGA_320_240, SUBSAMPLING, 320,  240,
		ov5640_setting_30fps_QVGA_320_240,
		ARRAY_SIZE(ov5640_setting_30fps_QVGA_320_240)},
		{ov5640_mode_NTSC_720_480, SUBSAMPLING, 720, 480,
		ov5640_setting_30fps_NTSC_720_480,
		ARRAY_SIZE(ov5640_setting_30fps_NTSC_720_480)},
		{ov5640_mode_PAL_720_576, SUBSAMPLING, 720, 576,
		ov5640_setting_30fps_PAL_720_576,
		ARRAY_SIZE(ov5640_setting_30fps_PAL_720_576)},
		{ov5640_mode_720P_1280_720, SUBSAMPLING, 1280, 720,
		ov5640_setting_30fps_720P_1280_720,
		ARRAY_SIZE(ov5640_setting_30fps_720P_1280_720)},
		{ov5640_mode_1080P_1920_1080, SCALING, 1920, 1080,
		ov5640_setting_30fps_1080P_1920_1080,
		ARRAY_SIZE(ov5640_setting_30fps_1080P_1920_1080)},
		{ov5640_mode_QSXGA_2592_1944, -1, 0, 0, NULL, 0},
		{ov5640_mode_QCIF_176_144, SUBSAMPLING, 176, 144,
		ov5640_setting_30fps_QCIF_176_144,
		ARRAY_SIZE(ov5640_setting_30fps_QCIF_176_144)},
		{ov5640_mode_XGA_1024_768, SUBSAMPLING, 1024, 768,
		ov5640_setting_30fps_XGA_1024_768,
		ARRAY_SIZE(ov5640_setting_30fps_XGA_1024_768)},
	},
};

static struct regulator *io_regulator;
static struct regulator *core_regulator;
static struct regulator *analog_regulator;
static struct regulator *gpo_regulator;

static int ov5640_probe(struct i2c_client *adapter,
				const struct i2c_device_id *device_id);
static int ov5640_remove(struct i2c_client *client);

static s32 ov5640_read_reg(u16 reg, u8 *val);
static s32 ov5640_write_reg(u16 reg, u8 val);

#ifdef CONFIG_OF
static const struct of_device_id ov5640_of_match[] = {
	{ .compatible = "ovti,ov564x_mipi",
	},
	{ /* sentinel */ }
};

MODULE_DEVICE_TABLE(of, ov5640_of_match);
#endif

static const struct i2c_device_id ov5640_id[] = {
	{"ov564x_mipi", 0},
	{},
};

MODULE_DEVICE_TABLE(i2c, ov5640_id);

static struct i2c_driver ov5640_i2c_driver = {
	.driver = {
		  .owner = THIS_MODULE,
		  .name  = "ov564x_mipi",
#ifdef CONFIG_OF
		  .of_match_table = of_match_ptr(ov5640_of_match),
#endif
		  },
	.probe  = ov5640_probe,
	.remove = ov5640_remove,
	.id_table = ov5640_id,
};

static void ov5640_standby(s32 enable)
{
	if (enable)
		gpio_set_value(pwn_gpio, 1);
	else
		gpio_set_value(pwn_gpio, 0);

	msleep(100);
}

static void ov5640_reset(void)
{
	/* camera reset */
	gpio_set_value(rst_gpio, 1);

	/* camera power dowmn */
	gpio_set_value(pwn_gpio, 1);
	msleep(5);

	gpio_set_value(pwn_gpio, 0);
	msleep(5);

	gpio_set_value(rst_gpio, 0);
	msleep(1);

	gpio_set_value(rst_gpio, 1);
	msleep(5);

	gpio_set_value(pwn_gpio, 1);
}

static int ov5640_power_on(struct device *dev)
{
	int ret = 0;

	io_regulator = devm_regulator_get(dev, "DOVDD");
	if (!IS_ERR(io_regulator)) {
		regulator_set_voltage(io_regulator,
				      OV5640_VOLTAGE_DIGITAL_IO,
				      OV5640_VOLTAGE_DIGITAL_IO);
		ret = regulator_enable(io_regulator);
		if (ret) {
			pr_err("%s:io set voltage error\n", __func__);
			return ret;
		} else {
			dev_dbg(dev,
				"%s:io set voltage ok\n", __func__);
		}
	} else {
		pr_err("%s: cannot get io voltage error\n", __func__);
		io_regulator = NULL;
	}

	core_regulator = devm_regulator_get(dev, "DVDD");
	if (!IS_ERR(core_regulator)) {
		regulator_set_voltage(core_regulator,
				      OV5640_VOLTAGE_DIGITAL_CORE,
				      OV5640_VOLTAGE_DIGITAL_CORE);
		ret = regulator_enable(core_regulator);
		if (ret) {
			pr_err("%s:core set voltage error\n", __func__);
			return ret;
		} else {
			dev_dbg(dev,
				"%s:core set voltage ok\n", __func__);
		}
	} else {
		core_regulator = NULL;
		pr_err("%s: cannot get core voltage error\n", __func__);
	}

	analog_regulator = devm_regulator_get(dev, "AVDD");
	if (!IS_ERR(analog_regulator)) {
		regulator_set_voltage(analog_regulator,
				      OV5640_VOLTAGE_ANALOG,
				      OV5640_VOLTAGE_ANALOG);
		ret = regulator_enable(analog_regulator);
		if (ret) {
			pr_err("%s:analog set voltage error\n",
				__func__);
			return ret;
		} else {
			dev_dbg(dev,
				"%s:analog set voltage ok\n", __func__);
		}
	} else {
		analog_regulator = NULL;
		pr_err("%s: cannot get analog voltage error\n", __func__);
	}

	return ret;
}

static void ov5640_power_off(void)
{
	if (analog_regulator)
		regulator_disable(analog_regulator);

	if (core_regulator)
		regulator_disable(core_regulator);

	if (io_regulator)
		regulator_disable(io_regulator);

	if (gpo_regulator)
		regulator_disable(gpo_regulator);
}

static s32 ov5640_write_reg(u16 reg, u8 val)
{
	u8 au8Buf[3] = {0};

	au8Buf[0] = reg >> 8;
	au8Buf[1] = reg & 0xff;
	au8Buf[2] = val;

	if (i2c_master_send(ov5640_data.i2c_client, au8Buf, 3) < 0) {
		pr_err("%s:write reg error:reg=%x,val=%x\n",
			__func__, reg, val);
		return -1;
	}

	return 0;
}

static s32 ov5640_read_reg(u16 reg, u8 *val)
{
	u8 au8RegBuf[2] = {0};
	u8 u8RdVal = 0;

	au8RegBuf[0] = reg >> 8;
	au8RegBuf[1] = reg & 0xff;

	if (2 != i2c_master_send(ov5640_data.i2c_client, au8RegBuf, 2)) {
		pr_err("%s:write reg error:reg=%x\n",
				__func__, reg);
		return -1;
	}

	if (1 != i2c_master_recv(ov5640_data.i2c_client, &u8RdVal, 1)) {
		pr_err("%s:read reg error:reg=%x,val=%x\n",
				__func__, reg, u8RdVal);
		return -1;
	}

	*val = u8RdVal;

	return u8RdVal;
}

static int prev_sysclk, prev_HTS;
static int AE_low, AE_high, AE_Target = 52;

static void OV5640_stream_on(void)
{
	ov5640_write_reg(0x4202, 0x00);
}

static void OV5640_stream_off(void)
{
	ov5640_write_reg(0x4202, 0x0f);
}


static int OV5640_get_sysclk(void)
{
	 /* calculate sysclk */
	int xvclk = ov5640_data.mclk / 10000;
	int temp1, temp2;
	int Multiplier, PreDiv, VCO, SysDiv, Pll_rdiv;
	int Bit_div2x = 1, sclk_rdiv, sysclk;
	u8 temp;

	int sclk_rdiv_map[] = {1, 2, 4, 8};

	temp1 = ov5640_read_reg(0x3034, &temp);
	temp2 = temp1 & 0x0f;
	if (temp2 == 8 || temp2 == 10)
		Bit_div2x = temp2 / 2;

	temp1 = ov5640_read_reg(0x3035, &temp);
	SysDiv = temp1>>4;
	if (SysDiv == 0)
		SysDiv = 16;

	temp1 = ov5640_read_reg(0x3036, &temp);
	Multiplier = temp1;

	temp1 = ov5640_read_reg(0x3037, &temp);
	PreDiv = temp1 & 0x0f;
	Pll_rdiv = ((temp1 >> 4) & 0x01) + 1;

	temp1 = ov5640_read_reg(0x3108, &temp);
	temp2 = temp1 & 0x03;
	sclk_rdiv = sclk_rdiv_map[temp2];

	VCO = xvclk * Multiplier / PreDiv;

	sysclk = VCO / SysDiv / Pll_rdiv * 2 / Bit_div2x / sclk_rdiv;

	return sysclk;
}

static void OV5640_set_night_mode(void)
{
	 /* read HTS from register settings */
	u8 mode;

	ov5640_read_reg(0x3a00, &mode);
	mode &= 0xfb;
	ov5640_write_reg(0x3a00, mode);
}

static int OV5640_get_HTS(void)
{
	 /* read HTS from register settings */
	int HTS;
	u8 temp;

	HTS = ov5640_read_reg(0x380c, &temp);
	HTS = (HTS<<8) + ov5640_read_reg(0x380d, &temp);

	return HTS;
}

static int OV5640_get_VTS(void)
{
	 /* read VTS from register settings */
	int VTS;
	u8 temp;

	/* total vertical size[15:8] high byte */
	VTS = ov5640_read_reg(0x380e, &temp);

	VTS = (VTS<<8) + ov5640_read_reg(0x380f, &temp);

	return VTS;
}

static int OV5640_set_VTS(int VTS)
{
	 /* write VTS to registers */
	 int temp;

	 temp = VTS & 0xff;
	 ov5640_write_reg(0x380f, temp);

	 temp = VTS>>8;
	 ov5640_write_reg(0x380e, temp);

	 return 0;
}

static int OV5640_get_shutter(void)
{
	 /* read shutter, in number of line period */
	int shutter;
	u8 temp;

	shutter = (ov5640_read_reg(0x03500, &temp) & 0x0f);
	shutter = (shutter<<8) + ov5640_read_reg(0x3501, &temp);
	shutter = (shutter<<4) + (ov5640_read_reg(0x3502, &temp)>>4);

	 return shutter;
}

static int OV5640_set_shutter(int shutter)
{
	 /* write shutter, in number of line period */
	 int temp;

	 shutter = shutter & 0xffff;

	 temp = shutter & 0x0f;
	 temp = temp<<4;
	 ov5640_write_reg(0x3502, temp);

	 temp = shutter & 0xfff;
	 temp = temp>>4;
	 ov5640_write_reg(0x3501, temp);

	 temp = shutter>>12;
	 ov5640_write_reg(0x3500, temp);

	 return 0;
}

static int OV5640_get_gain16(void)
{
	 /* read gain, 16 = 1x */
	int gain16;
	u8 temp;

	gain16 = ov5640_read_reg(0x350a, &temp) & 0x03;
	gain16 = (gain16<<8) + ov5640_read_reg(0x350b, &temp);

	return gain16;
}

static int OV5640_set_gain16(int gain16)
{
	/* write gain, 16 = 1x */
	u8 temp;
	gain16 = gain16 & 0x3ff;

	temp = gain16 & 0xff;
	ov5640_write_reg(0x350b, temp);

	temp = gain16>>8;
	ov5640_write_reg(0x350a, temp);

	return 0;
}

static int OV5640_get_light_freq(void)
{
	/* get banding filter value */
	int temp, temp1, light_freq = 0;
	u8 tmp;

	temp = ov5640_read_reg(0x3c01, &tmp);

	if (temp & 0x80) {
		/* manual */
		temp1 = ov5640_read_reg(0x3c00, &tmp);
		if (temp1 & 0x04) {
			/* 50Hz */
			light_freq = 50;
		} else {
			/* 60Hz */
			light_freq = 60;
		}
	} else {
		/* auto */
		temp1 = ov5640_read_reg(0x3c0c, &tmp);
		if (temp1 & 0x01) {
			/* 50Hz */
			light_freq = 50;
		} else {
			/* 60Hz */
		}
	}
	return light_freq;
}

static void OV5640_set_bandingfilter(void)
{
	int prev_VTS;
	int band_step60, max_band60, band_step50, max_band50;

	/* read preview PCLK */
	prev_sysclk = OV5640_get_sysclk();
	/* read preview HTS */
	prev_HTS = OV5640_get_HTS();

	/* read preview VTS */
	prev_VTS = OV5640_get_VTS();

	/* calculate banding filter */
	/* 60Hz */
	band_step60 = prev_sysclk * 100/prev_HTS * 100/120;
	ov5640_write_reg(0x3a0a, (band_step60 >> 8));
	ov5640_write_reg(0x3a0b, (band_step60 & 0xff));

	max_band60 = (int)((prev_VTS-4)/band_step60);
	ov5640_write_reg(0x3a0d, max_band60);

	/* 50Hz */
	band_step50 = prev_sysclk * 100/prev_HTS;
	ov5640_write_reg(0x3a08, (band_step50 >> 8));
	ov5640_write_reg(0x3a09, (band_step50 & 0xff));

	max_band50 = (int)((prev_VTS-4)/band_step50);
	ov5640_write_reg(0x3a0e, max_band50);
}

static int OV5640_set_AE_target(int target)
{
	/* stable in high */
	int fast_high, fast_low;
	AE_low = target * 23 / 25;	/* 0.92 */
	AE_high = target * 27 / 25;	/* 1.08 */

	fast_high = AE_high<<1;
	if (fast_high > 255)
		fast_high = 255;

	fast_low = AE_low >> 1;

	ov5640_write_reg(0x3a0f, AE_high);
	ov5640_write_reg(0x3a10, AE_low);
	ov5640_write_reg(0x3a1b, AE_high);
	ov5640_write_reg(0x3a1e, AE_low);
	ov5640_write_reg(0x3a11, fast_high);
	ov5640_write_reg(0x3a1f, fast_low);

	return 0;
}

static void OV5640_turn_on_AE_AG(int enable)
{
	u8 ae_ag_ctrl;

	ov5640_read_reg(0x3503, &ae_ag_ctrl);
	if (enable) {
		/* turn on auto AE/AG */
		ae_ag_ctrl = ae_ag_ctrl & ~(0x03);
	} else {
		/* turn off AE/AG */
		ae_ag_ctrl = ae_ag_ctrl | 0x03;
	}
	ov5640_write_reg(0x3503, ae_ag_ctrl);
}

static bool binning_on(void)
{
	u8 temp;
	ov5640_read_reg(0x3821, &temp);
	temp &= 0xfe;
	if (temp)
		return true;
	else
		return false;
}

static void ov5640_set_virtual_channel(int channel)
{
	u8 channel_id;

	ov5640_read_reg(0x4814, &channel_id);
	channel_id &= ~(3 << 6);
	ov5640_write_reg(0x4814, channel_id | (channel << 6));
}

/* download ov5640 settings to sensor through i2c */
static int ov5640_download_firmware(struct reg_value *pModeSetting, s32 ArySize)
{
	register u32 Delay_ms = 0;
	register u16 RegAddr = 0;
	register u8 Mask = 0;
	register u8 Val = 0;
	u8 RegVal = 0;
	int i, retval = 0;

	for (i = 0; i < ArySize; ++i, ++pModeSetting) {
		Delay_ms = pModeSetting->u32Delay_ms;
		RegAddr = pModeSetting->u16RegAddr;
		Val = pModeSetting->u8Val;
		Mask = pModeSetting->u8Mask;

		if (Mask) {
			retval = ov5640_read_reg(RegAddr, &RegVal);
			if (retval < 0)
				goto err;

			RegVal &= ~(u8)Mask;
			Val &= Mask;
			Val |= RegVal;
		}

		retval = ov5640_write_reg(RegAddr, Val);
		if (retval < 0)
			goto err;

		if (Delay_ms)
			msleep(Delay_ms);
	}
err:
	return retval;
}

/* sensor changes between scaling and subsampling
 * go through exposure calcualtion
 */
static int ov5640_change_mode_exposure_calc(enum ov5640_frame_rate frame_rate,
				enum ov5640_mode mode)
{
	struct reg_value *pModeSetting = NULL;
	s32 ArySize = 0;
	u8 average;
	int prev_shutter, prev_gain16;
	int cap_shutter, cap_gain16;
	int cap_sysclk, cap_HTS, cap_VTS;
	int light_freq, cap_bandfilt, cap_maxband;
	long cap_gain16_shutter;
	int retval = 0;

	/* check if the input mode and frame rate is valid */
	pModeSetting =
		ov5640_mode_info_data[frame_rate][mode].init_data_ptr;
	ArySize =
		ov5640_mode_info_data[frame_rate][mode].init_data_size;

	ov5640_data.pix.width =
		ov5640_mode_info_data[frame_rate][mode].width;
	ov5640_data.pix.height =
		ov5640_mode_info_data[frame_rate][mode].height;

	if (ov5640_data.pix.width == 0 || ov5640_data.pix.height == 0 ||
		pModeSetting == NULL || ArySize == 0)
		return -EINVAL;

	/* auto focus */
	/* OV5640_auto_focus();//if no af function, just skip it */

	/* turn off AE/AG */
	OV5640_turn_on_AE_AG(0);

	/* read preview shutter */
	prev_shutter = OV5640_get_shutter();
	if ((binning_on()) && (mode != ov5640_mode_720P_1280_720)
			&& (mode != ov5640_mode_1080P_1920_1080))
		prev_shutter *= 2;

	/* read preview gain */
	prev_gain16 = OV5640_get_gain16();

	/* get average */
	ov5640_read_reg(0x56a1, &average);

	/* turn off night mode for capture */
	OV5640_set_night_mode();

	/* turn off overlay */
	/* ov5640_write_reg(0x3022, 0x06);//if no af function, just skip it */

	OV5640_stream_off();

	/* Write capture setting */
	retval = ov5640_download_firmware(pModeSetting, ArySize);
	if (retval < 0)
		goto err;

	/* read capture VTS */
	cap_VTS = OV5640_get_VTS();
	cap_HTS = OV5640_get_HTS();
	cap_sysclk = OV5640_get_sysclk();

	/* calculate capture banding filter */
	light_freq = OV5640_get_light_freq();
	if (light_freq == 60) {
		/* 60Hz */
		cap_bandfilt = cap_sysclk * 100 / cap_HTS * 100 / 120;
	} else {
		/* 50Hz */
		cap_bandfilt = cap_sysclk * 100 / cap_HTS;
	}
	cap_maxband = (int)((cap_VTS - 4)/cap_bandfilt);

	/* calculate capture shutter/gain16 */
	if (average > AE_low && average < AE_high) {
		/* in stable range */
		cap_gain16_shutter =
		  prev_gain16 * prev_shutter * cap_sysclk/prev_sysclk
		  * prev_HTS/cap_HTS * AE_Target / average;
	} else {
		cap_gain16_shutter =
		  prev_gain16 * prev_shutter * cap_sysclk/prev_sysclk
		  * prev_HTS/cap_HTS;
	}

	/* gain to shutter */
	if (cap_gain16_shutter < (cap_bandfilt * 16)) {
		/* shutter < 1/100 */
		cap_shutter = cap_gain16_shutter/16;
		if (cap_shutter < 1)
			cap_shutter = 1;

		cap_gain16 = cap_gain16_shutter/cap_shutter;
		if (cap_gain16 < 16)
			cap_gain16 = 16;
	} else {
		if (cap_gain16_shutter >
				(cap_bandfilt * cap_maxband * 16)) {
			/* exposure reach max */
			cap_shutter = cap_bandfilt * cap_maxband;
			cap_gain16 = cap_gain16_shutter / cap_shutter;
		} else {
			/* 1/100 < (cap_shutter = n/100) =< max */
			cap_shutter =
			  ((int) (cap_gain16_shutter/16 / cap_bandfilt))
			  *cap_bandfilt;
			cap_gain16 = cap_gain16_shutter / cap_shutter;
		}
	}

	/* write capture gain */
	OV5640_set_gain16(cap_gain16);

	/* write capture shutter */
	if (cap_shutter > (cap_VTS - 4)) {
		cap_VTS = cap_shutter + 4;
		OV5640_set_VTS(cap_VTS);
	}
	OV5640_set_shutter(cap_shutter);

	OV5640_stream_on();

err:
	return retval;
}

/* if sensor changes inside scaling or subsampling
 * change mode directly
 * */
static int ov5640_change_mode_direct(enum ov5640_frame_rate frame_rate,
				enum ov5640_mode mode)
{
	struct reg_value *pModeSetting = NULL;
	s32 ArySize = 0;
	int retval = 0;

	/* check if the input mode and frame rate is valid */
	pModeSetting =
		ov5640_mode_info_data[frame_rate][mode].init_data_ptr;
	ArySize =
		ov5640_mode_info_data[frame_rate][mode].init_data_size;

	ov5640_data.pix.width =
		ov5640_mode_info_data[frame_rate][mode].width;
	ov5640_data.pix.height =
		ov5640_mode_info_data[frame_rate][mode].height;

	if (ov5640_data.pix.width == 0 || ov5640_data.pix.height == 0 ||
		pModeSetting == NULL || ArySize == 0)
		return -EINVAL;

	/* turn off AE/AG */
	OV5640_turn_on_AE_AG(0);

	OV5640_stream_off();

	/* Write capture setting */
	retval = ov5640_download_firmware(pModeSetting, ArySize);
	if (retval < 0)
		goto err;

	OV5640_stream_on();

	OV5640_turn_on_AE_AG(1);

err:
	return retval;
}

static int ov5640_init_mode(enum ov5640_frame_rate frame_rate,
			    enum ov5640_mode mode, enum ov5640_mode orig_mode)
{
	struct reg_value *pModeSetting = NULL;
	s32 ArySize = 0;
	int retval = 0;
	void *mipi_csi2_info;
	u32 mipi_reg, msec_wait4stable = 0;
	enum ov5640_downsize_mode dn_mode, orig_dn_mode;

	if ((mode > ov5640_mode_MAX || mode < ov5640_mode_MIN)
		&& (mode != ov5640_mode_INIT)) {
		pr_err("Wrong ov5640 mode detected!\n");
		return -1;
	}

	mipi_csi2_info = mipi_csi2_get_info();

	/* initial mipi dphy */
	if (!mipi_csi2_info) {
		printk(KERN_ERR "%s() in %s: Fail to get mipi_csi2_info!\n",
		       __func__, __FILE__);
		return -1;
	}

	if (!mipi_csi2_get_status(mipi_csi2_info))
		mipi_csi2_enable(mipi_csi2_info);

	if (!mipi_csi2_get_status(mipi_csi2_info)) {
		pr_err("Can not enable mipi csi2 driver!\n");
		return -1;
	}

	mipi_csi2_set_lanes(mipi_csi2_info);

	/*Only reset MIPI CSI2 HW at sensor initialize*/
	if (mode == ov5640_mode_INIT)
		mipi_csi2_reset(mipi_csi2_info);

	if (ov5640_data.pix.pixelformat == V4L2_PIX_FMT_UYVY)
		mipi_csi2_set_datatype(mipi_csi2_info, MIPI_DT_YUV422);
	else if (ov5640_data.pix.pixelformat == V4L2_PIX_FMT_RGB565)
		mipi_csi2_set_datatype(mipi_csi2_info, MIPI_DT_RGB565);
	else
		pr_err("currently this sensor format can not be supported!\n");

	dn_mode = ov5640_mode_info_data[frame_rate][mode].dn_mode;
	orig_dn_mode = ov5640_mode_info_data[frame_rate][orig_mode].dn_mode;
	if (mode == ov5640_mode_INIT) {
		pModeSetting = ov5640_init_setting_30fps_VGA;
		ArySize = ARRAY_SIZE(ov5640_init_setting_30fps_VGA);

		ov5640_data.pix.width = 640;
		ov5640_data.pix.height = 480;
		retval = ov5640_download_firmware(pModeSetting, ArySize);
		if (retval < 0)
			goto err;

		pModeSetting = ov5640_setting_30fps_VGA_640_480;
		ArySize = ARRAY_SIZE(ov5640_setting_30fps_VGA_640_480);
		retval = ov5640_download_firmware(pModeSetting, ArySize);
	} else if ((dn_mode == SUBSAMPLING && orig_dn_mode == SCALING) ||
			(dn_mode == SCALING && orig_dn_mode == SUBSAMPLING)) {
		/* change between subsampling and scaling
		 * go through exposure calucation */
		retval = ov5640_change_mode_exposure_calc(frame_rate, mode);
	} else {
		/* change inside subsampling or scaling
		 * download firmware directly */
		retval = ov5640_change_mode_direct(frame_rate, mode);
	}

	if (retval < 0)
		goto err;

	OV5640_set_AE_target(AE_Target);
	OV5640_get_light_freq();
	OV5640_set_bandingfilter();
	ov5640_set_virtual_channel(ov5640_data.csi);

	/* add delay to wait for sensor stable */
	if (mode == ov5640_mode_QSXGA_2592_1944) {
		/* dump the first two frames: 1/7.5*2
		 * the frame rate of QSXGA is 7.5fps */
		msec_wait4stable = 267;
	} else if (frame_rate == ov5640_15_fps) {
		/* dump the first nine frames: 1/15*9 */
		msec_wait4stable = 600;
	} else if (frame_rate == ov5640_30_fps) {
		/* dump the first nine frames: 1/30*9 */
		msec_wait4stable = 300;
	}
	msleep(msec_wait4stable);

	if (mipi_csi2_info) {
		unsigned int i;

		i = 0;

		/* wait for mipi sensor ready */
		mipi_reg = mipi_csi2_dphy_status(mipi_csi2_info);
		while ((mipi_reg == 0x200) && (i < 10)) {
			mipi_reg = mipi_csi2_dphy_status(mipi_csi2_info);
			i++;
			msleep(10);
		}

		if (i >= 10) {
			pr_err("mipi csi2 can not receive sensor clk!\n");
			return -1;
		}

		i = 0;

		/* wait for mipi stable */
		mipi_reg = mipi_csi2_get_error1(mipi_csi2_info);
		while ((mipi_reg != 0x0) && (i < 10)) {
			mipi_reg = mipi_csi2_get_error1(mipi_csi2_info);
			i++;
			msleep(10);
		}

		if (i >= 10) {
			pr_err("mipi csi2 can not reveive data correctly!\n");
			return -1;
		}
	}
err:
	return retval;
}

static int ov5640_af_init(void)
{
	u8 value = 0;

	ov5640_download_firmware(af_firmware, ARRAY_SIZE(af_firmware));

	while (ov5640_read_reg(OV5640_REG_AF_STATUS, &value)) {
		if (value == OV5640_AF_STATUS_IDLE)
			break;
		mdelay(1);
		pr_debug("Waiting for AF Firmware ready..");
	}
	return ov5640_write_reg(OV5640_AF_MODE, OV5640_AF_MODE_CONT);
}

static int ov5640_af_set_mode(int mode)
{
	int err = 0;

	switch (mode) {
	case V4L2_CID_AUTO_FOCUS_START:
		/* start single focus */
		err = ov5640_write_reg(OV5640_AF_MODE,
				OV5640_AF_MODE_SINGLE);
		focus_range = V4L2_AUTO_FOCUS_RANGE_NORMAL;
		break;
	case V4L2_CID_FOCUS_AUTO:
		/* start continuous focus */
		err = ov5640_write_reg(OV5640_AF_MODE,
				OV5640_AF_MODE_CONT);
		focus_range = V4L2_AUTO_FOCUS_RANGE_NORMAL;
		break;
	case V4L2_CID_3A_LOCK:
		/* pause focus */
		err = ov5640_write_reg(OV5640_AF_MODE,
				OV5640_AF_MODE_PAUSE);
		break;
	case V4L2_CID_AUTO_FOCUS_STOP:
		/* release focus to infinity */
		err = ov5640_write_reg(OV5640_AF_MODE,
				OV5640_AF_MODE_RELEASE);
		break;
	default:
		pr_err("Invalid mode: %d\n", mode);
		return -EINVAL;
	}

	if (err) {
		pr_err("Setting focus mode failed!\n");
		return err;
	}

	focus_mode = mode;

	return 0;
}

static int ov5640_af_start_single(void)
{
	return ov5640_af_set_mode(V4L2_CID_AUTO_FOCUS_START);
}

static int ov5640_af_stop_single(void)
{
	return ov5640_af_set_mode(V4L2_CID_AUTO_FOCUS_STOP);
}

static int ov5640_af_set_auto(int enable)
{
	int ret = 0;

	if (enable)
		ret = ov5640_af_set_mode(V4L2_CID_FOCUS_AUTO);
	else
		ret = ov5640_af_set_mode(V4L2_CID_AUTO_FOCUS_STOP);

	return ret;
}
static int ov5640_af_set_focus_range(int value)
{
	int ret = 0;

	switch (value) {
	case V4L2_AUTO_FOCUS_RANGE_INFINITY:
		ret = ov5640_af_set_mode(V4L2_CID_AUTO_FOCUS_STOP);
		focus_range = V4L2_AUTO_FOCUS_RANGE_INFINITY;
		break;
	case V4L2_AUTO_FOCUS_RANGE_NORMAL:
	default:
		focus_range = V4L2_AUTO_FOCUS_RANGE_NORMAL;
	}
	return ret;
}

static int ov5640_af_set_focus_lock(int value)
{
	if (value != V4L2_LOCK_FOCUS) {
		pr_err("%s: Invalid focus cmd (%#x)\n", __func__, value);
		return -EINVAL;
	}

	return ov5640_af_set_mode(V4L2_CID_3A_LOCK);
}

static int ov5640_af_get_status(int *status)
{
	int err;
	u8 val = 0;

	err = ov5640_read_reg(OV5640_REG_AF_STATUS, &val);
	if (err < 0)
		return err;

	switch (val) {
	case OV5640_AF_STATUS_DL:
		*status = V4L2_AUTO_FOCUS_STATUS_FAILED;
		break;
	case OV5640_AF_STATUS_RUN:
		*status = V4L2_AUTO_FOCUS_STATUS_BUSY;
		break;
	case OV5640_AF_STATUS_FINISH:
		*status = V4L2_AUTO_FOCUS_STATUS_REACHED;
		break;
	case OV5640_AF_STATUS_INIT:
	case OV5640_AF_STATUS_IDLE:

	default:
		/*
		 * By default return IDLE status
		 */
		*status = V4L2_AUTO_FOCUS_STATUS_IDLE;
	}

	return 0;
}

static int ov5640_af_set_region(uint16_t x, uint16_t y)
{
	int err = 0;

	if (!x && !y) {
		err = ov5640_write_reg(OV5640_AF_MODE,
				OV5640_AF_MODE_RESTART);
		if (err) {
			pr_err("Resetting focus region failed!\n");
			return err;
		}
		goto end;
	}

	if ((x > OV5640_AF_WINDOW_WIDTH) ||
			(y > OV5640_AF_WINDOW_HEIGHT)) {
		pr_err("Out of bound  x %d y %d\n", x, y);
		return -EINVAL;
	}

	err = ov5640_write_reg(OV5640_REG_AF_X_POS, x);
	if (err) {
		pr_err("Setting X pos failed!\n");
		return err;
	}

	err = ov5640_write_reg(OV5640_REG_AF_Y_POS, y);
	if (err) {
		pr_err("Setting Y failed!\n");
		return err;
	}

	err = ov5640_write_reg(OV5640_AF_MODE,
			OV5640_AF_MODE_SET_ZONE);
	if (err) {
		pr_err("Setting AF Zone failed!\n");
		return err;
	}
end:
	g_roi_x = x;
	g_roi_y = y;

	return 0;
}
/* --------------- IOCTL functions from v4l2_int_ioctl_desc --------------- */

static int ioctl_g_ifparm(struct v4l2_int_device *s, struct v4l2_ifparm *p)
{
	if (s == NULL) {
		pr_err("   ERROR!! no slave device set!\n");
		return -1;
	}

	memset(p, 0, sizeof(*p));
	p->u.bt656.clock_curr = ov5640_data.mclk;
	pr_debug("   clock_curr=mclk=%d\n", ov5640_data.mclk);
	p->if_type = V4L2_IF_TYPE_BT656;
	p->u.bt656.mode = V4L2_IF_TYPE_BT656_MODE_NOBT_8BIT;
	p->u.bt656.clock_min = OV5640_XCLK_MIN;
	p->u.bt656.clock_max = OV5640_XCLK_MAX;
	p->u.bt656.bt_sync_correct = 1;  /* Indicate external vsync */

	return 0;
}

/*!
 * ioctl_s_power - V4L2 sensor interface handler for VIDIOC_S_POWER ioctl
 * @s: pointer to standard V4L2 device structure
 * @on: indicates power mode (on or off)
 *
 * Turns the power on or off, depending on the value of on and returns the
 * appropriate error code.
 */
static int ioctl_s_power(struct v4l2_int_device *s, int on)
{
	struct sensor_data *sensor = s->priv;

	if (on && !sensor->on) {
		if (io_regulator)
			if (regulator_enable(io_regulator) != 0)
				return -EIO;
		if (core_regulator)
			if (regulator_enable(core_regulator) != 0)
				return -EIO;
		if (gpo_regulator)
			if (regulator_enable(gpo_regulator) != 0)
				return -EIO;
		if (analog_regulator)
			if (regulator_enable(analog_regulator) != 0)
				return -EIO;
		/* Make sure power on */
		ov5640_standby(0);
	} else if (!on && sensor->on) {

		ov5640_power_off();

		ov5640_standby(1);
	}

	sensor->on = on;

	return 0;
}

/*!
 * ioctl_g_parm - V4L2 sensor interface handler for VIDIOC_G_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_G_PARM ioctl structure
 *
 * Returns the sensor's video CAPTURE parameters.
 */
static int ioctl_g_parm(struct v4l2_int_device *s, struct v4l2_streamparm *a)
{
	struct sensor_data *sensor = s->priv;
	struct v4l2_captureparm *cparm = &a->parm.capture;
	int ret = 0;

	switch (a->type) {
	/* This is the only case currently handled. */
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
		memset(a, 0, sizeof(*a));
		a->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		cparm->capability = sensor->streamcap.capability;
		cparm->timeperframe = sensor->streamcap.timeperframe;
		cparm->capturemode = sensor->streamcap.capturemode;
		ret = 0;
		break;

	/* These are all the possible cases. */
	case V4L2_BUF_TYPE_VIDEO_OUTPUT:
	case V4L2_BUF_TYPE_VIDEO_OVERLAY:
	case V4L2_BUF_TYPE_VBI_CAPTURE:
	case V4L2_BUF_TYPE_VBI_OUTPUT:
	case V4L2_BUF_TYPE_SLICED_VBI_CAPTURE:
	case V4L2_BUF_TYPE_SLICED_VBI_OUTPUT:
		ret = -EINVAL;
		break;

	default:
		pr_debug("   type is unknown - %d\n", a->type);
		ret = -EINVAL;
		break;
	}

	return ret;
}

/*!
 * ioctl_s_parm - V4L2 sensor interface handler for VIDIOC_S_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_S_PARM ioctl structure
 *
 * Configures the sensor to use the input parameters, if possible.  If
 * not possible, reverts to the old parameters and returns the
 * appropriate error code.
 */
static int ioctl_s_parm(struct v4l2_int_device *s, struct v4l2_streamparm *a)
{
	struct sensor_data *sensor = s->priv;
	struct v4l2_fract *timeperframe = &a->parm.capture.timeperframe;
	u32 tgt_fps;	/* target frames per secound */
	enum ov5640_frame_rate frame_rate;
	enum ov5640_mode orig_mode;
	int ret = 0;

	/* Make sure power on */
	ov5640_standby(0);

	switch (a->type) {
	/* This is the only case currently handled. */
	case V4L2_BUF_TYPE_VIDEO_CAPTURE:
		/* Check that the new frame rate is allowed. */
		if ((timeperframe->numerator == 0) ||
		    (timeperframe->denominator == 0)) {
			timeperframe->denominator = DEFAULT_FPS;
			timeperframe->numerator = 1;
		}

		tgt_fps = timeperframe->denominator /
			  timeperframe->numerator;

		if (tgt_fps > MAX_FPS) {
			timeperframe->denominator = MAX_FPS;
			timeperframe->numerator = 1;
		} else if (tgt_fps < MIN_FPS) {
			timeperframe->denominator = MIN_FPS;
			timeperframe->numerator = 1;
		}

		/* Actual frame rate we use */
		tgt_fps = timeperframe->denominator /
			  timeperframe->numerator;

		if (tgt_fps == 15)
			frame_rate = ov5640_15_fps;
		else if (tgt_fps == 30)
			frame_rate = ov5640_30_fps;
		else {
			pr_err(" The camera frame rate is not supported!\n");
			return -EINVAL;
		}

		orig_mode = sensor->streamcap.capturemode;
		ret = ov5640_init_mode(frame_rate,
				(u32)a->parm.capture.capturemode, orig_mode);
		if (ret < 0)
			return ret;

		sensor->streamcap.timeperframe = *timeperframe;
		sensor->streamcap.capturemode =
				(u32)a->parm.capture.capturemode;

		break;

	/* These are all the possible cases. */
	case V4L2_BUF_TYPE_VIDEO_OUTPUT:
	case V4L2_BUF_TYPE_VIDEO_OVERLAY:
	case V4L2_BUF_TYPE_VBI_CAPTURE:
	case V4L2_BUF_TYPE_VBI_OUTPUT:
	case V4L2_BUF_TYPE_SLICED_VBI_CAPTURE:
	case V4L2_BUF_TYPE_SLICED_VBI_OUTPUT:
		pr_debug("   type is not " \
			"V4L2_BUF_TYPE_VIDEO_CAPTURE but %d\n",
			a->type);
		ret = -EINVAL;
		break;

	default:
		pr_debug("   type is unknown - %d\n", a->type);
		ret = -EINVAL;
		break;
	}

	return ret;
}

/*!
 * ioctl_g_fmt_cap - V4L2 sensor interface handler for ioctl_g_fmt_cap
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 v4l2_format structure
 *
 * Returns the sensor's current pixel format in the v4l2_format
 * parameter.
 */
static int ioctl_g_fmt_cap(struct v4l2_int_device *s, struct v4l2_format *f)
{
	struct sensor_data *sensor = s->priv;

	f->fmt.pix = sensor->pix;

	return 0;
}

/*!
 * ioctl_g_ctrl - V4L2 sensor interface handler for VIDIOC_G_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_G_CTRL ioctl structure
 *
 * If the requested control is supported, returns the control's current
 * value from the video_control[] array.  Otherwise, returns -EINVAL
 * if the control is not supported.
 */
static int ioctl_g_ctrl(struct v4l2_int_device *s, struct v4l2_control *vc)
{
	int ret = 0;

	switch (vc->id) {
	case V4L2_CID_BRIGHTNESS:
		vc->value = ov5640_data.brightness;
		break;
	case V4L2_CID_HUE:
		vc->value = ov5640_data.hue;
		break;
	case V4L2_CID_CONTRAST:
		vc->value = ov5640_data.contrast;
		break;
	case V4L2_CID_SATURATION:
		vc->value = ov5640_data.saturation;
		break;
	case V4L2_CID_RED_BALANCE:
		vc->value = ov5640_data.red;
		break;
	case V4L2_CID_BLUE_BALANCE:
		vc->value = ov5640_data.blue;
		break;
	case V4L2_CID_EXPOSURE:
		vc->value = ov5640_data.ae_mode;
		break;
	case V4L2_CID_3A_LOCK:
		vc->value = (focus_mode == V4L2_CID_3A_LOCK);
		break;
	case V4L2_CID_AUTO_FOCUS_STATUS:
		ret = ov5640_af_get_status(&vc->value);
		break;
	case V4L2_CID_AUTO_FOCUS_RANGE:
		vc->value = focus_range;
		break;
	case V4L2_CID_FOCUS_ABSOLUTE:
	case V4L2_CID_FOCUS_AUTO:
		vc->value = (focus_mode == V4L2_CID_FOCUS_AUTO);
		break;
	default:
		ret = -EINVAL;
	}

	return ret;
}

/*!
 * ioctl_s_ctrl - V4L2 sensor interface handler for VIDIOC_S_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_S_CTRL ioctl structure
 *
 * If the requested control is supported, sets the control's current
 * value in HW (and updates the video_control[] array).  Otherwise,
 * returns -EINVAL if the control is not supported.
 */
static int ioctl_s_ctrl(struct v4l2_int_device *s, struct v4l2_control *vc)
{
	int retval = 0;

	pr_debug("In ov5640:ioctl_s_ctrl %d\n",
		 vc->id);

	switch (vc->id) {
	case V4L2_CID_BRIGHTNESS:
		break;
	case V4L2_CID_CONTRAST:
		break;
	case V4L2_CID_SATURATION:
		break;
	case V4L2_CID_HUE:
		break;
	case V4L2_CID_AUTO_WHITE_BALANCE:
		break;
	case V4L2_CID_DO_WHITE_BALANCE:
		break;
	case V4L2_CID_RED_BALANCE:
		break;
	case V4L2_CID_BLUE_BALANCE:
		break;
	case V4L2_CID_GAMMA:
		break;
	case V4L2_CID_EXPOSURE:
		break;
	case V4L2_CID_AUTOGAIN:
		break;
	case V4L2_CID_GAIN:
		break;
	case V4L2_CID_HFLIP:
		break;
	case V4L2_CID_VFLIP:
		break;
	case V4L2_CID_AUTO_FOCUS_START:
		retval = ov5640_af_start_single();
		break;
	case V4L2_CID_AUTO_FOCUS_STOP:
		retval = ov5640_af_stop_single();
		break;
	case V4L2_CID_FOCUS_AUTO:
		retval = ov5640_af_set_auto(1);
		break;
	case V4L2_CID_FOCUS_ABSOLUTE:
		/* Custom implementation that sets the ROI */
		retval = ov5640_af_set_region((vc->value >> 16),
					      (vc->value & 0xffff));
		break;
	case V4L2_CID_3A_LOCK:
		retval = ov5640_af_set_focus_lock(vc->value);
		break;
	case V4L2_CID_AUTO_FOCUS_RANGE:
		retval = ov5640_af_set_focus_range(vc->value);
		break;
	default:
		retval = -EPERM;
		break;
	}

	return retval;
}

/*!
 * ioctl_enum_framesizes - V4L2 sensor interface handler for
 *			   VIDIOC_ENUM_FRAMESIZES ioctl
 * @s: pointer to standard V4L2 device structure
 * @fsize: standard V4L2 VIDIOC_ENUM_FRAMESIZES ioctl structure
 *
 * Return 0 if successful, otherwise -EINVAL.
 */
static int ioctl_enum_framesizes(struct v4l2_int_device *s,
				 struct v4l2_frmsizeenum *fsize)
{
	if (fsize->index > ov5640_mode_MAX)
		return -EINVAL;

	fsize->pixel_format = ov5640_data.pix.pixelformat;
	fsize->discrete.width =
			max(ov5640_mode_info_data[0][fsize->index].width,
			    ov5640_mode_info_data[1][fsize->index].width);
	fsize->discrete.height =
			max(ov5640_mode_info_data[0][fsize->index].height,
			    ov5640_mode_info_data[1][fsize->index].height);
	return 0;
}

/*!
 * ioctl_enum_frameintervals - V4L2 sensor interface handler for
 *			       VIDIOC_ENUM_FRAMEINTERVALS ioctl
 * @s: pointer to standard V4L2 device structure
 * @fival: standard V4L2 VIDIOC_ENUM_FRAMEINTERVALS ioctl structure
 *
 * Return 0 if successful, otherwise -EINVAL.
 */
static int ioctl_enum_frameintervals(struct v4l2_int_device *s,
					 struct v4l2_frmivalenum *fival)
{
	int i, j, count = 0;

	fival->type = V4L2_FRMIVAL_TYPE_DISCRETE;
	fival->discrete.numerator = 1;

	for (i = 0; i < ARRAY_SIZE(ov5640_mode_info_data); i++)
		for (j = 0; j < (ov5640_mode_MAX + 1); j++)
			if (fival->pixel_format == ov5640_data.pix.pixelformat
			 && fival->width == ov5640_mode_info_data[i][j].width
			 && fival->height == ov5640_mode_info_data[i][j].height
			 && ov5640_mode_info_data[i][j].init_data_ptr != NULL
			 && fival->index == count++) {
				fival->discrete.denominator =
						ov5640_framerates[i];
				return 0;
			}

	return -EINVAL;
}

/*!
 * ioctl_g_chip_ident - V4L2 sensor interface handler for
 *			VIDIOC_DBG_G_CHIP_IDENT ioctl
 * @s: pointer to standard V4L2 device structure
 * @id: pointer to int
 *
 * Return 0.
 */
static int ioctl_g_chip_ident(struct v4l2_int_device *s, int *id)
{
	((struct v4l2_dbg_chip_ident *)id)->match.type =
					V4L2_CHIP_MATCH_I2C_DRIVER;
	strcpy(((struct v4l2_dbg_chip_ident *)id)->match.name,
		"ov5640_mipi_camera");

	return 0;
}

/*!
 * ioctl_init - V4L2 sensor interface handler for VIDIOC_INT_INIT
 * @s: pointer to standard V4L2 device structure
 */
static int ioctl_init(struct v4l2_int_device *s)
{

	return 0;
}

/*!
 * ioctl_enum_fmt_cap - V4L2 sensor interface handler for VIDIOC_ENUM_FMT
 * @s: pointer to standard V4L2 device structure
 * @fmt: pointer to standard V4L2 fmt description structure
 *
 * Return 0.
 */
static int ioctl_enum_fmt_cap(struct v4l2_int_device *s,
			      struct v4l2_fmtdesc *fmt)
{
	if (fmt->index > ov5640_mode_MAX)
		return -EINVAL;

	fmt->pixelformat = ov5640_data.pix.pixelformat;

	return 0;
}

/*!
 * ioctl_dev_init - V4L2 sensor interface handler for vidioc_int_dev_init_num
 * @s: pointer to standard V4L2 device structure
 *
 * Initialise the device when slave attaches to the master.
 */
static int ioctl_dev_init(struct v4l2_int_device *s)
{
	struct sensor_data *sensor = s->priv;
	u32 tgt_xclk;	/* target xclk */
	u32 tgt_fps;	/* target frames per secound */
	int ret;
	enum ov5640_frame_rate frame_rate;
	void *mipi_csi2_info;

	ov5640_data.on = true;

	/* mclk */
	tgt_xclk = ov5640_data.mclk;
	tgt_xclk = min(tgt_xclk, (u32)OV5640_XCLK_MAX);
	tgt_xclk = max(tgt_xclk, (u32)OV5640_XCLK_MIN);
	ov5640_data.mclk = tgt_xclk;

	pr_debug("   Setting mclk to %d MHz\n", tgt_xclk / 1000000);

	/* Default camera frame rate is set in probe */
	tgt_fps = sensor->streamcap.timeperframe.denominator /
		  sensor->streamcap.timeperframe.numerator;

	if (tgt_fps == 15)
		frame_rate = ov5640_15_fps;
	else if (tgt_fps == 30)
		frame_rate = ov5640_30_fps;
	else
		return -EINVAL; /* Only support 15fps or 30fps now. */

	mipi_csi2_info = mipi_csi2_get_info();

	/* enable mipi csi2 */
	if (mipi_csi2_info)
		mipi_csi2_enable(mipi_csi2_info);
	else {
		printk(KERN_ERR "%s() in %s: Fail to get mipi_csi2_info!\n",
		       __func__, __FILE__);
		return -EPERM;
	}

	ret = ov5640_init_mode(frame_rate, ov5640_mode_INIT, ov5640_mode_INIT);

	return ret;
}

/*!
 * ioctl_dev_exit - V4L2 sensor interface handler for vidioc_int_dev_exit_num
 * @s: pointer to standard V4L2 device structure
 *
 * Delinitialise the device when slave detaches to the master.
 */
static int ioctl_dev_exit(struct v4l2_int_device *s)
{
	void *mipi_csi2_info;

	mipi_csi2_info = mipi_csi2_get_info();

	/* disable mipi csi2 */
	if (mipi_csi2_info)
		if (mipi_csi2_get_status(mipi_csi2_info))
			mipi_csi2_disable(mipi_csi2_info);

	return 0;
}

/*!
 * This structure defines all the ioctls for this module and links them to the
 * enumeration.
 */
static struct v4l2_int_ioctl_desc ov5640_ioctl_desc[] = {
	{vidioc_int_dev_init_num, (v4l2_int_ioctl_func *) ioctl_dev_init},
	{vidioc_int_dev_exit_num, ioctl_dev_exit},
	{vidioc_int_s_power_num, (v4l2_int_ioctl_func *) ioctl_s_power},
	{vidioc_int_g_ifparm_num, (v4l2_int_ioctl_func *) ioctl_g_ifparm},
/*	{vidioc_int_g_needs_reset_num,
				(v4l2_int_ioctl_func *)ioctl_g_needs_reset}, */
/*	{vidioc_int_reset_num, (v4l2_int_ioctl_func *)ioctl_reset}, */
	{vidioc_int_init_num, (v4l2_int_ioctl_func *) ioctl_init},
	{vidioc_int_enum_fmt_cap_num,
				(v4l2_int_ioctl_func *) ioctl_enum_fmt_cap},
/*	{vidioc_int_try_fmt_cap_num,
				(v4l2_int_ioctl_func *)ioctl_try_fmt_cap}, */
	{vidioc_int_g_fmt_cap_num, (v4l2_int_ioctl_func *) ioctl_g_fmt_cap},
/*	{vidioc_int_s_fmt_cap_num, (v4l2_int_ioctl_func *) ioctl_s_fmt_cap}, */
	{vidioc_int_g_parm_num, (v4l2_int_ioctl_func *) ioctl_g_parm},
	{vidioc_int_s_parm_num, (v4l2_int_ioctl_func *) ioctl_s_parm},
/*	{vidioc_int_queryctrl_num, (v4l2_int_ioctl_func *)ioctl_queryctrl}, */
	{vidioc_int_g_ctrl_num, (v4l2_int_ioctl_func *) ioctl_g_ctrl},
	{vidioc_int_s_ctrl_num, (v4l2_int_ioctl_func *) ioctl_s_ctrl},
	{vidioc_int_enum_framesizes_num,
				(v4l2_int_ioctl_func *) ioctl_enum_framesizes},
	{vidioc_int_enum_frameintervals_num,
			(v4l2_int_ioctl_func *) ioctl_enum_frameintervals},
	{vidioc_int_g_chip_ident_num,
				(v4l2_int_ioctl_func *) ioctl_g_chip_ident},
};

static struct v4l2_int_slave ov5640_slave = {
	.ioctls = ov5640_ioctl_desc,
	.num_ioctls = ARRAY_SIZE(ov5640_ioctl_desc),
};

static struct v4l2_int_device ov5640_int_device = {
	.module = THIS_MODULE,
	.name = "ov564x",
	.type = v4l2_int_type_slave,
	.u = {
		.slave = &ov5640_slave,
	},
};

/*!
 * ov5640 I2C probe function
 *
 * @param adapter            struct i2c_adapter *
 * @return  Error code indicating success or failure
 */
static int ov5640_probe(struct i2c_client *client,
			const struct i2c_device_id *id)
{
	struct device *dev = &client->dev;
	int retval;
	u8 chip_id_high, chip_id_low;

	/* request power down pin */
	pwn_gpio = of_get_named_gpio(dev->of_node, "pwn-gpios", 0);
	if (!gpio_is_valid(pwn_gpio)) {
		dev_warn(dev, "no sensor pwdn pin available");
		return -EINVAL;
	}
	retval = devm_gpio_request_one(dev, pwn_gpio, GPIOF_OUT_INIT_HIGH,
					"ov5640_mipi_pwdn");
	if (retval < 0)
		return retval;

	/* request reset pin */
	rst_gpio = of_get_named_gpio(dev->of_node, "rst-gpios", 0);
	if (!gpio_is_valid(rst_gpio)) {
		dev_warn(dev, "no sensor reset pin available");
		return -EINVAL;
	}
	retval = devm_gpio_request_one(dev, rst_gpio, GPIOF_OUT_INIT_HIGH,
					"ov5640_mipi_reset");
	if (retval < 0)
		return retval;

	/* Set initial values for the sensor struct. */
	memset(&ov5640_data, 0, sizeof(ov5640_data));
	ov5640_data.sensor_clk = devm_clk_get(dev, "csi_mclk");
	if (IS_ERR(ov5640_data.sensor_clk)) {
		/* assuming clock enabled by default */
		ov5640_data.sensor_clk = NULL;
		dev_err(dev, "clock-frequency missing or invalid\n");
		return PTR_ERR(ov5640_data.sensor_clk);
	}

	retval = of_property_read_u32(dev->of_node, "mclk",
					&(ov5640_data.mclk));
	if (retval) {
		dev_err(dev, "mclk missing or invalid\n");
		return retval;
	}

	retval = of_property_read_u32(dev->of_node, "mclk_source",
					(u32 *) &(ov5640_data.mclk_source));
	if (retval) {
		dev_err(dev, "mclk_source missing or invalid\n");
		return retval;
	}

	retval = of_property_read_u32(dev->of_node, "csi_id",
					&(ov5640_data.csi));
	if (retval) {
		dev_err(dev, "csi id missing or invalid\n");
		return retval;
	}

	clk_prepare_enable(ov5640_data.sensor_clk);

	ov5640_data.io_init = ov5640_reset;
	ov5640_data.i2c_client = client;
	ov5640_data.pix.pixelformat = V4L2_PIX_FMT_UYVY;
	ov5640_data.pix.width = 640;
	ov5640_data.pix.height = 480;
	ov5640_data.streamcap.capability = V4L2_MODE_HIGHQUALITY |
					   V4L2_CAP_TIMEPERFRAME;
	ov5640_data.streamcap.capturemode = 0;
	ov5640_data.streamcap.timeperframe.denominator = DEFAULT_FPS;
	ov5640_data.streamcap.timeperframe.numerator = 1;

	ov5640_power_on(dev);

	ov5640_reset();

	ov5640_standby(0);

	retval = ov5640_read_reg(OV5640_CHIP_ID_HIGH_BYTE, &chip_id_high);
	if (retval < 0 || chip_id_high != 0x56) {
		pr_warning("camera ov5640_mipi is not found\n");
		ov5640_power_off();
		clk_disable_unprepare(ov5640_data.sensor_clk);
		return -ENODEV;
	}
	retval = ov5640_read_reg(OV5640_CHIP_ID_LOW_BYTE, &chip_id_low);
	if (retval < 0 || chip_id_low != 0x40) {
		pr_warning("camera ov5640_mipi is not found\n");
		ov5640_power_off();
		clk_disable_unprepare(ov5640_data.sensor_clk);
		return -ENODEV;
	}

	retval = ov5640_af_init();
	if (retval < 0)
		pr_err("%s: error downloading autofocus firmware\n", __func__);

	ov5640_standby(1);

	ov5640_int_device.priv = &ov5640_data;
	retval = v4l2_int_device_register(&ov5640_int_device);

	clk_disable_unprepare(ov5640_data.sensor_clk);

	pr_info("camera ov5640_mipi is found\n");
	return retval;
}

/*!
 * ov5640 I2C detach function
 *
 * @param client            struct i2c_client *
 * @return  Error code indicating success or failure
 */
static int ov5640_remove(struct i2c_client *client)
{
	v4l2_int_device_unregister(&ov5640_int_device);

	ov5640_power_off();

	return 0;
}

/*!
 * ov5640 init function
 * Called by insmod ov5640_camera.ko.
 *
 * @return  Error code indicating success or failure
 */
static __init int ov5640_init(void)
{
	u8 err;

	err = i2c_add_driver(&ov5640_i2c_driver);
	if (err != 0)
		pr_err("%s:driver registration failed, error=%d\n",
			__func__, err);

	return err;
}

/*!
 * OV5640 cleanup function
 * Called on rmmod ov5640_camera.ko
 *
 * @return  Error code indicating success or failure
 */
static void __exit ov5640_clean(void)
{
	i2c_del_driver(&ov5640_i2c_driver);
}

module_init(ov5640_init);
module_exit(ov5640_clean);

MODULE_AUTHOR("Freescale Semiconductor, Inc.");
MODULE_DESCRIPTION("OV5640 MIPI Camera Driver");
MODULE_LICENSE("GPL");
MODULE_VERSION("1.0");
MODULE_ALIAS("CSI");
